/*
 *  작업 내용
 *    -. USER_IDENTITY_VERIFICATION         : 누락 칼럼 (user_id) 추가
 */

CREATE DATABASE IF NOT EXISTS `keycloak`;
set foreign_key_checks = 0;
USE `keycloak`;

-- keycloak.USER_MFA definition
CREATE OR REPLACE TABLE keycloak.USER_MFA (
	`id` 						varchar(255) 	DEFAULT UUID()			COMMENT '고유 식별 ID',
	`user_id` 					varchar(255) 							COMMENT '사용자 ID',
	`credential_code` 			varchar(255) 							COMMENT '해싱코드',
	`expire_date` 				timestamp 		NOT NULL DEFAULT NOW()	COMMENT '만료시간',
	`repeat_count` 				int 			DEFAULT 0 				COMMENT '로그인 실패 횟수',
	`created_timestamp` 		timestamp 		DEFAULT NOW()			COMMENT '생성시간',
	PRIMARY KEY(id)
) COMMENT 'MFA 인증 정보';

-- TODO: user_id ??
-- keycloak.USER_IDENTITY_VERIFICATION definition
CREATE OR REPLACE TABLE keycloak.USER_IDENTITY_VERIFICATION (
    `id`               			varchar(255)	DEFAULT UUID() 			COMMENT '고유 식별 ID',
    `credential_code`  			varchar(255)							COMMENT '해싱코드',
    `expire_date`      			timestamp 		NOT NULL DEFAULT NOW()	COMMENT '만료시간',
    `repeat_count`     			int          	DEFAULT 0 				COMMENT '로그인 실패 횟수',
    `auth_type`        			varchar(255) 							COMMENT '인증 타입 구분(sgu: 회원가입, idf: 아이디 찾기, pwf: 비밀번호 찾기, unl: 계정 잠금 해제, mfa-auth: MFA 인증코드 발송)',
    `channel_type`        		varchar(255) 							COMMENT '인증 채널 코드(sms, email)',
    `user_id`           		varchar(255)							COMMENT '등록자ID',
    `channel_type_value`  		varchar(255) 							COMMENT '인증 채널 명(전화번호 인증, 이메일 인증)',
    `updated_timestamp` 		timestamp 								COMMENT '수정시간',
    `created_timestamp` 		timestamp 		DEFAULT NOW()			COMMENT '생성시간',
    PRIMARY KEY (id)
) COMMENT 'IDENTITY 검증 테이블';

-- keycloak.USER_TEMPORARY_AUTH_COOKIE definition
CREATE OR REPLACE TABLE keycloak.USER_TEMPORARY_AUTH_COOKIE (
    `id`                 		varchar(255) 	DEFAULT UUID()			COMMENT '고유 식별 ID',
    `value`              		varchar(255)							COMMENT '쿠키 세션 ID',
    `expire_date`        		timestamp		NOT NULL DEFAULT NOW()	COMMENT '만료시간',
    `auth_type`          		varchar(255)							COMMENT '인증 타입 구분',
    `created_timestamp` 		timestamp    	DEFAULT NOW()			COMMENT '생성시간',
    PRIMARY KEY (id)
) COMMENT '임시 로그인 쿠키';

-- keycloak.USER_LOGIN_FAILURE definition
CREATE OR REPLACE TABLE keycloak.USER_LOGIN_FAILURE (
  `REALM_NAME` 					varchar(255) 	NOT NULL				COMMENT '렐름 명',
  `USER_NAME` 					varchar(255) 	NOT NULL				COMMENT '유저 명',
  `LOGIN_ATTEMPTS` 				int(11) 		NOT NULL 				COMMENT '로그인 실패 횟수',
  `LAST_LOGIN_ATTEMPT_TIME` 	timestamp 		NOT NULL DEFAULT NOW() ON UPDATE NOW() COMMENT '마지막 시도 시간',
  PRIMARY KEY (`REALM_NAME`, `USER_NAME`)
) COMMENT '로그인 실패 정보' ;

ALTER TABLE keycloak.USER_ENTITY MODIFY enabled bit(1);