/*
 *  작업 내용
 *    -. MSTR_API_STATISTICS                : cloud_service pod 통합에 따른 데이터베이스 변경
 *    -. MSTR_API_STATISTICS                : api_path, params 길이 변경
 *    -. MSTR_RELEASE_NOTE                  : 전체 칼럼 변경
 */

CREATE DATABASE IF NOT EXISTS `maestro`;
set foreign_key_checks = 0;
USE `maestro`;

-- cloud_service.MSTR_API_STATISTICS definition
-- 기존 cloud_service -> maestro 이관
CREATE OR REPLACE TABLE maestro.MSTR_API_STATISTICS (
	`id` 				int(11) 		NOT NULL AUTO_INCREMENT COMMENT '고유 ID',
	`provider_type` 	int(11) 		DEFAULT NULL 			COMMENT '',
	`endpoint_id` 		varchar(36) 	DEFAULT NULL 			COMMENT '엔드포인트 ID',
	`api_path` 			varchar(2000) 	DEFAULT NULL 			COMMENT 'API 경로',
	`http_status` 		int(11) 		DEFAULT NULL 			COMMENT '상태 코드',
	`http_method` 		varchar(8) 		DEFAULT NULL 			COMMENT '요청 메소드',
	`user_id` 			varchar(36) 	DEFAULT NULL 			COMMENT '사용자 ID',
	`workspace_id` 		varchar(36) 	DEFAULT NULL 			COMMENT '워크스페이스 ID',
	`time` 				timestamp 		NULL DEFAULT NULL 		COMMENT '요청시간',
	`is_admin` 			int(11) 		DEFAULT NULL 			COMMENT '관리자 여부',
	`type_name` 		varchar(255) 	DEFAULT NULL 			COMMENT '타입 구분',
	`ip` 				varchar(255) 	DEFAULT NULL 			COMMENT '요청 IP',
	`content` 			varchar(255) 	DEFAULT NULL 			COMMENT '내용',
	`request_body` 		text 			DEFAULT NULL 			COMMENT '요청 본문',
	`response_body` 	text 			DEFAULT NULL 			COMMENT '응답 본문',
	`params` 			varchar(5000) 	DEFAULT NULL 			COMMENT '요청 매개변수',
  PRIMARY KEY (`id`)
) COMMENT 'API 로그 수집';

-- maestro.MSTR_ACCESS_CONTROL definition
CREATE OR REPLACE TABLE maestro.MSTR_ACCESS_CONTROL (
  `id` varchar(36) NOT NULL DEFAULT uuid() COMMENT '고유 ID',
  `ip_address` varchar(15) NOT NULL COMMENT 'IP Address',
  `cidr` tinyint(4) NOT NULL COMMENT 'CIDR - Prefix Length',
  `description` text DEFAULT NULL COMMENT '설명',
  `status` tinyint(4) NOT NULL DEFAULT 1 COMMENT '상태',
  `create_user_id` varchar(36) NULL COMMENT '생성자 ID',
  `create_time` timestamp NOT NULL DEFAULT current_timestamp() COMMENT '생성일시',
  `update_user_id` varchar(36) DEFAULT NULL COMMENT '수정자 ID',
  `update_time` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT '수정일시',
  PRIMARY KEY (`id`)
) comment='접근 제어';

-- maestro.MSTR_ASSIGNER_IN_WORKFLOW definition
CREATE OR REPLACE TABLE maestro.MSTR_ASSIGNER_IN_WORKFLOW (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 ID',
  `assign_user_id` varchar(36) DEFAULT NULL comment '할당 대상(유저 혹은 그룹)',
  `workflow_id` varchar(36) NOT NULL comment '워크스페이스 ID',
  `assign_type` int(11) DEFAULT 1 COMMENT '타입',
  `create_time` timestamp NULL DEFAULT current_timestamp() comment '생성시간'
) comment='워크플로우 할당자 목록';

-- maestro.MSTR_AUTHORITY definition
CREATE OR REPLACE TABLE maestro.MSTR_AUTHORITY (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 ID',
  `name` varchar(127) NOT NULL comment '권한명',
  `description` text DEFAULT NULL comment '설명',
  `selector` text DEFAULT NULL comment '식별자',
  `type` varchar(127) DEFAULT NULL comment '구분',
  `category` varchar(127) DEFAULT NULL comment '카테고리',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `status` int(11) DEFAULT 0 comment '상태',
  `solution` varchar(127) DEFAULT NULL comment '솔루션',
  `constant` tinyint(4) DEFAULT 0 comment '불변',
  PRIMARY KEY (`id`),
  KEY `MSTR_AUTHORITY_create_time_index` (`create_time`)
) comment='권한';

-- maestro.MSTR_AUTHORITY_TYPE definition
CREATE OR REPLACE TABLE maestro.MSTR_AUTHORITY_TYPE (
  `id` varchar(255) NOT NULL DEFAULT uuid() comment '고유 ID',
  `description` varchar(255) DEFAULT NULL comment '설명',
  `is_default` int(11) DEFAULT 0 comment '기본 설정 여부',
  `name` varchar(255) DEFAULT NULL comment '권한타입명',
  `selector` varchar(255) DEFAULT NULL comment '셀렉터',
  PRIMARY KEY (`id`)
) comment='권한 타입';

-- maestro.MSTR_BOARD definition
CREATE OR REPLACE TABLE maestro.MSTR_BOARD (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 ID',
  `name` varchar(500) DEFAULT NULL comment '일음',
  `data` text DEFAULT NULL comment '내용',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `status` int(11) DEFAULT 1 comment '상태',
  `sub_category_id` varchar(36) NOT NULL comment '서브 카테고리 ID',
  `pin` tinyint(1) DEFAULT 0 comment '고정여부',
  `pin_time` timestamp NULL DEFAULT NULL comment '고정시간',
  `first_posted_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) comment='게시글';

-- maestro.MSTR_BOARD_CATEGORY definition
CREATE OR REPLACE TABLE maestro.MSTR_BOARD_CATEGORY (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 ID',
  `name` varchar(500) DEFAULT NULL comment '이름',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `status` int(11) DEFAULT 1 comment '상태',
  PRIMARY KEY (`id`),
  UNIQUE KEY `MSTR_BOARD_CATEGORY_name_uindex` (`name`)
) comment='게시글 카테고리';

-- maestro.MSTR_BOARD_FILE definition
CREATE OR REPLACE TABLE maestro.MSTR_BOARD_FILE (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 ID',
  `name` varchar(500) DEFAULT NULL comment '파일명',
  `path` varchar(1000) DEFAULT NULL comment '파일경로',
  `status` int(11) DEFAULT 1 comment '상태',
  `board_id` varchar(36) NOT NULL DEFAULT uuid() comment '게시글 ID',
  PRIMARY KEY (`id`)
) comment='게시글 파일';

-- maestro.MSTR_BOARD_IN_MSTR_ORG definition
CREATE OR REPLACE TABLE maestro.MSTR_BOARD_IN_MSTR_ORG (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 ID',
  `org_id` varchar(36) NOT NULL DEFAULT uuid() comment '조직 ID',
  `board_id` varchar(36) NOT NULL DEFAULT uuid() comment '게시글 ID',
  PRIMARY KEY (`id`)
) comment='게시글 폴더 중간';

-- maestro.MSTR_BOARD_SUB_CATEGORY definition
CREATE OR REPLACE TABLE maestro.MSTR_BOARD_SUB_CATEGORY (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 ID',
  `name` varchar(500) DEFAULT NULL comment '이름',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `status` int(11) DEFAULT 1 comment '상태',
  `category_id` varchar(36) NOT NULL comment '상위 ID',
  PRIMARY KEY (`id`)
) comment='게시글 서브 카테고리';

-- maestro.MSTR_CATEGORY definition
CREATE OR REPLACE TABLE maestro.MSTR_CATEGORY (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 ID',
  `name` varchar(127) DEFAULT NULL comment '이름',
  `description` varchar(255) DEFAULT NULL comment '설명',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `status` int(11) DEFAULT 0 comment '상태',
  PRIMARY KEY (`id`)
) comment='카테고리';

-- maestro.MSTR_ENDPOINT definition
CREATE OR REPLACE TABLE maestro.MSTR_ENDPOINT (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 ID',
  `name` varchar(500) DEFAULT NULL comment 'API명',
  `description` varchar(2000) DEFAULT NULL comment '설명',
  `uri` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL comment 'URI',
  `solution_id` varchar(36) NOT NULL comment '솔루션 ID',
  `solution` varchar(127) DEFAULT NULL comment '솔루션',
  `service` varchar(127) DEFAULT NULL comment '서비스',
  `type` varchar(127) DEFAULT NULL comment '타입',
  `method` varchar(127) DEFAULT NULL comment '요청 메소드',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `status` int(11) DEFAULT 0 comment '상태',
  `solution_server_id` varchar(255) DEFAULT NULL comment '솔루션 서버 ID',
  `white_api` int(11) NOT NULL DEFAULT 0 comment '화이트 리스트 여부',
  PRIMARY KEY (`id`),
  UNIQUE KEY `MSTR_ENDPOINT_pk` (`uri`,`method`,`solution_server_id`),
  KEY `MSTR_ENDPOINT_create_time_index` (`create_time`)
) comment='엔드포인트';

-- maestro.MSTR_ENDPOINT_RESOURCE_TYPE definition
CREATE OR REPLACE TABLE maestro.MSTR_ENDPOINT_RESOURCE_TYPE (
  `name` varchar(127) NOT NULL comment '이름',
  `description` varchar(255) DEFAULT NULL comment '설명',
  `selector` varchar(255) DEFAULT NULL comment '식별자',
  PRIMARY KEY (`name`)
) comment='엔드포인트 리소스 타입';

-- maestro.MSTR_ENDPOINT_SERVICE definition
CREATE OR REPLACE TABLE maestro.MSTR_ENDPOINT_SERVICE (
  `name` varchar(127) NOT NULL comment '이름',
  `description` varchar(255) DEFAULT NULL comment '설명',
  `selector` varchar(255) DEFAULT NULL comment '식별자',
  PRIMARY KEY (`name`)
) comment='엔드포인트 서비스';

-- maestro.MSTR_ENDPOINT_SYNC_LOG definition
CREATE OR REPLACE TABLE maestro.MSTR_ENDPOINT_SYNC_LOG (
  `id` int(11) NOT NULL AUTO_INCREMENT comment '고유 ID',
  `sync_time` timestamp NULL DEFAULT NULL comment '동기화 시간',
  `solution` varchar(255) DEFAULT NULL comment '솔루션',
  `user_id` varchar(255) DEFAULT NULL comment '요청자',
  `endpoint_sync_log` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL comment '동기화 로그',
  `endpoint_event_sync_log` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL comment '이벤트 동기화 로그',
  PRIMARY KEY (`id`)
) comment='엔드포인트 동기화 로그';

-- maestro.MSTR_ENDPOINT_TYPE_IN_SERVICE definition
CREATE OR REPLACE TABLE maestro.MSTR_ENDPOINT_TYPE_IN_SERVICE (
  `service` varchar(127) NOT NULL comment '서비스',
  `type` varchar(127) NOT NULL comment '타입',
  PRIMARY KEY (`service`,`type`),
  KEY `FK_MSTR_ENDPOINT_RESOURC` (`type`)
) comment='엔트포인트 서비스 타입';

-- maestro.MSTR_FIELD_IN_SECTION definition
CREATE OR REPLACE TABLE maestro.MSTR_FIELD_IN_SECTION (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 ID',
  `name` varchar(127) DEFAULT NULL comment '이름',
  `description` varchar(255) DEFAULT NULL comment '설명',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `status` int(11) DEFAULT 0 comment '상태',
  `section_id` varchar(36) NOT NULL DEFAULT uuid() comment '섹션 ID',
  `order` int(11) DEFAULT NULL comment '정렬 순서',
  `type_of_field_id` varchar(36) NOT NULL DEFAULT uuid() comment '필드 종류 ID'
) comment='섹션별 필드';

-- maestro.MSTR_FINOPS_OPENSTACK_MONTH_COST definition
CREATE OR REPLACE TABLE maestro.MSTR_FINOPS_OPENSTACK_MONTH_COST (
  `id` bigint(20) NOT NULL AUTO_INCREMENT comment '고유 ID',
  `provider_id` varchar(36) DEFAULT NULL COMMENT '공급자 ID',
  `service_type` varchar(36) DEFAULT NULL COMMENT '서비스 유형(VOLUME, NETWORK, INSTANCE)',
  `instance_no` varchar(100) DEFAULT NULL COMMENT '인스턴스 번호',
  `instance_name` varchar(100) DEFAULT NULL COMMENT '인스턴스 이름',
  `description` varchar(100) DEFAULT NULL COMMENT '설명',
  `use_date` varchar(8) DEFAULT NULL COMMENT '사용일시(YYYYMM)',
  `cost` bigint(20) DEFAULT NULL COMMENT '비용',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '생성일시',
  `cost_type` varchar(10) DEFAULT NULL COMMENT '비용 유형(USAGE[사용량], ALLOCATION[할당량])',
  PRIMARY KEY (`id`),
  KEY `idx_id` (`id`),
  KEY `idx_instance_no` (`instance_no`),
  KEY `idx_use_date` (`use_date`)
) ;

-- maestro.MSTR_FOLDER definition
CREATE OR REPLACE TABLE maestro.MSTR_FOLDER (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 ID',
  `name` varchar(127) NOT NULL comment '이름',
  `description` text DEFAULT NULL comment '설명',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `parent_id` varchar(36) DEFAULT NULL comment '상위 폴더 ID',
  `org_id` varchar(36) DEFAULT NULL comment '조직 ID',
  `depth` int(11) NOT NULL comment '깊이',
  `status` int(11) NOT NULL DEFAULT 0 comment '상태',
  PRIMARY KEY (`id`),
  KEY `MSTR_FOLDER_create_time_index` (`create_time`)
) comment='폴더';

-- maestro.MSTR_FOLDER_IN_SERVICE_CATALOG definition
CREATE OR REPLACE TABLE maestro.MSTR_FOLDER_IN_SERVICE_CATALOG (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 ID',
  `folder_id` varchar(36) NOT NULL comment '조직 ID',
  `service_catalog_id` varchar(36) NOT NULL comment '서비스 카탈로그 ID',
  `create_time` timestamp NULL DEFAULT current_timestamp() comment '생성시간'
) comment='폴더 IN 서비스 카탈로그';

-- maestro.MSTR_GLOBAL_MENU_AUTHORITY definition
CREATE OR REPLACE TABLE maestro.MSTR_GLOBAL_MENU_AUTHORITY (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 ID',
  `global_menu_id` varchar(36) NOT NULL DEFAULT uuid() comment '전역 메뉴 ID',
  `authority_id` varchar(36) NOT NULL DEFAULT uuid() comment '권한 ID',
  PRIMARY KEY (`id`)
) comment='전역 메뉴 권한';

-- maestro.MSTR_GLOBAL_OPTION definition
CREATE OR REPLACE TABLE maestro.MSTR_GLOBAL_OPTION (
  `id` varchar(255) NOT NULL DEFAULT uuid() comment '고유 ID',
  `name` varchar(255) NOT NULL comment '설정 명',
  `value` varchar(255) NOT NULL comment '설정 값',
  `use_yn` char(1) NOT NULL DEFAULT 'Y' comment '샤용 여부',
  PRIMARY KEY (`id`)
) comment='전역 설정';

-- maestro.MSTR_LOG_TAG definition
CREATE OR REPLACE TABLE maestro.MSTR_LOG_TAG (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 ID',
  `description` varchar(2000) DEFAULT NULL comment '설명',
  `name` varchar(500) DEFAULT NULL comment '태그 명',
  PRIMARY KEY (`id`)
) comment='로그 태그';

-- maestro.MSTR_LOG_TAG_API_DATA definition
CREATE OR REPLACE TABLE maestro.MSTR_LOG_TAG_API_DATA (
  `id` varchar(255) NOT NULL DEFAULT uuid() comment '고유 ID',
  `solution` varchar(255) DEFAULT NULL comment '솔루션',
  `log_tag_name` varchar(255) DEFAULT NULL comment '태그명',
  `method` varchar(255) DEFAULT NULL comment '요청 메소드',
  `server_name` varchar(255) DEFAULT NULL comment '서버명',
  `path` varchar(255) DEFAULT NULL comment 'URI',
  `description` varchar(255) DEFAULT NULL comment '설명',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  PRIMARY KEY (`id`)
) COMMENT='로그태그 최초 세팅용 데이터. 환경별로 api id가 다를 수 있기 때문에 사용한다.';

-- maestro.MSTR_MENU_FEATURE_TYPE definition
CREATE OR REPLACE TABLE maestro.MSTR_MENU_FEATURE_TYPE (
  `name` varchar(500) NOT NULL comment '이름',
  `description` varchar(2000) DEFAULT NULL comment '설명',
  PRIMARY KEY (`name`)
) comment='메뉴 활성화 타입';

-- maestro.MSTR_MENU_PLATFORM definition
CREATE OR REPLACE TABLE maestro.MSTR_MENU_PLATFORM (
  `menu_id` varchar(255) NOT NULL comment '메뉴 ID',
  `platform_id` varchar(255) NOT NULL comment '플랫폼 ID',
  PRIMARY KEY (`menu_id`,`platform_id`)
) comment='메뉴 플랫폼';

-- maestro.MSTR_NOTIFICATION definition
CREATE OR REPLACE TABLE maestro.MSTR_NOTIFICATION (
  `id` varchar(255) NOT NULL DEFAULT uuid() comment '알림 ID',
  `name` varchar(255) DEFAULT NULL comment '알림명',
  `description` varchar(255) DEFAULT NULL comment '설명',
  `channel` varchar(255) DEFAULT NULL comment '채널여부',
  `repeat_type` varchar(255) DEFAULT NULL comment '반복 타입',
  `repeat_frequency` varchar(255) DEFAULT NULL comment '반복 횟수',
  `repeat_period` varchar(255) DEFAULT NULL comment '반복 주기',
  `create_date` timestamp NULL DEFAULT current_timestamp() comment '생성일시',
  `update_date` timestamp NULL DEFAULT NULL comment '수정일시',
  `create_user` varchar(255) DEFAULT NULL comment '생성자',
  `update_user` varchar(255) DEFAULT NULL comment '수정자',
  `use_yn` varchar(255) DEFAULT 'Y' comment '사용 여부',
  `type` varchar(255) DEFAULT NULL comment '타입',
  PRIMARY KEY (`id`)
) comment='알림';

-- maestro.MSTR_NOTIFICATION_COMMON_CODE_TYPE definition
CREATE OR REPLACE TABLE maestro.MSTR_NOTIFICATION_COMMON_CODE_TYPE (
  `code_type_id` varchar(255) NOT NULL comment '코드 타입 ID',
  `code_type_name` varchar(255) DEFAULT NULL comment '코드 타입 명',
  `create_date` timestamp NULL DEFAULT current_timestamp() comment '생성일시',
  `update_date` timestamp NULL DEFAULT NULL comment '수정일시',
  `create_user` varchar(255) DEFAULT NULL comment '생성자',
  `update_user` varchar(255) DEFAULT NULL comment '수정자',
  `use_yn` varchar(255) DEFAULT 'Y' comment '사용 여부',
  PRIMARY KEY (`code_type_id`)
) comment='알림 공통 코드 타입';

-- maestro.MSTR_NOTIFICATION_DATA definition
CREATE OR REPLACE TABLE maestro.MSTR_NOTIFICATION_DATA (
  `id` varchar(255) NOT NULL DEFAULT uuid() comment '알림정보 ID',
  `event_history_id` varchar(255) DEFAULT NULL comment '이벤트 기록 ID',
  `action_yn` varchar(255) DEFAULT NULL comment '조치 여부',
  `message` varchar(255) DEFAULT NULL comment '메시지',
  `detail_url` varchar(255) DEFAULT NULL comment '상세보기 URL',
  `create_date` timestamp NULL DEFAULT current_timestamp() comment '생성시간',
  `update_date` timestamp NULL DEFAULT NULL comment '수정시간',
  `create_user` varchar(255) DEFAULT NULL comment '생서자',
  `update_user` varchar(255) DEFAULT NULL comment '수정자',
  `use_yn` varchar(255) DEFAULT 'Y' comment '사용 여부',
  `level` varchar(255) DEFAULT NULL comment '레벨',
  `user_detail_url` varchar(255) DEFAULT NULL comment '사용자 상세 주소',
  `admin_detail_url` varchar(255) DEFAULT NULL comment '관리자 상세 주소',
  PRIMARY KEY (`id`)
) comment='발생한 알림';

-- maestro.MSTR_NOTIFICATION_DOMAIN_OPTION definition
CREATE OR REPLACE TABLE maestro.MSTR_NOTIFICATION_DOMAIN_OPTION (
  `id` varchar(255) NOT NULL DEFAULT uuid() comment '알림 도메인 식별 ID',
  `name` varchar(255) DEFAULT NULL comment '알림 도메인 명',
  `base_path` varchar(255) DEFAULT NULL comment 'URL',
  `create_date` timestamp NULL DEFAULT current_timestamp() comment '생성시간',
  `update_date` timestamp NULL DEFAULT NULL comment '수정시간',
  `create_user` varchar(255) DEFAULT NULL comment '생성자',
  `update_user` varchar(255) DEFAULT NULL comment '수정자',
  `use_yn` varchar(255) DEFAULT 'Y' comment '사용 여부',
  PRIMARY KEY (`id`)
) comment='알림 도메인 옵션';

-- maestro.MSTR_NOTIFICATION_EVENT_CODE definition
CREATE OR REPLACE TABLE maestro.MSTR_NOTIFICATION_EVENT_CODE (
  `id` varchar(255) NOT NULL DEFAULT uuid() comment '알림이벤트 코드 식별 ID',
  `event_code` varchar(255) DEFAULT NULL comment '이벤트 코드',
  `message_form` varchar(255) DEFAULT NULL comment '메시지 형식',
  `name` varchar(255) DEFAULT NULL comment '이벤트 명',
  `event_condition` varchar(255) DEFAULT NULL comment '이벤트 조건',
  `repeat_yn` varchar(255) DEFAULT NULL comment '반복 여부',
  `level` varchar(255) DEFAULT NULL comment '레벨',
  `attribute` varchar(255) DEFAULT NULL comment '속셩',
  `target` varchar(255) DEFAULT NULL comment '대상',
  `create_date` timestamp NULL DEFAULT current_timestamp() comment '생성일시',
  `update_date` timestamp NULL DEFAULT NULL comment '수정일시',
  `create_user` varchar(255) DEFAULT NULL comment '생성자',
  `update_user` varchar(255) DEFAULT NULL comment '수정자',
  `use_yn` varchar(255) DEFAULT 'Y',
  PRIMARY KEY (`id`)
) comment='알림 이벤트 코드';

-- maestro.MSTR_NOTIFICATION_EVENT_HISTORY definition
CREATE OR REPLACE TABLE maestro.MSTR_NOTIFICATION_EVENT_HISTORY (
  `id` varchar(255) NOT NULL DEFAULT uuid() comment '이벤트 기록 식별 ID',
  `event_id` varchar(255) DEFAULT NULL comment '이벤트 식별 ID',
  `create_date` timestamp NULL DEFAULT current_timestamp() comment '생성일시',
  `update_date` timestamp NULL DEFAULT NULL comment '수정일시',
  `create_user` varchar(255) DEFAULT NULL comment '생성자',
  `update_user` varchar(255) DEFAULT NULL comment '수정자',
  `use_yn` varchar(255) DEFAULT 'Y' comment '사용 여부',
  PRIMARY KEY (`id`)
) comment='발생한 이벤트';

-- maestro.MSTR_NOTIFICATION_PERSONAL_RECEIVE definition
CREATE OR REPLACE TABLE maestro.MSTR_NOTIFICATION_PERSONAL_RECEIVE (
  `id` varchar(100) NOT NULL DEFAULT uuid() comment '사용자별 받은 정보 식별 ID',
  `notification_data_id` varchar(100) DEFAULT NULL comment '일림정보 식별 ID',
  `read_yn` varchar(255) DEFAULT 'N' comment '조치 여부',
  `user_id` varchar(100) DEFAULT NULL comment '사용자 여부',
  `channel` varchar(100) DEFAULT NULL comment '채널',
  `create_date` timestamp NULL DEFAULT current_timestamp() comment '생성일시',
  `update_date` timestamp NULL DEFAULT current_timestamp() comment '수정일시',
  `create_user` varchar(255) DEFAULT NULL comment '생성자',
  `update_user` varchar(255) DEFAULT NULL comment '수정자',
  `use_yn` varchar(100) DEFAULT 'Y' comment '사용 여부',
  PRIMARY KEY (`id`),
  KEY `IDX_ID_USER_ID_READ_YN_CHANNEL_NOTIFICATION_DATA_ID` (`id`,`notification_data_id`,`user_id`,`read_yn`,`channel`)
) comment='사용자별 받은 알림';

-- maestro.MSTR_NOTIFICATION_RECEIVE_GROUP definition
CREATE OR REPLACE TABLE maestro.MSTR_NOTIFICATION_RECEIVE_GROUP (
  `id` varchar(255) NOT NULL DEFAULT uuid() comment '수신자 그룹 식별 ID',
  `name` varchar(255) DEFAULT NULL comment '그룹명',
  `description` varchar(255) DEFAULT NULL comment '설명',
  `type` varchar(255) DEFAULT NULL comment '구분',
  `create_date` timestamp NULL DEFAULT current_timestamp() comment '생성일',
  `update_date` timestamp NULL DEFAULT NULL comment '수정일',
  `create_user` varchar(255) DEFAULT NULL comment '생성자',
  `update_user` varchar(255) DEFAULT NULL comment '수정자',
  `use_yn` varchar(255) DEFAULT 'Y' comment '사용 여부',
  PRIMARY KEY (`id`)
) comment='수신자 그룹';

-- maestro.MSTR_NOTIFICATION_RECEIVE_EVENT definition
CREATE OR REPLACE TABLE maestro.MSTR_NOTIFICATION_RECEIVE_EVENT(
   `user_id` varchar(255),
   `event_id` varchar(255),
   PRIMARY KEY(user_id, event_id)
);

-- maestro.MSTR_NOTIFICATION_RECEIVE_INFO definition
CREATE OR REPLACE TABLE maestro.MSTR_NOTIFICATION_RECEIVE_INFO (
  `id` varchar(255) NOT NULL DEFAULT uuid() comment '수신원의 식별 ID',
  `user_id` varchar(255) DEFAULT NULL comment '사용자 ID',
  `channel` varchar(255) DEFAULT NULL comment '수신 채널',
  `receive_day` varchar(255) DEFAULT NULL comment '요일',
  `start_time` int(11) DEFAULT NULL comment '수신 시작 시간',
  `end_time` int(11) DEFAULT NULL comment '수신 ㅈ오료 시간',
  `create_date` timestamp NULL DEFAULT current_timestamp() comment '생성일시',
  `update_date` timestamp NULL DEFAULT NULL comment '수정일시',
  `create_user` varchar(255) DEFAULT NULL comment '생성자',
  `update_user` varchar(255) DEFAULT NULL comment '수정자',
  `use_yn` varchar(255) DEFAULT 'Y' comment '사용 여부',
  PRIMARY KEY (`id`)
) comment='사용자 채널 및 수신 요일';

-- maestro.MSTR_ORG_IN_SERVICE_OBJECT definition
CREATE OR REPLACE TABLE maestro.MSTR_ORG_IN_SERVICE_OBJECT (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 ID',
  `org_id` varchar(36) DEFAULT NULL comment '조직 ID',
  `service_object_id` varchar(36) DEFAULT NULL comment '서비스 오브젝트 ID',
  `create_time` timestamp NULL DEFAULT current_timestamp() comment '생성시간',
  PRIMARY KEY (`id`)
) comment='조직별 서비스 오브젝트';

-- maestro.MSTR_ORG_IN_SERVICE_TYPE definition
CREATE OR REPLACE TABLE maestro.MSTR_ORG_IN_SERVICE_TYPE (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 ID',
  `org_id` varchar(36) DEFAULT NULL comment '조직 ID',
  `service_type_id` varchar(36) DEFAULT NULL comment '서비스 타입 ID',
  `create_time` timestamp NULL DEFAULT current_timestamp() comment '생성시간',
  PRIMARY KEY (`id`)
) comment='조직별 서비스 타입';

-- maestro.MSTR_OTHER_BILLING_POLICY_LOG definition
CREATE OR REPLACE TABLE maestro.MSTR_OTHER_BILLING_POLICY_LOG (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '기타과금 정책 로그 ID',
  `other_billing_policy_id` varchar(36) NOT NULL DEFAULT uuid() comment '기타 과금 정책 ID',
  `other_billing_folder_id` varchar(36) NOT NULL comment '기타 과금 폴더 ID',
  `create_user_id` varchar(100) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT current_timestamp() comment '생성시간',
  `update_contents` varchar(100) DEFAULT NULL comment '업데이트 구분',
  `before_modification` varchar(500) DEFAULT NULL comment '변경전 내용',
  `after_modification` varchar(500) DEFAULT NULL comment '변경후 내용',
  PRIMARY KEY (`id`)
) comment='기타과금 정책';

-- maestro.MSTR_PROVIDER_NAVIGATOR definition
CREATE OR REPLACE TABLE maestro.MSTR_PROVIDER_NAVIGATOR (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 ID',
  `user_id` varchar(36) NOT NULL COMMENT '사용자 ID',
  `global_menu_id` varchar(36) NOT NULL COMMENT 'MSTR_PLATFORM 에 있는 id 일치',
  `provider_id` varchar(255) DEFAULT NULL COMMENT 'MSTR_PROVIDER 에 있는 id와 일치',
  `provider_sub` varchar(255) DEFAULT NULL COMMENT '각 플랫폼/솔루션 별로 상이함',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`,`global_menu_id`)
) COMMENT='공급자 네비게이터';

-- maestro.MSTR_PROVIDER_NAVIGATOR_BOOKMARK definition
CREATE OR REPLACE TABLE maestro.MSTR_PROVIDER_NAVIGATOR_BOOKMARK (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 ID',
  `user_id` varchar(36) NOT NULL COMMENT '사용자 ID',
  `global_menu_id` varchar(36) NOT NULL COMMENT 'MSTR_PLATFORM 에 있는 id 일치',
  `provider_id` varchar(255) DEFAULT NULL COMMENT 'MSTR_PROVIDER 에 있는 id와 일치',
  `provider_sub` varchar(255) DEFAULT NULL COMMENT '각 플랫폼/솔루션 별로 상이함',
  PRIMARY KEY (`id`),
  UNIQUE KEY `bookmark_uk` (`user_id`,`provider_id`,`provider_sub`)
) COMMENT='공급자 네비게이터 북마크';

-- maestro.MSTR_PROVIDER_TYPE definition
CREATE OR REPLACE TABLE maestro.MSTR_PROVIDER_TYPE (
  `id` int(11) NOT NULL comment '고유 ID',
  `name` varchar(127) DEFAULT NULL comment '이름',
  `public` int(11) DEFAULT 1 comment 'public 여부',
  `description` varchar(127) DEFAULT NULL comment '설명',
  `is_active` int(11) NOT NULL DEFAULT 1 comment '활성화 여부',
  PRIMARY KEY (`id`)
) comment='공급자 타입';

-- maestro.MSTR_REQUEST_BOARD definition
CREATE OR REPLACE TABLE maestro.MSTR_REQUEST_BOARD (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 ID',
  `name` varchar(500) DEFAULT NULL comment '제목',
  `request_data` text DEFAULT NULL comment '문의 내용',
  `response_data` text DEFAULT NULL comment '답변',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `complete_time` timestamp NULL DEFAULT NULL comment '답변시간',
  `status` int(11) DEFAULT 1 comment '상태',
  `category` int(11) DEFAULT 1 comment '카테고리 코드',
  `category_id` varchar(36) DEFAULT NULL comment '카테고리 식별 ID',
  PRIMARY KEY (`id`)
) comment='문의 게시글';

-- maestro.MSTR_REQUEST_BOARD_CATEGORY definition
CREATE OR REPLACE TABLE maestro.MSTR_REQUEST_BOARD_CATEGORY (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '문의 카테고리 식별 ID',
  `name` varchar(30) DEFAULT NULL comment '이름',
  `code` varchar(10) DEFAULT NULL comment '코드',
  `create_user_id` varchar(36) DEFAULT 'admin' comment '생성자',
  `create_time` timestamp NULL DEFAULT current_timestamp() comment '생성시간',
  `is_active` tinyint(1) DEFAULT 1 comment '활성화 여부',
  `portal` varchar(10) DEFAULT NULL comment '사용 포탈',
  PRIMARY KEY (`id`)
) comment='문의 게시글 카테고리 관리 테이블';

-- maestro.MSTR_REQUEST_BOARD_FILE definition
CREATE OR REPLACE TABLE maestro.MSTR_REQUEST_BOARD_FILE (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '파일 식별 ID',
  `name` varchar(500) DEFAULT NULL comment '논리 파일명',
  `path` varchar(1000) DEFAULT NULL comment '파일경로',
  `status` int(11) DEFAULT 1 comment '상태',
  `board_id` varchar(36) NOT NULL DEFAULT uuid() comment '게시글 식별 ID',
  `type` int(11) DEFAULT 1 comment '타입',
  PRIMARY KEY (`id`)
) comment='문의 게시글 첨부파일 관리 테이블';

-- maestro.MSTR_REQUEST_OF_SERVICE definition
CREATE OR REPLACE TABLE maestro.MSTR_REQUEST_OF_SERVICE (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '요청 식별 ID',
  `name` varchar(127) DEFAULT NULL comment '제목',
  `description` varchar(255) DEFAULT NULL comment '설명',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `status` int(11) DEFAULT 0 comment '상태',
  `assign_user_id` varchar(36) DEFAULT NULL comment '담당자',
  `expect_complete_time` timestamp NULL DEFAULT NULL comment '완료희망일시',
  `content` text DEFAULT NULL comment '요청내용',
  `template_request_of_service_id` varchar(36) NOT NULL comment '승인 식별 ID'
) comment='서비스 요청 관리 테이블';

-- maestro.MSTR_REQUEST_OF_SERVICE_CATEGORY definition
CREATE OR REPLACE TABLE maestro.MSTR_REQUEST_OF_SERVICE_CATEGORY (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '요청 식별 ID',
  `name` varchar(127) NOT NULL comment '제목',
  `description` text DEFAULT NULL comment '설명',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `status` int(11) DEFAULT 0 comment '상태',
  `type` varchar(20) DEFAULT NULL comment '타입',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) comment='서비스 카탈로그 요청 관리 테이블';

-- maestro.MSTR_REQUEST_OF_SERVICE_TYPE_BOOKMARK definition
CREATE OR REPLACE TABLE maestro.MSTR_REQUEST_OF_SERVICE_TYPE_BOOKMARK (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '북마크 식별 ID',
  `user_id` varchar(36) NOT NULL COMMENT '사용자 아이디',
  `service_type_id` varchar(36) NOT NULL COMMENT 'MSTR_REQUEST_OF_SERVICE_TYPE 에 있는 id 일치',
  `description` text DEFAULT NULL comment '설명',
  `create_time` timestamp NULL DEFAULT current_timestamp() comment '생성일시',
  PRIMARY KEY (`id`)
) COMMENT='서비스 신청 타입 즐겨찾기 관리';

-- maestro.MSTR_REQUEST_OF_SERVICE_TYPE_IN_FOLDER definition
CREATE OR REPLACE TABLE maestro.MSTR_REQUEST_OF_SERVICE_TYPE_IN_FOLDER (
  `id` int(10) NOT NULL AUTO_INCREMENT comment '순번',
  `uuid` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `service_type_id` varchar(36) DEFAULT NULL comment '서비스 타입 ID',
  `folder_id` varchar(36) DEFAULT NULL comment '폴더 식별 ID',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT current_timestamp() comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT current_timestamp() comment '수정시간',
  PRIMARY KEY (`id`)
) comment='폴더별 서비스 타입 요청 관리 테이블';

-- maestro.MSTR_RESOURCE_TYPE definition
CREATE OR REPLACE TABLE maestro.MSTR_RESOURCE_TYPE (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '리소스 타입 식별 ID',
  `name` varchar(31) NOT NULL comment '이름'
) comment='리소스 구분 관리 테이블';

-- maestro.MSTR_ROLE_TYPE definition
CREATE OR REPLACE TABLE maestro.MSTR_ROLE_TYPE (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '역할 식별 ID',
  `description` varchar(255) DEFAULT NULL comment '설명',
  `name` varchar(255) NOT NULL comment '이름',
  `selector` varchar(255) DEFAULT NULL comment '사용 포탈',
  PRIMARY KEY (`id`)
) comment='역할 구분 관리 테이블';

-- maestro.MSTR_SECTION_IN_TEMPLATE_REQUEST_OF_SERVICE definition
CREATE OR REPLACE TABLE maestro.MSTR_SECTION_IN_TEMPLATE_REQUEST_OF_SERVICE (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `name` varchar(127) DEFAULT NULL comment '이름',
  `description` varchar(255) DEFAULT NULL comment '설명',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `status` int(11) DEFAULT 0 comment '상태',
  `template_request_of_service_id` varchar(36) NOT NULL comment '승인 식별 ID'
) comment='섹션별 서비스 요청 승인 관리 테이블';

-- maestro.MSTR_SELECT_FIELD definition
CREATE OR REPLACE TABLE maestro.MSTR_SELECT_FIELD (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `name` varchar(127) DEFAULT NULL comment '이름',
  `description` varchar(255) DEFAULT NULL comment '설명',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `status` int(11) DEFAULT 0 comment '상태'
) comment='셀렉트 필드 테이블';

-- maestro.MSTR_SERVICE_CATALOG definition
CREATE OR REPLACE TABLE maestro.MSTR_SERVICE_CATALOG (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '카탈로그 식별 ID',
  `name` varchar(127) DEFAULT NULL comment '이름',
  `description` varchar(255) DEFAULT NULL comment '설명',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `status` int(11) DEFAULT 0 comment '상태'
) comment='서비스 카탈로그';

-- maestro.MSTR_SERVICE_OBJECT definition
CREATE OR REPLACE TABLE maestro.MSTR_SERVICE_OBJECT (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '서비스 오브젝트 식별 ID',
  `name` varchar(127) DEFAULT NULL comment '이름',
  `description` varchar(255) DEFAULT NULL comment '설명',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `status` int(11) DEFAULT 0 comment '상태',
  `file_path` varchar(255) DEFAULT NULL comment '파일 경로',
  `image_path` varchar(255) NOT NULL DEFAULT 'https://placeimg.com/100/100/any' comment '이미지 경로',
  `platform_id` varchar(36) NOT NULL DEFAULT uuid() comment '플랫폼 ID',
  `type_of_service_object_build_id` varchar(36) DEFAULT NULL comment '타입별 서비스 오브젝트 빌드 ID',
  `type_of_service_object_id` varchar(36) DEFAULT NULL comment '타입별 서비스 오브젝트 ID',
  `category_id` varchar(36) NOT NULL comment '카테고리 식별 ID',
  `yaml` mediumtext DEFAULT NULL comment 'yaml 내용',
  `use_count` int(11) DEFAULT 0 comment '사용 횟수',
  `type` varchar(127) DEFAULT NULL comment '타입',
  `readme` mediumtext  DEFAULT NULL comment 'readme',
  `chart_name` varchar(255) DEFAULT NULL comment '차트명',
  `chart_version` varchar(255) DEFAULT NULL comment '차트버전',
  `helm_id` varchar(255) DEFAULT NULL comment 'helm ID',
  PRIMARY KEY (`id`)
) comment='서비스 오브젝트';

-- maestro.MSTR_SERVICE_OBJECT_APPROVER definition
CREATE OR REPLACE TABLE maestro.MSTR_SERVICE_OBJECT_APPROVER (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '승인 식별 ID',
  `user_id` varchar(36) DEFAULT NULL comment '사용자 식별 ID',
  `org_id` varchar(36) DEFAULT NULL comment '조직 식별 ID',
  `step` int(11) DEFAULT 1 comment '단계',
  `service_object_id` varchar(36) DEFAULT NULL comment '서비스 오브젝트 ID',
  `create_time` timestamp NULL DEFAULT current_timestamp() comment '생성시간',
  PRIMARY KEY (`id`)
) comment='서비스 오브젝트 승인';

-- maestro.MSTR_SERVICE_OBJECT_IN_SERVICE_CATALOG definition
CREATE OR REPLACE TABLE maestro.MSTR_SERVICE_OBJECT_IN_SERVICE_CATALOG (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `service_catalog_id` varchar(36) NOT NULL comment '서비스 카탈로그 ID',
  `service_object_id` varchar(36) NOT NULL comment '서비스 오브젝트 ID',
  `create_time` timestamp NULL DEFAULT current_timestamp() comment '생성시간',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  UNIQUE KEY `SERVICE_CATALOG_ID_SERVICE_OBJECT_ID` (`service_catalog_id`,`service_object_id`)
) comment='서비스 카탈로그별 서비스 오브젝트';

-- maestro.MSTR_SERVICE_OBJECT_IN_SERVICE_CATALOG_BOOKMARK definition
CREATE OR REPLACE TABLE maestro.MSTR_SERVICE_OBJECT_IN_SERVICE_CATALOG_BOOKMARK (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `user_id` varchar(36) NOT NULL COMMENT '사용자 아이디',
  `service_catalog_id` varchar(36) NOT NULL COMMENT 'MSTR_SERVICE_OBJECT_IN_SERVICE_CATALOG 에 있는 service_catalog_id 일치',
  `service_object_id` varchar(36) NOT NULL COMMENT 'MSTR_SERVICE_OBJECT_IN_SERVICE_CATALOG 에 있는 service_object_id 일치',
  `description` text DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) COMMENT='서비스 카탈로그의 서비스 오브젝트 즐겨찾기 관리';

-- maestro.MSTR_SERVICE_REQUEST definition
CREATE OR REPLACE TABLE maestro.MSTR_SERVICE_REQUEST (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `name` varchar(127) DEFAULT NULL comment '제목',
  `status` int(11) DEFAULT 0 comment '상태',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `end_time` timestamp NULL DEFAULT NULL comment '종료시간',
  `requester_id` varchar(36) NOT NULL comment '요청자 식별 ID',
  `manager_id` varchar(36) DEFAULT NULL comment '관리자 식별 ID',
  `description` text DEFAULT NULL comment '설명',
  `cidr` varchar(127) DEFAULT NULL comment 'CIDR',
  `solution_id` varchar(36) NOT NULL comment '솔루션 ID',
  `resource_type_id` varchar(36) NOT NULL comment '리소스 타입 식별 ID'
) comment='서비스 신청';

-- maestro.MSTR_SERVICE_REQUEST_COMMENT definition
CREATE OR REPLACE TABLE maestro.MSTR_SERVICE_REQUEST_COMMENT (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `content` text DEFAULT NULL comment '내용',
  `parent_id` varchar(36) DEFAULT NULL comment '상위 식별 ID',
  `service_request_id` varchar(36) DEFAULT NULL comment '서비스 신청 식별 ID',
  `depth` int(11) DEFAULT NULL comment '깊이',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `deleted` tinyint(1) DEFAULT 0 comment '삭제 여부',
  PRIMARY KEY (`id`)
) comment='서비스 신청 코멘트';

-- maestro.MSTR_SERVICE_REQUEST_LOG definition
CREATE OR REPLACE TABLE maestro.MSTR_SERVICE_REQUEST_LOG (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `message` text DEFAULT NULL comment '메세지',
  `service_request_status` int(11) DEFAULT NULL comment '서비스 요청 상태',
  `create_time` timestamp NULL DEFAULT current_timestamp() comment '생성시간',
  `request_of_service_object_id` varchar(36) DEFAULT NULL comment '요청 서비스 오브젝트 ID',
  PRIMARY KEY (`id`),
  KEY `idx_sr_log_request_of_service_object_id` (`request_of_service_object_id`)
) comment='서비스 신청 로그';

-- maestro.MSTR_SERVICE_REQUEST_RESERVATION definition
CREATE OR REPLACE TABLE maestro.MSTR_SERVICE_REQUEST_RESERVATION (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `resource_id` varchar(36) DEFAULT NULL comment '리소스 식별 ID',
  `workspace_id` varchar(36) DEFAULT NULL comment '워크스페이스 식별 ID',
  `request_of_service_object_id` varchar(36) DEFAULT NULL comment '요청 서비스 오브젝트 ID',
  `start_time` timestamp NULL DEFAULT NULL comment '시작시간',
  `end_time` timestamp NULL DEFAULT NULL comment '종료시간',
  `status` varchar(30) DEFAULT NULL comment '상태',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  PRIMARY KEY (`id`)
) comment='서비스 신청 보류';

-- maestro.MSTR_SERVICE_TYPE_APPROVER definition
CREATE OR REPLACE TABLE maestro.MSTR_SERVICE_TYPE_APPROVER (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `user_id` varchar(36) DEFAULT NULL comment '사용자 식별 ID',
  `org_id` varchar(36) DEFAULT NULL comment '조직 식별 ID',
  `step` int(11) DEFAULT 0 comment '단계',
  `service_type_id` varchar(36) DEFAULT NULL comment '서비스 타입 ID',
  `create_time` timestamp NULL DEFAULT current_timestamp() comment '생성 시간',
  PRIMARY KEY (`id`)
) comment='서비스 신청 승인';

-- maestro.MSTR_SOLUTION definition
CREATE OR REPLACE TABLE maestro.MSTR_SOLUTION (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `name` varchar(127) NOT NULL comment '솔루션 이름',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` datetime DEFAULT NULL comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` datetime DEFAULT NULL comment '수정시간',
  `description` varchar(255) DEFAULT NULL comment '설명',
  `status` int(11) DEFAULT NULL comment '상태',
  `external_yn` int(11) DEFAULT 0 comment '외부 솔루션 여부',
  `base_user_path` varchar(255) DEFAULT NULL comment '사용자 기본 패스',
  `base_admin_path` varchar(255) DEFAULT NULL comment '괸리자 기본 패스',
  PRIMARY KEY (`id`)
) comment='솔루션';

-- maestro.MSTR_SOLUTION_IN_WORKSPACE definition
CREATE OR REPLACE TABLE maestro.MSTR_SOLUTION_IN_WORKSPACE (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `name` varchar(127) NOT NULL comment '이름',
  `workspace_id` varchar(36) NOT NULL comment '워크스페이스 식별 ID',
  `solution_id` varchar(36) NOT NULL comment '솔루션 식별 ID'
) comment='솔루션 워크스페이스';

-- maestro.MSTR_SYMPHONY_ALARM_ENV definition
CREATE OR REPLACE TABLE maestro.MSTR_SYMPHONY_ALARM_ENV (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date_type` varchar(255) DEFAULT NULL COMMENT '알람 일자 타입, DAY / WEEK',
  `abnormal_limit` int(11) DEFAULT NULL COMMENT '이상 발생 빈도 임계치 ',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) COMMENT='마에스트로 심포니 알람 환경변수 테이블';

-- maestro.MSTR_SYMPHONY_ENV definition
CREATE OR REPLACE TABLE maestro.MSTR_SYMPHONY_ENV (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `platform_type` varchar(255) DEFAULT NULL COMMENT '플랫폼 타입 ex. OPENSTACK, NCP',
  `provider_type_id` int(11) DEFAULT NULL COMMENT 'bt_provider 테이블 참고',
  `resource_type_id` int(11) DEFAULT NULL COMMENT 'bt_provider_type 테이블 참고',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) COMMENT='마에스트로 심포니 연동용 환경변수 테이블';

-- maestro.MSTR_TAG definition
CREATE OR REPLACE TABLE maestro.MSTR_TAG (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `name` varchar(127) DEFAULT NULL comment '이름',
  `description` varchar(255) DEFAULT NULL comment '설명',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `status` int(11) DEFAULT 0 comment '상태'
) comment='태그';

-- maestro.MSTR_TAG_IN_SERVICE_OBJECT definition
CREATE OR REPLACE TABLE maestro.MSTR_TAG_IN_SERVICE_OBJECT (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `service_object_id` varchar(36) NOT NULL comment '서비스 오브젝트 식별 ID',
  `tag_id` varchar(36) NOT NULL comment '태그 식별 ID',
  `create_time` timestamp NULL DEFAULT current_timestamp() comment '생성시간',
  PRIMARY KEY (`id`)
) comment='서비스 오브젝트 태그';

-- maestro.MSTR_TEMPLATE_REQUEST_OF_SERVICE definition
CREATE OR REPLACE TABLE maestro.MSTR_TEMPLATE_REQUEST_OF_SERVICE (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `name` varchar(127) DEFAULT NULL comment '이름',
  `description` varchar(255) DEFAULT NULL comment '설명',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `status` int(11) DEFAULT 0 comment '상태'
) comment='서비스 오브젝트 템플릿';

-- maestro.MSTR_TEXT_FIELD definition
CREATE OR REPLACE TABLE maestro.MSTR_TEXT_FIELD (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `name` varchar(127) DEFAULT NULL comment '이름',
  `description` varchar(255) DEFAULT NULL comment '설명',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `status` int(11) DEFAULT 0 comment '상태'
) comment='텍스트 필드';

-- maestro.MSTR_TYPE_OF_FIELD definition
CREATE OR REPLACE TABLE maestro.MSTR_TYPE_OF_FIELD (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `name` varchar(127) DEFAULT NULL comment '이름',
  `description` varchar(255) DEFAULT NULL comment '설명',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `status` int(11) DEFAULT 0 comment '상태',
  `order` int(11) DEFAULT NULL comment '정렬 순서'
) comment='타입 필드';

-- maestro.MSTR_TYPE_OF_SERVICE_OBJECT definition
CREATE OR REPLACE TABLE maestro.MSTR_TYPE_OF_SERVICE_OBJECT (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `name` varchar(127) DEFAULT NULL comment '이름',
  `description` varchar(255) DEFAULT NULL comment '설명',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `status` int(11) DEFAULT 0 comment '상태'
) comment='서비스 오브젝트 타입';

-- maestro.MSTR_TYPE_OF_SERVICE_OBJECT_BUILD definition
CREATE OR REPLACE TABLE maestro.MSTR_TYPE_OF_SERVICE_OBJECT_BUILD (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `name` varchar(127) DEFAULT NULL comment '이름',
  `description` varchar(255) DEFAULT NULL comment '설명',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `status` int(11) DEFAULT 0 comment '상태'
) comment='서비스 오브젝트 타입 빌드';

-- maestro.MSTR_USER_GROUP definition
CREATE OR REPLACE TABLE maestro.MSTR_USER_GROUP (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `name` varchar(127) NOT NULL comment '이름',
  `description` text DEFAULT NULL comment '설명',
  `org_id` varchar(36) NOT NULL comment '조직 식별 ID',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `status` int(11) DEFAULT 1 comment '상태',
  `group_email` varchar(255) NOT NULL comment '그룹 이메일',
  PRIMARY KEY (`id`),
  KEY `MSTR_USER_GROUP_create_time_index` (`create_time`)
) comment='사용자 그룹';

-- maestro.MSTR_USER_ORG_MAPPING definition
CREATE OR REPLACE TABLE maestro.MSTR_USER_ORG_MAPPING (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `user_id` varchar(36) DEFAULT NULL comment '사용자 식별 ID',
  `org_id` varchar(36) DEFAULT NULL comment '조직 식별 ID',
  `mapping_status` varchar(30) DEFAULT NULL comment '맵핑 상태',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_user_org` (`user_id`,`org_id`)
) comment='사용자 그룹 맵핑';

-- maestro.MSTR_USER_SERVICE_REQUEST_VIEW_HISTORY definition
CREATE OR REPLACE TABLE maestro.MSTR_USER_SERVICE_REQUEST_VIEW_HISTORY (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `user_id` varchar(36) DEFAULT NULL comment '사용자 식별 ID',
  `service_request_id` varchar(36) DEFAULT NULL comment '서비스 요청 식별 ID',
  `last_view_time` timestamp NULL DEFAULT NULL comment '마지막 조회시간',
  PRIMARY KEY (`id`)
) comment='서비스 카탈로그 조회 이력';

-- maestro.MSTR_WORKFLOW definition
CREATE OR REPLACE TABLE maestro.MSTR_WORKFLOW (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `name` varchar(127) DEFAULT NULL comment '이름',
  `description` varchar(255) DEFAULT NULL comment '설명',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT current_timestamp() comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() comment '수정시간',
  `status` int(11) DEFAULT 0 comment '상태',
  `next_workflow_id` varchar(36) DEFAULT NULL comment '다음 식별 ID',
  `step` int(11) DEFAULT NULL comment '단계'
) comment='워크플로우';

-- maestro.MSTR_WORKFLOW_IN_REQUEST_OF_SERVICE_OBJECT definition
CREATE OR REPLACE TABLE maestro.MSTR_WORKFLOW_IN_REQUEST_OF_SERVICE_OBJECT (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `request_of_service_object_id` varchar(36) NOT NULL comment '요청 서비스 오브젝트 식별 ID',
  `workflow_id` varchar(36) NOT NULL comment '워크플로우 식별 ID',
  `create_time` timestamp NULL DEFAULT current_timestamp() comment '생성시간'
) comment='워크플로우 요청 서비스 오브젝트';

-- maestro.MSTR_WORKFLOW_IN_REQUEST_OF_SERVICE_TYPE definition
CREATE OR REPLACE TABLE maestro.MSTR_WORKFLOW_IN_REQUEST_OF_SERVICE_TYPE (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `request_of_service_type_id` varchar(36) NOT NULL comment '요청 서비스 오브젝트 식별 ID',
  `workflow_id` varchar(36) NOT NULL comment '워크플로우 식별 ID',
  `create_time` timestamp NULL DEFAULT current_timestamp() comment '생성시간'
) comment='워크플로우 요청 서비스 타입';

-- maestro.MSTR_WORKSPACE definition
CREATE OR REPLACE TABLE maestro.MSTR_WORKSPACE (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '고유 식별 ID',
  `name` varchar(127) NOT NULL comment '이름',
  `description` text DEFAULT NULL comment '설명',
  `folder_id` varchar(36) NOT NULL comment '폴더 식별 ID',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `status` int(11) DEFAULT 0 comment '상태',
  `org_id` varchar(36) DEFAULT NULL comment '조직 식별 ID',
  `cicd_project_name` varchar(500) DEFAULT NULL comment '트럼본에서 사용하는 테넌트명 지정용 필드, 유니크하다',
  `bookmark` tinyint(1) DEFAULT NULL comment '북마크 여부',
  PRIMARY KEY (`id`),
  UNIQUE KEY `MSTR_WORKSPACE__org_id__name` (`org_id`,`name`),
  KEY `MSTR_WORKSPACE_create_time_index` (`create_time`)
) comment='워크스페이스';

-- maestro.MSTR_WORKSPACE_BOOKMARK definition
CREATE OR REPLACE TABLE maestro.MSTR_WORKSPACE_BOOKMARK (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `user_id` varchar(36) NOT NULL COMMENT '사용자 아이디',
  `workspace_id` varchar(36) NOT NULL COMMENT 'MSTR_WORKSPACE 에 있는 id 일치',
  `workspace_name` varchar(36) NOT NULL COMMENT 'MSTR_WORKSPACE 에 있는 name 일치',
  `description` text DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) COMMENT='워크스페이스 즐겨찾기 관리';

-- maestro.QRTZ_CALENDARS definition
CREATE OR REPLACE TABLE maestro.QRTZ_CALENDARS (
  `SCHED_NAME` varchar(120) NOT NULL COMMENT '스케줄러 이름',
  `CALENDAR_NAME` varchar(200) NOT NULL COMMENT '캘린더 이름',
  `CALENDAR` blob NOT NULL COMMENT '캘린더 데이터',
  PRIMARY KEY (`SCHED_NAME`,`CALENDAR_NAME`)
) COMMENT='Quartz 캘린더 정보';

-- maestro.QRTZ_FIRED_TRIGGERS definition
CREATE OR REPLACE TABLE maestro.QRTZ_FIRED_TRIGGERS (
  `SCHED_NAME` varchar(120) NOT NULL COMMENT '스케줄러 이름',
  `ENTRY_ID` varchar(95) NOT NULL COMMENT '엔트리 ID',
  `TRIGGER_NAME` varchar(200) NOT NULL COMMENT '트리거 이름',
  `TRIGGER_GROUP` varchar(200) NOT NULL COMMENT '트리거 그룹',
  `INSTANCE_NAME` varchar(200) NOT NULL COMMENT '인스턴스 이름',
  `FIRED_TIME` bigint(13) NOT NULL COMMENT '실행 시간',
  `SCHED_TIME` bigint(13) NOT NULL COMMENT '스케줄 시간',
  `PRIORITY` int(11) NOT NULL COMMENT '우선순위',
  `STATE` varchar(16) NOT NULL COMMENT '상태',
  `JOB_NAME` varchar(200) DEFAULT NULL COMMENT 'Job 이름',
  `JOB_GROUP` varchar(200) DEFAULT NULL COMMENT 'Job 그룹',
  `IS_NONCONCURRENT` varchar(1) DEFAULT NULL COMMENT '동시 실행 불가 여부',
  `REQUESTS_RECOVERY` varchar(1) DEFAULT NULL COMMENT '복구 요청 여부',
  PRIMARY KEY (`SCHED_NAME`,`ENTRY_ID`)
) COMMENT='Quartz 실행된 트리거 정보';

-- maestro.QRTZ_JOB_DETAILS definition
CREATE OR REPLACE TABLE maestro.QRTZ_JOB_DETAILS (
  `SCHED_NAME` varchar(120) NOT NULL COMMENT '스케줄러 이름',
  `JOB_NAME` varchar(200) NOT NULL COMMENT 'Job 이름',
  `JOB_GROUP` varchar(200) NOT NULL COMMENT 'Job 그룹',
  `DESCRIPTION` varchar(250) DEFAULT NULL COMMENT '설명',
  `JOB_CLASS_NAME` varchar(250) NOT NULL COMMENT 'Job 클래스 이름',
  `IS_DURABLE` varchar(1) NOT NULL COMMENT '지속 가능 여부',
  `IS_NONCONCURRENT` varchar(1) NOT NULL COMMENT '동시 실행 불가 여부',
  `IS_UPDATE_DATA` varchar(1) NOT NULL COMMENT '데이터 업데이트 여부',
  `REQUESTS_RECOVERY` varchar(1) NOT NULL COMMENT '복구 요청 여부',
  `JOB_DATA` blob DEFAULT NULL COMMENT 'Job 데이터',
  PRIMARY KEY (`SCHED_NAME`,`JOB_NAME`,`JOB_GROUP`)
) COMMENT='Quartz Job 정보';

-- maestro.QRTZ_LOCKS definition
CREATE OR REPLACE TABLE maestro.QRTZ_LOCKS (
  `SCHED_NAME` varchar(120) NOT NULL COMMENT '스케줄러 이름',
  `LOCK_NAME` varchar(40) NOT NULL COMMENT '락 이름',
  PRIMARY KEY (`SCHED_NAME`,`LOCK_NAME`)
) COMMENT='Quartz 락 정보';

-- maestro.QRTZ_PAUSED_TRIGGER_GRPS definition
CREATE OR REPLACE TABLE maestro.QRTZ_PAUSED_TRIGGER_GRPS (
  `SCHED_NAME` varchar(120) NOT NULL COMMENT '스케줄러 이름',
  `TRIGGER_GROUP` varchar(200) NOT NULL COMMENT '트리거 그룹',
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_GROUP`)
) COMMENT='Quartz 일시정지된 트리거 그룹 정보';

-- maestro.QRTZ_SCHEDULER_EVENT definition
CREATE OR REPLACE TABLE maestro.QRTZ_SCHEDULER_EVENT (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `name` varchar(500) DEFAULT NULL,
  `description` varchar(2000) DEFAULT NULL,
  `path` text DEFAULT NULL,
  `body` text DEFAULT NULL,
  `header` text DEFAULT NULL,
  `solution_id` varchar(36) DEFAULT NULL,
  `solution` varchar(127) DEFAULT NULL,
  `service` varchar(127) DEFAULT NULL,
  `resource_type` varchar(127) DEFAULT NULL,
  `method` varchar(127) DEFAULT NULL,
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `update_user_id` varchar(36) DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  `status` int(11) DEFAULT 0,
  `service_type_id` varchar(36) DEFAULT NULL,
  KEY `UMTAEHYEOK_EVENT_create_time_index` (`create_time`)
) ;

-- maestro.QRTZ_SCHEDULER_STATE definition
CREATE OR REPLACE TABLE maestro.QRTZ_SCHEDULER_STATE (
  `SCHED_NAME` varchar(120) NOT NULL COMMENT '스케줄러 이름',
  `INSTANCE_NAME` varchar(200) NOT NULL COMMENT '인스턴스 이름',
  `LAST_CHECKIN_TIME` bigint(13) NOT NULL COMMENT '마지막 체크인 시간',
  `CHECKIN_INTERVAL` bigint(13) NOT NULL COMMENT '체크인 간격',
  PRIMARY KEY (`SCHED_NAME`,`INSTANCE_NAME`)
) COMMENT='Quartz 스케줄러 상태 정보';

-- maestro.SVC_REQUEST_API definition
CREATE OR REPLACE TABLE maestro.SVC_REQUEST_API (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `method` varchar(10) NOT NULL,
  `endpoint` varchar(255) NOT NULL,
  `header` text DEFAULT NULL,
  `body` text DEFAULT NULL,
  `status` int(11) DEFAULT 0,
  `step` int(11) DEFAULT 1,
  `service_request_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`)
) ;

-- maestro.MSTR_ADMIN_FOLDER definition
CREATE OR REPLACE TABLE maestro.MSTR_ADMIN_FOLDER (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `name` varchar(127) NOT NULL,
  `description` text DEFAULT NULL,
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `update_user_id` varchar(36) DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  `depth` int(11) NOT NULL,
  `status` int(11) DEFAULT 0,
  `parent_id` varchar(36) DEFAULT NULL,
  `org_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_MSTR_ADMIN_FOLDER_TO_MSTR_ADMIN_FOLDER_1` (`parent_id`),
  KEY `FK_MSTR_ADMIN_FOLDER_TO_MSTR_ADMIN_FOLDER_2` (`org_id`),
  CONSTRAINT `FK_MSTR_ADMIN_FOLDER_TO_MSTR_ADMIN_FOLDER_1` FOREIGN KEY (`parent_id`) REFERENCES `MSTR_ADMIN_FOLDER` (`id`),
  CONSTRAINT `FK_MSTR_ADMIN_FOLDER_TO_MSTR_ADMIN_FOLDER_2` FOREIGN KEY (`org_id`) REFERENCES `MSTR_ADMIN_FOLDER` (`id`)
) ;

-- maestro.MSTR_ADMIN_GROUP definition
CREATE OR REPLACE TABLE maestro.MSTR_ADMIN_GROUP (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `name` varchar(127) NOT NULL,
  `description` text DEFAULT NULL,
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `update_user_id` varchar(36) DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  `status` int(11) DEFAULT 0,
  `org_id` varchar(36) NOT NULL,
  `group_email` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_MSTR_ADMIN_FOLDER_TO_MSTR_ADMIN_GROUP_1` (`org_id`),
  CONSTRAINT `FK_MSTR_ADMIN_FOLDER_TO_MSTR_ADMIN_GROUP_1` FOREIGN KEY (`org_id`) REFERENCES `MSTR_ADMIN_FOLDER` (`id`)
) ;

-- maestro.MSTR_ADMIN_IN_FOLDER definition
CREATE OR REPLACE TABLE maestro.MSTR_ADMIN_IN_FOLDER (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `user_id` varchar(36) NOT NULL,
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `update_user_id` varchar(36) DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  `name` varchar(127) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `folder_id` varchar(36) NOT NULL,
  `status` int(11) DEFAULT 0,
  `is_guest` int(11) DEFAULT 0,
  `is_org` int(11) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `FK_MSTR_ADMIN_FOLDER_TO_MSTR_ADMIN_IN_FOLDER_1` (`folder_id`),
  CONSTRAINT `FK_MSTR_ADMIN_FOLDER_TO_MSTR_ADMIN_IN_FOLDER_1` FOREIGN KEY (`folder_id`) REFERENCES `MSTR_ADMIN_FOLDER` (`id`)
) ;

-- maestro.MSTR_ADMIN_IN_GROUP definition
CREATE OR REPLACE TABLE maestro.MSTR_ADMIN_IN_GROUP (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `status` int(11) DEFAULT 0,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_MSTR_ADMIN_GROUP_TO_MSTR_ADMIN_IN_GROUP_1` (`group_id`),
  CONSTRAINT `FK_MSTR_ADMIN_GROUP_TO_MSTR_ADMIN_IN_GROUP_1` FOREIGN KEY (`group_id`) REFERENCES `MSTR_ADMIN_GROUP` (`id`)
) ;

-- maestro.MSTR_BOARD_RECOMMENDATION definition
CREATE OR REPLACE TABLE maestro.MSTR_BOARD_RECOMMENDATION (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `board_id` varchar(36) NOT NULL,
  `user_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `MSTR_BOARD_RECOMMENDATION_MSTR_BOARD_id_fk` (`board_id`),
  CONSTRAINT `MSTR_BOARD_RECOMMENDATION_MSTR_BOARD_id_fk` FOREIGN KEY (`board_id`) REFERENCES `MSTR_BOARD` (`id`)
) ;

-- maestro.MSTR_ENDPOINT_IN_AUTHORITY definition
CREATE OR REPLACE TABLE maestro.MSTR_ENDPOINT_IN_AUTHORITY (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `authority_id` varchar(36) NOT NULL,
  `endpoint_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `MSTR_ENDPOINT_IN_AUTHORITY_MSTR_AUTHORITY_id_fk` (`authority_id`),
  KEY `MSTR_ENDPOINT_IN_AUTHORITY_MSTR_ENDPOINT_id_fk` (`endpoint_id`),
  CONSTRAINT `MSTR_ENDPOINT_IN_AUTHORITY_MSTR_AUTHORITY_id_fk` FOREIGN KEY (`authority_id`) REFERENCES `MSTR_AUTHORITY` (`id`),
  CONSTRAINT `MSTR_ENDPOINT_IN_AUTHORITY_MSTR_ENDPOINT_id_fk` FOREIGN KEY (`endpoint_id`) REFERENCES `MSTR_ENDPOINT` (`id`)
) ;

-- maestro.MSTR_ENDPOINT_IN_LOG_TAG definition
CREATE OR REPLACE TABLE maestro.MSTR_ENDPOINT_IN_LOG_TAG (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `endpoint_id` varchar(36) NOT NULL DEFAULT uuid(),
  `log_tag_id` varchar(36) NOT NULL DEFAULT uuid(),
  PRIMARY KEY (`id`),
  KEY `MSTR_ENDPOINT_IN_LOG_TAG_MSTR_ENDPOINT_id_fk` (`endpoint_id`),
  KEY `MSTR_ENDPOINT_IN_LOG_TAG_MSTR_LOG_TAG_id_fk` (`log_tag_id`),
  CONSTRAINT `MSTR_ENDPOINT_IN_LOG_TAG_MSTR_ENDPOINT_id_fk` FOREIGN KEY (`endpoint_id`) REFERENCES `MSTR_ENDPOINT` (`id`),
  CONSTRAINT `MSTR_ENDPOINT_IN_LOG_TAG_MSTR_LOG_TAG_id_fk` FOREIGN KEY (`log_tag_id`) REFERENCES `MSTR_LOG_TAG` (`id`)
) ;

-- maestro.MSTR_ENDPOINT_SERVICE_IN_SOLUTION definition
CREATE OR REPLACE TABLE maestro.MSTR_ENDPOINT_SERVICE_IN_SOLUTION (
  `service` varchar(127) NOT NULL,
  `solution_id` varchar(36) NOT NULL,
  PRIMARY KEY (`service`,`solution_id`),
  KEY `MSTR_ENDPOINT_SERVICE_IN_SOLUTION_MSTR_SOLUTION_null_fk` (`solution_id`),
  CONSTRAINT `FK_MSTR_ENDPOINT_SERVICE_TO_MSTR_ENDPOINT_SERVICE_IN_SOLUTION_1` FOREIGN KEY (`service`) REFERENCES `MSTR_ENDPOINT_SERVICE` (`name`),
  CONSTRAINT `MSTR_ENDPOINT_SERVICE_IN_SOLUTION_MSTR_SOLUTION_null_fk` FOREIGN KEY (`solution_id`) REFERENCES `MSTR_SOLUTION` (`id`)
) ;

-- maestro.MSTR_INFRA_FOLDER definition
CREATE OR REPLACE TABLE maestro.MSTR_INFRA_FOLDER (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `name` varchar(127) NOT NULL,
  `description` text DEFAULT NULL,
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `update_user_id` varchar(36) DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  `depth` int(11) NOT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `root_infra_id` varchar(36) DEFAULT NULL,
  `status` int(11) DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `MSTR_INFRA_FOLDER_pk` (`parent_id`,`name`),
  KEY `MSTR_INFRA_FOLDER_MSTR_INFRA_FOLDER_id_fk` (`root_infra_id`),
  KEY `MSTR_INFRA_FOLDER_create_time_index` (`create_time`),
  CONSTRAINT `MSTR_INFRA_FOLDER_MSTR_INFRA_FOLDER_id_fk` FOREIGN KEY (`root_infra_id`) REFERENCES `MSTR_INFRA_FOLDER` (`id`),
  CONSTRAINT `MSTR_INFRA_FOLDER_parent_id_fk` FOREIGN KEY (`parent_id`) REFERENCES `MSTR_INFRA_FOLDER` (`id`)
) ;

-- maestro.MSTR_MENU definition
CREATE OR REPLACE TABLE maestro.MSTR_MENU (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `name` varchar(500) DEFAULT NULL,
  `description` varchar(2000) DEFAULT NULL,
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT current_timestamp(),
  `update_user_id` varchar(36) DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  `status` int(11) DEFAULT 0,
  `position` int(11) NOT NULL DEFAULT 0,
  `depth` int(11) NOT NULL DEFAULT 0,
  `path` varchar(500) DEFAULT NULL,
  `selector` varchar(500) DEFAULT NULL,
  `global_menu_id` varchar(500) DEFAULT NULL,
  `en_name` varchar(255) DEFAULT NULL,
  `icon_path` varchar(2000) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_MSTR_MENU_TO_MSTR_MENU_1` (`parent_id`),
  CONSTRAINT `FK_MSTR_MENU_TO_MSTR_MENU_1` FOREIGN KEY (`parent_id`) REFERENCES `MSTR_MENU` (`id`)
) ;

-- maestro.MSTR_MENU_AUTHORITY definition
CREATE OR REPLACE TABLE maestro.MSTR_MENU_AUTHORITY (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `authority_id` varchar(36) NOT NULL DEFAULT uuid(),
  `menu_id` varchar(36) NOT NULL DEFAULT uuid(),
  `feature_types` varchar(2000) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_MSTR_AUTHORITY_TO_MSTR_MENU_AUTHORITY_1` (`authority_id`),
  KEY `FK_MSTR_MENU_TO_MSTR_MENU_AUTHORITY_1` (`menu_id`),
  CONSTRAINT `FK_MSTR_AUTHORITY_TO_MSTR_MENU_AUTHORITY_1` FOREIGN KEY (`authority_id`) REFERENCES `MSTR_AUTHORITY` (`id`),
  CONSTRAINT `FK_MSTR_MENU_TO_MSTR_MENU_AUTHORITY_1` FOREIGN KEY (`menu_id`) REFERENCES `MSTR_MENU` (`id`)
) ;

-- maestro.MSTR_NOTIFICATION_AND_GROUP definition
CREATE OR REPLACE TABLE maestro.MSTR_NOTIFICATION_AND_GROUP (
  `notification_id` varchar(255) NOT NULL comment '알림 식별 ID',
  `receive_group_id` varchar(255) NOT NULL comment '수신자 그룹 식별 ID',
  PRIMARY KEY (`notification_id`,`receive_group_id`),
  KEY `receive_group_id` (`receive_group_id`),
  CONSTRAINT `MSTR_NOTIFICATION_AND_GROUP_ibfk_1` FOREIGN KEY (`notification_id`) REFERENCES `MSTR_NOTIFICATION` (`id`),
  CONSTRAINT `MSTR_NOTIFICATION_AND_GROUP_ibfk_2` FOREIGN KEY (`receive_group_id`) REFERENCES `MSTR_NOTIFICATION_RECEIVE_GROUP` (`id`)
) comment='수신자 그룹과 알림 중간 테이블';

-- maestro.MSTR_NOTIFICATION_COMMON_CODE definition
CREATE OR REPLACE TABLE maestro.MSTR_NOTIFICATION_COMMON_CODE (
  `code` varchar(255) NOT NULL comment '코드',
  `code_type_id` varchar(255) DEFAULT NULL comment '코드 유형 ID',
  `parent_code` varchar(255) DEFAULT NULL comment '부모코드',
  `name` varchar(255) DEFAULT NULL comment '코드명',
  `create_date` timestamp NULL DEFAULT current_timestamp() comment '생성일시',
  `update_date` timestamp NULL DEFAULT NULL comment '수정일시',
  `create_user` varchar(255) DEFAULT NULL comment '생성자',
  `update_user` varchar(255) DEFAULT NULL comment '수정자',
  `use_yn` varchar(255) DEFAULT 'Y' comment '사용 여부',
  PRIMARY KEY (`code`),
  KEY `code_type_id` (`code_type_id`),
  KEY `parent_code` (`parent_code`),
  CONSTRAINT `MSTR_NOTIFICATION_COMMON_CODE_ibfk_1` FOREIGN KEY (`code_type_id`) REFERENCES `MSTR_NOTIFICATION_COMMON_CODE_TYPE` (`code_type_id`),
  CONSTRAINT `MSTR_NOTIFICATION_COMMON_CODE_ibfk_2` FOREIGN KEY (`parent_code`) REFERENCES `MSTR_NOTIFICATION_COMMON_CODE` (`code`)
) comment='알림 공통 코드 테이블';

-- maestro.MSTR_NOTIFICATION_EVENT definition
CREATE OR REPLACE TABLE maestro.MSTR_NOTIFICATION_EVENT (
  `id` varchar(255) NOT NULL DEFAULT uuid() comment '이벤트 식별 ID',
  `event_code_id` varchar(255) DEFAULT NULL comment '알림이벤트 코드 식별 ID',
  `solution_id` varchar(255) DEFAULT NULL comment '솔루션 식별 ID',
  `main_classification_code` varchar(255) DEFAULT NULL comment '대분류 코드',
  `main_classification_name` varchar(255) DEFAULT NULL comment '대분류 명',
  `sub_classification_code` varchar(255) DEFAULT NULL comment '소분류 코드',
  `sub_classification_name` varchar(255) DEFAULT NULL comment '소분류 명',
  `sub_message` varchar(255) DEFAULT NULL comment '부 메세지',
  `description` varchar(255) DEFAULT NULL comment '설명',
  `create_date` timestamp NULL DEFAULT current_timestamp() comment '생성일시',
  `update_date` timestamp NULL DEFAULT current_timestamp() comment '수정일시',
  `create_user` varchar(255) DEFAULT NULL comment '생성자',
  `update_user` varchar(255) DEFAULT NULL comment '수정자',
  `use_yn` varchar(255) DEFAULT 'Y' comment '사용 여부',
  `event_default` int(11) NOT NULL DEFAULT 1,
  `receive_target` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `event_code_id` (`event_code_id`),
  KEY `solution_id` (`solution_id`),
  CONSTRAINT `MSTR_NOTIFICATION_EVENT_ibfk_1` FOREIGN KEY (`event_code_id`) REFERENCES `MSTR_NOTIFICATION_EVENT_CODE` (`id`),
  CONSTRAINT `MSTR_NOTIFICATION_EVENT_ibfk_2` FOREIGN KEY (`solution_id`) REFERENCES `MSTR_SOLUTION` (`id`)
) comment '알림 이벤트 테이블';

-- maestro.MSTR_NOTIFICATION_IN_GROUP definition
CREATE OR REPLACE TABLE maestro.MSTR_NOTIFICATION_IN_GROUP (
  `id` varchar(255) NOT NULL DEFAULT uuid() comment '그룹원의 식별 ID',
  `group_id` varchar(255) DEFAULT NULL comment '수신자 그룹 식별 ID',
  `name` varchar(255) DEFAULT NULL comment '이름',
  `user_id` varchar(255) DEFAULT uuid() comment '사용자 ID',
  `phone` varchar(255) DEFAULT NULL comment '전화번호',
  `email` varchar(255) DEFAULT NULL comment '이메일',
  `external_yn` varchar(255) DEFAULT NULL comment '외부 사용자 여부',
  `type` varchar(255) DEFAULT 'USER' comment '타입',
  `create_date` timestamp NULL DEFAULT current_timestamp() comment '생성일시',
  `update_date` timestamp NULL DEFAULT NULL comment '수정일시',
  `create_user` varchar(255) DEFAULT NULL comment '생성자',
  `update_user` varchar(255) DEFAULT NULL comment '수정자',
  `use_yn` varchar(255) DEFAULT 'Y' comment '사용 여부',
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `MSTR_NOTIFICATION_IN_GROUP_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `MSTR_NOTIFICATION_RECEIVE_GROUP` (`id`)
) comment='수신자 그룹에 속한 회원 테이블';

-- maestro.MSTR_PLATFORM definition
CREATE OR REPLACE TABLE maestro.MSTR_PLATFORM (
  `id` varchar(36) NOT NULL DEFAULT uuid() comment '플렛폼 아이디',
  `solution_id` varchar(36) DEFAULT NULL comment '솔루션 아이디',
  `name` varchar(127) DEFAULT NULL comment '이름',
  `description` varchar(255) DEFAULT NULL comment '설명',
  `create_user_id` varchar(36) DEFAULT NULL comment '생성자',
  `create_time` timestamp NULL DEFAULT NULL comment '생성시간',
  `update_user_id` varchar(36) DEFAULT NULL comment '수정자',
  `update_time` timestamp NULL DEFAULT NULL comment '수정시간',
  `status` int(11) DEFAULT 0 comment '상태',
  PRIMARY KEY (`id`),
  KEY `MSTR_PLATFORM_MSTR_SOLUTION_id_fk` (`solution_id`),
  CONSTRAINT `MSTR_PLATFORM_MSTR_SOLUTION_id_fk` FOREIGN KEY (`solution_id`) REFERENCES `MSTR_SOLUTION` (`id`)
) ;

-- maestro.MSTR_PROVIDER definition
CREATE OR REPLACE TABLE maestro.MSTR_PROVIDER (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `name` varchar(127) NOT NULL,
  `description` text DEFAULT NULL,
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `update_user_id` varchar(36) DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `root_infra_id` varchar(36) DEFAULT NULL,
  `status` int(11) DEFAULT 0,
  `type` int(11) DEFAULT 1,
  `url` varchar(127) DEFAULT NULL,
  `place` varchar(255) DEFAULT NULL,
  `platform_type` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `MSTR_PROVIDER_MSTR_PROVIDER_TYPE_null_fk` (`type`),
  KEY `MSTR_PROVIDER_create_time_index` (`create_time`),
  CONSTRAINT `MSTR_PROVIDER_MSTR_PROVIDER_TYPE_null_fk` FOREIGN KEY (`type`) REFERENCES `MSTR_PROVIDER_TYPE` (`id`)
) ;

-- maestro.MSTR_REQUEST_OF_SERVICE_TYPE definition
CREATE OR REPLACE TABLE maestro.MSTR_REQUEST_OF_SERVICE_TYPE (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `name` varchar(127) NOT NULL,
  `description` text DEFAULT NULL,
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT current_timestamp(),
  `update_user_id` varchar(36) DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT current_timestamp(),
  `status` int(11) DEFAULT 0,
  `operation_code` varchar(20) DEFAULT NULL,
  `category_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_SERVICE_CATEGORY_TO_MSTR_REQUEST_OF_SERVICE_TYPE` (`category_id`),
  CONSTRAINT `FK_SERVICE_CATEGORY_TO_MSTR_REQUEST_OF_SERVICE_TYPE_1` FOREIGN KEY (`category_id`) REFERENCES `MSTR_REQUEST_OF_SERVICE_CATEGORY` (`id`)
) ;

-- maestro.MSTR_ROLE_CATEGORY definition
CREATE OR REPLACE TABLE maestro.MSTR_ROLE_CATEGORY (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `description` varchar(255) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `type_id` varchar(36) NOT NULL,
  `selector` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_MSTR_ROLE_TYPE_TO_MSTR_ROLE_CATEGORY_1` (`type_id`),
  CONSTRAINT `FK_MSTR_ROLE_TYPE_TO_MSTR_ROLE_CATEGORY_1` FOREIGN KEY (`type_id`) REFERENCES `MSTR_ROLE_TYPE` (`id`)
) ;

-- maestro.MSTR_ROLE_DEPLOY definition
CREATE OR REPLACE TABLE maestro.MSTR_ROLE_DEPLOY (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `name` varchar(127) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `update_user_id` varchar(36) DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  `status` int(11) DEFAULT 1,
  `org_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_MSTR_FOLDER_TO_MSTR_ROLE_DEPLOY_1` (`org_id`),
  CONSTRAINT `FK_MSTR_FOLDER_TO_MSTR_ROLE_DEPLOY_1` FOREIGN KEY (`org_id`) REFERENCES `MSTR_FOLDER` (`id`)
) ;

-- maestro.MSTR_ROLE_DEPLOY_OPTION definition
CREATE OR REPLACE TABLE maestro.MSTR_ROLE_DEPLOY_OPTION (
  `deploy_id` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `type` varchar(255) DEFAULT 'options',
  `value` varchar(4000) NOT NULL,
  `create_user_id` varchar(255) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`deploy_id`,`name`),
  KEY `MSTR_ROLE_DEPLOY_DEFAULT_pk` (`deploy_id`),
  CONSTRAINT `MSTR_ROLE_DEPLOY_DEFAULT_MSTR_ROLE_DEPLOY_id_fk` FOREIGN KEY (`deploy_id`) REFERENCES `MSTR_ROLE_DEPLOY` (`id`)
) COMMENT='service, default deploy 등의 옵션이 기록되는 테이블';

-- TODO: create_user_id current_timestamp ??
-- maestro.MSTR_SOLUTION_SERVER definition
CREATE OR REPLACE TABLE maestro.MSTR_SOLUTION_SERVER (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `name` varchar(127) DEFAULT NULL,
  `status` int(11) DEFAULT 1,
  `description` varchar(255) DEFAULT NULL,
  `create_user_id` varchar(36) DEFAULT current_timestamp(),
  `create_time` timestamp NULL DEFAULT NULL,
  `update_user_id` varchar(36) DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  `solution_id` varchar(36) NOT NULL,
  `is_admin` int(11) DEFAULT 1,
  `base_path` varchar(127) DEFAULT NULL,
  `api_docs_path` varchar(127) DEFAULT NULL,
  `nickname` varchar(127) DEFAULT NULL COMMENT '별칭',
  PRIMARY KEY (`id`),
  KEY `FK_MSTR_SOLUTION_TO_MSTR_SOLUTION_SERVER_1` (`solution_id`),
  CONSTRAINT `FK_MSTR_SOLUTION_TO_MSTR_SOLUTION_SERVER_1` FOREIGN KEY (`solution_id`) REFERENCES `MSTR_SOLUTION` (`id`)
) ;

-- maestro.MSTR_USER_IN_FOLDER definition
CREATE OR REPLACE TABLE maestro.MSTR_USER_IN_FOLDER (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `user_id` varchar(36) NOT NULL,
  `folder_id` varchar(36) NOT NULL,
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `update_user_id` varchar(36) DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  `name` varchar(127) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `status` tinyint(4) DEFAULT 0,
  `is_guest` tinyint(1) DEFAULT NULL,
  `is_org` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `MSTR_USER_IN_FOLDER_MSTR_FOLDER_null_fk` (`folder_id`),
  KEY `MSTR_USER_IN_FOLDER_create_time_index` (`create_time`),
  CONSTRAINT `MSTR_USER_IN_FOLDER_MSTR_FOLDER_null_fk` FOREIGN KEY (`folder_id`) REFERENCES `MSTR_FOLDER` (`id`)
) ;

-- maestro.MSTR_USER_IN_GROUP definition
CREATE OR REPLACE TABLE maestro.MSTR_USER_IN_GROUP (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `status` int(11) DEFAULT 0,
  `user_id` varchar(36) NOT NULL,
  `user_group_id` varchar(36) NOT NULL DEFAULT uuid(),
  PRIMARY KEY (`id`),
  KEY `FK_MSTR_USER_GROUP_TO_MSTR_USER_IN_GROUP_1` (`user_group_id`),
  CONSTRAINT `FK_MSTR_USER_GROUP_TO_MSTR_USER_IN_GROUP_1` FOREIGN KEY (`user_group_id`) REFERENCES `MSTR_USER_GROUP` (`id`)
) ;

-- maestro.MSTR_WORKSPACE_CONNECTION definition
CREATE OR REPLACE TABLE maestro.MSTR_WORKSPACE_CONNECTION (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `workspace_id` varchar(36) NOT NULL,
  `provider_id` varchar(36) NOT NULL,
  `tenant_name` varchar(127) NOT NULL DEFAULT 'Default',
  `tenant_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `MSTR_WORKSPACE_CONNECTION_MSTR_PROVIDER_null_fk` (`provider_id`),
  KEY `MSTR_WORKSPACE_CONNECTION_MSTR_WORKSPACE_null_fk` (`workspace_id`),
  CONSTRAINT `MSTR_WORKSPACE_CONNECTION_MSTR_PROVIDER_null_fk` FOREIGN KEY (`provider_id`) REFERENCES `MSTR_PROVIDER` (`id`),
  CONSTRAINT `MSTR_WORKSPACE_CONNECTION_MSTR_WORKSPACE_null_fk` FOREIGN KEY (`workspace_id`) REFERENCES `MSTR_WORKSPACE` (`id`)
) ;

-- maestro.QRTZ_TRIGGERS definition
CREATE OR REPLACE TABLE maestro.QRTZ_TRIGGERS (
  `SCHED_NAME` varchar(120) NOT NULL COMMENT '스케줄러 이름',
  `TRIGGER_NAME` varchar(200) NOT NULL COMMENT '트리거 이름',
  `TRIGGER_GROUP` varchar(200) NOT NULL COMMENT '트리거 그룹',
  `JOB_NAME` varchar(200) NOT NULL COMMENT 'Job 이름',
  `JOB_GROUP` varchar(200) NOT NULL COMMENT 'Job 그룹',
  `DESCRIPTION` varchar(250) DEFAULT NULL COMMENT '설명',
  `NEXT_FIRE_TIME` bigint(13) DEFAULT NULL COMMENT '다음 실행 시간',
  `PREV_FIRE_TIME` bigint(13) DEFAULT NULL COMMENT '이전 실행 시간',
  `PRIORITY` int(11) DEFAULT NULL COMMENT '우선순위',
  `TRIGGER_STATE` varchar(16) NOT NULL COMMENT '트리거 상태',
  `TRIGGER_TYPE` varchar(8) NOT NULL COMMENT '트리거 타입',
  `START_TIME` bigint(13) NOT NULL COMMENT '시작 시간',
  `END_TIME` bigint(13) DEFAULT NULL COMMENT '종료 시간',
  `CALENDAR_NAME` varchar(200) DEFAULT NULL COMMENT '캘린더 이름',
  `MISFIRE_INSTR` smallint(6) DEFAULT NULL COMMENT '미스파이어 지시자',
  `JOB_DATA` blob DEFAULT NULL COMMENT 'Job 데이터',
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`),
  KEY `SCHED_NAME` (`SCHED_NAME`,`JOB_NAME`,`JOB_GROUP`),
  CONSTRAINT `QRTZ_TRIGGERS_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `JOB_NAME`, `JOB_GROUP`) REFERENCES `QRTZ_JOB_DETAILS` (`SCHED_NAME`, `JOB_NAME`, `JOB_GROUP`)
) COMMENT='Quartz 트리거 정보';

-- maestro.MSTR_FOLDER_IN_ROLE_DEPLOY definition
CREATE OR REPLACE TABLE maestro.MSTR_FOLDER_IN_ROLE_DEPLOY (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `org_id` varchar(36) NOT NULL,
  `deploy_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_MSTR_FOLDER_TO_MSTR_FOLDER_IN_ROLE_DEPLOY_1` (`org_id`),
  KEY `FK_MSTR_ROLE_DEPLOY_TO_MSTR_FOLDER_IN_ROLE_DEPLOY_1` (`deploy_id`),
  CONSTRAINT `FK_MSTR_FOLDER_TO_MSTR_FOLDER_IN_ROLE_DEPLOY_1` FOREIGN KEY (`org_id`) REFERENCES `MSTR_FOLDER` (`id`),
  CONSTRAINT `FK_MSTR_ROLE_DEPLOY_TO_MSTR_FOLDER_IN_ROLE_DEPLOY_1` FOREIGN KEY (`deploy_id`) REFERENCES `MSTR_ROLE_DEPLOY` (`id`)
) ;

-- maestro.MSTR_GLOBAL_MENU definition
CREATE OR REPLACE TABLE maestro.MSTR_GLOBAL_MENU (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `description` varchar(2000) DEFAULT NULL,
  `solution_id` varchar(36) NOT NULL,
  `platform_id` varchar(36) DEFAULT NULL,
  `name` varchar(500) DEFAULT NULL,
  `type` varchar(127) DEFAULT NULL,
  `icon` varchar(500) DEFAULT NULL,
  `last_layout_changed_time` timestamp NULL DEFAULT NULL,
  `last_layout_chagned_user_id` varchar(500) DEFAULT NULL,
  `path` varchar(500) DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `MSTR_GLOBAL_MENU_MSTR_PLATFORM_null_fk` (`platform_id`),
  KEY `MSTR_GLOBAL_MENU_MSTR_SOLUTION_null_fk` (`solution_id`),
  CONSTRAINT `MSTR_GLOBAL_MENU_MSTR_PLATFORM_null_fk` FOREIGN KEY (`platform_id`) REFERENCES `MSTR_PLATFORM` (`id`),
  CONSTRAINT `MSTR_GLOBAL_MENU_MSTR_SOLUTION_null_fk` FOREIGN KEY (`solution_id`) REFERENCES `MSTR_SOLUTION` (`id`)
) ;

-- maestro.MSTR_NOTIFICATION_AND_EVENT definition
CREATE OR REPLACE TABLE maestro.MSTR_NOTIFICATION_AND_EVENT (
  `event_id` varchar(255) NOT NULL comment '이벤트 식별 ID',
  `notification_id` varchar(255) NOT NULL comment '알림 식별 ID',
  PRIMARY KEY (`event_id`,`notification_id`),
  KEY `notification_id` (`notification_id`),
  CONSTRAINT `MSTR_NOTIFICATION_AND_EVENT_ibfk_1` FOREIGN KEY (`event_id`) REFERENCES `MSTR_NOTIFICATION_EVENT` (`id`),
  CONSTRAINT `MSTR_NOTIFICATION_AND_EVENT_ibfk_2` FOREIGN KEY (`notification_id`) REFERENCES `MSTR_NOTIFICATION` (`id`)
) comment='알림과 이벤트 중간 테이블';

-- maestro.MSTR_REQUEST_OF_SERVICE_OBJECT definition
CREATE OR REPLACE TABLE maestro.MSTR_REQUEST_OF_SERVICE_OBJECT (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `name` varchar(127) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `create_user_id` varchar(36) NOT NULL,
  `create_time` timestamp NULL DEFAULT current_timestamp(),
  `update_user_id` varchar(36) DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `status` int(11) DEFAULT 0,
  `service_object_id` varchar(36) DEFAULT NULL,
  `service_desk_template_id` varchar(36) DEFAULT NULL,
  `request_user_id` varchar(36) DEFAULT NULL,
  `manager_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(36) DEFAULT NULL,
  `tenant_id` varchar(36) DEFAULT NULL,
  `request_time` timestamp NULL DEFAULT NULL,
  `desired_end_time` timestamp NULL DEFAULT NULL,
  `content` varchar(1000) DEFAULT NULL,
  `type` int(11) DEFAULT 0,
  `file_path` varchar(255) DEFAULT NULL,
  `variables` text DEFAULT NULL,
  `approve_time` timestamp NULL DEFAULT NULL,
  `progress_time` timestamp NULL DEFAULT NULL,
  `end_time` timestamp NULL DEFAULT NULL,
  `detail` text DEFAULT NULL,
  `provision_file_path` varchar(255) DEFAULT NULL,
  `provision_log` text DEFAULT NULL,
  `yaml` mediumtext DEFAULT NULL,
  `folder_id` varchar(36) DEFAULT NULL,
  `org_id` varchar(36) DEFAULT NULL,
  `resource_info` text DEFAULT NULL,
  `request_type_id` varchar(36) DEFAULT NULL,
  `admin_setting` tinyint(1) DEFAULT 0,
  `config_map` text DEFAULT NULL COMMENT '변수로 치환할 값에 대해 map 형태로 구성된 값입니다',
  `reason` varchar(1000) DEFAULT NULL,
  `workspace_id` varchar(36) DEFAULT NULL,
  `scheduled_time` timestamp NULL DEFAULT NULL,
  `return_time` timestamp NULL DEFAULT NULL,
  KEY `FK_SERVICE_TYPE_TO_MSTR_REQUEST_OF_SERVICE_OBJECT` (`request_type_id`),
  CONSTRAINT `FK_SERVICE_TYPE_TO_MSTR_REQUEST_OF_SERVICE_OBJECT` FOREIGN KEY (`request_type_id`) REFERENCES `MSTR_REQUEST_OF_SERVICE_TYPE` (`id`)
) ;

-- maestro.MSTR_ROLE definition
CREATE OR REPLACE TABLE maestro.MSTR_ROLE (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `name` varchar(127) DEFAULT NULL,
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `update_user_id` varchar(36) DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `selector` varchar(255) NOT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  `category_id` varchar(36) NOT NULL,
  `open_org` int(11) DEFAULT 0,
  `open_folder` int(11) DEFAULT 0,
  `open_workspace` int(11) DEFAULT 0,
  `role_type_id` varchar(36) DEFAULT NULL,
  `is_default` int(11) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `FK_MSTR_ROLE_CATEGORY_TO_MSTR_ROLE_1` (`category_id`),
  KEY `MSTR_ROLE_MSTR_ROLE_TYPE_id_fk` (`role_type_id`),
  CONSTRAINT `FK_MSTR_ROLE_CATEGORY_TO_MSTR_ROLE_1` FOREIGN KEY (`category_id`) REFERENCES `MSTR_ROLE_CATEGORY` (`id`),
  CONSTRAINT `MSTR_ROLE_MSTR_ROLE_TYPE_id_fk` FOREIGN KEY (`role_type_id`) REFERENCES `MSTR_ROLE_TYPE` (`id`)
) ;

-- maestro.MSTR_ROLE_DEPLOYED definition
CREATE OR REPLACE TABLE maestro.MSTR_ROLE_DEPLOYED (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `deploy_id` varchar(36) NOT NULL,
  `role_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `MSTR_ROLE_DEPLOYED_pk` (`deploy_id`,`role_id`),
  KEY `FK_MSTR_ROLE_TO_MSTR_DEPLOYED_ROLE_1` (`role_id`),
  CONSTRAINT `FK_MSTR_ROLE_DEPLOY_TO_MSTR_DEPLOYED_ROLE_1` FOREIGN KEY (`deploy_id`) REFERENCES `MSTR_ROLE_DEPLOY` (`id`),
  CONSTRAINT `FK_MSTR_ROLE_TO_MSTR_DEPLOYED_ROLE_1` FOREIGN KEY (`role_id`) REFERENCES `MSTR_ROLE` (`id`)
) ;

-- maestro.MSTR_USER_FOLDER_ROLE definition
CREATE OR REPLACE TABLE maestro.MSTR_USER_FOLDER_ROLE (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `folder_id` varchar(36) NOT NULL,
  `user_in_folder_id` varchar(36) NOT NULL,
  `deployed_role_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `MSTR_USER_FOLDER_ROLE_pk` (`folder_id`,`user_in_folder_id`,`deployed_role_id`),
  KEY `FK_MSTR_DEPLOYED_ROLE_TO_MSTR_USER_FOLDER_ROLE_1` (`deployed_role_id`),
  KEY `FK_MSTR_USER_IN_FOLDER_TO_MSTR_USER_FOLDER_ROLE_1` (`user_in_folder_id`),
  CONSTRAINT `FK_MSTR_DEPLOYED_ROLE_TO_MSTR_USER_FOLDER_ROLE_1` FOREIGN KEY (`deployed_role_id`) REFERENCES `MSTR_ROLE_DEPLOYED` (`id`),
  CONSTRAINT `FK_MSTR_FOLDER_TO_MSTR_USER_FOLDER_ROLE_1` FOREIGN KEY (`folder_id`) REFERENCES `MSTR_FOLDER` (`id`),
  CONSTRAINT `FK_MSTR_USER_IN_FOLDER_TO_MSTR_USER_FOLDER_ROLE_1` FOREIGN KEY (`user_in_folder_id`) REFERENCES `MSTR_USER_IN_FOLDER` (`id`)
) ;

-- maestro.MSTR_USER_GROUP_FOLDER_ROLE definition
CREATE OR REPLACE TABLE maestro.MSTR_USER_GROUP_FOLDER_ROLE (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `user_group_id` varchar(36) NOT NULL,
  `deployed_role_id` varchar(36) NOT NULL,
  `folder_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `MSTR_USER_GROUP_FOLDER_ROLE_pk` (`folder_id`,`user_group_id`,`deployed_role_id`),
  KEY `FK_MSTR_DEPLOYED_ROLE_TO_MSTR_USER_GROUP_FOLDER_ROLE_1` (`deployed_role_id`),
  KEY `FK_MSTR_USER_GROUP_TO_MSTR_USER_GROUP_FOLDER_ROLE_1` (`user_group_id`),
  CONSTRAINT `FK_MSTR_DEPLOYED_ROLE_TO_MSTR_USER_GROUP_FOLDER_ROLE_1` FOREIGN KEY (`deployed_role_id`) REFERENCES `MSTR_ROLE_DEPLOYED` (`id`),
  CONSTRAINT `FK_MSTR_FOLDER_TO_MSTR_USER_GROUP_FOLDER_ROLE_1` FOREIGN KEY (`folder_id`) REFERENCES `MSTR_FOLDER` (`id`),
  CONSTRAINT `FK_MSTR_USER_GROUP_TO_MSTR_USER_GROUP_FOLDER_ROLE_1` FOREIGN KEY (`user_group_id`) REFERENCES `MSTR_USER_GROUP` (`id`)
) ;

-- maestro.MSTR_USER_GROUP_WORKSPACE_ROLE definition
CREATE OR REPLACE TABLE maestro.MSTR_USER_GROUP_WORKSPACE_ROLE (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `user_group_id` varchar(36) NOT NULL,
  `deployed_role_id` varchar(36) NOT NULL,
  `workspace_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `MSTR_USER_GROUP_WORKSPACE_ROLE_pk` (`workspace_id`,`user_group_id`,`deployed_role_id`),
  KEY `FK_MSTR_DEPLOYED_ROLE_TO_CopyOfMSTR_USER_GROUP_FOLDER_ROLE_1` (`deployed_role_id`),
  KEY `FK_MSTR_USER_GROUP_TO_CopyOfMSTR_USER_GROUP_FOLDER_ROLE_1` (`user_group_id`),
  CONSTRAINT `FK_MSTR_DEPLOYED_ROLE_TO_CopyOfMSTR_USER_GROUP_FOLDER_ROLE_1` FOREIGN KEY (`deployed_role_id`) REFERENCES `MSTR_ROLE_DEPLOYED` (`id`),
  CONSTRAINT `FK_MSTR_USER_GROUP_TO_CopyOfMSTR_USER_GROUP_FOLDER_ROLE_1` FOREIGN KEY (`user_group_id`) REFERENCES `MSTR_USER_GROUP` (`id`),
  CONSTRAINT `FK_MSTR_WORKSPACE_TO_CopyOfMSTR_USER_GROUP_FOLDER_ROLE_1` FOREIGN KEY (`workspace_id`) REFERENCES `MSTR_WORKSPACE` (`id`)
) ;

-- maestro.MSTR_USER_WORKSPACE_ROLE definition
CREATE OR REPLACE TABLE maestro.MSTR_USER_WORKSPACE_ROLE (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `workspace_id` varchar(36) NOT NULL,
  `user_in_folder_id` varchar(36) NOT NULL,
  `deployed_role_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `MSTR_USER_WORKSPACE_ROLE_pk` (`deployed_role_id`,`user_in_folder_id`,`workspace_id`),
  KEY `FK_MSTR_USER_IN_FOLDER_TO_MSTR_USER_WORKSPACE_ROLE_1` (`user_in_folder_id`),
  KEY `FK_MSTR_WORKSPACE_TO_MSTR_USER_WORKSPACE_ROLE_1` (`workspace_id`),
  CONSTRAINT `FK_MSTR_DEPLOYED_ROLE_TO_MSTR_USER_WORKSPACE_ROLE_1` FOREIGN KEY (`deployed_role_id`) REFERENCES `MSTR_ROLE_DEPLOYED` (`id`),
  CONSTRAINT `FK_MSTR_USER_IN_FOLDER_TO_MSTR_USER_WORKSPACE_ROLE_1` FOREIGN KEY (`user_in_folder_id`) REFERENCES `MSTR_USER_IN_FOLDER` (`id`),
  CONSTRAINT `FK_MSTR_WORKSPACE_TO_MSTR_USER_WORKSPACE_ROLE_1` FOREIGN KEY (`workspace_id`) REFERENCES `MSTR_WORKSPACE` (`id`)
) ;

-- maestro.QRTZ_BLOB_TRIGGERS definition
CREATE OR REPLACE TABLE maestro.QRTZ_BLOB_TRIGGERS (
  `SCHED_NAME` varchar(120) NOT NULL COMMENT '스케줄러 이름',
  `TRIGGER_NAME` varchar(200) NOT NULL COMMENT '트리거 이름',
  `TRIGGER_GROUP` varchar(200) NOT NULL COMMENT '트리거 그룹',
  `BLOB_DATA` blob DEFAULT NULL COMMENT 'BLOB 데이터',
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`),
  CONSTRAINT `QRTZ_BLOB_TRIGGERS_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `QRTZ_TRIGGERS` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) COMMENT='Quartz BLOB 트리거 정보';

-- maestro.QRTZ_CRON_TRIGGERS definition
CREATE OR REPLACE TABLE maestro.QRTZ_CRON_TRIGGERS (
  `SCHED_NAME` varchar(120) NOT NULL COMMENT '스케줄러 이름',
  `TRIGGER_NAME` varchar(200) NOT NULL COMMENT '트리거 이름',
  `TRIGGER_GROUP` varchar(200) NOT NULL COMMENT '트리거 그룹',
  `CRON_EXPRESSION` varchar(120) NOT NULL COMMENT 'Cron 표현식',
  `TIME_ZONE_ID` varchar(80) DEFAULT NULL COMMENT '시간대 식별자',
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`),
  CONSTRAINT `QRTZ_CRON_TRIGGERS_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `QRTZ_TRIGGERS` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) COMMENT='Quartz Cron 트리거 정보';

-- maestro.QRTZ_SIMPLE_TRIGGERS definition
CREATE OR REPLACE TABLE maestro.QRTZ_SIMPLE_TRIGGERS (
  `SCHED_NAME` varchar(120) NOT NULL COMMENT '스케줄러 이름',
  `TRIGGER_NAME` varchar(200) NOT NULL COMMENT '트리거 이름',
  `TRIGGER_GROUP` varchar(200) NOT NULL COMMENT '트리거 그룹',
  `REPEAT_COUNT` int(11) NOT NULL COMMENT '반복 횟수',
  `REPEAT_INTERVAL` bigint(13) NOT NULL COMMENT '반복 간격',
  `TIMES_TRIGGERED` int(11) NOT NULL COMMENT '트리거 실행 횟수',
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`),
  CONSTRAINT `QRTZ_SIMPLE_TRIGGERS_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `QRTZ_TRIGGERS` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) COMMENT='Quartz Simple 트리거 정보';

-- maestro.QRTZ_SIMPROP_TRIGGERS definition
CREATE OR REPLACE TABLE maestro.QRTZ_SIMPROP_TRIGGERS (
  `SCHED_NAME` varchar(120) NOT NULL COMMENT '스케줄러 이름',
  `TRIGGER_NAME` varchar(200) NOT NULL COMMENT '트리거 이름',
  `TRIGGER_GROUP` varchar(200) NOT NULL COMMENT '트리거 그룹',
  `STR_PROP_1` varchar(512) DEFAULT NULL COMMENT '문자열 속성 1',
  `STR_PROP_2` varchar(512) DEFAULT NULL COMMENT '문자열 속성 2',
  `STR_PROP_3` varchar(512) DEFAULT NULL COMMENT '문자열 속성 3',
  `INT_PROP_1` int(11) DEFAULT NULL COMMENT '정수 속성 1',
  `INT_PROP_2` int(11) DEFAULT NULL COMMENT '정수 속성 2',
  `LONG_PROP_1` bigint(20) DEFAULT NULL COMMENT '긴 정수 속성 1',
  `LONG_PROP_2` bigint(20) DEFAULT NULL COMMENT '긴 정수 속성 2',
  `DEC_PROP_1` decimal(13,4) DEFAULT NULL COMMENT '실수 속성 1',
  `DEC_PROP_2` decimal(13,4) DEFAULT NULL COMMENT '실수 속성 2',
  `BOOL_PROP_1` varchar(1) DEFAULT NULL COMMENT '부울 속성 1',
  `BOOL_PROP_2` varchar(1) DEFAULT NULL COMMENT '부울 속성 2',
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`),
  CONSTRAINT `QRTZ_SIMPROP_TRIGGERS_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `QRTZ_TRIGGERS` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) COMMENT='Quartz Simple 속성 트리거 정보';

-- maestro.MSTR_ADMIN_FOLDER_ROLE definition
CREATE OR REPLACE TABLE maestro.MSTR_ADMIN_FOLDER_ROLE (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `folder_id` varchar(36) NOT NULL DEFAULT uuid(),
  `admin_in_folder_id` varchar(36) NOT NULL DEFAULT uuid(),
  `role_id` varchar(36) NOT NULL DEFAULT uuid(),
  PRIMARY KEY (`id`),
  KEY `FK_MSTR_ADMIN_FOLDER_TO_MSTR_ADMIN_FOLDER_ROLE_1` (`folder_id`),
  KEY `FK_MSTR_ADMIN_IN_FOLDER_TO_MSTR_ADMIN_FOLDER_ROLE_1` (`admin_in_folder_id`),
  KEY `FK_MSTR_ROLE_TO_MSTR_ADMIN_FOLDER_ROLE_1` (`role_id`),
  CONSTRAINT `FK_MSTR_ADMIN_FOLDER_TO_MSTR_ADMIN_FOLDER_ROLE_1` FOREIGN KEY (`folder_id`) REFERENCES `MSTR_ADMIN_FOLDER` (`id`),
  CONSTRAINT `FK_MSTR_ADMIN_IN_FOLDER_TO_MSTR_ADMIN_FOLDER_ROLE_1` FOREIGN KEY (`admin_in_folder_id`) REFERENCES `MSTR_ADMIN_IN_FOLDER` (`id`),
  CONSTRAINT `FK_MSTR_ROLE_TO_MSTR_ADMIN_FOLDER_ROLE_1` FOREIGN KEY (`role_id`) REFERENCES `MSTR_ROLE` (`id`)
) ;

-- maestro.MSTR_ADMIN_GROUP_FOLDER_ROLE definition
CREATE OR REPLACE TABLE maestro.MSTR_ADMIN_GROUP_FOLDER_ROLE (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `group_id` varchar(36) NOT NULL,
  `role_id` varchar(36) NOT NULL,
  `folder_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_MSTR_ADMIN_FOLDER_TO_MSTR_ADMIN_GROUP_FOLDER_ROLE_1` (`folder_id`),
  KEY `FK_MSTR_ADMIN_GROUP_TO_MSTR_ADMIN_GROUP_FOLDER_ROLE_1` (`group_id`),
  KEY `FK_MSTR_ROLE_TO_MSTR_ADMIN_GROUP_FOLDER_ROLE_1` (`role_id`),
  CONSTRAINT `FK_MSTR_ADMIN_FOLDER_TO_MSTR_ADMIN_GROUP_FOLDER_ROLE_1` FOREIGN KEY (`folder_id`) REFERENCES `MSTR_ADMIN_FOLDER` (`id`),
  CONSTRAINT `FK_MSTR_ADMIN_GROUP_TO_MSTR_ADMIN_GROUP_FOLDER_ROLE_1` FOREIGN KEY (`group_id`) REFERENCES `MSTR_ADMIN_GROUP` (`id`),
  CONSTRAINT `FK_MSTR_ROLE_TO_MSTR_ADMIN_GROUP_FOLDER_ROLE_1` FOREIGN KEY (`role_id`) REFERENCES `MSTR_ROLE` (`id`)
) ;

-- maestro.MSTR_AUTHORITY_IN_ROLE definition
CREATE OR REPLACE TABLE maestro.MSTR_AUTHORITY_IN_ROLE (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `role_id` varchar(36) NOT NULL,
  `authority_id` varchar(36) NOT NULL,
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `status` int(11) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `MSTR_AUTHORITY_IN_ROLE_MSTR_AUTHORITY_null_fk` (`authority_id`),
  KEY `MSTR_AUTHORITY_IN_ROLE_MSTR_ROLE_null_fk` (`role_id`),
  CONSTRAINT `MSTR_AUTHORITY_IN_ROLE_MSTR_AUTHORITY_null_fk` FOREIGN KEY (`authority_id`) REFERENCES `MSTR_AUTHORITY` (`id`),
  CONSTRAINT `MSTR_AUTHORITY_IN_ROLE_MSTR_ROLE_null_fk` FOREIGN KEY (`role_id`) REFERENCES `MSTR_ROLE` (`id`)
) ;

-- maestro.MSTR_RELEASE_NOTE definition
CREATE OR REPLACE TABLE maestro.MSTR_RELEASE_NOTE (
	`id` 						varchar(36) 	NOT NULL DEFAULT UUID() 			COMMENT '고유 식별 ID',
	`version`					varchar(20)		NOT NULL							COMMENT '릴리즈 버전',
	`release_time`				varchar(10)		NOT NULL							COMMENT '릴리즈 날짜',
	`title`						varchar(1000)	NULL								COMMENT '릴리즈 제목',
	`description`				text			NULL 								COMMENT '릴리즈 소개',
	`whats_new`					text			NULL								COMMENT 'Whats New',
	`create_time`				timestamp		NULL DEFAULT current_timestamp()	COMMENT '생성일시',
	PRIMARY KEY (`id`)
) COMMENT '릴리즈 노트' ;

-- maestro.svd_service_preset definition
CREATE OR REPLACE TABLE maestro.svd_service_preset (
    `id`                                        varchar(36)    DEFAULT UUID()                   NOT NULL        PRIMARY KEY     COMMENT '서비스 템플릿 id',
    `preset_resource_type_cd`	                varchar(30)	                                    NOT NULL                        COMMENT '서비스 공급 프리셋 자원 종류코드 (TERRAFORM, YAML, HELM_CHART)',
    `data`	                                    text	                                            NULL                        COMMENT '자원 정보',
    `platform_id`                               varchar(36)     DEFAULT NULL                                                    COMMENT '플랫폼 아이디',
    `name`                                      varchar(127)                                        NULL                        COMMENT '제목',
    `create_user_id`                            varchar(36)                                         NULL                        COMMENT '생성자 id',
    `create_time`                               timestamp       DEFAULT current_timestamp()     NOT NULL                        COMMENT '생성일시',
    `update_user_id`                            varchar(36)                                         NULL                        COMMENT '수정자 id',
    `update_time`                               timestamp       DEFAULT current_timestamp()     NOT NULL                        COMMENT '수정일시',
    `description`                               text                                                NULL                        COMMENT '설명',
    `status`                                    int             DEFAULT 0                           NULL                        COMMENT '상태 (삭제:-1, 대기:0, 배포:1)'
) COMMENT '서비스 공급 프리셋';

-- maestro.svd_service_preset_item definition
CREATE OR REPLACE TABLE maestro.svd_service_preset_item (
    `id`                                        varchar(36)    DEFAULT UUID()                   NOT NULL        PRIMARY KEY     COMMENT '서비스 공급 프리셋 항목 id',
    `service_preset_id`                         varchar(36)                                     NOT NULL                        COMMENT '서비스 공급 프리셋 id (FK)',
    `preset_item_type`	                        varchar(30)	                                    NOT NULL                        COMMENT '서비스 공급 항목 타입 (플랫폼 + 카테고리 + 000 :: ex. OPENSTACK_OS_001)',
    `item_key`	                                varchar(50)	                                    NOT NULL                        COMMENT '항목 Key',
    `item_label`	                            text	                                        NOT NULL                        COMMENT '항목 label',
    `is_user_write`	                            boolean	       DEFAULT FALSE                    NOT NULL                        COMMENT '사용자 입력 여부',
    `name`                                      varchar(127)                                        NULL                        COMMENT '제목',
    `create_user_id`                            varchar(36)                                         NULL                        COMMENT '생성자 id',
    `create_time`                               timestamp       DEFAULT current_timestamp()     NOT NULL                        COMMENT '생성일시',
    `update_user_id`                            varchar(36)                                         NULL                        COMMENT '수정자 id',
    `update_time`                               timestamp       DEFAULT current_timestamp()     NOT NULL                        COMMENT '수정일시',
    `description`                               text                                                NULL                        COMMENT '설명',
    `status`                                    int             DEFAULT 0                           NULL                        COMMENT '상태 (삭제:-1, 대기:0, 배포:1)'
) COMMENT = '서비스 공급 프리셋 항목';


-- maestro.svd_service_desk_template definition
CREATE OR REPLACE TABLE maestro.`svd_service_desk_template` (
    `id`                                        varchar(36)     DEFAULT UUID()                  NOT NULL        PRIMARY KEY     COMMENT '서비스 공급 오브젝트 id',
    `service_target_id`	                        varchar(36)	                                        NULL                        COMMENT '서비스 공급 id (FK :: service_object_id or service_preset_id)',
    `catalog_resource_type_cd`	                varchar(20)	                                    NOT NULL                        COMMENT '카탈로그 자원 종류코드 (PRESET, TERRAFORM, YAML, HELM_CHART)',
    `provider_id`	                            varchar(36)	                                        NULL                        COMMENT '공급자 id',
    `tenant_id`	                                varchar(36)	                                        NULL                        COMMENT '테넌트 id',
    `category_id`                               varchar(36)                                         NULL                        COMMENT '카테고리 id',
    `platform_id`                               varchar(36)                                         NULL                        COMMENT '플랫폼 id',
    `image_file_path`                           varchar(255)                                        NULL                        COMMENT '이미지 파일 경로',
    `provision_file_path`                       varchar(255)                                        NULL                        COMMENT '프로비저닝 파일 경로',
    `config_map`                                text                                                NULL                        COMMENT '변수로 치환될 data',
    `yaml`                                      text                                                NULL                        COMMENT '변수로 치환될 yaml data',
    `readme`                                    mediumtext                                          null                        comment 'HELM_CHART 설정 - readme',
    `chart_name`                                varchar(255)                                        null                        comment 'HELM_CHART 설정 - 업로드 차트명',
    `chart_version`                             varchar(255)                                        null                        comment 'HELM_CHART 설정 - 업로드 차트 버전',
    `helm_id`                                   varchar(255)                                        null                        comment 'HELM_CHART 설정 - 차트 id',
    `is_self_service`	                        boolean	        DEFAULT FALSE                   NOT NULL                        COMMENT '승인여부',
    `name`                                      varchar(127)                                        NULL                        COMMENT '제목',
    `create_user_id`                            varchar(36)                                         NULL                        COMMENT '생성자 id',
    `create_time`                               timestamp       DEFAULT current_timestamp()     NOT NULL                        COMMENT '생성일시',
    `update_user_id`                            varchar(36)                                         NULL                        COMMENT '수정자 id',
    `update_time`                               timestamp       DEFAULT current_timestamp()     NOT NULL                        COMMENT '수정일시',
    `description`                               text                                                NULL                        COMMENT '설명',
    `status`                                    int             DEFAULT 0                           NULL                        COMMENT '상태 (삭제:-1, 대기:0, 배포:1)'
) COMMENT = '서비스 공급 템플릿';

-- 서비스 즐겨찾기
CREATE OR REPLACE TABLE maestro.`svd_service_bookmark` (
    `id`                                        varchar(36)    DEFAULT UUID()                   NOT NULL        PRIMARY KEY     COMMENT '서비스 즐겨찾기 id',
    `workspace_id`	                            varchar(36)	                                    NOT NULL                        COMMENT '워크스페이스 id',
    `user_id`	                                varchar(36)	                                    NOT NULL                        COMMENT '사용자 id',
    `service_bookmark_type_cd`	                varchar(30)	                                    NOT NULL                        COMMENT '서비스 즐겨찾기 타입코드',
    `service_id`	                            varchar(36)	                                    NOT NULL                        COMMENT '서비스 id',
    `create_time`                               timestamp       DEFAULT current_timestamp()     NOT NULL                        COMMENT '생성일시'
) COMMENT = '서비스 즐겨찾기';

-- 결재라인
CREATE OR REPLACE TABLE maestro.`svd_approval_line` (
    `id`                                        varchar(36)    DEFAULT UUID()                   NOT NULL        PRIMARY KEY     COMMENT '결재라인 id',
    `workspace_id`	                            varchar(36)	                                    NOT NULL                        COMMENT '워크스페이스 id',
    `is_active`	                                boolean	       DEFAULT FALSE                    NOT NULL                        COMMENT '활성화 여부',
    `total_steps`	                            tinyint 	   UNSIGNED DEFAULT 0               NOT NULL                        COMMENT '총 결제 단계 (최대 50)',
    `name`                                      varchar(127)                                        NULL                        COMMENT '제목',
    `create_user_id`                            varchar(36)                                         NULL                        COMMENT '생성자 id',
    `create_time`                               timestamp       DEFAULT current_timestamp()     NOT NULL                        COMMENT '생성일시',
    `update_user_id`                            varchar(36)                                         NULL                        COMMENT '수정자 id',
    `update_time`                               timestamp       DEFAULT current_timestamp()     NOT NULL                        COMMENT '수정일시',
    `description`                               text                                                NULL                        COMMENT '설명',
    `status`                                    int             DEFAULT 0                           NULL                        COMMENT '상태 (삭제:-1, 대기:0, 배포:1)'
);
ALTER TABLE maestro.`svd_approval_line` COMMENT = '결재라인';
ALTER TABLE maestro.`svd_approval_line`
ADD CONSTRAINT `CK_svd_approval_line_workspace_id`
UNIQUE (`workspace_id`);