set foreign_key_checks = 0;

-- maestro.MSTR_ACCESS_CONTROL
INSERT INTO maestro.MSTR_ACCESS_CONTROL (ip_address, cidr)
VALUES  ('0.0.0.0', 0)
;

-- maestro.MSTR_AUTHORITY_TYPE
INSERT INTO maestro.MSTR_AUTHORITY_TYPE (id, description, is_default, name, selector)
VALUES  ('40ceedea-07ba-11ef-8bb1-cee8dc1678f7', 'Portal 권한', 0, 'User', 'portal')
    ,   ('40cfe466-07ba-11ef-8bb1-cee8dc1678f7', 'Console 권한', 1, 'Admin', 'console')
;

-- maestro.MSTR_AUTHORITY
INSERT INTO maestro.MSTR_AUTHORITY (id, status, solution, constant, name, description, selector, `type`, category)
VALUES  ('0676b247-0df4-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]역할 배포 목록 제어', '역할 배포 목록 제어','console.cmp.user-iam.role.depoly.edit','admin','user-iam')
    ,   ('51dd9f48-0df2-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]역할 배포 목록 조회', 'role.deploy.access','console.cmp.user-iam.role.deploy.access','admin','user-iam')
    ,   ('d1d74626-0aa9-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]리소스 상태 제어', '워크스페이스 내 전체 리소스 상태 제어','portal.cmp.workspace.update','user','workspace')
    ,   ('09907e37-0aa4-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]리소스 목록 조회', '워크스페이스 내 전체 리소스 목록 및 상세 정보 조회','portal.cmp.workspace.access','user','workspace')
    ,   ('2e5e5ff4-0d11-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]서비스 처리 현황 조회', '처리한 서비스 목록 및 상세 정보 조회','console.cmp.service-request.access','admin','service-request')
    ,   ('11b0f8d4-0a1e-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]서비스 신청', 'SR/서비스 카탈로그 조회 및 신청','portal.cmp.service-request.request','user','service-request')
    ,   ('7f5c30cf-0a26-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]서비스 신청 취소','신청한 서비스 취소','portal.cmp.service-request.cancel','user','service-request')
    ,   ('b701d4df-0a90-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]나의 신청현황 조회','요청한 SR목록 및 상세 정보 조회','portal.cmp.service-request.listaccess','user','service-request')
    ,   ('480c1f8a-0a93-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]요청 서비스 제어','서비스 신청/반려','portal.cmp.service-request.approve','user','service-request')
    ,   ('c0b5041e-0d19-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]요청 서비스 제어2','서비스 실행/반려','console.cmp.service-request.control','admin','service-request')
    ,   ('127ac895-0e8a-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]서비스 오브젝트 제어','서비스 오브젝트 제어','console.cmp.service-catalog.object.control','admin','service-catalog')
    ,   ('48648c82-0e88-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]서비스 오브젝트 조회','서비스 오브젝트 목록 및 상세 정보 조회','console.cmp.service-catalog.object.access','admin','service-catalog')
    ,   ('3d778167-0de2-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]서비스 카탈로그 제어','서비스 카탈로그 제어','console.cmp.service-catalog.edit','admin','service-catalog')
    ,   ('4ed8e5dd-0ddf-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]서비스 카탈로그 조회','서비스 카탈로그 목록 및 상세 조회','console.cmp.service-catalog.access','admin','service-catalog')
    ,   ('131b2dbc-0e93-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]관리자 메뉴 상태 설정','메뉴 상태 변경','console.cmp.operation.menu.status.control','admin','operation')
    ,   ('db749053-0e97-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]사용자 메뉴 상태 설정','Portal 메뉴 상태 변경','console.cmp.user-operation.menu.status.control','admin','user-operation')
    ,   ('bfb6a2d9-0e8a-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]관리자 메뉴 제어','메뉴 제어','console.cmp.operation.menu.edit','admin','operation')
    ,   ('3bb3a43c-0e87-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]관리자 메뉴 조회','메뉴 목록 및 메뉴 상세 정보 조회','console.cmp.operation.menu.access','admin','operation')
    ,   ('edbade42-0e96-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]사용자 메뉴 제어','Portal 메뉴 제어','console.cmp.user-operation.menu.edit','admin','user-operation')
    ,   ('1f622bc3-0e96-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]사용자 메뉴 조회','메뉴 목록 및 메뉴 상세 정보 조회','console.cmp.user-operation.menu.access','admin','user-operation')
    ,   ('f7d93cc6-0c73-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]조직 디렉토리 제어','조직/폴더/워크스페이스 제어','console.cmp.workspace.edit','admin','workspace')
    ,   ('314a4d20-0c72-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]조직 디렉토리 조회','조직 구조 및 상세 정보 조회','console.cmp.workspace.access','admin','workspace')
    ,   ('6eff1976-0dc1-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]공급자 제어','공급자 연결 및 연결 해제를 포함한 제어','console.cmp.connect.provider.edit','admin','connect')
    ,   ('4bbdc444-0dc1-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]공급자 목록 조회','연결된 공급자 목록 및 상세 정보 조회','console.cmp.connect.provider.access','admin','connect')
    ,   ('2141ec9b-0dc2-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]테넌트 연결 제어','워크스페이스에 테넌트 연결 및 해제','console.cmp.workspace.tenant.edit','admin','workspace')
    ,   ('cfdee3c5-0dc1-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]테넌트 목록 조회','워크스페이스 연결된 테넌트 목록 및 상세 정보 조회','console.cmp.workspace.tenant.access','admin','workspace')
    ,   ('305ea1be-0eca-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]구성원 접근 제어 조회',NULL,'console.cmp.user-iam.user.access-control.access','admin','user-iam')
    ,   ('d6329d31-0ea2-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]구성원 접근 제어 조회','구성원 역할 할당 현황 및 상세 정보 조회','console.cmp.iam.user.access-control.access','admin','iam')
    ,   ('4908cdd5-0eca-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]구성원 역할 설정',NULL,'console.cmp.user-iam.user.access-control.edit','admin','user-iam')
    ,   ('16964bc2-0ea4-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]구성원 역할 설정','운영자 및 운영자 그룹 역할 설정','console.cmp.iam.user.access-control.edit','admin','iam')
    ,   ('a78fa6b6-0cfa-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]권한 제어','권한 제어 죽게따','console.cmp.iam.authority.edit','admin','iam')
    ,   ('a67189a7-0cf2-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]권한 조회','권한 목록 및 상세 정보 조회','console.cmp.iam.authority.access','admin','iam')
    ,   ('3de192b5-0e83-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]사용자 제어',NULL,'console.cmp.user-iam.user.edit','admin','user-iam')
    ,   ('80e943d2-0ce2-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]사용자 조회',NULL,'console.cmp.user-iam.user.access','admin','user-iam')
    ,   ('9d987a23-0e93-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]사용자 그룹 제어',NULL,'console.cmp.user-iam.user.group.edit','admin','user-iam')
    ,   ('f5e1f598-0e8b-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]사용자 그룹 조회',NULL,'console.cmp.user-iam.user.group.access','admin','user-iam')
    ,   ('93b70a2f-0ea6-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]운영자 그룹 제어','운영자 그룹 제어','console.cmp.iam.user.edit','admin','iam')
    ,   ('b0cb42dc-0ea5-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]운영자 그룹 조회','운영자 그룹 정보 조회','console.cmp.iam.user.group.access','admin','iam')
    ,   ('ff36e898-0ed0-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]운영자 제어',NULL,'console.cmp.iam.user.edit','admin','iam')
    ,   ('fd0007f4-0ed0-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]운영자 조회',NULL,'console.cmp.iam.user.access','admin','iam')
    ,   ('345dd81a-0e9d-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]게시글 제어','게시글 제어','console.cmp.community.edit','admin','community')
    ,   ('3bb025df-0dd9-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]게시글 제어','게시글 제어','console.cmp.community.edit','admin','community')
    ,   ('5f6cbddf-0dd8-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]게시글 조회','게시글 목록 및 상세 정보 조회','console.cmp.community.access','admin','community')
    ,   ('9a9e7e00-0e9c-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]게시글 조회','게시글 목록 및 상세 정보 조회','console.cmp.community.access','admin','community')
    ,   ('97d8021e-0e83-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]접속 로그 조회','Console 사용자 접속 로그 조회','console.cmp.tracking.log.access-log.access','admin','tracking')
    ,   ('63564207-0e86-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]감사 로그 조회','Console 사용자 작업 로그 조회','console.cmp.tracking.log.audit-log.access','admin','tracking')
    ,   ('3287b065-0dfe-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]이벤트 목록 조회','이벤트 목록 조회','console.cmp.tracking.notification.event.access','admin','tracking')
    ,   ('5946959f-0e72-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]이벤트 메시지 수정','이벤트 메시지 수정','console.cmp.tracking.notification.event.message.update','admin','tracking')
    ,   ('b43d9159-0cd7-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]엔드포인트 조회','동기화된 엔드포인트 조회','console.cmp.iam.endpoint.access','admin','iam')
    ,   ('2c374f52-0cf6-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]이상 징후 탐지 조회','자원 목록 및 이상징후 상세 정보 조회','console.cmp.insight.anomaly.access','admin','insight')
    ,   ('4756e40c-0def-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]Console 역할 제어','역할 제어','console.cmp.iam.role.edit','admin','iam')
    ,   ('49c61346-0c36-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]Console 알림 유형 조회','알림 유형 목록 및 상세 정보 조회','console.cmp.tracking.notification.category.access','admin','tracking')
    ,   ('837fe845-0c38-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]Console 알림 유형 수정','알림 기본 정보 수정','console.cmp.tracking.notification.category.update','admin','tracking')
    ,   ('997a36e6-0e73-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]Console 수신자 그룹 제어','수신자 그룹 제어','console.cmp.tracking.notification.receive-group.edit','admin','tracking')
    ,   ('c8ffcdd1-0df6-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]Console 알림 유형 제어','알림 제어','console.cmp.tracking.notification.category.edit','admin','tracking')
    ,   ('dc50da6a-0d29-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]Console 역할 조회','역할 목록 및 상세 정보 조회','console.cmp.iam.role.access','admin','iam')
    ,   ('e8797b18-0c36-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]Console 알림 유형 생성','알림 유형 생성','console.cmp.tracking.notification.category.create','admin','tracking')
    ,   ('0ff661ba-0e73-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]Console 수신자 그룹 조회','수신자 그룹 목록 및 상세정보 조회','console.cmp.tracking.notification.receive-group.access','admin','tracking')
    ,   ('e8f387a9-0c4d-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]대시보드 조회','조직별 현황 대시보드 조회','console.cmp.user-operation.dashboard','admin','user-operation')
    ,   ('49e3f6a3-0cf6-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]자원 최적화 조회','자원 최적화 조회','console.cmp.insight.resource.access','admin','insight')
    ,   ('72992fce-0ccf-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]인프라 디렉토리 제어','인프라 디렉토리 제어','console.cmp.connect.edit','admin','connect')
    ,   ('b4fc1b71-0ccc-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]인프라 디렉토리 조회','인프라 구조 및 상세 정보 조회','console.cmp.connect.access','admin','connect')
    ,   ('92fd39e8-0cf6-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]자원 최적화 목록 조회','자원 최적화 목록 및 상세 정보 조회','console.cmp.cost.resourceList.access','admin','cost')
    ,   ('9dad1123-1062-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]관리자 서비스 승인','관리자 포탈에서의 승인자가 필요한 트럼본에서 사용하는 권한입니다.','console.cmp.service-request.approve','admin','service-request')
    ,   ('dcdd52f8-6441-11ef-aa9f-f2cdef6842ce', 1, 'CMP', 0, '[기본권한]상품 조회','상품 조회 기능','portal.cmp.default.product','user','default')
    ,   ('a3bb3830-0c2b-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]과금 정책 제어','FinOps 플랫폼 과금 정책에 대한 권한 관리','console.cmp.cost.policy.edit','admin','cost')
    ,   ('5a1b494d-0c2b-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]과금 정책 조회','FinOps 플랫폼 과금 정책에 대한 권한','console.cmp.cost.policy.access','admin','cost')
    ,   ('84245683-0cf2-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]기타 과금 제어','기타 과금 정책에 대한 권한관리','console.cmp.cost.other.edit','admin','cost')
    ,   ('e90a2bc7-0cf1-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]기타 과금 조회','기타과금정책','console.cmp.cost.other.access','admin','cost')
    ,   ('f502a047-0dc0-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]비용 조회','플랫폼 및 조직 계층별 비용 조회','console.cmp.cost.access','admin','cost')
    ,   ('fcbe15e0-0cef-11ef-9fbf-8ef2ee3c3984', 1, 'CMP', 0, '[기본권한]엔드포인트 동기화','DB에 추가된 엔드포인트 동기화','console.cmp.iam.endpoint.sync','admin','iam')
    ,   ('d8c8fbf6-e536-11ef-9c74-0a11b82fa8dd', 1, 'CMP', 0, '플랫폼 조회 권한','기본 권한 From 동기화','default.cmp.view','default','default')
    ,   ('d8d1fff6-e536-11ef-9c74-0a11b82fa8dd', 1, 'CMP', 0, '플랫폼 작업 권한','기본 권한 From 동기화','default.cmp.edit','default','default')
    ,   ('3394d144-0acd-11ef-9fbf-8ef2ee3c3984', 1, 'NCP', 0, '[기본권한]Public Cloud - ncp 조회','ncp 리소스 목록 및 상세 정보 조회','portal.cmp.workspace.ncp-access','user','workspace')
    ,   ('0ee32712-15c6-11f0-8e4c-52e9553a2057', 1, 'NCP', 0, 'NCP 조회 권한','기본 권한 From 동기화','default.ncp.view','default','default')
    ,   ('0ee4181c-15c6-11f0-8e4c-52e9553a2057', 1, 'NCP', 0, 'NCP 작업 권한','기본 권한 From 동기화','default.ncp.edit','default','default')
    ,   ('626a9a51-36cd-11f0-80c3-6e593baabd40', 1, 'NCP', 0, 'NCP 조회 권한','기본 권한 From 동기화','default.ncp.view','default','default')
    ,   ('626b6278-36cd-11f0-80c3-6e593baabd40', 1, 'NCP', 0, 'NCP 작업 권한','기본 권한 From 동기화','default.ncp.edit','default','default')
    ,   ('f93e0c1e-4f13-11ef-8f18-c6494ca007d9', 1, 'AWS', 0, '[기본권한]Public Cloud for AWS 조회','AWS 리소스 목록 및 상세 정보 조회','portal.cmp.workspace.aws-access','user','workspace')
    ,   ('d655d42b-fe3d-11ef-b654-1a18cace67cc', 1, 'AWS', 0, 'AWS 조회 권한','기본 권한 From 동기화','default.aws.view','default','default')
    ,   ('d656b86f-fe3d-11ef-b654-1a18cace67cc', 1, 'AWS', 0, 'AWS 작업 권한','기본 권한 From 동기화','default.aws.edit','default','default')
    ,   ('67a38878-36cd-11f0-80c3-6e593baabd40', 1, 'Doublebass', 0, 'VMware 조회 권한','기본 권한 From 동기화','default.doublebass.view','default','default')
    ,   ('67a3be72-36cd-11f0-80c3-6e593baabd40', 1, 'Doublebass', 0, 'VMware 작업 권한','기본 권한 From 동기화','default.doublebass.edit','default','default')
    ,   ('b318eeda-fa65-11ef-9b14-1a18cace67cc', 1, 'Doublebass', 0, 'VMware 조회 권한','기본 권한 From 동기화','default.doublebass.view','default','default')
    ,   ('b3198a62-fa65-11ef-9b14-1a18cace67cc', 1, 'Doublebass', 0, 'VMware 작업 권한','기본 권한 From 동기화','default.doublebass.edit','default','default')
    ,   ('393dfa74-0acc-11ef-9fbf-8ef2ee3c3984', 1, 'viola', 0, '[기본권한]K8S Engine 조회','k8s 리소스 목록 및 상세 정보 조회','portal.cmp.workspace.k8s-access','user','workspace')
    ,   ('81bbecfb-e538-11ef-9c74-0a11b82fa8dd', 1, 'Viola', 0, 'Kubernetes 조회 권한','기본 권한 From 동기화','default.viola.view','default','default')
    ,   ('c783c3b3-e538-11ef-9c74-0a11b82fa8dd', 1, 'Viola', 0, 'Kubernetes 작업 권한','기본 권한 From 동기화','default.viola.edit','default','default')
    ,   ('1824c672-0ac6-11ef-9fbf-8ef2ee3c3984', 1, 'Contrabass', 0, '[기본권한]Compute Engine 조회','openstack 리소스 목록 및 상세 정보 조회','portal.cmp.workspace.os-access','user','workspace')
    ,   ('ade8822b-e537-11ef-9c74-0a11b82fa8dd', 1, 'Contrabass', 0, 'Openstack 조회 권한','기본 권한 From 동기화','default.contrabass.view','default','default')
    ,   ('adf13eeb-e537-11ef-9c74-0a11b82fa8dd', 1, 'Contrabass', 0, 'Openstack 작업 권한','기본 권한 From 동기화','default.contrabass.edit','default','default')
    ,   ('e953d891-23e7-11f0-b0f2-3e31076d3589', 1, 'Contrabass', 0, 'openstack 작업권한',NULL,'console.contrabass.default.create','admin','default')
    ,   ('f32a526a-143e-11f0-8e4c-52e9553a2057', 1, 'Cisco', 0, '플랫폼 조회 권한','기본 권한 From 동기화','default.cisco.view','default','default')
    ,   ('f32ad614-143e-11f0-8e4c-52e9553a2057', 1, 'Cisco', 0, '플랫폼 작업 권한','기본 권한 From 동기화','default.cisco.edit','default','default')
    ,   ('e2a7a627-0f9e-11f0-8e4c-52e9553a2057', 1, 'Trombone', 0, 'CI/CD 조회 권한','기본 권한 From 동기화','default.trombone.view','default','default')
    ,   ('e2a853b9-0f9e-11f0-8e4c-52e9553a2057', 1, 'Trombone', 0, 'CI/CD 작업 권한','기본 권한 From 동기화','default.trombone.edit','default','default')
    ,   ('e815dc9c-1061-11f0-8e4c-52e9553a2057', 1, 'Vista', 0, 'Monitoring 조회 권한','기본 권한 From 동기화','default.vista.view','default','default')
    ,   ('e8167d54-1061-11f0-8e4c-52e9553a2057', 1, 'Vista', 0, 'Monitoring 작업 권한','기본 권한 From 동기화','default.vista.edit','default','default')
;

-- maestro.MSTR_ENDPOINT
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)
VALUES  ('0075d144-0070-11ef-8bb1-cee8dc1678f7','권한 타입 조회','권한 타입 조회','/authorities/types','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','authority','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('00761804-0070-11ef-8bb1-cee8dc1678f7','권한과 연결된 역할 목록 조회','권한과 연결된 역할 목록 조회','/authorities/connected-roles/{authorityId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','authority','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0076c9d4-0070-11ef-8bb1-cee8dc1678f7','워크스페이스 로드 밸런서 상세 조회 API','워크스페이스에 속한 로드 밸런서 상세 조회','/workspaces/load-balancers/{loadBalancerId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','load balancer','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('00a078bc-8439-11ee-a4fd-dadafdb14cb0','사용자 검색','사용자 검색','/user','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('00a0bcfd-8439-11ee-a4fd-dadafdb14cb0','사용자 상세 조회','사용자 상세 조회','/user/{userId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('00a101d4-8439-11ee-a4fd-dadafdb14cb0','계층 워크스페이스 속 사용자 목록 조회','계층 워크스페이스 속 사용자 목록 조회','/user/workspace/{workspaceId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('00a14aee-8439-11ee-a4fd-dadafdb14cb0','계층 폴더 속 사용자 목록 조회','계층 폴더 속 사용자 목록 조회','/user/folder/{folderId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('00a1962d-8439-11ee-a4fd-dadafdb14cb0','특정 폴더(혹은 조직) / 워크스페이스에서 승인 권한 가진 사용자 검색','특정 폴더(혹은 조직) / 워크스페이스에서 승인 권한 가진 사용자 검색','/user/approver','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('01378067-cc65-11ee-b44d-76e12e5221ff','수신자 전화번호 수정 API','수신자 전화번호 수정 API','/group/phone','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','notification','PUT',1,'dc347010-c3f4-11ee-8281-7e177595258d',0)
    ,   ('013f936c-16b7-11f0-8e4c-52e9553a2057','메뉴 관리에서 관리자/사용자 네비게이션 메뉴 목록 조회','메뉴 관리에서 관리자/사용자 네비게이션 메뉴 목록 조회','/menu/global','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','menu','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('015cfb00-01dc-11ef-8bb1-cee8dc1678f7','오브젝트 container에 대한 object 경로 API','오브젝트 container에 대한 object 경로 API','/swift/container/{name}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','swift','container','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('015d7085-01dc-11ef-8bb1-cee8dc1678f7','오브젝트 container detail API','오브젝트 container detail API','/swift/container/{name}/detail','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','swift','container','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('015e0c88-01dc-11ef-8bb1-cee8dc1678f7','오브젝트 container public API','오브젝트 container public API','/swift/container/public/{name}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','swift','container','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('015e48a5-01dc-11ef-8bb1-cee8dc1678f7','오브젝트 container meta-data API','오브젝트 container meta-data API','/swift/container/metadata/{name}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','swift','container','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('02cd9420-3394-11ef-9f42-5e230e3817dd','Volume 목록 checker','Volume 목록 checker','/volumes/duplicate-checker','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volumes','volume','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('03655632-ba98-11ee-afaf-76fb71c4f9db','공급자 클러스터 리스트 조회','공급자 클러스터 리스트 조회','/v1/provider/lists','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','provider','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('03c85035-2953-11ef-9f42-5e230e3817dd','Trombone Summary','Trombone Summary','/approval/cmp/sr/timeout','eeffe021-b1f6-11ee-b0d1-0242ac110002','Trombone','tromboneservice','trombonecategory','POST',1,'973e6aaf-27c1-11ef-9f42-5e230e3817dd',0)
    ,   ('03c8ec4b-2953-11ef-9f42-5e230e3817dd','Trombone Summary','Trombone Summary','/approval/cmp/sr/create','eeffe021-b1f6-11ee-b0d1-0242ac110002','Trombone','tromboneservice','trombonecategory','POST',1,'973e6aaf-27c1-11ef-9f42-5e230e3817dd',0)
    ,   ('044d70fb-ec0f-11ee-ac8e-c6591bb2a6db','admin-common : DELETE/provider-navigator/bookmark/providerSub/{providerSubId}','admin-common : DELETE/provider-navigator/bookmark/providerSub/{providerSubId}','/provider-navigator/bookmark/providerSub/{providerSubId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','provider','provider navigator','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('048af247-1990-11ef-bc41-1ecbd3ef6ccd','디플로이먼트 내 레플리카셋 변경','디플로이먼트 내 레플리카셋 변경','/v1/k8s/namespaces/{namespaceName}/deployments/{deploymentName}/replicas','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','deployment','PATCH',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)
VALUES  ('048b4929-1990-11ef-bc41-1ecbd3ef6ccd','공급자 프로젝트 등록','공급자 프로젝트 등록','/v1/workspace/register','345ae518-f857-11ed-921d-aa1950d374e1','Viola','infra','provider','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('048b9af9-1990-11ef-bc41-1ecbd3ef6ccd','공급자 토큰 발급','공급자 토큰 발급','/v1/provider/token','345ae518-f857-11ed-921d-aa1950d374e1','Viola','infra','provider','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('048be4af-1990-11ef-bc41-1ecbd3ef6ccd','클러스터 - 네임스페이스 리스트 조회','클러스터 - 네임스페이스 리스트 조회','/v1/provider/namespace','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','provider','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('048c2cac-1990-11ef-bc41-1ecbd3ef6ccd','공급자 클러스터 리스트 조회','공급자 클러스터 리스트 조회','/v1/provider/lists','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','provider','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('048c83a7-1990-11ef-bc41-1ecbd3ef6ccd','사용자 포탈 - 파드 리스트','사용자 포탈 - 파드 리스트','/v1/pods','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('048cd1a8-1990-11ef-bc41-1ecbd3ef6ccd','Harbor SystemInfo 조회','Harbor SystemInfo 조회','/v1/harbor/version','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','image','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('048d21b7-1990-11ef-bc41-1ecbd3ef6ccd','Harbor 이미지 리스트 조회','Harbor 이미지 리스트 조회','/v1/harbor/repo/list','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','image','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('048d6a79-1990-11ef-bc41-1ecbd3ef6ccd','Harbor 프로젝트 리스트 조회','Harbor 프로젝트 리스트 조회','/v1/harbor/projects','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','image','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('048dbb62-1990-11ef-bc41-1ecbd3ef6ccd','Harbor 프로젝트 리포지토리 리스트 조회','Harbor 프로젝트 리포지토리 리스트 조회','/v1/harbor/projects/{projectName}/repositories','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','image','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('048e0aa2-1990-11ef-bc41-1ecbd3ef6ccd','Vault에 저장된 Harbor url 조회','Vault에 저장된 Harbor url 조회','/v1/harbor/config/info','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','image','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('048e5ef2-1990-11ef-bc41-1ecbd3ef6ccd','Harbor 이미지-아티팩트 리스트 조회','Harbor 이미지-아티팩트 리스트 조회','/v1/harbor/artifact/list','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','image','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('048eb286-1990-11ef-bc41-1ecbd3ef6ccd','Harbor 이미지-이티팩트 상세 조회','Harbor 이미지-이티팩트 상세 조회','/v1/harbor/artifact/info','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','image','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('048f00f5-1990-11ef-bc41-1ecbd3ef6ccd','사용자 포탈 - 디플로이먼트 리스트','사용자 포탈 - 디플로이먼트 리스트','/v1/deployments','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('048f4fc3-1990-11ef-bc41-1ecbd3ef6ccd','임계치 설정 수정','임계치 설정 수정','/v1/criticalpoint/update','345ae518-f857-11ed-921d-aa1950d374e1','Viola','infra','critical point','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('048f9fe9-1990-11ef-bc41-1ecbd3ef6ccd','임계치 설정 리스트 조회','임계치 설정 리스트 조회','/v1/criticalpoint/list','345ae518-f857-11ed-921d-aa1950d374e1','Viola','infra','critical point','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('048fee5b-1990-11ef-bc41-1ecbd3ef6ccd','임계치 설정 상세 조회','임계치 설정 상세 조회','/v1/criticalpoint/detail','345ae518-f857-11ed-921d-aa1950d374e1','Viola','infra','critical point','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('04903bcc-1990-11ef-bc41-1ecbd3ef6ccd','임계치 설정 삭제','임계치 설정 삭제','/v1/criticalpoint/delete','345ae518-f857-11ed-921d-aa1950d374e1','Viola','infra','critical point','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('04908956-1990-11ef-bc41-1ecbd3ef6ccd','임계치 설정 생성','임계치 설정 생성','/v1/criticalpoint/create','345ae518-f857-11ed-921d-aa1950d374e1','Viola','infra','critical point','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0490e5b4-1990-11ef-bc41-1ecbd3ef6ccd','공급자 연결확인','공급자 연결확인','/v1/connection/test','345ae518-f857-11ed-921d-aa1950d374e1','Viola','infra','provider','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0491334b-1990-11ef-bc41-1ecbd3ef6ccd','쿠버네티스 자원 수정','쿠버네티스 자원 수정','/v1/common/putApi','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','kubernetes','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)
VALUES  ('04917e35-1990-11ef-bc41-1ecbd3ef6ccd','프로메테우스를 이용한 쿠버네티스 자원 이용량 조회','프로메테우스를 이용한 쿠버네티스 자원 이용량 조회','/v1/common/prometheusGetApi','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','prometheus','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0491d43e-1990-11ef-bc41-1ecbd3ef6ccd','쿠버네티스 자원 생성','쿠버네티스 자원 생성','/v1/common/postApi','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','kubernetes','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('04922785-1990-11ef-bc41-1ecbd3ef6ccd','쿠버네티스 자원 수정','쿠버네티스 자원 수정','/v1/common/patchApi','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','kubernetes','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('04927226-1990-11ef-bc41-1ecbd3ef6ccd','쿠버네티스 자원 조회','쿠버네티스 자원 조회','/v1/common/getApi','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','kubernetes','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0492b68f-1990-11ef-bc41-1ecbd3ef6ccd','쿠버네티스 자원 삭제','쿠버네티스 자원 삭제','/v1/common/deleteApi','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','kubernetes','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('049307df-1990-11ef-bc41-1ecbd3ef6ccd','디플로이먼트 내 레플리카셋 변경','디플로이먼트 내 레플리카셋 변경','/v1/namespaces/{namespaceName}/deployments/{deploymentName}/replicas','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','PATCH',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('049355d0-1990-11ef-bc41-1ecbd3ef6ccd','디플로이먼트 내 레플리카셋 변경','디플로이먼트 내 레플리카셋 변경','/v1/k8s/namespaces/{namespaceName}/deployments/{deploymentName}/replicas','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','deployment','PATCH',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0493a9e4-1990-11ef-bc41-1ecbd3ef6ccd','관리자 포탈 - 네임스페이스 하위 자원 존재 유무','관리자 포탈 - 네임스페이스 하위 자원 존재 유무','/v1/namespaces/{namespaceName}/resources','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','namespace','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('085cfe6b-86be-11ef-9a6b-ba8787afde77','traffic policy instances 조회','traffic policy instances 조회','/route53s/traffic-policy-instances','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('085e2305-86be-11ef-9a6b-ba8787afde77','Traffic Policy Instance 변경','Traffic Policy Instance 변경','/route53s/traffic-policy-instances','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('085e719a-86be-11ef-9a6b-ba8787afde77','Traffic Policy Instance 생성','Traffic Policy Instance 생성','/route53s/traffic-policy-instances','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('085eafb5-86be-11ef-9a6b-ba8787afde77','Traffic Policy Instance 삭제','Traffic Policy Instance 삭제','/route53s/traffic-policy-instances','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('085ef073-86be-11ef-9a6b-ba8787afde77','시작 템플릿 수정','시작 템플릿 수정','/ec2/launchtemplates/modify','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('085f4d6d-86be-11ef-9a6b-ba8787afde77','AutoScaling 그룹 수정','AutoScaling 그룹 수정','/autoscaling/provisioning/groups','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('085f8ea7-86be-11ef-9a6b-ba8787afde77','AutoScaling 그룹 생성','AutoScaling 그룹 생성','/autoscaling/provisioning/groups','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('085fc6a1-86be-11ef-9a6b-ba8787afde77','AutoScaling 그룹 삭제','AutoScaling 그룹 삭제','/autoscaling/provisioning/groups','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('085ffd45-86be-11ef-9a6b-ba8787afde77','서비스 쿼터 태그 생성','서비스 쿼터 태그 생성','/servicequotas/tags/provisioning','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','tag','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086041b5-86be-11ef-9a6b-ba8787afde77','서비스 쿼터 태그 삭제','서비스 쿼터 태그 삭제','/servicequotas/tags/provisioning','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','tag','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('08607b24-86be-11ef-9a6b-ba8787afde77','서비스 할당량 증가 요청','서비스 할당량 증가 요청','/servicequotas/provisioning','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0860b52b-86be-11ef-9a6b-ba8787afde77','서비스 할당량 증가 요청','서비스 할당량 증가 요청','/servicequotas/provisioning/request','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)
VALUES  ('08615f15-86be-11ef-9a6b-ba8787afde77','서비스 할당량 템플릿 연결','서비스 할당량 템플릿 연결','/servicequotas/provisioning/associate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0861993c-86be-11ef-9a6b-ba8787afde77','traffic policy versions 조회','traffic policy versions 조회','/route53s/traffic-policy-versions','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0861dbaf-86be-11ef-9a6b-ba8787afde77','Traffic Policy Version 생성','Traffic Policy Version 생성','/route53s/traffic-policy-versions','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('08621944-86be-11ef-9a6b-ba8787afde77','Traffic Policy 삭제','Traffic Policy 삭제','/route53s/traffic-policies','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('08625680-86be-11ef-9a6b-ba8787afde77','key 태그 추가','key 태그 추가','/kms/tag','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','kms','kms','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('08629436-86be-11ef-9a6b-ba8787afde77','key 태그 삭제','key 태그 삭제','/kms/tag','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','kms','kms','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0862cf08-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 목록 조회','LaunchTemplate 목록 조회','/ec2/launchtemplates','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('08630782-86be-11ef-9a6b-ba8787afde77','시작 템플릿 기본 버전 수정','시작 템플릿 기본 버전 수정','/ec2/launchtemplates','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('08633e0a-86be-11ef-9a6b-ba8787afde77','시작 템플릿 생성','시작 템플릿 생성','/ec2/launchtemplates','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086375f8-86be-11ef-9a6b-ba8787afde77','시작 템플릿 삭제','시작 템플릿 삭제','/ec2/launchtemplates','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0863af13-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 목록 조회','LaunchTemplate 목록 조회','/ec2/launchtemplates','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','OPTIONS',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086409e6-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 목록 조회','LaunchTemplate 목록 조회','/ec2/launchtemplates','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','HEAD',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086445f8-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 목록 조회','LaunchTemplate 목록 조회','/ec2/launchtemplates','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','PATCH',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('08648c91-86be-11ef-9a6b-ba8787afde77','시작 템플릿 버전 생성','시작 템플릿 버전 생성','/ec2/launchtemplates/version','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0864c255-86be-11ef-9a6b-ba8787afde77','로드밸런서 연결','로드밸런서 연결','/autoscaling/provisioning/groups/loadbalancer','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0864fa87-86be-11ef-9a6b-ba8787afde77','admin : DELETE/autoscaling/provisioning/groups/loadbalancer','admin : DELETE/autoscaling/provisioning/groups/loadbalancer','/autoscaling/provisioning/groups/loadbalancer','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086530ae-86be-11ef-9a6b-ba8787afde77','로드밸런서 타겟 그룹 연결','로드밸런서 타겟 그룹 연결','/autoscaling/provisioning/groups/loadbalancer/target-groups','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086568a3-86be-11ef-9a6b-ba8787afde77','admin : DELETE/autoscaling/provisioning/groups/loadbalancer/target-groups','admin : DELETE/autoscaling/provisioning/groups/loadbalancer/target-groups','/autoscaling/provisioning/groups/loadbalancer/target-groups','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0865b2be-86be-11ef-9a6b-ba8787afde77','Topology 조회','Topology 조회','/topology','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','topology','topology','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0865ec25-86be-11ef-9a6b-ba8787afde77','태그 목록 조회','태그 목록 조회','/servicequotas/tags/inquiry','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','tag','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)
VALUES  ('08661ffc-86be-11ef-9a6b-ba8787afde77','서비스 목록 조회','서비스 목록 조회','/servicequotas/inquiry/services','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0866542a-86be-11ef-9a6b-ba8787afde77','서비스 할당량 조회','서비스 할당량 조회','/servicequotas/inquiry/service-quota','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('08668bba-86be-11ef-9a6b-ba8787afde77','서비스 할당량 목록 조회','서비스 할당량 목록 조회','/servicequotas/inquiry/service-quotas','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0866c638-86be-11ef-9a6b-ba8787afde77','서비스 할당량 템플릿에서 할당량 증가 요청 목록 조회','서비스 할당량 템플릿에서 할당량 증가 요청 목록 조회','/servicequotas/inquiry/service-quota-increase-requests-in-template','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0867048e-86be-11ef-9a6b-ba8787afde77','서비스 할당량 템플릿에서 할당량 증가 요청 조회','서비스 할당량 템플릿에서 할당량 증가 요청 조회','/servicequotas/inquiry/service-quota-increase-request-from-template','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('08673d57-86be-11ef-9a6b-ba8787afde77','요청된 서비스 할당량 변경 조회','요청된 서비스 할당량 변경 조회','/servicequotas/inquiry/service-quota-change','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086776f3-86be-11ef-9a6b-ba8787afde77','요청된 서비스 할당량 변경 이력 목록 조회','요청된 서비스 할당량 변경 이력 목록 조회','/servicequotas/inquiry/requested-service-quota-change-history','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0867ab88-86be-11ef-9a6b-ba8787afde77','할당량에 따른 요청된 서비스 할당량 변경 이력 목록 조회','할당량에 따른 요청된 서비스 할당량 변경 이력 목록 조회','/servicequotas/inquiry/requested-service-quota-change-history-by-quota','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0867e044-86be-11ef-9a6b-ba8787afde77','AWS 기본 서비스 할당량 조회','AWS 기본 서비스 할당량 조회','/servicequotas/inquiry/basic-service-quota','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('08681339-86be-11ef-9a6b-ba8787afde77','AWS 기본 서비스 할당량 목록 조회','AWS 기본 서비스 할당량 목록 조회','/servicequotas/inquiry/aws-default-service-quotas','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('08684474-86be-11ef-9a6b-ba8787afde77','서비스 할당량 템플릿에 대한 연관성 조회','서비스 할당량 템플릿에 대한 연관성 조회','/servicequotas/inquiry/association','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('08687235-86be-11ef-9a6b-ba8787afde77','traffic policy instances by policy 조회','traffic policy instances by policy 조회','/route53s/traffic-policy-instances-by-policy','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0868a4f8-86be-11ef-9a6b-ba8787afde77','traffic policy instances by hosted zone 조회','traffic policy instances by hosted zone 조회','/route53s/traffic-policy-instances-by-hosted-zone','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086924c1-86be-11ef-9a6b-ba8787afde77','스냅샷 티어 상태 조회','스냅샷 티어 상태 조회','/compute/snapshots/tier/statuses/{snapshotId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','snapshot','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('08697fc9-86be-11ef-9a6b-ba8787afde77','내 소유 스냅샷 목록 조회','내 소유 스냅샷 목록 조회','/compute/snapshots/self','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','snapshot','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0869b539-86be-11ef-9a6b-ba8787afde77','퍼블릭 스냅샷 목록 조회','퍼블릭 스냅샷 목록 조회','/compute/snapshots/public','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','snapshot','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0869e58a-86be-11ef-9a6b-ba8787afde77','프라이빗 스냅샷 목록 조회','프라이빗 스냅샷 목록 조회','/compute/snapshots/private','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','snapshot','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086a1659-86be-11ef-9a6b-ba8787afde77','퍼블릭 스냅샷 목록 조회','퍼블릭 스냅샷 목록 조회','/compute/snapshots/locked','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','snapshot','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086a460d-86be-11ef-9a6b-ba8787afde77','빠른 스냅샷 복원 목록 조회','빠른 스냅샷 복원 목록 조회','/compute/snapshots/fast-restores/{snapshotId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','snapshot','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086a737e-86be-11ef-9a6b-ba8787afde77','스냅샷 어트리뷰트 조회','스냅샷 어트리뷰트 조회','/compute/snapshots/attribute/{snapshotId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','snapshot','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)
VALUES  ('086aad0e-86be-11ef-9a6b-ba8787afde77','admin : GET/autoscaling/groups/target-groups','admin : GET/autoscaling/groups/target-groups','/autoscaling/groups/target-groups','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086ae76d-86be-11ef-9a6b-ba8787afde77','admin : GET/autoscaling/groups/load-balancers','admin : GET/autoscaling/groups/load-balancers','/autoscaling/groups/load-balancers','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086b1dce-86be-11ef-9a6b-ba8787afde77','서비스 할당량 템플릿 해제','서비스 할당량 템플릿 해제','/servicequotas/provisioning/disassociate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086b5adf-86be-11ef-9a6b-ba8787afde77','서비스 할당량 증가 요청 삭제','서비스 할당량 증가 요청 삭제','/servicequotas/provisioning/delete','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086b8c09-86be-11ef-9a6b-ba8787afde77','시작 템플릿 버전 삭제','시작 템플릿 버전 삭제','/ec2/launchtemplates/version/delete','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086bbe9e-86be-11ef-9a6b-ba8787afde77','시작 템플릿 삭제','시작 템플릿 삭제','/ec2/launchtemplates/delete','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086bf1ae-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 버전 목록 조회','LaunchTemplate 버전 목록 조회','/ec2/launchtemplates/versions','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086c24e8-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 버전 목록 조회','LaunchTemplate 버전 목록 조회','/ec2/launchtemplates/versions','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086c5c0e-86be-11ef-9a6b-ba8787afde77','시작 템플릿 버전 생성','시작 템플릿 버전 생성','/ec2/launchtemplates/versions','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086c94ca-86be-11ef-9a6b-ba8787afde77','시작 템플릿 버전 삭제','시작 템플릿 버전 삭제','/ec2/launchtemplates/versions','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086cc786-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 버전 목록 조회','LaunchTemplate 버전 목록 조회','/ec2/launchtemplates/versions','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','OPTIONS',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086cf7af-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 버전 목록 조회','LaunchTemplate 버전 목록 조회','/ec2/launchtemplates/versions','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','HEAD',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086d2a76-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 버전 목록 조회','LaunchTemplate 버전 목록 조회','/ec2/launchtemplates/versions','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','PATCH',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086d64d2-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 데이터 조회','LaunchTemplate 데이터 조회','/ec2/launchtemplates/data','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086d9720-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 데이터 조회','LaunchTemplate 데이터 조회','/ec2/launchtemplates/data','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086dcd27-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 데이터 조회','LaunchTemplate 데이터 조회','/ec2/launchtemplates/data','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086e02d6-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 데이터 조회','LaunchTemplate 데이터 조회','/ec2/launchtemplates/data','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086e3257-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 데이터 조회','LaunchTemplate 데이터 조회','/ec2/launchtemplates/data','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','OPTIONS',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086e5d8c-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 데이터 조회','LaunchTemplate 데이터 조회','/ec2/launchtemplates/data','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','HEAD',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('086e8d22-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 데이터 조회','LaunchTemplate 데이터 조회','/ec2/launchtemplates/data','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','PATCH',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)
VALUES  ('086ec076-86be-11ef-9a6b-ba8787afde77','traffic policy instances 조회','traffic policy instances 조회','/route53s/traffic-policy-instances','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('086eec9a-86be-11ef-9a6b-ba8787afde77','Traffic Policy Instance 변경','Traffic Policy Instance 변경','/route53s/traffic-policy-instances','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('086f1b94-86be-11ef-9a6b-ba8787afde77','Traffic Policy Instance 생성','Traffic Policy Instance 생성','/route53s/traffic-policy-instances','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('086f4730-86be-11ef-9a6b-ba8787afde77','Traffic Policy Instance 삭제','Traffic Policy Instance 삭제','/route53s/traffic-policy-instances','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('086f7447-86be-11ef-9a6b-ba8787afde77','시작 템플릿 수정','시작 템플릿 수정','/ec2/launchtemplates/modify','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('086fa486-86be-11ef-9a6b-ba8787afde77','AutoScaling 그룹 수정','AutoScaling 그룹 수정','/autoscaling/provisioning/groups','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('086fd352-86be-11ef-9a6b-ba8787afde77','AutoScaling 그룹 생성','AutoScaling 그룹 생성','/autoscaling/provisioning/groups','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('087001da-86be-11ef-9a6b-ba8787afde77','AutoScaling 그룹 삭제','AutoScaling 그룹 삭제','/autoscaling/provisioning/groups','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('08703059-86be-11ef-9a6b-ba8787afde77','서비스 쿼터 태그 생성','서비스 쿼터 태그 생성','/servicequotas/tags/provisioning','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','tag','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('08706296-86be-11ef-9a6b-ba8787afde77','서비스 쿼터 태그 삭제','서비스 쿼터 태그 삭제','/servicequotas/tags/provisioning','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','tag','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('08708dca-86be-11ef-9a6b-ba8787afde77','서비스 할당량 증가 요청','서비스 할당량 증가 요청','/servicequotas/provisioning','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0870b798-86be-11ef-9a6b-ba8787afde77','서비스 할당량 증가 요청','서비스 할당량 증가 요청','/servicequotas/provisioning/request','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0870ea18-86be-11ef-9a6b-ba8787afde77','서비스 할당량 템플릿 연결','서비스 할당량 템플릿 연결','/servicequotas/provisioning/associate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('08711ecc-86be-11ef-9a6b-ba8787afde77','traffic policy versions 조회','traffic policy versions 조회','/route53s/traffic-policy-versions','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('08715104-86be-11ef-9a6b-ba8787afde77','Traffic Policy Version 생성','Traffic Policy Version 생성','/route53s/traffic-policy-versions','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('08718465-86be-11ef-9a6b-ba8787afde77','Traffic Policy 삭제','Traffic Policy 삭제','/route53s/traffic-policies','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0871b5d9-86be-11ef-9a6b-ba8787afde77','key 태그 추가','key 태그 추가','/kms/tag','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','kms','kms','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0871e2d1-86be-11ef-9a6b-ba8787afde77','key 태그 삭제','key 태그 삭제','/kms/tag','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','kms','kms','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('087219ac-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 목록 조회','LaunchTemplate 목록 조회','/ec2/launchtemplates','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('08724ce7-86be-11ef-9a6b-ba8787afde77','시작 템플릿 기본 버전 수정','시작 템플릿 기본 버전 수정','/ec2/launchtemplates','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)
VALUES  ('08727e54-86be-11ef-9a6b-ba8787afde77','시작 템플릿 생성','시작 템플릿 생성','/ec2/launchtemplates','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0872b0bb-86be-11ef-9a6b-ba8787afde77','시작 템플릿 삭제','시작 템플릿 삭제','/ec2/launchtemplates','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0872dc27-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 목록 조회','LaunchTemplate 목록 조회','/ec2/launchtemplates','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','OPTIONS',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('08730dc3-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 목록 조회','LaunchTemplate 목록 조회','/ec2/launchtemplates','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','HEAD',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('08733d09-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 목록 조회','LaunchTemplate 목록 조회','/ec2/launchtemplates','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','PATCH',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('08736aa6-86be-11ef-9a6b-ba8787afde77','시작 템플릿 버전 생성','시작 템플릿 버전 생성','/ec2/launchtemplates/version','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('08739883-86be-11ef-9a6b-ba8787afde77','로드밸런서 연결','로드밸런서 연결','/autoscaling/provisioning/groups/loadbalancer','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0873c3f3-86be-11ef-9a6b-ba8787afde77','user : DELETE/autoscaling/provisioning/groups/loadbalancer','user : DELETE/autoscaling/provisioning/groups/loadbalancer','/autoscaling/provisioning/groups/loadbalancer','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0873f6ad-86be-11ef-9a6b-ba8787afde77','로드밸런서 타겟 그룹 연결','로드밸런서 타겟 그룹 연결','/autoscaling/provisioning/groups/loadbalancer/target-groups','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('08743309-86be-11ef-9a6b-ba8787afde77','user : DELETE/autoscaling/provisioning/groups/loadbalancer/target-groups','user : DELETE/autoscaling/provisioning/groups/loadbalancer/target-groups','/autoscaling/provisioning/groups/loadbalancer/target-groups','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('087462f2-86be-11ef-9a6b-ba8787afde77','Topology 조회','Topology 조회','/topology','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','topology','topology','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('08749be7-86be-11ef-9a6b-ba8787afde77','태그 목록 조회','태그 목록 조회','/servicequotas/tags/inquiry','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','tag','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0874caee-86be-11ef-9a6b-ba8787afde77','서비스 목록 조회','서비스 목록 조회','/servicequotas/inquiry/services','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0874f86c-86be-11ef-9a6b-ba8787afde77','서비스 할당량 조회','서비스 할당량 조회','/servicequotas/inquiry/service-quota','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('087527c7-86be-11ef-9a6b-ba8787afde77','서비스 할당량 목록 조회','서비스 할당량 목록 조회','/servicequotas/inquiry/service-quotas','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('08755728-86be-11ef-9a6b-ba8787afde77','서비스 할당량 템플릿에서 할당량 증가 요청 목록 조회','서비스 할당량 템플릿에서 할당량 증가 요청 목록 조회','/servicequotas/inquiry/service-quota-increase-requests-in-template','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('08758428-86be-11ef-9a6b-ba8787afde77','서비스 할당량 템플릿에서 할당량 증가 요청 조회','서비스 할당량 템플릿에서 할당량 증가 요청 조회','/servicequotas/inquiry/service-quota-increase-request-from-template','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0875b07a-86be-11ef-9a6b-ba8787afde77','요청된 서비스 할당량 변경 조회','요청된 서비스 할당량 변경 조회','/servicequotas/inquiry/service-quota-change','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0875e8ce-86be-11ef-9a6b-ba8787afde77','요청된 서비스 할당량 변경 이력 목록 조회','요청된 서비스 할당량 변경 이력 목록 조회','/servicequotas/inquiry/requested-service-quota-change-history','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('08761897-86be-11ef-9a6b-ba8787afde77','할당량에 따른 요청된 서비스 할당량 변경 이력 목록 조회','할당량에 따른 요청된 서비스 할당량 변경 이력 목록 조회','/servicequotas/inquiry/requested-service-quota-change-history-by-quota','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)
VALUES  ('08764daa-86be-11ef-9a6b-ba8787afde77','AWS 기본 서비스 할당량 조회','AWS 기본 서비스 할당량 조회','/servicequotas/inquiry/basic-service-quota','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('08767da5-86be-11ef-9a6b-ba8787afde77','AWS 기본 서비스 할당량 목록 조회','AWS 기본 서비스 할당량 목록 조회','/servicequotas/inquiry/aws-default-service-quotas','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0876ab70-86be-11ef-9a6b-ba8787afde77','서비스 할당량 템플릿에 대한 연관성 조회','서비스 할당량 템플릿에 대한 연관성 조회','/servicequotas/inquiry/association','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0876dde2-86be-11ef-9a6b-ba8787afde77','traffic policy instances by policy 조회','traffic policy instances by policy 조회','/route53s/traffic-policy-instances-by-policy','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('08770d60-86be-11ef-9a6b-ba8787afde77','traffic policy instances by hosted zone 조회','traffic policy instances by hosted zone 조회','/route53s/traffic-policy-instances-by-hosted-zone','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('08777540-86be-11ef-9a6b-ba8787afde77','스냅샷 티어 상태 조회','스냅샷 티어 상태 조회','/compute/snapshots/tier/statuses/{snapshotId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','snapshot','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0877a601-86be-11ef-9a6b-ba8787afde77','내 소유 스냅샷 목록 조회','내 소유 스냅샷 목록 조회','/compute/snapshots/self','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','snapshot','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0877d685-86be-11ef-9a6b-ba8787afde77','퍼블릭 스냅샷 목록 조회','퍼블릭 스냅샷 목록 조회','/compute/snapshots/public','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','snapshot','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0878072a-86be-11ef-9a6b-ba8787afde77','프라이빗 스냅샷 목록 조회','프라이빗 스냅샷 목록 조회','/compute/snapshots/private','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','snapshot','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('087835c6-86be-11ef-9a6b-ba8787afde77','퍼블릭 스냅샷 목록 조회','퍼블릭 스냅샷 목록 조회','/compute/snapshots/locked','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','snapshot','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('08786334-86be-11ef-9a6b-ba8787afde77','빠른 스냅샷 복원 목록 조회','빠른 스냅샷 복원 목록 조회','/compute/snapshots/fast-restores/{snapshotId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','snapshot','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0878dbb4-86be-11ef-9a6b-ba8787afde77','스냅샷 어트리뷰트 조회','스냅샷 어트리뷰트 조회','/compute/snapshots/attribute/{snapshotId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','snapshot','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('087909da-86be-11ef-9a6b-ba8787afde77','user : GET/autoscaling/groups/target-groups','user : GET/autoscaling/groups/target-groups','/autoscaling/groups/target-groups','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('087934c2-86be-11ef-9a6b-ba8787afde77','user : GET/autoscaling/groups/load-balancers','user : GET/autoscaling/groups/load-balancers','/autoscaling/groups/load-balancers','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('08795fe5-86be-11ef-9a6b-ba8787afde77','서비스 할당량 템플릿 해제','서비스 할당량 템플릿 해제','/servicequotas/provisioning/disassociate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('08799801-86be-11ef-9a6b-ba8787afde77','서비스 할당량 증가 요청 삭제','서비스 할당량 증가 요청 삭제','/servicequotas/provisioning/delete','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0879c31e-86be-11ef-9a6b-ba8787afde77','시작 템플릿 버전 삭제','시작 템플릿 버전 삭제','/ec2/launchtemplates/version/delete','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0879eebd-86be-11ef-9a6b-ba8787afde77','시작 템플릿 삭제','시작 템플릿 삭제','/ec2/launchtemplates/delete','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('087a1de9-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 버전 목록 조회','LaunchTemplate 버전 목록 조회','/ec2/launchtemplates/versions','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('087a4ea5-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 버전 목록 조회','LaunchTemplate 버전 목록 조회','/ec2/launchtemplates/versions','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)
VALUES  ('087a8216-86be-11ef-9a6b-ba8787afde77','시작 템플릿 버전 생성','시작 템플릿 버전 생성','/ec2/launchtemplates/versions','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('087ab098-86be-11ef-9a6b-ba8787afde77','시작 템플릿 버전 삭제','시작 템플릿 버전 삭제','/ec2/launchtemplates/versions','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('087ade1d-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 버전 목록 조회','LaunchTemplate 버전 목록 조회','/ec2/launchtemplates/versions','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','OPTIONS',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('087b102c-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 버전 목록 조회','LaunchTemplate 버전 목록 조회','/ec2/launchtemplates/versions','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','HEAD',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('087b3bdf-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 버전 목록 조회','LaunchTemplate 버전 목록 조회','/ec2/launchtemplates/versions','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','PATCH',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('087b663f-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 데이터 조회','LaunchTemplate 데이터 조회','/ec2/launchtemplates/data','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('087b9240-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 데이터 조회','LaunchTemplate 데이터 조회','/ec2/launchtemplates/data','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('087bc3fc-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 데이터 조회','LaunchTemplate 데이터 조회','/ec2/launchtemplates/data','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('087bf1f4-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 데이터 조회','LaunchTemplate 데이터 조회','/ec2/launchtemplates/data','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('087c1d06-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 데이터 조회','LaunchTemplate 데이터 조회','/ec2/launchtemplates/data','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','OPTIONS',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('087c4ab5-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 데이터 조회','LaunchTemplate 데이터 조회','/ec2/launchtemplates/data','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','HEAD',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('087c797d-86be-11ef-9a6b-ba8787afde77','LaunchTemplate 데이터 조회','LaunchTemplate 데이터 조회','/ec2/launchtemplates/data','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','PATCH',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0a7b6ba9-1990-11ef-bc41-1ecbd3ef6ccd','user : GET/price/test','user : GET/price/test','/price/test','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','billing','month','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('0a7e3ac5-0ebd-11f0-8e4c-52e9553a2057','클러스터 생성: 프로젝트별 리소스 필터링','클러스터 생성: 프로젝트별 리소스 필터링','/v1/k8s/management/clusters/configuration/projects/resources','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0a80e3b2-0ebd-11f0-8e4c-52e9553a2057','클러스터 생성: 프로젝트별 리소스 필터링','클러스터 생성: 프로젝트별 리소스 필터링','/v1/k8s/management/clusters/configuration/projects/resources','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0ac1dfc8-1517-11f0-8e4c-52e9553a2057','IP Pool Physical 삭제','IP Pool Physical 삭제','/ip-pool/physicals/{ipPoolPhysicalId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','ip pool physical','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0afe5346-6e76-11ef-aa9f-f2cdef6842ce','공유 파일 시스템 타입 스펙 수정/삭제','공유 파일 시스템 타입 스펙 수정/삭제','/manila/shares/types/{shareTypeId}/spec','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0afeb4b8-6e76-11ef-aa9f-f2cdef6842ce','공유 파일 시스템 타입 삭제','공유 파일 시스템 타입 삭제','/manila/shares/types','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0aff4e93-6e76-11ef-aa9f-f2cdef6842ce','인스턴스 유형 프로젝트 접근 권한 수정 API','인스턴스 유형 프로젝트 접근 권한 수정 API','/compute/flavors/{flavorId}/access','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','flavor','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0affa65f-6e76-11ef-aa9f-f2cdef6842ce','공유 파일 시스템 타입 스펙 수정/삭제','공유 파일 시스템 타입 스펙 수정/삭제','/manila/shares/types/{shareTypeId}/spec','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','PUT',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)
VALUES  ('0affda8a-6e76-11ef-aa9f-f2cdef6842ce','공유 파일 시스템 타입 삭제','공유 파일 시스템 타입 삭제','/manila/shares/types','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','DELETE',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('0b0011cf-6e76-11ef-aa9f-f2cdef6842ce','인스턴스 유형 프로젝트 접근 권한 수정 API','인스턴스 유형 프로젝트 접근 권한 수정 API','/compute/flavors/{flavorId}/access','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','flavor','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('0b0dd9fd-03cb-11f0-b506-82bf7ec01e38','공급자 클러스터 상세 조회','공급자 클러스터 상세 조회','/v2/providers/{providerId}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','provider','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0b0e9c2e-03cb-11f0-b506-82bf7ec01e38','공급자 클러스터 수정','공급자 클러스터 수정','/v2/providers/{providerId}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','provider','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0b0eeb5e-03cb-11f0-b506-82bf7ec01e38','공급자 클러스터 삭제','공급자 클러스터 삭제','/v2/providers/{providerId}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','provider','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0b0f12ff-03cb-11f0-b506-82bf7ec01e38','StorageClass 상세 조회','StorageClass 상세 조회','/v1/k8s/storage-class/{storageClassName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','storageclass','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0b0f4c8e-03cb-11f0-b506-82bf7ec01e38','StorageClass 수정','StorageClass 수정','/v1/k8s/storage-class/{storageClassName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','storageclass','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0b0f6f89-03cb-11f0-b506-82bf7ec01e38','노드 수정','노드 수정','/v1/k8s/nodes/{nodeName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','node','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0b0f9472-03cb-11f0-b506-82bf7ec01e38','노드 Cordon 수정','노드 Cordon 수정','/v1/k8s/nodes/{nodeName}/cordon','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','node','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0b0fbdcc-03cb-11f0-b506-82bf7ec01e38','노드 Labels 수정','노드 Labels 수정','/v1/k8s/nodes/labels','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','node','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0b0fe087-03cb-11f0-b506-82bf7ec01e38','공급자 클러스터 리스트 조회','공급자 클러스터 리스트 조회','/v2/providers','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','provider','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0b1002e6-03cb-11f0-b506-82bf7ec01e38','공급자 클러스터 생성','공급자 클러스터 생성','/v2/providers','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','provider','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0b102679-03cb-11f0-b506-82bf7ec01e38','공급자 클러스터 연결 확인','공급자 클러스터 연결 확인','/v2/providers/connection','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','provider','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0b104774-03cb-11f0-b506-82bf7ec01e38','StorageClass 리스트 조회','StorageClass 리스트 조회','/v1/k8s/storage-class','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','storageclass','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0b10716f-03cb-11f0-b506-82bf7ec01e38','StorageClass 생성','StorageClass 생성','/v1/k8s/storage-class','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','storageclass','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0b109ca1-03cb-11f0-b506-82bf7ec01e38','디플로이먼트 Rollout Restart','디플로이먼트 Rollout Restart','/v1/k8s/namespaces/{namespaceName}/deployments/{deploymentName}/rollout','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','deployment','PATCH',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0b10e3eb-03cb-11f0-b506-82bf7ec01e38','공급자 클러스터 리스트 조회','공급자 클러스터 리스트 조회','/v2/providers/namespaces','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','provider','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0b11193c-03cb-11f0-b506-82bf7ec01e38','공급자 클러스터 이름 중복 체크','공급자 클러스터 이름 중복 체크','/v2/providers/check-name','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','provider','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0b113c48-03cb-11f0-b506-82bf7ec01e38','StorageClass 사용 PVC 조회','StorageClass 사용 PVC 조회','/v1/k8s/storage-class/{storageClassName}/pvc','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','storageclass','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0b115872-03cb-11f0-b506-82bf7ec01e38','컨테이너 로그 다운로드','컨테이너 로그 다운로드','/v1/k8s/namespaces/{namespaceName}/pods/{podName}/containers/{containerName}/log','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','pod','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)
VALUES  ('0b11af1e-03cb-11f0-b506-82bf7ec01e38','멀티 클러스터 스토리지 클래스 조회','멀티 클러스터 스토리지 클래스 조회','/v1/k8s/multi-cluster/storage-class','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','storageclass','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0b11ff23-03cb-11f0-b506-82bf7ec01e38','StorageClass 삭제','StorageClass 삭제','/v1/k8s/multi-cluster/storage-class','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','storageclass','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0b122465-03cb-11f0-b506-82bf7ec01e38','공급자 클러스터 상세 조회','공급자 클러스터 상세 조회','/v2/providers/{providerId}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','provider','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0b124c4c-03cb-11f0-b506-82bf7ec01e38','공급자 클러스터 수정','공급자 클러스터 수정','/v2/providers/{providerId}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','provider','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0b127269-03cb-11f0-b506-82bf7ec01e38','공급자 클러스터 삭제','공급자 클러스터 삭제','/v2/providers/{providerId}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','provider','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0b129389-03cb-11f0-b506-82bf7ec01e38','StorageClass 상세 조회','StorageClass 상세 조회','/v1/k8s/storage-class/{storageClassName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','storageclass','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0b12b415-03cb-11f0-b506-82bf7ec01e38','StorageClass 수정','StorageClass 수정','/v1/k8s/storage-class/{storageClassName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','storageclass','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0b12d080-03cb-11f0-b506-82bf7ec01e38','노드 수정','노드 수정','/v1/k8s/nodes/{nodeName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','node','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0b12ec40-03cb-11f0-b506-82bf7ec01e38','노드 Cordon 수정','노드 Cordon 수정','/v1/k8s/nodes/{nodeName}/cordon','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','node','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0b1305d6-03cb-11f0-b506-82bf7ec01e38','노드 Labels 수정','노드 Labels 수정','/v1/k8s/nodes/labels','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','node','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0b131f7b-03cb-11f0-b506-82bf7ec01e38','공급자 클러스터 리스트 조회','공급자 클러스터 리스트 조회','/v2/providers','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','provider','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0b1345d4-03cb-11f0-b506-82bf7ec01e38','공급자 클러스터 생성','공급자 클러스터 생성','/v2/providers','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','provider','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0b1364e1-03cb-11f0-b506-82bf7ec01e38','공급자 클러스터 연결 확인','공급자 클러스터 연결 확인','/v2/providers/connection','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','provider','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0b13840b-03cb-11f0-b506-82bf7ec01e38','StorageClass 리스트 조회','StorageClass 리스트 조회','/v1/k8s/storage-class','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','storageclass','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0b13b465-03cb-11f0-b506-82bf7ec01e38','StorageClass 생성','StorageClass 생성','/v1/k8s/storage-class','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','storageclass','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0b13d489-03cb-11f0-b506-82bf7ec01e38','디플로이먼트 Rollout Restart','디플로이먼트 Rollout Restart','/v1/k8s/namespaces/{namespaceName}/deployments/{deploymentName}/rollout','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','deployment','PATCH',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0b13f44b-03cb-11f0-b506-82bf7ec01e38','공급자 클러스터 리스트 조회','공급자 클러스터 리스트 조회','/v2/providers/namespaces','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','provider','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0b141649-03cb-11f0-b506-82bf7ec01e38','공급자 클러스터 이름 중복 체크','공급자 클러스터 이름 중복 체크','/v2/providers/check-name','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','provider','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0b144525-03cb-11f0-b506-82bf7ec01e38','StorageClass 사용 PVC 조회','StorageClass 사용 PVC 조회','/v1/k8s/storage-class/{storageClassName}/pvc','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','storageclass','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0b146800-03cb-11f0-b506-82bf7ec01e38','컨테이너 로그 다운로드','컨테이너 로그 다운로드','/v1/k8s/namespaces/{namespaceName}/pods/{podName}/containers/{containerName}/log','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','pod','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)
VALUES  ('0b148678-03cb-11f0-b506-82bf7ec01e38','멀티 클러스터 스토리지 클래스 조회','멀티 클러스터 스토리지 클래스 조회','/v1/k8s/multi-cluster/storage-class','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','storageclass','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0b14a5cf-03cb-11f0-b506-82bf7ec01e38','StorageClass 삭제','StorageClass 삭제','/v1/k8s/multi-cluster/storage-class','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','storageclass','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0b673098-b0e9-11ee-94e4-eea823231fc8','특정 공유 파일 시스템 규칙 전체 목록 상세 정보 조회','특정 공유 파일 시스템 규칙 전체 목록 상세 정보 조회','/manila/shares/list-access/{shareId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0c141737-8643-11ef-9a6b-ba8787afde77','서비스 신청 실행','서비스 신청 실행','/services/{serviceRequestId}/execute','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('0c348066-f8b8-11ef-b6a6-1a18cace67cc','RGW 사용자 상세 조회','RGW 사용자 상세 조회','/api/rgw/user/{uid}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','user','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c35dceb-f8b8-11ef-b6a6-1a18cace67cc','RGW 사용자 수정','RGW 사용자 수정','/api/rgw/user/{uid}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','user','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c362a0c-f8b8-11ef-b6a6-1a18cace67cc','RGW 사용자 삭제','RGW 사용자 삭제','/api/rgw/user/{uid}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','user','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c366e0e-f8b8-11ef-b6a6-1a18cace67cc','RGW 사용자 역할 수정','RGW 사용자 역할 수정','/api/rgw/user/role','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','role','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c36a753-f8b8-11ef-b6a6-1a18cace67cc','RGW 사용자 역할 생성','RGW 사용자 역할 생성','/api/rgw/user/role','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','role','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c36e059-f8b8-11ef-b6a6-1a18cace67cc','오브젝트 NFS 상세 조회','오브젝트 NFS 상세 조회','/api/rgw/nfs/{clusterId}/{exportId}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','nfs','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c3713b1-f8b8-11ef-b6a6-1a18cace67cc','오브젝트 NFS 수정','오브젝트 NFS 수정','/api/rgw/nfs/{clusterId}/{exportId}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','nfs','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c37967e-f8b8-11ef-b6a6-1a18cace67cc','오브젝트 NFS 삭제','오브젝트 NFS 삭제','/api/rgw/nfs/{clusterId}/{exportId}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','nfs','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c37dc10-f8b8-11ef-b6a6-1a18cace67cc','Update Zone Group','Update Zone Group','/api/rgw/multisite/zonegroup/{zonegroupName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c3811ee-f8b8-11ef-b6a6-1a18cace67cc','Delete Zonegroup','Delete Zonegroup','/api/rgw/multisite/zonegroup/{zonegroupName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c38419c-f8b8-11ef-b6a6-1a18cace67cc','Update Zone','Update Zone','/api/rgw/multisite/zone/{zoneName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c386922-f8b8-11ef-b6a6-1a18cace67cc','Get sync Policy','Get sync Policy','/api/rgw/multisite/sync-policy','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c389fe7-f8b8-11ef-b6a6-1a18cace67cc','Update Sync Policy','Update Sync Policy','/api/rgw/multisite/sync-policy','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c38cfa7-f8b8-11ef-b6a6-1a18cace67cc','Create Sync Policy Group','Create Sync Policy Group','/api/rgw/multisite/sync-policy','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c3903c2-f8b8-11ef-b6a6-1a18cace67cc','Update Sync Pipe','Update Sync Pipe','/api/rgw/multisite/sync-pipe','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c393ec1-f8b8-11ef-b6a6-1a18cace67cc','Update Sync Flow','Update Sync Flow','/api/rgw/multisite/sync-flow','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api) 
VALUES  ('0c39793c-f8b8-11ef-b6a6-1a18cace67cc','Update Realm','Update Realm','/api/rgw/multisite/realm/{realmName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c39ab71-f8b8-11ef-b6a6-1a18cace67cc','Delete Realm','Delete Realm','/api/rgw/multisite/realm/{realmName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c39de2f-f8b8-11ef-b6a6-1a18cace67cc','Migrate Multisite','Migrate Multisite','/api/rgw/multisite/migrate','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c3a07b6-f8b8-11ef-b6a6-1a18cace67cc','RGW 버킷 조회','RGW 버킷 조회','/api/rgw/bucket/{bucketName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','bucket','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c3a2dfc-f8b8-11ef-b6a6-1a18cace67cc','RGW 버킷 수정','RGW 버킷 수정','/api/rgw/bucket/{bucketName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','bucket','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c3a66c4-f8b8-11ef-b6a6-1a18cace67cc','RGW 버킷 삭제','RGW 버킷 삭제','/api/rgw/bucket/{bucketName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','bucket','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c3a90f0-f8b8-11ef-b6a6-1a18cace67cc','Get a RBD Mirroring sitename','Get a RBD Mirroring sitename','/api/rbd/mirroring/site-name','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','mirroring','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c3ab54f-f8b8-11ef-b6a6-1a18cace67cc','Update RBD Mirroring sitename','Update RBD Mirroring sitename','/api/rbd/mirroring/site-name','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','mirroring','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c3addfe-f8b8-11ef-b6a6-1a18cace67cc','Get RBD Mirroring Pool`s Peer Info','Get RBD Mirroring Pool`s Peer Info','/api/rbd/mirroring/pool/{poolName}/peer/{peerUuid}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','mirroring','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c3b0c35-f8b8-11ef-b6a6-1a18cace67cc','Update RBD Mirroring Pool`s Peer Info','Update RBD Mirroring Pool`s Peer Info','/api/rbd/mirroring/pool/{poolName}/peer/{peerUuid}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','mirroring','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c3b44b6-f8b8-11ef-b6a6-1a18cace67cc','Delete RBD Mirroring Pool`s Peer Info','Delete RBD Mirroring Pool`s Peer Info','/api/rbd/mirroring/pool/{poolName}/peer/{peerUuid}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','mirroring','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c3bbcf6-f8b8-11ef-b6a6-1a18cace67cc','Update RBD Mirroring MirrorMode','Update RBD Mirroring MirrorMode','/api/rbd/mirroring/pool/{poolName}/mirror-mode','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','mirroring','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c3bf9b2-f8b8-11ef-b6a6-1a18cace67cc','RBD iSCSI Update Target','RBD iSCSI Update Target','/api/rbd/iscsi/target/{targetIqn}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','iscsi','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c3c3252-f8b8-11ef-b6a6-1a18cace67cc','Toggle Write Mode Image By PoolName/Namespace(생략가능)/ImageName','Toggle Write Mode Image By PoolName/Namespace(생략가능)/ImageName','/api/rbd/image/{poolName}/{namespace}/{imageName}/write-mode','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c3c6a3e-f8b8-11ef-b6a6-1a18cace67cc','Toggle Write Mode Image By PoolName/Namespace(생략가능)/ImageName','Toggle Write Mode Image By PoolName/Namespace(생략가능)/ImageName','/api/rbd/image/{poolName}/{imageName}/write-mode','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c3ca9a6-f8b8-11ef-b6a6-1a18cace67cc','Protect/Unprotect Snapshot Image','Protect/Unprotect Snapshot Image','/api/rbd/image/{poolName}/{namespace}/{imageName}/snapshot/{snapshotName}/protect','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c3cf355-f8b8-11ef-b6a6-1a18cace67cc','Protect/Unprotect Snapshot Image','Protect/Unprotect Snapshot Image','/api/rbd/image/{poolName}/{imageName}/snapshot/{snapshotName}/protect','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c3d1efc-f8b8-11ef-b6a6-1a18cace67cc','Create Snapshot Image','Create Snapshot Image','/api/rbd/image/{poolName}/{namespace}/{imageName}/snapshot/{snapshotName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c3d4df4-f8b8-11ef-b6a6-1a18cace67cc','Delete Snapshot Image','Delete Snapshot Image','/api/rbd/image/{poolName}/{namespace}/{imageName}/snapshot/{snapshotName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c3e4ce5-f8b8-11ef-b6a6-1a18cace67cc','Create Snapshot Image','Create Snapshot Image','/api/rbd/image/{poolName}/{imageName}/snapshot/{snapshotName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api) 
VALUES  ('0c3f391e-f8b8-11ef-b6a6-1a18cace67cc','Delete Snapshot Image','Delete Snapshot Image','/api/rbd/image/{poolName}/{imageName}/snapshot/{snapshotName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c40c3d0-f8b8-11ef-b6a6-1a18cace67cc','Resync Image By PoolName/Namespace(생략가능)/ImageName','Resync Image By PoolName/Namespace(생략가능)/ImageName','/api/rbd/image/{poolName}/{namespace}/{imageName}/resync','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c416355-f8b8-11ef-b6a6-1a18cace67cc','Resync Image By PoolName/Namespace(생략가능)/ImageName','Resync Image By PoolName/Namespace(생략가능)/ImageName','/api/rbd/image/{poolName}/{imageName}/resync','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c419903-f8b8-11ef-b6a6-1a18cace67cc','Remove Image Schedule By PoolName/Namespace(생략가능)/ImageName','Remove Image Schedule By PoolName/Namespace(생략가능)/ImageName','/api/rbd/image/{poolName}/{namespace}/{imageName}/remove-schedule','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c41c6d4-f8b8-11ef-b6a6-1a18cace67cc','Remove Image Schedule By PoolName/Namespace(생략가능)/ImageName','Remove Image Schedule By PoolName/Namespace(생략가능)/ImageName','/api/rbd/image/{poolName}/{imageName}/remove-schedule','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c41ef2a-f8b8-11ef-b6a6-1a18cace67cc','Update Image By PoolName/Namespace(생략가능)/ImageName','Update Image By PoolName/Namespace(생략가능)/ImageName','/api/rbd/image/{poolName}/{namespace}/{imageName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c42197a-f8b8-11ef-b6a6-1a18cace67cc','Delete Image By PoolName/Namespace(생략가능)/ImageName','Delete Image By PoolName/Namespace(생략가능)/ImageName','/api/rbd/image/{poolName}/{namespace}/{imageName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c43089d-f8b8-11ef-b6a6-1a18cace67cc','Update Image By PoolName/Namespace(생략가능)/ImageName','Update Image By PoolName/Namespace(생략가능)/ImageName','/api/rbd/image/{poolName}/{imageName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c459acb-f8b8-11ef-b6a6-1a18cace67cc','Delete Image By PoolName/Namespace(생략가능)/ImageName','Delete Image By PoolName/Namespace(생략가능)/ImageName','/api/rbd/image/{poolName}/{imageName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c46064c-f8b8-11ef-b6a6-1a18cace67cc','Get pool mirror mode','Get pool mirror mode','/api/rbd/image/pool/{poolName}/mirroring','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c463e04-f8b8-11ef-b6a6-1a18cace67cc','Update pool mirror mode','Update pool mirror mode','/api/rbd/image/pool/{poolName}/mirroring','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c46668a-f8b8-11ef-b6a6-1a18cace67cc','NFS 수정','NFS 수정','/api/file/nfs/{clusterId}/{id}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','nfs','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4690ed-f8b8-11ef-b6a6-1a18cace67cc','NFS 삭제','NFS 삭제','/api/file/nfs/{clusterId}/{id}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','nfs','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c46c529-f8b8-11ef-b6a6-1a18cace67cc','FileSystem Info 수정','FileSystem Info 수정','/api/file/fs','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c46e959-f8b8-11ef-b6a6-1a18cace67cc','FileSystem 생성','FileSystem 생성','/api/file/fs','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c470d0e-f8b8-11ef-b6a6-1a18cace67cc','FileSystem update subvolume','FileSystem update subvolume','/api/file/fs/subvolume/{volName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4754ee-f8b8-11ef-b6a6-1a18cace67cc','FileSystem delete subvolume','FileSystem delete subvolume','/api/file/fs/subvolume/{volName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c47bc27-f8b8-11ef-b6a6-1a18cace67cc','Subvolume group update','Subvolume group update','/api/file/fs/subvolume/group','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','system','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c47f5d9-f8b8-11ef-b6a6-1a18cace67cc','Subvolume group create','Subvolume group create','/api/file/fs/subvolume/group','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','system','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4819c3-f8b8-11ef-b6a6-1a18cace67cc','FileSystem get snapshot schedule','FileSystem get snapshot schedule','/api/file/fs/snapshot/schedule/{fs}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)
VALUES  ('0c483c39-f8b8-11ef-b6a6-1a18cace67cc','FileSystem update snapshot schedule','FileSystem update snapshot schedule','/api/file/fs/snapshot/schedule/{fs}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c486689-f8b8-11ef-b6a6-1a18cace67cc','FileSystem delete snapshot schedule','FileSystem delete snapshot schedule','/api/file/fs/snapshot/schedule/{fs}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c488d25-f8b8-11ef-b6a6-1a18cace67cc','FileSystem auth info','FileSystem auth info','/api/file/fs/auth','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c499a43-f8b8-11ef-b6a6-1a18cace67cc','Get User list','Get User list','/api/cluster/user','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','administration','user','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4a1b48-f8b8-11ef-b6a6-1a18cace67cc','update cluster user','update cluster user','/api/cluster/user','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','administration','user','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4a55dc-f8b8-11ef-b6a6-1a18cace67cc','create/import cluster user','create/import cluster user','/api/cluster/user','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','administration','user','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4a8839-f8b8-11ef-b6a6-1a18cace67cc','Update service','Update service','/api/cluster/service/{serviceName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','administration','service','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4addac-f8b8-11ef-b6a6-1a18cace67cc','Delete service','Delete service','/api/cluster/service/{serviceName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','administration','service','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4b4c49-f8b8-11ef-b6a6-1a18cace67cc','Update daemon status','Update daemon status','/api/cluster/service/daemon/{daemonName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','administration','service','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4b78f4-f8b8-11ef-b6a6-1a18cace67cc','Update Pool','Update Pool','/api/cluster/pool/{poolName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','pool','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4b9fc9-f8b8-11ef-b6a6-1a18cace67cc','Delete Pool','Delete Pool','/api/cluster/pool/{poolName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','pool','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4bc1be-b2c7-11ef-97f1-9e78f0b36502','가상 네트워크 공급자별 조회','가상 네트워크 공급자별 조회','/topology/virtual-network/{providerId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','topology','virtual-network','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0c4bc8bd-f8b8-11ef-b6a6-1a18cace67cc','Update OSD','Update OSD','/api/cluster/osd/{id}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4bec85-f8b8-11ef-b6a6-1a18cace67cc','Delete OSD','Delete OSD','/api/cluster/osd/{id}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4c0ddc-f8b8-11ef-b6a6-1a18cace67cc','Update OSD reweight','Update OSD reweight','/api/cluster/osd/{id}/reweight','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4c2c04-f8b8-11ef-b6a6-1a18cace67cc','Update OSD mark','Update OSD mark','/api/cluster/osd/{id}/mark','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4c4778-f8b8-11ef-b6a6-1a18cace67cc','Get Recovery Priority','Get Recovery Priority','/api/cluster/osd/recovery-priority','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4c5429-b2c7-11ef-97f1-9e78f0b36502','가상 네트워크 호스트별 조회','가상 네트워크 호스트별 조회','/topology/virtual-network/host/{providerId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','topology','virtual-network','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0c4c6ea3-f8b8-11ef-b6a6-1a18cace67cc','Update Recovery Priority','Update Recovery Priority','/api/cluster/osd/recovery-priority','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4c9398-f8b8-11ef-b6a6-1a18cace67cc','Get PG scrub options','Get PG scrub options','/api/cluster/osd/pg-scrub','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api) 
VALUES  ('0c4c9f07-b2c7-11ef-97f1-9e78f0b36502','가상 네트워크 공급자별 조회','가상 네트워크 공급자별 조회','/topology/virtual-network/{providerId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','topology','virtual-network','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('0c4cb44f-f8b8-11ef-b6a6-1a18cace67cc','Update PG scrub options','Update PG scrub options','/api/cluster/osd/pg-scrub','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4cb86d-b2c7-11ef-97f1-9e78f0b36502','가상 네트워크 호스트별 조회','가상 네트워크 호스트별 조회','/topology/virtual-network/host/{providerId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','topology','virtual-network','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('0c4cd223-f8b8-11ef-b6a6-1a18cace67cc','Update PG scrub options','Update PG scrub options','/api/cluster/osd/pg-scrub/advanced','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4cfd87-f8b8-11ef-b6a6-1a18cace67cc','Get OSD flags','Get OSD flags','/api/cluster/osd/flags','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4d379e-f8b8-11ef-b6a6-1a18cace67cc','Update OSD flags','Update OSD flags','/api/cluster/osd/flags','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4d6364-f8b8-11ef-b6a6-1a18cace67cc','Update OSD flags individually','Update OSD flags individually','/api/cluster/osd/flags/individual','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4d83eb-f8b8-11ef-b6a6-1a18cace67cc','Alert silence 수정','Alert silence 수정','/api/cluster/monitoring/silence','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','observability','alerts','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4db16a-f8b8-11ef-b6a6-1a18cace67cc','Alert silence 생성/재생성','Alert silence 생성/재생성','/api/cluster/monitoring/silence','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','observability','alerts','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4ddfe1-f8b8-11ef-b6a6-1a18cace67cc','Get manage module detail','Get manage module detail','/api/cluster/module/{moduleName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','administration','manage module','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4e02a4-f8b8-11ef-b6a6-1a18cace67cc','put manage module','put manage module','/api/cluster/module/{moduleName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','administration','manage module','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4e2217-f8b8-11ef-b6a6-1a18cace67cc','Modify host by hostname','Modify host by hostname','/api/cluster/host/{hostname}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','host','PUT',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4e454b-f8b8-11ef-b6a6-1a18cace67cc','Delete host by hostname','Delete host by hostname','/api/cluster/host/{hostname}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','host','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4e6858-f8b8-11ef-b6a6-1a18cace67cc','RGW 사용자 생성','RGW 사용자 생성','/api/rgw/user','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','user','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4e9626-f8b8-11ef-b6a6-1a18cace67cc','오브젝트 NFS 생성','오브젝트 NFS 생성','/api/rgw/nfs','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','nfs','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4ebfe3-f8b8-11ef-b6a6-1a18cace67cc','Get Zone Group','Get Zone Group','/api/rgw/multisite/zonegroup','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4ee0aa-f8b8-11ef-b6a6-1a18cace67cc','Create Zone Group','Create Zone Group','/api/rgw/multisite/zonegroup','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4eff3d-f8b8-11ef-b6a6-1a18cace67cc','Get list Zone Info','Get list Zone Info','/api/rgw/multisite/zone','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4f2624-f8b8-11ef-b6a6-1a18cace67cc','Post Zone','Post Zone','/api/rgw/multisite/zone','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4f52be-f8b8-11ef-b6a6-1a18cace67cc','Get List Realm','Get List Realm','/api/rgw/multisite/realm','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)
VALUES  ('0c4fa6e0-f8b8-11ef-b6a6-1a18cace67cc','Create Realm','Create Realm','/api/rgw/multisite/realm','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c4fcd8c-f8b8-11ef-b6a6-1a18cace67cc','Export Token','Export Token','/api/rgw/multisite/realm/token','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c50454b-f8b8-11ef-b6a6-1a18cace67cc','Import token','Import token','/api/rgw/multisite/realm/token','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c506c08-f8b8-11ef-b6a6-1a18cace67cc','RGW 버킷 생성','RGW 버킷 생성','/api/rgw/bucket','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','bucket','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c509359-f8b8-11ef-b6a6-1a18cace67cc','NVMeTCP subsystem 목록 조회','NVMeTCP subsystem 목록 조회','/api/rbd/nvme/subsystem','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','nvmetcp','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c50b6a5-f8b8-11ef-b6a6-1a18cace67cc','NVMeTCP subsystem 생성','NVMeTCP subsystem 생성','/api/rbd/nvme/subsystem','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','nvmetcp','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c50d72f-f8b8-11ef-b6a6-1a18cace67cc','NVMeTCP subsystem namespace 목록 조회','NVMeTCP subsystem namespace 목록 조회','/api/rbd/nvme/subsystem/{nqn}/namespace','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','nvmetcp','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5104a0-f8b8-11ef-b6a6-1a18cace67cc','NVMeTCP subsystem namespace 생성','NVMeTCP subsystem namespace 생성','/api/rbd/nvme/subsystem/{nqn}/namespace','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','nvmetcp','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c512473-f8b8-11ef-b6a6-1a18cace67cc','NVMeTCP subsystem listener 목록 조회','NVMeTCP subsystem listener 목록 조회','/api/rbd/nvme/subsystem/{nqn}/listener','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','nvmetcp','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c514c60-f8b8-11ef-b6a6-1a18cace67cc','NVMeTCP subsystem listener 생성','NVMeTCP subsystem listener 생성','/api/rbd/nvme/subsystem/{nqn}/listener','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','nvmetcp','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5173f9-f8b8-11ef-b6a6-1a18cace67cc','NVMeTCP subsystem initiator 목록 조회','NVMeTCP subsystem initiator 목록 조회','/api/rbd/nvme/subsystem/{nqn}/initiator','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','nvmetcp','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c51973c-f8b8-11ef-b6a6-1a18cace67cc','NVMeTCP subsystem initiator 생성','NVMeTCP subsystem initiator 생성','/api/rbd/nvme/subsystem/{nqn}/initiator','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','nvmetcp','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c51bdb1-f8b8-11ef-b6a6-1a18cace67cc','RBD Mirroring Peer 등록','RBD Mirroring Peer 등록','/api/rbd/mirroring/pool/{poolName}/peer','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','mirroring','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c51e2d5-f8b8-11ef-b6a6-1a18cace67cc','Import RBD Mirroring Source Token','Import RBD Mirroring Source Token','/api/rbd/mirroring/bootstrap/token/import','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','mirroring','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c52098f-f8b8-11ef-b6a6-1a18cace67cc','Export RBD Mirroring Source Token','Export RBD Mirroring Source Token','/api/rbd/mirroring/bootstrap/token/export','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','mirroring','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c523bb2-f8b8-11ef-b6a6-1a18cace67cc','RBD iSCSI Create Target','RBD iSCSI Create Target','/api/rbd/iscsi/target','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','iscsi','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5271a3-f8b8-11ef-b6a6-1a18cace67cc','RBD Image 생성','RBD Image 생성','/api/rbd/image','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c52a424-f8b8-11ef-b6a6-1a18cace67cc','Rollback Snapshot Image','Rollback Snapshot Image','/api/rbd/image/{poolName}/{namespace}/{imageName}/snapshot/{snapshotName}/rollback','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c52d0be-f8b8-11ef-b6a6-1a18cace67cc','Rollback Snapshot Image','Rollback Snapshot Image','/api/rbd/image/{poolName}/{imageName}/snapshot/{snapshotName}/rollback','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c52f2c8-f8b8-11ef-b6a6-1a18cace67cc','Clone Snapshot Image','Clone Snapshot Image','/api/rbd/image/{poolName}/{namespace}/{imageName}/snapshot/{snapshotName}/clone','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)
VALUES  ('0c5312ea-f8b8-11ef-b6a6-1a18cace67cc','Clone Snapshot Image','Clone Snapshot Image','/api/rbd/image/{poolName}/{imageName}/snapshot/{snapshotName}/clone','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5330cb-f8b8-11ef-b6a6-1a18cace67cc','Copy Snapshot Image','Copy Snapshot Image','/api/rbd/image/{poolName}/{namespace}/{imageName}/snapshot/copy','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c536240-f8b8-11ef-b6a6-1a18cace67cc','Copy Snapshot Image','Copy Snapshot Image','/api/rbd/image/{poolName}/{imageName}/snapshot/copy','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c53e878-f8b8-11ef-b6a6-1a18cace67cc','Create Snapshot Image','Create Snapshot Image','/api/rbd/image/{poolName}/{namespace}/{imageName}/snapshot','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5596f7-f8b8-11ef-b6a6-1a18cace67cc','Create Snapshot Image','Create Snapshot Image','/api/rbd/image/{poolName}/{imageName}/snapshot','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c55dd71-f8b8-11ef-b6a6-1a18cace67cc','Move to Trash Image By PoolName/Namespace(생략가능)/ImageName','Move to Trash Image By PoolName/Namespace(생략가능)/ImageName','/api/rbd/image/{poolName}/{namespace}/{imageName}/move-trash','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c560780-f8b8-11ef-b6a6-1a18cace67cc','Move to Trash Image By PoolName/Namespace(생략가능)/ImageName','Move to Trash Image By PoolName/Namespace(생략가능)/ImageName','/api/rbd/image/{poolName}/{imageName}/move-trash','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c562889-f8b8-11ef-b6a6-1a18cace67cc','Flatten Image By PoolName/Namespace(생략가능)/ImageName','Flatten Image By PoolName/Namespace(생략가능)/ImageName','/api/rbd/image/{poolName}/{namespace}/{imageName}/flatten','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5657a8-f8b8-11ef-b6a6-1a18cace67cc','Flatten Image By PoolName/Namespace(생략가능)/ImageName','Flatten Image By PoolName/Namespace(생략가능)/ImageName','/api/rbd/image/{poolName}/{imageName}/flatten','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c56845d-f8b8-11ef-b6a6-1a18cace67cc','Copy Image By PoolName/Namespace(생략가능)/ImageName','Copy Image By PoolName/Namespace(생략가능)/ImageName','/api/rbd/image/{poolName}/{namespace}/{imageName}/copy','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c56a57d-f8b8-11ef-b6a6-1a18cace67cc','Copy Image By PoolName/Namespace(생략가능)/ImageName','Copy Image By PoolName/Namespace(생략가능)/ImageName','/api/rbd/image/{poolName}/{imageName}/copy','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c56c3d6-f8b8-11ef-b6a6-1a18cace67cc','Create Namespace','Create Namespace','/api/rbd/image/{poolName}/namespace/{namespace}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c56eece-f8b8-11ef-b6a6-1a18cace67cc','Delete Namespace','Delete Namespace','/api/rbd/image/{poolName}/namespace/{namespace}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c573157-f8b8-11ef-b6a6-1a18cace67cc','Purge Trash Image','Purge Trash Image','/api/rbd/image/trash/purge','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c57658b-f8b8-11ef-b6a6-1a18cace67cc','NFS 생성','NFS 생성','/api/file/nfs','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','nfs','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c57c7f0-f8b8-11ef-b6a6-1a18cace67cc','FileSystem snapshot create','FileSystem snapshot create','/api/file/fs/{fsId}/snapshot','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c57fc7a-f8b8-11ef-b6a6-1a18cace67cc','FileSystem snapshot delete','FileSystem snapshot delete','/api/file/fs/{fsId}/snapshot','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5826f6-f8b8-11ef-b6a6-1a18cace67cc','FileSystem create subvolume','FileSystem create subvolume','/api/file/fs/subvolume','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5855ae-f8b8-11ef-b6a6-1a18cace67cc','FileSystem create subvolume snapshot','FileSystem create subvolume snapshot','/api/file/fs/subvolume/snapshot','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c58773b-f8b8-11ef-b6a6-1a18cace67cc','FileSystem create subvolume Clone','FileSystem create subvolume Clone','/api/file/fs/subvolume/snapshot/clone','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)
VALUES  ('0c58a663-f8b8-11ef-b6a6-1a18cace67cc','FileSystem create snapshot schedule','FileSystem create snapshot schedule','/api/file/fs/snapshot/schedule','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c58cc85-f8b8-11ef-b6a6-1a18cace67cc','FileSystem deactivate snapshot schedule','FileSystem deactivate snapshot schedule','/api/file/fs/snapshot/schedule/{fs}/deactivate','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c58f77d-f8b8-11ef-b6a6-1a18cace67cc','FileSystem activate snapshot schedule','FileSystem activate snapshot schedule','/api/file/fs/snapshot/schedule/{fs}/activate','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c591c54-f8b8-11ef-b6a6-1a18cace67cc','export cluster user','export cluster user','/api/cluster/user/export','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','administration','user','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c594251-f8b8-11ef-b6a6-1a18cace67cc','Get service list','Get service list','/api/cluster/service','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','administration','service','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c596c72-f8b8-11ef-b6a6-1a18cace67cc','Create service','Create service','/api/cluster/service','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','administration','service','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c59988d-f8b8-11ef-b6a6-1a18cace67cc','Pool 목록 조회','Pool 목록 조회','/api/cluster/pool','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','pool','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c59c493-f8b8-11ef-b6a6-1a18cace67cc','Create Pool','Create Pool','/api/cluster/pool','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','pool','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c59e946-f8b8-11ef-b6a6-1a18cace67cc','Create EC Profile','Create EC Profile','/api/cluster/pool/ec-profile','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','pool','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5a24f7-f8b8-11ef-b6a6-1a18cace67cc','Create Crush Rule','Create Crush Rule','/api/cluster/pool/crush-rule','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','pool','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5a4513-f8b8-11ef-b6a6-1a18cace67cc','Get OSD list','Get OSD list','/api/cluster/osd','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5a656c-f8b8-11ef-b6a6-1a18cace67cc','Create OSD','Create OSD','/api/cluster/osd','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5a890a-f8b8-11ef-b6a6-1a18cace67cc','Update OSD scrub','Update OSD scrub','/api/cluster/osd/{id}/scrub','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5aba0d-f8b8-11ef-b6a6-1a18cace67cc','Update OSD scrub','Update OSD scrub','/api/cluster/osd/{id}/scrub/{isDeep}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5aee2f-f8b8-11ef-b6a6-1a18cace67cc','Update OSD Deep scrub','Update OSD Deep scrub','/api/cluster/osd/{id}/scrub/deep','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5b29eb-f8b8-11ef-b6a6-1a18cace67cc','post manage module enable','post manage module enable','/api/cluster/module/{moduleName}/enable','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','administration','manage module','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5b53f2-f8b8-11ef-b6a6-1a18cace67cc','post manage module disable','post manage module disable','/api/cluster/module/{moduleName}/disable','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','administration','manage module','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5b7883-f8b8-11ef-b6a6-1a18cace67cc','Get Host list','Get Host list','/api/cluster/host','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','host','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5bac57-f8b8-11ef-b6a6-1a18cace67cc','Create host by hostname','Create host by hostname','/api/cluster/host','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','host','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5bded9-f8b8-11ef-b6a6-1a18cace67cc','Identify host device by hostname','Identify host device by hostname','/api/cluster/host/{hostname}/identify-device','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','host','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api) 
VALUES  ('0c5c0859-f8b8-11ef-b6a6-1a18cace67cc','Get cluster configurations','Get cluster configurations','/api/cluster/conf','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','administration','configuration','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5c2c22-f8b8-11ef-b6a6-1a18cace67cc','Post cluster configurations','Post cluster configurations','/api/cluster/conf','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','administration','configuration','POST',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5c6a1e-f8b8-11ef-b6a6-1a18cace67cc','NVMeTCP subsystem namespace 상세 조회','NVMeTCP subsystem namespace 상세 조회','/api/rbd/nvme/subsystem/{nqn}/namespace/{nsid}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','nvmetcp','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5ca483-f8b8-11ef-b6a6-1a18cace67cc','NVMeTCP subsystem namespace 삭제','NVMeTCP subsystem namespace 삭제','/api/rbd/nvme/subsystem/{nqn}/namespace/{nsid}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','nvmetcp','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5d0d0b-f8b8-11ef-b6a6-1a18cace67cc','NVMeTCP subsystem namespace 수정','NVMeTCP subsystem namespace 수정','/api/rbd/nvme/subsystem/{nqn}/namespace/{nsid}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','nvmetcp','PATCH',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5d42ed-f8b8-11ef-b6a6-1a18cace67cc','RGW 사용자 역할 목록','RGW 사용자 역할 목록','/api/rgw/user/roles','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','role','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5d6d4b-f8b8-11ef-b6a6-1a18cace67cc','RGW 사용자 목록 조회','RGW 사용자 목록 조회','/api/rgw/user/list','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','user','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5d8aa2-f8b8-11ef-b6a6-1a18cace67cc','RGW 사용자 email 유무 확인','RGW 사용자 email 유무 확인','/api/rgw/user/email','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','user','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5dd591-f8b8-11ef-b6a6-1a18cace67cc','RGW Site의 기본 Zonegroup 정보 조회','RGW Site의 기본 Zonegroup 정보 조회','/api/rgw/site/placement-targets','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','site','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5e0878-f8b8-11ef-b6a6-1a18cace67cc','오브젝트 스토리지 overview 페이지 조회','오브젝트 스토리지 overview 페이지 조회','/api/rgw/overview','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','overview','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5e3ba2-f8b8-11ef-b6a6-1a18cace67cc','오브젝트 NFS 목록 조회','오브젝트 NFS 목록 조회','/api/rgw/nfs/list','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','nfs','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5e6e25-f8b8-11ef-b6a6-1a18cace67cc','오브젝트 NFS 생성정보 조회','오브젝트 NFS 생성정보 조회','/api/rgw/nfs/create-info','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','nfs','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5e93eb-f8b8-11ef-b6a6-1a18cace67cc','오브젝트 NFS 생성 - 버킷 조회','오브젝트 NFS 생성 - 버킷 조회','/api/rgw/nfs/buckets','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','nfs','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5ec6bc-f8b8-11ef-b6a6-1a18cace67cc','Get Zone Info','Get Zone Info','/api/rgw/multisite/zone/{zone}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5efcaa-f8b8-11ef-b6a6-1a18cace67cc','Realm Update에 사용되는 Api','Realm Update에 사용되는 Api','/api/rgw/multisite/zone/pools','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5f306d-f8b8-11ef-b6a6-1a18cace67cc','Get sync Policy Group','Get sync Policy Group','/api/rgw/multisite/sync-policy/group/{groupId}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5f52b9-f8b8-11ef-b6a6-1a18cace67cc','RGW Gateway 성능지표 조회','RGW Gateway 성능지표 조회','/api/rgw/gateway/{serviceMapId}/perf-counters','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','gateway','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5f6e86-f8b8-11ef-b6a6-1a18cace67cc','RGW Gateway 상세 조회','RGW Gateway 상세 조회','/api/rgw/gateway/{rgwId}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','gateway','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5fa07c-f8b8-11ef-b6a6-1a18cace67cc','RGW Gateway 목록 조회','RGW Gateway 목록 조회','/api/rgw/gateway/list','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','gateway','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c5fc35e-f8b8-11ef-b6a6-1a18cace67cc','RGW 버킷 목록 조회','RGW 버킷 목록 조회','/api/rgw/bucket/list','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','bucket','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)
VALUES  ('0c5febc9-f8b8-11ef-b6a6-1a18cace67cc','NVMeTCP subsystem detail','NVMeTCP subsystem detail','/api/rbd/nvme/subsystem/{nqn}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','nvmetcp','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6009af-f8b8-11ef-b6a6-1a18cace67cc','NVMeTCP subsystem 삭제','NVMeTCP subsystem 삭제','/api/rbd/nvme/subsystem/{nqn}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','nvmetcp','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c60281b-f8b8-11ef-b6a6-1a18cace67cc','NVMeTCP  gateway 조회','NVMeTCP  gateway 조회','/api/rbd/nvme/gateway','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','nvmetcp','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c604930-f8b8-11ef-b6a6-1a18cace67cc','Get a set of RBD Mirroring lists','Get a set of RBD Mirroring lists','/api/rbd/mirroring','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','mirroring','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c606ac7-f8b8-11ef-b6a6-1a18cace67cc','Get RBD Mirroring Pool`s Peer List','Get RBD Mirroring Pool`s Peer List','/api/rbd/mirroring/pool/{poolName}/peers','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','mirroring','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6090e2-f8b8-11ef-b6a6-1a18cace67cc','RBD iSCSI Target List','RBD iSCSI Target List','/api/rbd/iscsi/targets','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','iscsi','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c60ab4b-f8b8-11ef-b6a6-1a18cace67cc','RBD iSCSI Settings','RBD iSCSI Settings','/api/rbd/iscsi/setting','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','iscsi','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c60cd1f-f8b8-11ef-b6a6-1a18cace67cc','RBD iSCSI Portals','RBD iSCSI Portals','/api/rbd/iscsi/portal','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','iscsi','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c60f278-f8b8-11ef-b6a6-1a18cace67cc','RBD iSCSI Gateway & Image 목록 조회','RBD iSCSI Gateway & Image 목록 조회','/api/rbd/iscsi/list','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','iscsi','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6118e4-f8b8-11ef-b6a6-1a18cace67cc','RBD Image 트래쉬 목록 조회','RBD Image 트래쉬 목록 조회','/api/rbd/image/tab/trash','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6135b4-f8b8-11ef-b6a6-1a18cace67cc','RBD Image 네임스페이스 목록 조회','RBD Image 네임스페이스 목록 조회','/api/rbd/image/tab/namespace','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c615b4d-f8b8-11ef-b6a6-1a18cace67cc','RBD Image 목록 조회','RBD Image 목록 조회','/api/rbd/image/tab/image','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c617e43-f8b8-11ef-b6a6-1a18cace67cc','RBD Image 상세 조회','RBD Image 상세 조회','/api/rbd/image/tab/image/{poolName}/{namespace}/{imageName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c61a1ea-f8b8-11ef-b6a6-1a18cace67cc','RBD Image 상세 조회','RBD Image 상세 조회','/api/rbd/image/tab/image/{poolName}/{imageName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c61caf0-f8b8-11ef-b6a6-1a18cace67cc','Get RBD Info List','Get RBD Info List','/api/rbd/image/prepare/create','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c61f98a-f8b8-11ef-b6a6-1a18cace67cc','namespace list','namespace list','/api/rbd/image/pool/{poolName}/namespace','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c62287d-f8b8-11ef-b6a6-1a18cace67cc','NFS 생성용 Info 조회','NFS 생성용 Info 조회','/api/file/nfs/ui-info','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','nfs','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c625ca0-f8b8-11ef-b6a6-1a18cace67cc','Subvolume 조회','Subvolume 조회','/api/file/nfs/subvolume/{volumeName}/{groupName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','nfs','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c628e04-f8b8-11ef-b6a6-1a18cace67cc','Subvolume 조회','Subvolume 조회','/api/file/nfs/subvolume/{volumeName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','nfs','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c62bd84-f8b8-11ef-b6a6-1a18cace67cc','Subvolume group 조회','Subvolume group 조회','/api/file/nfs/subgroup/{volumeName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','nfs','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api) 
VALUES  ('0c62ef3f-f8b8-11ef-b6a6-1a18cace67cc','NFS 목록 조회','NFS 목록 조회','/api/file/nfs/list','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','nfs','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c632523-f8b8-11ef-b6a6-1a18cace67cc','NFS 상세 조회','NFS 상세 조회','/api/file/nfs/detail/{clusterId}/{id}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','nfs','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c635940-f8b8-11ef-b6a6-1a18cace67cc','FileSystem Update Info 조회','FileSystem Update Info 조회','/api/file/fs/{id}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c63857d-f8b8-11ef-b6a6-1a18cace67cc','FileSystem url info','FileSystem url info','/api/file/fs/{id}/ls-dir','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c63b123-f8b8-11ef-b6a6-1a18cace67cc','FileSystem get directories','FileSystem get directories','/api/file/fs/{fsId}/dir','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c63f067-f8b8-11ef-b6a6-1a18cace67cc','FileSystem clients info','FileSystem clients info','/api/file/fs/{fsId}/clients','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c642586-f8b8-11ef-b6a6-1a18cace67cc','FileSystem UI Info 조회','FileSystem UI Info 조회','/api/file/fs/ui-info','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6453fa-f8b8-11ef-b6a6-1a18cace67cc','Subvolume 조회','Subvolume 조회','/api/file/fs/subvolume/{volumeName}/{groupName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','nfs','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c647ded-f8b8-11ef-b6a6-1a18cace67cc','Subvolume 조회','Subvolume 조회','/api/file/fs/subvolume/{volumeName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','nfs','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c64a1fe-f8b8-11ef-b6a6-1a18cace67cc','FileSystem get subbvolume snapshot','FileSystem get subbvolume snapshot','/api/file/fs/subvolume/snapshot/{volName}/{subvolName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c64c13c-f8b8-11ef-b6a6-1a18cace67cc','FileSystem delete subbvolume snapshot','FileSystem delete subbvolume snapshot','/api/file/fs/subvolume/snapshot/{volName}/{subvolName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c650439-f8b8-11ef-b6a6-1a18cace67cc','Subvolume group 조회','Subvolume group 조회','/api/file/fs/subvolume/group/{volName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','system','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c653d31-f8b8-11ef-b6a6-1a18cace67cc','Subvolume group delete','Subvolume group delete','/api/file/fs/subvolume/group/{volName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','system','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c657103-f8b8-11ef-b6a6-1a18cace67cc','FileSystem 목록 조회','FileSystem 목록 조회','/api/file/fs/list','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c65a0e7-f8b8-11ef-b6a6-1a18cace67cc','FileSystem Detail 목록 조회','FileSystem Detail 목록 조회','/api/file/fs/detail/{fsId}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c65d694-f8b8-11ef-b6a6-1a18cace67cc','FileSystem attach info','FileSystem attach info','/api/file/fs/attach-info/{id}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c661630-f8b8-11ef-b6a6-1a18cace67cc','Get Dashboard data','Get Dashboard data','/api/dashboard','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','dashboard','dashboard','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6647ba-f8b8-11ef-b6a6-1a18cace67cc','Get Cluster summary','Get Cluster summary','/api/cluster/summary','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','summary','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6674da-f8b8-11ef-b6a6-1a18cace67cc','Get service event list','Get service event list','/api/cluster/service/{serviceName}/events','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','administration','service','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c66e1f6-f8b8-11ef-b6a6-1a18cace67cc','Get service daemon list','Get service daemon list','/api/cluster/service/{serviceName}/daemons','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','administration','service','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api) 
VALUES  ('0c6712de-f8b8-11ef-b6a6-1a18cace67cc','Get service detail','Get service detail','/api/cluster/service/{name}/detail','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','administration','service','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c673f91-f8b8-11ef-b6a6-1a18cace67cc','Get service ui-info','Get service ui-info','/api/cluster/service/ui-info','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','administration','service','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c676577-f8b8-11ef-b6a6-1a18cace67cc','Get pool info','Get pool info','/api/cluster/pool/{name}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','pool','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c678871-f8b8-11ef-b6a6-1a18cace67cc','Get pool detail panel data','Get pool detail panel data','/api/cluster/pool/{name}/detail','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','pool','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c67ac95-f8b8-11ef-b6a6-1a18cace67cc','Get info for creating Pool','Get info for creating Pool','/api/cluster/pool/ui-info','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','pool','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c67cd21-f8b8-11ef-b6a6-1a18cace67cc','Get info for creating EC Profile','Get info for creating EC Profile','/api/cluster/pool/ui-info/erasure-code-profile','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','pool','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c67f09a-f8b8-11ef-b6a6-1a18cace67cc','Get info for creating Crush Rule','Get info for creating Crush Rule','/api/cluster/pool/ui-info/crush-rule','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','pool','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c681b52-f8b8-11ef-b6a6-1a18cace67cc','Get OSD performance counter','Get OSD performance counter','/api/cluster/osd/{id}/perf-counter','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6853bd-f8b8-11ef-b6a6-1a18cace67cc','Get OSD metadata','Get OSD metadata','/api/cluster/osd/{id}/metadata','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c689125-f8b8-11ef-b6a6-1a18cace67cc','Get OSD device list','Get OSD device list','/api/cluster/osd/{id}/devices','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c68cdc6-f8b8-11ef-b6a6-1a18cace67cc','Get OSD device health','Get OSD device health','/api/cluster/osd/{id}/device-health','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c68f7d2-f8b8-11ef-b6a6-1a18cace67cc','Get OSD map','Get OSD map','/api/cluster/osd/{id}/attributes','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c691d86-f8b8-11ef-b6a6-1a18cace67cc','Get is safe to delete OSD','Get is safe to delete OSD','/api/cluster/osd/safe-to-delete','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c694a9c-f8b8-11ef-b6a6-1a18cace67cc','Get data for OSD creation','Get data for OSD creation','/api/cluster/osd/create-info','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6977ae-f8b8-11ef-b6a6-1a18cace67cc','Silences Alert 조회','Silences Alert 조회','/api/cluster/monitoring/silences-alerts','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','observability','alerts','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c699d00-f8b8-11ef-b6a6-1a18cace67cc','Resolved Alert 조회','Resolved Alert 조회','/api/cluster/monitoring/resolved-alerts','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','observability','alerts','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c69b8bf-f8b8-11ef-b6a6-1a18cace67cc','Active Alert 조회','Active Alert 조회','/api/cluster/monitoring/active-alerts','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','observability','alerts','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c69eb3b-f8b8-11ef-b6a6-1a18cace67cc','Get Mon list','Get Mon list','/api/cluster/mon','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','mon','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6a216f-f8b8-11ef-b6a6-1a18cace67cc','Get Mon Subgrid list','Get Mon Subgrid list','/api/cluster/mon/{name}/children','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','mon','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6a5825-f8b8-11ef-b6a6-1a18cace67cc','Get Mon summary (cluster Status)','Get Mon summary (cluster Status)','/api/cluster/mon/summary','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','mon','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)
VALUES  ('0c6a8b13-f8b8-11ef-b6a6-1a18cace67cc','Get manage module list','Get manage module list','/api/cluster/module','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','administration','manage module','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6abb3a-f8b8-11ef-b6a6-1a18cace67cc','Get manage module options','Get manage module options','/api/cluster/module/{moduleName}/options','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','administration','manage module','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6add7b-f8b8-11ef-b6a6-1a18cace67cc','Log 목록 조회','Log 목록 조회','/api/cluster/logs/{type}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','observability','logs','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6afae7-f8b8-11ef-b6a6-1a18cace67cc','Get physical disk list','Get physical disk list','/api/cluster/inventory','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','disk','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6b2378-f8b8-11ef-b6a6-1a18cace67cc','Get Host device health','Get Host device health','/api/cluster/host/{hostname}/smart','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','host','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6b4e45-f8b8-11ef-b6a6-1a18cace67cc','Get Host physical disk list','Get Host physical disk list','/api/cluster/host/{hostname}/inventories','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','host','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6b78b6-f8b8-11ef-b6a6-1a18cace67cc','Get Host device list','Get Host device list','/api/cluster/host/{hostname}/devices','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','host','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6bab74-f8b8-11ef-b6a6-1a18cace67cc','Get Host daemon list','Get Host daemon list','/api/cluster/host/{hostname}/daemons','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','host','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6be662-f8b8-11ef-b6a6-1a18cace67cc','Get Host basic-info tab''s basic info detail','Get Host basic-info tab''s basic info detail','/api/cluster/host/detail/{hostname}/basic','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','host','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6c1a8a-f8b8-11ef-b6a6-1a18cace67cc','Get CRUSH map tree','Get CRUSH map tree','/api/cluster/crush','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','crush','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6c5275-f8b8-11ef-b6a6-1a18cace67cc','Get cluster configurations','Get cluster configurations','/api/cluster/conf/{name}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','administration','configuration','GET',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6c7a0f-f8b8-11ef-b6a6-1a18cace67cc','RGW 사용자 역할 삭제','RGW 사용자 역할 삭제','/api/rgw/user/role/{roleName}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','role','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6c9ca1-f8b8-11ef-b6a6-1a18cace67cc','Delete Sync Policy Group','Delete Sync Policy Group','/api/rgw/multisite/sync-policy/{groupId}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6cca4a-f8b8-11ef-b6a6-1a18cace67cc','Delete Sync Pipe','Delete Sync Pipe','/api/rgw/multisite/sync-pipe/{groupId}/{pipeId}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6d12ab-f8b8-11ef-b6a6-1a18cace67cc','Delete Sync Flow','Delete Sync Flow','/api/rgw/multisite/sync-flow/{flowId}/{flowType}/{groupId}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','object','multisite','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6d59fb-f8b8-11ef-b6a6-1a18cace67cc','NVMeTCP subsystem listener 삭제','NVMeTCP subsystem listener 삭제','/api/rbd/nvme/subsystem/{nqn}/listener/{hostName}/{traddr}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','nvmetcp','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6d839a-f8b8-11ef-b6a6-1a18cace67cc','NVMeTCP subsystem initiator 삭제','NVMeTCP subsystem initiator 삭제','/api/rbd/nvme/subsystem/{nqn}/initiator/{hostNqn}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','nvmetcp','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6db025-f8b8-11ef-b6a6-1a18cace67cc','Delete Trash Image','Delete Trash Image','/api/rbd/image/{poolName}/{namespace}/trash/{trashId}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6dd829-f8b8-11ef-b6a6-1a18cace67cc','Delete Trash Image','Delete Trash Image','/api/rbd/image/{poolName}/trash/{trashId}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','block','image','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6e01af-f8b8-11ef-b6a6-1a18cace67cc','FileSystem Info 삭제','FileSystem Info 삭제','/api/file/fs/{name}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)
VALUES  ('0c6e29b1-f8b8-11ef-b6a6-1a18cace67cc','FileSystem client delete','FileSystem client delete','/api/file/fs/{fsId}/client/{clientId}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','file','filesystem','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6e5cf0-f8b8-11ef-b6a6-1a18cace67cc','Delete cluster user','Delete cluster user','/api/cluster/user/{entity}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','administration','user','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6e9047-f8b8-11ef-b6a6-1a18cace67cc','Delete EC Profile','Delete EC Profile','/api/cluster/pool/ec-profile/{name}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','pool','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6eb877-f8b8-11ef-b6a6-1a18cace67cc','Delete Crush Rule','Delete Crush Rule','/api/cluster/pool/crush-rule/{name}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','pool','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6ee374-f8b8-11ef-b6a6-1a18cace67cc','Purge OSD','Purge OSD','/api/cluster/osd/{id}/purge','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6f06c3-f8b8-11ef-b6a6-1a18cace67cc','Destroy OSD','Destroy OSD','/api/cluster/osd/{id}/destroy','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','cluster','osd','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0c6f28b3-f8b8-11ef-b6a6-1a18cace67cc','Alert silence 삭제','Alert silence 삭제','/api/cluster/monitoring/silence/{sId}','dcf83803-d707-11ef-9c74-0a11b82fa8dd','Ceph','observability','alerts','DELETE',1,'e03434c0-d70d-11ef-9c74-0a11b82fa8dd',0)
    ,   ('0cda2bb7-879a-11ee-a4fd-dadafdb14cb0','프로바이더 캐시 업데이트 API','프로바이더 캐시 업데이트 API','/provider/cacheUpdate','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','provider','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cda9282-879a-11ee-a4fd-dadafdb14cb0','프로젝트 유저 등록 API','프로젝트 유저 등록 API','/identity/roles/assign-role/{projectId}/users/{userId}/roles/{roleId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','identity','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cdad2f1-879a-11ee-a4fd-dadafdb14cb0','프로젝트 할당된 유저 조회 API','프로젝트 할당된 유저 조회 API','/identity/projects/{projectId}/users','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','identity','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cdb19ca-879a-11ee-a4fd-dadafdb14cb0','Update Project User','Update Project User','/identity/projects/{projectId}/users','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','identity','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cdb5c5e-879a-11ee-a4fd-dadafdb14cb0','프로젝트 쿼터 조회 API','프로젝트 쿼터 조회 API','/identity/projects/{projectId}/quota','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','identity','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cdba2df-879a-11ee-a4fd-dadafdb14cb0','Quota Update','Quota Update','/identity/projects/{projectId}/quota','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','identity','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cdbee38-879a-11ee-a4fd-dadafdb14cb0','이미지 파일 업로드 API','이미지 파일 업로드 API','/compute/images/{imageId}/file','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','image','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cdc3dac-879a-11ee-a4fd-dadafdb14cb0','서비스 카탈로그 생성 요청 API','서비스 카탈로그 생성 요청 API','/service-catalog','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','servicecatalog','servicecatalog','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cdc926c-879a-11ee-a4fd-dadafdb14cb0','프로바이더 생성 API','프로바이더 생성 API','/provider/{providerId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','provider','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cdcce7e-879a-11ee-a4fd-dadafdb14cb0','프로바이더 수정 API','프로바이더 수정 API','/provider/{providerId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','provider','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cdd0b70-879a-11ee-a4fd-dadafdb14cb0','연결 확인 API','연결 확인 API','/provider/check','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','provider','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cdd4e9c-879a-11ee-a4fd-dadafdb14cb0','Pool Delete','Pool Delete','/load-balancer/pools/{poolId}/members','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cdda19a-879a-11ee-a4fd-dadafdb14cb0','프로젝트 목록 조회 API','프로젝트 목록 조회 API','/identity/projects','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','identity','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)
VALUES  ('0cdde435-879a-11ee-a4fd-dadafdb14cb0','프로젝트 생성 API','프로젝트 생성 API','/identity/projects','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','identity','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cde28ea-879a-11ee-a4fd-dadafdb14cb0','프로젝트 삭제 API','프로젝트 삭제 API','/identity/projects','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','identity','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cde6ba2-879a-11ee-a4fd-dadafdb14cb0','오픈스택 엔드포인트 인터페이스 변경 API','오픈스택 엔드포인트 인터페이스 변경 API','/endpoint-interface/{interfaceType}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','openstack','interface','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cdeae06-879a-11ee-a4fd-dadafdb14cb0','인스턴스 스냅샷 목록 조회 API','인스턴스 스냅샷 목록 조회 API','/compute/servers/snapshots','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','glance','image','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cdeaf12-26ec-11ef-84f6-cef7037da37f','Ec2 Instance 상태 변경','Ec2 Instance 상태 변경','/compute/servers/type','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0cdef34a-879a-11ee-a4fd-dadafdb14cb0','인스턴스 스냅샷 멀티 삭제 API','인스턴스 스냅샷 멀티 삭제 API','/compute/servers/snapshots','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','glance','image','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cdf3c38-879a-11ee-a4fd-dadafdb14cb0','호스트집합 메타데이터 생성/수정 API','호스트집합 메타데이터 생성/수정 API','/compute/hosts/{aggregateId}/metadata','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','hostaggregate','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cdf536f-26ec-11ef-84f6-cef7037da37f','Ec2 Instance 작동중지','Ec2 Instance 작동중지','/compute/servers/stop','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0cdf7a35-879a-11ee-a4fd-dadafdb14cb0','유저 상세 조회 API','유저 상세 조회 API','/identity/users/{userId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','identity','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cdf858e-26ec-11ef-84f6-cef7037da37f','Ec2 Instance 작동','Ec2 Instance 작동','/compute/servers/start','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0cdfb1ce-26ec-11ef-84f6-cef7037da37f','Ec2 Instance 이름 변경','Ec2 Instance 이름 변경','/compute/servers/name','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0cdfb865-879a-11ee-a4fd-dadafdb14cb0','유저 상태 변경 API','유저 상태 변경 API','/identity/users/{userId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','identity','PATCH',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cdffaa1-879a-11ee-a4fd-dadafdb14cb0','볼륨 쿼터 조회','볼륨 쿼터 조회','/volume/limits','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce03693-879a-11ee-a4fd-dadafdb14cb0','컴퓨트 쿼터 조회','컴퓨트 쿼터 조회','/validation/compute','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce06cc7-26ec-11ef-84f6-cef7037da37f','admin : POST/security-groups/authorize/ingress','admin : POST/security-groups/authorize/ingress','/security-groups/authorize/ingress','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0ce0820c-879a-11ee-a4fd-dadafdb14cb0','시스템 볼륨 쿼터 할당량 조회 API','시스템 볼륨 쿼터 할당량 조회 API','/system/quota/volume','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce0ae09-26ec-11ef-84f6-cef7037da37f','admin : DELETE/security-groups/authorize/ingress','admin : DELETE/security-groups/authorize/ingress','/security-groups/authorize/ingress','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0ce0be6f-879a-11ee-a4fd-dadafdb14cb0','시스템 Share 쿼터 할당량 조회 API','시스템 Share 쿼터 할당량 조회 API','/system/quota/share','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce0dcc9-26ec-11ef-84f6-cef7037da37f','admin : POST/security-groups/authorize/egress','admin : POST/security-groups/authorize/egress','/security-groups/authorize/egress','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0ce0fcda-879a-11ee-a4fd-dadafdb14cb0','시스템 네트워크 쿼터 할당량 조회 API','시스템 네트워크 쿼터 할당량 조회 API','/system/quota/network','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','network','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('0ce10a67-26ec-11ef-84f6-cef7037da37f','admin : DELETE/security-groups/authorize/egress','admin : DELETE/security-groups/authorize/egress','/security-groups/authorize/egress','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0ce13807-26ec-11ef-84f6-cef7037da37f','Ec2 Instance 생성','Ec2 Instance 생성','/compute/servers','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0ce13b40-879a-11ee-a4fd-dadafdb14cb0','시스템 컴퓨트 쿼터 할당량 조회 API','시스템 컴퓨트 쿼터 할당량 조회 API','/system/quota/compute','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce16527-26ec-11ef-84f6-cef7037da37f','Ec2 인스턴스 리부팅','Ec2 인스턴스 리부팅','/compute/servers/reboot','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0ce176b8-879a-11ee-a4fd-dadafdb14cb0','시스템 메타데이터 정의 조회 API','시스템 메타데이터 정의 조회 API','/system/metadata','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','glance','metadata','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce18b5a-26ec-11ef-84f6-cef7037da37f','보안 그룹 삭제','보안 그룹 삭제','/security-groups/{securityGroupId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0ce1b278-26ec-11ef-84f6-cef7037da37f','보안그룹 룰 목록 조회','보안그룹 룰 목록 조회','/security-groups/rules','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0ce1b61e-879a-11ee-a4fd-dadafdb14cb0','시스템 서비스 조회 API','시스템 서비스 조회 API','/system/info/service','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','identity','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce1db2d-26ec-11ef-84f6-cef7037da37f','보안그룹 룰 필터하여 목록 조회','보안그룹 룰 필터하여 목록 조회','/security-groups/rules/filters','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0ce20bdf-26ec-11ef-84f6-cef7037da37f','Ec2 Instance 삭제','Ec2 Instance 삭제','/compute/servers/{instanceId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0ce23115-879a-11ee-a4fd-dadafdb14cb0','시스템 네트워크 에이전트 조회 API','시스템 네트워크 에이전트 조회 API','/system/info/network','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','network','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce23c05-26ec-11ef-84f6-cef7037da37f','Ec2 Instance 상태 변경','Ec2 Instance 상태 변경','/compute/servers/type','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0ce2672d-26ec-11ef-84f6-cef7037da37f','Ec2 Instance 작동중지','Ec2 Instance 작동중지','/compute/servers/stop','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0ce27512-879a-11ee-a4fd-dadafdb14cb0','시스템 컴퓨트 서비스 조회 API','시스템 컴퓨트 서비스 조회 API','/system/info/compute','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce29444-26ec-11ef-84f6-cef7037da37f','Ec2 Instance 작동','Ec2 Instance 작동','/compute/servers/start','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0ce2bfc4-26ec-11ef-84f6-cef7037da37f','Ec2 Instance 이름 변경','Ec2 Instance 이름 변경','/compute/servers/name','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0ce2ece7-879a-11ee-a4fd-dadafdb14cb0','시스템 블록 스토리지 서비스 조회 API','시스템 블록 스토리지 서비스 조회 API','/system/info/block-storage','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce325b7-26ec-11ef-84f6-cef7037da37f','user : POST/security-groups/authorize/ingress','user : POST/security-groups/authorize/ingress','/security-groups/authorize/ingress','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0ce33fc4-879a-11ee-a4fd-dadafdb14cb0','서비스 카탈로그 생성을 위한 내역 상세 조회 API','서비스 카탈로그 생성을 위한 내역 상세 조회 API','/service-catalog/{id}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','servicecatalog','servicecatalog','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce34bcd-26ec-11ef-84f6-cef7037da37f','user : DELETE/security-groups/authorize/ingress','user : DELETE/security-groups/authorize/ingress','/security-groups/authorize/ingress','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('0ce37344-26ec-11ef-84f6-cef7037da37f','user : POST/security-groups/authorize/egress','user : POST/security-groups/authorize/egress','/security-groups/authorize/egress','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0ce37f82-879a-11ee-a4fd-dadafdb14cb0','서비스 카탈로그 생성을 위한 프로젝트 이름 조회 API','서비스 카탈로그 생성을 위한 프로젝트 이름 조회 API','/service-catalog/project-name','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','servicecatalog','project','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce398bb-26ec-11ef-84f6-cef7037da37f','user : DELETE/security-groups/authorize/egress','user : DELETE/security-groups/authorize/egress','/security-groups/authorize/egress','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0ce3c059-26ec-11ef-84f6-cef7037da37f','Ec2 Instance 생성','Ec2 Instance 생성','/compute/servers','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0ce3c6ee-879a-11ee-a4fd-dadafdb14cb0','카탈로그 선택을 위한 네트워크 목록 조회 API','카탈로그 선택을 위한 네트워크 목록 조회 API','/service-catalog/networks','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','servicecatalog','network','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce3e8b0-26ec-11ef-84f6-cef7037da37f','Ec2 인스턴스 리부팅','Ec2 인스턴스 리부팅','/compute/servers/reboot','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0ce408db-879a-11ee-a4fd-dadafdb14cb0','카탈로그 선택을 위한 네트워크 보안그룹 목록 조회 API','카탈로그 선택을 위한 네트워크 보안그룹 목록 조회 API','/service-catalog/network/security-groups','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','servicecatalog','securitygroup','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce40d6b-26ec-11ef-84f6-cef7037da37f','보안 그룹 삭제','보안 그룹 삭제','/security-groups/{securityGroupId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0ce43441-26ec-11ef-84f6-cef7037da37f','보안그룹 룰 목록 조회','보안그룹 룰 목록 조회','/security-groups/rules','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0ce446fe-879a-11ee-a4fd-dadafdb14cb0','카탈로그 선택을 위한 OS 이미지 목록 조회','카탈로그 선택을 위한 OS 이미지 목록 조회','/service-catalog/image/os-images','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','servicecatalog','image','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce46a36-26ec-11ef-84f6-cef7037da37f','보안그룹 룰 필터하여 목록 조회','보안그룹 룰 필터하여 목록 조회','/security-groups/rules/filters','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0ce48654-879a-11ee-a4fd-dadafdb14cb0','서비스 카탈로그 생성을 위한 리소스 조회 API','서비스 카탈로그 생성을 위한 리소스 조회 API','/service-catalog/for-create/{id}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','servicecatalog','servicecatalog','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce491d4-26ec-11ef-84f6-cef7037da37f','Ec2 Instance 삭제','Ec2 Instance 삭제','/compute/servers/{instanceId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0ce4d4b5-879a-11ee-a4fd-dadafdb14cb0','서비스 카탈로그 요청을 위한 오픈스택 서비스 엔드포인트 조회 API','서비스 카탈로그 요청을 위한 오픈스택 서비스 엔드포인트 조회 API','/service-catalog/endpoint','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','servicecatalog','endpoint','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce51cc5-879a-11ee-a4fd-dadafdb14cb0','카탈로그 선택을 위한 키페어 목록 조회 API','카탈로그 선택을 위한 키페어 목록 조회 API','/service-catalog/compute/keypairs','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','servicecatalog','keypair','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce559fa-879a-11ee-a4fd-dadafdb14cb0','카탈로그 선택을 위한 인스턴스 유형 목록 조회','카탈로그 선택을 위한 인스턴스 유형 목록 조회','/service-catalog/compute/instance-types','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','servicecatalog','compute','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce59dbe-879a-11ee-a4fd-dadafdb14cb0','선택된 공급자의 프로젝트 목록 조회 API','선택된 공급자의 프로젝트 목록 조회 API','/provider','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','provider','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce5e30b-879a-11ee-a4fd-dadafdb14cb0','프로바이더 목록 조회 API','프로바이더 목록 조회 API','/provider/providerTest','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','provider','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce61c91-879a-11ee-a4fd-dadafdb14cb0','공급자 프로젝트 조회 API','공급자 프로젝트 조회 API','/provider/projects','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','provider','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce65bf2-879a-11ee-a4fd-dadafdb14cb0','providerId에 따른 credential 조회 API','providerId에 따른 credential 조회 API','/provider/credential','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','credential','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('0ce6a2ae-879a-11ee-a4fd-dadafdb14cb0','네트워크 쿼터 조회','네트워크 쿼터 조회','/network/quota','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','network','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce6eab6-879a-11ee-a4fd-dadafdb14cb0','인스턴스 상세 페이지 유동 아이피 조회 API','인스턴스 상세 페이지 유동 아이피 조회','/network/floating-ips/instance/{instanceId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','floatingip','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce73b63-879a-11ee-a4fd-dadafdb14cb0','floatingIpId로 필터된 Floating Ip 목록 조회 API','floatingIpId로 필터된 Floating Ip 목록 조회 API','/network/floating-ips/filter-by-id','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','floatingip','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce81112-879a-11ee-a4fd-dadafdb14cb0','유저 조회 API','유저 조회 API','/identity/users','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','identity','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce8c085-879a-11ee-a4fd-dadafdb14cb0','Role 목록 조회 API','Role 목록 조회 API','/identity/roles','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','identity','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce91fda-879a-11ee-a4fd-dadafdb14cb0','Role assignments 목록 조회 API','Role assignments 목록 조회 API','/identity/roles/role-assignments','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','identity','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce98c07-879a-11ee-a4fd-dadafdb14cb0','프로젝트 상세 조회 API','프로젝트 상세 조회 API','/identity/projects/{projectId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','identity','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ce9d854-879a-11ee-a4fd-dadafdb14cb0','도메인 조회 API','도메인 조회 API','/identity/domains','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','identity','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cea36fd-879a-11ee-a4fd-dadafdb14cb0','서비스 별 자원 이름 조회','서비스 별 자원 이름 조회','/getResourceName','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','catalog','resource','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cea86b5-879a-11ee-a4fd-dadafdb14cb0','대시보드 공급자 자원 사용량 API','대시보드 공급자 자원 사용량 API','/dashboard/provider-statistics','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','dashboard','dashboard','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cead96c-879a-11ee-a4fd-dadafdb14cb0','Service-status','Service-status','/dashboard/prometheus/service-status','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','dashboard','hypervisor','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ceb2335-879a-11ee-a4fd-dadafdb14cb0','대시보드 공급자 자원 사용량 그래프 API','대시보드 공급자 자원 사용량 그래프 API','/dashboard/prometheus/provider-resource-usage-graph','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','dashboard','prometheus','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ceb70b0-879a-11ee-a4fd-dadafdb14cb0','대시보드 프로젝트별 쿼터 사용량','대시보드 프로젝트별 쿼터 사용량','/dashboard/projects-quota','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','dashboard','project','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cebb4c5-879a-11ee-a4fd-dadafdb14cb0','대시보드 인프라 자원 현황 API','대시보드 인프라 자원 현황 API','/dashboard/infra-statistics','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','dashboard','infra','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cebf884-879a-11ee-a4fd-dadafdb14cb0','연결된 프로젝트 테스트 조회 API','연결된 프로젝트 테스트 조회 API','/dashboard/connected-project-list/test/provider/{providerId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','dashboard','project','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cec60f0-879a-11ee-a4fd-dadafdb14cb0','연결된 프로젝트 조회 API','연결된 프로젝트 조회 API','/dashboard/connected-project-list/provider/{providerId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','dashboard','project','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0cecbcd9-879a-11ee-a4fd-dadafdb14cb0','Show Hypervisor Statistics','Show Hypervisor Statistics','/dashboard/compute/servers/os-hypervisors','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','dashboard','hypervisor','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ced06db-879a-11ee-a4fd-dadafdb14cb0','인스턴스 모니터링 API','인스턴스 모니터링 API','/compute/servers/{instanceId}/monitor','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ced4bfb-879a-11ee-a4fd-dadafdb14cb0','인스턴스 스냅샷 유형 목록 조회 API','인스턴스 스냅샷 유형 목록 조회 API','/compute/servers/snapshots/filter-by-id','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','glance','image','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0ced8ef7-879a-11ee-a4fd-dadafdb14cb0','프로젝트 유저 삭제 API','프로젝트 유저 삭제 API','/identity/roles/unassign-role/{projectId}/users/{userId}/roles/{roleId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','keystone','identity','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('0d2495a5-9f9e-11ee-a438-3e72d96d3fbc','사용자 최초 조직 할당','사용자 최초 조직 할당','/user/org/{userId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','management','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0d27013f-9f9e-11ee-a438-3e72d96d3fbc','메뉴 허용 기능 수정','허용 기능 목록 수정','/menu/{menuId}/features','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','menu','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('0d921179-0adc-11f0-8e4c-52e9553a2057','릴리즈 노트 상세 조회','릴리즈 노트 상세 조회','/support/release-note/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','support-center','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0d937433-0adc-11f0-8e4c-52e9553a2057','릴리즈 노트 목록 조회','릴리즈 노트 목록 조회','/support/release-notes','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','support-center','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0df0d31a-39eb-11f0-80c3-6e593baabd40','NetApp Storage 볼륨 목록 조회','NetApp Storage 볼륨 목록 조회','/v2/storages-api/volumes','910fa43a-7797-11ee-b465-565158862942','Vista','observability','storage','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('0df1f2ca-39eb-11f0-80c3-6e593baabd40','NetApp Storage SVM 목록 조회','NetApp Storage SVM 목록 조회','/v2/storages-api/svms','910fa43a-7797-11ee-b465-565158862942','Vista','observability','storage','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('0df21db4-39eb-11f0-80c3-6e593baabd40','NetApp Storage 노드 목록 조회','NetApp Storage 노드 목록 조회','/v2/storages-api/nodes','910fa43a-7797-11ee-b465-565158862942','Vista','observability','storage','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('0df24700-39eb-11f0-80c3-6e593baabd40','NetApp Storage EMS 이벤트 목록 조회','NetApp Storage EMS 이벤트 목록 조회','/v2/storages-api/ems','910fa43a-7797-11ee-b465-565158862942','Vista','observability','storage','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('0df265e3-39eb-11f0-80c3-6e593baabd40','NetApp Storage 디스크 목록 조회','NetApp Storage 디스크 목록 조회','/v2/storages-api/disks','910fa43a-7797-11ee-b465-565158862942','Vista','observability','storage','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('0df287f5-39eb-11f0-80c3-6e593baabd40','NetApp Storage 클러스터 연결 확인','NetApp Storage 클러스터 연결 확인','/v2/storages-api/connect/check','910fa43a-7797-11ee-b465-565158862942','Vista','observability','storage','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('0df2b0e6-39eb-11f0-80c3-6e593baabd40','NetApp Storage 클러스터 메트릭 조회','NetApp Storage 클러스터 메트릭 조회','/v2/storages-api/clusters/metrics','910fa43a-7797-11ee-b465-565158862942','Vista','observability','storage','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('0df2d482-39eb-11f0-80c3-6e593baabd40','NetApp Storage 메인 페이지 클러스터 목록 조회','NetApp Storage 메인 페이지 클러스터 목록 조회','/v2/storages-api/clusters/main','910fa43a-7797-11ee-b465-565158862942','Vista','observability','storage','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('0df2f9c1-39eb-11f0-80c3-6e593baabd40','NetApp Storage 어그리게이트 목록 조회','NetApp Storage 어그리게이트 목록 조회','/v2/storages-api/aggregates','910fa43a-7797-11ee-b465-565158862942','Vista','observability','storage','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('0e6868a6-3e8b-11ef-9f42-5e230e3817dd','가상서비스 상세 조회','가상서비스 상세 조회','/v1/k8s/namespaces/{namespaceName}/virtualservices/{virtualServiceName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e68c35a-3e8b-11ef-9f42-5e230e3817dd','가상서비스 수정','가상서비스 수정','/v1/k8s/namespaces/{namespaceName}/virtualservices/{virtualServiceName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e690cb1-3e8b-11ef-9f42-5e230e3817dd','가상서비스 삭제','가상서비스 삭제','/v1/k8s/namespaces/{namespaceName}/virtualservices/{virtualServiceName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e694c40-3e8b-11ef-9f42-5e230e3817dd','게이트웨이 상세 조회','게이트웨이 상세 조회','/v1/k8s/namespaces/{namespaceName}/gateways/{gatewayName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','gateway','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e698e9e-3e8b-11ef-9f42-5e230e3817dd','게이트웨이 수정','게이트웨이 수정','/v1/k8s/namespaces/{namespaceName}/gateways/{gatewayName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','gateway','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e69d230-3e8b-11ef-9f42-5e230e3817dd','게이트웨이 삭제','게이트웨이 삭제','/v1/k8s/namespaces/{namespaceName}/gateways/{gatewayName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','gateway','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e6a12a2-3e8b-11ef-9f42-5e230e3817dd','트래픽 정책 상세 정보 조회','트래픽 정책 상세 정보 조회','/v1/k8s/namespaces/{namespaceName}/destinationrules/{destinationRuleName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','destinationrule','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('0e6a4f70-3e8b-11ef-9f42-5e230e3817dd','트래픽 정책 수정','트래픽 정책 수정','/v1/k8s/namespaces/{namespaceName}/destinationrules/{destinationRuleName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','destinationrule','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e6a8f1a-3e8b-11ef-9f42-5e230e3817dd','트래픽 정책 삭제','트래픽 정책 삭제','/v1/k8s/namespaces/{namespaceName}/destinationrules/{destinationRuleName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','destinationrule','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e6bce24-3e8b-11ef-9f42-5e230e3817dd','트래픽 모니터링','트래픽 모니터링','/v1/k8s/trafficmonitorings/connection/test','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','trafficmonitoring','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e6c0209-3e8b-11ef-9f42-5e230e3817dd','네임스페이스별 가상서비스 리스트 조회','네임스페이스별 가상서비스 리스트 조회','/v1/k8s/namespaces/{namespaceName}/virtualservices','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e6c3d6a-3e8b-11ef-9f42-5e230e3817dd','가상서비스 생성','가상서비스 생성','/v1/k8s/namespaces/{namespaceName}/virtualservices','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e6c6d72-3e8b-11ef-9f42-5e230e3817dd','네임스페이스별 게이트웨이 리스트 조회','네임스페이스별 게이트웨이 리스트 조회','/v1/k8s/namespaces/{namespaceName}/gateways','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','gateway','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e6c9d7a-3e8b-11ef-9f42-5e230e3817dd','게이트웨이 생성','게이트웨이 생성','/v1/k8s/namespaces/{namespaceName}/gateways','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','gateway','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e6ce0bb-3e8b-11ef-9f42-5e230e3817dd','네임스페이스별 트래픽 정책 리스트 조회','네임스페이스별 트래픽 정책 리스트 조회','/v1/k8s/namespaces/{namespaceName}/destinationrules','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','destinationrule','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e6d162a-3e8b-11ef-9f42-5e230e3817dd','트래픽 정책 생성','트래픽 정책 생성','/v1/k8s/namespaces/{namespaceName}/destinationrules','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','destinationrule','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e6d4d38-3e8b-11ef-9f42-5e230e3817dd','클러스터 노드 스케일링','클러스터 노드 스케일링','/v1/k8s/management/clusters/{clusterName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','PATCH',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e6d8452-3e8b-11ef-9f42-5e230e3817dd','가상서비스 리스트 조회','가상서비스 리스트 조회','/v1/k8s/virtualservices','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e6dbce0-3e8b-11ef-9f42-5e230e3817dd','트래픽 모니터링','트래픽 모니터링','/v1/k8s/trafficmonitorings/**','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','trafficmonitoring','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e6df458-3e8b-11ef-9f42-5e230e3817dd','가상서비스 yaml 정보 조회','가상서비스 yaml 정보 조회','/v1/k8s/namespaces/{namespaceName}/virtualservices/{virtualServiceName}/yaml','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e6e25a1-3e8b-11ef-9f42-5e230e3817dd','가상서비스 상세 정보(게이트웨이) 조회','가상서비스 상세 정보(게이트웨이) 조회','/v1/k8s/namespaces/{namespaceName}/virtualservices/{virtualServiceName}/gateway','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e6e68a0-3e8b-11ef-9f42-5e230e3817dd','가상서비스 상세 기본정보 조회','가상서비스 상세 기본정보 조회','/v1/k8s/namespaces/{namespaceName}/virtualservices/{virtualServiceName}/detail','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e6eacb6-3e8b-11ef-9f42-5e230e3817dd','가상서비스 상세 정보(목적지 서비스) 조회','가상서비스 상세 정보(목적지 서비스) 조회','/v1/k8s/namespaces/{namespaceName}/virtualservices/{virtualServiceName}/destinationservice','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e6ee96d-3e8b-11ef-9f42-5e230e3817dd','게이트웨이별 가상서비스 리스트 조회','게이트웨이별 가상서비스 리스트 조회','/v1/k8s/namespaces/{namespaceName}/virtualservices/gateways/{gatewayName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e6f1b52-3e8b-11ef-9f42-5e230e3817dd','게이트웨이 yaml 정보 조회 (json)','게이트웨이 yaml 정보 조회 (json)','/v1/k8s/namespaces/{namespaceName}/gateways/{gatewayName}/yaml','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','gateway','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e6f4f67-3e8b-11ef-9f42-5e230e3817dd','트래픽 규칙 yaml 정보 조회 (json)','트래픽 규칙 yaml 정보 조회 (json)','/v1/k8s/namespaces/{namespaceName}/destinationrules/{destinationRuleName}/yaml','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','destinationrule','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e6f9198-3e8b-11ef-9f42-5e230e3817dd','트래픽 규칙과 연결된 가상서비스 조회','트래픽 규칙과 연결된 가상서비스 조회','/v1/k8s/namespaces/{namespaceName}/destinationrules/{destinationRuleName}/virtualservice','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','destinationrule','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('0e6fd4b0-3e8b-11ef-9f42-5e230e3817dd','트래픽 규칙 상세 정보 조회 (subset 별 detail)','트래픽 규칙 상세 정보 조회 (subset 별 detail)','/v1/k8s/namespaces/{namespaceName}/destinationrules/{destinationRuleName}/detail','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','destinationrule','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e71b90a-3e8b-11ef-9f42-5e230e3817dd','게이트웨이 리스트 조회','게이트웨이 리스트 조회','/v1/k8s/gateways','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','gateway','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e7203a0-3e8b-11ef-9f42-5e230e3817dd','트래픽 정책 리스트 조회','트래픽 정책 리스트 조회','/v1/k8s/destinationrules','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','destinationrule','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('0e7243e1-3e8b-11ef-9f42-5e230e3817dd','퍼시스턴트 볼륨 상세 조회','퍼시스턴트 볼륨 상세 조회','/v1/k8s/persistentvolumes/{persistentVolumeName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','persistentvolume','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e727b40-3e8b-11ef-9f42-5e230e3817dd','퍼시스턴트 볼륨 수정','퍼시스턴트 볼륨 수정','/v1/k8s/persistentvolumes/{persistentVolumeName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','persistentvolume','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e72c080-3e8b-11ef-9f42-5e230e3817dd','퍼시스턴트 볼륨 삭제','퍼시스턴트 볼륨 삭제','/v1/k8s/persistentvolumes/{persistentVolumeName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','persistentvolume','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e72f2a3-3e8b-11ef-9f42-5e230e3817dd','가상서비스 상세 조회','가상서비스 상세 조회','/v1/k8s/namespaces/{namespaceName}/virtualservices/{virtualServiceName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e732417-3e8b-11ef-9f42-5e230e3817dd','가상서비스 수정','가상서비스 수정','/v1/k8s/namespaces/{namespaceName}/virtualservices/{virtualServiceName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e735ddd-3e8b-11ef-9f42-5e230e3817dd','가상서비스 삭제','가상서비스 삭제','/v1/k8s/namespaces/{namespaceName}/virtualservices/{virtualServiceName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e738e62-3e8b-11ef-9f42-5e230e3817dd','서비스 상세 조회','서비스 상세 조회','/v1/k8s/namespaces/{namespaceName}/services/{serviceName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','network','service','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e73c171-3e8b-11ef-9f42-5e230e3817dd','서비스 수정','서비스 수정','/v1/k8s/namespaces/{namespaceName}/services/{serviceName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','network','service','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e73f26b-3e8b-11ef-9f42-5e230e3817dd','서비스 삭제','서비스 삭제','/v1/k8s/namespaces/{namespaceName}/services/{serviceName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','network','service','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e741fef-3e8b-11ef-9f42-5e230e3817dd','롤 상세 조회','롤 상세 조회','/v1/k8s/namespaces/{namespaceName}/roles/{roleName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','serviceaccount','role','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e744e7c-3e8b-11ef-9f42-5e230e3817dd','롤 수정','롤 수정','/v1/k8s/namespaces/{namespaceName}/roles/{roleName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','serviceaccount','role','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e747da5-3e8b-11ef-9f42-5e230e3817dd','롤 삭제','롤 삭제','/v1/k8s/namespaces/{namespaceName}/roles/{roleName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','serviceaccount','role','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e74bc61-3e8b-11ef-9f42-5e230e3817dd','퍼시스턴트 볼륨 클레임 상세 조회','퍼시스턴트 볼륨 클레임 상세 조회','/v1/k8s/namespaces/{namespaceName}/persistentvolumeclaims/{persistentvolumeclaimName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','persistentvolumeclaim','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e74f107-3e8b-11ef-9f42-5e230e3817dd','퍼시스턴트 볼륨 클레임 수정','퍼시스턴트 볼륨 클레임 수정','/v1/k8s/namespaces/{namespaceName}/persistentvolumeclaims/{persistentvolumeclaimName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','persistentvolumeclaim','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e751ed7-3e8b-11ef-9f42-5e230e3817dd','퍼시스턴트 볼륨 클레임 삭제','퍼시스턴트 볼륨 클레임 삭제','/v1/k8s/namespaces/{namespaceName}/persistentvolumeclaims/{persistentvolumeclaimName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','persistentvolumeclaim','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e754f3f-3e8b-11ef-9f42-5e230e3817dd','네트워크 폴리시 상세 조회','네트워크 폴리시 상세 조회','/v1/k8s/namespaces/{namespaceName}/networkpolicies/{networkPolicyName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','network','networkpolicy','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e75816f-3e8b-11ef-9f42-5e230e3817dd','네트워크 폴리시 수정','네트워크 폴리시 수정','/v1/k8s/namespaces/{namespaceName}/networkpolicies/{networkPolicyName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','network','networkpolicy','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('0e75ac77-3e8b-11ef-9f42-5e230e3817dd','네트워크 폴리시 삭제','네트워크 폴리시 삭제','/v1/k8s/namespaces/{namespaceName}/networkpolicies/{networkPolicyName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','network','networkpolicy','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e75d970-3e8b-11ef-9f42-5e230e3817dd','HPA 상세 조회','HPA 상세 조회','/v1/k8s/namespaces/{namespaceName}/horizontalpodautoscalers/{horizontalPodAutoScalerName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','horizontal pod autoscaling','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e760aba-3e8b-11ef-9f42-5e230e3817dd','HPA 수정','HPA 수정','/v1/k8s/namespaces/{namespaceName}/horizontalpodautoscalers/{horizontalPodAutoScalerName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','horizontal pod autoscaling','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e763d52-3e8b-11ef-9f42-5e230e3817dd','HPA 삭제','HPA 삭제','/v1/k8s/namespaces/{namespaceName}/horizontalpodautoscalers/{horizontalPodAutoScalerName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','horizontal pod autoscaling','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e767163-3e8b-11ef-9f42-5e230e3817dd','게이트웨이 상세 조회','게이트웨이 상세 조회','/v1/k8s/namespaces/{namespaceName}/gateways/{gatewayName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','gateway','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e76aba8-3e8b-11ef-9f42-5e230e3817dd','게이트웨이 수정','게이트웨이 수정','/v1/k8s/namespaces/{namespaceName}/gateways/{gatewayName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','gateway','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e76e0bf-3e8b-11ef-9f42-5e230e3817dd','게이트웨이 삭제','게이트웨이 삭제','/v1/k8s/namespaces/{namespaceName}/gateways/{gatewayName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','gateway','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e771561-3e8b-11ef-9f42-5e230e3817dd','트래픽 정책 상세 정보 조회','트래픽 정책 상세 정보 조회','/v1/k8s/namespaces/{namespaceName}/destinationrules/{destinationRuleName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','destinationrule','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e774c74-3e8b-11ef-9f42-5e230e3817dd','트래픽 정책 수정','트래픽 정책 수정','/v1/k8s/namespaces/{namespaceName}/destinationrules/{destinationRuleName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','destinationrule','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e77896f-3e8b-11ef-9f42-5e230e3817dd','트래픽 정책 삭제','트래픽 정책 삭제','/v1/k8s/namespaces/{namespaceName}/destinationrules/{destinationRuleName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','destinationrule','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e77c647-3e8b-11ef-9f42-5e230e3817dd','컨피그맵 상세 조회','컨피그맵 상세 조회','/v1/k8s/namespaces/{namespaceName}/configmaps/{configMapName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','configmap','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e77feb4-3e8b-11ef-9f42-5e230e3817dd','컨피그맵 수정','컨피그맵 수정','/v1/k8s/namespaces/{namespaceName}/configmaps/{configMapName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','configmap','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e78b764-3e8b-11ef-9f42-5e230e3817dd','컨피그맵 삭제','컨피그맵 삭제','/v1/k8s/namespaces/{namespaceName}/configmaps/{configMapName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','configmap','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e7a22c8-3e8b-11ef-9f42-5e230e3817dd','트래픽 모니터링','트래픽 모니터링','/v1/k8s/trafficmonitorings/connection/test','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','trafficmonitoring','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e7a59f3-3e8b-11ef-9f42-5e230e3817dd','전체 퍼시스턴트 볼륨 리스트 조회','전체 퍼시스턴트 볼륨 리스트 조회','/v1/k8s/persistentvolumes','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','persistentvolume','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e7a92ab-3e8b-11ef-9f42-5e230e3817dd','퍼시스턴트 볼륨 생성','퍼시스턴트 볼륨 생성','/v1/k8s/persistentvolumes','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','persistentvolume','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e7ad3eb-3e8b-11ef-9f42-5e230e3817dd','네임스페이스별 가상서비스 리스트 조회','네임스페이스별 가상서비스 리스트 조회','/v1/k8s/namespaces/{namespaceName}/virtualservices','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e7b0ee2-3e8b-11ef-9f42-5e230e3817dd','가상서비스 생성','가상서비스 생성','/v1/k8s/namespaces/{namespaceName}/virtualservices','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e7b48c7-3e8b-11ef-9f42-5e230e3817dd','네임스페이스별 서비스 리스트 조회','네임스페이스별 서비스 리스트 조회','/v1/k8s/namespaces/{namespaceName}/services','345ae518-f857-11ed-921d-aa1950d374e1','Viola','network','service','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e7b7c34-3e8b-11ef-9f42-5e230e3817dd','서비스 생성','서비스 생성','/v1/k8s/namespaces/{namespaceName}/services','345ae518-f857-11ed-921d-aa1950d374e1','Viola','network','service','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('0e7bacf1-3e8b-11ef-9f42-5e230e3817dd','네임스페이스별 롤 리스트 조회','네임스페이스별 롤 리스트 조회','/v1/k8s/namespaces/{namespaceName}/roles','345ae518-f857-11ed-921d-aa1950d374e1','Viola','serviceaccount','role','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e7be26a-3e8b-11ef-9f42-5e230e3817dd','롤 생성','롤 생성','/v1/k8s/namespaces/{namespaceName}/roles','345ae518-f857-11ed-921d-aa1950d374e1','Viola','serviceaccount','role','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e7c1d05-3e8b-11ef-9f42-5e230e3817dd','네임스페이스별 퍼시스턴트 볼륨 클레임 리스트 조회','네임스페이스별 퍼시스턴트 볼륨 클레임 리스트 조회','/v1/k8s/namespaces/{namespaceName}/persistentvolumeclaims','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','persistentvolumeclaim','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e7c5946-3e8b-11ef-9f42-5e230e3817dd','퍼시스턴트 볼륨 클레임 생성','퍼시스턴트 볼륨 클레임 생성','/v1/k8s/namespaces/{namespaceName}/persistentvolumeclaims','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','persistentvolumeclaim','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e7c91aa-3e8b-11ef-9f42-5e230e3817dd','네임스페이스별 네트워크 폴리시 리스트 조회','네임스페이스별 네트워크 폴리시 리스트 조회','/v1/k8s/namespaces/{namespaceName}/networkpolicies','345ae518-f857-11ed-921d-aa1950d374e1','Viola','network','networkpolicy','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e7cc53f-3e8b-11ef-9f42-5e230e3817dd','네트워크 폴리시 생성','네트워크 폴리시 생성','/v1/k8s/namespaces/{namespaceName}/networkpolicies','345ae518-f857-11ed-921d-aa1950d374e1','Viola','network','networkpolicy','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e7cf7fc-3e8b-11ef-9f42-5e230e3817dd','네임스페이스별 HPA 리스트 조회','네임스페이스별 HPA 리스트 조회','/v1/k8s/namespaces/{namespaceName}/horizontalpodautoscalers','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','horizontal pod autoscaling','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e7d2926-3e8b-11ef-9f42-5e230e3817dd','HPA 생성','HPA 생성','/v1/k8s/namespaces/{namespaceName}/horizontalpodautoscalers','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','horizontal pod autoscaling','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e7d5f33-3e8b-11ef-9f42-5e230e3817dd','네임스페이스별 게이트웨이 리스트 조회','네임스페이스별 게이트웨이 리스트 조회','/v1/k8s/namespaces/{namespaceName}/gateways','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','gateway','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e7d992b-3e8b-11ef-9f42-5e230e3817dd','게이트웨이 생성','게이트웨이 생성','/v1/k8s/namespaces/{namespaceName}/gateways','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','gateway','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e7dcc36-3e8b-11ef-9f42-5e230e3817dd','네임스페이스별 트래픽 정책 리스트 조회','네임스페이스별 트래픽 정책 리스트 조회','/v1/k8s/namespaces/{namespaceName}/destinationrules','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','destinationrule','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e7dffda-3e8b-11ef-9f42-5e230e3817dd','트래픽 정책 생성','트래픽 정책 생성','/v1/k8s/namespaces/{namespaceName}/destinationrules','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','destinationrule','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e7e3941-3e8b-11ef-9f42-5e230e3817dd','네임스페이스별 컨피그맵 리스트 조회','네임스페이스별 컨피그맵 리스트 조회','/v1/k8s/namespaces/{namespaceName}/configmaps','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','configmap','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e7e77d8-3e8b-11ef-9f42-5e230e3817dd','컨피그맵 생성','컨피그맵 생성','/v1/k8s/namespaces/{namespaceName}/configmaps','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','configmap','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e7f6e7b-3e8b-11ef-9f42-5e230e3817dd','클러스터 노드 스케일링','클러스터 노드 스케일링','/v1/k8s/management/clusters/{clusterName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','PATCH',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e7fa58e-3e8b-11ef-9f42-5e230e3817dd','가상서비스 리스트 조회','가상서비스 리스트 조회','/v1/k8s/virtualservices','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e7fd87e-3e8b-11ef-9f42-5e230e3817dd','트래픽 모니터링','트래픽 모니터링','/v1/k8s/trafficmonitorings/**','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','trafficmonitoring','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e800994-3e8b-11ef-9f42-5e230e3817dd','전체 서비스 리스트 조회','전체 서비스 리스트 조회','/v1/k8s/services','345ae518-f857-11ed-921d-aa1950d374e1','Viola','network','service','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e803aa3-3e8b-11ef-9f42-5e230e3817dd','전체 롤 리스트 조회','전체 롤 리스트 조회','/v1/k8s/roles','345ae518-f857-11ed-921d-aa1950d374e1','Viola','serviceaccount','role','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e8067cf-3e8b-11ef-9f42-5e230e3817dd','전체 퍼시스턴트 볼륨 클레임 리스트 조회','전체 퍼시스턴트 볼륨 클레임 리스트 조회','/v1/k8s/persistentvolumeclaims','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','persistentvolumeclaim','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('0e811931-3e8b-11ef-9f42-5e230e3817dd','전체 노드 리스트 조회','전체 노드 리스트 조회','/v1/k8s/nodes','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','node','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e816518-3e8b-11ef-9f42-5e230e3817dd','노드 상세 조회','노드 상세 조회','/v1/k8s/nodes/{nodeName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','node','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e819758-3e8b-11ef-9f42-5e230e3817dd','전체 네트워크 폴리시 리스트 조회','전체 네트워크 폴리시 리스트 조회','/v1/k8s/networkpolicies','345ae518-f857-11ed-921d-aa1950d374e1','Viola','network','networkpolicy','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e81cd83-3e8b-11ef-9f42-5e230e3817dd','가상서비스 yaml 정보 조회','가상서비스 yaml 정보 조회','/v1/k8s/namespaces/{namespaceName}/virtualservices/{virtualServiceName}/yaml','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e8212fe-3e8b-11ef-9f42-5e230e3817dd','가상서비스 상세 정보(게이트웨이) 조회','가상서비스 상세 정보(게이트웨이) 조회','/v1/k8s/namespaces/{namespaceName}/virtualservices/{virtualServiceName}/gateway','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e824939-3e8b-11ef-9f42-5e230e3817dd','가상서비스 상세 기본정보 조회','가상서비스 상세 기본정보 조회','/v1/k8s/namespaces/{namespaceName}/virtualservices/{virtualServiceName}/detail','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e827877-3e8b-11ef-9f42-5e230e3817dd','가상서비스 상세 정보(목적지 서비스) 조회','가상서비스 상세 정보(목적지 서비스) 조회','/v1/k8s/namespaces/{namespaceName}/virtualservices/{virtualServiceName}/destinationservice','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e82a14e-3e8b-11ef-9f42-5e230e3817dd','게이트웨이별 가상서비스 리스트 조회','게이트웨이별 가상서비스 리스트 조회','/v1/k8s/namespaces/{namespaceName}/virtualservices/gateways/{gatewayName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e82d751-3e8b-11ef-9f42-5e230e3817dd','게이트웨이 yaml 정보 조회 (json)','게이트웨이 yaml 정보 조회 (json)','/v1/k8s/namespaces/{namespaceName}/gateways/{gatewayName}/yaml','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','gateway','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e830ab5-3e8b-11ef-9f42-5e230e3817dd','트래픽 규칙 yaml 정보 조회 (json)','트래픽 규칙 yaml 정보 조회 (json)','/v1/k8s/namespaces/{namespaceName}/destinationrules/{destinationRuleName}/yaml','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','destinationrule','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e83385a-3e8b-11ef-9f42-5e230e3817dd','트래픽 규칙과 연결된 가상서비스 조회','트래픽 규칙과 연결된 가상서비스 조회','/v1/k8s/namespaces/{namespaceName}/destinationrules/{destinationRuleName}/virtualservice','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','destinationrule','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e8365ac-3e8b-11ef-9f42-5e230e3817dd','트래픽 규칙 상세 정보 조회 (subset 별 detail)','트래픽 규칙 상세 정보 조회 (subset 별 detail)','/v1/k8s/namespaces/{namespaceName}/destinationrules/{destinationRuleName}/detail','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','destinationrule','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e8391bd-3e8b-11ef-9f42-5e230e3817dd','전체 HPA 리스트 조회','전체 HPA 리스트 조회','/v1/k8s/horizontalpodautoscalers','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','horizontal pod autoscaling','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e83bbf0-3e8b-11ef-9f42-5e230e3817dd','게이트웨이 리스트 조회','게이트웨이 리스트 조회','/v1/k8s/gateways','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','gateway','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e83e7ce-3e8b-11ef-9f42-5e230e3817dd','트래픽 정책 리스트 조회','트래픽 정책 리스트 조회','/v1/k8s/destinationrules','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','destinationrule','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0e8412d8-3e8b-11ef-9f42-5e230e3817dd','전체 컨피그맵 리스트 조회','전체 컨피그맵 리스트 조회','/v1/k8s/configmaps','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','configmap','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('0eaafd3b-edbc-11ef-945c-1a18cace67cc','서비스-오브젝트 variable.tf 특정 Key 조회 API','서비스-오브젝트 variable.tf 특정 Key 조회 API','/service-objects/{id}/extract-variable','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('0f8ebcdb-3799-11f0-80c3-6e593baabd40','NetApp Storage 클러스터 메트릭 조회','NetApp Storage 클러스터 메트릭 조회','/v2/storages/clusters/metrics','910fa43a-7797-11ee-b465-565158862942','Vista','observability','storage','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('0f8f6827-3799-11f0-80c3-6e593baabd40','NetApp Storage 메인 페이지 클러스터 목록 조회','NetApp Storage 메인 페이지 클러스터 목록 조회','/v2/storages/clusters/main','910fa43a-7797-11ee-b465-565158862942','Vista','observability','storage','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('0f9839f5-27bf-11ef-9f42-5e230e3817dd','인바운드 생성','인바운드 생성','/security-groups/ingresses','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('0f98b7a6-27bf-11ef-9f42-5e230e3817dd','인바운드 삭제','인바운드 삭제','/security-groups/ingresses','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0f990c7d-27bf-11ef-9f42-5e230e3817dd','아웃바운드 생성','아웃바운드 생성','/security-groups/egresses','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0f995977-27bf-11ef-9f42-5e230e3817dd','아웃바운드 삭제','아웃바운드 삭제','/security-groups/egresses','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0f99a523-27bf-11ef-9f42-5e230e3817dd','라우팅 테이블 라우트 추가','라우팅 테이블 라우트 추가','/network/route-tables/routes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0f9a927d-27bf-11ef-9f42-5e230e3817dd','라우팅 테이블 라우트 제거','라우팅 테이블 라우트 제거','/network/route-tables/routes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0f9ae821-27bf-11ef-9f42-5e230e3817dd','Volume 리스트 조회','Volume 리스트 조회','/volumes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volumes','volume','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0f9b7c6a-27bf-11ef-9f42-5e230e3817dd','Volume 리스트 필터 조회','Volume 리스트 필터 조회','/volumes/filters','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volumes','volume','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('0f9c728d-27bf-11ef-9f42-5e230e3817dd','인바운드 생성','인바운드 생성','/security-groups/ingresses','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0f9ce620-27bf-11ef-9f42-5e230e3817dd','인바운드 삭제','인바운드 삭제','/security-groups/ingresses','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0f9d5fbb-27bf-11ef-9f42-5e230e3817dd','아웃바운드 생성','아웃바운드 생성','/security-groups/egresses','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0f9dacc5-27bf-11ef-9f42-5e230e3817dd','아웃바운드 삭제','아웃바운드 삭제','/security-groups/egresses','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0f9df013-27bf-11ef-9f42-5e230e3817dd','라우팅 테이블 라우트 추가','라우팅 테이블 라우트 추가','/network/route-tables/routes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0f9e2df2-27bf-11ef-9f42-5e230e3817dd','라우팅 테이블 라우트 제거','라우팅 테이블 라우트 제거','/network/route-tables/routes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0f9e60e3-27bf-11ef-9f42-5e230e3817dd','Volume 리스트 조회','Volume 리스트 조회','/volumes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volumes','volume','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('0f9ea178-27bf-11ef-9f42-5e230e3817dd','Volume 리스트 필터 조회','Volume 리스트 필터 조회','/volumes/filters','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volumes','volume','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('104cff6b-5541-11ef-97d4-9676f6708993','서비스-카탈로그-요청 조회(userId 강제전달 삭제) API','서비스-카탈로그-요청 조회(userId 강제전달 삭제) API','/service-objects/requests/viola','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('11e3e9b9-2de2-11ef-9f42-5e230e3817dd','[NEW]전체 조직/폴더/워크스페이스 월별 비용 조회','[NEW]전체 조직/폴더/워크스페이스 월별 비용 조회','/cost/total-analysis/organization/workspace-all-new','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','cost','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('11e47434-2de2-11ef-9f42-5e230e3817dd','서비스-카탈로그 카테고리 상세 조회 API','서비스-카탈로그 카테고리 상세 조회 API','/service-objects/requests/types/detail','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('11e4dc00-2de2-11ef-9f42-5e230e3817dd','역할 타입과 조직에 배포된 역할 조회 API','역할 타입과 조직에 배포된 역할 조회 API','/roles/typesAndDeployed','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','role','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('12116ca9-4e37-11ef-8f18-c6494ca007d9','AWS 가상머신 정지','AWS 가상머신 정지','/workspaces/servers/aws/tenants/{tenantId}/instances/{instanceId}/stop','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('1211a966-4e37-11ef-8f18-c6494ca007d9','AWS 가상머신 시작','AWS 가상머신 시작','/workspaces/servers/aws/tenants/{tenantId}/instances/{instanceId}/start','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('1211d47c-4e37-11ef-8f18-c6494ca007d9','AWS 가상머신 재시작','AWS 가상머신 재시작','/workspaces/servers/aws/tenants/{tenantId}/instances/{instanceId}/reboot','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('12333929-4d87-11ef-8f18-c6494ca007d9','객체 삭제 멀티','객체 삭제 멀티','/storages/objects/{bucketName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('12337b38-4d87-11ef-8f18-c6494ca007d9','객체 삭제 멀티','객체 삭제 멀티','/storages/objects/{bucketName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('136cb432-65cf-11ef-aa9f-f2cdef6842ce','rack 선택 조회','rack 선택 조회','/topology/rack/{id}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','topology','select-rack','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('136dbcf2-65cf-11ef-aa9f-f2cdef6842ce','websocket 테스트','websocket 테스트','/test/notice','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','websocket','test','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('136e0171-65cf-11ef-aa9f-f2cdef6842ce','Response-Error-Test','Response-Error-Test','/mole/test-error-response','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','test','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('136e3ae4-65cf-11ef-aa9f-f2cdef6842ce','proxy','proxy','/mole/proxy','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','vip','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('136e6b32-65cf-11ef-aa9f-f2cdef6842ce','instance-max-resources','instance-max-resources','/mole/instance-max-resources','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','mole','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('136e9983-65cf-11ef-aa9f-f2cdef6842ce','인스턴스 일시정지 해제 - pause server','인스턴스 일시정지 해제 - pause server','/compute/servers/{serverId}/action/un-pause','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('136ed390-65cf-11ef-aa9f-f2cdef6842ce','version','version','/version','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','version','version','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('136f25b2-65cf-11ef-aa9f-f2cdef6842ce','Token 테스트','Token 테스트','/token/test','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','token','test','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('136f5425-65cf-11ef-aa9f-f2cdef6842ce','rack 선택 조회','rack 선택 조회','/topology/rack/{id}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','topology','select-rack','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('136f7e39-65cf-11ef-aa9f-f2cdef6842ce','websocket 테스트','websocket 테스트','/test/notice','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','websocket','test','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('136faac2-65cf-11ef-aa9f-f2cdef6842ce','Response-Error-Test','Response-Error-Test','/mole/test-error-response','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','test','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('136fd697-65cf-11ef-aa9f-f2cdef6842ce','proxy','proxy','/mole/proxy','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','vip','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('136fffbe-65cf-11ef-aa9f-f2cdef6842ce','instance-max-resources','instance-max-resources','/mole/instance-max-resources','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','mole','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('137036a6-65cf-11ef-aa9f-f2cdef6842ce','인스턴스 일시정지 해제 - pause server','인스턴스 일시정지 해제 - pause server','/compute/servers/{serverId}/action/un-pause','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('137061b5-65cf-11ef-aa9f-f2cdef6842ce','version','version','/version','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','version','version','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('1370917d-65cf-11ef-aa9f-f2cdef6842ce','Token 테스트','Token 테스트','/token/test','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','token','test','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('139e2de9-8446-11ee-a4fd-dadafdb14cb0','서비스 API 사용량 조회','서비스 API 사용량 조회','/dashboard/service-api-usage','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','dashboard','GET',1,'bb6fa9a6-8443-11ee-a4fd-dadafdb14cb0',0)
    ,   ('13fd8870-2948-11ef-9f42-5e230e3817dd','사용자 특정 조직/폴더/워크 스페이스  하위 포함 역할 조회','사용자 특정 조직/폴더/워크 스페이스  하위 포함 역할 조회','/user/access-control/{userId}/{resourceId}/roles','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','access-control','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('13ff0c56-2948-11ef-9f42-5e230e3817dd','사용자 그룹 특정 조직/폴더/워크 스페이스  하위 포함 역할 조회','사용자 그룹 특정 조직/폴더/워크 스페이스  하위 포함 역할 조회','/user/access-control/{userGroupId}/group/{resourceId}/roles','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','access-control','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('13ff8265-2948-11ef-9f42-5e230e3817dd','하위 테넌트와 공급자 함께 검색','하위 테넌트와 공급자 함께 검색','/infra/provider/with-tenants','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','infra','provider','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('140006de-2948-11ef-9f42-5e230e3817dd','관리자 그룹이 가진 역할 목록 조회','관리자 그룹이 가진 역할 목록 조회','/admin/access-control/{adminId}/group/roles','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','admin','access-control','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('141c7ef5-181c-11ef-8ee3-1ecbd3ef6ccd','워크스페이스 바톤 Ncp VM 리소스 조회','워크스페이스 바톤 Ncp VM 리소스 조회','/baton/resources/workspace/{workspaceId}/ncp/vm','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','baton','resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('141d8cf8-181c-11ef-8ee3-1ecbd3ef6ccd','바톤 Openstack Flavor 리소스 조회','바톤 Openstack Flavor 리소스 조회','/baton/resources/openstack/flavor','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','baton','resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('141dc977-181c-11ef-8ee3-1ecbd3ef6ccd','인벤토리 스토리지 조회 API','인벤토리 스토리지 조회 API','/baton/resources/inventories/storages','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','baton','resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('141df5f2-181c-11ef-8ee3-1ecbd3ef6ccd','인벤토리 서버 조회 API','인벤토리 서버 조회 API','/baton/resources/inventories/servers','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','baton','resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('141e21ef-181c-11ef-8ee3-1ecbd3ef6ccd','인벤토리 네트워 조회 API','인벤토리 네트워 조회 API','/baton/resources/inventories/networks','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','baton','resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('141e4137-181c-11ef-8ee3-1ecbd3ef6ccd','인벤토리 LB 조회 API','인벤토리 LB 조회 API','/baton/resources/inventories/load-balancers','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','baton','resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('141e65df-181c-11ef-8ee3-1ecbd3ef6ccd','Bare Metal compute node 조회 API','Bare Metal compute node 조회 API','/baton/resources/inventories/bare-metals','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','baton','resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('141e8877-181c-11ef-8ee3-1ecbd3ef6ccd','폴더 리소스 조회','폴더 리소스 조회','/baton/resources/folder/{folderId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','baton','resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('141eabfd-181c-11ef-8ee3-1ecbd3ef6ccd','폴더 리소스 조회 API','폴더 리소스 조회 API','/baton/resources/all','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','baton','resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('141ed405-181c-11ef-8ee3-1ecbd3ef6ccd','관리자 사이트 - 비밀번호 변경 전 현재 비밀번호 검증','관리자 사이트 - 비밀번호 변경 전 현재 비밀번호 검증','/profile/verify-password','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','admin','management','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('141f1ca2-181c-11ef-8ee3-1ecbd3ef6ccd','자신의 정보 조회','자신의 정보 조회','/profile/info','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','admin','management','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('15c3735f-f582-11ee-ac8e-c6591bb2a6db','유동 아이피 풀 목록 API','유동 아이피 풀 목록 조회 ','/network/floating-ip/pools','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','floatingip','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('162bc54a-0479-11f0-a3f7-5e2a9b4227fd','Tier-0 NAT Rule 수정','Tier-0 NAT Rule 수정','/nsx/nat/tier-0s/{tier-0-id}/rules','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nat','rules','PATCH',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('162ea4d3-0479-11f0-a3f7-5e2a9b4227fd','Tier-0 NAT Rule 수정','Tier-0 NAT Rule 수정','/nsx/nat/tier-0s/{tier-0-id}/rules','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nat','rules','PATCH',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('17db585e-b782-11ef-9c74-0a11b82fa8dd','서버 인증서 조회','서버 인증서 조회','/iam/certificates/server-certificate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','certificate','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('17dc1073-b782-11ef-9c74-0a11b82fa8dd','acm 인증서 조회','acm 인증서 조회','/acm/certificates/acm-certificate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','acm','certificate','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('17de28f3-b782-11ef-9c74-0a11b82fa8dd','acm 인증서 목록 조회','acm 인증서 목록 조회','/acm/certificates/acm-certificates','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','acm','certificate','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('18c11155-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshotContent 상세 조회','VolumeSnapshotContent 상세 조회','/v1/k8s/volume/volume-snapshot-content/{volumeSnapshotContentName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshotcontent','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('18c19da9-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshotContent 수정','VolumeSnapshotContent 수정','/v1/k8s/volume/volume-snapshot-content/{volumeSnapshotContentName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshotcontent','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('18c1e8a0-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshotContent 삭제','VolumeSnapshotContent 삭제','/v1/k8s/volume/volume-snapshot-content/{volumeSnapshotContentName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshotcontent','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('18c22304-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshotClass 상세 조회','VolumeSnapshotClass 상세 조회','/v1/k8s/volume/volume-snapshot-class/{volumeSnapshotClassName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshotclass','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('18c262b4-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshotClass 수정','VolumeSnapshotClass 수정','/v1/k8s/volume/volume-snapshot-class/{volumeSnapshotClassName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshotclass','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('18c2a14f-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshotClass 삭제','VolumeSnapshotClass 삭제','/v1/k8s/volume/volume-snapshot-class/{volumeSnapshotClassName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshotclass','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('18c30f52-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshot 상세 조회','VolumeSnapshot 상세 조회','/v1/k8s/namespaces/{namespaceName}/volume/volume-snapshot/{volumeSnapshotName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshot','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('18c34b98-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshot 수정','VolumeSnapshot 수정','/v1/k8s/namespaces/{namespaceName}/volume/volume-snapshot/{volumeSnapshotName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshot','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('18c38133-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshot 삭제','VolumeSnapshot 삭제','/v1/k8s/namespaces/{namespaceName}/volume/volume-snapshot/{volumeSnapshotName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshot','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('18c3b69f-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshotContent 리스트 조회','VolumeSnapshotContent 리스트 조회','/v1/k8s/volume/volume-snapshot-content','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshotcontent','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('18c3e7f5-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshotContent 생성','VolumeSnapshotContent 생성','/v1/k8s/volume/volume-snapshot-content','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshotcontent','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('18c417fc-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshotClass 리스트 조회','VolumeSnapshotClass 리스트 조회','/v1/k8s/volume/volume-snapshot-class','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshotclass','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('18c44b8b-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshotClass 생성','VolumeSnapshotClass 생성','/v1/k8s/volume/volume-snapshot-class','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshotclass','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('18c47bc8-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshot 리스트 조회','VolumeSnapshot 리스트 조회','/v1/k8s/namespaces/{namespaceName}/volume/volume-snapshot','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshot','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('18c4b8b6-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshot 생성','VolumeSnapshot 생성','/v1/k8s/namespaces/{namespaceName}/volume/volume-snapshot','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshot','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('18c4ec47-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshot 리스트 조회','VolumeSnapshot 리스트 조회','/v1/k8s/volume/volume-snapshot','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshot','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('18c51f99-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshotContent 상세 조회','VolumeSnapshotContent 상세 조회','/v1/k8s/volume/volume-snapshot-content/{volumeSnapshotContentName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshotcontent','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('18c55229-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshotContent 수정','VolumeSnapshotContent 수정','/v1/k8s/volume/volume-snapshot-content/{volumeSnapshotContentName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshotcontent','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('18c58dfd-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshotContent 삭제','VolumeSnapshotContent 삭제','/v1/k8s/volume/volume-snapshot-content/{volumeSnapshotContentName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshotcontent','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('18c5be76-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshotClass 상세 조회','VolumeSnapshotClass 상세 조회','/v1/k8s/volume/volume-snapshot-class/{volumeSnapshotClassName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshotclass','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('18c5f51b-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshotClass 수정','VolumeSnapshotClass 수정','/v1/k8s/volume/volume-snapshot-class/{volumeSnapshotClassName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshotclass','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('18c62890-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshotClass 삭제','VolumeSnapshotClass 삭제','/v1/k8s/volume/volume-snapshot-class/{volumeSnapshotClassName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshotclass','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('18c65a03-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshot 상세 조회','VolumeSnapshot 상세 조회','/v1/k8s/namespaces/{namespaceName}/volume/volume-snapshot/{volumeSnapshotName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshot','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('18c6897e-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshot 수정','VolumeSnapshot 수정','/v1/k8s/namespaces/{namespaceName}/volume/volume-snapshot/{volumeSnapshotName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshot','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('18c6bd44-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshot 삭제','VolumeSnapshot 삭제','/v1/k8s/namespaces/{namespaceName}/volume/volume-snapshot/{volumeSnapshotName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshot','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('18c6efd5-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshotContent 리스트 조회','VolumeSnapshotContent 리스트 조회','/v1/k8s/volume/volume-snapshot-content','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshotcontent','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('18c723df-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshotContent 생성','VolumeSnapshotContent 생성','/v1/k8s/volume/volume-snapshot-content','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshotcontent','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('18c75672-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshotClass 리스트 조회','VolumeSnapshotClass 리스트 조회','/v1/k8s/volume/volume-snapshot-class','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshotclass','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('18c78bb9-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshotClass 생성','VolumeSnapshotClass 생성','/v1/k8s/volume/volume-snapshot-class','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshotclass','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('18c7bdfb-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshot 리스트 조회','VolumeSnapshot 리스트 조회','/v1/k8s/namespaces/{namespaceName}/volume/volume-snapshot','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshot','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('18c7f217-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshot 생성','VolumeSnapshot 생성','/v1/k8s/namespaces/{namespaceName}/volume/volume-snapshot','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshot','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('18c823bd-4fca-11ef-8f18-c6494ca007d9','VolumeSnapshot 리스트 조회','VolumeSnapshot 리스트 조회','/v1/k8s/volume/volume-snapshot','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','volumesnapshot','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('19b73f79-8859-11ee-a4fd-dadafdb14cb0','기초 권한 동기화','기초 권한 동기화','/authorities/basic/{solutionName}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','authority','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('19b81b7a-8859-11ee-a4fd-dadafdb14cb0','사용자 기본정보 수정','사용자 기본정보 수정','/user/{userId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('19b860c8-8859-11ee-a4fd-dadafdb14cb0','사용자 비밀번호 변경','사용자 비밀번호 변경','/user/{userId}/reset-password','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('19b8a106-8859-11ee-a4fd-dadafdb14cb0','현재 비밀번호 검증','현재 비밀번호 검증','/user/verify-password/{username}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('19c9f644-6444-11ef-aa9f-f2cdef6842ce','카테고리 별 서비스 상품 개수 조회','카테고리 별 서비스 상품 개수 조회','/products/categories/product-count','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-product','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('1a28e6a6-27ba-11ef-9f42-5e230e3817dd','서비스 신청 예약 생성','서비스 신청 예약 생성','/service-objects/requests/{id}/reservation','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('1a296f02-27ba-11ef-9f42-5e230e3817dd','사용자가 속한 그룹 목록 조회','사용자가 속한 그룹 목록 조회','/user/group/{userId}/groups','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','group','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('1a30f9d1-18fe-11f0-92a4-b2a8347e4220','버킷 암호화 설정 변경','버킷 암호화 설정 변경','/storages/buckets/{bucketName}/encryption','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1a362ea7-18fe-11f0-92a4-b2a8347e4220','admin : GET/storages/objects/buckets/{bucketName}/encryption','admin : GET/storages/objects/buckets/{bucketName}/encryption','/storages/objects/buckets/{bucketName}/encryption','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1c289f36-b6c8-11ef-9c74-0a11b82fa8dd','도메인 리스트 삭제','도메인 리스트 삭제','/route53s/domains/list','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1c2a03ac-b6c8-11ef-9c74-0a11b82fa8dd','리스너 속성 조회','리스너 속성 조회','/load-balancers/listeners/attributes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancers listeners','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1c2ae49e-b6c8-11ef-9c74-0a11b82fa8dd','도메인 리스트 등록','도메인 리스트 등록','/route53s/domains/lists','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1c2b13ba-b6c8-11ef-9c74-0a11b82fa8dd','리스너 인증서 조회','리스너 인증서 조회','/load-balancers/listeners/certificates','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancers listeners','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1c2b3aea-b6c8-11ef-9c74-0a11b82fa8dd','사용가능 도메인 체크','사용가능 도메인 체크','/route53s/domains/checks','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1c2b5fb6-b6c8-11ef-9c74-0a11b82fa8dd','로드벨런서 신뢰 저장소 조회','로드벨런서 신뢰 저장소 조회','/load-balancers/trust-store','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancer','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1c2b82ec-b6c8-11ef-9c74-0a11b82fa8dd','로드벨런서 SSL 정책 조회','로드벨런서 SSL 정책 조회','/load-balancers/ssl-policy','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancer','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1c2ba65a-b6c8-11ef-9c74-0a11b82fa8dd','로드벨런서 정책 조회','로드벨런서 정책 조회','/load-balancers/policy','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancer','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1d229f05-3a81-11ef-9f42-5e230e3817dd','객체 Or 폴더 업로드','객체 Or 폴더 업로드','/storages/upload','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1d23a27a-3a81-11ef-9f42-5e230e3817dd','버킷 생성','버킷 생성','/storages/buckets','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1d23e10f-3a81-11ef-9f42-5e230e3817dd','Instance Mapping Device 조회','Instance Mapping Device 조회','/volumes/instance-mapping-device','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volumes','volume','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1d2427ce-3a81-11ef-9f42-5e230e3817dd','Device Meta data 조회','Device Meta data 조회','/volumes/device-meta','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volumes','volume','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1d2462cb-3a81-11ef-9f42-5e230e3817dd','버킷 목록 조회','버킷 목록 조회','/storages','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1d2498b8-3a81-11ef-9f42-5e230e3817dd','admin : GET/storages/objects/info/buckets/{bucketName}/**','admin : GET/storages/objects/info/buckets/{bucketName}/**','/storages/objects/info/buckets/{bucketName}/**','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1d24daa6-3a81-11ef-9f42-5e230e3817dd','admin : GET/storages/objects/buckets/{bucketName}','admin : GET/storages/objects/buckets/{bucketName}','/storages/objects/buckets/{bucketName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1d250c06-3a81-11ef-9f42-5e230e3817dd','admin : GET/storages/objects-versions/buckets/{bucketName}','admin : GET/storages/objects-versions/buckets/{bucketName}','/storages/objects-versions/buckets/{bucketName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1d253b84-3a81-11ef-9f42-5e230e3817dd','admin : GET/storages/info','admin : GET/storages/info','/storages/info','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('1d257176-3a81-11ef-9f42-5e230e3817dd','admin : GET/storages/info/buckets/{bucketName}','admin : GET/storages/info/buckets/{bucketName}','/storages/info/buckets/{bucketName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1d25abce-3a81-11ef-9f42-5e230e3817dd','객체 다운로드','객체 다운로드','/storages/download','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1d25ea80-3a81-11ef-9f42-5e230e3817dd','버킷이름 중복체크','버킷이름 중복체크','/storages/buckets/duplicate-check/{bucketName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1d264d80-3a81-11ef-9f42-5e230e3817dd','객체 삭제 멀티','객체 삭제 멀티','/storages/objects/{bucketName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1d268c79-3a81-11ef-9f42-5e230e3817dd','버킷 삭제','버킷 삭제','/storages/buckets/{bucketName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1d26c94a-3a81-11ef-9f42-5e230e3817dd','nic 분리','nic 분리','/compute/nics/detach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','network interface','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('1d270ae4-3a81-11ef-9f42-5e230e3817dd','nic 부착','nic 부착','/compute/nics/attach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','network interface','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('1d27525b-3a81-11ef-9f42-5e230e3817dd','객체 Or 폴더 업로드','객체 Or 폴더 업로드','/storages/upload','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('1d278d66-3a81-11ef-9f42-5e230e3817dd','버킷 생성','버킷 생성','/storages/buckets','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('1d27c54d-3a81-11ef-9f42-5e230e3817dd','Instance Mapping Device 조회','Instance Mapping Device 조회','/volumes/instance-mapping-device','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volumes','volume','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('1d27f76c-3a81-11ef-9f42-5e230e3817dd','Volume 목록 checker','Volume 목록 checker','/volumes/duplicate-checker','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volumes','volume','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('1d28295d-3a81-11ef-9f42-5e230e3817dd','Device Meta data 조회','Device Meta data 조회','/volumes/device-meta','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volumes','volume','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('1d285de1-3a81-11ef-9f42-5e230e3817dd','버킷 목록 조회','버킷 목록 조회','/storages','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('1d288d38-3a81-11ef-9f42-5e230e3817dd','user : GET/storages/objects/info/buckets/{bucketName}/**','user : GET/storages/objects/info/buckets/{bucketName}/**','/storages/objects/info/buckets/{bucketName}/**','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('1d28c175-3a81-11ef-9f42-5e230e3817dd','user : GET/storages/objects/buckets/{bucketName}','user : GET/storages/objects/buckets/{bucketName}','/storages/objects/buckets/{bucketName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('1d28f49b-3a81-11ef-9f42-5e230e3817dd','user : GET/storages/objects-versions/buckets/{bucketName}','user : GET/storages/objects-versions/buckets/{bucketName}','/storages/objects-versions/buckets/{bucketName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('1d292efb-3a81-11ef-9f42-5e230e3817dd','user : GET/storages/info','user : GET/storages/info','/storages/info','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('1d295c90-3a81-11ef-9f42-5e230e3817dd','user : GET/storages/info/buckets/{bucketName}','user : GET/storages/info/buckets/{bucketName}','/storages/info/buckets/{bucketName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('1d298a19-3a81-11ef-9f42-5e230e3817dd','객체 다운로드','객체 다운로드','/storages/download','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('1d29b714-3a81-11ef-9f42-5e230e3817dd','버킷이름 중복체크','버킷이름 중복체크','/storages/buckets/duplicate-check/{bucketName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('1d29eb10-3a81-11ef-9f42-5e230e3817dd','user : GET/compute/nics/duplicate-checker','user : GET/compute/nics/duplicate-checker','/compute/nics/duplicate-checker','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','network interface','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('1d2a4a48-3a81-11ef-9f42-5e230e3817dd','객체 삭제 멀티','객체 삭제 멀티','/storages/objects/{bucketName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('1d2a7912-3a81-11ef-9f42-5e230e3817dd','버킷 삭제','버킷 삭제','/storages/buckets/{bucketName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('1d5d39de-4fd4-11ef-8f18-c6494ca007d9','볼륨 그룹 단일 삭제 API','볼륨 그룹 단일 삭제 API','/block-storage/volume-groups/{volumeGroupId}/delete-volume/{deleteVolume}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('1d5d8843-4fd4-11ef-8f18-c6494ca007d9','볼륨 그룹 단일 삭제 API','볼륨 그룹 단일 삭제 API','/block-storage/volume-groups/{volumeGroupId}/delete-volume/{deleteVolume}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('1decda86-98aa-11ee-971f-72441c073636','서비스-오브젝트 조회 API','서비스-오브젝트 조회 API','/service-objects/frequently-used','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('1defd072-98aa-11ee-971f-72441c073636','메뉴 권한 설정','메뉴 권한 설정','/menu/{menuId}/authority','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','menu','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('1e0bd731-fbc7-11ee-b354-0eff8aa9f4e3','볼륨 스냅샷 상태 업데이트','볼륨 스냅샷 상태 업데이트','/block-storage/volumes/snapshots/{volumeSnapshotId}/status-update','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('1e28af52-4ef7-11ef-8f18-c6494ca007d9','볼륨 그룹에 추가할 수 있는 볼륨 목록을 조회','볼륨 그룹에 추가할 수 있는 볼륨 목록을 조회','/block-storage/volumes/volume-type-name','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('1e291944-4ef7-11ef-8f18-c6494ca007d9','하이퍼 바이저 호스트 통합 조회 API','하이퍼 바이저 호스트 통합 조회 API','/compute/hypervisors/host','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','hypervisor','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('1e295cad-4ef7-11ef-8f18-c6494ca007d9','볼륨 그룹에 추가할 수 있는 볼륨 목록을 조회','볼륨 그룹에 추가할 수 있는 볼륨 목록을 조회','/block-storage/volumes/volume-type-name','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('1e2995a6-4ef7-11ef-8f18-c6494ca007d9','하이퍼 바이저 호스트 통합 조회 API','하이퍼 바이저 호스트 통합 조회 API','/compute/hypervisors/host','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','hypervisor','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('1e795b73-c4b8-11ee-8281-7e177595258d','알림 생성 API','알림 생성 API','/create','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','notification','POST',1,'dc347010-c3f4-11ee-8281-7e177595258d',0)
    ,   ('1e7a3e2e-c4b8-11ee-8281-7e177595258d','알림 목록 조회','알림 목록 조회','/list','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','notification','GET',1,'dc347010-c3f4-11ee-8281-7e177595258d',0)
    ,   ('1e7b1e03-c4b8-11ee-8281-7e177595258d','수신자 그룹 목록 조회 API','수신자 그룹 목록 조회 API','/group/all','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','notification','GET',1,'dc347010-c3f4-11ee-8281-7e177595258d',0)
    ,   ('1eb2b47d-fe4a-11ef-b654-1a18cace67cc','콘트라베이스 공급자 전체 목록 조회 API','콘트라베이스 공급자 전체 목록 조회 API','/infra/provider','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cb_provider','findallproviders','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('1eb39311-fe4a-11ef-b654-1a18cace67cc','콘트라베이스 공급자 수정','콘트라베이스 공급자 수정','/infra/provider','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cb_provider','modifyprovider','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('1eb3d5d3-fe4a-11ef-b654-1a18cace67cc','콘트라베이스 공급자 저장','콘트라베이스 공급자 저장','/infra/provider','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cb_provider','createprovider','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('1eb415d6-fe4a-11ef-b654-1a18cace67cc','SSL Offloading을 위한 바비칸 시크릿 생성 API','SSL Offloading을 위한 바비칸 시크릿 생성 API','/key-manager/secret/file','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','barbican','secret','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('1eb4a5c5-fe4a-11ef-b654-1a18cace67cc','인프라 연결 여부 확인','인프라 연결 여부 확인','/infra/provider/check','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cb_provider','checkconnectioninfra','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('1eb4ce37-fe4a-11ef-b654-1a18cace67cc','콘트라베이스 공급자 단건 조회 API','콘트라베이스 공급자 단건 조회 API','/infra/provider/{uuid}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cb_provider','findbyuuidandprovidertype','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('1eb4f88f-fe4a-11ef-b654-1a18cace67cc','콘트라베이스 공급자 삭제','콘트라베이스 공급자 삭제','/infra/provider/{uuid}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cb_provider','removeprovider','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('1eb576f3-fe4a-11ef-b654-1a18cace67cc','콘트라베이스 공급자별 프로젝트 목록 조회 API','콘트라베이스 공급자별 프로젝트 목록 조회 API','/infra/provider/project','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cb_provider','findproviderwithprojectlist','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('1eb784ec-fe4a-11ef-b654-1a18cace67cc','콘트라베이스 공급자 이름 중복체크 API','콘트라베이스 공급자 이름 중복체크 API','/infra/provider/check-name','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cb_provider','providernamecheckproc','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('1ebad279-fe4a-11ef-b654-1a18cace67cc','콘트라베이스 공급자 전체 목록 조회 API','콘트라베이스 공급자 전체 목록 조회 API','/infra/provider','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cb_provider','findallproviders','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('1ebb99e3-fe4a-11ef-b654-1a18cace67cc','콘트라베이스 공급자 수정','콘트라베이스 공급자 수정','/infra/provider','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cb_provider','modifyprovider','PUT',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('1ebc1344-fe4a-11ef-b654-1a18cace67cc','콘트라베이스 공급자 저장','콘트라베이스 공급자 저장','/infra/provider','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cb_provider','createprovider','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('1ebc77f8-fe4a-11ef-b654-1a18cace67cc','SSL Offloading을 위한 바비칸 시크릿 생성 API','SSL Offloading을 위한 바비칸 시크릿 생성 API','/key-manager/secret/file','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','barbican','secret','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('1ebccd20-fe4a-11ef-b654-1a18cace67cc','인프라 연결 여부 확인','인프라 연결 여부 확인','/infra/provider/check','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cb_provider','checkconnectioninfra','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('1ebd0888-fe4a-11ef-b654-1a18cace67cc','콘트라베이스 공급자 단건 조회 API','콘트라베이스 공급자 단건 조회 API','/infra/provider/{uuid}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cb_provider','findbyuuidandprovidertype','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('1ebd3d73-fe4a-11ef-b654-1a18cace67cc','콘트라베이스 공급자 삭제','콘트라베이스 공급자 삭제','/infra/provider/{uuid}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cb_provider','removeprovider','DELETE',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('1ebdaa52-fe4a-11ef-b654-1a18cace67cc','콘트라베이스 공급자별 프로젝트 목록 조회 API','콘트라베이스 공급자별 프로젝트 목록 조회 API','/infra/provider/project','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cb_provider','findproviderwithprojectlist','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('1ebdf304-fe4a-11ef-b654-1a18cace67cc','콘트라베이스 공급자 이름 중복체크 API','콘트라베이스 공급자 이름 중복체크 API','/infra/provider/check-name','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cb_provider','providernamecheckproc','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('1efe309a-495b-11ef-a4c4-96fd9ef2bacb','폴더 생성','폴더 생성','/storages/folders','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1efeb2f4-495b-11ef-a4c4-96fd9ef2bacb','폴더 중복체크','폴더 중복체크','/storages/folder/duplicate-check','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1efef8a4-495b-11ef-a4c4-96fd9ef2bacb','폴더 생성','폴더 생성','/storages/folders','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('1eff3736-495b-11ef-a4c4-96fd9ef2bacb','폴더 중복체크','폴더 중복체크','/storages/folder/duplicate-check','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('1f1cd225-339c-11ef-9f42-5e230e3817dd','nic 분리','nic 분리','/compute/nics/detach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','network interface','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1f1e2b11-339c-11ef-9f42-5e230e3817dd','nic 부착','nic 부착','/compute/nics/attach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','network interface','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('1f61d092-68df-11ef-aa9f-f2cdef6842ce','Access Control CIDR 단건 조회','Access Control CIDR 단건 조회','/acl/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','access control','access control','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('1f63121f-68df-11ef-aa9f-f2cdef6842ce','Access Control CIDR 수정','Access Control CIDR 수정','/acl/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','access control','access control','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('1f63916a-68df-11ef-aa9f-f2cdef6842ce','Access Control CIDR 삭제','Access Control CIDR 삭제','/acl/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','access control','access control','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('1f63f026-68df-11ef-aa9f-f2cdef6842ce','최초 IAM-ADMIN 계정 생성','최초 IAM-ADMIN 계정 생성','/ktc/interface/root','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','ktc','iam-api','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('1f643c52-68df-11ef-aa9f-f2cdef6842ce','Access Control CIDR 목록 조회','Access Control CIDR 목록 조회','/acl','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','access control','access control','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('1f648162-68df-11ef-aa9f-f2cdef6842ce','Access Control CIDR 등록','Access Control CIDR 등록','/acl','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','access control','access control','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('201e6e5f-b34f-11ee-afaf-76fb71c4f9db','cicd 프로젝트에 연결된 워크스페이스 목록 검색','cicd 프로젝트에 연결된 워크스페이스 목록 검색','/infra/ci-cd/workspace','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','infra','provider','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2052bddb-9db3-11ef-8cfe-22e1909bc60f','클러스터 그룹 태그 수정','클러스터 그룹 태그 수정','/v1/k8s/management/clusters/tag/{clusterId}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('20533304-9db3-11ef-8cfe-22e1909bc60f','멀티 클러스터 테넌트 리스트 조회','멀티 클러스터 테넌트 리스트 조회','/v1/k8s/management/clusters/tenant/{userId}/{globalMenuId}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('20537ded-9db3-11ef-8cfe-22e1909bc60f','클러스터 그룹 태그 수정','클러스터 그룹 태그 수정','/v1/k8s/management/clusters/tag/{clusterId}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('2053b48d-9db3-11ef-8cfe-22e1909bc60f','멀티 클러스터 테넌트 리스트 조회','멀티 클러스터 테넌트 리스트 조회','/v1/k8s/management/clusters/tenant/{userId}/{globalMenuId}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('212678d9-f574-11ee-ac8e-c6591bb2a6db','유동 아이피 풀 목록 API','유동 아이피 풀 목록 조회 ','/network/floating-ip-pools','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','floatingip','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('218f43e7-b463-11ee-afaf-76fb71c4f9db','카테고리 수정',NULL,'/boards/categorys/{categoryId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','category','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('218fde0d-b463-11ee-afaf-76fb71c4f9db','카테고리 삭제',NULL,'/boards/categorys/{categoryId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','category','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2190c9cc-b463-11ee-afaf-76fb71c4f9db','서브 카테고리 수정',NULL,'/boards/categorys/sub/{subCategoryId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','sub category','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('21910efe-b463-11ee-afaf-76fb71c4f9db','서브 카테고리 삭제',NULL,'/boards/categorys/sub/{subCategoryId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','sub category','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('21a1862f-8487-11ef-9a6b-ba8787afde77','KTC 최신 콘텐츠 목록 조회','KTC 최신 콘텐츠 목록 조회','/ktc/interface/updated','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','ktc','home-api','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('2299e0af-b86a-11ef-9c74-0a11b82fa8dd','Get HostedZone','Get HostedZone','/route53s/hosted-zone/{hostedZoneId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('22bc9650-3832-11ef-9f42-5e230e3817dd','PointSolution List','PointSolution List','/point/solution/apm/transaction-elapse/{period}','910fa43a-7797-11ee-b465-565158862942','Vista','observability','pointsolution','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('22bdaa18-45a2-11ef-a4c4-96fd9ef2bacb','객체 삭제','객체 삭제','/storages/object/{bucketName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('22be45fb-45a2-11ef-a4c4-96fd9ef2bacb','객체 삭제','객체 삭제','/storages/object/{bucketName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('237675e8-9103-11ef-a845-1a3f5588de48','인스턴스 콘솔 로그 API','인스턴스 콘솔 로그 API','/compute/servers/{serverId}/console-log','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('23771f96-9103-11ef-a845-1a3f5588de48','공유 제한 상태 가져오기','공유 제한 상태 가져오기','/manila/shares/limits','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('23777094-9103-11ef-a845-1a3f5588de48','인스턴스 액션 로그 상세 조회 API','인스턴스 액션 로그 상세 조회 API','/compute/servers/{serverId}/action-log/{requestId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2377bc25-9103-11ef-a845-1a3f5588de48','인스턴스 콘솔 로그 API','인스턴스 콘솔 로그 API','/compute/servers/{serverId}/console-log','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('237809c1-9103-11ef-a845-1a3f5588de48','공유 제한 상태 가져오기','공유 제한 상태 가져오기','/manila/shares/limits','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('237853c4-9103-11ef-a845-1a3f5588de48','인스턴스 액션 로그 상세 조회 API','인스턴스 액션 로그 상세 조회 API','/compute/servers/{serverId}/action-log/{requestId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('242e3065-1439-11f0-8e4c-52e9553a2057','svd-서비스-카탈로그의 오브젝트 삭제','svd-서비스-카탈로그의 오브젝트 삭제','/service-desk-catalogs/service-desk-objects','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-desk-catalog','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('24586f14-b6c8-11ef-9c74-0a11b82fa8dd','K8S 클러스터 및 하위 네임스페이스, 파드 정보 조회','K8S 클러스터 및 하위 네임스페이스, 파드 정보 조회','/v2/resources/pod-view','910fa43a-7797-11ee-b465-565158862942','Vista','observability','resource','POST',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('245926d6-b6c8-11ef-9c74-0a11b82fa8dd','Duplicate Incident Rule check','Duplicate Incident Rule check','/v2/incident-rules/check-duplicates','910fa43a-7797-11ee-b465-565158862942','Vista','observability','incident rule','POST',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('2459abc8-b6c8-11ef-9c74-0a11b82fa8dd','Dashboard 목록에서 태그 추가/제거','Dashboard 목록에서 태그 추가/제거','/v2/dashboards/{dashboardId}/tags','910fa43a-7797-11ee-b465-565158862942','Vista','observability','dashboard','POST',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('245a61c2-b6c8-11ef-9c74-0a11b82fa8dd','특정 대시보드 복제','특정 대시보드 복제','/v2/dashboards/{dashboardId}/copy','910fa43a-7797-11ee-b465-565158862942','Vista','observability','dashboard','POST',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('245aa074-b6c8-11ef-9c74-0a11b82fa8dd','Resource Group Resources','Resource Group Resources','/v2/resources/resource-groups/{resourceTypeGroupId}/options','910fa43a-7797-11ee-b465-565158862942','Vista','observability','resource','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('245b38ed-b6c8-11ef-9c74-0a11b82fa8dd','K8S 클러스터 및 하위 네임스페이스, 파드 정보 조회','K8S 클러스터 및 하위 네임스페이스, 파드 정보 조회','/v2/resources/namespaces/options','910fa43a-7797-11ee-b465-565158862942','Vista','observability','resource','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('245b6b73-b6c8-11ef-9c74-0a11b82fa8dd','Not Include In Resource Group Resources','Not Include In Resource Group Resources','/v2/resources/all/{resourceTypeGroupId}/options','910fa43a-7797-11ee-b465-565158862942','Vista','observability','resource','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('245b8dcc-b6c8-11ef-9c74-0a11b82fa8dd','ResourceType list','ResourceType list','/v2/resource-types','910fa43a-7797-11ee-b465-565158862942','Vista','observability','resourcetype','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('245bac00-b6c8-11ef-9c74-0a11b82fa8dd','Resources By ResourceType','Resources By ResourceType','/v2/resource-types/{resourceTypeId}/resources','910fa43a-7797-11ee-b465-565158862942','Vista','observability','resource','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('245bc8dd-b6c8-11ef-9c74-0a11b82fa8dd','ResourceTypeMetrics list By Id','ResourceTypeMetrics list By Id','/v2/resource-types/{resourceTypeId}/metrics','910fa43a-7797-11ee-b465-565158862942','Vista','observability','metric','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('245c1c2c-b6c8-11ef-9c74-0a11b82fa8dd','Log Table','Log Table','/v2/logs/table','910fa43a-7797-11ee-b465-565158862942','Vista','observability','log','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('245c6070-b6c8-11ef-9c74-0a11b82fa8dd','Log Chart','Log Chart','/v2/logs/chart','910fa43a-7797-11ee-b465-565158862942','Vista','observability','log','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('245cc06c-b6c8-11ef-9c74-0a11b82fa8dd','대시보드의 위젯 목록 조회','대시보드의 위젯 목록 조회','/v2/dashboards/{dashboardId}/widgets','910fa43a-7797-11ee-b465-565158862942','Vista','observability','dashboard','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('25ad47a6-9805-11ef-acba-fe8777174134','임계치 설정 상세 조회','임계치 설정 상세 조회','/v1/k8s/namespaces/{namespace}/criticalpoints/{criticalPointName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','infra','critical point','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('25ae1fbb-9805-11ef-acba-fe8777174134','임계치 설정 수정','임계치 설정 수정','/v1/k8s/namespaces/{namespace}/criticalpoints/{criticalPointName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','infra','critical point','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('25ae6d2f-9805-11ef-acba-fe8777174134','임계치 설정 삭제','임계치 설정 삭제','/v1/k8s/namespaces/{namespace}/criticalpoints/{criticalPointName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','infra','critical point','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('25ae98e6-9805-11ef-acba-fe8777174134','VPA 상세 조회','VPA 상세 조회','/v1/k8s/namespaces/{namespaceName}/verticalpodautoscalers/{verticalPodAutoScalerName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','vertical pod autoscaling','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('25aeea9e-9805-11ef-acba-fe8777174134','VPA 수정','VPA 수정','/v1/k8s/namespaces/{namespaceName}/verticalpodautoscalers/{verticalPodAutoScalerName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','vertical pod autoscaling','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('25af17c0-9805-11ef-acba-fe8777174134','VPA 삭제','VPA 삭제','/v1/k8s/namespaces/{namespaceName}/verticalpodautoscalers/{verticalPodAutoScalerName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','vertical pod autoscaling','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('25af464c-9805-11ef-acba-fe8777174134','HPA 상세 조회','HPA 상세 조회','/v1/k8s/autoscaler/namespaces/{namespaceName}/horizontalpodautoscalers/{horizontalPodAutoScalerName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','horizontal pod autoscaling','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('25af8ab6-9805-11ef-acba-fe8777174134','HPA 수정','HPA 수정','/v1/k8s/autoscaler/namespaces/{namespaceName}/horizontalpodautoscalers/{horizontalPodAutoScalerName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','horizontal pod autoscaling','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('25afc1a5-9805-11ef-acba-fe8777174134','HPA 삭제','HPA 삭제','/v1/k8s/autoscaler/namespaces/{namespaceName}/horizontalpodautoscalers/{horizontalPodAutoScalerName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','horizontal pod autoscaling','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('25afee9e-9805-11ef-acba-fe8777174134','네임스페이스 별 임계치 설정 리스트 조회','네임스페이스 별 임계치 설정 리스트 조회','/v1/k8s/namespaces/{namespace}/criticalpoints','345ae518-f857-11ed-921d-aa1950d374e1','Viola','infra','critical point','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('25b014f0-9805-11ef-acba-fe8777174134','임계치 설정 생성','임계치 설정 생성','/v1/k8s/namespaces/{namespace}/criticalpoints','345ae518-f857-11ed-921d-aa1950d374e1','Viola','infra','critical point','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('25b03de2-9805-11ef-acba-fe8777174134','네임스페이스별 VPA 리스트 조회','네임스페이스별 VPA 리스트 조회','/v1/k8s/namespaces/{namespaceName}/verticalpodautoscalers','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','vertical pod autoscaling','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('25b06779-9805-11ef-acba-fe8777174134','VPA 생성','VPA 생성','/v1/k8s/namespaces/{namespaceName}/verticalpodautoscalers','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','vertical pod autoscaling','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('25b08ae8-9805-11ef-acba-fe8777174134','네임스페이스 istio 설정','네임스페이스 istio 설정','/v1/k8s/namespaces/{namespaceName}/istio-injected','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','namespace','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('25b0ca8b-9805-11ef-acba-fe8777174134','네임스페이스 istio 설정','네임스페이스 istio 설정','/v1/k8s/namespaces/{namespaceName}/istio-injected','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','namespace','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('25b0f64c-9805-11ef-acba-fe8777174134','쿠버네티스 yaml 유효성 검사','쿠버네티스 yaml 유효성 검사','/v1/k8s/dry-run','345ae518-f857-11ed-921d-aa1950d374e1','Viola','kubernetes','dry-run','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('25b1597e-9805-11ef-acba-fe8777174134','네임스페이스별 HPA 리스트 조회','네임스페이스별 HPA 리스트 조회','/v1/k8s/autoscaler/namespaces/{namespaceName}/horizontalpodautoscalers','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','horizontal pod autoscaling','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('25b1a2fd-9805-11ef-acba-fe8777174134','HPA 생성','HPA 생성','/v1/k8s/autoscaler/namespaces/{namespaceName}/horizontalpodautoscalers','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','horizontal pod autoscaling','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('25b1e070-9805-11ef-acba-fe8777174134','임계치 설정 알림 전송','임계치 설정 알림 전송','/v1/criticalpoint/alert/send','345ae518-f857-11ed-921d-aa1950d374e1','Viola','infra','critical point','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('25b22a2c-9805-11ef-acba-fe8777174134','전체 VPA 리스트 조회','전체 VPA 리스트 조회','/v1/k8s/verticalpodautoscalers','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','vertical pod autoscaling','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('25b32ffb-9805-11ef-acba-fe8777174134','마에스트로 인프라 디렉토리','마에스트로 인프라 디렉토리','/v1/k8s/management/clusters/infra-directory','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('25b37d41-9805-11ef-acba-fe8777174134','임계치 설정 전체 리스트 조회','임계치 설정 전체 리스트 조회','/v1/k8s/criticalpoints','345ae518-f857-11ed-921d-aa1950d374e1','Viola','infra','critical point','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('25b3a6cd-9805-11ef-acba-fe8777174134','전체 HPA 리스트 조회','전체 HPA 리스트 조회','/v1/k8s/autoscaler/horizontalpodautoscalers','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','horizontal pod autoscaling','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('25b3c835-9805-11ef-acba-fe8777174134','임계치 설정 상세 조회','임계치 설정 상세 조회','/v1/k8s/namespaces/{namespace}/criticalpoints/{criticalPointName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','infra','critical point','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('25b3f2a2-9805-11ef-acba-fe8777174134','임계치 설정 수정','임계치 설정 수정','/v1/k8s/namespaces/{namespace}/criticalpoints/{criticalPointName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','infra','critical point','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('25b41420-9805-11ef-acba-fe8777174134','임계치 설정 삭제','임계치 설정 삭제','/v1/k8s/namespaces/{namespace}/criticalpoints/{criticalPointName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','infra','critical point','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('25b4344d-9805-11ef-acba-fe8777174134','VPA 상세 조회','VPA 상세 조회','/v1/k8s/namespaces/{namespaceName}/verticalpodautoscalers/{verticalPodAutoScalerName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','vertical pod autoscaling','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('25b455ec-9805-11ef-acba-fe8777174134','VPA 수정','VPA 수정','/v1/k8s/namespaces/{namespaceName}/verticalpodautoscalers/{verticalPodAutoScalerName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','vertical pod autoscaling','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('25b47c98-9805-11ef-acba-fe8777174134','VPA 삭제','VPA 삭제','/v1/k8s/namespaces/{namespaceName}/verticalpodautoscalers/{verticalPodAutoScalerName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','vertical pod autoscaling','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('25b4bf53-9805-11ef-acba-fe8777174134','HPA 상세 조회','HPA 상세 조회','/v1/k8s/autoscaler/namespaces/{namespaceName}/horizontalpodautoscalers/{horizontalPodAutoScalerName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','horizontal pod autoscaling','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('25b4e5fe-9805-11ef-acba-fe8777174134','HPA 수정','HPA 수정','/v1/k8s/autoscaler/namespaces/{namespaceName}/horizontalpodautoscalers/{horizontalPodAutoScalerName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','horizontal pod autoscaling','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('25b50d87-9805-11ef-acba-fe8777174134','HPA 삭제','HPA 삭제','/v1/k8s/autoscaler/namespaces/{namespaceName}/horizontalpodautoscalers/{horizontalPodAutoScalerName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','horizontal pod autoscaling','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('25b533ee-9805-11ef-acba-fe8777174134','네임스페이스 별 임계치 설정 리스트 조회','네임스페이스 별 임계치 설정 리스트 조회','/v1/k8s/namespaces/{namespace}/criticalpoints','345ae518-f857-11ed-921d-aa1950d374e1','Viola','infra','critical point','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('25b55e69-9805-11ef-acba-fe8777174134','임계치 설정 생성','임계치 설정 생성','/v1/k8s/namespaces/{namespace}/criticalpoints','345ae518-f857-11ed-921d-aa1950d374e1','Viola','infra','critical point','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('25b587b9-9805-11ef-acba-fe8777174134','네임스페이스별 VPA 리스트 조회','네임스페이스별 VPA 리스트 조회','/v1/k8s/namespaces/{namespaceName}/verticalpodautoscalers','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','vertical pod autoscaling','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('25b5bbeb-9805-11ef-acba-fe8777174134','VPA 생성','VPA 생성','/v1/k8s/namespaces/{namespaceName}/verticalpodautoscalers','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','vertical pod autoscaling','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('25b5e563-9805-11ef-acba-fe8777174134','네임스페이스 istio 설정','네임스페이스 istio 설정','/v1/k8s/namespaces/{namespaceName}/istio-injected','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','namespace','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('25b60b4a-9805-11ef-acba-fe8777174134','네임스페이스 istio 설정','네임스페이스 istio 설정','/v1/k8s/namespaces/{namespaceName}/istio-injected','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','namespace','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('25b6360e-9805-11ef-acba-fe8777174134','쿠버네티스 yaml 유효성 검사','쿠버네티스 yaml 유효성 검사','/v1/k8s/dry-run','345ae518-f857-11ed-921d-aa1950d374e1','Viola','kubernetes','dry-run','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('25b656ad-9805-11ef-acba-fe8777174134','네임스페이스별 HPA 리스트 조회','네임스페이스별 HPA 리스트 조회','/v1/k8s/autoscaler/namespaces/{namespaceName}/horizontalpodautoscalers','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','horizontal pod autoscaling','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('25b67d41-9805-11ef-acba-fe8777174134','HPA 생성','HPA 생성','/v1/k8s/autoscaler/namespaces/{namespaceName}/horizontalpodautoscalers','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','horizontal pod autoscaling','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('25b69cc4-9805-11ef-acba-fe8777174134','임계치 설정 알림 전송','임계치 설정 알림 전송','/v1/criticalpoint/alert/send','345ae518-f857-11ed-921d-aa1950d374e1','Viola','infra','critical point','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('25b6b983-9805-11ef-acba-fe8777174134','전체 VPA 리스트 조회','전체 VPA 리스트 조회','/v1/k8s/verticalpodautoscalers','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','vertical pod autoscaling','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('25b76183-9805-11ef-acba-fe8777174134','마에스트로 인프라 디렉토리','마에스트로 인프라 디렉토리','/v1/k8s/management/clusters/infra-directory','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('25b7b241-9805-11ef-acba-fe8777174134','임계치 설정 전체 리스트 조회','임계치 설정 전체 리스트 조회','/v1/k8s/criticalpoints','345ae518-f857-11ed-921d-aa1950d374e1','Viola','infra','critical point','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('25b7d518-9805-11ef-acba-fe8777174134','전체 HPA 리스트 조회','전체 HPA 리스트 조회','/v1/k8s/autoscaler/horizontalpodautoscalers','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','horizontal pod autoscaling','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('266ed9d2-144c-11f0-8e4c-52e9553a2057','알림 이벤트 기반 발송 목록 조회  API','알림 이벤트 기반 발송 목록 조회  API','/data/event2','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','notification','GET',1,'dc347010-c3f4-11ee-8281-7e177595258d',0)
    ,   ('266fbdb4-144c-11f0-8e4c-52e9553a2057','알림 이벤트 기반 발송 목록에 대한 Filter 정보 조회  API','알림 이벤트 기반 발송 목록에 대한 Filter 정보 조회  API','/data/event/filter','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','notification','GET',1,'dc347010-c3f4-11ee-8281-7e177595258d',0)
    ,   ('27365de4-47fb-11ef-a4c4-96fd9ef2bacb','test-notification','test-notification','/test/notification','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','dashboard','hypervisor','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2736dd8c-47fb-11ef-a4c4-96fd9ef2bacb','test-notification','test-notification','/dashboard/notification','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','dashboard','hypervisor','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('27374705-47fb-11ef-a4c4-96fd9ef2bacb','test-notification','test-notification','/test/notification','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','dashboard','hypervisor','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('273799c2-47fb-11ef-a4c4-96fd9ef2bacb','test-notification','test-notification','/dashboard/notification','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','dashboard','hypervisor','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('27c83de7-10cd-11ef-9fbf-8ef2ee3c3984','사용자 중복조회','사용자 중복조회','/iam/users/validate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','user','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('27cbf52e-10cd-11ef-9fbf-8ef2ee3c3984','admin : GET/compute/servers','admin : GET/compute/servers','/compute/servers','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('27cc3762-10cd-11ef-9fbf-8ef2ee3c3984','os 에따른 버전 조회','os 에따른 버전 조회','/compute/servers/versions/{os}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',1)
    ,   ('27cc7255-10cd-11ef-9fbf-8ef2ee3c3984','','','/compute/servers/security-groups','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',1)
    ,   ('27cca9a7-10cd-11ef-9fbf-8ef2ee3c3984','','','/compute/servers/monitoring/{instanceId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',1)
    ,   ('27ccdc47-10cd-11ef-9fbf-8ef2ee3c3984','admin : GET/compute/servers/logs/{instanceId}','admin : GET/compute/servers/logs/{instanceId}','/compute/servers/logs/{instanceId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('27cd0def-10cd-11ef-9fbf-8ef2ee3c3984','','','/compute/servers/keys','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',1)
    ,   ('27cd3cde-10cd-11ef-9fbf-8ef2ee3c3984','keypair 리스트 조회','keypair 리스트 조회','/compute/servers/keypairs','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('27cd6b7c-10cd-11ef-9fbf-8ef2ee3c3984','admin : GET/compute/servers/instance-types','admin : GET/compute/servers/instance-types','/compute/servers/instance-types','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('27cd98f8-10cd-11ef-9fbf-8ef2ee3c3984','인스턴스 타입 디테일 조회','인스턴스 타입 디테일 조회','/compute/servers/instance-types/instances/{instanceType}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',1)
    ,   ('27cdcae8-10cd-11ef-9fbf-8ef2ee3c3984','추가된부분','추가된부분','/compute/servers/instance-types/amis/{ami}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',1)
    ,   ('27cdf650-10cd-11ef-9fbf-8ef2ee3c3984','admin : GET/compute/servers/by-instance/{instanceId}','admin : GET/compute/servers/by-instance/{instanceId}','/compute/servers/by-instance/{instanceId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('27d31757-10cd-11ef-9fbf-8ef2ee3c3984','quickstart  ami 리스트 조회','quickstart  ami 리스트 조회','/compute/amis','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','ami','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',1)
    ,   ('27d35b67-10cd-11ef-9fbf-8ef2ee3c3984','os 별 생성 qucickstart ami 리스트 조회','os 별 생성 qucickstart ami 리스트 조회','/compute/amis/by-os/{os}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','ami','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('27d39b47-10cd-11ef-9fbf-8ef2ee3c3984','ami 디테일 info 조회','ami 디테일 info 조회','/compute/amis/by-ami/{ami}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','ami','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('27f21020-3abc-11f0-80c3-6e593baabd40','NetApp Storage 클러스터 조회','NetApp Storage 클러스터 조회','/v2/storages/clusters/{clusterUuid}','910fa43a-7797-11ee-b465-565158862942','Vista','observability','storage','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('27f330dc-3abc-11f0-80c3-6e593baabd40','NetApp Storage 클러스터 목록 조회','NetApp Storage 클러스터 목록 조회','/v2/storages-api/clusters','910fa43a-7797-11ee-b465-565158862942','Vista','observability','storage','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('27f3587d-3abc-11f0-80c3-6e593baabd40','NetApp Storage 클러스터 조회','NetApp Storage 클러스터 조회','/v2/storages-api/clusters/{clusterUuid}','910fa43a-7797-11ee-b465-565158862942','Vista','observability','storage','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('27ff3866-605f-11ef-9a30-f2cdef6842ce','사용자 상태 변경','사용자 상태 변경','/user/{userId}/status','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','management','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('29b774de-d718-11ef-9c74-0a11b82fa8dd','서비스 타입 결재자 조회 API','서비스 타입 결재자 조회 API','/service-request-approver/service-type','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('29b82943-d718-11ef-9c74-0a11b82fa8dd','서비스 오브젝트 결재자 조회 API','서비스 오브젝트 결재자 조회 API','/service-request-approver/service-object','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('29efb960-52fe-11ef-8f18-c6494ca007d9','해당 볼륨 그룹과 연관 있는 볼륨 목록 조회','해당 볼륨 그룹과 연관 있는 볼륨 목록 조회','/block-storage/volumes/volume-group/{volumeGroupId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('2ace8724-ccdc-11ef-9c74-0a11b82fa8dd','커뮤니티 게시글 첨부파일 다운로드','커뮤니티 게시글 첨부파일 다운로드','/boards/{id}/download/{fileId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','board','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('2acf711d-ccdc-11ef-9c74-0a11b82fa8dd','일대일 문의 첨부파일 다운로드','일대일 문의 첨부파일 다운로드','/boards/requests/{id}/download/{fileId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','request board','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('2ad0032c-ccdc-11ef-9c74-0a11b82fa8dd','커뮤니티 게시글 첨부파일 다운로드','커뮤니티 게시글 첨부파일 다운로드','/boards/{id}/download/{fileId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','board','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2ad05e68-ccdc-11ef-9c74-0a11b82fa8dd','일대일 문의 첨부파일 다운로드','일대일 문의 첨부파일 다운로드','/boards/requests/{id}/download/{fileId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','request board','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2b468b12-1c13-11f0-b59d-5aaf6fae780b','Fabric Node topology 정보를 조회','Fabric Node topology 정보를 조회','/fabrics/NodeTopology','d5add9d1-1439-11f0-8e4c-52e9553a2057','Cisco','management','fabric','GET',1,'50a61e5c-1449-11f0-8e4c-52e9553a2057',0)
    ,   ('2b47e9e0-1c13-11f0-b59d-5aaf6fae780b','Fabric Node Single Linked topology 정보를 조회','Fabric Node Single Linked topology 정보를 조회','/fabrics/NodeTopologySingleLinkedList','d5add9d1-1439-11f0-8e4c-52e9553a2057','Cisco','management','fabric','GET',1,'50a61e5c-1449-11f0-8e4c-52e9553a2057',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('2c242ed6-43dd-11ef-a4c4-96fd9ef2bacb','알림 이벤트 기반 발송 목록 조회  API','알림 이벤트 기반 발송 목록 조회  API','/data/event','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','notification','GET',1,'dc347010-c3f4-11ee-8281-7e177595258d',0)
    ,   ('2c24a99c-43dd-11ef-a4c4-96fd9ef2bacb','서비스 신청','서비스 신청','/interface/service-objects/requests/provisions/by-config-map','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2c91428b-9760-11ef-a1af-ee884fc03848','CMP에서 KTC로 문의 전송 API','CMP에서 KTC로 문의 전송 API','/ktc/interface/todo','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','ktc','board-api','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('2c91dc90-9760-11ef-a1af-ee884fc03848','KTC에서 CMP로 공지사항 등록 API','KTC에서 CMP로 공지사항 등록 API','/ktc/interface/announce','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','ktc','board-api','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('2c9237a8-9760-11ef-a1af-ee884fc03848','CMP 공지사항 등록 API','CMP 공지사항 등록 API','/ktc/interface/announce/cmp','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','ktc','board-api','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('2c926e3c-9760-11ef-a1af-ee884fc03848','일대일 문의 카테고리 목록 조회','일대일 문의 카테고리 목록 조회','/boards/requests/categories','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','request board','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2c92af70-9760-11ef-a1af-ee884fc03848','일대일 문의 카테고리 상세 조회','일대일 문의 카테고리 상세 조회','/boards/requests/categories/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','request board','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2c92d9ba-9760-11ef-a1af-ee884fc03848','특정 코드의 일대일 문의 카테고리 조회','특정 코드의 일대일 문의 카테고리 조회','/boards/requests/categories/by-code','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','request board','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2d0bdaad-d7ca-11ef-9c74-0a11b82fa8dd','서비스 타입 결재자 조회 API','서비스 타입 결재자 조회 API','/service-approver/service-type-approver','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('2d0c645d-d7ca-11ef-9c74-0a11b82fa8dd','서비스 오브젝트 결재자 조회 API','서비스 오브젝트 결재자 조회 API','/service-approver/service-object-approver','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('2d7f58e9-e0f2-11ee-84a7-5e1f35257281','공유 내보내기 위치','공유 내보내기 위치','/manila/shares/{shareId}/export-locations','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2d8ec349-2ef8-11f0-92ed-2e5d1099d8b8','svd-서비스-템플릿 카탈로그 배포 이력 조회','svd-서비스-템플릿 카탈로그 배포 이력 조회','/service-desk-templates/{id}/requests','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-desk-template','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de2747f-0c4e-11ef-9fbf-8ef2ee3c3984','사용자 조직 재할당','사용자의 조직을 재할당한다. 기존 조직은 삭제되고 새로운 조직이 할당된다.','/user/{userId}/reassign-org/{orgId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','management','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de2fa3c-0c4e-11ef-9fbf-8ef2ee3c3984','대시보드 조직 기준 비용 정보 조회','대시보드 조직 기준 비용 정보 조회','/dashboard/org/cost/{orgId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','dashboard','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('2de3499f-0c4e-11ef-9fbf-8ef2ee3c3984','Ncp 가상머신 일시 정지','Ncp 가상머신 일시 정지','/workspaces/servers/ncp/tenants/{tenantId}/instances/{instanceId}/suspend','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de38bf2-0c4e-11ef-9fbf-8ef2ee3c3984','Ncp 가상머신 정지','Ncp 가상머신 정지','/workspaces/servers/ncp/tenants/{tenantId}/instances/{instanceId}/stop','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de3d0b9-0c4e-11ef-9fbf-8ef2ee3c3984','Ncp 가상머신 시작','Ncp 가상머신 시작','/workspaces/servers/ncp/tenants/{tenantId}/instances/{instanceId}/start','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de40fab-0c4e-11ef-9fbf-8ef2ee3c3984','Ncp 가상머신 소프트 리부트','Ncp 가상머신 소프트 리부트','/workspaces/servers/ncp/tenants/{tenantId}/instances/{instanceId}/soft','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de446ce-0c4e-11ef-9fbf-8ef2ee3c3984','Ncp 가상머신 재기동','Ncp 가상머신 재기동','/workspaces/servers/ncp/tenants/{tenantId}/instances/{instanceId}/reset','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de47e24-0c4e-11ef-9fbf-8ef2ee3c3984','Ncp 가상머신 재시작','Ncp 가상머신 재시작','/workspaces/servers/ncp/tenants/{tenantId}/instances/{instanceId}/reboot','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('2de4ac4a-0c4e-11ef-9fbf-8ef2ee3c3984','Ncp 가상머신 기동','Ncp 가상머신 기동','/workspaces/servers/ncp/tenants/{tenantId}/instances/{instanceId}/on','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de4e187-0c4e-11ef-9fbf-8ef2ee3c3984','Ncp 가상머신 종료','Ncp 가상머신 종료','/workspaces/servers/ncp/tenants/{tenantId}/instances/{instanceId}/off','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de51286-0c4e-11ef-9fbf-8ef2ee3c3984','Ncp 가상머신 하드 리부트','Ncp 가상머신 하드 리부트','/workspaces/servers/ncp/tenants/{tenantId}/instances/{instanceId}/hard','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de571d4-0c4e-11ef-9fbf-8ef2ee3c3984','Ncp 가상머신 강제 종료','Ncp 가상머신 강제 종료','/workspaces/servers/ncp/tenants/{tenantId}/instances/{instanceId}/hard_stop','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de5a403-0c4e-11ef-9fbf-8ef2ee3c3984','Ncp 가상머신 삭제','Ncp 가상머신 삭제','/workspaces/servers/ncp/tenants/{tenantId}/instances/{instanceId}/delete','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de5da63-0c4e-11ef-9fbf-8ef2ee3c3984','Doublebass 가상머신 일시 정지','Doublebass 가상머신 일시 정지','/workspaces/servers/doublebass/tenants/{tenantId}/instances/{instanceId}/suspend','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de61063-0c4e-11ef-9fbf-8ef2ee3c3984','Doublebass 가상머신 정지','Doublebass 가상머신 정지','/workspaces/servers/doublebass/tenants/{tenantId}/instances/{instanceId}/stop','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de63a07-0c4e-11ef-9fbf-8ef2ee3c3984','Doublebass 가상머신 시작','Doublebass 가상머신 시작','/workspaces/servers/doublebass/tenants/{tenantId}/instances/{instanceId}/start','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de666ed-0c4e-11ef-9fbf-8ef2ee3c3984','Doublebass 가상머신 소프트 리부트','Doublebass 가상머신 소프트 리부트','/workspaces/servers/doublebass/tenants/{tenantId}/instances/{instanceId}/soft','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de68e78-0c4e-11ef-9fbf-8ef2ee3c3984','Doublebass 가상머신 재기동','Doublebass 가상머신 재기동','/workspaces/servers/doublebass/tenants/{tenantId}/instances/{instanceId}/reset','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de6c0ee-0c4e-11ef-9fbf-8ef2ee3c3984','Doublebass 가상머신 재시작','Doublebass 가상머신 재시작','/workspaces/servers/doublebass/tenants/{tenantId}/instances/{instanceId}/reboot','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de6eacc-0c4e-11ef-9fbf-8ef2ee3c3984','Doublebass 가상머신 기동','Doublebass 가상머신 기동','/workspaces/servers/doublebass/tenants/{tenantId}/instances/{instanceId}/on','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de736c7-0c4e-11ef-9fbf-8ef2ee3c3984','Doublebass 가상머신 종료','Doublebass 가상머신 종료','/workspaces/servers/doublebass/tenants/{tenantId}/instances/{instanceId}/off','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de768be-0c4e-11ef-9fbf-8ef2ee3c3984','Doublebass 가상머신 하드 리부트','Doublebass 가상머신 하드 리부트','/workspaces/servers/doublebass/tenants/{tenantId}/instances/{instanceId}/hard','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de7b6b5-0c4e-11ef-9fbf-8ef2ee3c3984','Doublebass 가상머신 강제 종료','Doublebass 가상머신 강제 종료','/workspaces/servers/doublebass/tenants/{tenantId}/instances/{instanceId}/hard_stop','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de806e7-0c4e-11ef-9fbf-8ef2ee3c3984','Doublebass 가상머신 삭제','Doublebass 가상머신 삭제','/workspaces/servers/doublebass/tenants/{tenantId}/instances/{instanceId}/delete','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de80d05-012c-11ef-8bb1-cee8dc1678f7','일대일 문의 삭제','일대일 문의 삭제','/boards/requests/{boardId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','request board','DELETE',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('2de8a334-0c4e-11ef-9fbf-8ef2ee3c3984','Contrabass 가상머신 일시 정지','Contrabass 가상머신 일시 정지','/workspaces/servers/contrabass/tenants/{tenantId}/instances/{instanceId}/suspend','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de8ef18-0c4e-11ef-9fbf-8ef2ee3c3984','Contrabass 가상머신 정지','Contrabass 가상머신 정지','/workspaces/servers/contrabass/tenants/{tenantId}/instances/{instanceId}/stop','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2de9a129-0c4e-11ef-9fbf-8ef2ee3c3984','Contrabass 가상머신 시작','Contrabass 가상머신 시작','/workspaces/servers/contrabass/tenants/{tenantId}/instances/{instanceId}/start','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('2de9d0ab-0c4e-11ef-9fbf-8ef2ee3c3984','Contrabass 가상머신 소프트 리부트','Contrabass 가상머신 소프트 리부트','/workspaces/servers/contrabass/tenants/{tenantId}/instances/{instanceId}/soft','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2dea0962-0c4e-11ef-9fbf-8ef2ee3c3984','Contrabass 가상머신 재기동','Contrabass 가상머신 재기동','/workspaces/servers/contrabass/tenants/{tenantId}/instances/{instanceId}/reset','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2dea37e9-0c4e-11ef-9fbf-8ef2ee3c3984','Contrabass 가상머신 재시작','Contrabass 가상머신 재시작','/workspaces/servers/contrabass/tenants/{tenantId}/instances/{instanceId}/reboot','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2dea6c4a-0c4e-11ef-9fbf-8ef2ee3c3984','Contrabass 가상머신 기동','Contrabass 가상머신 기동','/workspaces/servers/contrabass/tenants/{tenantId}/instances/{instanceId}/on','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2dea9b0f-0c4e-11ef-9fbf-8ef2ee3c3984','Contrabass 가상머신 종료','Contrabass 가상머신 종료','/workspaces/servers/contrabass/tenants/{tenantId}/instances/{instanceId}/off','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2deadb14-0c4e-11ef-9fbf-8ef2ee3c3984','Contrabass 가상머신 하드 리부트','Contrabass 가상머신 하드 리부트','/workspaces/servers/contrabass/tenants/{tenantId}/instances/{instanceId}/hard','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2deb1203-0c4e-11ef-9fbf-8ef2ee3c3984','Contrabass 가상머신 강제 종료','Contrabass 가상머신 강제 종료','/workspaces/servers/contrabass/tenants/{tenantId}/instances/{instanceId}/hard_stop','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2deb9c9c-0c4e-11ef-9fbf-8ef2ee3c3984','Contrabass 가상머신 삭제','Contrabass 가상머신 삭제','/workspaces/servers/contrabass/tenants/{tenantId}/instances/{instanceId}/delete','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2deca8db-0c4e-11ef-9fbf-8ef2ee3c3984','서비스-카탈로그 내 조직의 카테고리 목록 조회 API','서비스-카탈로그 내 조직의 카테고리 목록 조회 API','/service-objects/requests/my-types','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('2ec3714d-9b3e-11ef-8cfe-22e1909bc60f','일대일 문의 조회','일대일 문의 조회','/ktc/interface/qna','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','ktc','board-api','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('2ec42677-9b3e-11ef-8cfe-22e1909bc60f','CMP에서 KTC로 일대일 문의 전송 API','CMP에서 KTC로 일대일 문의 전송 API','/ktc/interface/qna','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','ktc','board-api','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('2ec4747d-9b3e-11ef-8cfe-22e1909bc60f','사용자 및 그룹 조회(with email)','사용자 및 그룹 조회(with email)','/user/access-control/filter','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','access-control','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2ec53f4f-9b3e-11ef-8cfe-22e1909bc60f','일대일 문의 단건 조회 API','일대일 문의 단건 조회 API','/ktc/interface/qna/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','ktc','board-api','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('2ec56f6a-9b3e-11ef-8cfe-22e1909bc60f','일대일 문의 카테고리 목록 조회','일대일 문의 카테고리 목록 조회','/boards/requests/categories','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','request board','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('2ec5a94c-9b3e-11ef-8cfe-22e1909bc60f','일대일 문의 카테고리 상세 조회','일대일 문의 카테고리 상세 조회','/boards/requests/categories/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','request board','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('2ec5d730-9b3e-11ef-8cfe-22e1909bc60f','특정 코드의 일대일 문의 카테고리 조회','특정 코드의 일대일 문의 카테고리 조회','/boards/requests/categories/by-code','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','request board','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('2ec68b9c-9b3e-11ef-8cfe-22e1909bc60f','일대일 문의 조회 API','일대일 문의 조회 API','/ktc/interface/qna','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','ktc','board-api','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('2ec6beed-9b3e-11ef-8cfe-22e1909bc60f','CMP에서 KTC로 일대일 문의 전송 API','CMP에서 KTC로 일대일 문의 전송 API','/ktc/interface/qna','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','ktc','board-api','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('2ec7284e-9b3e-11ef-8cfe-22e1909bc60f','테넌트가 연결된 조직 조회','테넌트가 연결된 조직 조회','/org/tenant/{tenantId}/connected-org','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2ec76d1a-9b3e-11ef-8cfe-22e1909bc60f','일대일 문의 단건 조회 API','일대일 문의 단건 조회 API','/ktc/interface/qna/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','ktc','board-api','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('2f287bc4-924d-11ee-92eb-661b04f0c4aa','관리자 포탈의 네비게이션 메뉴 목록 조회#whtie-api','관리자 포탈 LLNB 메뉴 목록 조회. 공개된 솔루션 하위 네비게이션 메뉴만 조회된다.','/menu/portal/navigation','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','menu','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('2f28d131-924d-11ee-92eb-661b04f0c4aa','관리자 포탈의 LNB 메뉴 조회','관리자 포탈 LNB 조회. 비공개인 메뉴나 사용자에게 허용되지 않은 메뉴는 제외한다.','/menu/portal/navigation/{navigationMenuId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','menu','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('2f291163-924d-11ee-92eb-661b04f0c4aa','메뉴 관리에서 관리자/사용자 네비게이션 메뉴 목록 조회#whtie-api','LLNB 메뉴 목록 조회. 비공개된 솔루션까지 조회한다.','/menu/navigation','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','menu','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('2f294c00-924d-11ee-92eb-661b04f0c4aa','메뉴 관리에서 메뉴 목록 조회#whtie-api','LNB 메뉴 목록 조회 특정 네비게이션 메뉴 하나에 대한 LNB 목록 조회','/menu/navigation/{navigationMenuId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','menu','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('2f29822b-924d-11ee-92eb-661b04f0c4aa','마이페이지 계정 접속 로그 조회','마이페이지 계정 접속 로그 조회','/log-mypage/access','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','dashboard','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('2f53ab60-c3f4-11ee-8281-7e177595258d','워크스페이스의 vm memory 사용률 조회','워크스페이스의 vm memory 사용률 조회','/workspace/{workspaceId}/dashboard/usage/memory','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','workspace','dashboard','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2f541397-c3f4-11ee-8281-7e177595258d','워크스페이스의 vm cpu 사용률 조회','워크스페이스의 vm cpu 사용률 조회','/workspace/{workspaceId}/dashboard/usage/cpu','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','workspace','dashboard','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('2f545a50-c3f4-11ee-8281-7e177595258d','플랫폼 과금 정책 수정','플랫폼 과금 정책 수정','/post/put/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','billing','PUT',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('2f54bc29-c3f4-11ee-8281-7e177595258d','기타 과금 정책 수정','기타 과금 정책 수정','/post/other/put/{folderId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','other','PUT',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('2f55059a-c3f4-11ee-8281-7e177595258d','기타 과금 정책 삭제','기타 과금 정책 삭제','/post/other/delete/{folderId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','other','PUT',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('2f5547fb-c3f4-11ee-8281-7e177595258d','플랫폼 과금 정책 삭제','플랫폼 과금 정책 삭제','/post/delete/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','billing','PUT',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('2f558a33-c3f4-11ee-8281-7e177595258d','기타 과금 정책 저장','기타 과금 정책 저장','/post/other/finops','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','other','POST',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('2f55d575-c3f4-11ee-8281-7e177595258d','플랫폼 과금 정책 저장','플랫폼 과금 정책 저장','/post/finops','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','billing','POST',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('2f561b5f-c3f4-11ee-8281-7e177595258d','기타 과금 정책 조회','기타 과금 정책 조회','/data/other/finops','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','other','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('2f56a14e-c3f4-11ee-8281-7e177595258d','기타 과금 정책 폴더별 조회','기타 과금 정책 폴더별 조회','/data/other/finops/info/folder/{folderId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','other','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('2f56f393-c3f4-11ee-8281-7e177595258d','기타 과금 폴더별 연결된 정책 조회 기능','기타 과금 폴더별 연결된 정책 조회 기능','/data/other/finops/folder','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','other','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('2f573590-c3f4-11ee-8281-7e177595258d','기타 과금 정책 폴더별 상세조회','기타 과금 정책 폴더별 상세조회','/data/other/finops/folder/{folderId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','other','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('2f577e2b-c3f4-11ee-8281-7e177595258d','플랫폼 과금 정책 조회','플랫폼 과금 정책 조회','/data/finops','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','billing','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('2f57cbee-c3f4-11ee-8281-7e177595258d','플랫폼 과금 정책 상세조회','플랫폼 과금 정책 상세조회','/data/finops/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','billing','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('2f584f46-c3f4-11ee-8281-7e177595258d','플랫폼 과금 정책 instanceId 조회','플랫폼 과금 정책 instanceId 조회','/data/finops/instance','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','billing','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('2f589282-c3f4-11ee-8281-7e177595258d','플랫폼 과금 정책 중복체크','플랫폼 과금 정책 중복체크','/data/finops/dupchk/{platformType}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','billing','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('2f58d1f3-c3f4-11ee-8281-7e177595258d','조직의 폴더 별 비용 분석','조직의 폴더 별 비용 분석','/cost/total-analysis/organization/folder','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','cost','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('2f5915bf-c3f4-11ee-8281-7e177595258d','클라우드 플랫폼 별 비용 분석','클라우드 플랫폼 별 비용 분석','/cost/total-analysis/cloud-platform','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','cost','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('2f595573-c3f4-11ee-8281-7e177595258d','클라우드 플랫폼 서비스 별 비용 분석','클라우드 플랫폼 서비스 별 비용 분석','/cost/total-analysis/cloud-platform/service','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','cost','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('2fec3302-64f9-11ef-aa9f-f2cdef6842ce','라우팅 테이블 이름수정','라우팅 테이블 이름수정','/network/route-tables/rewrite-name','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('2feca4ef-64f9-11ef-aa9f-f2cdef6842ce','EBS 스냅샷 목록 조회','EBS 스냅샷 목록 조회','/snapshot/ebs-snapshots','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ebs','snapshot','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('2fece8f8-64f9-11ef-aa9f-f2cdef6842ce','라우팅 테이블 이름수정','라우팅 테이블 이름수정','/network/route-tables/rewrite-name','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('2fed1ec0-64f9-11ef-aa9f-f2cdef6842ce','EBS 스냅샷 목록 조회','EBS 스냅샷 목록 조회','/snapshot/ebs-snapshots','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ebs','snapshot','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('2fedac37-6ab1-11ef-aa9f-f2cdef6842ce','사용자 콘솔 - 공급자 - 네임스페이스 리스트','사용자 콘솔 - 공급자 - 네임스페이스 리스트','/v1/user-console/provider/namespaces','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','tenant','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('2fee6ca4-6ab1-11ef-aa9f-f2cdef6842ce','사용자 콘솔 - 공급자 - 네임스페이스 리스트','사용자 콘솔 - 공급자 - 네임스페이스 리스트','/v1/user-console/provider/namespaces','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','tenant','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('30027b9d-4e14-11ef-8f18-c6494ca007d9','Ceph Dashboard resource 조회 API','Ceph Dashboard resource 조회 API','/dashboard/ceph','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','dashboard','ceph','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('3002fa49-4e14-11ef-8f18-c6494ca007d9','Ceph Dashboard resource 조회 API','Ceph Dashboard resource 조회 API','/dashboard/ceph','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','dashboard','ceph','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('30abd9b5-0a1d-11ef-9fbf-8ef2ee3c3984','클라우드 플랫폼 별 비용 분석','클라우드 플랫폼 별 비용 분석','/cost/platform/total-analysis/day/cloud-platform','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','cost','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('30ac3b8e-0a1d-11ef-9fbf-8ef2ee3c3984','공급자 및 테넌트가 연결된, 접근 가능 워크스페이스 목록 조회','공급자 및 테넌트가 연결된, 접근 가능 워크스페이스 목록 조회','/workspaces/accessible-with-tenant','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('310553ca-6e82-11ef-aa9f-f2cdef6842ce','Storage Backend read','Storage Backend read','/block-storage/storage-back-end/dashboard','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','storage','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('31061041-6e82-11ef-aa9f-f2cdef6842ce','Storage Backend read','Storage Backend read','/block-storage/storage-back-end/dashboard','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','storage','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('32b938e4-bc01-11ee-afaf-76fb71c4f9db','워크스페이스를 통한 바톤 리소스 조회','워크스페이스를 통한 바톤 리소스 조회','/baton/resources/workspace/{workspaceId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','baton','resource','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('32b9baac-bc01-11ee-afaf-76fb71c4f9db','워크스페이스 바톤 Openstack VM 리소스 조회','워크스페이스 바톤 Openstack VM 리소스 조회','/baton/resources/workspace/{workspaceId}/openstack/vm','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','baton','resource','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('32ba446d-bc01-11ee-afaf-76fb71c4f9db','워크스페이스 바톤 K8s pod 리소스 조회','워크스페이스 바톤 K8s pod 리소스 조회','/baton/resources/workspace/{workspaceId}/kubernetes/pods','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','baton','resource','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('32ba8fce-bc01-11ee-afaf-76fb71c4f9db','폴더 리소스 조회','폴더 리소스 조회','/baton/resources/folder/{folderId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','baton','resource','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('33978742-0e22-11ef-9fbf-8ef2ee3c3984','사용자 업데이트','사용자 업데이트','/iam/users/{oldUserName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','user','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3397fbcf-0e22-11ef-9fbf-8ef2ee3c3984','사용자 정책 부착','사용자 정책 부착','/iam/users/policy','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','user','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('33982ef9-0e22-11ef-9fbf-8ef2ee3c3984','nic 부착','nic 부착','/compute/nics/attach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','network interface','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('348bb789-19ce-11f0-92a4-b2a8347e4220','플랫폼 과금 정책 수정','플랫폼 과금 정책 수정','/data/finops/put/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','billing','PUT',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('348cfca1-19ce-11f0-92a4-b2a8347e4220','플랫폼 과금 정책 삭제','플랫폼 과금 정책 삭제','/data/finops/delete/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','billing','PUT',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('348d3590-19ce-11f0-92a4-b2a8347e4220','플랫폼 기본 과금 정책 저장','플랫폼 기본 과금 정책 저장','/data/finops','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','billing','POST',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('348d637d-19ce-11f0-92a4-b2a8347e4220','과금 대기 정책 조회','과금 대기 정책 조회','/data/finops/pendingPolicy','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','billing','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('36d9602f-fc5b-11ee-b354-0eff8aa9f4e3','워크스페이스 강제 삭제','워크스페이스 강제 삭제','/workspaces/forceDelete/{workspaceId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('36f62b24-cf29-11ef-9c74-0a11b82fa8dd','rack id 기준 switch 상세 조회','rack id 기준 switch 상세 조회','/topology/switch/{switchId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','topology','rack-topology','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('36f6aeba-cf29-11ef-9c74-0a11b82fa8dd','request id로 log 정보 조회','request id로 log 정보 조회','/mole/request-id/broadcast','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','vip','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('36f6ed25-cf29-11ef-9c74-0a11b82fa8dd','ram-allocation-ratio-by-host','ram-allocation-ratio-by-host','/mole/ram-allocation-ratio2','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','host','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('36f724dc-cf29-11ef-9c74-0a11b82fa8dd','cpu-allocation-ratio-by-host','cpu-allocation-ratio-by-host','/mole/cpu-allocation-ratio2','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','host','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('36f89d50-cf29-11ef-9c74-0a11b82fa8dd','rack id 기준 switch 상세 조회','rack id 기준 switch 상세 조회','/topology/switch/{switchId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','topology','rack-topology','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('36f8c595-cf29-11ef-9c74-0a11b82fa8dd','request id로 log 정보 조회','request id로 log 정보 조회','/mole/request-id/broadcast','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','vip','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('36f8e8d4-cf29-11ef-9c74-0a11b82fa8dd','ram-allocation-ratio-by-host','ram-allocation-ratio-by-host','/mole/ram-allocation-ratio2','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','host','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('36f909c4-cf29-11ef-9c74-0a11b82fa8dd','cpu-allocation-ratio-by-host','cpu-allocation-ratio-by-host','/mole/cpu-allocation-ratio2','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','host','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('37b18a63-dac6-11ee-84a7-5e1f35257281','서비스 카탈로그 오브젝트 즐겨찾기 등록','서비스 카탈로그 오브젝트 즐겨찾기 등록','/service-catalogs/bookmark','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('37b22fc2-dac6-11ee-84a7-5e1f35257281','서비스 카탈로그 오브젝트 즐겨찾기 삭제','서비스 카탈로그 오브젝트 즐겨찾기 삭제','/service-catalogs/bookmark/{serviceCatalogId}/service-object/{serviceObjectId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','DELETE',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('382a3ca0-3c63-11f0-96fd-3eb1d9594243','사용자 콘솔에서 VM 메타 리스트 조회','사용자 콘솔에서 VM 메타 리스트 조회','/vcenter/meta/vms','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('382bc714-3c63-11f0-96fd-3eb1d9594243','사용자 콘솔에서 VM 메타 리스트 조회','사용자 콘솔에서 VM 메타 리스트 조회','/vcenter/meta/vms','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('38410536-9825-11ee-971f-72441c073636','서비스-오브젝트 삭제','서비스-오브젝트 삭제','/service-objects/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('3841b1cb-9825-11ee-971f-72441c073636','메뉴 정보 수정','메뉴 정보 수정','/menu/{menuId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','menu','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('3841ffd2-9825-11ee-971f-72441c073636','메뉴 관리에서 메뉴 목록 조회','메뉴 관리에서 메뉴 목록 조회','/menu','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','menu','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('38424465-9825-11ee-971f-72441c073636','메뉴 상세 조회','메뉴 상세 조회','/menu/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','menu','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('38483fe0-9825-11ee-971f-72441c073636','메뉴 기능 타입 목록 조회','메뉴에서 사용될 수 있는 기능 목록 조회.','/menu/feature/types','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','menu','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('388a856b-9011-11ef-a845-1a3f5588de48','key 로테이션','key 로테이션','/kms/rotation/{keyId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','kms','kms','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('388ae502-9011-11ef-a845-1a3f5588de48','key 기본 리전 변경','key 기본 리전 변경','/kms/primary-region','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','kms','kms','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('388b2441-9011-11ef-a845-1a3f5588de48','key 정책 수정','key 정책 수정','/kms/policy','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','kms','kms','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('388b5cb3-9011-11ef-a845-1a3f5588de48','key 정책 생성','key 정책 생성','/kms/policy','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','kms','kms','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('388b929d-9011-11ef-a845-1a3f5588de48','Loadbalancer 태그 조회','Loadbalancer 태그 조회','/loadbalancer-tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','loadbalancer','tags','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('388bef77-9011-11ef-a845-1a3f5588de48','Loadbalancer 태그 추가','Loadbalancer 태그 추가','/loadbalancer-tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','loadbalancer','tags','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('388c3704-9011-11ef-a845-1a3f5588de48','Loadbalancer 태그 삭제','Loadbalancer 태그 삭제','/loadbalancer-tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','loadbalancer','tags','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('388c8f4f-9011-11ef-a845-1a3f5588de48','모든 알리아스 목록 조회','모든 알리아스 목록 조회','/kms/alias','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','kms','kms','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('388cbd6a-9011-11ef-a845-1a3f5588de48','VPC와 관련된 서비스 할당량 목록 조회','VPC와 관련된 서비스 할당량 목록 조회','/servicequotas/inquiry/service-quotas-with-vpc','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('388cebfa-9011-11ef-a845-1a3f5588de48','관련 다중 리전 목록 조회','관련 다중 리전 목록 조회','/kms/{keyId}/multi-region-keys','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','kms','kms','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('388d1d4d-9011-11ef-a845-1a3f5588de48','비대칭 퍼블릭 키 조회','비대칭 퍼블릭 키 조회','/kms/public-key/{keyId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','kms','kms','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('388d5027-9011-11ef-a845-1a3f5588de48','롤과 유저 패스 및 arn 정보 목록','롤과 유저 패스 및 arn 정보 목록','/iam/users/roles-users','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','user','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('388da3a8-9011-11ef-a845-1a3f5588de48','key 로테이션','key 로테이션','/kms/rotation/{keyId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','kms','kms','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('388dd8cd-9011-11ef-a845-1a3f5588de48','key 기본 리전 변경','key 기본 리전 변경','/kms/primary-region','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','kms','kms','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('388e0e96-9011-11ef-a845-1a3f5588de48','key 정책 수정','key 정책 수정','/kms/policy','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','kms','kms','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('388e4ba5-9011-11ef-a845-1a3f5588de48','key 정책 생성','key 정책 생성','/kms/policy','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','kms','kms','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('388e849f-9011-11ef-a845-1a3f5588de48','Loadbalancer 태그 조회','Loadbalancer 태그 조회','/loadbalancer-tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','loadbalancer','tags','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('388ec786-9011-11ef-a845-1a3f5588de48','Loadbalancer 태그 추가','Loadbalancer 태그 추가','/loadbalancer-tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','loadbalancer','tags','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('388effb1-9011-11ef-a845-1a3f5588de48','Loadbalancer 태그 삭제','Loadbalancer 태그 삭제','/loadbalancer-tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','loadbalancer','tags','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('388f28e4-9011-11ef-a845-1a3f5588de48','모든 알리아스 목록 조회','모든 알리아스 목록 조회','/kms/alias','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','kms','kms','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('388f4f83-9011-11ef-a845-1a3f5588de48','VPC와 관련된 서비스 할당량 목록 조회','VPC와 관련된 서비스 할당량 목록 조회','/servicequotas/inquiry/service-quotas-with-vpc','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','servicequotas','servicequotas','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('388f7aec-9011-11ef-a845-1a3f5588de48','관련 다중 리전 목록 조회','관련 다중 리전 목록 조회','/kms/{keyId}/multi-region-keys','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','kms','kms','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('388fa3be-9011-11ef-a845-1a3f5588de48','비대칭 퍼블릭 키 조회','비대칭 퍼블릭 키 조회','/kms/public-key/{keyId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','kms','kms','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('388fcb67-9011-11ef-a845-1a3f5588de48','롤과 유저 패스 및 arn 정보 목록','롤과 유저 패스 및 arn 정보 목록','/iam/users/roles-users','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','user','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('38bef601-65c0-11ef-aa9f-f2cdef6842ce','최적화 방안 결과 조회 API','최적화 방안 결과 조회 API','/resource/provider/{providerId}/result','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','drs','resource','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('38bf6e90-65c0-11ef-aa9f-f2cdef6842ce','최적화 방안 결과 조회 API','최적화 방안 결과 조회 API','/resource/provider/{providerId}/result','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','drs','resource','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('3a30b89a-892b-11ee-a4fd-dadafdb14cb0','감사 로그 조회(관리자, 사용자 공통으로 검색됨)','감사 로그 조회(관리자, 사용자 공통으로 검색됨)','/log/work','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','dashboard','GET',1,'bb6fa9a6-8443-11ee-a4fd-dadafdb14cb0',0)
    ,   ('3a490581-8312-11ee-a4fd-dadafdb14cb0','워크스페이스 가상머신 상태 변경(시작, 정지, 재시작)','모든 제품 파라미터에 따라 가상머신 상태 변경','/workspaces/servers/tenants/{tenantId}/instances/{instanceId}/{status}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('3a5872f5-8312-11ee-a4fd-dadafdb14cb0','서비스 신청 생성','서비스 신청 생성','/service-objects/requests/{id}/vmware','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('3a5a019c-8312-11ee-a4fd-dadafdb14cb0','오픈스택 서비스 신청','오픈스택 서비스 신청','/service-objects/requests/{id}/openstack','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('3a5b0706-8312-11ee-a4fd-dadafdb14cb0','서비스 신청','서비스 신청','/service-objects/requests/{id}/ncp','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('3a5c0a99-8312-11ee-a4fd-dadafdb14cb0','서비스 신청 생성','서비스 신청 생성','/service-objects/requests/{id}/kubernetes','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('3a609a51-8312-11ee-a4fd-dadafdb14cb0','워크스페이스에 연결된 공급자 목록 조회','워크스페이스에 연결된 공급자 목록 조회','/workspaces/{id}/providers','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('3a617f0d-8312-11ee-a4fd-dadafdb14cb0','워크스페이스에 연결된 공급자에 연결된 테넌트 ID 목록 조회','워크스페이스에 연결된 공급자에 연결된 테넌트 ID 목록 조회','/workspaces/{id}/providers/{providerId}/tenants','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('3a626921-8312-11ee-a4fd-dadafdb14cb0','워크스페이스 가상머신 목록 조회 API','워크스페이스 가상머신 목록 조회 API','/workspaces/servers','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('3a637110-8312-11ee-a4fd-dadafdb14cb0','워크스페이스 컨테이너 목록 조회 API','워크스페이스 컨테이너 목록 조회 API','/workspaces/containers','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','container','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('3a64a0b5-8312-11ee-a4fd-dadafdb14cb0','(현재 사용자) 접근 가능 워크스페이스 목록 조회','(현재 사용자) 접근 가능 워크스페이스 목록 조회','/workspaces/accessible','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('3a6d8f5f-8312-11ee-a4fd-dadafdb14cb0','서비스-카탈로그-요청 승인 API','서비스-카탈로그-요청에 대한 반려 기능','/service-objects/requests/{id}/reject','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('3a6e79ac-8312-11ee-a4fd-dadafdb14cb0','서비스 신청 승인','서비스 신청 승인','/service-objects/requests/{id}/approve','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('3a6f582c-8312-11ee-a4fd-dadafdb14cb0','서비스-카탈로그-요청 조회 API','서비스-카탈로그-요청 조회 API','/service-objects/requests/assignments','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('3cc5f63b-44a9-11ef-a4c4-96fd9ef2bacb','볼륨 리소스 개수 조회','볼륨 리소스 개수 조회','/dashboard/volume-test/resources-count','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','dashboard','dashboard','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3cc66b81-44a9-11ef-a4c4-96fd9ef2bacb','볼륨 리소스 개수 조회','볼륨 리소스 개수 조회','/dashboard/volume-test/resources-count','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','dashboard','dashboard','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3d12b81f-0ddf-11ef-9fbf-8ef2ee3c3984','가상머신 별 이상탐지 목록 조회','가상머신 별 이상탐지 목록 조회','/ai/anomaly-detection/servers/{dayCount}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','ai','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('3d14fb63-4b2b-11ef-a4c4-96fd9ef2bacb','객체 Or 폴더 업로드','객체 Or 폴더 업로드','/storages/upload','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3d154798-4b2b-11ef-a4c4-96fd9ef2bacb','객체 Or 폴더 업로드','객체 Or 폴더 업로드','/storages/upload','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3d9ec177-24c3-11f0-acfd-fecd16557305','서비스 신청','서비스 신청','/service-objects/requests/self','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('3da11456-24c3-11f0-acfd-fecd16557305','사용자 감사 로그 조회(관리자용)','사용자 감사 로그 조회(관리자용)','/log/work/user','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','dashboard','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('3da22eec-24c3-11f0-acfd-fecd16557305','관리자 감사 로그 조회(관리자용)','관리자 감사 로그 조회(관리자용)','/log/work/admin','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','dashboard','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('3e4e59aa-007f-11ef-8bb1-cee8dc1678f7','오브젝트 account meta-data 생성/수정/삭제 API','오브젝트 account meta-data 생성/수정/삭제 API','/swift/accounts/metadata','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','swift','accounts','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('3e769dd0-b219-11ef-97f1-9e78f0b36502','record set 수정','record set 수정','/route53s/record-sets','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e775016-b219-11ef-97f1-9e78f0b36502','record set 생성','record set 생성','/route53s/record-sets','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e779d37-b219-11ef-97f1-9e78f0b36502','Hosted Zone DNSSEC 활성화','Hosted Zone DNSSEC 활성화','/route53s/locations/{hostedZoneId}/dnssec/enable','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e77c4dc-b219-11ef-97f1-9e78f0b36502','Hosted Zone DNSSEC 비활성화','Hosted Zone DNSSEC 비활성화','/route53s/locations/{hostedZoneId}/dnssec/disable','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e77e0f6-b219-11ef-97f1-9e78f0b36502','locations comment 변경','locations comment 변경','/route53s/locations/comment','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e780f1d-b219-11ef-97f1-9e78f0b36502','도메인 서버 이름 변경','도메인 서버 이름 변경','/route53s/domains/dns-change','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('3e782fbc-b219-11ef-97f1-9e78f0b36502','admin : GET/autoscaling/tags','admin : GET/autoscaling/tags','/autoscaling/tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','tags','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e785fdf-b219-11ef-97f1-9e78f0b36502','admin : PUT/autoscaling/tags','admin : PUT/autoscaling/tags','/autoscaling/tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','tags','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e787ff4-b219-11ef-97f1-9e78f0b36502','admin : POST/autoscaling/tags','admin : POST/autoscaling/tags','/autoscaling/tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','tags','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e791c57-b219-11ef-97f1-9e78f0b36502','오토스케일링 업데이트 및 서비스 프로세스 제어','오토스케일링 업데이트 및 서비스 프로세스 제어','/autoscaling/provisioning/groups/update-and-suspend','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e793943-b219-11ef-97f1-9e78f0b36502','로드밸런서 연결 해제','로드밸런서 연결 해제','/autoscaling/provisioning/groups/loadbalancer','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e796eaf-b219-11ef-97f1-9e78f0b36502','로드밸런서 타겟 그룹 연결 해제','로드밸런서 타겟 그룹 연결 해제','/autoscaling/provisioning/groups/loadbalancer/target-groups','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e799eef-b219-11ef-97f1-9e78f0b36502','오토스케일링 타겟그룹 attach and detach','오토스케일링 타겟그룹 attach and detach','/autoscaling/provisioning/groups/attach-and-detach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e79b866-b219-11ef-97f1-9e78f0b36502','볼륨 스냅샷 생성','볼륨 스냅샷 생성','/volumes/snapshots','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volume','ebs','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e79e5ed-b219-11ef-97f1-9e78f0b36502','리소스 태그 조회','리소스 태그 조회','/route53s/tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e79fda8-b219-11ef-97f1-9e78f0b36502','Route53 리소스 태그 변경','Route53 리소스 태그 변경','/route53s/tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7a152d-b219-11ef-97f1-9e78f0b36502','도메인 조회','도메인 조회','/route53s/domains','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7a2d9a-b219-11ef-97f1-9e78f0b36502','도메인 등록','도메인 등록','/route53s/domains','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7a4296-b219-11ef-97f1-9e78f0b36502','도메인 태그 조회','도메인 태그 조회','/route53s/domains/tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7a57c7-b219-11ef-97f1-9e78f0b36502','도메인 태그 수정','도메인 태그 수정','/route53s/domains/tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7a6e9d-b219-11ef-97f1-9e78f0b36502','도메인 태그 삭제','도메인 태그 삭제','/route53s/domains/tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7aa96c-b219-11ef-97f1-9e78f0b36502','도메인 갱신','도메인 갱신','/route53s/domains/renew','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7ac5c2-b219-11ef-97f1-9e78f0b36502','도메인 자동 갱신 활성화','도메인 자동 갱신 활성화','/route53s/domains/renew/enable','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7adbea-b219-11ef-97f1-9e78f0b36502','도메인 자동 갱신 비활성화','도메인 자동 갱신 비활성화','/route53s/domains/renew/disable','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7b12d9-b219-11ef-97f1-9e78f0b36502','도메인 연락처 수정','도메인 연락처 수정','/route53s/domains/contact','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7b3e21-b219-11ef-97f1-9e78f0b36502','사용가능 도메인 체크','사용가능 도메인 체크','/route53s/domains/check','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('3e7b59cf-b219-11ef-97f1-9e78f0b36502','오토스케일링 서비스 프로세스 제어','오토스케일링 서비스 프로세스 제어','/autoscaling/provisioning/groups/suspend','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7b7424-b219-11ef-97f1-9e78f0b36502','VPC 엔드포인트 목록','VPC 엔드포인트 목록','/vpc-endpoints','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc endpoint','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7b95c9-b219-11ef-97f1-9e78f0b36502','VPC 엔드포인트 상세보기','VPC 엔드포인트 상세보기','/vpc-endpoints/{vpcEndpointId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc endpoint','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7bb1af-b219-11ef-97f1-9e78f0b36502','VPC 엔드포인트 필터하여 목록을 조회한다','VPC 엔드포인트 필터하여 목록을 조회한다','/vpc-endpoints/filters','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc endpoint','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7bc99f-b219-11ef-97f1-9e78f0b36502','VPC 엔드포인트 중복 체크','VPC 엔드포인트 중복 체크','/vpc-endpoints/duplicate-checker','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc endpoint','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7be6c5-b219-11ef-97f1-9e78f0b36502','볼륨 속성값 조회','볼륨 속성값 조회','/volumes/{volumeId}/attributes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volumes','volume','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7bfe68-b219-11ef-97f1-9e78f0b36502','볼륨 디바이스 명 조회','볼륨 디바이스 명 조회','/volumes/devices','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volumes','volume','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7c1776-b219-11ef-97f1-9e78f0b36502','볼륨 디바이스 명 OS 별 조회','볼륨 디바이스 명 OS 별 조회','/volumes/devices/{os}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volumes','volume','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7c3bd3-b219-11ef-97f1-9e78f0b36502','recourdList 조회','recourdList 조회','/route53s/records','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7c6169-b219-11ef-97f1-9e78f0b36502','locations 디테일 조회','locations 디테일 조회','/route53s/locations/{hostedzoneId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7c8d09-b219-11ef-97f1-9e78f0b36502','locations duplicate check 조회','locations duplicate check 조회','/route53s/locations/is-duplicated-hostedname/{hotedzonename}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7cbd3a-b219-11ef-97f1-9e78f0b36502','Health check 조회','Health check 조회','/route53s/health-check','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7ced65-b219-11ef-97f1-9e78f0b36502','이전 잠금 비활성','이전 잠금 비활성','/route53s/domains/unlock/{domainname}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7d0982-b219-11ef-97f1-9e78f0b36502','도메인 추천 조회','도메인 추천 조회','/route53s/domains/suggestions','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7d1ec5-b219-11ef-97f1-9e78f0b36502','도메인 가격 조회','도메인 가격 조회','/route53s/domains/prices','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7d3bc8-b219-11ef-97f1-9e78f0b36502','이전 잠금 활성','이전 잠금 활성','/route53s/domains/lock/{domainname}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7d5d7f-b219-11ef-97f1-9e78f0b36502','도메인 상세 조회','도메인 상세 조회','/route53s/domains/detail','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7d7e2f-b219-11ef-97f1-9e78f0b36502','도메인 비용조회','도메인 비용조회','/route53s/domains/cost/{domainname}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7d989a-b219-11ef-97f1-9e78f0b36502','Dns Sec 조회','Dns Sec 조회','/route53s/dns-sec','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7dadde-b219-11ef-97f1-9e78f0b36502','역할 목록 조회','역할 목록 조회','/iam/users/roles','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','user','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('3e7ddefe-b219-11ef-97f1-9e78f0b36502','정책 정보 조회','정책 정보 조회','/iam/users/policies/arn','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','user','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7e43c2-b219-11ef-97f1-9e78f0b36502','시작 템플릿 중복 체크','시작 템플릿 중복 체크','/ec2/launchtemplates/duplication-checker','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7e733a-b219-11ef-97f1-9e78f0b36502','인스턴스 타입 가능 AZ 목록','인스턴스 타입 가능 AZ 목록','/compute/servers/{instanceType}/azs','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7ea499-b219-11ef-97f1-9e78f0b36502','Data Platform 조회','Data Platform 조회','/api/dataplatform','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','data platform','data platform','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7ed271-b219-11ef-97f1-9e78f0b36502','record set 삭제','record set 삭제','/route53s/record-sets/deletes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7eee3c-b219-11ef-97f1-9e78f0b36502','도메인 삭제','도메인 삭제','/route53s/domains/{domainname}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('3e7f14fc-b219-11ef-97f1-9e78f0b36502','record set 수정','record set 수정','/route53s/record-sets','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e7f3c0f-b219-11ef-97f1-9e78f0b36502','record set 생성','record set 생성','/route53s/record-sets','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e7f55e4-b219-11ef-97f1-9e78f0b36502','Hosted Zone DNSSEC 활성화','Hosted Zone DNSSEC 활성화','/route53s/locations/{hostedZoneId}/dnssec/enable','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e7f6d0a-b219-11ef-97f1-9e78f0b36502','Hosted Zone DNSSEC 비활성화','Hosted Zone DNSSEC 비활성화','/route53s/locations/{hostedZoneId}/dnssec/disable','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e7f857c-b219-11ef-97f1-9e78f0b36502','locations comment 변경','locations comment 변경','/route53s/locations/comment','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e7fa076-b219-11ef-97f1-9e78f0b36502','user : GET/autoscaling/tags','user : GET/autoscaling/tags','/autoscaling/tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','tags','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e7fbd03-b219-11ef-97f1-9e78f0b36502','user : PUT/autoscaling/tags','user : PUT/autoscaling/tags','/autoscaling/tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','tags','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e7fe142-b219-11ef-97f1-9e78f0b36502','user : POST/autoscaling/tags','user : POST/autoscaling/tags','/autoscaling/tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','tags','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e807121-b219-11ef-97f1-9e78f0b36502','오토스케일링 업데이트 및 서비스 프로세스 제어','오토스케일링 업데이트 및 서비스 프로세스 제어','/autoscaling/provisioning/groups/update-and-suspend','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e808e28-b219-11ef-97f1-9e78f0b36502','로드밸런서 연결 해제','로드밸런서 연결 해제','/autoscaling/provisioning/groups/loadbalancer','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e80c4e2-b219-11ef-97f1-9e78f0b36502','로드밸런서 타겟 그룹 연결 해제','로드밸런서 타겟 그룹 연결 해제','/autoscaling/provisioning/groups/loadbalancer/target-groups','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e80f6a4-b219-11ef-97f1-9e78f0b36502','오토스케일링 타겟그룹 attach and detach','오토스케일링 타겟그룹 attach and detach','/autoscaling/provisioning/groups/attach-and-detach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e81103d-b219-11ef-97f1-9e78f0b36502','볼륨 스냅샷 생성','볼륨 스냅샷 생성','/volumes/snapshots','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volume','ebs','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e816a03-b219-11ef-97f1-9e78f0b36502','리소스 태그 조회','리소스 태그 조회','/route53s/tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('3e81c39a-b219-11ef-97f1-9e78f0b36502','Route53 리소스 태그 변경','Route53 리소스 태그 변경','/route53s/tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e81e23e-b219-11ef-97f1-9e78f0b36502','도메인 등록','도메인 등록','/route53s/domains/{domainname}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e81ffe8-b219-11ef-97f1-9e78f0b36502','도메인 삭제','도메인 삭제','/route53s/domains/{domainname}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e8216a8-b219-11ef-97f1-9e78f0b36502','도메인 태그 조회','도메인 태그 조회','/route53s/domains/tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e822cbb-b219-11ef-97f1-9e78f0b36502','도메인 태그 수정','도메인 태그 수정','/route53s/domains/tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e82460f-b219-11ef-97f1-9e78f0b36502','도메인 태그 삭제','도메인 태그 삭제','/route53s/domains/tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e82634e-b219-11ef-97f1-9e78f0b36502','오토스케일링 서비스 프로세스 제어','오토스케일링 서비스 프로세스 제어','/autoscaling/provisioning/groups/suspend','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e82cb28-b219-11ef-97f1-9e78f0b36502','VPC 엔드포인트 목록','VPC 엔드포인트 목록','/vpc-endpoints','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc endpoint','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e832f31-b219-11ef-97f1-9e78f0b36502','VPC 엔드포인트 상세보기','VPC 엔드포인트 상세보기','/vpc-endpoints/{vpcEndpointId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc endpoint','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e8358a6-b219-11ef-97f1-9e78f0b36502','VPC 엔드포인트 필터하여 목록을 조회한다','VPC 엔드포인트 필터하여 목록을 조회한다','/vpc-endpoints/filters','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc endpoint','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e838834-b219-11ef-97f1-9e78f0b36502','VPC 엔드포인트 중복 체크','VPC 엔드포인트 중복 체크','/vpc-endpoints/duplicate-checker','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc endpoint','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e83ae9b-b219-11ef-97f1-9e78f0b36502','볼륨 속성값 조회','볼륨 속성값 조회','/volumes/{volumeId}/attributes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volumes','volume','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e83cc12-b219-11ef-97f1-9e78f0b36502','볼륨 디바이스 명 조회','볼륨 디바이스 명 조회','/volumes/devices','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volumes','volume','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e83e3e6-b219-11ef-97f1-9e78f0b36502','볼륨 디바이스 명 OS 별 조회','볼륨 디바이스 명 OS 별 조회','/volumes/devices/{os}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volumes','volume','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e83fc20-b219-11ef-97f1-9e78f0b36502','recourdList 조회','recourdList 조회','/route53s/records','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e845201-b219-11ef-97f1-9e78f0b36502','locations 디테일 조회','locations 디테일 조회','/route53s/locations/{hostedzoneId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e8478fc-b219-11ef-97f1-9e78f0b36502','locations duplicate check 조회','locations duplicate check 조회','/route53s/locations/is-duplicated-hostedname/{hotedzonename}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e849892-b219-11ef-97f1-9e78f0b36502','Health check 조회','Health check 조회','/route53s/health-check','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e84b322-b219-11ef-97f1-9e78f0b36502','도메인 조회','도메인 조회','/route53s/domains','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e84cb3d-b219-11ef-97f1-9e78f0b36502','도메인 추천 조회','도메인 추천 조회','/route53s/domains/suggestions','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('3e84e53a-b219-11ef-97f1-9e78f0b36502','도메인 가격 조회','도메인 가격 조회','/route53s/domains/prices','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e84fae2-b219-11ef-97f1-9e78f0b36502','도메인 상세 조회','도메인 상세 조회','/route53s/domains/detail','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e850f96-b219-11ef-97f1-9e78f0b36502','Dns Sec 조회','Dns Sec 조회','/route53s/dns-sec','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e85260c-b219-11ef-97f1-9e78f0b36502','역할 목록 조회','역할 목록 조회','/iam/users/roles','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','user','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e8542c2-b219-11ef-97f1-9e78f0b36502','정책 정보 조회','정책 정보 조회','/iam/users/policies/arn','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','user','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e855c82-b219-11ef-97f1-9e78f0b36502','인스턴스 타입 가능 AZ 목록','인스턴스 타입 가능 AZ 목록','/compute/servers/{instanceType}/azs','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e857402-b219-11ef-97f1-9e78f0b36502','Data Platform 조회','Data Platform 조회','/api/dataplatform','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','data platform','data platform','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3e859077-b219-11ef-97f1-9e78f0b36502','record set 삭제','record set 삭제','/route53s/record-sets/deletes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('3ec9e372-e5c0-11ee-9e78-fa4b89773297','자신의 정보 조회','자신의 정보 조회','/user/profile/info','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('3f4c5151-8fe5-11ee-92eb-661b04f0c4aa','',NULL,'/test22','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','billing','month','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',1)
    ,   ('3fe617e1-e59d-11ee-9e78-fa4b89773297','사용자 알림 수신 정보 조회 API','사용자 알림 수신 정보 조회 API','/receive-info','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','notification','GET',1,'dc347010-c3f4-11ee-8281-7e177595258d',1)
    ,   ('3fe7fc0f-e59d-11ee-9e78-fa4b89773297','사용자 알림 수신 정보 수정 API','사용자 알림 수신 정보 수정 API','/receive-info','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','notification','PUT',1,'dc347010-c3f4-11ee-8281-7e177595258d',1)
    ,   ('41b11cd7-605f-11ef-9a30-f2cdef6842ce','로드벨런서 이름 중복 조회','로드벨런서 이름 중복 조회','/load-balancers/is-used-name','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancer','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('41b173e1-605f-11ef-9a30-f2cdef6842ce','로드벨런서 이름 중복 조회','로드벨런서 이름 중복 조회','/load-balancers/is-used-name','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancer','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('41cd83f0-36cd-11f0-80c3-6e593baabd40','테넌트 상세 조회','테넌트 상세 조회','/tenants/{tenantId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','tenants','tenant','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ce33f8-36cd-11f0-80c3-6e593baabd40','user : PUT/tenants/{tenantId}','user : PUT/tenants/{tenantId}','/tenants/{tenantId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','tenants','tenant','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ce7295-36cd-11f0-80c3-6e593baabd40','타겟 그룹 생성','타겟 그룹 생성','/target-group/update/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','loadbalancer','targetgroup','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41cea434-36cd-11f0-80c3-6e593baabd40','타겟 그룹에 적용될 타겟을 설정','타겟 그룹에 적용될 타겟을 설정','/target-group/update/target/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','loadbalancer','target','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ced24c-36cd-11f0-80c3-6e593baabd40','copyObject','copyObject','/storage/objectstorage/buckets/{bucketName}/copyObject','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41cf16ae-36cd-11f0-80c3-6e593baabd40','user : PUT/storage/objectstorage/buckets/parts','user : PUT/storage/objectstorage/buckets/parts','/storage/objectstorage/buckets/parts','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('41cf48ba-36cd-11f0-80c3-6e593baabd40','putFolder','putFolder','/storage/objectstorage/buckets/folder','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41cf7ada-36cd-11f0-80c3-6e593baabd40','대시보드 버킷 조회 및 버킷 조회','대시보드 버킷 조회 및 버킷 조회','/storage/objectstorage/buckets','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41cfb662-36cd-11f0-80c3-6e593baabd40','putObject','putObject','/storage/objectstorage/buckets','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41cfecbb-36cd-11f0-80c3-6e593baabd40','bucket 생성','bucket 생성','/storage/objectstorage/buckets','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d04961-36cd-11f0-80c3-6e593baabd40','subnet networkACL 수정','subnet networkACL 수정','/network/subnets/{subnetId}/{aclId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','subnet','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d0c1be-36cd-11f0-80c3-6e593baabd40','route table list','route table list','/network/routeTables','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','route table','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d0f22e-36cd-11f0-80c3-6e593baabd40','route Table 메모 수정','route Table 메모 수정','/network/routeTables','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','routetable','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d11d95-36cd-11f0-80c3-6e593baabd40','route Table 생성','route Table 생성','/network/routeTables','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','routetable','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d1442e-36cd-11f0-80c3-6e593baabd40','natGatewayDescription 수정','natGatewayDescription 수정','/network/nat-gateways/description','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','nat gateway','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d19573-36cd-11f0-80c3-6e593baabd40','Network ACL Outbound 규칙 추가','Network ACL Outbound 규칙 추가','/network/acls/rules/outbounds','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network acl','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d1c27e-36cd-11f0-80c3-6e593baabd40','Network ACL Outbound 규칙 제거','Network ACL Outbound 규칙 제거','/network/acls/rules/outbounds','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network acl','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d1eae2-36cd-11f0-80c3-6e593baabd40','Network ACL Inbound 규칙 추가','Network ACL Inbound 규칙 추가','/network/acls/rules/inbounds','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network acl','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d20bbc-36cd-11f0-80c3-6e593baabd40','Network ACL Inbound 규칙 제거','Network ACL Inbound 규칙 제거','/network/acls/rules/inbounds','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network acl','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d2364d-36cd-11f0-80c3-6e593baabd40','Network ACL 설명(메모) 수정','Network ACL 설명(메모) 수정','/network/acls/description','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network acl','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d258af-36cd-11f0-80c3-6e593baabd40','Network ACL Deny Allow IP 설정','Network ACL Deny Allow IP 설정','/network/acls/deny-allow-groups/ip','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network acl','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d27cd2-36cd-11f0-80c3-6e593baabd40','Network ACL Deny Allow Group 메모 변경','Network ACL Deny Allow Group 메모 변경','/network/acls/deny-allow-groups/description','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network acl','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d2d9f8-36cd-11f0-80c3-6e593baabd40','user : PUT/compute/server/servers/{serverNo}/terminate','user : PUT/compute/server/servers/{serverNo}/terminate','/compute/server/servers/{serverNo}/terminate','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d32a3d-36cd-11f0-80c3-6e593baabd40','운영중 상태의 Server 정지','운영중 상태의 Server 정지','/compute/server/servers/{serverNo}/stop','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d36f26-36cd-11f0-80c3-6e593baabd40','user : PUT/compute/server/servers/{serverNo}/start','user : PUT/compute/server/servers/{serverNo}/start','/compute/server/servers/{serverNo}/start','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d396a0-36cd-11f0-80c3-6e593baabd40','운영중 상태의 Server 재시작','운영중 상태의 Server 재시작','/compute/server/servers/{serverNo}/reboot','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('41d3db6b-36cd-11f0-80c3-6e593baabd40','publicIp 서버인스턴스 할당해제','publicIp 서버인스턴스 할당해제','/compute/server/public-ip/disassociate','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','public ip','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d40496-36cd-11f0-80c3-6e593baabd40','user : PUT/compute/server/public-ip/associate','user : PUT/compute/server/public-ip/associate','/compute/server/public-ip/associate','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','public ip','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d42475-36cd-11f0-80c3-6e593baabd40','NIC 내에서 속한 ACG 리스트 수정','NIC 내에서 속한 ACG 리스트 수정','/compute/server/network-interface/{networkInterfaceNo}/acg','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d44566-36cd-11f0-80c3-6e593baabd40','user : PUT/compute/server/network-interface/unassign-SecondaryIps','user : PUT/compute/server/network-interface/unassign-SecondaryIps','/compute/server/network-interface/unassign-SecondaryIps','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d46897-36cd-11f0-80c3-6e593baabd40','NIC 서버에서 해제','NIC 서버에서 해제','/compute/server/network-interface/detach-networkInterface','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d4890b-36cd-11f0-80c3-6e593baabd40','NIC 할달','NIC 할달','/compute/server/network-interface/attach-networkInterface','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d4bc78-36cd-11f0-80c3-6e593baabd40','user : PUT/compute/server/network-interface/assign-secondaryIps','user : PUT/compute/server/network-interface/assign-secondaryIps','/compute/server/network-interface/assign-secondaryIps','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d4e2aa-36cd-11f0-80c3-6e593baabd40','user : PUT/compute/server/acgs/out-bound','user : PUT/compute/server/acgs/out-bound','/compute/server/acgs/out-bound','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d505d0-36cd-11f0-80c3-6e593baabd40','user : DELETE/compute/server/acgs/out-bound','user : DELETE/compute/server/acgs/out-bound','/compute/server/acgs/out-bound','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d54da4-36cd-11f0-80c3-6e593baabd40','AccessControlGroup inbound 추가','AccessControlGroup inbound 추가','/compute/server/acgs/in-bound','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','PUT',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d57279-36cd-11f0-80c3-6e593baabd40','user : DELETE/compute/server/acgs/in-bound','user : DELETE/compute/server/acgs/in-bound','/compute/server/acgs/in-bound','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d59d6e-36cd-11f0-80c3-6e593baabd40','테넌트 리스트 조회','테넌트 리스트 조회','/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','tenants','tenant','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d5c8b4-36cd-11f0-80c3-6e593baabd40','테넌트 생성','테넌트 생성','/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','tenants','tenant','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d5f243-36cd-11f0-80c3-6e593baabd40','테넌트 삭제','테넌트 삭제','/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','tenants','tenant','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d61b2c-36cd-11f0-80c3-6e593baabd40','테넌트 리스트 조회','테넌트 리스트 조회','/tenants/servers','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','tenants','tenant server','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d63ffe-36cd-11f0-80c3-6e593baabd40','테넌트 생성','테넌트 생성','/tenants/servers','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','tenants','tenant server','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d6654f-36cd-11f0-80c3-6e593baabd40','테넌트 생성','테넌트 생성','/tenants/servers','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','tenants','tenant server','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d683c2-36cd-11f0-80c3-6e593baabd40','타겟 그룹 생성','타겟 그룹 생성','/target-group/create/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','loadbalancer','targetgroup','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d6a5fe-36cd-11f0-80c3-6e593baabd40','타겟 그룹에 적용될 타겟을 추가','타겟 그룹에 적용될 타겟을 추가','/target-group/create/target/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','loadbalancer','target','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d6cd6e-36cd-11f0-80c3-6e593baabd40','user : POST/storage/objectstorage/{bucketNo}/tenants','user : POST/storage/objectstorage/{bucketNo}/tenants','/storage/objectstorage/{bucketNo}/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('41d7157a-36cd-11f0-80c3-6e593baabd40','user : DELETE/storage/objectstorage/{bucketNo}/tenants','user : DELETE/storage/objectstorage/{bucketNo}/tenants','/storage/objectstorage/{bucketNo}/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d73d78-36cd-11f0-80c3-6e593baabd40','user : POST/storage/objectstorage/buckets/{bucketName}/complete','user : POST/storage/objectstorage/buckets/{bucketName}/complete','/storage/objectstorage/buckets/{bucketName}/complete','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d7674f-36cd-11f0-80c3-6e593baabd40','InitiateMultiPartUpload','InitiateMultiPartUpload','/storage/objectstorage/buckets/upload','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d790f9-36cd-11f0-80c3-6e593baabd40','user : GET/service-objects','user : GET/service-objects','/service-objects','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','service object','service object','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d7d7af-36cd-11f0-80c3-6e593baabd40','user : POST/service-objects','user : POST/service-objects','/service-objects','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','service object','service object','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d7ff4e-36cd-11f0-80c3-6e593baabd40','서버 top 조회','서버 top 조회','/servers/top','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','cloud insight','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d82b81-36cd-11f0-80c3-6e593baabd40','user : POST/servers/top/data-multiple','user : POST/servers/top/data-multiple','/servers/top/data-multiple','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','cloud insight','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d85b6b-36cd-11f0-80c3-6e593baabd40','user : POST/servers/get-metric-top-chart-data','user : POST/servers/get-metric-top-chart-data','/servers/get-metric-top-chart-data','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','cloud insight','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d8843f-36cd-11f0-80c3-6e593baabd40','user : POST/provider/check','user : POST/provider/check','/provider/check','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','provider','provider','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d8dfa8-36cd-11f0-80c3-6e593baabd40','','','/price/month','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','billing','month','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',1)
    ,   ('41d90e4d-36cd-11f0-80c3-6e593baabd40','user : GET/network/vpcs','user : GET/network/vpcs','/network/vpcs','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','vpc','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d93f21-36cd-11f0-80c3-6e593baabd40','vpc 생성','vpc 생성','/network/vpcs','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','vpc','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d96bdb-36cd-11f0-80c3-6e593baabd40','vpc에 테넌트 할당','vpc에 테넌트 할당','/network/vpcs/{vpcNo}/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','vpc','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d998e2-36cd-11f0-80c3-6e593baabd40','user : DELETE/network/vpcs/{vpcNo}/tenants','user : DELETE/network/vpcs/{vpcNo}/tenants','/network/vpcs/{vpcNo}/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','vpc','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d9c3b3-36cd-11f0-80c3-6e593baabd40','subnet 목록 조회','subnet 목록 조회','/network/subnets','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','subnet','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41d9f3d4-36cd-11f0-80c3-6e593baabd40','subnet 생성','subnet 생성','/network/subnets','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','subnet','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41da1a52-36cd-11f0-80c3-6e593baabd40','user : POST/network/subnets/{subnetNo}/tenants','user : POST/network/subnets/{subnetNo}/tenants','/network/subnets/{subnetNo}/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','subnet','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41da401e-36cd-11f0-80c3-6e593baabd40','user : DELETE/network/subnets/{subnetNo}/tenants','user : DELETE/network/subnets/{subnetNo}/tenants','/network/subnets/{subnetNo}/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','subnet','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41da6fdb-36cd-11f0-80c3-6e593baabd40','route Table subnet 추가','route Table subnet 추가','/network/routeTables/route-table-subnet','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','routetable','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41da9a85-36cd-11f0-80c3-6e593baabd40','route Table subnet 삭제','route Table subnet 삭제','/network/routeTables/route-table-subnet','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','routetable','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('41dac238-36cd-11f0-80c3-6e593baabd40','route Table route 추가','route Table route 추가','/network/routeTables/route-table-route','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','routetable','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41dae7de-36cd-11f0-80c3-6e593baabd40','route Table route 삭제','route Table route 삭제','/network/routeTables/route-table-route','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','routetable','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41db1322-36cd-11f0-80c3-6e593baabd40','route Table route 관리','route Table route 관리','/network/routeTables/route-table-route/manage','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','routetable','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41db3685-36cd-11f0-80c3-6e593baabd40','natGateWayList 조회','natGateWayList 조회','/network/nat-gateways','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','nat gateway','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41db6c7f-36cd-11f0-80c3-6e593baabd40','natGateway 생성','natGateway 생성','/network/nat-gateways','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','nat gateway','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41db9917-36cd-11f0-80c3-6e593baabd40','Network ACL 목록 조회','Network ACL 목록 조회','/network/acls','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network network acl','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41dbda9a-36cd-11f0-80c3-6e593baabd40','Network ACL 생성','Network ACL 생성','/network/acls','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network acl','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41dbfee2-36cd-11f0-80c3-6e593baabd40','Network ACL Deny Allow Group 목록 조회','Network ACL Deny Allow Group 목록 조회','/network/acls/deny-allow-groups','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network network acl','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41dc22b5-36cd-11f0-80c3-6e593baabd40','Network ACL Deny Allow Group 생성','Network ACL Deny Allow Group 생성','/network/acls/deny-allow-groups','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network acl','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41dc43b0-36cd-11f0-80c3-6e593baabd40','Network ACL Deny Allow Group 삭제','Network ACL Deny Allow Group 삭제','/network/acls/deny-allow-groups','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network acl','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41dc660e-36cd-11f0-80c3-6e593baabd40','로그 조회','로그 조회','/management/log/logs','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','log analytics','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41dc9dbe-36cd-11f0-80c3-6e593baabd40','로그인키 조회','로그인키 조회','/loginKey','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','login key','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41dcc1aa-36cd-11f0-80c3-6e593baabd40','로그인 인증키 생성','로그인 인증키 생성','/loginKey','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','login key','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41dd102c-36cd-11f0-80c3-6e593baabd40','로그인 인증키 삭제','로그인 인증키 삭제','/loginKey','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','login key','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41dd9e7a-36cd-11f0-80c3-6e593baabd40','인증키 기반 Root Password 조회','인증키 기반 Root Password 조회','/loginKey/rootPassword','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','login key','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ddd55e-36cd-11f0-80c3-6e593baabd40','user : GET/compute/server/storages','user : GET/compute/server/storages','/compute/server/storages','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41de0479-36cd-11f0-80c3-6e593baabd40','ServerStorage 생성','ServerStorage 생성','/compute/server/storages','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41de32ef-36cd-11f0-80c3-6e593baabd40','서버스토리지 테넌트에 할당','서버스토리지 테넌트에 할당','/compute/server/storages/{storageNo}/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41de6b0e-36cd-11f0-80c3-6e593baabd40','서버스토리지 테넌트에 할당해제','서버스토리지 테넌트에 할당해제','/compute/server/storages/{storageNo}/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41de9112-36cd-11f0-80c3-6e593baabd40','ServerStorage 볼륨 변경','ServerStorage 볼륨 변경','/compute/server/storages/volume-size','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('41deb3a3-36cd-11f0-80c3-6e593baabd40','ServerStorage 연결해제','ServerStorage 연결해제','/compute/server/storages/detach','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ded316-36cd-11f0-80c3-6e593baabd40','ServerStorage 연결','ServerStorage 연결','/compute/server/storages/attach','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41def512-36cd-11f0-80c3-6e593baabd40','SnapShot 목록 조회','SnapShot 목록 조회','/compute/server/snapshots','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','snapshot','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41df15e3-36cd-11f0-80c3-6e593baabd40','블록 스토리지 스냅샷 생성','블록 스토리지 스냅샷 생성','/compute/server/snapshots','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','snapshot','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41df417f-36cd-11f0-80c3-6e593baabd40','블록 스토리지 스냅샷 삭제','블록 스토리지 스냅샷 삭제','/compute/server/snapshots','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','snapshot','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41df6ad1-36cd-11f0-80c3-6e593baabd40','서버 리스트 조회','서버 리스트 조회','/compute/server/servers','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41df9a83-36cd-11f0-80c3-6e593baabd40','서버 생성','서버 생성','/compute/server/servers','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41dfbf2f-36cd-11f0-80c3-6e593baabd40','서버 테넌트에 할당','서버 테넌트에 할당','/compute/server/servers/{serverNo}/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41dfe325-36cd-11f0-80c3-6e593baabd40','서버 테넌트에 할당해제','서버 테넌트에 할당해제','/compute/server/servers/{serverNo}/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e010a1-36cd-11f0-80c3-6e593baabd40','서버 테넌트에 할당','서버 테넌트에 할당','/compute/server/servers/{serverNo}/tenants2','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e03351-36cd-11f0-80c3-6e593baabd40','서버 스펙 변경','서버 스펙 변경','/compute/server/servers/{serverNo}/server-spec','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e0609c-36cd-11f0-80c3-6e593baabd40','서버 스펙 변경','서버 스펙 변경','/compute/server/servers/{serverNo}/protect','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e08f55-36cd-11f0-80c3-6e593baabd40','publicIp 생성','publicIp 생성','/compute/server/public-ip/public-ips','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','public ip','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e0b36c-36cd-11f0-80c3-6e593baabd40','서버 네트워크 인터페이스 조회','서버 네트워크 인터페이스 조회','/compute/server/network-interface','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e0dfc3-36cd-11f0-80c3-6e593baabd40','nic 생성','nic 생성','/compute/server/network-interface','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e103a0-36cd-11f0-80c3-6e593baabd40','서버 네트워크 인터페이스에 속한 flow-log 조회','서버 네트워크 인터페이스에 속한 flow-log 조회','/compute/server/network-interface/{networkInterfaceNo}/flow-log','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e126b7-36cd-11f0-80c3-6e593baabd40','서버 네트워크 인터페이스에 속한 flow-log 생성 및 수정','서버 네트워크 인터페이스에 속한 flow-log 생성 및 수정','/compute/server/network-interface/{networkInterfaceNo}/flow-log','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e167b9-36cd-11f0-80c3-6e593baabd40','서버 네트워크 인터페이스에 속한 flow-log 삭제','서버 네트워크 인터페이스에 속한 flow-log 삭제','/compute/server/network-interface/{networkInterfaceNo}/flow-log','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e19b52-36cd-11f0-80c3-6e593baabd40','initScript 목록 조회','initScript 목록 조회','/compute/server/init-script','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','init script','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e1c5c9-36cd-11f0-80c3-6e593baabd40','initScript 생성','initScript 생성','/compute/server/init-script','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','init script','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('41e1e8ef-36cd-11f0-80c3-6e593baabd40','initScript 삭제','initScript 삭제','/compute/server/init-script','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','init script','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e20ce3-36cd-11f0-80c3-6e593baabd40','AccessControlGroup 목록 조회','AccessControlGroup 목록 조회','/compute/server/acgs','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e230fd-36cd-11f0-80c3-6e593baabd40','AccessControlGroup 생성','AccessControlGroup 생성','/compute/server/acgs','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e24f23-36cd-11f0-80c3-6e593baabd40','ServerImage 생성','ServerImage 생성','/compute/server-image','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server image','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e26fc7-36cd-11f0-80c3-6e593baabd40','ServerImage 유저의 공유 권한 생성','ServerImage 유저의 공유 권한 생성','/compute/server-image/sharing-permission','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server image','POST',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e28f2a-36cd-11f0-80c3-6e593baabd40','ServerImage 유저의 공유 권한 삭제','ServerImage 유저의 공유 권한 삭제','/compute/server-image/sharing-permission','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server image','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e2b84b-36cd-11f0-80c3-6e593baabd40','타겟 그룹 생성','타겟 그룹 생성','/target-group/update/health-check/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','loadbalancer','targetgroup','PATCH',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e2dacb-36cd-11f0-80c3-6e593baabd40','타겟 그룹의 설명을 수정','타겟 그룹의 설명을 수정','/target-group/update/description/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','loadbalancer','target','PATCH',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e2fdb5-36cd-11f0-80c3-6e593baabd40','user : GET/tenants/validation','user : GET/tenants/validation','/tenants/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','tenants','tenant','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e32608-36cd-11f0-80c3-6e593baabd40','user : GET/tenants/un-allocate','user : GET/tenants/un-allocate','/tenants/un-allocate','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','tenants','tenant','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e350be-36cd-11f0-80c3-6e593baabd40','테넌트 리스트 조회','테넌트 리스트 조회','/tenants/temp','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','tenants','tenant','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e37063-36cd-11f0-80c3-6e593baabd40','타겟 그룹 리스트 조회','타겟 그룹 리스트 조회','/target-group/select/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','loadbalancer','targetgroup','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e396a9-36cd-11f0-80c3-6e593baabd40','타겟 그룹의 생성이 가능한 Vpc List 조회','타겟 그룹의 생성이 가능한 Vpc List 조회','/target-group/select/vpc/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','loadbalancer','target','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e3b5aa-36cd-11f0-80c3-6e593baabd40','타겟 그룹에 적용된 타겟 리스트를 조회','타겟 그룹에 적용된 타겟 리스트를 조회','/target-group/select/target/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','loadbalancer','target','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e3e7bd-36cd-11f0-80c3-6e593baabd40','타겟 그룹 디테일 조회','타겟 그룹 디테일 조회','/target-group/select/detail/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','loadbalancer','targetgroup','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e40b22-36cd-11f0-80c3-6e593baabd40','flowLog 생성시 버킷 조회','flowLog 생성시 버킷 조회','/storage/objectstorage/flow-log/buckets','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e4686c-36cd-11f0-80c3-6e593baabd40','bucket validation','bucket validation','/storage/objectstorage/buckets/{bucketName}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e4986a-36cd-11f0-80c3-6e593baabd40','버킷 삭제','버킷 삭제','/storage/objectstorage/buckets/{bucketName}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e4c102-36cd-11f0-80c3-6e593baabd40','downloadObject','downloadObject','/storage/objectstorage/buckets/{bucketName}/object','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e4e741-36cd-11f0-80c3-6e593baabd40','ListMultipartUploads','ListMultipartUploads','/storage/objectstorage/buckets/{bucketName}/multi-part','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('41e51bec-36cd-11f0-80c3-6e593baabd40','ListParts','ListParts','/storage/objectstorage/buckets/{bucketName}/list-part','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e5799d-36cd-11f0-80c3-6e593baabd40','user : GET/storage/objectstorage/buckets/{bucketName}/folders','user : GET/storage/objectstorage/buckets/{bucketName}/folders','/storage/objectstorage/buckets/{bucketName}/folders','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e5ab8b-36cd-11f0-80c3-6e593baabd40','folder validation','folder validation','/storage/objectstorage/buckets/{bucketName}/folder/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e5cd42-36cd-11f0-80c3-6e593baabd40','bucket validation','bucket validation','/storage/objectstorage/buckets/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e5ea21-36cd-11f0-80c3-6e593baabd40','user : GET/storage/objectstorage/acl/buckets/{bucketName}','user : GET/storage/objectstorage/acl/buckets/{bucketName}','/storage/objectstorage/acl/buckets/{bucketName}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e6060a-36cd-11f0-80c3-6e593baabd40','user : GET/servers/metrics/{prodKey}','user : GET/servers/metrics/{prodKey}','/servers/metrics/{prodKey}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','cloud insight','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e626ef-36cd-11f0-80c3-6e593baabd40','region 리스트 조회','region 리스트 조회','/regions','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','region','region','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e64d6b-36cd-11f0-80c3-6e593baabd40','zone 리스트 조회','zone 리스트 조회','/regions/zones','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','region','region','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e67533-36cd-11f0-80c3-6e593baabd40','user : GET/provider','user : GET/provider','/provider','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','provider','provider','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e6a15c-36cd-11f0-80c3-6e593baabd40','user : GET/provider/{providerId}','user : GET/provider/{providerId}','/provider/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','provider','provider','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e6c46f-36cd-11f0-80c3-6e593baabd40','provider에 속해있는 테넌트에 전체의 대한 현황 정보','provider에 속해있는 테넌트에 전체의 대한 현황 정보','/provider/tenants/info','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','provider','provider','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e6e70e-36cd-11f0-80c3-6e593baabd40','user : GET/network/vpcs/{vpcNo}','user : GET/network/vpcs/{vpcNo}','/network/vpcs/{vpcNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','vpc','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e70c61-36cd-11f0-80c3-6e593baabd40','vpc 삭제','vpc 삭제','/network/vpcs/{vpcNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','vpc','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e72c9c-36cd-11f0-80c3-6e593baabd40','VPC 이름 중복 확인','VPC 이름 중복 확인','/network/vpcs/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','vpc','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e7494b-36cd-11f0-80c3-6e593baabd40','subnet detail','subnet detail','/network/subnets/{subnetNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','subnet','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e76923-36cd-11f0-80c3-6e593baabd40','subnet validation','subnet validation','/network/subnets/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','subnet','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e78875-36cd-11f0-80c3-6e593baabd40','Subnet 이름 중복 확인','Subnet 이름 중복 확인','/network/subnets/validation/{subnetName}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','subnet','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e7ac08-36cd-11f0-80c3-6e593baabd40','subnet 목록 nic Count 포함  조회','subnet 목록 nic Count 포함  조회','/network/subnets/subnet-provisioning','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','subnet','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e7cc3f-36cd-11f0-80c3-6e593baabd40','route table detail','route table detail','/network/routeTables/{routeTableNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','route table','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e7f0cf-36cd-11f0-80c3-6e593baabd40','Route Table 삭제','Route Table 삭제','/network/routeTables/{routeTableNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','routetable','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('41e8279e-36cd-11f0-80c3-6e593baabd40','route table validation','route table validation','/network/routeTables/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','route table','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e84ef0-36cd-11f0-80c3-6e593baabd40','route table detail - subnet List','route table detail - subnet List','/network/routeTables/subnets/{routeTableNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','route table','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e87f5a-36cd-11f0-80c3-6e593baabd40','route table detail - subnet List','route table detail - subnet List','/network/routeTables/routes/{routeTableNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','route table','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e8ef09-36cd-11f0-80c3-6e593baabd40','user : GET/network/nat-gateways/{natGatewayInstanceNo}','user : GET/network/nat-gateways/{natGatewayInstanceNo}','/network/nat-gateways/{natGatewayInstanceNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','nat gateway','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e91cc7-36cd-11f0-80c3-6e593baabd40','natGateway 삭제','natGateway 삭제','/network/nat-gateways/{natGatewayInstanceNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','nat gateway','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e940e3-36cd-11f0-80c3-6e593baabd40','NatGateWay 이름 중복 확인','NatGateWay 이름 중복 확인','/network/nat-gateways/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','nat gateway','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e9663e-36cd-11f0-80c3-6e593baabd40','subnet 목록 조회','subnet 목록 조회','/network/load-balancer','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','subnet','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e98bf7-36cd-11f0-80c3-6e593baabd40','Network ACL 상세 조회','Network ACL 상세 조회','/network/acls/{networkAclNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network network acl','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e9b2b7-36cd-11f0-80c3-6e593baabd40','Network ACL 삭제','Network ACL 삭제','/network/acls/{networkAclNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network acl','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e9d37e-36cd-11f0-80c3-6e593baabd40','Network ACL 중복 체크','Network ACL 중복 체크','/network/acls/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network network acl','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41e9fb54-36cd-11f0-80c3-6e593baabd40','Network ACL 규칙 목록 조회','Network ACL 규칙 목록 조회','/network/acls/rules','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network network acl','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ea2292-36cd-11f0-80c3-6e593baabd40','Network ACL 규칙 우선 순위 중복 체크','Network ACL 규칙 우선 순위 중복 체크','/network/acls/rules/validate','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network network acl','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ea476c-36cd-11f0-80c3-6e593baabd40','Deny-Allow Group 상세 정보 - 기본 정보 조회','Deny-Allow Group 상세 정보 - 기본 정보 조회','/network/acls/deny-allow-groups/{networkAclDenyAllowGroupNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network network acl','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ea7380-36cd-11f0-80c3-6e593baabd40','Deny-Allow Group 상세 정보 -  NetworkAcl 조회','Deny-Allow Group 상세 정보 -  NetworkAcl 조회','/network/acls/deny-allow-groups/{networkAclDenyAllowGroupNo}/network-acl','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network network acl','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ea9948-36cd-11f0-80c3-6e593baabd40','Deny-Allow Group 상세 정보 -  IP 조회','Deny-Allow Group 상세 정보 -  IP 조회','/network/acls/deny-allow-groups/{networkAclDenyAllowGroupNo}/ip','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network network acl','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41eac1e1-36cd-11f0-80c3-6e593baabd40','Deny-Allow Group 중복 체크','Deny-Allow Group 중복 체크','/network/acls/deny-allow-groups/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network network acl','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41eae734-36cd-11f0-80c3-6e593baabd40','인증키 이름 중복 확인','인증키 이름 중복 확인','/loginKey/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','login key','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41eb05cb-36cd-11f0-80c3-6e593baabd40','인증키 목록 조회','인증키 목록 조회','/loginKey/list','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','login key','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41eb2682-36cd-11f0-80c3-6e593baabd40','대시보드 서비스 이용 내용','대시보드 서비스 이용 내용','/dashboard/service-usage-info','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','dashboard','dashboard','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41eb6023-36cd-11f0-80c3-6e593baabd40','user : GET/compute/server/storages/{storageNo}','user : GET/compute/server/storages/{storageNo}','/compute/server/storages/{storageNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('41eb97e7-36cd-11f0-80c3-6e593baabd40','server-storage validation','server-storage validation','/compute/server/storages/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ebbbc8-36cd-11f0-80c3-6e593baabd40','스토리지 생성시 서버 목록 조회','스토리지 생성시 서버 목록 조회','/compute/server/storages/servers','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ebe113-36cd-11f0-80c3-6e593baabd40','스토리지 서버연결시  서버 목록 조회','스토리지 서버연결시  서버 목록 조회','/compute/server/storages/servers/attach-storage','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ec0ef6-36cd-11f0-80c3-6e593baabd40','SnapShot Detail 조회','SnapShot Detail 조회','/compute/server/snapshots/{blockStorageSnapshotInstanceNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','snapshot','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ec3a63-36cd-11f0-80c3-6e593baabd40','SnapShot 이름 중복 확인','SnapShot 이름 중복 확인','/compute/server/snapshots/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','snapshot','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ec5bc5-36cd-11f0-80c3-6e593baabd40','서버 상세 조회','서버 상세 조회','/compute/server/servers/{serverNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ec7bf0-36cd-11f0-80c3-6e593baabd40','server validation','server validation','/compute/server/servers/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ecab8e-36cd-11f0-80c3-6e593baabd40','server-spec 리스트 조회','server-spec 리스트 조회','/compute/server/servers/server-spec','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ecd4f6-36cd-11f0-80c3-6e593baabd40','user : GET/compute/server/servers/detail/network-interface','user : GET/compute/server/servers/detail/network-interface','/compute/server/servers/detail/network-interface','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ecf71c-36cd-11f0-80c3-6e593baabd40','서버 네트워크 인터페이스 조회','서버 네트워크 인터페이스 조회','/compute/server/servers/create/network-interface','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ed1ac0-36cd-11f0-80c3-6e593baabd40','user : GET/compute/server/serverImages','user : GET/compute/server/serverImages','/compute/server/serverImages','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server image','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ed4473-36cd-11f0-80c3-6e593baabd40','서버이미지 상세 조회','서버이미지 상세 조회','/compute/server/serverImages/{serverImageNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server image','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ed6b5c-36cd-11f0-80c3-6e593baabd40','내 server 이미지 삭제','내 server 이미지 삭제','/compute/server/serverImages/{serverImageNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ed9028-36cd-11f0-80c3-6e593baabd40','user : GET/compute/server/serverImageProducts','user : GET/compute/server/serverImageProducts','/compute/server/serverImageProducts','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server image','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41edb4f0-36cd-11f0-80c3-6e593baabd40','user : GET/compute/server/serverImageProducts/{serverImageProductCode}/serverProducts','user : GET/compute/server/serverImageProducts/{serverImageProductCode}/serverProducts','/compute/server/serverImageProducts/{serverImageProductCode}/serverProducts','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41edd373-36cd-11f0-80c3-6e593baabd40','Server-Image 이름 중복 확인','Server-Image 이름 중복 확인','/compute/server/server-image/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server image','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41edff89-36cd-11f0-80c3-6e593baabd40','user : GET/compute/server/network-interface/{networkInterfaceNo}','user : GET/compute/server/network-interface/{networkInterfaceNo}','/compute/server/network-interface/{networkInterfaceNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ee2b4c-36cd-11f0-80c3-6e593baabd40','user : DELETE/compute/server/network-interface/{networkInterfaceNo}','user : DELETE/compute/server/network-interface/{networkInterfaceNo}','/compute/server/network-interface/{networkInterfaceNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ee4d96-36cd-11f0-80c3-6e593baabd40','network interface 서버 연결 가능한 목록 출력','network interface 서버 연결 가능한 목록 출력','/compute/server/network-interface/{networkInterfaceNo}/servers','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ee7037-36cd-11f0-80c3-6e593baabd40','서버 네트워크 인터페이스에 속한 Acg 리스트 조회','서버 네트워크 인터페이스에 속한 Acg 리스트 조회','/compute/server/network-interface/{networkInterfaceNo}/available-acg','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('41eea2af-36cd-11f0-80c3-6e593baabd40','NIC 이름 중복 확인','NIC 이름 중복 확인','/compute/server/network-interface/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41eed05a-36cd-11f0-80c3-6e593baabd40','IP 중복 체크용','IP 중복 체크용','/compute/server/network-interface/ips','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ef13f1-36cd-11f0-80c3-6e593baabd40','NIC 내의 ACG 조회','NIC 내의 ACG 조회','/compute/server/network-interface/acgs/{acgNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ef3f6c-36cd-11f0-80c3-6e593baabd40','NIC 내의 ACG에서 ACG 룰 조회','NIC 내의 ACG에서 ACG 룰 조회','/compute/server/network-interface/acgs/{acgNo}/rules','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ef61c9-36cd-11f0-80c3-6e593baabd40','user : GET/compute/server/init-script/{initScriptNo}','user : GET/compute/server/init-script/{initScriptNo}','/compute/server/init-script/{initScriptNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','init script','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ef802d-36cd-11f0-80c3-6e593baabd40','initScript 이름 중복 확인','initScript 이름 중복 확인','/compute/server/init-script/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','init script','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41ef9e12-36cd-11f0-80c3-6e593baabd40','all server-image list 조회','all server-image list 조회','/compute/server/all-image-product','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server image','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41efc19a-36cd-11f0-80c3-6e593baabd40','user : GET/compute/server/acgs/{acgNo}/rules','user : GET/compute/server/acgs/{acgNo}/rules','/compute/server/acgs/{acgNo}/rules','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41efe12a-36cd-11f0-80c3-6e593baabd40','user : GET/compute/server/acgs/{accessControlGroupNo}','user : GET/compute/server/acgs/{accessControlGroupNo}','/compute/server/acgs/{accessControlGroupNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f0065a-36cd-11f0-80c3-6e593baabd40','AccessControlGroup 삭제','AccessControlGroup 삭제','/compute/server/acgs/{accessControlGroupNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f02578-36cd-11f0-80c3-6e593baabd40','NIC 내의 ACG에서 ACG 룰 조회','NIC 내의 ACG에서 ACG 룰 조회','/compute/server/acgs/vpcs/{vpcNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f042bb-36cd-11f0-80c3-6e593baabd40','Network ACG 이름 중복 확인','Network ACG 이름 중복 확인','/compute/server/acgs/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f06577-36cd-11f0-80c3-6e593baabd40','user : GET/compute/server-image/test','user : GET/compute/server-image/test','/compute/server-image/test','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server image','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f08a40-36cd-11f0-80c3-6e593baabd40','user : GET/compute/public-ip','user : GET/compute/public-ip','/compute/public-ip','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','public ip','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f0ab4e-36cd-11f0-80c3-6e593baabd40','publicIp 상세 조회','publicIp 상세 조회','/compute/public-ip/{publicIpInstanceNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','public ip','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f0c859-36cd-11f0-80c3-6e593baabd40','publicIp 생성시 서버 목록 조회','publicIp 생성시 서버 목록 조회','/compute/public-ip/servers','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','public ip','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f0f391-36cd-11f0-80c3-6e593baabd40','user : GET/billing/test','user : GET/billing/test','/billing/test','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','resource','billing','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f12b6a-36cd-11f0-80c3-6e593baabd40','ProductPrice 조회','ProductPrice 조회','/billing/product-prices','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','resource','billing','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f14bea-36cd-11f0-80c3-6e593baabd40','user : GET/billing/product-costs-mock','user : GET/billing/product-costs-mock','/billing/product-costs-mock','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','resource','billing','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f1672e-36cd-11f0-80c3-6e593baabd40','ProductDemandCostList 조회','ProductDemandCostList 조회','/billing/product-costs-by-month','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','resource','billing','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('41f182ef-36cd-11f0-80c3-6e593baabd40','user : GET/billing/prices','user : GET/billing/prices','/billing/prices','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','resource','billing','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f1b3bc-36cd-11f0-80c3-6e593baabd40','월 별 상품 사용량 조회','월 별 상품 사용량 조회','/billing/monthly-use','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','resource','billing','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f1d75f-36cd-11f0-80c3-6e593baabd40','user : GET/billing/demand-costs','user : GET/billing/demand-costs','/billing/demand-costs','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','resource','billing','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f1fc1f-36cd-11f0-80c3-6e593baabd40','CostAndUseAge 조회','CostAndUseAge 조회','/billing/daily-use','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','resource','billing','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f22181-36cd-11f0-80c3-6e593baabd40','user : GET/billing/contract-summaries','user : GET/billing/contract-summaries','/billing/contract-summaries','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','resource','billing','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f24d9a-36cd-11f0-80c3-6e593baabd40','user : GET/billing/contract-demand-costs','user : GET/billing/contract-demand-costs','/billing/contract-demand-costs','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','resource','billing','GET',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f272ef-36cd-11f0-80c3-6e593baabd40','타겟 그룹 삭제','타겟 그룹 삭제','/target-group/delete/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','loadbalancer','targetgroup','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f29484-36cd-11f0-80c3-6e593baabd40','타겟 그룹에 적용된 타겟을 제거','타겟 그룹에 적용된 타겟을 제거','/target-group/delete/target/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','loadbalancer','target','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f2afd0-36cd-11f0-80c3-6e593baabd40','오브젝트 삭제','오브젝트 삭제','/storage/objectstorage/buckets/{bucketName}/objects','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f2e2e8-36cd-11f0-80c3-6e593baabd40','user : DELETE/storage/objectstorage/buckets/{bucketName}/multiObject','user : DELETE/storage/objectstorage/buckets/{bucketName}/multiObject','/storage/objectstorage/buckets/{bucketName}/multiObject','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f30375-36cd-11f0-80c3-6e593baabd40','AbortMultipartUpload','AbortMultipartUpload','/storage/objectstorage/buckets/{bucketName}/abort-upload','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f322ac-36cd-11f0-80c3-6e593baabd40','subnet 삭제','subnet 삭제','/network/subnets/{subnetId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','subnet','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f34148-36cd-11f0-80c3-6e593baabd40','ServerStorage 삭제','ServerStorage 삭제','/compute/server/storages/{serverStorageNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f35ef4-36cd-11f0-80c3-6e593baabd40','user : DELETE/compute/server/public-ip/{publicIpInstanceNo}','user : DELETE/compute/server/public-ip/{publicIpInstanceNo}','/compute/server/public-ip/{publicIpInstanceNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','public ip','DELETE',1,'1f062c92-1678-11ef-922c-16fe18334070',0)
    ,   ('41f383e4-36cd-11f0-80c3-6e593baabd40','테넌트 상세 조회','테넌트 상세 조회','/tenants/{tenantId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','tenants','tenant','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f3a1af-36cd-11f0-80c3-6e593baabd40','admin : PUT/tenants/{tenantId}','admin : PUT/tenants/{tenantId}','/tenants/{tenantId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','tenants','tenant','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f3bc5f-36cd-11f0-80c3-6e593baabd40','타겟 그룹 생성','타겟 그룹 생성','/target-group/update/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','loadbalancer','targetgroup','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f3db89-36cd-11f0-80c3-6e593baabd40','타겟 그룹에 적용될 타겟을 설정','타겟 그룹에 적용될 타겟을 설정','/target-group/update/target/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','loadbalancer','target','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f3fabf-36cd-11f0-80c3-6e593baabd40','copyObject','copyObject','/storage/objectstorage/buckets/{bucketName}/copyObject','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f419e7-36cd-11f0-80c3-6e593baabd40','admin : PUT/storage/objectstorage/buckets/parts','admin : PUT/storage/objectstorage/buckets/parts','/storage/objectstorage/buckets/parts','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('41f43758-36cd-11f0-80c3-6e593baabd40','putFolder','putFolder','/storage/objectstorage/buckets/folder','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f45950-36cd-11f0-80c3-6e593baabd40','대시보드 버킷 조회 및 버킷 조회','대시보드 버킷 조회 및 버킷 조회','/storage/objectstorage/buckets','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f479e2-36cd-11f0-80c3-6e593baabd40','putObject','putObject','/storage/objectstorage/buckets','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f49c64-36cd-11f0-80c3-6e593baabd40','bucket 생성','bucket 생성','/storage/objectstorage/buckets','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f4c0dc-36cd-11f0-80c3-6e593baabd40','subnet networkACL 수정','subnet networkACL 수정','/network/subnets/{subnetId}/{aclId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','subnet','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f4e9f5-36cd-11f0-80c3-6e593baabd40','route table list','route table list','/network/routeTables','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','route table','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f50d56-36cd-11f0-80c3-6e593baabd40','route Table 메모 수정','route Table 메모 수정','/network/routeTables','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','routetable','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f53205-36cd-11f0-80c3-6e593baabd40','route Table 생성','route Table 생성','/network/routeTables','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','routetable','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f55480-36cd-11f0-80c3-6e593baabd40','natGatewayDescription 수정','natGatewayDescription 수정','/network/nat-gateways/description','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','nat gateway','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f5709d-36cd-11f0-80c3-6e593baabd40','Network ACL Outbound 규칙 추가','Network ACL Outbound 규칙 추가','/network/acls/rules/outbounds','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network acl','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f59a43-36cd-11f0-80c3-6e593baabd40','Network ACL Outbound 규칙 제거','Network ACL Outbound 규칙 제거','/network/acls/rules/outbounds','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network acl','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f60006-36cd-11f0-80c3-6e593baabd40','Network ACL Inbound 규칙 추가','Network ACL Inbound 규칙 추가','/network/acls/rules/inbounds','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network acl','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f62356-36cd-11f0-80c3-6e593baabd40','Network ACL Inbound 규칙 제거','Network ACL Inbound 규칙 제거','/network/acls/rules/inbounds','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network acl','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f648cb-36cd-11f0-80c3-6e593baabd40','Network ACL 설명(메모) 수정','Network ACL 설명(메모) 수정','/network/acls/description','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network acl','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f66fa3-36cd-11f0-80c3-6e593baabd40','Network ACL Deny Allow IP 설정','Network ACL Deny Allow IP 설정','/network/acls/deny-allow-groups/ip','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network acl','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f6966d-36cd-11f0-80c3-6e593baabd40','Network ACL Deny Allow Group 메모 변경','Network ACL Deny Allow Group 메모 변경','/network/acls/deny-allow-groups/description','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network acl','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f6bcf8-36cd-11f0-80c3-6e593baabd40','admin : PUT/compute/server/servers/{serverNo}/terminate','admin : PUT/compute/server/servers/{serverNo}/terminate','/compute/server/servers/{serverNo}/terminate','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f6e51e-36cd-11f0-80c3-6e593baabd40','운영중 상태의 Server 정지','운영중 상태의 Server 정지','/compute/server/servers/{serverNo}/stop','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f70bea-36cd-11f0-80c3-6e593baabd40','admin : PUT/compute/server/servers/{serverNo}/start','admin : PUT/compute/server/servers/{serverNo}/start','/compute/server/servers/{serverNo}/start','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f732b0-36cd-11f0-80c3-6e593baabd40','운영중 상태의 Server 재시작','운영중 상태의 Server 재시작','/compute/server/servers/{serverNo}/reboot','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('41f75f6c-36cd-11f0-80c3-6e593baabd40','publicIp 서버인스턴스 할당해제','publicIp 서버인스턴스 할당해제','/compute/server/public-ip/disassociate','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','public ip','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f78049-36cd-11f0-80c3-6e593baabd40','admin : PUT/compute/server/public-ip/associate','admin : PUT/compute/server/public-ip/associate','/compute/server/public-ip/associate','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','public ip','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f7a046-36cd-11f0-80c3-6e593baabd40','NIC 내에서 속한 ACG 리스트 수정','NIC 내에서 속한 ACG 리스트 수정','/compute/server/network-interface/{networkInterfaceNo}/acg','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f7c5b0-36cd-11f0-80c3-6e593baabd40','admin : PUT/compute/server/network-interface/unassign-SecondaryIps','admin : PUT/compute/server/network-interface/unassign-SecondaryIps','/compute/server/network-interface/unassign-SecondaryIps','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f7e35c-36cd-11f0-80c3-6e593baabd40','NIC 서버에서 해제','NIC 서버에서 해제','/compute/server/network-interface/detach-networkInterface','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f806f6-36cd-11f0-80c3-6e593baabd40','NIC 할달','NIC 할달','/compute/server/network-interface/attach-networkInterface','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f8290e-36cd-11f0-80c3-6e593baabd40','admin : PUT/compute/server/network-interface/assign-secondaryIps','admin : PUT/compute/server/network-interface/assign-secondaryIps','/compute/server/network-interface/assign-secondaryIps','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f84a34-36cd-11f0-80c3-6e593baabd40','admin : PUT/compute/server/acgs/out-bound','admin : PUT/compute/server/acgs/out-bound','/compute/server/acgs/out-bound','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f87610-36cd-11f0-80c3-6e593baabd40','admin : DELETE/compute/server/acgs/out-bound','admin : DELETE/compute/server/acgs/out-bound','/compute/server/acgs/out-bound','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f89557-36cd-11f0-80c3-6e593baabd40','AccessControlGroup inbound 추가','AccessControlGroup inbound 추가','/compute/server/acgs/in-bound','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','PUT',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f8b6dd-36cd-11f0-80c3-6e593baabd40','admin : DELETE/compute/server/acgs/in-bound','admin : DELETE/compute/server/acgs/in-bound','/compute/server/acgs/in-bound','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f8dc95-36cd-11f0-80c3-6e593baabd40','테넌트 리스트 조회','테넌트 리스트 조회','/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','tenants','tenant','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f8fd98-36cd-11f0-80c3-6e593baabd40','테넌트 생성','테넌트 생성','/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','tenants','tenant','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f923ee-36cd-11f0-80c3-6e593baabd40','테넌트 삭제','테넌트 삭제','/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','tenants','tenant','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f9499a-36cd-11f0-80c3-6e593baabd40','테넌트 리스트 조회','테넌트 리스트 조회','/tenants/servers','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','tenants','tenant server','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f96ba1-36cd-11f0-80c3-6e593baabd40','테넌트 생성','테넌트 생성','/tenants/servers','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','tenants','tenant server','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f98eaf-36cd-11f0-80c3-6e593baabd40','테넌트 생성','테넌트 생성','/tenants/servers','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','tenants','tenant server','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f9afb6-36cd-11f0-80c3-6e593baabd40','타겟 그룹 생성','타겟 그룹 생성','/target-group/create/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','loadbalancer','targetgroup','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f9cbd1-36cd-11f0-80c3-6e593baabd40','타겟 그룹에 적용될 타겟을 추가','타겟 그룹에 적용될 타겟을 추가','/target-group/create/target/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','loadbalancer','target','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41f9e44c-36cd-11f0-80c3-6e593baabd40','admin : POST/storage/objectstorage/{bucketNo}/tenants','admin : POST/storage/objectstorage/{bucketNo}/tenants','/storage/objectstorage/{bucketNo}/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('41fa0856-36cd-11f0-80c3-6e593baabd40','admin : DELETE/storage/objectstorage/{bucketNo}/tenants','admin : DELETE/storage/objectstorage/{bucketNo}/tenants','/storage/objectstorage/{bucketNo}/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41fa28df-36cd-11f0-80c3-6e593baabd40','admin : POST/storage/objectstorage/buckets/{bucketName}/complete','admin : POST/storage/objectstorage/buckets/{bucketName}/complete','/storage/objectstorage/buckets/{bucketName}/complete','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41fa4f52-36cd-11f0-80c3-6e593baabd40','InitiateMultiPartUpload','InitiateMultiPartUpload','/storage/objectstorage/buckets/upload','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41fa9b79-36cd-11f0-80c3-6e593baabd40','admin : GET/service-objects','admin : GET/service-objects','/service-objects','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','service object','service object','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41fac61f-36cd-11f0-80c3-6e593baabd40','admin : POST/service-objects','admin : POST/service-objects','/service-objects','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','service object','service object','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41faf137-36cd-11f0-80c3-6e593baabd40','서버 top 조회','서버 top 조회','/servers/top','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','cloud insight','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41fb2155-36cd-11f0-80c3-6e593baabd40','admin : POST/servers/top/data-multiple','admin : POST/servers/top/data-multiple','/servers/top/data-multiple','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','cloud insight','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41fb40dd-36cd-11f0-80c3-6e593baabd40','admin : POST/servers/get-metric-top-chart-data','admin : POST/servers/get-metric-top-chart-data','/servers/get-metric-top-chart-data','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','cloud insight','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41fb60db-36cd-11f0-80c3-6e593baabd40','admin : POST/provider/check','admin : POST/provider/check','/provider/check','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','provider','provider','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41fb7ff4-36cd-11f0-80c3-6e593baabd40','','','/price/month','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','billing','month','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',1)
    ,   ('41fba803-36cd-11f0-80c3-6e593baabd40','admin : GET/network/vpcs','admin : GET/network/vpcs','/network/vpcs','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','vpc','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41fbc546-36cd-11f0-80c3-6e593baabd40','vpc 생성','vpc 생성','/network/vpcs','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','vpc','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41fbe63f-36cd-11f0-80c3-6e593baabd40','vpc에 테넌트 할당','vpc에 테넌트 할당','/network/vpcs/{vpcNo}/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','vpc','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41fc0921-36cd-11f0-80c3-6e593baabd40','admin : DELETE/network/vpcs/{vpcNo}/tenants','admin : DELETE/network/vpcs/{vpcNo}/tenants','/network/vpcs/{vpcNo}/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','vpc','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41fc2e37-36cd-11f0-80c3-6e593baabd40','subnet 목록 조회','subnet 목록 조회','/network/subnets','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','subnet','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41fc4fa1-36cd-11f0-80c3-6e593baabd40','subnet 생성','subnet 생성','/network/subnets','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','subnet','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41fc7261-36cd-11f0-80c3-6e593baabd40','admin : POST/network/subnets/{subnetNo}/tenants','admin : POST/network/subnets/{subnetNo}/tenants','/network/subnets/{subnetNo}/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','subnet','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41fc8db1-36cd-11f0-80c3-6e593baabd40','admin : DELETE/network/subnets/{subnetNo}/tenants','admin : DELETE/network/subnets/{subnetNo}/tenants','/network/subnets/{subnetNo}/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','subnet','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41fcacb6-36cd-11f0-80c3-6e593baabd40','route Table subnet 추가','route Table subnet 추가','/network/routeTables/route-table-subnet','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','routetable','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41fcca9c-36cd-11f0-80c3-6e593baabd40','route Table subnet 삭제','route Table subnet 삭제','/network/routeTables/route-table-subnet','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','routetable','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('41fcecd5-36cd-11f0-80c3-6e593baabd40','route Table route 추가','route Table route 추가','/network/routeTables/route-table-route','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','routetable','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41fe1ae0-36cd-11f0-80c3-6e593baabd40','route Table route 삭제','route Table route 삭제','/network/routeTables/route-table-route','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','routetable','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41fe454d-36cd-11f0-80c3-6e593baabd40','route Table route 관리','route Table route 관리','/network/routeTables/route-table-route/manage','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','routetable','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41fe6a4f-36cd-11f0-80c3-6e593baabd40','natGateWayList 조회','natGateWayList 조회','/network/nat-gateways','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','nat gateway','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41fe8c73-36cd-11f0-80c3-6e593baabd40','natGateway 생성','natGateway 생성','/network/nat-gateways','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','nat gateway','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41feaaaa-36cd-11f0-80c3-6e593baabd40','Network ACL 목록 조회','Network ACL 목록 조회','/network/acls','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network network acl','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41fecaa5-36cd-11f0-80c3-6e593baabd40','Network ACL 생성','Network ACL 생성','/network/acls','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network acl','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41feea57-36cd-11f0-80c3-6e593baabd40','Network ACL Deny Allow Group 목록 조회','Network ACL Deny Allow Group 목록 조회','/network/acls/deny-allow-groups','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network network acl','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41ff0d3a-36cd-11f0-80c3-6e593baabd40','Network ACL Deny Allow Group 생성','Network ACL Deny Allow Group 생성','/network/acls/deny-allow-groups','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network acl','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41ff2b5b-36cd-11f0-80c3-6e593baabd40','Network ACL Deny Allow Group 삭제','Network ACL Deny Allow Group 삭제','/network/acls/deny-allow-groups','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network acl','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41ff4c1f-36cd-11f0-80c3-6e593baabd40','로그 조회','로그 조회','/management/log/logs','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','log analytics','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41ff6816-36cd-11f0-80c3-6e593baabd40','로그인키 조회','로그인키 조회','/loginKey','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','login key','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41ff8861-36cd-11f0-80c3-6e593baabd40','로그인 인증키 생성','로그인 인증키 생성','/loginKey','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','login key','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41ffa60d-36cd-11f0-80c3-6e593baabd40','로그인 인증키 삭제','로그인 인증키 삭제','/loginKey','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','login key','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41ffc605-36cd-11f0-80c3-6e593baabd40','인증키 기반 Root Password 조회','인증키 기반 Root Password 조회','/loginKey/rootPassword','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','login key','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('41ffe37b-36cd-11f0-80c3-6e593baabd40','admin : GET/compute/server/storages','admin : GET/compute/server/storages','/compute/server/storages','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4200002a-36cd-11f0-80c3-6e593baabd40','ServerStorage 생성','ServerStorage 생성','/compute/server/storages','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4200181f-36cd-11f0-80c3-6e593baabd40','서버스토리지 테넌트에 할당','서버스토리지 테넌트에 할당','/compute/server/storages/{storageNo}/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42004f89-36cd-11f0-80c3-6e593baabd40','서버스토리지 테넌트에 할당해제','서버스토리지 테넌트에 할당해제','/compute/server/storages/{storageNo}/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42007866-36cd-11f0-80c3-6e593baabd40','ServerStorage 볼륨 변경','ServerStorage 볼륨 변경','/compute/server/storages/volume-size','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('420097bf-36cd-11f0-80c3-6e593baabd40','ServerStorage 연결해제','ServerStorage 연결해제','/compute/server/storages/detach','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4200b57e-36cd-11f0-80c3-6e593baabd40','ServerStorage 연결','ServerStorage 연결','/compute/server/storages/attach','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4200d22e-36cd-11f0-80c3-6e593baabd40','SnapShot 목록 조회','SnapShot 목록 조회','/compute/server/snapshots','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','snapshot','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4200f082-36cd-11f0-80c3-6e593baabd40','블록 스토리지 스냅샷 생성','블록 스토리지 스냅샷 생성','/compute/server/snapshots','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','snapshot','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42010baa-36cd-11f0-80c3-6e593baabd40','블록 스토리지 스냅샷 삭제','블록 스토리지 스냅샷 삭제','/compute/server/snapshots','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','snapshot','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42012ad1-36cd-11f0-80c3-6e593baabd40','서버 리스트 조회','서버 리스트 조회','/compute/server/servers','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42014613-36cd-11f0-80c3-6e593baabd40','서버 생성','서버 생성','/compute/server/servers','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42016edd-36cd-11f0-80c3-6e593baabd40','서버 테넌트에 할당','서버 테넌트에 할당','/compute/server/servers/{serverNo}/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4201934a-36cd-11f0-80c3-6e593baabd40','서버 테넌트에 할당해제','서버 테넌트에 할당해제','/compute/server/servers/{serverNo}/tenants','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4201ba1a-36cd-11f0-80c3-6e593baabd40','서버 테넌트에 할당','서버 테넌트에 할당','/compute/server/servers/{serverNo}/tenants2','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4201d8e0-36cd-11f0-80c3-6e593baabd40','서버 스펙 변경','서버 스펙 변경','/compute/server/servers/{serverNo}/server-spec','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4201f94a-36cd-11f0-80c3-6e593baabd40','서버 스펙 변경','서버 스펙 변경','/compute/server/servers/{serverNo}/protect','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42022a7d-36cd-11f0-80c3-6e593baabd40','publicIp 생성','publicIp 생성','/compute/server/public-ip/public-ips','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','public ip','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42024bfc-36cd-11f0-80c3-6e593baabd40','서버 네트워크 인터페이스 조회','서버 네트워크 인터페이스 조회','/compute/server/network-interface','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42026b03-36cd-11f0-80c3-6e593baabd40','nic 생성','nic 생성','/compute/server/network-interface','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42028a05-36cd-11f0-80c3-6e593baabd40','서버 네트워크 인터페이스에 속한 flow-log 조회','서버 네트워크 인터페이스에 속한 flow-log 조회','/compute/server/network-interface/{networkInterfaceNo}/flow-log','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4202ab19-36cd-11f0-80c3-6e593baabd40','서버 네트워크 인터페이스에 속한 flow-log 생성 및 수정','서버 네트워크 인터페이스에 속한 flow-log 생성 및 수정','/compute/server/network-interface/{networkInterfaceNo}/flow-log','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4202d26d-36cd-11f0-80c3-6e593baabd40','서버 네트워크 인터페이스에 속한 flow-log 삭제','서버 네트워크 인터페이스에 속한 flow-log 삭제','/compute/server/network-interface/{networkInterfaceNo}/flow-log','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4202eeb5-36cd-11f0-80c3-6e593baabd40','initScript 목록 조회','initScript 목록 조회','/compute/server/init-script','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','init script','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42030c19-36cd-11f0-80c3-6e593baabd40','initScript 생성','initScript 생성','/compute/server/init-script','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','init script','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('42032d30-36cd-11f0-80c3-6e593baabd40','initScript 삭제','initScript 삭제','/compute/server/init-script','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','init script','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42035444-36cd-11f0-80c3-6e593baabd40','AccessControlGroup 목록 조회','AccessControlGroup 목록 조회','/compute/server/acgs','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4203887a-36cd-11f0-80c3-6e593baabd40','AccessControlGroup 생성','AccessControlGroup 생성','/compute/server/acgs','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4203bc11-d123-11ee-8e11-0af68e3c6ac5','워크스페이스 즐겨찾기 등록','워크스페이스 즐겨찾기 등록','/workspaces/bookmark','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('42047bd9-36cd-11f0-80c3-6e593baabd40','ServerImage 생성','ServerImage 생성','/compute/server-image','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server image','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420496c5-d123-11ee-8e11-0af68e3c6ac5','워크스페이스의 storage 정보 조회','워크스페이스의 storage 정보 조회','/workspace/{workspaceId}/dashboard/resources/storage','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','workspace','dashboard','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4204c02e-36cd-11f0-80c3-6e593baabd40','ServerImage 유저의 공유 권한 생성','ServerImage 유저의 공유 권한 생성','/compute/server-image/sharing-permission','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server image','POST',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4204ed16-36cd-11f0-80c3-6e593baabd40','ServerImage 유저의 공유 권한 삭제','ServerImage 유저의 공유 권한 삭제','/compute/server-image/sharing-permission','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server image','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42050dae-36cd-11f0-80c3-6e593baabd40','타겟 그룹 생성','타겟 그룹 생성','/target-group/update/health-check/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','loadbalancer','targetgroup','PATCH',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420541a2-36cd-11f0-80c3-6e593baabd40','타겟 그룹의 설명을 수정','타겟 그룹의 설명을 수정','/target-group/update/description/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','loadbalancer','target','PATCH',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42056069-36cd-11f0-80c3-6e593baabd40','admin : GET/tenants/validation','admin : GET/tenants/validation','/tenants/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','tenants','tenant','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42057f86-d123-11ee-8e11-0af68e3c6ac5','워크스페이스 즐겨찾기 삭제','워크스페이스 즐겨찾기 삭제','/workspaces/bookmark/{workspaceId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','DELETE',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('4205817c-36cd-11f0-80c3-6e593baabd40','admin : GET/tenants/un-allocate','admin : GET/tenants/un-allocate','/tenants/un-allocate','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','tenants','tenant','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4205ae24-36cd-11f0-80c3-6e593baabd40','테넌트 리스트 조회','테넌트 리스트 조회','/tenants/temp','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','tenants','tenant','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4205da91-36cd-11f0-80c3-6e593baabd40','타겟 그룹 리스트 조회','타겟 그룹 리스트 조회','/target-group/select/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','loadbalancer','targetgroup','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42060e45-36cd-11f0-80c3-6e593baabd40','타겟 그룹의 생성이 가능한 Vpc List 조회','타겟 그룹의 생성이 가능한 Vpc List 조회','/target-group/select/vpc/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','loadbalancer','target','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4206318d-36cd-11f0-80c3-6e593baabd40','타겟 그룹에 적용된 타겟 리스트를 조회','타겟 그룹에 적용된 타겟 리스트를 조회','/target-group/select/target/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','loadbalancer','target','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42065f20-36cd-11f0-80c3-6e593baabd40','타겟 그룹 디테일 조회','타겟 그룹 디테일 조회','/target-group/select/detail/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','loadbalancer','targetgroup','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420691b2-36cd-11f0-80c3-6e593baabd40','flowLog 생성시 버킷 조회','flowLog 생성시 버킷 조회','/storage/objectstorage/flow-log/buckets','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4206c29f-36cd-11f0-80c3-6e593baabd40','bucket validation','bucket validation','/storage/objectstorage/buckets/{bucketName}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4206ee38-36cd-11f0-80c3-6e593baabd40','버킷 삭제','버킷 삭제','/storage/objectstorage/buckets/{bucketName}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42071b84-36cd-11f0-80c3-6e593baabd40','downloadObject','downloadObject','/storage/objectstorage/buckets/{bucketName}/object','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4207494b-36cd-11f0-80c3-6e593baabd40','ListMultipartUploads','ListMultipartUploads','/storage/objectstorage/buckets/{bucketName}/multi-part','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42077036-36cd-11f0-80c3-6e593baabd40','ListParts','ListParts','/storage/objectstorage/buckets/{bucketName}/list-part','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4207a0ab-36cd-11f0-80c3-6e593baabd40','admin : GET/storage/objectstorage/buckets/{bucketName}/folders','admin : GET/storage/objectstorage/buckets/{bucketName}/folders','/storage/objectstorage/buckets/{bucketName}/folders','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4207c9d6-36cd-11f0-80c3-6e593baabd40','folder validation','folder validation','/storage/objectstorage/buckets/{bucketName}/folder/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4207ec65-36cd-11f0-80c3-6e593baabd40','bucket validation','bucket validation','/storage/objectstorage/buckets/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42080b90-36cd-11f0-80c3-6e593baabd40','admin : GET/storage/objectstorage/acl/buckets/{bucketName}','admin : GET/storage/objectstorage/acl/buckets/{bucketName}','/storage/objectstorage/acl/buckets/{bucketName}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42082add-36cd-11f0-80c3-6e593baabd40','admin : GET/servers/metrics/{prodKey}','admin : GET/servers/metrics/{prodKey}','/servers/metrics/{prodKey}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','cloud insight','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42084bb9-36cd-11f0-80c3-6e593baabd40','region 리스트 조회','region 리스트 조회','/regions','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','region','region','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420869b2-36cd-11f0-80c3-6e593baabd40','zone 리스트 조회','zone 리스트 조회','/regions/zones','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','region','region','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4208892d-36cd-11f0-80c3-6e593baabd40','admin : GET/provider','admin : GET/provider','/provider','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','provider','provider','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4208a357-36cd-11f0-80c3-6e593baabd40','admin : GET/provider/{providerId}','admin : GET/provider/{providerId}','/provider/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','provider','provider','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4208c2d3-36cd-11f0-80c3-6e593baabd40','provider에 속해있는 테넌트에 전체의 대한 현황 정보','provider에 속해있는 테넌트에 전체의 대한 현황 정보','/provider/tenants/info','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','provider','provider','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4208e188-36cd-11f0-80c3-6e593baabd40','admin : GET/network/vpcs/{vpcNo}','admin : GET/network/vpcs/{vpcNo}','/network/vpcs/{vpcNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','vpc','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42090462-36cd-11f0-80c3-6e593baabd40','vpc 삭제','vpc 삭제','/network/vpcs/{vpcNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','vpc','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42092739-36cd-11f0-80c3-6e593baabd40','VPC 이름 중복 확인','VPC 이름 중복 확인','/network/vpcs/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','vpc','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42094743-36cd-11f0-80c3-6e593baabd40','subnet detail','subnet detail','/network/subnets/{subnetNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','subnet','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420968c5-36cd-11f0-80c3-6e593baabd40','subnet validation','subnet validation','/network/subnets/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','subnet','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42098a15-36cd-11f0-80c3-6e593baabd40','Subnet 이름 중복 확인','Subnet 이름 중복 확인','/network/subnets/validation/{subnetName}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','subnet','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4209a841-36cd-11f0-80c3-6e593baabd40','subnet 목록 nic Count 포함  조회','subnet 목록 nic Count 포함  조회','/network/subnets/subnet-provisioning','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','subnet','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4209c1ba-36cd-11f0-80c3-6e593baabd40','route table detail','route table detail','/network/routeTables/{routeTableNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','route table','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4209e004-36cd-11f0-80c3-6e593baabd40','Route Table 삭제','Route Table 삭제','/network/routeTables/{routeTableNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','routetable','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420a112f-36cd-11f0-80c3-6e593baabd40','route table validation','route table validation','/network/routeTables/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','route table','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420a3b8a-36cd-11f0-80c3-6e593baabd40','route table detail - subnet List','route table detail - subnet List','/network/routeTables/subnets/{routeTableNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','route table','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420a7e85-36cd-11f0-80c3-6e593baabd40','route table detail - subnet List','route table detail - subnet List','/network/routeTables/routes/{routeTableNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','route table','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420a9fa4-36cd-11f0-80c3-6e593baabd40','admin : GET/network/nat-gateways/{natGatewayInstanceNo}','admin : GET/network/nat-gateways/{natGatewayInstanceNo}','/network/nat-gateways/{natGatewayInstanceNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','nat gateway','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420abe4b-36cd-11f0-80c3-6e593baabd40','natGateway 삭제','natGateway 삭제','/network/nat-gateways/{natGatewayInstanceNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','nat gateway','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420ae1f7-36cd-11f0-80c3-6e593baabd40','NatGateWay 이름 중복 확인','NatGateWay 이름 중복 확인','/network/nat-gateways/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','nat gateway','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420b0466-36cd-11f0-80c3-6e593baabd40','subnet 목록 조회','subnet 목록 조회','/network/load-balancer','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','subnet','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420b2527-36cd-11f0-80c3-6e593baabd40','Network ACL 상세 조회','Network ACL 상세 조회','/network/acls/{networkAclNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network network acl','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420b42b0-36cd-11f0-80c3-6e593baabd40','Network ACL 삭제','Network ACL 삭제','/network/acls/{networkAclNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network acl','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420b642c-36cd-11f0-80c3-6e593baabd40','Network ACL 중복 체크','Network ACL 중복 체크','/network/acls/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network network acl','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420b8436-36cd-11f0-80c3-6e593baabd40','Network ACL 규칙 목록 조회','Network ACL 규칙 목록 조회','/network/acls/rules','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network network acl','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420bbdea-36cd-11f0-80c3-6e593baabd40','Network ACL 규칙 우선 순위 중복 체크','Network ACL 규칙 우선 순위 중복 체크','/network/acls/rules/validate','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network network acl','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420c114b-36cd-11f0-80c3-6e593baabd40','Deny-Allow Group 상세 정보 - 기본 정보 조회','Deny-Allow Group 상세 정보 - 기본 정보 조회','/network/acls/deny-allow-groups/{networkAclDenyAllowGroupNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network network acl','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420c4f59-36cd-11f0-80c3-6e593baabd40','Deny-Allow Group 상세 정보 -  NetworkAcl 조회','Deny-Allow Group 상세 정보 -  NetworkAcl 조회','/network/acls/deny-allow-groups/{networkAclDenyAllowGroupNo}/network-acl','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network network acl','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420c7530-36cd-11f0-80c3-6e593baabd40','Deny-Allow Group 상세 정보 -  IP 조회','Deny-Allow Group 상세 정보 -  IP 조회','/network/acls/deny-allow-groups/{networkAclDenyAllowGroupNo}/ip','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network network acl','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420c937f-36cd-11f0-80c3-6e593baabd40','Deny-Allow Group 중복 체크','Deny-Allow Group 중복 체크','/network/acls/deny-allow-groups/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','network network acl','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420cbe47-36cd-11f0-80c3-6e593baabd40','인증키 이름 중복 확인','인증키 이름 중복 확인','/loginKey/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','login key','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('420cda12-36cd-11f0-80c3-6e593baabd40','인증키 목록 조회','인증키 목록 조회','/loginKey/list','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','login key','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420cf98d-36cd-11f0-80c3-6e593baabd40','대시보드 서비스 이용 내용','대시보드 서비스 이용 내용','/dashboard/service-usage-info','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','dashboard','dashboard','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420d2efb-36cd-11f0-80c3-6e593baabd40','admin : GET/compute/server/storages/{storageNo}','admin : GET/compute/server/storages/{storageNo}','/compute/server/storages/{storageNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420d6b52-36cd-11f0-80c3-6e593baabd40','server-storage validation','server-storage validation','/compute/server/storages/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420d9368-36cd-11f0-80c3-6e593baabd40','스토리지 생성시 서버 목록 조회','스토리지 생성시 서버 목록 조회','/compute/server/storages/servers','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420db8e9-36cd-11f0-80c3-6e593baabd40','스토리지 서버연결시  서버 목록 조회','스토리지 서버연결시  서버 목록 조회','/compute/server/storages/servers/attach-storage','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420dd657-36cd-11f0-80c3-6e593baabd40','SnapShot Detail 조회','SnapShot Detail 조회','/compute/server/snapshots/{blockStorageSnapshotInstanceNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','snapshot','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420e007d-36cd-11f0-80c3-6e593baabd40','SnapShot 이름 중복 확인','SnapShot 이름 중복 확인','/compute/server/snapshots/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','snapshot','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420e25fc-36cd-11f0-80c3-6e593baabd40','서버 상세 조회','서버 상세 조회','/compute/server/servers/{serverNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420e4771-36cd-11f0-80c3-6e593baabd40','server validation','server validation','/compute/server/servers/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420e6966-36cd-11f0-80c3-6e593baabd40','server-spec 리스트 조회','server-spec 리스트 조회','/compute/server/servers/server-spec','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420e8f86-36cd-11f0-80c3-6e593baabd40','admin : GET/compute/server/servers/detail/network-interface','admin : GET/compute/server/servers/detail/network-interface','/compute/server/servers/detail/network-interface','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420eb011-36cd-11f0-80c3-6e593baabd40','서버 네트워크 인터페이스 조회','서버 네트워크 인터페이스 조회','/compute/server/servers/create/network-interface','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420ed886-36cd-11f0-80c3-6e593baabd40','admin : GET/compute/server/serverImages','admin : GET/compute/server/serverImages','/compute/server/serverImages','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server image','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420ef9b7-36cd-11f0-80c3-6e593baabd40','서버이미지 상세 조회','서버이미지 상세 조회','/compute/server/serverImages/{serverImageNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server image','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420f1e36-36cd-11f0-80c3-6e593baabd40','내 server 이미지 삭제','내 server 이미지 삭제','/compute/server/serverImages/{serverImageNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420f44ea-36cd-11f0-80c3-6e593baabd40','admin : GET/compute/server/serverImageProducts','admin : GET/compute/server/serverImageProducts','/compute/server/serverImageProducts','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server image','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420f6d55-36cd-11f0-80c3-6e593baabd40','admin : GET/compute/server/serverImageProducts/{serverImageProductCode}/serverProducts','admin : GET/compute/server/serverImageProducts/{serverImageProductCode}/serverProducts','/compute/server/serverImageProducts/{serverImageProductCode}/serverProducts','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420f90d4-36cd-11f0-80c3-6e593baabd40','Server-Image 이름 중복 확인','Server-Image 이름 중복 확인','/compute/server/server-image/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server image','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420fafa4-36cd-11f0-80c3-6e593baabd40','admin : GET/compute/server/network-interface/{networkInterfaceNo}','admin : GET/compute/server/network-interface/{networkInterfaceNo}','/compute/server/network-interface/{networkInterfaceNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('420fcb76-36cd-11f0-80c3-6e593baabd40','admin : DELETE/compute/server/network-interface/{networkInterfaceNo}','admin : DELETE/compute/server/network-interface/{networkInterfaceNo}','/compute/server/network-interface/{networkInterfaceNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('420fe6d0-36cd-11f0-80c3-6e593baabd40','network interface 서버 연결 가능한 목록 출력','network interface 서버 연결 가능한 목록 출력','/compute/server/network-interface/{networkInterfaceNo}/servers','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42100982-36cd-11f0-80c3-6e593baabd40','서버 네트워크 인터페이스에 속한 Acg 리스트 조회','서버 네트워크 인터페이스에 속한 Acg 리스트 조회','/compute/server/network-interface/{networkInterfaceNo}/available-acg','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('421092c4-36cd-11f0-80c3-6e593baabd40','NIC 이름 중복 확인','NIC 이름 중복 확인','/compute/server/network-interface/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4210c65d-36cd-11f0-80c3-6e593baabd40','IP 중복 체크용','IP 중복 체크용','/compute/server/network-interface/ips','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','network interface','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4210f148-36cd-11f0-80c3-6e593baabd40','NIC 내의 ACG 조회','NIC 내의 ACG 조회','/compute/server/network-interface/acgs/{acgNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42111dd0-36cd-11f0-80c3-6e593baabd40','NIC 내의 ACG에서 ACG 룰 조회','NIC 내의 ACG에서 ACG 룰 조회','/compute/server/network-interface/acgs/{acgNo}/rules','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('421151d1-36cd-11f0-80c3-6e593baabd40','admin : GET/compute/server/init-script/{initScriptNo}','admin : GET/compute/server/init-script/{initScriptNo}','/compute/server/init-script/{initScriptNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','init script','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42118ac7-36cd-11f0-80c3-6e593baabd40','initScript 이름 중복 확인','initScript 이름 중복 확인','/compute/server/init-script/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','init script','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4211c492-36cd-11f0-80c3-6e593baabd40','all server-image list 조회','all server-image list 조회','/compute/server/all-image-product','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server image','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4211eec7-36cd-11f0-80c3-6e593baabd40','admin : GET/compute/server/acgs/{acgNo}/rules','admin : GET/compute/server/acgs/{acgNo}/rules','/compute/server/acgs/{acgNo}/rules','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42121145-36cd-11f0-80c3-6e593baabd40','admin : GET/compute/server/acgs/{accessControlGroupNo}','admin : GET/compute/server/acgs/{accessControlGroupNo}','/compute/server/acgs/{accessControlGroupNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4212492d-36cd-11f0-80c3-6e593baabd40','AccessControlGroup 삭제','AccessControlGroup 삭제','/compute/server/acgs/{accessControlGroupNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42126c9b-36cd-11f0-80c3-6e593baabd40','NIC 내의 ACG에서 ACG 룰 조회','NIC 내의 ACG에서 ACG 룰 조회','/compute/server/acgs/vpcs/{vpcNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42129450-36cd-11f0-80c3-6e593baabd40','Network ACG 이름 중복 확인','Network ACG 이름 중복 확인','/compute/server/acgs/validation','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','access control group','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4212bcca-36cd-11f0-80c3-6e593baabd40','admin : GET/compute/server-image/test','admin : GET/compute/server-image/test','/compute/server-image/test','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server image','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4212f6f5-36cd-11f0-80c3-6e593baabd40','admin : GET/compute/public-ip','admin : GET/compute/public-ip','/compute/public-ip','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','public ip','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42131a92-36cd-11f0-80c3-6e593baabd40','publicIp 상세 조회','publicIp 상세 조회','/compute/public-ip/{publicIpInstanceNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','public ip','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42134ef6-36cd-11f0-80c3-6e593baabd40','publicIp 생성시 서버 목록 조회','publicIp 생성시 서버 목록 조회','/compute/public-ip/servers','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','public ip','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42137385-36cd-11f0-80c3-6e593baabd40','admin : GET/billing/test','admin : GET/billing/test','/billing/test','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','resource','billing','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('42139879-36cd-11f0-80c3-6e593baabd40','ProductPrice 조회','ProductPrice 조회','/billing/product-prices','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','resource','billing','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4213b918-36cd-11f0-80c3-6e593baabd40','admin : GET/billing/product-costs-mock','admin : GET/billing/product-costs-mock','/billing/product-costs-mock','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','resource','billing','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4213d80a-36cd-11f0-80c3-6e593baabd40','ProductDemandCostList 조회','ProductDemandCostList 조회','/billing/product-costs-by-month','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','resource','billing','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4213f54b-36cd-11f0-80c3-6e593baabd40','admin : GET/billing/prices','admin : GET/billing/prices','/billing/prices','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','resource','billing','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42141a2f-36cd-11f0-80c3-6e593baabd40','월 별 상품 사용량 조회','월 별 상품 사용량 조회','/billing/monthly-use','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','resource','billing','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('421486c2-36cd-11f0-80c3-6e593baabd40','admin : GET/billing/demand-costs','admin : GET/billing/demand-costs','/billing/demand-costs','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','resource','billing','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4214ab17-36cd-11f0-80c3-6e593baabd40','CostAndUseAge 조회','CostAndUseAge 조회','/billing/daily-use','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','resource','billing','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4214cbf4-36cd-11f0-80c3-6e593baabd40','admin : GET/billing/contract-summaries','admin : GET/billing/contract-summaries','/billing/contract-summaries','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','resource','billing','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4214eef3-36cd-11f0-80c3-6e593baabd40','admin : GET/billing/contract-demand-costs','admin : GET/billing/contract-demand-costs','/billing/contract-demand-costs','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','resource','billing','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4215120f-36cd-11f0-80c3-6e593baabd40','타겟 그룹 삭제','타겟 그룹 삭제','/target-group/delete/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','loadbalancer','targetgroup','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('421539f7-36cd-11f0-80c3-6e593baabd40','타겟 그룹에 적용된 타겟을 제거','타겟 그룹에 적용된 타겟을 제거','/target-group/delete/target/{providerId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','loadbalancer','target','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42155a80-36cd-11f0-80c3-6e593baabd40','오브젝트 삭제','오브젝트 삭제','/storage/objectstorage/buckets/{bucketName}/objects','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42157755-36cd-11f0-80c3-6e593baabd40','admin : DELETE/storage/objectstorage/buckets/{bucketName}/multiObject','admin : DELETE/storage/objectstorage/buckets/{bucketName}/multiObject','/storage/objectstorage/buckets/{bucketName}/multiObject','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('42159581-36cd-11f0-80c3-6e593baabd40','AbortMultipartUpload','AbortMultipartUpload','/storage/objectstorage/buckets/{bucketName}/abort-upload','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','storage','storage','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4215b458-36cd-11f0-80c3-6e593baabd40','subnet 삭제','subnet 삭제','/network/subnets/{subnetId}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','subnet','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4215d26f-36cd-11f0-80c3-6e593baabd40','ServerStorage 삭제','ServerStorage 삭제','/compute/server/storages/{serverStorageNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','compute','server storage','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4215ed52-36cd-11f0-80c3-6e593baabd40','admin : DELETE/compute/server/public-ip/{publicIpInstanceNo}','admin : DELETE/compute/server/public-ip/{publicIpInstanceNo}','/compute/server/public-ip/{publicIpInstanceNo}','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','network','public ip','DELETE',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('426573fa-9e41-11ee-a438-3e72d96d3fbc','메뉴 삭제','메뉴 삭제','/menu/{menuId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','menu','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4265ec93-9e41-11ee-a438-3e72d96d3fbc','특정 네비게이션 메뉴 하위 LNB 배치 변경','특정 네비게이션 메뉴 하위 LNB 배치 변경','/menu/global/{globalMenuId}/layout','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','menu','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('426973c2-9e41-11ee-a438-3e72d96d3fbc','메뉴 식별자 중복 확인','메뉴에서 사용될 수 있는 기능 목록 조회.','/menu/check-selector','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','menu','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('430be721-4597-11ef-a4c4-96fd9ef2bacb','서비스 신청에 필요한 설정 값 수정','서비스 신청에 필요한 설정 값 수정','/service-objects/requests/{id}/config-map','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4324ccf0-ce55-11ef-9c74-0a11b82fa8dd','자신의 비밀번호 초기화','자신의 비밀번호 초기화','/profile/reset-password','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','profile','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4325d879-ce55-11ef-9c74-0a11b82fa8dd','마이페이지 비밀번호 변경','마이페이지 비밀번호 변경','/profile/reset-password','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','profile','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('43495419-9cc6-11ef-8cfe-22e1909bc60f','서브넷 설정','서브넷 설정','/load-balancers/subnets','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancer','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('434a0188-9cc6-11ef-8cfe-22e1909bc60f','Ip 주소 타입 설정','Ip 주소 타입 설정','/load-balancers/ip-address-type','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancer','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('434afd28-9cc6-11ef-8cfe-22e1909bc60f','admin : PUT/autoscaling/instances/rollback','admin : PUT/autoscaling/instances/rollback','/autoscaling/instances/rollback','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','instance','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('434b9881-9cc6-11ef-8cfe-22e1909bc60f','admin : PUT/autoscaling/instances/refresh','admin : PUT/autoscaling/instances/refresh','/autoscaling/instances/refresh','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','instance','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('434bca16-9cc6-11ef-8cfe-22e1909bc60f','admin : PUT/autoscaling/instances/protection','admin : PUT/autoscaling/instances/protection','/autoscaling/instances/protection','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','instance','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('434bf8a6-9cc6-11ef-8cfe-22e1909bc60f','admin : PUT/autoscaling/instances/health','admin : PUT/autoscaling/instances/health','/autoscaling/instances/health','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','instance','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('434c961f-9cc6-11ef-8cfe-22e1909bc60f','시작 템플릿 인스턴스 시작','시작 템플릿 인스턴스 시작','/ec2/launchtemplates/servers','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('434ccee2-9cc6-11ef-8cfe-22e1909bc60f','admin : POST/autoscaling/instances/attach','admin : POST/autoscaling/instances/attach','/autoscaling/instances/attach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','instance','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('434cfc3e-9cc6-11ef-8cfe-22e1909bc60f','admin : GET/autoscaling/instances/refreshes','admin : GET/autoscaling/instances/refreshes','/autoscaling/instances/refreshes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','instance','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('434d5697-9cc6-11ef-8cfe-22e1909bc60f','admin : DELETE/autoscaling/instances/terminate','admin : DELETE/autoscaling/instances/terminate','/autoscaling/instances/terminate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','instance','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('434d92fd-9cc6-11ef-8cfe-22e1909bc60f','admin : DELETE/autoscaling/instances/detach','admin : DELETE/autoscaling/instances/detach','/autoscaling/instances/detach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','instance','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('434df6b4-9cc6-11ef-8cfe-22e1909bc60f','admin : DELETE/autoscaling/instances/cancel','admin : DELETE/autoscaling/instances/cancel','/autoscaling/instances/cancel','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','instance','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('434e6d92-9cc6-11ef-8cfe-22e1909bc60f','서브넷 설정','서브넷 설정','/load-balancers/subnets','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancer','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('434e9e6c-9cc6-11ef-8cfe-22e1909bc60f','Ip 주소 타입 설정','Ip 주소 타입 설정','/load-balancers/ip-address-type','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancer','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('434f2410-9cc6-11ef-8cfe-22e1909bc60f','user : PUT/autoscaling/instances/rollback','user : PUT/autoscaling/instances/rollback','/autoscaling/instances/rollback','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','instance','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('434f497f-9cc6-11ef-8cfe-22e1909bc60f','user : PUT/autoscaling/instances/refresh','user : PUT/autoscaling/instances/refresh','/autoscaling/instances/refresh','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','instance','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('434f7708-9cc6-11ef-8cfe-22e1909bc60f','user : PUT/autoscaling/instances/protection','user : PUT/autoscaling/instances/protection','/autoscaling/instances/protection','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','instance','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('434f9ee3-9cc6-11ef-8cfe-22e1909bc60f','user : PUT/autoscaling/instances/health','user : PUT/autoscaling/instances/health','/autoscaling/instances/health','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','instance','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('43506d0b-9cc6-11ef-8cfe-22e1909bc60f','시작 템플릿 인스턴스 시작','시작 템플릿 인스턴스 시작','/ec2/launchtemplates/servers','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('4350ad45-9cc6-11ef-8cfe-22e1909bc60f','user : POST/autoscaling/instances/attach','user : POST/autoscaling/instances/attach','/autoscaling/instances/attach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','instance','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('4350d21b-9cc6-11ef-8cfe-22e1909bc60f','user : GET/autoscaling/instances/refreshes','user : GET/autoscaling/instances/refreshes','/autoscaling/instances/refreshes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','instance','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('43511003-9cc6-11ef-8cfe-22e1909bc60f','user : DELETE/autoscaling/instances/terminate','user : DELETE/autoscaling/instances/terminate','/autoscaling/instances/terminate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','instance','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('4351370e-9cc6-11ef-8cfe-22e1909bc60f','user : DELETE/autoscaling/instances/detach','user : DELETE/autoscaling/instances/detach','/autoscaling/instances/detach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','instance','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('4351651f-9cc6-11ef-8cfe-22e1909bc60f','user : DELETE/autoscaling/instances/cancel','user : DELETE/autoscaling/instances/cancel','/autoscaling/instances/cancel','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','instance','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('4370ebe5-b869-11ef-9c74-0a11b82fa8dd','Dnssec 해제','Dnssec 해제','/route53s/domains/delegation-signer','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4372da9d-b869-11ef-9c74-0a11b82fa8dd','Dnssec 등록','Dnssec 등록','/route53s/domains/delegation-signer','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('43736154-b869-11ef-9c74-0a11b82fa8dd','도메인 리스트 등록','도메인 리스트 등록','/route53s/domains/register/list','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('437396cf-b869-11ef-9c74-0a11b82fa8dd','업로드서버인증서','업로드서버인증서','/iam/users/server-certificate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','user','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('43742137-b869-11ef-9c74-0a11b82fa8dd','퀵 스타트 AMI 저장','퀵 스타트 AMI 저장','/compute/amis/quickstart','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','ami','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('43749a6b-b869-11ef-9c74-0a11b82fa8dd','admin : POST/autoscaling/metrics/enable','admin : POST/autoscaling/metrics/enable','/autoscaling/metrics/enable','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','metric','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4375063d-b869-11ef-9c74-0a11b82fa8dd','admin : POST/autoscaling/metrics/disable','admin : POST/autoscaling/metrics/disable','/autoscaling/metrics/disable','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','metric','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('43752f0f-b869-11ef-9c74-0a11b82fa8dd','acm 인증서 생성','acm 인증서 생성','/acm/certificates/acm-certificate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','acm','certificate','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('43759b75-b869-11ef-9c74-0a11b82fa8dd','admin : GET/route53s/match-domain-vpc/{domainName}','admin : GET/route53s/match-domain-vpc/{domainName}','/route53s/match-domain-vpc/{domainName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4375fcc6-b869-11ef-9c74-0a11b82fa8dd','이전 잠금 비활성','이전 잠금 비활성','/route53s/domains/unlock/{domainName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('437623fd-b869-11ef-9c74-0a11b82fa8dd','연락 가능 여부 확인 이메일 재전송','연락 가능 여부 확인 이메일 재전송','/route53s/domains/resend/{domainName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('43764ad2-b869-11ef-9c74-0a11b82fa8dd','이전 잠금 활성','이전 잠금 활성','/route53s/domains/lock/{domainName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4376752e-b869-11ef-9c74-0a11b82fa8dd','도메인 비용조회','도메인 비용조회','/route53s/domains/cost/{domainName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('43769aa6-b869-11ef-9c74-0a11b82fa8dd','admin : GET/autoscaling/metrics/types','admin : GET/autoscaling/metrics/types','/autoscaling/metrics/types','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','metric','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4376c4a3-b869-11ef-9c74-0a11b82fa8dd','도메인 삭제','도메인 삭제','/route53s/domains/{domainName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('45a95c42-6447-11ef-aa9f-f2cdef6842ce','Metric Config List','Metric Config List','/comm/metric-config','910fa43a-7797-11ee-b465-565158862942','Vista','observability','common','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('45a9e55f-6447-11ef-aa9f-f2cdef6842ce','Metric Config Update','Metric Config Update','/comm/metric-config','910fa43a-7797-11ee-b465-565158862942','Vista','observability','common','PUT',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('45aa2b64-6447-11ef-aa9f-f2cdef6842ce','인벤토리 파드 목록 조회 API','인벤토리 파드 목록 조회 API','/inventory/pod/items','910fa43a-7797-11ee-b465-565158862942','Vista','observability','inventory','POST',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('45aaf21c-6447-11ef-aa9f-f2cdef6842ce','인스턴스 목록 조회 API','인스턴스 목록 조회 API','/inventory/instance/items','910fa43a-7797-11ee-b465-565158862942','Vista','observability','inventory','POST',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('45ab30bf-6447-11ef-aa9f-f2cdef6842ce','호스트 목록 조회 API','호스트 목록 조회 API','/inventory/host/items','910fa43a-7797-11ee-b465-565158862942','Vista','observability','inventory','POST',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('45ab6ed1-6447-11ef-aa9f-f2cdef6842ce','인벤토리 파드 목록 현황 조회 API','인벤토리 파드 목록 현황 조회 API','/inventory/pod/stat','910fa43a-7797-11ee-b465-565158862942','Vista','observability','inventory','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('45abb200-6447-11ef-aa9f-f2cdef6842ce','인벤토리 파드 매트릭 조회 API','인벤토리 파드 매트릭 조회 API','/inventory/pod/metric','910fa43a-7797-11ee-b465-565158862942','Vista','observability','inventory','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('45abf1cb-6447-11ef-aa9f-f2cdef6842ce','네트워크 목록 현황 조회 API','네트워크 목록 현황 조회 API','/inventory/network/stat','910fa43a-7797-11ee-b465-565158862942','Vista','observability','inventory','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('45ac2f06-6447-11ef-aa9f-f2cdef6842ce','인벤토리 네트워크 매트릭 조회 API','인벤토리 네트워크 매트릭 조회 API','/inventory/network/metric','910fa43a-7797-11ee-b465-565158862942','Vista','observability','inventory','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('45ac71e9-6447-11ef-aa9f-f2cdef6842ce','인벤토리 로드밸런서 목록 현황 조회 API','인벤토리 로드밸런서 목록 현황 조회 API','/inventory/loadbalancer/stat','910fa43a-7797-11ee-b465-565158862942','Vista','observability','inventory','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('45acb14a-6447-11ef-aa9f-f2cdef6842ce','인벤토리 로드밸런서 매트릭 조회 API','인벤토리 로드밸런서 매트릭 조회 API','/inventory/loadbalancer/metric','910fa43a-7797-11ee-b465-565158862942','Vista','observability','inventory','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('45aced00-6447-11ef-aa9f-f2cdef6842ce','인스턴스 목록 현황 조회 API','인스턴스 목록 현황 조회 API','/inventory/instance/stat','910fa43a-7797-11ee-b465-565158862942','Vista','observability','inventory','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('45ad266a-6447-11ef-aa9f-f2cdef6842ce','인벤토리 인스턴스 매트릭 조회 API','인벤토리 인스턴스 매트릭 조회 API','/inventory/instance/metric','910fa43a-7797-11ee-b465-565158862942','Vista','observability','inventory','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('45ad60b8-6447-11ef-aa9f-f2cdef6842ce','호스트 목록 현황 조회 API','호스트 목록 현황 조회 API','/inventory/host/stat','910fa43a-7797-11ee-b465-565158862942','Vista','observability','inventory','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('45ada2bd-6447-11ef-aa9f-f2cdef6842ce','인벤토리 호스트 매트릭 조회 API','인벤토리 호스트 매트릭 조회 API','/inventory/host/metric','910fa43a-7797-11ee-b465-565158862942','Vista','observability','inventory','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('45adf2bd-6447-11ef-aa9f-f2cdef6842ce','Event hour list','Event hour list','/event/history','910fa43a-7797-11ee-b465-565158862942','Vista','observability','event','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('45ae7138-6447-11ef-aa9f-f2cdef6842ce','IaaS 대시보드의 공급자 현황 API','IaaS 대시보드의 공급자 현황 API','/dashboard/iaas/workspaces/status/list','910fa43a-7797-11ee-b465-565158862942','Vista','observability','dashboard','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('45aefa72-6447-11ef-aa9f-f2cdef6842ce','사용자 IaaS 대시보드의 워크스페이스 하위 인스턴스 목록 조회 API','사용자 IaaS 대시보드의 워크스페이스 하위 인스턴스 목록 조회 API','/dashboard/iaas/instances/list','910fa43a-7797-11ee-b465-565158862942','Vista','observability','dashboard','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('45af3750-6447-11ef-aa9f-f2cdef6842ce','COMPUTE_HOST Dashboard','COMPUTE_HOST Dashboard','/dashboard/compute/controller-host/list','910fa43a-7797-11ee-b465-565158862942','Vista','observability','dashboard','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('45afa764-6447-11ef-aa9f-f2cdef6842ce','COMPUTE_HOST Dashboard','COMPUTE_HOST Dashboard','/dashboard/compute/compute-host/list','910fa43a-7797-11ee-b465-565158862942','Vista','observability','dashboard','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('45c0f187-4330-11ef-9f42-5e230e3817dd','노드별 가상 자원 개요(프로메테우스 대시보드)','노드별 가상 자원 개요(프로메테우스 대시보드)','/dashboard/compute/servers/resource-usage','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','dashboard','prometheus','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('45c142a5-4330-11ef-9f42-5e230e3817dd','하이퍼바이저 노드별 가상 자원 개요','하이퍼바이저 노드별 가상 자원 개요','/dashboard/compute/servers/hypervisors-resource-usage','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','dashboard','hypervisor','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('45c18514-4330-11ef-9f42-5e230e3817dd','노드별 가상 자원 개요(프로메테우스 대시보드)','노드별 가상 자원 개요(프로메테우스 대시보드)','/dashboard/compute/servers/resource-usage','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','dashboard','prometheus','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('45c1be19-4330-11ef-9f42-5e230e3817dd','하이퍼바이저 노드별 가상 자원 개요','하이퍼바이저 노드별 가상 자원 개요','/dashboard/compute/servers/hypervisors-resource-usage','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','dashboard','hypervisor','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('466f36a6-8309-11ee-a4fd-dadafdb14cb0','워크스페이스 수정','워크스페이스 수정','/workspaces/{workspaceId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('467174ce-8309-11ee-a4fd-dadafdb14cb0','워크플로우 조회','워크플로우 조회','/workflows/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','workflow','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4672741d-8309-11ee-a4fd-dadafdb14cb0','워크플로우 수정','워크플로우 수정','/workflows/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','workflow','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('467331ad-8309-11ee-a4fd-dadafdb14cb0','워크플로우 삭제','워크플로우 삭제','/workflows/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','workflow','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46790ecb-8309-11ee-a4fd-dadafdb14cb0','그룹 상세 조회','그룹 상세 조회','/user/group/{groupId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','group','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('467a4cd3-8309-11ee-a4fd-dadafdb14cb0','사용자 그룹 수정','사용자 그룹 수정','/user/group/{groupId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','group','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('467b0013-8309-11ee-a4fd-dadafdb14cb0','사용자 그룹 삭제','사용자 그룹 삭제','/user/group/{groupId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','group','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('467c7d1d-8309-11ee-a4fd-dadafdb14cb0','카테고리 조회','카테고리 조회','/tags/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('467e3f26-8309-11ee-a4fd-dadafdb14cb0','Tag 생성','Tag 생성','/tags/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('467f6279-8309-11ee-a4fd-dadafdb14cb0','tag 삭제','tag 삭제','/tags/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4687c3bb-8309-11ee-a4fd-dadafdb14cb0','서비스-오브젝트 조회','서비스-오브젝트 조회','/service-objects/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46889fa2-8309-11ee-a4fd-dadafdb14cb0','서비스-오브젝트 수정','서비스-오브젝트 수정','/service-objects/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4689969c-8309-11ee-a4fd-dadafdb14cb0','서비스-카탈로그-요청 조회','서비스-카탈로그-요청 조회','/service-objects/requests/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('468ae7a4-8309-11ee-a4fd-dadafdb14cb0','서비스 신청 수정','서비스 신청 수정','/service-objects/requests/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('468c94dd-8309-11ee-a4fd-dadafdb14cb0','서비스 신청 삭제','서비스 신청 삭제','/service-objects/requests/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46914907-8309-11ee-a4fd-dadafdb14cb0','역할 수정','역할 수정','/roles/{roleId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','role','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('469238e0-8309-11ee-a4fd-dadafdb14cb0','역할 배포 수정','역할 배포 수정','/roles/deploy/{deployId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','role-deploy','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4692ed1a-8309-11ee-a4fd-dadafdb14cb0','역할 배포 삭제','역할 배포 삭제','/roles/deploy/{deployId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','role-deploy','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4693a26d-8309-11ee-a4fd-dadafdb14cb0','조직 회수','조직 회수','/roles/deploy/{deployId}/take-back-org','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','role-deploy','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('469465e0-8309-11ee-a4fd-dadafdb14cb0','조직 등록','조직 등록','/roles/deploy/{deployId}/register-org','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','role-deploy','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46962c5d-8309-11ee-a4fd-dadafdb14cb0','플렛폼 생성','플렛폼 생성','/platforms/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','platform','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46972049-377f-11ef-9f42-5e230e3817dd','대시보드 서비스 현황','대시보드 서비스 현황','/dashboard/service-status','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','dashboard','prometheus','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46995ade-8309-11ee-a4fd-dadafdb14cb0','조직 삭제','조직 삭제','/org/{orgId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46a33cd2-8309-11ee-a4fd-dadafdb14cb0','엔드포인트 수정','엔드포인트 수정','/endpoints/{endpointId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','endpoint','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46a47a88-8309-11ee-a4fd-dadafdb14cb0','카테고리 조회','카테고리 조회','/categories/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46a5313a-1f24-11ef-922c-16fe18334070','ACL Entry 제할당한다','ACL Entry 제할당한다','/network/acls/entrys','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','acl','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('46a5538a-8309-11ee-a4fd-dadafdb14cb0','카테고리 수정','카테고리 수정','/categories/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46a6122a-8309-11ee-a4fd-dadafdb14cb0','카테고리 삭제','카테고리 삭제','/categories/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46a6ba11-1f24-11ef-922c-16fe18334070','vpc 리소스 맵','vpc 리소스 맵','/network/vpcs/resource-map/{vpcId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('46a72169-1f24-11ef-922c-16fe18334070','admin : DELETE/network/internet-gateways/{internetGatewayId}','admin : DELETE/network/internet-gateways/{internetGatewayId}','/network/internet-gateways/{internetGatewayId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','gateway','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('46a79553-1f24-11ef-922c-16fe18334070','admin : GET/compute/amis/regions/{amiId}','admin : GET/compute/amis/regions/{amiId}','/compute/amis/regions/{amiId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','ami','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('46a7a2b9-8309-11ee-a4fd-dadafdb14cb0','권한 수정','권한 수정','/authorities/{authorityId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','authority','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46a7fa0d-1f24-11ef-922c-16fe18334070','ACL Entry삭제','ACL Entry삭제','/network/acls/entrys/{networkAclId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','acl','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('46a89050-1f24-11ef-922c-16fe18334070','ACL Entry 제할당한다','ACL Entry 제할당한다','/network/acls/entrys','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','acl','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('46a8b095-8309-11ee-a4fd-dadafdb14cb0','권한 삭제','권한 삭제','/authorities/{authorityId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','authority','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46a8d405-1f24-11ef-922c-16fe18334070','vpc 리소스 맵','vpc 리소스 맵','/network/vpcs/resource-map/{vpcId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('46a95005-1f24-11ef-922c-16fe18334070','user : DELETE/network/internet-gateways/{internetGatewayId}','user : DELETE/network/internet-gateways/{internetGatewayId}','/network/internet-gateways/{internetGatewayId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','gateway','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('46a998bb-1f24-11ef-922c-16fe18334070','user : GET/compute/amis/regions/{amiId}','user : GET/compute/amis/regions/{amiId}','/compute/amis/regions/{amiId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','ami','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('46a9d991-1f24-11ef-922c-16fe18334070','ACL Entry삭제','ACL Entry삭제','/network/acls/entrys/{networkAclId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','acl','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('46b263bd-8309-11ee-a4fd-dadafdb14cb0','워크플로우 조회','워크플로우 조회','/workflows','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','workflow','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46b341ed-8309-11ee-a4fd-dadafdb14cb0','워크플로우 생성','워크플로우 생성','/workflows','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','workflow','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46b4e8f0-8309-11ee-a4fd-dadafdb14cb0','사용자 검색','사용자 검색','/user','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','management','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46b72b3d-8309-11ee-a4fd-dadafdb14cb0','그룹 목록 조회','그룹 목록 조회','/user/group','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','group','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46b829b5-8309-11ee-a4fd-dadafdb14cb0','사용자 그룹 생성','사용자 그룹 생성','/user/group','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','group','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46b8d062-8309-11ee-a4fd-dadafdb14cb0','사용자 / 그룹 접근제어 설정','사용자 / 그룹 접근제어 설정','/user/access-control','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','access-control','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46b9ebf1-8309-11ee-a4fd-dadafdb14cb0','사용자 / 그룹 접근제어 삭제','사용자 / 그룹 접근제어 삭제','/user/access-control','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','access-control','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46bb1195-8309-11ee-a4fd-dadafdb14cb0','카테고리 조회','카테고리 조회','/tags','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46bbbc11-8309-11ee-a4fd-dadafdb14cb0','Tag 생성','Tag 생성','/tags','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46bc8f0f-8309-11ee-a4fd-dadafdb14cb0','서비스-오브젝트-tag 생성','서비스-오브젝트-tag 생성','/tags/{tagId}/service-objects/{serviceObjectId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46bd45b3-8309-11ee-a4fd-dadafdb14cb0','서비스-오브젝트-tag 삭제','서비스-오브젝트-tag 삭제','/tags/{tagId}/service-objects/{serviceObjectId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46bff12c-8309-11ee-a4fd-dadafdb14cb0','솔루션 생성 API','솔루션에 대한 생성 기능','/solutions','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','solution','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46c0fd93-8309-11ee-a4fd-dadafdb14cb0','서비스-오브젝트-카테고리 생성','서비스-오브젝트-카테고리 생성','/service-objects/{serviceObjectId}/tag/{tagId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46c1b753-8309-11ee-a4fd-dadafdb14cb0','서비스-오브젝트-카테고리 삭제','서비스-오브젝트-카테고리 삭제','/service-objects/{serviceObjectId}/tag/{tagId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46c26710-8309-11ee-a4fd-dadafdb14cb0','서비스-카탈로그-요청 조회','서비스-카탈로그-요청 조회','/service-objects/requests','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('46c3bbad-8309-11ee-a4fd-dadafdb14cb0','서비스 신청 생성','서비스 신청 생성','/service-objects/requests','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46c4bf64-8309-11ee-a4fd-dadafdb14cb0','서비스-카탈로그-요청-워크플로우 생성','서비스-카탈로그-요청-워크플로우 생성','/service-objects/requests/{requestOfServiceObjectId}/workflow/{workflowId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46c59324-8309-11ee-a4fd-dadafdb14cb0','서비스-카탈로그-요청-워크플로우 삭제','서비스-카탈로그-요청-워크플로우 삭제','/service-objects/requests/{requestOfServiceObjectId}/workflow/{workflowId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46c698ac-8309-11ee-a4fd-dadafdb14cb0','서비스 신청 생성','서비스 신청 생성','/service-objects/requests/{id}/provisions','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46c75b11-8309-11ee-a4fd-dadafdb14cb0','서비스-오브젝트 조회','서비스-오브젝트 조회','/service-objects','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46c860cf-8309-11ee-a4fd-dadafdb14cb0','서비스-오브젝트 생성','서비스-오브젝트 생성','/service-objects','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46caac70-8309-11ee-a4fd-dadafdb14cb0','서비스-카탈로그 생성','서비스-카탈로그 생성','/service-catalogs','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46cb946f-8309-11ee-a4fd-dadafdb14cb0','서비스-오브젝트 목록 조회','서비스-오브젝트 목록 조회','/service-catalogs/{id}/service-objects','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46cc6d37-8309-11ee-a4fd-dadafdb14cb0','서비스-오브젝트와 서비스-카탈로그 관계 생성','서비스-오브젝트와 서비스-카탈로그 관계 생성','/service-catalogs/{id}/service-objects','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46cd30b7-8309-11ee-a4fd-dadafdb14cb0','서비스-오브젝트와 서비스-카탈로그 관계 생성','서비스-오브젝트와 서비스-카탈로그 관계 생성','/service-catalogs/{id}/service-objects/{serviceObjectId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46ce0d3b-8309-11ee-a4fd-dadafdb14cb0','서비스-오브젝트와 서비스-카탈로그 관계 삭제','서비스-오브젝트와 서비스-카탈로그 관계 삭제','/service-catalogs/{id}/service-objects/{serviceObjectId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46d0ccb1-8309-11ee-a4fd-dadafdb14cb0','역할 배포 목록 조회','역할 배포 목록 조회','/roles/deploy','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','role-deploy','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46d190b2-8309-11ee-a4fd-dadafdb14cb0','역할 배포 생성','역할 배포 생성','/roles/deploy','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','role-deploy','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46d8be2d-8309-11ee-a4fd-dadafdb14cb0','서비스-카탈로그 조직 배포','서비스-카탈로그 조직 배포','/org/{id}/service-catalogs/{serviceCatalogId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46da8692-8309-11ee-a4fd-dadafdb14cb0','서비스-카탈로그 조직 배포 취소','서비스-카탈로그 조직 배포 취소','/org/{id}/service-catalogs/{serviceCatalogId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46dba35a-8309-11ee-a4fd-dadafdb14cb0','서비스-카탈로그 조직 배포','서비스-카탈로그 조직 배포','/org/service-catalogs','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46e35432-8309-11ee-a4fd-dadafdb14cb0','공급자 연결 확인','공급자 연결 확인','/infra/provider/connect/check','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','infra','provider','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46e61e4a-8309-11ee-a4fd-dadafdb14cb0','API Docs를 통한 Endpoint 추출(감사로그 수집 대상 동기화 포함)','API Docs를 통한 Endpoint 추출(감사로그 수집 대상 동기화 포함)','/endpoints/sync/{solution}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','endpoint','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46e70617-8309-11ee-a4fd-dadafdb14cb0','카테고리 조회','카테고리 조회','/categories','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('46e7d4aa-8309-11ee-a4fd-dadafdb14cb0','카테고리 생성','카테고리 생성','/categories','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('46f33375-8309-11ee-a4fd-dadafdb14cb0','워크스페이스에 배포된 역할 목록 조회','워크스페이스에 배포된 역할 목록 조회','/workspaces/{workspaceId}/roles','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46f47608-8309-11ee-a4fd-dadafdb14cb0','워크스페이스에 연결된 자원(테넌트) 목록 조회','워크스페이스에 연결된 자원(테넌트) 목록 조회','/workspaces/{workspaceId}/resources','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46f597c9-8309-11ee-a4fd-dadafdb14cb0','워크스페이스내 접근가능 구성원 목록 조회','워크스페이스내 접근가능 구성원 목록 조회','/workspaces/{workspaceId}/access-member','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46f7c1a0-8309-11ee-a4fd-dadafdb14cb0','그룹 생성시 메일 중복 확인','그룹 생성시 메일 중복 확인','/user/group/check-group-email','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','group','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46fe7b2f-8309-11ee-a4fd-dadafdb14cb0','서비스-카탈로그 조회','서비스-카탈로그 조회','/service-objects/{id}/service-catalogs','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46ff2dfc-8309-11ee-a4fd-dadafdb14cb0','폴더 조회 API(하나의 서비스 카탈로그에 연결된 폴더 목록 조회)','폴더 조회 API(하나의 서비스 카탈로그에 연결된 폴더 목록 조회)','/service-catalogs/{id}/folders','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('46ffd06c-8309-11ee-a4fd-dadafdb14cb0','역할 타입 조회 API (카테고리 포함)','역할 타입 조회 API (카테고리 포함)','/roles/types','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','role','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('47007dc5-8309-11ee-a4fd-dadafdb14cb0','조직 리소스에 배포된 역할 조회','조직 리소스에 배포된 역할 조회','/roles/deployed','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','role','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4701d2bc-8309-11ee-a4fd-dadafdb14cb0','역할 배포 조회','역할 배포 조회','/roles/deploy/{roleDeployId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','role-deploy','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('47028ec1-8309-11ee-a4fd-dadafdb14cb0','배포 가능한 조직 검색','배포 가능한 조직 검색','/roles/deploy/{roleDeployId}/registrable-org','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','role-deploy','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('47034d94-8309-11ee-a4fd-dadafdb14cb0','역할 이름 중복 체크','역할 이름 중복 체크','/roles/deploy/check-name','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','role-deploy','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('47040d0d-8309-11ee-a4fd-dadafdb14cb0','역할 식별자 중복 체크','역할 식별자 중복 체크','/roles/check-selector','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','role','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('47052686-8309-11ee-a4fd-dadafdb14cb0','역할 이름 중복 체크','역할 이름 중복 체크','/roles/check-name','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','role','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('470617ef-8309-11ee-a4fd-dadafdb14cb0','상태 별 플랫폼 목록 조회','상태 별 플랫폼 목록 조회','/platforms/status/{status}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','platform','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('470744fc-8309-11ee-a4fd-dadafdb14cb0','조직에 속한 워크스페이스 목록 조회','조직에 속한 워크스페이스 목록 조회','/org/{orgId}/workspaces','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('47083a4d-8309-11ee-a4fd-dadafdb14cb0','조직에 속한 유저 목록 조회','조직에 속한 유저 목록 조회','/org/{orgId}/users','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('47091d10-8309-11ee-a4fd-dadafdb14cb0','조직에 속한 역할 목록 조회','조직에 속한 역할 목록 조회','/org/{orgId}/roles','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4709cc1e-8309-11ee-a4fd-dadafdb14cb0','조직에 속한 그룹 목록 조회','조직에 속한 그룹 목록 조회','/org/{orgId}/groups','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('470a6a2b-8309-11ee-a4fd-dadafdb14cb0','조직에 배포된 서비스-카탈로그 목록 조회','조직에 배포된 서비스-카탈로그 목록 조회','/org/{id}/service-catalogs','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('470c37e0-8309-11ee-a4fd-dadafdb14cb0','감사 로그 조회(관리자용)','감사 로그 조회(관리자용)','/log/work','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','dashboard','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('470ce019-8309-11ee-a4fd-dadafdb14cb0','접속 로그 조회','접속 로그 조회','/log/access','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','dashboard','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('470f1289-8309-11ee-a4fd-dadafdb14cb0','이름 중복 체크 - Infra Folder 생성시','이름 중복 체크 - Infra Folder 생성시','/infra/{infraId}/folder/{folderId}/check-exist-infra-name','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','infra','provider','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4713113e-8309-11ee-a4fd-dadafdb14cb0','공급자 타입 검색','공급자 타입 검색','/infra/provider/types','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','infra','provider','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('47191284-8309-11ee-a4fd-dadafdb14cb0','이름 중복 체크 - Root Infra 생성시','이름 중복 체크 - Root Infra 생성시','/infra/check-exist-infra-name','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','infra','provider','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('471b081f-8309-11ee-a4fd-dadafdb14cb0','유형 전체 목록 조회','유형 전체 목록 조회','/endpoints/type','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','endpoint','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('471c21a5-8309-11ee-a4fd-dadafdb14cb0','서비스 목록 조회','서비스 목록 조회','/endpoints/service','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','endpoint','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('471ed53c-8309-11ee-a4fd-dadafdb14cb0','대시보드 서비스 신청 현황','대시보드 서비스 신청 현황','/dashboard/request-service','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','dashboard','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('472016d7-8309-11ee-a4fd-dadafdb14cb0','대시보드 서비스 요청 TOP 5','대시보드 서비스 요청 TOP 5','/dashboard/request-service/top5','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','dashboard','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('4721cde4-8309-11ee-a4fd-dadafdb14cb0','대시보드  접근제어','대시보드  접근제어','/dashboard/infra','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','dashboard','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('47227f61-8309-11ee-a4fd-dadafdb14cb0','대시보드  연결정보','대시보드  연결정보','/dashboard/connection/info','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','dashboard','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('47233166-8309-11ee-a4fd-dadafdb14cb0','대시보드 클라우드 플랫폼 연결 현황','대시보드 클라우드 플랫폼 연결 현황','/dashboard/cloud/platform/connection','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','dashboard','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('4724e7ab-8309-11ee-a4fd-dadafdb14cb0','대시보드  접근제어','대시보드  접근제어','/dashboard/access-control','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','dashboard','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('4725a992-8309-11ee-a4fd-dadafdb14cb0','셀렉터 중복 확인','셀렉터 중복 확인','/authorities/check-selector','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','authority','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4726730c-8309-11ee-a4fd-dadafdb14cb0','권한 생성 이름 중복 확인','권한 생성 이름 중복 확인','/authorities/check-name','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','authority','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4732947b-8309-11ee-a4fd-dadafdb14cb0','워크스페이스 / 공급자 연결 해제(NCP용)','워크스페이스 / 공급자 연결 해제(NCP용)','/infra/workspace-connection','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','infra','provider','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('473350f3-8309-11ee-a4fd-dadafdb14cb0','워크스페이스 / 공급자 연결 해제','워크스페이스 / 공급자 연결 해제','/infra/workspace-connection/{workspaceConnectionId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','infra','provider','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('476737e7-322e-11f0-92ed-2e5d1099d8b8','모든 조직과 테넌트 조회','모든 조직과 테넌트 조회','/org/folder/tenant','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','org-resource','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('478ec2c1-94cd-11ee-971f-72441c073636','메뉴 공개 상태 변경','메뉴 공개 상태 변경','/menu/{menuId}/status','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','menu','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('478f02ec-94cd-11ee-971f-72441c073636','메뉴 관리에서 메뉴 목록 조회#whtie-api','LNB 메뉴 목록 조회 특정 네비게이션 메뉴 하나에 대한 LNB 목록 조회','/menu/global/{globalMenuId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','menu','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('478f4656-94cd-11ee-971f-72441c073636','특정 네비게이션 메뉴 하위 LNB 배치 변경','관리자 포탈 LNB 조회. 비공개인 메뉴나 사용자에게 허용되지 않은 메뉴는 제외한다.','/menu/global/{globalMenuId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','menu','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('478f7c06-94cd-11ee-971f-72441c073636','관리자 포탈 GNB 메뉴 목록 조회','관리자 포탈 GNB 메뉴 목록 조회','/menu/portal/global','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','menu','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('478fc208-94cd-11ee-971f-72441c073636','관리자 포탈의 LNB 메뉴 조회','관리자 포탈의 LNB 메뉴 조회','/menu/portal/global/{globalMenuId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','menu','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('478ff97f-94cd-11ee-971f-72441c073636','메뉴 관리에서 관리자/사용자 네비게이션 메뉴 목록 조회','메뉴 관리에서 관리자/사용자 네비게이션 메뉴 목록 조회','/menu/global','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','menu','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('479038a2-94cd-11ee-971f-72441c073636','메뉴 이름 중복 확인','메뉴 이름 중복 확인','/menu/check-name','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','menu','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('47b3ca8d-8643-11ef-9a6b-ba8787afde77','감사 로그 조회(관리자용)','감사 로그 조회(관리자용)','/dashboard/log/work','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','dashboard','GET',1,'bb6fa9a6-8443-11ee-a4fd-dadafdb14cb0',1)
    ,   ('47d73531-2167-11ef-922c-16fe18334070','ipmi power on from agent','ipmi power on from agent','/mole/ipmi-power-on','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','host','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('47d7abdf-2167-11ef-922c-16fe18334070','ipmi power off from agent','ipmi power off from agent','/mole/ipmi-power-off','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','host','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('47d7fca2-2167-11ef-922c-16fe18334070','volume restore','volume restore','/block-storage/volumes/backups/restore','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('47d92678-2167-11ef-922c-16fe18334070','os info read from agent','os info read from agent','/mole/os-info','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','host','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('47d95b96-2167-11ef-922c-16fe18334070','nic info read from agent','nic info read from agent','/mole/nic-info','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','host','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('47d99b01-2167-11ef-922c-16fe18334070','ipmi status read from agent','ipmi status read from agent','/mole/ipmi-status','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','mole','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('47d9d251-2167-11ef-922c-16fe18334070','read cpu allocation ratio','read cpu allocation ratio','/mole/cpu-allocation-ratio','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','vip','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('47da061a-2167-11ef-922c-16fe18334070','read volume backend names from mole agent','read volume backend names from mole agent','/mole/agent','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agent mole','vip','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('47da37eb-2167-11ef-922c-16fe18334070','ipmi power on from agent','ipmi power on from agent','/mole/ipmi-power-on','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','host','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('47da8051-2167-11ef-922c-16fe18334070','ipmi power off from agent','ipmi power off from agent','/mole/ipmi-power-off','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','host','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('47dab39c-2167-11ef-922c-16fe18334070','volume restore','volume restore','/block-storage/volumes/backups/restore','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('47daed58-2167-11ef-922c-16fe18334070','os info read from agent','os info read from agent','/mole/os-info','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','host','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('47db1df1-2167-11ef-922c-16fe18334070','nic info read from agent','nic info read from agent','/mole/nic-info','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','host','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('47db4bab-2167-11ef-922c-16fe18334070','ipmi status read from agent','ipmi status read from agent','/mole/ipmi-status','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','mole','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('47db8cf7-2167-11ef-922c-16fe18334070','read cpu allocation ratio','read cpu allocation ratio','/mole/cpu-allocation-ratio','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','vip','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('47dbbd27-2167-11ef-922c-16fe18334070','read volume backend names from mole agent','read volume backend names from mole agent','/mole/agent','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agent mole','vip','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('48053007-9ffc-11ef-8cfe-22e1909bc60f','볼륨 분리','볼륨 분리','/volumes/detach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volume','ebs','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('48059be5-9ffc-11ef-8cfe-22e1909bc60f','볼륨 연결','볼륨 연결','/volumes/attach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volume','ebs','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('4805cd99-9ffc-11ef-8cfe-22e1909bc60f','user : GET/autoscaling/launchconfiguration','user : GET/autoscaling/launchconfiguration','/autoscaling/launchconfiguration','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','launchconfiguration','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('4805f040-9ffc-11ef-8cfe-22e1909bc60f','user : POST/autoscaling/launchconfiguration','user : POST/autoscaling/launchconfiguration','/autoscaling/launchconfiguration','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','launchconfiguration','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('48060aaa-9ffc-11ef-8cfe-22e1909bc60f','시작 템플릿 삭제','시작 템플릿 삭제','/ec2/launchtemplates/{launchTemplateId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('48065cad-9ffc-11ef-8cfe-22e1909bc60f','시작 템플릿 버전 삭제','시작 템플릿 버전 삭제','/ec2/launchtemplates/{launchTemplateId}/versions/{version}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('4806794c-9ffc-11ef-8cfe-22e1909bc60f','user : DELETE/autoscaling/launchconfiguration/{deletename}','user : DELETE/autoscaling/launchconfiguration/{deletename}','/autoscaling/launchconfiguration/{deletename}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','launchconfiguration','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('4806a199-9ffc-11ef-8cfe-22e1909bc60f','볼륨 분리','볼륨 분리','/volumes/detach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volume','ebs','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4806c351-9ffc-11ef-8cfe-22e1909bc60f','볼륨 연결','볼륨 연결','/volumes/attach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volume','ebs','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4806dfa5-9ffc-11ef-8cfe-22e1909bc60f','admin : GET/autoscaling/launchconfiguration','admin : GET/autoscaling/launchconfiguration','/autoscaling/launchconfiguration','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','launchconfiguration','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4807252d-9ffc-11ef-8cfe-22e1909bc60f','admin : POST/autoscaling/launchconfiguration','admin : POST/autoscaling/launchconfiguration','/autoscaling/launchconfiguration','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','launchconfiguration','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('48074579-9ffc-11ef-8cfe-22e1909bc60f','시작 템플릿 삭제','시작 템플릿 삭제','/ec2/launchtemplates/{launchTemplateId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('480763f0-9ffc-11ef-8cfe-22e1909bc60f','시작 템플릿 버전 삭제','시작 템플릿 버전 삭제','/ec2/launchtemplates/{launchTemplateId}/versions/{version}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('480784e5-9ffc-11ef-8cfe-22e1909bc60f','admin : DELETE/autoscaling/launchconfiguration/{deletename}','admin : DELETE/autoscaling/launchconfiguration/{deletename}','/autoscaling/launchconfiguration/{deletename}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','launchconfiguration','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('481765e5-dc4a-11ee-84a7-5e1f35257281','서비스 신청 오브젝트 즐겨찾기 등록','서비스 신청 오브젝트 즐겨찾기 등록','/service-objects/requests/bookmark','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('4817d54b-dc4a-11ee-84a7-5e1f35257281','서비스 신청 오브젝트 즐겨찾기 삭제','서비스 신청 오브젝트 즐겨찾기 삭제','/service-objects/requests/bookmark/{serviceTypeId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','DELETE',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('485167be-142d-11f0-8e4c-52e9553a2057','워크스페이스에 배포된 서비스 카탈로그 목록 조회','워크스페이스에 배포된 서비스 카탈로그 목록 조회','/workspaces/{workspaceId}/service-catalogs','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('48529204-142d-11f0-8e4c-52e9553a2057','IP Pool 삭제','IP Pool 삭제','/ip-pool/{ipPoolId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','ip-pool','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('48658069-65da-11ef-aa9f-f2cdef6842ce','KubeConfig 인증서 조회','KubeConfig 인증서 조회','/v1/k8s/namespaces/{namespaceName}/serviceaccounts/{serviceAccountName}/kubeconfigs','345ae518-f857-11ed-921d-aa1950d374e1','Viola','serviceaccount','serviceaccount','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4865f684-65da-11ef-aa9f-f2cdef6842ce','KubeConfig 인증서 발급','KubeConfig 인증서 발급','/v1/k8s/namespaces/{namespaceName}/serviceaccounts/{serviceAccountName}/kubeconfigs','345ae518-f857-11ed-921d-aa1950d374e1','Viola','serviceaccount','serviceaccount','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('4866310d-65da-11ef-aa9f-f2cdef6842ce','KubeConfig 인증서 발급','KubeConfig 인증서 발급','/v1/k8s/namespaces/{namespaceName}/serviceaccounts/{serviceAccountName}/kubeconfigs/{kubeconfigId}/download','345ae518-f857-11ed-921d-aa1950d374e1','Viola','serviceaccount','serviceaccount','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('48666242-65da-11ef-aa9f-f2cdef6842ce','KubeConfig 인증서 조회','KubeConfig 인증서 조회','/v1/k8s/namespaces/{namespaceName}/serviceaccounts/{serviceAccountName}/kubeconfig-download-history','345ae518-f857-11ed-921d-aa1950d374e1','Viola','serviceaccount','serviceaccount','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('486690a2-65da-11ef-aa9f-f2cdef6842ce','KubeConfig 다운로드 이력 조회','KubeConfig 다운로드 이력 조회','/v1/k8s/namespaces/{namespaceName}/kubeconfigs-download-history','345ae518-f857-11ed-921d-aa1950d374e1','Viola','serviceaccount','serviceaccount','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('4866e53f-65da-11ef-aa9f-f2cdef6842ce','KubeConfig 다운로드 이력 조회','KubeConfig 다운로드 이력 조회','/v1/k8s/kubeconfigs-download-history','345ae518-f857-11ed-921d-aa1950d374e1','Viola','serviceaccount','serviceaccount','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('486730dc-65da-11ef-aa9f-f2cdef6842ce','KubeConfig 인증서 삭제','KubeConfig 인증서 삭제','/v1/k8s/namespaces/{namespaceName}/serviceaccounts/{serviceAccountName}/kubeconfigs/{kubeconfigId}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','serviceaccount','serviceaccount','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('486759f8-65da-11ef-aa9f-f2cdef6842ce','KubeConfig 인증서 조회','KubeConfig 인증서 조회','/v1/k8s/namespaces/{namespaceName}/serviceaccounts/{serviceAccountName}/kubeconfigs','345ae518-f857-11ed-921d-aa1950d374e1','Viola','serviceaccount','serviceaccount','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('486781bf-65da-11ef-aa9f-f2cdef6842ce','KubeConfig 인증서 발급','KubeConfig 인증서 발급','/v1/k8s/namespaces/{namespaceName}/serviceaccounts/{serviceAccountName}/kubeconfigs','345ae518-f857-11ed-921d-aa1950d374e1','Viola','serviceaccount','serviceaccount','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('4867a80f-65da-11ef-aa9f-f2cdef6842ce','KubeConfig 인증서 발급','KubeConfig 인증서 발급','/v1/k8s/namespaces/{namespaceName}/serviceaccounts/{serviceAccountName}/kubeconfigs/{kubeconfigId}/download','345ae518-f857-11ed-921d-aa1950d374e1','Viola','serviceaccount','serviceaccount','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('4867d07a-65da-11ef-aa9f-f2cdef6842ce','KubeConfig 인증서 조회','KubeConfig 인증서 조회','/v1/k8s/namespaces/{namespaceName}/serviceaccounts/{serviceAccountName}/kubeconfig-download-history','345ae518-f857-11ed-921d-aa1950d374e1','Viola','serviceaccount','serviceaccount','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('48680a8a-65da-11ef-aa9f-f2cdef6842ce','KubeConfig 다운로드 이력 조회','KubeConfig 다운로드 이력 조회','/v1/k8s/namespaces/{namespaceName}/kubeconfigs-download-history','345ae518-f857-11ed-921d-aa1950d374e1','Viola','serviceaccount','serviceaccount','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('486831eb-65da-11ef-aa9f-f2cdef6842ce','KubeConfig 다운로드 이력 조회','KubeConfig 다운로드 이력 조회','/v1/k8s/kubeconfigs-download-history','345ae518-f857-11ed-921d-aa1950d374e1','Viola','serviceaccount','serviceaccount','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('48685b82-65da-11ef-aa9f-f2cdef6842ce','KubeConfig 인증서 삭제','KubeConfig 인증서 삭제','/v1/k8s/namespaces/{namespaceName}/serviceaccounts/{serviceAccountName}/kubeconfigs/{kubeconfigId}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','serviceaccount','serviceaccount','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('4872c45f-d7bf-11ef-9c74-0a11b82fa8dd','작업이력 detailLog 조회','작업이력 detailLog 조회','/log/action/detail/{serviceTypeName}/{uuid}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','x-openstack-request-id','actionlog','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4873897e-d7bf-11ef-9c74-0a11b82fa8dd','작업이력 detailLog 조회','작업이력 detailLog 조회','/log/action/detail/{serviceTypeName}/{uuid}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','x-openstack-request-id','actionlog','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('48b1eba5-1e9c-11f0-b0f2-3e31076d3589','특정 계정 감사 로그 조회(관리자용)','특정 계정 감사 로그 조회(관리자용)','/log/work/{userId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','dashboard','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('490919e2-3e8c-11ef-9f42-5e230e3817dd','볼륨 id List 조회','볼륨 id List 조회','/volumes/by-volume','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volumes','volume','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('49095d9e-3e8c-11ef-9f42-5e230e3817dd','볼륨 id List 조회','볼륨 id List 조회','/volumes/by-volume','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volumes','volume','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('494d2eca-10dd-11ef-9fbf-8ef2ee3c3984','네트워크 목록 조회 API (자동 필터 적용)','네트워크 목록 조회 API (자동 필터 적용)','/network/networks/filter','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','network','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('495ac637-1437-11f0-8e4c-52e9553a2057','장치 리스트 조회','장치 리스트 조회','/v2/devices','910fa43a-7797-11ee-b465-565158862942','Vista','observability','device','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('495ca417-1437-11f0-8e4c-52e9553a2057','제조사 등록','제조사 등록','/v2/devices/vendor/{vendorName}','910fa43a-7797-11ee-b465-565158862942','Vista','observability','device','POST',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('495cdf2e-1437-11f0-8e4c-52e9553a2057','NetApp Storage 메트릭 조회','NetApp Storage 메트릭 조회','/v2/storages/metrics','910fa43a-7797-11ee-b465-565158862942','Vista','observability','storage','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('495d6edf-1437-11f0-8e4c-52e9553a2057','NetApp Storage 디스크 목록 조회','NetApp Storage 디스크 목록 조회','/v2/storages/disks','910fa43a-7797-11ee-b465-565158862942','Vista','observability','storage','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('495dba76-1437-11f0-8e4c-52e9553a2057','장치 상세 조회','장치 상세 조회','/v2/devices/{deviceId}','910fa43a-7797-11ee-b465-565158862942','Vista','observability','device','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('495df513-1437-11f0-8e4c-52e9553a2057','장치 삭제','장치 삭제','/v2/devices/{deviceId}','910fa43a-7797-11ee-b465-565158862942','Vista','observability','device','DELETE',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('495e2a85-1437-11f0-8e4c-52e9553a2057','제조사 조회','제조사 조회','/v2/devices/vendor','910fa43a-7797-11ee-b465-565158862942','Vista','observability','device','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('495e5c05-1437-11f0-8e4c-52e9553a2057','장치 현황 조회','장치 현황 조회','/v2/devices/status','910fa43a-7797-11ee-b465-565158862942','Vista','observability','device','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('495e8e73-1437-11f0-8e4c-52e9553a2057','스태킹 가능한 스위치 목록 조회','스태킹 가능한 스위치 목록 조회','/v2/devices/stackable','910fa43a-7797-11ee-b465-565158862942','Vista','observability','device','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('495ec701-1437-11f0-8e4c-52e9553a2057','OID 타입 조회','OID 타입 조회','/v2/devices/oid/types','910fa43a-7797-11ee-b465-565158862942','Vista','observability','device','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('495ef40f-1437-11f0-8e4c-52e9553a2057','제조사 삭제','제조사 삭제','/v2/devices/vendor/{vendorId}','910fa43a-7797-11ee-b465-565158862942','Vista','observability','device','DELETE',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('49739488-10dd-11ef-9fbf-8ef2ee3c3984','volume backup list','volume backup list','/block-storage/volumes/backups/filter-by-id','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('49749518-10dd-11ef-9fbf-8ef2ee3c3984','volume backup schedule detail volume-backup-work-log-list','volume backup schedule detail volume-backup-work-log-list','/block-storage/volumes/backups/backups-schedule/worklog/{id}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('49db150a-36cd-11f0-80c3-6e593baabd40','특정 Region의 Trail 추적 Bucket 조회','특정 Region의 Trail 추적 Bucket 조회','/v1/job-producer/aws/trail/{provider_id}/buckets','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','job-producer','aws','GET',1,'96aae0f7-15e0-11f0-8e4c-52e9553a2057',0)
    ,   ('49dba28b-36cd-11f0-80c3-6e593baabd40','스케줄러 목록 전체 조회 API','스케줄러 목록 전체 조회 API','/v1/job-producer/scheduler','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','job-producer','scheduler','GET',1,'96aae0f7-15e0-11f0-8e4c-52e9553a2057',0)
    ,   ('49dbdbbe-36cd-11f0-80c3-6e593baabd40','Asynq 스케줄러 상태 점검 API','Asynq 스케줄러 상태 점검 API','/v1/job-producer/scheduler/asynq','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','job-producer','scheduler','GET',1,'96aae0f7-15e0-11f0-8e4c-52e9553a2057',0)
    ,   ('49dc06a1-36cd-11f0-80c3-6e593baabd40','Asynq 스케줄러 아카이브 삭제 API','Asynq 스케줄러 아카이브 삭제 API','/v1/job-producer/scheduler/asynq','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','job-producer','scheduler','DELETE',1,'96aae0f7-15e0-11f0-8e4c-52e9553a2057',0)
    ,   ('49dc3895-36cd-11f0-80c3-6e593baabd40','공급자의 AWS 스케줄 목록 조회 API','공급자의 AWS 스케줄 목록 조회 API','/v1/job-producer/scheduler/aws/{provider_id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','job-producer','scheduler','GET',1,'96aae0f7-15e0-11f0-8e4c-52e9553a2057',0)
    ,   ('49dc8324-36cd-11f0-80c3-6e593baabd40','특정 스케줄러 조회 API','특정 스케줄러 조회 API','/v1/job-producer/scheduler/{provider_id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','job-producer','scheduler','GET',1,'96aae0f7-15e0-11f0-8e4c-52e9553a2057',0)
    ,   ('49dcb21e-36cd-11f0-80c3-6e593baabd40','수동 수집 트리거 API','수동 수집 트리거 API','/v1/job-producer/scheduler/{provider_id}/collect','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','job-producer','scheduler','POST',1,'96aae0f7-15e0-11f0-8e4c-52e9553a2057',0)
    ,   ('49dcde39-36cd-11f0-80c3-6e593baabd40','스케줄러 수정 API','스케줄러 수정 API','/v1/job-producer/scheduler/{provider_id}/{task_name}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','job-producer','scheduler','PUT',1,'96aae0f7-15e0-11f0-8e4c-52e9553a2057',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('49dd0f64-36cd-11f0-80c3-6e593baabd40','Task Requests 조회 API','Task Requests 조회 API','/v1/job-producer/tasks/requests','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','job-producer','tasks','POST',1,'96aae0f7-15e0-11f0-8e4c-52e9553a2057',0)
    ,   ('49dd340d-36cd-11f0-80c3-6e593baabd40','Task Results 조회 API','Task Results 조회 API','/v1/job-producer/tasks/results','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','job-producer','tasks','POST',1,'96aae0f7-15e0-11f0-8e4c-52e9553a2057',0)
    ,   ('49dd52cf-36cd-11f0-80c3-6e593baabd40','Tag 제거','Tag 제거','/vcenter/tag-associations/detach','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag','PUT',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49dd709b-36cd-11f0-80c3-6e593baabd40','Tag 할당','Tag 할당','/vcenter/tag-associations/attach','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag','PUT',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49dd933d-36cd-11f0-80c3-6e593baabd40','물리적 어댑터 데이터 리스트 조회 API','물리적 어댑터 데이터 리스트 조회 API','/vcenter/switches/dvs/{dvsId}/physical-adapter','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ddbf26-36cd-11f0-80c3-6e593baabd40','분산 스위치의 물리 어댑터 수정 API','분산 스위치의 물리 어댑터 수정 API','/vcenter/switches/dvs/{dvsId}/physical-adapter','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','PUT',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49dde013-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - VMware Audit','엑셀 다운로드 - VMware Audit','/vmwareAudit/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49de030d-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 가상머신','엑셀 다운로드 - 가상머신','/vms/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49de2c72-36cd-11f0-80c3-6e593baabd40','VM 리스트 조회','VM 리스트 조회','/vcenter/vms','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49de63df-36cd-11f0-80c3-6e593baabd40','가상머신 생성','가상머신 생성','/vcenter/vms','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49de9a56-36cd-11f0-80c3-6e593baabd40','가상머신의 네트워크 조회','가상머신의 네트워크 조회','/vcenter/vms/{vm-id}/networks','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49dec7cb-36cd-11f0-80c3-6e593baabd40','가상머신에 네트워크 등록','가상머신에 네트워크 등록','/vcenter/vms/{vm-id}/networks','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49defaee-36cd-11f0-80c3-6e593baabd40','스크립트 실행','스크립트 실행','/vcenter/vms/{vm-id}/invoke-vm-scripts','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49df1edc-36cd-11f0-80c3-6e593baabd40','가상머신 동기화','가상머신 동기화','/vcenter/vms/sync','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','virtualmachine','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49df426f-36cd-11f0-80c3-6e593baabd40','가상머신 전원 관리','가상머신 전원 관리','/vcenter/vms/power','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49df7182-36cd-11f0-80c3-6e593baabd40','가상머신들의 현재상태를 DB에 저장','가상머신들의 현재상태를 DB에 저장','/vcenter/vms/batch','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49df9a29-36cd-11f0-80c3-6e593baabd40','Workspace 와 Tenant 연결 상태 매칭 정보 조회','Workspace 와 Tenant 연결 상태 매칭 정보 조회','/vcenter/tenant/compute-resources/connection-status','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49dfe160-36cd-11f0-80c3-6e593baabd40','Workspace 와 Tenant 연결 상태 매칭 정보 조회','Workspace 와 Tenant 연결 상태 매칭 정보 조회','/vcenter/tenants/compute-resources/connection-status','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e0090d-36cd-11f0-80c3-6e593baabd40','단일 템플릿 조회','단일 템플릿 조회','/vcenter/templates/{template-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','template','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e02dfe-36cd-11f0-80c3-6e593baabd40','템플릿 복제','템플릿 복제','/vcenter/templates/{template-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','template','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('49e06532-36cd-11f0-80c3-6e593baabd40','템플릿 삭제','템플릿 삭제','/vcenter/templates/{template-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','template','DELETE',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e09bca-36cd-11f0-80c3-6e593baabd40','Tag 리스트 조회','Tag 리스트 조회','/vcenter/tags','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e0c6ce-36cd-11f0-80c3-6e593baabd40','Tag 생성','Tag 생성','/vcenter/tags','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e0ee48-36cd-11f0-80c3-6e593baabd40','Tag 카테고리 리스트 조회','Tag 카테고리 리스트 조회','/vcenter/tag-categories','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag-category','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e117ee-36cd-11f0-80c3-6e593baabd40','Tag 카테고리 등록','Tag 카테고리 등록','/vcenter/tag-categories','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag-category','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e14515-36cd-11f0-80c3-6e593baabd40','할당된 Tag 리스트 조회','할당된 Tag 리스트 조회','/vcenter/tag-associations','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e177c8-36cd-11f0-80c3-6e593baabd40','할당된 Tag 리스트 조회','할당된 Tag 리스트 조회','/vcenter/tag-associations','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e19ae6-36cd-11f0-80c3-6e593baabd40','스위치 리스트 조회 API','스위치 리스트 조회 API','/vcenter/switches','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e1d74b-36cd-11f0-80c3-6e593baabd40','스위치 등록 API','스위치 등록 API','/vcenter/switches','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e1fca0-36cd-11f0-80c3-6e593baabd40','분산 스위치의 호스트 멤버 추가','분산 스위치의 호스트 멤버 추가','/vcenter/switches/{dvs-id}/host-members','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e22127-36cd-11f0-80c3-6e593baabd40','가상머신의 스냅샷 등록','가상머신의 스냅샷 등록','/vcenter/snapshot/{vm-id}/snapshots','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','snapshot','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e23de8-36cd-11f0-80c3-6e593baabd40','스냅샷 되돌리기','스냅샷 되돌리기','/vcenter/snapshot/{vm-id}/snapshots/{snapshot-id}/revert','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','snapshot','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e2618e-36cd-11f0-80c3-6e593baabd40','리소스풀 리스트 조회','리소스풀 리스트 조회','/vcenter/resource-pools','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','resourcepool','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e27b3c-36cd-11f0-80c3-6e593baabd40','리소스풀 등록','리소스풀 등록','/vcenter/resource-pools','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','resourcepool','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e29523-36cd-11f0-80c3-6e593baabd40','다수 프로젝트 등록','다수 프로젝트 등록','/vcenter/projects/bulk-register','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','project','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e2b36b-36cd-11f0-80c3-6e593baabd40','포트그룹 목록 조회','포트그룹 목록 조회','/vcenter/portgroups','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','network','portgroup','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e2cb89-36cd-11f0-80c3-6e593baabd40','포트그룹 생성','포트그룹 생성','/vcenter/portgroups','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','network','portgroup','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e2e33e-36cd-11f0-80c3-6e593baabd40','Library Id 리스트 조회','Library Id 리스트 조회','/vcenter/libraries','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','other','library','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e303b9-36cd-11f0-80c3-6e593baabd40','Library 등록','Library 등록','/vcenter/libraries','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','other','library','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e32bd1-36cd-11f0-80c3-6e593baabd40','폴더 리스트 조회','폴더 리스트 조회','/vcenter/folders','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','folder','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('49e35915-36cd-11f0-80c3-6e593baabd40','폴더 등록','폴더 등록','/vcenter/folders','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','folder','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e399aa-36cd-11f0-80c3-6e593baabd40','프로젝트 동기화 (prune)','프로젝트 동기화 (prune)','/vcenter/folders/sync','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','folder','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e3c955-36cd-11f0-80c3-6e593baabd40','플레이버 목록 조회','플레이버 목록 조회','/vcenter/flavors','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','flavor','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e3e908-36cd-11f0-80c3-6e593baabd40','플레이버 등록','플레이버 등록','/vcenter/flavors','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','flavor','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e410e0-36cd-11f0-80c3-6e593baabd40','플레이버 수정','플레이버 수정','/vcenter/flavors','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','flavor','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e4395a-36cd-11f0-80c3-6e593baabd40','데이터스토어 목록 조회','데이터스토어 목록 조회','/vcenter/datastores','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastore','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e4781f-36cd-11f0-80c3-6e593baabd40','데이터스토어 등록','데이터스토어 등록','/vcenter/datastores','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastore','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e49e73-36cd-11f0-80c3-6e593baabd40','데이터스토어 클러스터 리스트 정보 조회','데이터스토어 클러스터 리스트 정보 조회','/vcenter/datastore-clusters','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastorecluster','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e4bd97-36cd-11f0-80c3-6e593baabd40','데이터스토어 클러스터 생성','데이터스토어 클러스터 생성','/vcenter/datastore-clusters','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastorecluster','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e4dcef-36cd-11f0-80c3-6e593baabd40','데이터스토어 클러스터에 데이터스토어 추가','데이터스토어 클러스터에 데이터스토어 추가','/vcenter/datastore-clusters/{datastore-cluster-id}/datastore-members','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastorecluster','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e4f854-36cd-11f0-80c3-6e593baabd40','데이터센터 목록 조회','데이터센터 목록 조회','/vcenter/datacenters','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','datacenter','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e52430-36cd-11f0-80c3-6e593baabd40','데이터센터 등록','데이터센터 등록','/vcenter/datacenters','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','datacenter','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e54233-36cd-11f0-80c3-6e593baabd40','클러스터 목록 조회','클러스터 목록 조회','/vcenter/clusters','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','cluster','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e566ed-36cd-11f0-80c3-6e593baabd40','클러스터 등록','클러스터 등록','/vcenter/clusters','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','cluster','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e5a0a6-36cd-11f0-80c3-6e593baabd40','클러스터에 호스트 추가','클러스터에 호스트 추가','/vcenter/clusters/{cluster-id}/hosts/{host-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','cluster','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e5ca24-36cd-11f0-80c3-6e593baabd40','로그인 테스트','로그인 테스트','/vcenter/auth','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','auth','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e5e81f-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 알람','엑셀 다운로드 - 알람','/triggered-alarms/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e6060a-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - Tier-1','엑셀 다운로드 - Tier-1','/tier-1s/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e6322e-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - Tier-0','엑셀 다운로드 - Tier-0','/tier-0s/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e6604f-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 템플릿','엑셀 다운로드 - 템플릿','/template/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('49e68461-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 스위치','엑셀 다운로드 - 스위치','/switch/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e6a5a9-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 스위치(표준)','엑셀 다운로드 - 스위치(표준)','/switch-svs/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e6cf71-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 스위치(분산)','엑셀 다운로드 - 스위치(분산)','/switch-dvs/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e6fec9-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 세그먼트','엑셀 다운로드 - 세그먼트','/segments/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e72163-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 포트그룹','엑셀 다운로드 - 포트그룹','/portgroups/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e740a0-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 포트그룹(표준)','엑셀 다운로드 - 포트그룹(표준)','/portgroups-std/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e75cc4-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 포트그룹(분산)','엑셀 다운로드 - 포트그룹(분산)','/portgroups-dv/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e777e2-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 로드밸런서','엑셀 다운로드 - 로드밸런서','/loadbalancer/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e79ba3-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 가상서버','엑셀 다운로드 - 가상서버','/lbvs/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e7bd1c-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - LbPool','엑셀 다운로드 - LbPool','/lbpool/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e7dd6d-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 호스트','엑셀 다운로드 - 호스트','/host/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e804b0-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 플레이버','엑셀 다운로드 - 플레이버','/flavors/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e823b2-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 분산방화벽','엑셀 다운로드 - 분산방화벽','/dfw/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e845c5-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 데이터스토어','엑셀 다운로드 - 데이터스토어','/datastores/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e87df9-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 데이터센터','엑셀 다운로드 - 데이터센터','/datacenter/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e8ac34-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 클러스터','엑셀 다운로드 - 클러스터','/cluster/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e8d215-36cd-11f0-80c3-6e593baabd40','단일 가상머신 조회','단일 가상머신 조회','/vcenter/vms/{vm-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e8f8f0-36cd-11f0-80c3-6e593baabd40','가상머신 삭제','가상머신 삭제','/vcenter/vms/{vm-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','DELETE',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e91fd8-36cd-11f0-80c3-6e593baabd40','가상머신 수정','가상머신 수정','/vcenter/vms/{vm-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e947e6-36cd-11f0-80c3-6e593baabd40','가상머신 이름 변경','가상머신 이름 변경','/vcenter/vms/{vm-id}/rename','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
;	
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('49e96a4e-36cd-11f0-80c3-6e593baabd40','가상머신 원격 제어 수정','가상머신 원격 제어 수정','/vcenter/vms/{vm-id}/enable-remote-control','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e9882c-36cd-11f0-80c3-6e593baabd40','가상머신 커스터마이징 수정','가상머신 커스터마이징 수정','/vcenter/vms/{vm-id}/customize','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e9c642-36cd-11f0-80c3-6e593baabd40','템플릿 수정','템플릿 수정','/vcenter/templates/{template-or-vm-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','template','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e9e51e-36cd-11f0-80c3-6e593baabd40','템플릿 이름 변경','템플릿 이름 변경','/vcenter/templates/{template-id}/rename','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','template','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49e9ffc8-36cd-11f0-80c3-6e593baabd40','단일 Tag 조회','단일 Tag 조회','/vcenter/tags/{tag-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ea1b62-36cd-11f0-80c3-6e593baabd40','Tag 삭제','Tag 삭제','/vcenter/tags/{tag-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag','DELETE',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ea3b0e-36cd-11f0-80c3-6e593baabd40','Tag 수정','Tag 수정','/vcenter/tags/{tag-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ea59b8-36cd-11f0-80c3-6e593baabd40','단일 Tag 카테고리 조회','단일 Tag 카테고리 조회','/vcenter/tag-categories/{tag-category-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag-category','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ea71e8-36cd-11f0-80c3-6e593baabd40','Tag 카테고리 삭제','Tag 카테고리 삭제','/vcenter/tag-categories/{tag-category-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag-category','DELETE',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ea8add-36cd-11f0-80c3-6e593baabd40','Tag 카테고리 수정','Tag 카테고리 수정','/vcenter/tag-categories/{tag-category-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag-category','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49eaa3dd-36cd-11f0-80c3-6e593baabd40','스위치 삭제 API','스위치 삭제 API','/vcenter/switches/{switch-name}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','DELETE',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49eabe49-36cd-11f0-80c3-6e593baabd40','스위치 수정 API','스위치 수정 API','/vcenter/switches/{switch-name}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ead7af-36cd-11f0-80c3-6e593baabd40','특정 표준 스위치의 물리 어댑터 조회','특정 표준 스위치의 물리 어댑터 조회','/vcenter/switches/svs/{switch-name}/physical-adapter','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49eafbcb-36cd-11f0-80c3-6e593baabd40','특정 표준 스위치의 물리 어댑터 수정','특정 표준 스위치의 물리 어댑터 수정','/vcenter/switches/svs/{switch-name}/physical-adapter','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49eb1b8f-36cd-11f0-80c3-6e593baabd40','스냅샷 삭제','스냅샷 삭제','/vcenter/snapshot/{vm-id}/snapshots/{snapshot-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','snapshot','DELETE',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49eb418e-36cd-11f0-80c3-6e593baabd40','스냅샷 수정','스냅샷 수정','/vcenter/snapshot/{vm-id}/snapshots/{snapshot-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','snapshot','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49eb600c-36cd-11f0-80c3-6e593baabd40','리소스풀 수정','리소스풀 수정','/vcenter/resource-pools/{resource-pool-id}/rename','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','resourcepool','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49eb8854-36cd-11f0-80c3-6e593baabd40','Provider 선택','Provider 선택','/vcenter/provider/{id}/{subId}/selection/{initYN}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ebb0a7-36cd-11f0-80c3-6e593baabd40','Tenant의 북마크 여부 수정','Tenant의 북마크 여부 수정','/vcenter/provider/tenantBookMark/{parentId}/{id}/{bookMarkYN}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ebd237-36cd-11f0-80c3-6e593baabd40','Provider의 북마크 여부 수정','Provider의 북마크 여부 수정','/vcenter/provider/providerBookMark/{parentId}/{id}/{bookMarkYN}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('49ebf0e7-36cd-11f0-80c3-6e593baabd40','단일 포트그룹 조회','단일 포트그룹 조회','/vcenter/portgroups/{portgroup-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','network','portgroup','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ec115b-36cd-11f0-80c3-6e593baabd40','단일 포트그룹 삭제','단일 포트그룹 삭제','/vcenter/portgroups/{portgroup-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','network','portgroup','DELETE',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ec3144-36cd-11f0-80c3-6e593baabd40','포트그룹 수정','포트그룹 수정','/vcenter/portgroups/{portgroup-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','network','portgroup','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ec554a-36cd-11f0-80c3-6e593baabd40','호스트 이름 변경','호스트 이름 변경','/vcenter/hosts/{host-id}/rename','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','host','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ec7b1e-36cd-11f0-80c3-6e593baabd40','폴더 이름 수정','폴더 이름 수정','/vcenter/folders/{folder-id}/rename','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','folder','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ec9aa3-36cd-11f0-80c3-6e593baabd40','가상자원 폴더 이동','가상자원 폴더 이동','/vcenter/folders/move','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','folder','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ecc278-36cd-11f0-80c3-6e593baabd40','데이터스토어 이름변경','데이터스토어 이름변경','/vcenter/datastores/{datastore-id}/rename','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastore','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ecf1f7-36cd-11f0-80c3-6e593baabd40','데이터스토어 용량 증가','데이터스토어 용량 증가','/vcenter/datastores/{datastore-id}/expand-capacity','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','datastore','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ed2437-36cd-11f0-80c3-6e593baabd40','데이터스토어 클러스터 이름 변경','데이터스토어 클러스터 이름 변경','/vcenter/datastore-clusters/{datastore-cluster-id}/rename','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastorecluster','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ed5bf4-36cd-11f0-80c3-6e593baabd40','데이터스토어 클러스터 DRS 설정 조회','데이터스토어 클러스터 DRS 설정 조회','/vcenter/datastore-clusters/{datastore-cluster-id}/drs-config','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastorecluster','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ed9594-36cd-11f0-80c3-6e593baabd40','데이터스토어 클러스터 DRS 설정 수정','데이터스토어 클러스터 DRS 설정 수정','/vcenter/datastore-clusters/{datastore-cluster-id}/drs-config','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastorecluster','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49edbb61-36cd-11f0-80c3-6e593baabd40','데이터센터 이름 변경','데이터센터 이름 변경','/vcenter/datacenters/{datacenter-id}/rename','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','datacenter','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ede071-36cd-11f0-80c3-6e593baabd40','클러스터 이름 변경','클러스터 이름 변경','/vcenter/clusters/{cluster-id}/rename','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','cluster','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ee0ab8-36cd-11f0-80c3-6e593baabd40','클러스터 DRS 설정 조회','클러스터 DRS 설정 조회','/vcenter/clusters/{cluster-id}/drs-config','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','cluster','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ee3385-36cd-11f0-80c3-6e593baabd40','단일 클러스터 DRS 설정 수정','단일 클러스터 DRS 설정 수정','/vcenter/clusters/{cluster-id}/drs-config','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','cluster','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ee517b-36cd-11f0-80c3-6e593baabd40','웹 콘솔 티켓 조회','웹 콘솔 티켓 조회','/vcenter/vms/{vm-id}/web-console-ticket','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ee7146-36cd-11f0-80c3-6e593baabd40','동기화를 하려는 가상머신 리스트 조회','동기화를 하려는 가상머신 리스트 조회','/vcenter/vms/sync/{provider-no}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','virtualmachine','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ee9533-36cd-11f0-80c3-6e593baabd40','가상머신 이름 중복 검사','가상머신 이름 중복 검사','/vcenter/vms/names/{desired-name}/is-taken','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49eebfa7-36cd-11f0-80c3-6e593baabd40','사용 가능한 ip 주소인지 조회','사용 가능한 ip 주소인지 조회','/vcenter/vms/ip/{ipv4-address}/is-taken','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49eedb16-36cd-11f0-80c3-6e593baabd40','사용중인 IP 조회','사용중인 IP 조회','/vcenter/vms/ip-addresses-in-use','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('49eef8d6-36cd-11f0-80c3-6e593baabd40','게스트 OS 리스트 조회','게스트 OS 리스트 조회','/vcenter/vms/guestos/list','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ef14e2-36cd-11f0-80c3-6e593baabd40','가상머신 만기일자 조회','가상머신 만기일자 조회','/vcenter/vms/expiry-date/{vm-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','virtualmachine','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ef341d-36cd-11f0-80c3-6e593baabd40','가상머신 전원 상태 조회','가상머신 전원 상태 조회','/vcenter/vms/areVmsOff','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ef5f69-36cd-11f0-80c3-6e593baabd40','Cluster, Host 단위 Tenant 상태 매칭 정보 조회','Cluster, Host 단위 Tenant 상태 매칭 정보 조회','/vcenter/tenant/compute-resources/status','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ef8d7b-36cd-11f0-80c3-6e593baabd40','Cluster, Host 단위 Tenant 상태 매칭 정보 조회','Cluster, Host 단위 Tenant 상태 매칭 정보 조회','/vcenter/tenants/compute-resources/status','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49efac44-36cd-11f0-80c3-6e593baabd40','Cluster, Stand Alone Host 단위 Tenant 정보 조회','Cluster, Stand Alone Host 단위 Tenant 정보 조회','/vcenter/tenant/compute-resources','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49efd506-36cd-11f0-80c3-6e593baabd40','Cluster, Stand Alone Host 단위 Tenant 정보 조회','Cluster, Stand Alone Host 단위 Tenant 정보 조회','/vcenter/tenants/compute-resources','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f000af-36cd-11f0-80c3-6e593baabd40','Tenant 정보 조회','Tenant 정보 조회','/vcenter/tenant','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f02765-36cd-11f0-80c3-6e593baabd40','Tenant 정보 조회','Tenant 정보 조회','/vcenter/tenants','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f0595c-36cd-11f0-80c3-6e593baabd40','템플릿 목록 조회','템플릿 목록 조회','/vcenter/templates','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','template','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f084b5-36cd-11f0-80c3-6e593baabd40','태스크 목록 조회','태스크 목록 조회','/vcenter/tasks','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','other','task','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f0a892-36cd-11f0-80c3-6e593baabd40','단일 태스크 조회','단일 태스크 조회','/vcenter/tasks/{task-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','other','task','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f0c788-36cd-11f0-80c3-6e593baabd40','태스크 취소','태스크 취소','/vcenter/tasks/{task-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','other','task','DELETE',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f0e72b-36cd-11f0-80c3-6e593baabd40','Tag 이름 중복 확인','Tag 이름 중복 확인','/vcenter/tags/names/{category-id}/{desired-name}/is-taken','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f10faa-36cd-11f0-80c3-6e593baabd40','Tag 카테고리(범주) 이름 중복 확인','Tag 카테고리(범주) 이름 중복 확인','/vcenter/tag-categories/names/{desired-name}/is-taken','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag-category','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f130f2-36cd-11f0-80c3-6e593baabd40','개별 스위치 조회 API','개별 스위치 조회 API','/vcenter/switches/{switch-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f15026-36cd-11f0-80c3-6e593baabd40','특정 표준 스위치의 물리 어댑터 MacAddr 조회','특정 표준 스위치의 물리 어댑터 MacAddr 조회','/vcenter/switches/svs/{switch-name}/physical-adapter-mac-address','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f16cbe-36cd-11f0-80c3-6e593baabd40','스위치 이름 중복 검사','스위치 이름 중복 검사','/vcenter/switches/names/{switch-name}/is-taken','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f189d1-36cd-11f0-80c3-6e593baabd40','특정 dvs를 사용하는 호스트 조회 API','특정 dvs를 사용하는 호스트 조회 API','/vcenter/switches/hosts-using-dvs/{dvsId}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f1a641-36cd-11f0-80c3-6e593baabd40','스냅샷 조회','스냅샷 조회','/vcenter/snapshot','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','snapshot','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('49f1c25f-36cd-11f0-80c3-6e593baabd40','스냅샷 이름 중복 확인','스냅샷 이름 중복 확인','/vcenter/snapshot/{vm-id}/name/{desired-name}/is-taken','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','snapshot','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f1e972-36cd-11f0-80c3-6e593baabd40','가상머신의 스냅샷 조회','가상머신의 스냅샷 조회','/vcenter/snapshot/{root-snapshot-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','snapshot','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f20667-36cd-11f0-80c3-6e593baabd40','resource 조회','resource 조회','/vcenter/resources','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','resource','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f2217d-36cd-11f0-80c3-6e593baabd40','메트릭 데이터 단일 object 조회','메트릭 데이터 단일 object 조회','/vcenter/resources/{object-id}/metric-data','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','metric','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f24502-36cd-11f0-80c3-6e593baabd40','네트워크 토폴로지 조회','네트워크 토폴로지 조회','/vcenter/resources/topology','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','networktopology','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f267b1-36cd-11f0-80c3-6e593baabd40','메트릭 데이터 조회','메트릭 데이터 조회','/vcenter/resources/metric-data','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','metric','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f285ee-36cd-11f0-80c3-6e593baabd40','메트릭 데이터 데이터스토어 조회','메트릭 데이터 데이터스토어 조회','/vcenter/resources/metric-data/datastore','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','metric','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f29fcd-36cd-11f0-80c3-6e593baabd40','단일 리소스풀 조회','단일 리소스풀 조회','/vcenter/resource-pools/{resource-pool-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','resourcepool','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f2b707-36cd-11f0-80c3-6e593baabd40','리소스풀 삭제','리소스풀 삭제','/vcenter/resource-pools/{resource-pool-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','resourcepool','DELETE',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f2de1e-36cd-11f0-80c3-6e593baabd40','Provider 리스트 조회','Provider 리스트 조회','/vcenter/provider','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f2ff01-36cd-11f0-80c3-6e593baabd40','포트그룹 이름 중복 검사','포트그룹 이름 중복 검사','/vcenter/portgroups/names/{portgroup-name}/is-taken','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','network','portgroup','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f31b6c-36cd-11f0-80c3-6e593baabd40','관리자 콘솔에서 VM 메타 리스트 조회','관리자 콘솔에서 VM 메타 리스트 조회','/vcenter/meta/vms','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f33afe-36cd-11f0-80c3-6e593baabd40','호스트 메타 목록 조회','호스트 메타 목록 조회','/vcenter/meta/hosts','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','host','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f358a8-36cd-11f0-80c3-6e593baabd40','데이터스토어 목록 메타 조회','데이터스토어 목록 메타 조회','/vcenter/meta/datastores','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastore','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f37b8d-36cd-11f0-80c3-6e593baabd40','조건에 맞는 객체 조회','조건에 맞는 객체 조회','/vcenter/master','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','other','master','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f39bb7-36cd-11f0-80c3-6e593baabd40','조건에 맞는 모든 객체 조회','조건에 맞는 모든 객체 조회','/vcenter/master/everything','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','other','master','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f3b8d0-36cd-11f0-80c3-6e593baabd40','단일 Library 조회','단일 Library 조회','/vcenter/libraries/{library-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','other','library','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f3ecf6-36cd-11f0-80c3-6e593baabd40','가상머신/템플릿 인벤토리 조회','가상머신/템플릿 인벤토리 조회','/vcenter/inventory/vm','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','inventory','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f410eb-36cd-11f0-80c3-6e593baabd40','스토리지 인벤토리 조회','스토리지 인벤토리 조회','/vcenter/inventory/storage','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','inventory','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f42e0a-36cd-11f0-80c3-6e593baabd40','네트워크 인벤토리 조회','네트워크 인벤토리 조회','/vcenter/inventory/network','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','inventory','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('49f44cbd-36cd-11f0-80c3-6e593baabd40','호스트/클러스터 인벤토리 조회','호스트/클러스터 인벤토리 조회','/vcenter/inventory/host','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','inventory','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f46ce0-36cd-11f0-80c3-6e593baabd40','호스트 목록 조회','호스트 목록 조회','/vcenter/hosts','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','host','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f48878-36cd-11f0-80c3-6e593baabd40','단일 호스트 조회','단일 호스트 조회','/vcenter/hosts/{host-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','host','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f4abdb-36cd-11f0-80c3-6e593baabd40','호스트의 사용가능 리스트 조회','호스트의 사용가능 리스트 조회','/vcenter/hosts/{host-id}/vmfs/availDiskList','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','host','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f4ce57-36cd-11f0-80c3-6e593baabd40','단일 폴더 조회','단일 폴더 조회','/vcenter/folders/{folder-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','folder','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f4ef6c-36cd-11f0-80c3-6e593baabd40','폴더 삭제','폴더 삭제','/vcenter/folders/{folder-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','folder','DELETE',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f512c6-36cd-11f0-80c3-6e593baabd40','폴더 하위 resource 조회','폴더 하위 resource 조회','/vcenter/folders/{folder-id}/managed-objects','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','folder','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f53ce5-36cd-11f0-80c3-6e593baabd40','하위 폴더 조회','하위 폴더 조회','/vcenter/folders/subfolders','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','folder','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f563fe-36cd-11f0-80c3-6e593baabd40','단일 플레이버 조회','단일 플레이버 조회','/vcenter/flavors/{flavor-no}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','flavor','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f5860d-36cd-11f0-80c3-6e593baabd40','플레이버 삭제','플레이버 삭제','/vcenter/flavors/{flavor-no}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','flavor','DELETE',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f5a1ca-36cd-11f0-80c3-6e593baabd40','플레이버 이름 중복 검사','플레이버 이름 중복 검사','/vcenter/flavors/names/{flavor-name}/is-taken','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','flavor','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f5c803-36cd-11f0-80c3-6e593baabd40','이벤트 리스트 조회','이벤트 리스트 조회','/vcenter/events','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','other','event','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f5ed89-36cd-11f0-80c3-6e593baabd40','단일 데이터스토어 조회','단일 데이터스토어 조회','/vcenter/datastores/{datastore-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastore','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f61d4c-36cd-11f0-80c3-6e593baabd40','데이터스토어 삭제','데이터스토어 삭제','/vcenter/datastores/{datastore-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastore','DELETE',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f64a9e-36cd-11f0-80c3-6e593baabd40','데이터스토어 최대 용량 조회','데이터스토어 최대 용량 조회','/vcenter/datastores/{datastore-id}/max-capacity','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','datastore','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f66c46-36cd-11f0-80c3-6e593baabd40','데이터스토어 이름 중복 검사','데이터스토어 이름 중복 검사','/vcenter/datastores/names/{desired-name}/is-taken','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastore','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f69659-36cd-11f0-80c3-6e593baabd40','데이터스토어 생성 옵션 조회','데이터스토어 생성 옵션 조회','/vcenter/datastores/create-option','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastore','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f6c56e-36cd-11f0-80c3-6e593baabd40','데이터스토어 클러스터 단건 상세 정보 조회','데이터스토어 클러스터 단건 상세 정보 조회','/vcenter/datastore-clusters/{datastore-cluster-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastorecluster','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f6e79a-36cd-11f0-80c3-6e593baabd40','데이터스토어 클러스터 삭제','데이터스토어 클러스터 삭제','/vcenter/datastore-clusters/{datastore-cluster-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastorecluster','DELETE',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f712f2-36cd-11f0-80c3-6e593baabd40','단일 데이터센터 조회','단일 데이터센터 조회','/vcenter/datacenters/{datacenter-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','datacenter','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('49f733d7-36cd-11f0-80c3-6e593baabd40','데이터센터 삭제','데이터센터 삭제','/vcenter/datacenters/{datacenter-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','datacenter','DELETE',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f755c8-36cd-11f0-80c3-6e593baabd40','데이터센터 이름 중복 검사','데이터센터 이름 중복 검사','/vcenter/datacenters/names/{desired-name}/is-taken','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','datacenter','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f7778b-36cd-11f0-80c3-6e593baabd40','단일 클러스터 조회','단일 클러스터 조회','/vcenter/clusters/{cluster-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','cluster','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f79a2c-36cd-11f0-80c3-6e593baabd40','클러스터 삭제','클러스터 삭제','/vcenter/clusters/{cluster-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','cluster','DELETE',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f7b995-36cd-11f0-80c3-6e593baabd40','클러스터 이름 중복 확인','클러스터 이름 중복 확인','/vcenter/clusters/names/{desired-name}/is-taken','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','cluster','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f7db9a-36cd-11f0-80c3-6e593baabd40','alarm리스트 조회','alarm리스트 조회','/vcenter/alarms/triggered-alarms','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','other','alarm','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f7fab7-36cd-11f0-80c3-6e593baabd40','단일 alarm 조회','단일 alarm 조회','/vcenter/alarms/specific-triggered-alarms/{entityId}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','other','alarm','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f81799-36cd-11f0-80c3-6e593baabd40','분산 스위치의 호스트 멤버 제거','분산 스위치의 호스트 멤버 제거','/vcenter/switches/{dvs-id}/host-members/{host-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','DELETE',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f83a17-36cd-11f0-80c3-6e593baabd40','데이터스토어 클러스터에 데이터스토어 맴버 해제','데이터스토어 클러스터에 데이터스토어 맴버 해제','/vcenter/datastore-clusters/{datastore-cluster-id}/datastore-members/{datastore-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastorecluster','DELETE',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f85a6a-36cd-11f0-80c3-6e593baabd40','공급자 정보 조회','공급자 정보 조회','/nsx/provider','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx','provider','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f87d4c-36cd-11f0-80c3-6e593baabd40','공급자 정보 수정','공급자 정보 수정','/nsx/provider','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx','provider','PUT',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f8992a-36cd-11f0-80c3-6e593baabd40','Tier-1 리스트 조회','Tier-1 리스트 조회','/nsx/tier-1s','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-1','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f8b681-36cd-11f0-80c3-6e593baabd40','Tier-1 게이트웨이 생성','Tier-1 게이트웨이 생성','/nsx/tier-1s','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-1','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f8d239-36cd-11f0-80c3-6e593baabd40','Tier-1 게이트웨이 조회','Tier-1 게이트웨이 조회','/nsx/tier-1s/{tier1-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-1','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f8f455-36cd-11f0-80c3-6e593baabd40','Tier-1 게이트웨이 생성','Tier-1 게이트웨이 생성','/nsx/tier-1s/{tier1-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-1','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f90edd-36cd-11f0-80c3-6e593baabd40','Tier-1 게이트웨이 삭제','Tier-1 게이트웨이 삭제','/nsx/tier-1s/{tier1-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-1','DELETE',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f929ed-36cd-11f0-80c3-6e593baabd40','Tier-1 게이트웨이 수정','Tier-1 게이트웨이 수정','/nsx/tier-1s/{tier1-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-1','PATCH',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f94490-36cd-11f0-80c3-6e593baabd40','Tier-0 리스트 조회','Tier-0 리스트 조회','/nsx/tier-0s','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-0','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f96191-36cd-11f0-80c3-6e593baabd40','Tier-0 생성','Tier-0 생성','/nsx/tier-0s','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-0','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f97aa6-36cd-11f0-80c3-6e593baabd40','Tier-0 단일 조회','Tier-0 단일 조회','/nsx/tier-0s/{tier0-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-0','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('49f9958d-36cd-11f0-80c3-6e593baabd40','Tier-0 생성','Tier-0 생성','/nsx/tier-0s/{tier0-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-0','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f9cdc5-36cd-11f0-80c3-6e593baabd40','Tier-0 삭제','Tier-0 삭제','/nsx/tier-0s/{tier0-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-0','DELETE',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49f9fa1a-36cd-11f0-80c3-6e593baabd40','Tier-0 수정','Tier-0 수정','/nsx/tier-0s/{tier0-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-0','PATCH',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fa1d04-36cd-11f0-80c3-6e593baabd40','세그먼트 리스트 조회','세그먼트 리스트 조회','/nsx/segments','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','segment','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fa4d74-36cd-11f0-80c3-6e593baabd40','세그먼트 생성','세그먼트 생성','/nsx/segments','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','segment','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fa7c4d-36cd-11f0-80c3-6e593baabd40','세그먼트 단일 조회','세그먼트 단일 조회','/nsx/segments/{segment-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','segment','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49faa432-36cd-11f0-80c3-6e593baabd40','세그먼트 생성','세그먼트 생성','/nsx/segments/{segment-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','segment','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fac487-36cd-11f0-80c3-6e593baabd40','세그먼트 삭제','세그먼트 삭제','/nsx/segments/{segment-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','segment','DELETE',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fadd40-36cd-11f0-80c3-6e593baabd40','세그먼트 수정','세그먼트 수정','/nsx/segments/{segment-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','segment','PATCH',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fafa1a-36cd-11f0-80c3-6e593baabd40','공급자 연동 테스트','공급자 연동 테스트','/nsx/provider/connect-test','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx','provider','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fb1efe-36cd-11f0-80c3-6e593baabd40','Tier-1 NAT Rule 리스트 조회','Tier-1 NAT Rule 리스트 조회','/nsx/nat/tier-1s/{tier-1-id}/rules','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nat','rules','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fb3936-36cd-11f0-80c3-6e593baabd40','Tier-1 NAT Rule 생성','Tier-1 NAT Rule 생성','/nsx/nat/tier-1s/{tier-1-id}/rules','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nat','rules','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fb56dc-36cd-11f0-80c3-6e593baabd40','Tier-0 NAT Rule 리스트 조회','Tier-0 NAT Rule 리스트 조회','/nsx/nat/tier-0s/{tier-0-id}/rules','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nat','rules','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fb728a-36cd-11f0-80c3-6e593baabd40','Tier-0 NAT Rule 생성','Tier-0 NAT Rule 생성','/nsx/nat/tier-0s/{tier-0-id}/rules','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nat','rules','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fb8c41-36cd-11f0-80c3-6e593baabd40','가상서버 리스트 조회','가상서버 리스트 조회','/nsx/lb-virtual-servers','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','virtualserver','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fbb762-36cd-11f0-80c3-6e593baabd40','가상서버 생성','가상서버 생성','/nsx/lb-virtual-servers','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','virtualserver','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fbe27f-36cd-11f0-80c3-6e593baabd40','가상서버 단일 조회','가상서버 단일 조회','/nsx/lb-virtual-servers/{lb-virtual-server-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','virtualserver','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fc06ea-36cd-11f0-80c3-6e593baabd40','가상서버 생성','가상서버 생성','/nsx/lb-virtual-servers/{lb-virtual-server-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','virtualserver','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fc2255-36cd-11f0-80c3-6e593baabd40','가상서버 삭제','가상서버 삭제','/nsx/lb-virtual-servers/{lb-virtual-server-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','virtualserver','DELETE',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fc416c-36cd-11f0-80c3-6e593baabd40','가상서버 수정','가상서버 수정','/nsx/lb-virtual-servers/{lb-virtual-server-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','virtualserver','PATCH',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('49fc6472-36cd-11f0-80c3-6e593baabd40','로드 밸런서 리스트 조회','로드 밸런서 리스트 조회','/nsx/lb-services','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','loadbalancer','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fc7ce7-36cd-11f0-80c3-6e593baabd40','로드 밸런서 생성','로드 밸런서 생성','/nsx/lb-services','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','loadbalancer','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fc9757-36cd-11f0-80c3-6e593baabd40','단일 서버 SSL 프로파일 조회','단일 서버 SSL 프로파일 조회','/nsx/lb-server-ssl-profiles/{lb-server-ssl-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkservice','serversslprofile','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fcb10e-36cd-11f0-80c3-6e593baabd40','단일 서버 SSL 프로파일 생성','단일 서버 SSL 프로파일 생성','/nsx/lb-server-ssl-profiles/{lb-server-ssl-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkservice','serversslprofile','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fcd2e5-36cd-11f0-80c3-6e593baabd40','서버 SSL 프로파일 삭제','서버 SSL 프로파일 삭제','/nsx/lb-server-ssl-profiles/{lb-server-ssl-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkservice','serversslprofile','DELETE',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fcf25d-36cd-11f0-80c3-6e593baabd40','단일 서버 SSL 프로파일 수정','단일 서버 SSL 프로파일 수정','/nsx/lb-server-ssl-profiles/{lb-server-ssl-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkservice','serversslprofile','PATCH',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fd0f26-36cd-11f0-80c3-6e593baabd40','로드 밸런서 Pool 리스트 조회','로드 밸런서 Pool 리스트 조회','/nsx/lb-pools','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','lbpool','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fd2d15-36cd-11f0-80c3-6e593baabd40','로드 밸런서 Pool 생성','로드 밸런서 Pool 생성','/nsx/lb-pools','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','lbpool','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fd5407-36cd-11f0-80c3-6e593baabd40','로드 밸런서 Pool 단일 조회','로드 밸런서 Pool 단일 조회','/nsx/lb-pools/{lb-pool-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','lbpool','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fd80f1-36cd-11f0-80c3-6e593baabd40','로드 밸런서 Pool 생성','로드 밸런서 Pool 생성','/nsx/lb-pools/{lb-pool-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','lbpool','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fda550-36cd-11f0-80c3-6e593baabd40','로드 밸런서 Pool 삭제','로드 밸런서 Pool 삭제','/nsx/lb-pools/{lb-pool-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','lbpool','DELETE',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fdca79-36cd-11f0-80c3-6e593baabd40','로드 밸런서 Pool 수정','로드 밸런서 Pool 수정','/nsx/lb-pools/{lb-pool-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','lbpool','PATCH',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fde987-36cd-11f0-80c3-6e593baabd40','단일 Persistence Profile 조회','단일 Persistence Profile 조회','/nsx/lb-persistence-profiles/{lb-persistence-profiles}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','persistenceprofile','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fe0186-36cd-11f0-80c3-6e593baabd40','Persistence Profile 생성','Persistence Profile 생성','/nsx/lb-persistence-profiles/{lb-persistence-profiles}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','persistenceprofile','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fe2300-36cd-11f0-80c3-6e593baabd40','Persistence Profile 삭제','Persistence Profile 삭제','/nsx/lb-persistence-profiles/{lb-persistence-profiles}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','persistenceprofile','DELETE',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fe4541-36cd-11f0-80c3-6e593baabd40','Persistence Profile 수정','Persistence Profile 수정','/nsx/lb-persistence-profiles/{lb-persistence-profiles}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','persistenceprofile','PATCH',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fe6547-36cd-11f0-80c3-6e593baabd40','단일 모니터 프로파일 조회','단일 모니터 프로파일 조회','/nsx/lb-monitor-profiles/{lb-monitor-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','monitor','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fe8902-36cd-11f0-80c3-6e593baabd40','모니터 프로파일 생성','모니터 프로파일 생성','/nsx/lb-monitor-profiles/{lb-monitor-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','monitor','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49feaa97-36cd-11f0-80c3-6e593baabd40','모니터 프로파일 삭제','모니터 프로파일 삭제','/nsx/lb-monitor-profiles/{lb-monitor-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','monitor','DELETE',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fec981-36cd-11f0-80c3-6e593baabd40','모니터 프로파일 수정','모니터 프로파일 수정','/nsx/lb-monitor-profiles/{lb-monitor-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','monitor','PATCH',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('49fee789-36cd-11f0-80c3-6e593baabd40','단일 클라이언트 SSL 프로파일 조회','단일 클라이언트 SSL 프로파일 조회','/nsx/lb-client-ssl-profiles/{lb-client-ssl-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkservice','clientsslprofile','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ff0720-36cd-11f0-80c3-6e593baabd40','클라이언트 SSL 프로파일 생성','클라이언트 SSL 프로파일 생성','/nsx/lb-client-ssl-profiles/{lb-client-ssl-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkservice','clientsslprofile','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ff219e-36cd-11f0-80c3-6e593baabd40','클라이언트 SSL 프로파일 삭제','클라이언트 SSL 프로파일 삭제','/nsx/lb-client-ssl-profiles/{lb-client-ssl-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkservice','clientsslprofile','DELETE',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ff3ef0-36cd-11f0-80c3-6e593baabd40','클라이언트 SSL 프로파일 수정','클라이언트 SSL 프로파일 수정','/nsx/lb-client-ssl-profiles/{lb-client-ssl-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkservice','clientsslprofile','PATCH',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ff5ff6-36cd-11f0-80c3-6e593baabd40','단일 Lb 앱 프로파일 조회','단일 Lb 앱 프로파일 조회','/nsx/lb-app-profiles/{lb-app-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','appprofile','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ff791d-36cd-11f0-80c3-6e593baabd40','Lb 앱 프로파일 생성','Lb 앱 프로파일 생성','/nsx/lb-app-profiles/{lb-app-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','appprofile','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ff91a1-36cd-11f0-80c3-6e593baabd40','Lb 앱 프로파일 삭제','Lb 앱 프로파일 삭제','/nsx/lb-app-profiles/{lb-app-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','appprofile','DELETE',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ffb38e-36cd-11f0-80c3-6e593baabd40','Lb 앱 프로파일 수정','Lb 앱 프로파일 수정','/nsx/lb-app-profiles/{lb-app-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','appprofile','PATCH',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49ffd170-36cd-11f0-80c3-6e593baabd40','Inventory Service 리스트 조회','Inventory Service 리스트 조회','/nsx/inventory/services','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','inventory','services','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('49fff641-36cd-11f0-80c3-6e593baabd40','Service 생성','Service 생성','/nsx/inventory/services','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','inventory','services','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a00126a-36cd-11f0-80c3-6e593baabd40','게이트웨이 방화벽 정책 기준 rule 생성','게이트웨이 방화벽 정책 기준 rule 생성','/nsx/gfw/domains/{domainId}/{gfw-policy-id}/rules','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0030cf-36cd-11f0-80c3-6e593baabd40','GFW 방화벽 쟁책 생성','GFW 방화벽 쟁책 생성','/nsx/gfw/domains/{domainId}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a004f77-36cd-11f0-80c3-6e593baabd40','분산 방화벽의 정책 내부 단일 룰 조회','분산 방화벽의 정책 내부 단일 룰 조회','/nsx/dfw/{dfw-id}/rules/{dfw-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','distributedfirewall','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a006c25-36cd-11f0-80c3-6e593baabd40','분산 방화벽의 정책 내부 단일 룰 생성','분산 방화벽의 정책 내부 단일 룰 생성','/nsx/dfw/{dfw-id}/rules/{dfw-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','distributedfirewall','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a00a11c-36cd-11f0-80c3-6e593baabd40','분산 방화벽의 정책 내부 단일 룰 삭제','분산 방화벽의 정책 내부 단일 룰 삭제','/nsx/dfw/{dfw-id}/rules/{dfw-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','distributedfirewall','DELETE',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a00c889-36cd-11f0-80c3-6e593baabd40','분산 방화벽의 정책 내부 단일 룰 수정','분산 방화벽의 정책 내부 단일 룰 수정','/nsx/dfw/{dfw-id}/rules/{dfw-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','distributedfirewall','PATCH',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a00f88f-36cd-11f0-80c3-6e593baabd40','분산 방화벽의 정책 내부 단일 룰 생성','분산 방화벽의 정책 내부 단일 룰 생성','/nsx/dfw/{dfw-id}/rules','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','distributedfirewall','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a011722-36cd-11f0-80c3-6e593baabd40','분산 방화벽 정책 조회','분산 방화벽 정책 조회','/nsx/dfw/{dfw-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','distributedfirewall','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a013af9-36cd-11f0-80c3-6e593baabd40','분산 방화벽 쟁책 등록','분산 방화벽 쟁책 등록','/nsx/dfw/{dfw-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','distributedfirewall','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0157ee-36cd-11f0-80c3-6e593baabd40','분산 방화벽 정책 삭제','분산 방화벽 정책 삭제','/nsx/dfw/{dfw-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','distributedfirewall','DELETE',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a0176b1-36cd-11f0-80c3-6e593baabd40','분산 방화벽 정책 수정','분산 방화벽 정책 수정','/nsx/dfw/{dfw-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','distributedfirewall','PATCH',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a018ee3-36cd-11f0-80c3-6e593baabd40','분산 방화벽 리스트 조회','분산 방화벽 리스트 조회','/nsx/dfw','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','distributedfirewall','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a01aa97-36cd-11f0-80c3-6e593baabd40','분산 방화벽 쟁책 등록','분산 방화벽 쟁책 등록','/nsx/dfw','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','distributedfirewall','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a01c2cc-36cd-11f0-80c3-6e593baabd40','공급자 연동 테스트','공급자 연동 테스트','/nsx-alb/provider/connect-test','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','provider','POST',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a01e463-36cd-11f0-80c3-6e593baabd40','Tier-1 NAT Rule 단일 조회','Tier-1 NAT Rule 단일 조회','/nsx/nat/tier-1s/{tier-1-id}/rules/{nat-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nat','rules','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0208bc-36cd-11f0-80c3-6e593baabd40','Tier-1 NAT Rule 삭제','Tier-1 NAT Rule 삭제','/nsx/nat/tier-1s/{tier-1-id}/rules/{nat-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nat','rules','DELETE',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a022b6e-36cd-11f0-80c3-6e593baabd40','Tier-1 NAT Rule 수정','Tier-1 NAT Rule 수정','/nsx/nat/tier-1s/{tier-1-id}/rules/{nat-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nat','rules','PATCH',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a024766-36cd-11f0-80c3-6e593baabd40','Tier-0 NAT Rule 단일 조회','Tier-0 NAT Rule 단일 조회','/nsx/nat/tier-0s/{tier-0-id}/rules/{nat-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nat','rules','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a026a52-36cd-11f0-80c3-6e593baabd40','Tier-0 NAT Rule 삭제','Tier-0 NAT Rule 삭제','/nsx/nat/tier-0s/{tier-0-id}/rules/{nat-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nat','rules','DELETE',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0288d3-36cd-11f0-80c3-6e593baabd40','Tier-0 NAT Rule 수정','Tier-0 NAT Rule 수정','/nsx/nat/tier-0s/{tier-0-id}/rules/{nat-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nat','rules','PATCH',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a02abaa-36cd-11f0-80c3-6e593baabd40','로드 밸런서 단일 조회','로드 밸런서 단일 조회','/nsx/lb-services/{lb-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','loadbalancer','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a02d01e-36cd-11f0-80c3-6e593baabd40','로드 밸런서 삭제','로드 밸런서 삭제','/nsx/lb-services/{lb-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','loadbalancer','DELETE',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a02f4ed-36cd-11f0-80c3-6e593baabd40','로드 밸런서 수정','로드 밸런서 수정','/nsx/lb-services/{lb-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','loadbalancer','PATCH',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a03178d-36cd-11f0-80c3-6e593baabd40','게이트웨이 방화벽 정책 기준 rule 수정','게이트웨이 방화벽 정책 기준 rule 수정','/nsx/gfw/domains/{domainId}/{gfw-policy-id}/rules/{gfw-policy-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','PATCH',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a03367f-36cd-11f0-80c3-6e593baabd40','GFW 방화벽 쟁책 수정','GFW 방화벽 쟁책 수정','/nsx/gfw/domains/{domainId}/{gfw-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','PATCH',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a035609-36cd-11f0-80c3-6e593baabd40','단일 서버풀 조회','단일 서버풀 조회','/nsx-alb/pool/{pool-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','pool','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0376ec-36cd-11f0-80c3-6e593baabd40','서버풀 수정','서버풀 수정','/nsx-alb/pool/{pool-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','pool','PATCH',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a03a062-36cd-11f0-80c3-6e593baabd40','Transport zone 리스트 조회','Transport zone 리스트 조회','/nsx/transport-zones','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','transportzone','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a03d132-36cd-11f0-80c3-6e593baabd40','Tier-1 게이트웨이의 edge 클러스터 조회','Tier-1 게이트웨이의 edge 클러스터 조회','/nsx/tier-1s/{tier1-id}/locale-services','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-1','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a03fc98-36cd-11f0-80c3-6e593baabd40','Tier-1 게이트웨이의 edge 조회','Tier-1 게이트웨이의 edge 조회','/nsx/tier-1s/{tier1-id}/locale-services/{locale-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-1','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a041c4f-36cd-11f0-80c3-6e593baabd40','Tier-0의 locale 리스트 조회','Tier-0의 locale 리스트 조회','/nsx/tier-0s/{tier0-id}/locale-services','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-0','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a04441e-36cd-11f0-80c3-6e593baabd40','Tier-0의 단일 locale 조회','Tier-0의 단일 locale 조회','/nsx/tier-0s/{tier0-id}/locale-services/{locale-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-0','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a04675a-36cd-11f0-80c3-6e593baabd40','Service Profile 리스트 조회','Service Profile 리스트 조회','/nsx/service-profiles','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','inventory','serviceprofile','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a048db2-36cd-11f0-80c3-6e593baabd40','단일 가상서버 조회','단일 가상서버 조회','/nsx/networking/network-services/load-balancing/virtual-servers/{lb-virtual-server-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancingview','virtualserver','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a04aad6-36cd-11f0-80c3-6e593baabd40','가상서버 리스트 조회','가상서버 리스트 조회','/nsx/networking/network-services/load-balancing/virtual-servers','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancingview','virtualserver','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a04c5b7-36cd-11f0-80c3-6e593baabd40','가상서버 리스트 조회','가상서버 리스트 조회','/nsx/networking/network-services/load-balancing/virtual-servers/','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancingview','virtualserver','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a04f568-36cd-11f0-80c3-6e593baabd40','로드 밸런서 Pool 단일 조회','로드 밸런서 Pool 단일 조회','/nsx/networking/network-services/load-balancing/server-pools/{lb-pool-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancingview','lbpool','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a05214b-36cd-11f0-80c3-6e593baabd40','로드 밸런서 Pool 리스트를 조회','로드 밸런서 Pool 리스트를 조회','/nsx/networking/network-services/load-balancing/server-pools','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancingview','lbpool','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a054243-36cd-11f0-80c3-6e593baabd40','로드 밸런서 Pool 리스트를 조회','로드 밸런서 Pool 리스트를 조회','/nsx/networking/network-services/load-balancing/server-pools/','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancingview','lbpool','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0565b2-36cd-11f0-80c3-6e593baabd40','로드 밸런서 단일 조회','로드 밸런서 단일 조회','/nsx/networking/network-services/load-balancing/load-balancers/{lb-services-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancingview','loadbalancer','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a058200-36cd-11f0-80c3-6e593baabd40','로드 밸런서 리스트 조회','로드 밸런서 리스트 조회','/nsx/networking/network-services/load-balancing/load-balancers','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancingview','loadbalancer','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a05a2d6-36cd-11f0-80c3-6e593baabd40','로드 밸런서 리스트 조회','로드 밸런서 리스트 조회','/nsx/networking/network-services/load-balancing/load-balancers/','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancingview','loadbalancer','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a063af8-36cd-11f0-80c3-6e593baabd40','Tier-1 단일 조회','Tier-1 단일 조회','/nsx/networking/connectivity/tier-1s/{tier1-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnectionview','tier-1','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a06786e-36cd-11f0-80c3-6e593baabd40','Tier-1 리스트 조회','Tier-1 리스트 조회','/nsx/networking/connectivity/tier-1s','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnectionview','tier-1','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a06a899-36cd-11f0-80c3-6e593baabd40','Tier-1 리스트 조회','Tier-1 리스트 조회','/nsx/networking/connectivity/tier-1s/','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnectionview','tier-1','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a06cbab-36cd-11f0-80c3-6e593baabd40','Tier-0 단일 조회','Tier-0 단일 조회','/nsx/networking/connectivity/tier-0s/{tier0-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnectionview','tier-0','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a06eda4-36cd-11f0-80c3-6e593baabd40','Tier-0 리스트 조회','Tier-0 리스트 조회','/nsx/networking/connectivity/tier-0s','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnectionview','tier-0','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a07147e-36cd-11f0-80c3-6e593baabd40','Tier-0 리스트 조회','Tier-0 리스트 조회','/nsx/networking/connectivity/tier-0s/','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnectionview','tier-0','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0731be-36cd-11f0-80c3-6e593baabd40','세그먼트 단일 조회','세그먼트 단일 조회','/nsx/networking/connectivity/segments/{segment-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnectionview','segment','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a074bdd-36cd-11f0-80c3-6e593baabd40','세그먼트 리스트를 조회','세그먼트 리스트를 조회','/nsx/networking/connectivity/segments','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnectionview','segment','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a076cb2-36cd-11f0-80c3-6e593baabd40','세그먼트 리스트를 조회','세그먼트 리스트를 조회','/nsx/networking/connectivity/segments/','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnectionview','segment','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a07910d-36cd-11f0-80c3-6e593baabd40','SSL 프로파일 리스트 조회','SSL 프로파일 리스트 조회','/nsx/lb-ssl-profiles','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','sslprofile','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a07af1d-36cd-11f0-80c3-6e593baabd40','서버 SSL 프로파일 리스트 조회','서버 SSL 프로파일 리스트 조회','/nsx/lb-server-ssl-profiles','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkservice','serversslprofile','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a07d0bb-36cd-11f0-80c3-6e593baabd40','Persistence Profile 리스트 조회','Persistence Profile 리스트 조회','/nsx/lb-persistence-profiles','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','persistenceprofile','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a07f4c7-36cd-11f0-80c3-6e593baabd40','로드 밸런싱 모니터링 리스트 조회','로드 밸런싱 모니터링 리스트 조회','/nsx/lb-monitor-profiles','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','monitor','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0817ce-36cd-11f0-80c3-6e593baabd40','클라이언트 SSL 프로파일 리스트 조회','클라이언트 SSL 프로파일 리스트 조회','/nsx/lb-client-ssl-profiles','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkservice','clientsslprofile','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a084a37-36cd-11f0-80c3-6e593baabd40','Lb 앱 프로파일 리스트 조회','Lb 앱 프로파일 리스트 조회','/nsx/lb-app-profiles','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','appprofile','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0872b8-36cd-11f0-80c3-6e593baabd40','Inventory Service 단일 조회','Inventory Service 단일 조회','/nsx/inventory/services/{service}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','inventory','services','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a089e30-36cd-11f0-80c3-6e593baabd40','그룹 리스트 조회','그룹 리스트 조회','/nsx/groups','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','inventory','group','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a08c0b0-36cd-11f0-80c3-6e593baabd40','게이트웨이 방화벽 정책 단일 조회','게이트웨이 방화벽 정책 단일 조회','/nsx/gfw/{gfw-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a08e8d4-36cd-11f0-80c3-6e593baabd40','게이트웨이 방화벽 정책 삭제','게이트웨이 방화벽 정책 삭제','/nsx/gfw/{gfw-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','DELETE',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0913a5-36cd-11f0-80c3-6e593baabd40','게이트웨이 방화벽 Summary 조회','게이트웨이 방화벽 Summary 조회','/nsx/gfw/summary','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a094313-36cd-11f0-80c3-6e593baabd40','모든 게이트웨이 방화벽 정책에서 rule 리스트 조회','모든 게이트웨이 방화벽 정책에서 rule 리스트 조회','/nsx/gfw/rules','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a096c4f-36cd-11f0-80c3-6e593baabd40','게이트웨이 방화벽 단일 규칙 조회','게이트웨이 방화벽 단일 규칙 조회','/nsx/gfw/domains/{domainId}/{gfw-id}/rules/{gfw-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a099ca2-36cd-11f0-80c3-6e593baabd40','게이트웨이 방화벽 정책 기준 rule  삭제','게이트웨이 방화벽 정책 기준 rule  삭제','/nsx/gfw/domains/{domainId}/{gfw-id}/rules/{gfw-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','DELETE',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a09cdd6-36cd-11f0-80c3-6e593baabd40','게이트웨이 방화벽 정책 기준 rule 리스트 조회','게이트웨이 방화벽 정책 기준 rule 리스트 조회','/nsx/gfw/domains/{domainId}/{gfw-id}/rules','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a09f55c-36cd-11f0-80c3-6e593baabd40','게이트웨이 방화벽 리스트 조회','게이트웨이 방화벽 리스트 조회','/nsx/gfw','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0a1843-36cd-11f0-80c3-6e593baabd40','Enforcement 리스트 조회','Enforcement 리스트 조회','/nsx/enforcement','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','enforcement','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0a3aac-36cd-11f0-80c3-6e593baabd40','Enforcement 단일 조회','Enforcement 단일 조회','/nsx/enforcement/{enforcement-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','enforcement','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0a5cb6-36cd-11f0-80c3-6e593baabd40','Edge-Cluster 리스트 조회','Edge-Cluster 리스트 조회','/nsx/enforcement/{enforcement-id}/edge-clusters','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','enforcement','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a0a7a11-36cd-11f0-80c3-6e593baabd40','단일 edge-cluster 조회','단일 edge-cluster 조회','/nsx/enforcement/{enforcement-id}/edge-clusters/{cluster-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','enforcement','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0a97bd-36cd-11f0-80c3-6e593baabd40','클러스터의 edge-node 리스트 조회','클러스터의 edge-node 리스트 조회','/nsx/enforcement/{enforcement-id}/edge-clusters/{cluster-id}/edge-nodes','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','enforcement','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0ab1e2-36cd-11f0-80c3-6e593baabd40','클러스터의 edge-node 단일 조회','클러스터의 edge-node 단일 조회','/nsx/enforcement/{enforcement-id}/edge-clusters/{cluster-id}/edge-nodes/{node-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','enforcement','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0acb5a-36cd-11f0-80c3-6e593baabd40','Dashboard 리소스 조회','Dashboard 리소스 조회','/nsx/dashboard','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','dashboard','resource','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0af386-36cd-11f0-80c3-6e593baabd40','Context Profile 리스트 조회','Context Profile 리스트 조회','/nsx/context-profiles','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','inventory','contextprofile','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0b13a5-36cd-11f0-80c3-6e593baabd40','단일 VirtualService 조회','단일 VirtualService 조회','/nsx-alb/virtualservice/{virtualservice-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','virtualservice','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0b393c-36cd-11f0-80c3-6e593baabd40','VirtualService summary 단일 조회','VirtualService summary 단일 조회','/nsx-alb/virtualservice/summary/{virtualservice-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','virtualservice','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0b53cb-36cd-11f0-80c3-6e593baabd40','VirtualService summary 조회','VirtualService summary 조회','/nsx-alb/virtualservice/summary','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','virtualservice','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0b6ce2-36cd-11f0-80c3-6e593baabd40','VirtualService 단일 조회','VirtualService 단일 조회','/nsx-alb/virtualservice/inventory/{virtualservice-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','virtualservice','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0b8701-36cd-11f0-80c3-6e593baabd40','VirtualService 인벤토리 리스트 조회','VirtualService 인벤토리 리스트 조회','/nsx-alb/virtualservice/inventory','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','virtualservice','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0ba68f-36cd-11f0-80c3-6e593baabd40','VirtualService 리스트 조회','VirtualService 리스트 조회','/nsx-alb/virtualservice','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','virtualservice','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0bc0d8-36cd-11f0-80c3-6e593baabd40','서비스 엔진 조회','서비스 엔진 조회','/nsx-alb/serviceengine','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','serviceengine','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0bd97e-36cd-11f0-80c3-6e593baabd40','단일 서비스 엔진 조회','단일 서비스 엔진 조회','/nsx-alb/serviceengine/{serviceengine-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','serviceengine','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0bf562-36cd-11f0-80c3-6e593baabd40','인벤토리 조회','인벤토리 조회','/nsx-alb/serviceengine/inventory','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','serviceengine','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0c1f84-36cd-11f0-80c3-6e593baabd40','단일 서비스 엔진 조회','단일 서비스 엔진 조회','/nsx-alb/serviceengine/inventory/{serviceengine-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','serviceengine','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0c3f88-36cd-11f0-80c3-6e593baabd40','서버 풀 Summary 조회','서버 풀 Summary 조회','/nsx-alb/pool/summary/{pool-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','pool','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0c605c-36cd-11f0-80c3-6e593baabd40','서버 리스트 조회','서버 리스트 조회','/nsx-alb/pool/inventory/{pool-uuid}/servers','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','pool','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0c7f96-36cd-11f0-80c3-6e593baabd40','서버 풀 조회','서버 풀 조회','/nsx-alb/pool/inventory/{pool-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','pool','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0ca453-36cd-11f0-80c3-6e593baabd40','서버풀 인벤토리 조회','서버풀 인벤토리 조회','/nsx-alb/pool/inventory','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','pool','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0cccdf-36cd-11f0-80c3-6e593baabd40','서버풀 그룹 조회','서버풀 그룹 조회','/nsx-alb/pool/group','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','pool','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a0cf8a1-36cd-11f0-80c3-6e593baabd40','서버풀 리스트 조회','서버풀 리스트 조회','/nsx-alb/pool','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','pool','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0d245d-36cd-11f0-80c3-6e593baabd40','네트워크 리스트 조회','네트워크 리스트 조회','/nsx-alb/network','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','network','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0d5132-36cd-11f0-80c3-6e593baabd40','네트워크 단일 조회','네트워크 단일 조회','/nsx-alb/network/{network-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','network','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0d809b-36cd-11f0-80c3-6e593baabd40','네트워크 서브넷 리스트 조회','네트워크 서브넷 리스트 조회','/nsx-alb/network/subnet','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','network','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0da458-36cd-11f0-80c3-6e593baabd40','인벤토리 리스트 조회','인벤토리 리스트 조회','/nsx-alb/network/inventory','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','network','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0dd95e-36cd-11f0-80c3-6e593baabd40','인벤토리의 단일 네트워크 조회','인벤토리의 단일 네트워크 조회','/nsx-alb/network/inventory/{network-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','network','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0e011e-36cd-11f0-80c3-6e593baabd40','클러스터의 버전 조회','클러스터의 버전 조회','/nsx-alb/cluster/version','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','cluster','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0e1cf9-36cd-11f0-80c3-6e593baabd40','클라우드 리스트 조회','클라우드 리스트 조회','/nsx-alb/cloud','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','cloud','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0e3bad-36cd-11f0-80c3-6e593baabd40','단일 클라우드 조회','단일 클라우드 조회','/nsx-alb/cloud/{cloud-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','cloud','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0e5a5c-36cd-11f0-80c3-6e593baabd40','단일 네트워크 조회','단일 네트워크 조회','/nsx-alb/cloud/{cloud-uuid}/servers/{network-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','cloud','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0e76df-36cd-11f0-80c3-6e593baabd40','인벤토리 조회','인벤토리 조회','/nsx-alb/cloud/inventory','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','cloud','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0e92ed-36cd-11f0-80c3-6e593baabd40','단일 클라우드 조회','단일 클라우드 조회','/nsx-alb/cloud/inventory/{cloud-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','cloud','GET',1,'aa511cb9-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('4a0eb442-36cd-11f0-80c3-6e593baabd40','Tag 제거','Tag 제거','/vcenter/tag-associations/detach','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag','PUT',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a0ed3a1-36cd-11f0-80c3-6e593baabd40','Tag 할당','Tag 할당','/vcenter/tag-associations/attach','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag','PUT',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a0ef3fa-36cd-11f0-80c3-6e593baabd40','물리적 어댑터 데이터 리스트 조회 API','물리적 어댑터 데이터 리스트 조회 API','/vcenter/switches/dvs/{dvsId}/physical-adapter','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a0f10f3-36cd-11f0-80c3-6e593baabd40','분산 스위치의 물리 어댑터 수정 API','분산 스위치의 물리 어댑터 수정 API','/vcenter/switches/dvs/{dvsId}/physical-adapter','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','PUT',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a0f2dc3-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - VMware Audit','엑셀 다운로드 - VMware Audit','/vmwareAudit/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a0f4c55-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 가상머신','엑셀 다운로드 - 가상머신','/vms/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a0f6d2b-36cd-11f0-80c3-6e593baabd40','VM 리스트 조회','VM 리스트 조회','/vcenter/vms','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a0f90e8-36cd-11f0-80c3-6e593baabd40','가상머신 생성','가상머신 생성','/vcenter/vms','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a0fad26-36cd-11f0-80c3-6e593baabd40','가상머신의 네트워크 조회','가상머신의 네트워크 조회','/vcenter/vms/{vm-id}/networks','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a0fd588-36cd-11f0-80c3-6e593baabd40','가상머신에 네트워크 등록','가상머신에 네트워크 등록','/vcenter/vms/{vm-id}/networks','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a0ffd5b-36cd-11f0-80c3-6e593baabd40','스크립트 실행','스크립트 실행','/vcenter/vms/{vm-id}/invoke-vm-scripts','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1022d1-36cd-11f0-80c3-6e593baabd40','가상머신 동기화','가상머신 동기화','/vcenter/vms/sync','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','virtualmachine','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a10431e-36cd-11f0-80c3-6e593baabd40','가상머신 전원 관리','가상머신 전원 관리','/vcenter/vms/power','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a10604b-36cd-11f0-80c3-6e593baabd40','가상머신들의 현재상태를 DB에 저장','가상머신들의 현재상태를 DB에 저장','/vcenter/vms/batch','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a10800f-36cd-11f0-80c3-6e593baabd40','Workspace 와 Tenant 연결 상태 매칭 정보 조회','Workspace 와 Tenant 연결 상태 매칭 정보 조회','/vcenter/tenant/compute-resources/connection-status','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a10a236-36cd-11f0-80c3-6e593baabd40','Workspace 와 Tenant 연결 상태 매칭 정보 조회','Workspace 와 Tenant 연결 상태 매칭 정보 조회','/vcenter/tenants/compute-resources/connection-status','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a10c239-36cd-11f0-80c3-6e593baabd40','단일 템플릿 조회','단일 템플릿 조회','/vcenter/templates/{template-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','template','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a10ed28-36cd-11f0-80c3-6e593baabd40','템플릿 복제','템플릿 복제','/vcenter/templates/{template-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','template','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1111d6-36cd-11f0-80c3-6e593baabd40','템플릿 삭제','템플릿 삭제','/vcenter/templates/{template-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','template','DELETE',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a112f63-36cd-11f0-80c3-6e593baabd40','Tag 리스트 조회','Tag 리스트 조회','/vcenter/tags','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a114d93-36cd-11f0-80c3-6e593baabd40','Tag 생성','Tag 생성','/vcenter/tags','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a116b30-36cd-11f0-80c3-6e593baabd40','Tag 카테고리 리스트 조회','Tag 카테고리 리스트 조회','/vcenter/tag-categories','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag-category','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a118b33-36cd-11f0-80c3-6e593baabd40','Tag 카테고리 등록','Tag 카테고리 등록','/vcenter/tag-categories','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag-category','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a11a512-36cd-11f0-80c3-6e593baabd40','할당된 Tag 리스트 조회','할당된 Tag 리스트 조회','/vcenter/tag-associations','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a11c25b-36cd-11f0-80c3-6e593baabd40','할당된 Tag 리스트 조회','할당된 Tag 리스트 조회','/vcenter/tag-associations','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a11daf3-36cd-11f0-80c3-6e593baabd40','스위치 리스트 조회 API','스위치 리스트 조회 API','/vcenter/switches','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a11f875-36cd-11f0-80c3-6e593baabd40','스위치 등록 API','스위치 등록 API','/vcenter/switches','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a12139b-36cd-11f0-80c3-6e593baabd40','분산 스위치의 호스트 멤버 추가','분산 스위치의 호스트 멤버 추가','/vcenter/switches/{dvs-id}/host-members','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a123c2e-36cd-11f0-80c3-6e593baabd40','가상머신의 스냅샷 등록','가상머신의 스냅샷 등록','/vcenter/snapshot/{vm-id}/snapshots','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','snapshot','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1259c7-36cd-11f0-80c3-6e593baabd40','스냅샷 되돌리기','스냅샷 되돌리기','/vcenter/snapshot/{vm-id}/snapshots/{snapshot-id}/revert','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','snapshot','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1275e4-36cd-11f0-80c3-6e593baabd40','리소스풀 리스트 조회','리소스풀 리스트 조회','/vcenter/resource-pools','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','resourcepool','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1292c2-36cd-11f0-80c3-6e593baabd40','리소스풀 등록','리소스풀 등록','/vcenter/resource-pools','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','resourcepool','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a12af3b-36cd-11f0-80c3-6e593baabd40','다수 프로젝트 등록','다수 프로젝트 등록','/vcenter/projects/bulk-register','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','project','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a12caaa-36cd-11f0-80c3-6e593baabd40','포트그룹 목록 조회','포트그룹 목록 조회','/vcenter/portgroups','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','network','portgroup','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a12e84f-36cd-11f0-80c3-6e593baabd40','포트그룹 생성','포트그룹 생성','/vcenter/portgroups','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','network','portgroup','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a13044c-36cd-11f0-80c3-6e593baabd40','Library Id 리스트 조회','Library Id 리스트 조회','/vcenter/libraries','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','other','library','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a13235a-36cd-11f0-80c3-6e593baabd40','Library 등록','Library 등록','/vcenter/libraries','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','other','library','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a135c77-36cd-11f0-80c3-6e593baabd40','폴더 리스트 조회','폴더 리스트 조회','/vcenter/folders','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','folder','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1387b3-36cd-11f0-80c3-6e593baabd40','폴더 등록','폴더 등록','/vcenter/folders','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','folder','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a13a2c7-36cd-11f0-80c3-6e593baabd40','프로젝트 동기화 (prune)','프로젝트 동기화 (prune)','/vcenter/folders/sync','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','folder','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a13bdbe-36cd-11f0-80c3-6e593baabd40','플레이버 목록 조회','플레이버 목록 조회','/vcenter/flavors','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','flavor','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a13da01-36cd-11f0-80c3-6e593baabd40','플레이버 등록','플레이버 등록','/vcenter/flavors','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','flavor','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a13f496-36cd-11f0-80c3-6e593baabd40','플레이버 수정','플레이버 수정','/vcenter/flavors','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','flavor','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a141308-36cd-11f0-80c3-6e593baabd40','데이터스토어 목록 조회','데이터스토어 목록 조회','/vcenter/datastores','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastore','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a143460-36cd-11f0-80c3-6e593baabd40','데이터스토어 등록','데이터스토어 등록','/vcenter/datastores','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastore','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a146a6c-36cd-11f0-80c3-6e593baabd40','데이터스토어 클러스터 리스트 정보 조회','데이터스토어 클러스터 리스트 정보 조회','/vcenter/datastore-clusters','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastorecluster','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a14bda4-36cd-11f0-80c3-6e593baabd40','데이터스토어 클러스터 생성','데이터스토어 클러스터 생성','/vcenter/datastore-clusters','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastorecluster','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a14e064-36cd-11f0-80c3-6e593baabd40','데이터스토어 클러스터에 데이터스토어 추가','데이터스토어 클러스터에 데이터스토어 추가','/vcenter/datastore-clusters/{datastore-cluster-id}/datastore-members','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastorecluster','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a15009b-36cd-11f0-80c3-6e593baabd40','데이터센터 목록 조회','데이터센터 목록 조회','/vcenter/datacenters','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','datacenter','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a151b0d-36cd-11f0-80c3-6e593baabd40','데이터센터 등록','데이터센터 등록','/vcenter/datacenters','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','datacenter','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a153414-36cd-11f0-80c3-6e593baabd40','클러스터 목록 조회','클러스터 목록 조회','/vcenter/clusters','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','cluster','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a155359-36cd-11f0-80c3-6e593baabd40','클러스터 등록','클러스터 등록','/vcenter/clusters','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','cluster','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1574f0-36cd-11f0-80c3-6e593baabd40','클러스터에 호스트 추가','클러스터에 호스트 추가','/vcenter/clusters/{cluster-id}/hosts/{host-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','cluster','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a15971b-36cd-11f0-80c3-6e593baabd40','로그인 테스트','로그인 테스트','/vcenter/auth','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','auth','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a15c2d3-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 알람','엑셀 다운로드 - 알람','/triggered-alarms/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a16006b-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - Tier-1','엑셀 다운로드 - Tier-1','/tier-1s/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1636e4-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - Tier-0','엑셀 다운로드 - Tier-0','/tier-0s/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1658a1-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 템플릿','엑셀 다운로드 - 템플릿','/template/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a168200-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 스위치','엑셀 다운로드 - 스위치','/switch/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a16a8e5-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 스위치(표준)','엑셀 다운로드 - 스위치(표준)','/switch-svs/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a16ca2a-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 스위치(분산)','엑셀 다운로드 - 스위치(분산)','/switch-dvs/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a16ebc7-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 세그먼트','엑셀 다운로드 - 세그먼트','/segments/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a170914-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 포트그룹','엑셀 다운로드 - 포트그룹','/portgroups/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a17238c-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 포트그룹(표준)','엑셀 다운로드 - 포트그룹(표준)','/portgroups-std/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1741d7-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 포트그룹(분산)','엑셀 다운로드 - 포트그룹(분산)','/portgroups-dv/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a175c4f-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 로드밸런서','엑셀 다운로드 - 로드밸런서','/loadbalancer/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a177ffb-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 가상서버','엑셀 다운로드 - 가상서버','/lbvs/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a179a9c-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - LbPool','엑셀 다운로드 - LbPool','/lbpool/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a17bbc2-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 호스트','엑셀 다운로드 - 호스트','/host/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a17d549-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 플레이버','엑셀 다운로드 - 플레이버','/flavors/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a17ee92-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 분산방화벽','엑셀 다운로드 - 분산방화벽','/dfw/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a180f33-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 데이터스토어','엑셀 다운로드 - 데이터스토어','/datastores/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1829af-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 데이터센터','엑셀 다운로드 - 데이터센터','/datacenter/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a184203-36cd-11f0-80c3-6e593baabd40','엑셀 다운로드 - 클러스터','엑셀 다운로드 - 클러스터','/cluster/excel/download','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','excel','POST',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a185d2c-36cd-11f0-80c3-6e593baabd40','단일 가상머신 조회','단일 가상머신 조회','/vcenter/vms/{vm-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1876eb-36cd-11f0-80c3-6e593baabd40','가상머신 삭제','가상머신 삭제','/vcenter/vms/{vm-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','DELETE',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a18a41e-36cd-11f0-80c3-6e593baabd40','가상머신 수정','가상머신 수정','/vcenter/vms/{vm-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a18c645-36cd-11f0-80c3-6e593baabd40','가상머신 이름 변경','가상머신 이름 변경','/vcenter/vms/{vm-id}/rename','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a18ead6-36cd-11f0-80c3-6e593baabd40','가상머신 원격 제어 수정','가상머신 원격 제어 수정','/vcenter/vms/{vm-id}/enable-remote-control','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a190685-36cd-11f0-80c3-6e593baabd40','가상머신 커스터마이징 수정','가상머신 커스터마이징 수정','/vcenter/vms/{vm-id}/customize','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a19264d-36cd-11f0-80c3-6e593baabd40','템플릿 수정','템플릿 수정','/vcenter/templates/{template-or-vm-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','template','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1940f9-36cd-11f0-80c3-6e593baabd40','템플릿 이름 변경','템플릿 이름 변경','/vcenter/templates/{template-id}/rename','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','template','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a196896-36cd-11f0-80c3-6e593baabd40','단일 Tag 조회','단일 Tag 조회','/vcenter/tags/{tag-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1988d5-36cd-11f0-80c3-6e593baabd40','Tag 삭제','Tag 삭제','/vcenter/tags/{tag-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag','DELETE',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a19ae68-36cd-11f0-80c3-6e593baabd40','Tag 수정','Tag 수정','/vcenter/tags/{tag-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a19c816-36cd-11f0-80c3-6e593baabd40','단일 Tag 카테고리 조회','단일 Tag 카테고리 조회','/vcenter/tag-categories/{tag-category-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag-category','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a19e0dc-36cd-11f0-80c3-6e593baabd40','Tag 카테고리 삭제','Tag 카테고리 삭제','/vcenter/tag-categories/{tag-category-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag-category','DELETE',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a19fe35-36cd-11f0-80c3-6e593baabd40','Tag 카테고리 수정','Tag 카테고리 수정','/vcenter/tag-categories/{tag-category-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag-category','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a1a1702-36cd-11f0-80c3-6e593baabd40','스위치 삭제 API','스위치 삭제 API','/vcenter/switches/{switch-name}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','DELETE',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1a3e77-36cd-11f0-80c3-6e593baabd40','스위치 수정 API','스위치 수정 API','/vcenter/switches/{switch-name}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1a5f8c-36cd-11f0-80c3-6e593baabd40','특정 표준 스위치의 물리 어댑터 조회','특정 표준 스위치의 물리 어댑터 조회','/vcenter/switches/svs/{switch-name}/physical-adapter','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1a7ee2-36cd-11f0-80c3-6e593baabd40','특정 표준 스위치의 물리 어댑터 수정','특정 표준 스위치의 물리 어댑터 수정','/vcenter/switches/svs/{switch-name}/physical-adapter','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1a9ec5-36cd-11f0-80c3-6e593baabd40','스냅샷 삭제','스냅샷 삭제','/vcenter/snapshot/{vm-id}/snapshots/{snapshot-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','snapshot','DELETE',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1abc49-36cd-11f0-80c3-6e593baabd40','스냅샷 수정','스냅샷 수정','/vcenter/snapshot/{vm-id}/snapshots/{snapshot-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','snapshot','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1ad600-36cd-11f0-80c3-6e593baabd40','리소스풀 수정','리소스풀 수정','/vcenter/resource-pools/{resource-pool-id}/rename','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','resourcepool','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1aeec6-36cd-11f0-80c3-6e593baabd40','Provider 선택','Provider 선택','/vcenter/provider/{id}/{subId}/selection/{initYN}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1b1e79-36cd-11f0-80c3-6e593baabd40','Tenant의 북마크 여부 수정','Tenant의 북마크 여부 수정','/vcenter/provider/tenantBookMark/{parentId}/{id}/{bookMarkYN}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1b4fe4-36cd-11f0-80c3-6e593baabd40','Provider의 북마크 여부 수정','Provider의 북마크 여부 수정','/vcenter/provider/providerBookMark/{parentId}/{id}/{bookMarkYN}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1b6d83-36cd-11f0-80c3-6e593baabd40','단일 포트그룹 조회','단일 포트그룹 조회','/vcenter/portgroups/{portgroup-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','network','portgroup','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1b8ab4-36cd-11f0-80c3-6e593baabd40','단일 포트그룹 삭제','단일 포트그룹 삭제','/vcenter/portgroups/{portgroup-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','network','portgroup','DELETE',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1baeaa-36cd-11f0-80c3-6e593baabd40','포트그룹 수정','포트그룹 수정','/vcenter/portgroups/{portgroup-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','network','portgroup','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1bcffa-36cd-11f0-80c3-6e593baabd40','호스트 이름 변경','호스트 이름 변경','/vcenter/hosts/{host-id}/rename','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','host','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1beeaf-36cd-11f0-80c3-6e593baabd40','폴더 이름 수정','폴더 이름 수정','/vcenter/folders/{folder-id}/rename','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','folder','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1c181c-36cd-11f0-80c3-6e593baabd40','가상자원 폴더 이동','가상자원 폴더 이동','/vcenter/folders/move','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','folder','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1c38ba-36cd-11f0-80c3-6e593baabd40','데이터스토어 이름변경','데이터스토어 이름변경','/vcenter/datastores/{datastore-id}/rename','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastore','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1c531f-36cd-11f0-80c3-6e593baabd40','데이터스토어 용량 증가','데이터스토어 용량 증가','/vcenter/datastores/{datastore-id}/expand-capacity','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','datastore','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1cbb52-36cd-11f0-80c3-6e593baabd40','데이터스토어 클러스터 이름 변경','데이터스토어 클러스터 이름 변경','/vcenter/datastore-clusters/{datastore-cluster-id}/rename','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastorecluster','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1cbf15-8e8b-11ee-a47a-a6869ab29cd8','인스턴트-타입-in-OS-in-서비스-카탈로그 조회 API','하나의 인스턴트-타입-in-OS-in-서비스-카탈로그에 대한 검색','/service-catalogs/{serviceCatalogId}/os/{osId}/instance-type/{instanceTypeId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','service catalog','instance type','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a1d4e67-36cd-11f0-80c3-6e593baabd40','데이터스토어 클러스터 DRS 설정 조회','데이터스토어 클러스터 DRS 설정 조회','/vcenter/datastore-clusters/{datastore-cluster-id}/drs-config','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastorecluster','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1ddd2b-8e8b-11ee-a47a-a6869ab29cd8','인스턴트-타입-in-OS-in-서비스-카탈로그 생성 API','인스턴트-타입-in-OS-in-서비스-카탈로그에 대한 수정 기능','/service-catalogs/{serviceCatalogId}/os/{osId}/instance-type/{instanceTypeId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','service catalog','instance type','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a1e6425-8e8b-11ee-a47a-a6869ab29cd8','인스턴트-타입-in-OS-in-서비스-카탈로그 삭제 API','인스턴트-타입-in-OS-in-서비스-카탈로그에 대한 삭제 기능','/service-catalogs/{serviceCatalogId}/os/{osId}/instance-type/{instanceTypeId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','service catalog','instance type','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a1e8230-36cd-11f0-80c3-6e593baabd40','데이터스토어 클러스터 DRS 설정 수정','데이터스토어 클러스터 DRS 설정 수정','/vcenter/datastore-clusters/{datastore-cluster-id}/drs-config','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastorecluster','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1ee020-8e8b-11ee-a47a-a6869ab29cd8','OS-in-서비스-카탈로그 생성 API','OS-in-서비스-카탈로그에 대한 수정 기능','/service-catalogs/{serviceCatalogId}/os/{id}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','service catalog','os','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a1f1020-36cd-11f0-80c3-6e593baabd40','데이터센터 이름 변경','데이터센터 이름 변경','/vcenter/datacenters/{datacenter-id}/rename','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','datacenter','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1f3fb2-8e8b-11ee-a47a-a6869ab29cd8','OS-in-서비스-카탈로그 삭제 API','OS-in-서비스-카탈로그에 대한 삭제 기능','/service-catalogs/{serviceCatalogId}/os/{id}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','service catalog','os','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a1f5ec8-36cd-11f0-80c3-6e593baabd40','클러스터 이름 변경','클러스터 이름 변경','/vcenter/clusters/{cluster-id}/rename','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','cluster','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1f892e-36cd-11f0-80c3-6e593baabd40','클러스터 DRS 설정 조회','클러스터 DRS 설정 조회','/vcenter/clusters/{cluster-id}/drs-config','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','cluster','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1f8ff9-8e8b-11ee-a47a-a6869ab29cd8','서비스-카탈로그 생성 API','서비스-카탈로그에 대한 수정 기능','/os/{id}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','service catalog','os','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a1fae23-36cd-11f0-80c3-6e593baabd40','단일 클러스터 DRS 설정 수정','단일 클러스터 DRS 설정 수정','/vcenter/clusters/{cluster-id}/drs-config','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','cluster','PATCH',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1fce58-36cd-11f0-80c3-6e593baabd40','웹 콘솔 티켓 조회','웹 콘솔 티켓 조회','/vcenter/vms/{vm-id}/web-console-ticket','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a1fee5d-36cd-11f0-80c3-6e593baabd40','동기화를 하려는 가상머신 리스트 조회','동기화를 하려는 가상머신 리스트 조회','/vcenter/vms/sync/{provider-no}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','virtualmachine','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2007e8-36cd-11f0-80c3-6e593baabd40','가상머신 이름 중복 검사','가상머신 이름 중복 검사','/vcenter/vms/names/{desired-name}/is-taken','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a200ee4-8e8b-11ee-a47a-a6869ab29cd8','인스턴스-타입 조회 API','하나의 인스턴스-타입에 대한 검색','/instance-types/{id}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','service catalog','instance type','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a202512-36cd-11f0-80c3-6e593baabd40','사용 가능한 ip 주소인지 조회','사용 가능한 ip 주소인지 조회','/vcenter/vms/ip/{ipv4-address}/is-taken','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a20430a-36cd-11f0-80c3-6e593baabd40','사용중인 IP 조회','사용중인 IP 조회','/vcenter/vms/ip-addresses-in-use','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a206905-36cd-11f0-80c3-6e593baabd40','게스트 OS 리스트 조회','게스트 OS 리스트 조회','/vcenter/vms/guestos/list','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a208836-8e8b-11ee-a47a-a6869ab29cd8','인스턴스-타입 삭제 API','인스턴스-타입에 대한 삭제 기능','/instance-types/{id}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','service catalog','instance type','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a208ade-36cd-11f0-80c3-6e593baabd40','가상머신 만기일자 조회','가상머신 만기일자 조회','/vcenter/vms/expiry-date/{vm-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','apiforbusiness','virtualmachine','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a20ad58-36cd-11f0-80c3-6e593baabd40','가상머신 전원 상태 조회','가상머신 전원 상태 조회','/vcenter/vms/areVmsOff','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a20ca84-36cd-11f0-80c3-6e593baabd40','Cluster, Host 단위 Tenant 상태 매칭 정보 조회','Cluster, Host 단위 Tenant 상태 매칭 정보 조회','/vcenter/tenant/compute-resources/status','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a20e475-36cd-11f0-80c3-6e593baabd40','Cluster, Host 단위 Tenant 상태 매칭 정보 조회','Cluster, Host 단위 Tenant 상태 매칭 정보 조회','/vcenter/tenants/compute-resources/status','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a20e764-8e8b-11ee-a47a-a6869ab29cd8','',NULL,'/compute/server/servers','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',1)
    ,   ('4a210517-36cd-11f0-80c3-6e593baabd40','Cluster, Stand Alone Host 단위 Tenant 정보 조회','Cluster, Stand Alone Host 단위 Tenant 정보 조회','/vcenter/tenant/compute-resources','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a212312-36cd-11f0-80c3-6e593baabd40','Cluster, Stand Alone Host 단위 Tenant 정보 조회','Cluster, Stand Alone Host 단위 Tenant 정보 조회','/vcenter/tenants/compute-resources','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a214657-36cd-11f0-80c3-6e593baabd40','Tenant 정보 조회','Tenant 정보 조회','/vcenter/tenant','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a214b36-8e8b-11ee-a47a-a6869ab29cd8','인스턴스 상태 변경','인스턴스 상태 변경','/compute/server/servers','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a216bde-36cd-11f0-80c3-6e593baabd40','Tenant 정보 조회','Tenant 정보 조회','/vcenter/tenants','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a219bb5-36cd-11f0-80c3-6e593baabd40','템플릿 목록 조회','템플릿 목록 조회','/vcenter/templates','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','template','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a21aa5b-8e8b-11ee-a47a-a6869ab29cd8','서버 생성','서버 생성','/compute/server/servers','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a21dc3e-36cd-11f0-80c3-6e593baabd40','태스크 목록 조회','태스크 목록 조회','/vcenter/tasks','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','other','task','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a21f7a2-8e8b-11ee-a47a-a6869ab29cd8','인스턴스 타입 변경','인스턴스 타입 변경','/compute/server/servers/spec','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a220235-36cd-11f0-80c3-6e593baabd40','단일 태스크 조회','단일 태스크 조회','/vcenter/tasks/{task-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','other','task','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a22245d-36cd-11f0-80c3-6e593baabd40','태스크 취소','태스크 취소','/vcenter/tasks/{task-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','other','task','DELETE',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a22447c-36cd-11f0-80c3-6e593baabd40','Tag 이름 중복 확인','Tag 이름 중복 확인','/vcenter/tags/names/{category-id}/{desired-name}/is-taken','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a224794-8e8b-11ee-a47a-a6869ab29cd8','인스턴스 이름 변경','인스턴스 이름 변경','/compute/server/servers/name','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a226074-36cd-11f0-80c3-6e593baabd40','Tag 카테고리(범주) 이름 중복 확인','Tag 카테고리(범주) 이름 중복 확인','/vcenter/tag-categories/names/{desired-name}/is-taken','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','tag-category','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a227913-36cd-11f0-80c3-6e593baabd40','개별 스위치 조회 API','개별 스위치 조회 API','/vcenter/switches/{switch-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a229830-36cd-11f0-80c3-6e593baabd40','특정 표준 스위치의 물리 어댑터 MacAddr 조회','특정 표준 스위치의 물리 어댑터 MacAddr 조회','/vcenter/switches/svs/{switch-name}/physical-adapter-mac-address','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a22a96c-8e8b-11ee-a47a-a6869ab29cd8','객체 Or 폴더 업로드','객체 Or 폴더 업로드','/storage/upload','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storage','storage','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a22bd0b-36cd-11f0-80c3-6e593baabd40','스위치 이름 중복 검사','스위치 이름 중복 검사','/vcenter/switches/names/{switch-name}/is-taken','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a22e098-36cd-11f0-80c3-6e593baabd40','특정 dvs를 사용하는 호스트 조회 API','특정 dvs를 사용하는 호스트 조회 API','/vcenter/switches/hosts-using-dvs/{dvsId}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a22febf-36cd-11f0-80c3-6e593baabd40','스냅샷 조회','스냅샷 조회','/vcenter/snapshot','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','snapshot','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a23371c-36cd-11f0-80c3-6e593baabd40','스냅샷 이름 중복 확인','스냅샷 이름 중복 확인','/vcenter/snapshot/{vm-id}/name/{desired-name}/is-taken','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','snapshot','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2337fb-8e8b-11ee-a47a-a6869ab29cd8','admin : GET/storage/buckets','admin : GET/storage/buckets','/storage/buckets','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storage','storage','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a2365dc-36cd-11f0-80c3-6e593baabd40','가상머신의 스냅샷 조회','가상머신의 스냅샷 조회','/vcenter/snapshot/{root-snapshot-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','snapshot','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a238a1b-8e8b-11ee-a47a-a6869ab29cd8','버킷 업로드','버킷 업로드','/storage/buckets','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storage','storage','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a238d7b-36cd-11f0-80c3-6e593baabd40','resource 조회','resource 조회','/vcenter/resources','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','resource','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a23b339-36cd-11f0-80c3-6e593baabd40','메트릭 데이터 단일 object 조회','메트릭 데이터 단일 object 조회','/vcenter/resources/{object-id}/metric-data','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','metric','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a23d1d9-36cd-11f0-80c3-6e593baabd40','네트워크 토폴로지 조회','네트워크 토폴로지 조회','/vcenter/resources/topology','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','networktopology','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a23d448-8e8b-11ee-a47a-a6869ab29cd8','OS-in-서비스-카탈로그 생성 API','OS-in-서비스-카탈로그에 대한 생성 기능','/service-catalogs/{serviceCatalogId}/os','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','service catalog','os','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a23f03c-36cd-11f0-80c3-6e593baabd40','메트릭 데이터 조회','메트릭 데이터 조회','/vcenter/resources/metric-data','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','metric','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a240e54-36cd-11f0-80c3-6e593baabd40','메트릭 데이터 데이터스토어 조회','메트릭 데이터 데이터스토어 조회','/vcenter/resources/metric-data/datastore','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','metric','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a241e72-8e8b-11ee-a47a-a6869ab29cd8','인스턴트-타입-in-OS-in-서비스-카탈로그 조회 API','인스턴트-타입-in-OS-in-서비스-카탈로그에 대하여 필터를 통한 검색 지원','/service-catalogs/{serviceCatalogId}/os/{osId}/instance-type','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','service catalog','instance type','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a242bc7-36cd-11f0-80c3-6e593baabd40','단일 리소스풀 조회','단일 리소스풀 조회','/vcenter/resource-pools/{resource-pool-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','resourcepool','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a245eb2-36cd-11f0-80c3-6e593baabd40','리소스풀 삭제','리소스풀 삭제','/vcenter/resource-pools/{resource-pool-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','resourcepool','DELETE',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a247061-8e8b-11ee-a47a-a6869ab29cd8','인스턴트-타입-in-OS-in-서비스-카탈로그 생성 API','인스턴트-타입-in-OS-in-서비스-카탈로그에 대한 생성 기능','/service-catalogs/{serviceCatalogId}/os/{osId}/instance-type','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','service catalog','instance type','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a248bf8-36cd-11f0-80c3-6e593baabd40','Provider 리스트 조회','Provider 리스트 조회','/vcenter/provider','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a24c16a-36cd-11f0-80c3-6e593baabd40','포트그룹 이름 중복 검사','포트그룹 이름 중복 검사','/vcenter/portgroups/names/{portgroup-name}/is-taken','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','network','portgroup','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a24c49e-8e8b-11ee-a47a-a6869ab29cd8','서비스-카탈로그 생성 API','서비스-카탈로그에 대한 생성 기능','/os','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','service catalog','os','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a24e628-36cd-11f0-80c3-6e593baabd40','관리자 콘솔에서 VM 메타 리스트 조회','관리자 콘솔에서 VM 메타 리스트 조회','/vcenter/meta/vms','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a24ff01-36cd-11f0-80c3-6e593baabd40','호스트 메타 목록 조회','호스트 메타 목록 조회','/vcenter/meta/hosts','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','host','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a251368-8e8b-11ee-a47a-a6869ab29cd8','VPC 목록','VPC 목록을 조회한다.','/network/vpc/vpcs','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a25215c-36cd-11f0-80c3-6e593baabd40','데이터스토어 목록 메타 조회','데이터스토어 목록 메타 조회','/vcenter/meta/datastores','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastore','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a25465b-36cd-11f0-80c3-6e593baabd40','조건에 맞는 객체 조회','조건에 맞는 객체 조회','/vcenter/master','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','other','master','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a256576-36cd-11f0-80c3-6e593baabd40','조건에 맞는 모든 객체 조회','조건에 맞는 모든 객체 조회','/vcenter/master/everything','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','other','master','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a256675-8e8b-11ee-a47a-a6869ab29cd8','VPC 생성','VPC 생성한다.','/network/vpc/vpcs','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a259141-36cd-11f0-80c3-6e593baabd40','단일 Library 조회','단일 Library 조회','/vcenter/libraries/{library-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','other','library','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a25bb16-8e8b-11ee-a47a-a6869ab29cd8','Subnet 목록 조회','Subnet 목록 조회한다.','/network/subnet/subnets','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','subnet','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a25c2f1-36cd-11f0-80c3-6e593baabd40','가상머신/템플릿 인벤토리 조회','가상머신/템플릿 인벤토리 조회','/vcenter/inventory/vm','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','inventory','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a25ee19-36cd-11f0-80c3-6e593baabd40','스토리지 인벤토리 조회','스토리지 인벤토리 조회','/vcenter/inventory/storage','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','inventory','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2607a4-8e8b-11ee-a47a-a6869ab29cd8','admin : POST/network/subnet/subnets',NULL,'/network/subnet/subnets','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','subnet','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a261511-36cd-11f0-80c3-6e593baabd40','네트워크 인벤토리 조회','네트워크 인벤토리 조회','/vcenter/inventory/network','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','inventory','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2636b0-36cd-11f0-80c3-6e593baabd40','호스트/클러스터 인벤토리 조회','호스트/클러스터 인벤토리 조회','/vcenter/inventory/host','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','inventory','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a265499-8e8b-11ee-a47a-a6869ab29cd8','라우팅 테이블 조회','라우팅 테이블 조회','/network/route/routes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a265994-36cd-11f0-80c3-6e593baabd40','호스트 목록 조회','호스트 목록 조회','/vcenter/hosts','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','host','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a267c1d-36cd-11f0-80c3-6e593baabd40','단일 호스트 조회','단일 호스트 조회','/vcenter/hosts/{host-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','host','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2698b6-8e8b-11ee-a47a-a6869ab29cd8','admin : POST/network/route/routes','admin : POST/network/route/routes','/network/route/routes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a26a442-36cd-11f0-80c3-6e593baabd40','호스트의 사용가능 리스트 조회','호스트의 사용가능 리스트 조회','/vcenter/hosts/{host-id}/vmfs/availDiskList','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','host','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a26cb68-36cd-11f0-80c3-6e593baabd40','단일 폴더 조회','단일 폴더 조회','/vcenter/folders/{folder-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','folder','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a26e519-8e8b-11ee-a47a-a6869ab29cd8','인스턴스-타입 조회 API','인스턴스-타입에 대하여 필터를 통한 검색 지원','/instance-types','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','service catalog','instance type','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a26eb50-36cd-11f0-80c3-6e593baabd40','폴더 삭제','폴더 삭제','/vcenter/folders/{folder-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','folder','DELETE',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a272995-8e8b-11ee-a47a-a6869ab29cd8','사용자 목록 조회','사용자 목록 조회','/iam/users','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','user','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a272a18-36cd-11f0-80c3-6e593baabd40','폴더 하위 resource 조회','폴더 하위 resource 조회','/vcenter/folders/{folder-id}/managed-objects','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','folder','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a275768-36cd-11f0-80c3-6e593baabd40','하위 폴더 조회','하위 폴더 조회','/vcenter/folders/subfolders','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','folder','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a276bd2-8e8b-11ee-a47a-a6869ab29cd8','사용자 생성','사용자 생성','/iam/users','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','user','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a2786f8-36cd-11f0-80c3-6e593baabd40','단일 플레이버 조회','단일 플레이버 조회','/vcenter/flavors/{flavor-no}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','flavor','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a27aebd-8e8b-11ee-a47a-a6869ab29cd8','사용자 태그 생성/수정','사용자 태그 생성/수정','/iam/users/tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','user','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a27b1d8-36cd-11f0-80c3-6e593baabd40','플레이버 삭제','플레이버 삭제','/vcenter/flavors/{flavor-no}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','flavor','DELETE',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a27d650-36cd-11f0-80c3-6e593baabd40','플레이버 이름 중복 검사','플레이버 이름 중복 검사','/vcenter/flavors/names/{flavor-name}/is-taken','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','flavor','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a27f011-8e8b-11ee-a47a-a6869ab29cd8','서버 삭제','서버 삭제','/compute/server/servers/terminate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a27fccb-36cd-11f0-80c3-6e593baabd40','이벤트 리스트 조회','이벤트 리스트 조회','/vcenter/events','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','other','event','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a28286a-36cd-11f0-80c3-6e593baabd40','단일 데이터스토어 조회','단일 데이터스토어 조회','/vcenter/datastores/{datastore-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastore','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a283244-8e8b-11ee-a47a-a6869ab29cd8','서버 중지','서버 중지','/compute/server/servers/stop','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a285186-36cd-11f0-80c3-6e593baabd40','데이터스토어 삭제','데이터스토어 삭제','/vcenter/datastores/{datastore-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastore','DELETE',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a28840f-8e8b-11ee-a47a-a6869ab29cd8','서버 실행','서버 실행','/compute/server/servers/start','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a28c496-8e8b-11ee-a47a-a6869ab29cd8','서버 리부팅','서버 리부팅','/compute/server/servers/reboot','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a28d6eb-36cd-11f0-80c3-6e593baabd40','데이터스토어 최대 용량 조회','데이터스토어 최대 용량 조회','/vcenter/datastores/{datastore-id}/max-capacity','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','datastore','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a291064-36cd-11f0-80c3-6e593baabd40','데이터스토어 이름 중복 검사','데이터스토어 이름 중복 검사','/vcenter/datastores/names/{desired-name}/is-taken','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastore','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a291c79-8e8b-11ee-a47a-a6869ab29cd8','admin : GET/aws/api/v1/container/eks/clusters','admin : GET/aws/api/v1/container/eks/clusters','/aws/api/v1/container/eks/clusters','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','container','eks','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a293905-36cd-11f0-80c3-6e593baabd40','데이터스토어 생성 옵션 조회','데이터스토어 생성 옵션 조회','/vcenter/datastores/create-option','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastore','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a29552d-36cd-11f0-80c3-6e593baabd40','데이터스토어 클러스터 단건 상세 정보 조회','데이터스토어 클러스터 단건 상세 정보 조회','/vcenter/datastore-clusters/{datastore-cluster-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastorecluster','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a298758-36cd-11f0-80c3-6e593baabd40','데이터스토어 클러스터 삭제','데이터스토어 클러스터 삭제','/vcenter/datastore-clusters/{datastore-cluster-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastorecluster','DELETE',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a298980-8e8b-11ee-a47a-a6869ab29cd8','admin : POST/aws/api/v1/container/eks/clusters','admin : POST/aws/api/v1/container/eks/clusters','/aws/api/v1/container/eks/clusters','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','container','eks','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a29bad1-36cd-11f0-80c3-6e593baabd40','단일 데이터센터 조회','단일 데이터센터 조회','/vcenter/datacenters/{datacenter-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','datacenter','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a29e5b0-36cd-11f0-80c3-6e593baabd40','데이터센터 삭제','데이터센터 삭제','/vcenter/datacenters/{datacenter-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','datacenter','DELETE',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2a0f49-36cd-11f0-80c3-6e593baabd40','데이터센터 이름 중복 검사','데이터센터 이름 중복 검사','/vcenter/datacenters/names/{desired-name}/is-taken','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','datacenter','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2a16cd-8e8b-11ee-a47a-a6869ab29cd8','admin : GET/workspace',NULL,'/workspace','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','workspace','workspace','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a2a36d9-36cd-11f0-80c3-6e593baabd40','단일 클러스터 조회','단일 클러스터 조회','/vcenter/clusters/{cluster-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','cluster','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2a5f44-36cd-11f0-80c3-6e593baabd40','클러스터 삭제','클러스터 삭제','/vcenter/clusters/{cluster-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','cluster','DELETE',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2a6dd7-8e8b-11ee-a47a-a6869ab29cd8','admin : GET/storage/objects/info/buckets/{bucketName}/**',NULL,'/storage/objects/info/buckets/{bucketName}/test','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storage','storage','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a2a88b0-36cd-11f0-80c3-6e593baabd40','클러스터 이름 중복 확인','클러스터 이름 중복 확인','/vcenter/clusters/names/{desired-name}/is-taken','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','cluster','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2aa423-36cd-11f0-80c3-6e593baabd40','alarm리스트 조회','alarm리스트 조회','/vcenter/alarms/triggered-alarms','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','other','alarm','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2ab637-8e8b-11ee-a47a-a6869ab29cd8','admin : GET/storage/objects/buckets/{bucketName}','admin : GET/storage/objects/buckets/{bucketName}','/storage/objects/buckets/{bucketName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storage','storage','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a2abc54-36cd-11f0-80c3-6e593baabd40','단일 alarm 조회','단일 alarm 조회','/vcenter/alarms/specific-triggered-alarms/{entityId}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','other','alarm','GET',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2ada82-36cd-11f0-80c3-6e593baabd40','분산 스위치의 호스트 멤버 제거','분산 스위치의 호스트 멤버 제거','/vcenter/switches/{dvs-id}/host-members/{host-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','switch','DELETE',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2af996-8e8b-11ee-a47a-a6869ab29cd8','admin : GET/storage/objects-versions/buckets/{bucketName}','admin : GET/storage/objects-versions/buckets/{bucketName}','/storage/objects-versions/buckets/{bucketName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storage','storage','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a2b06bc-36cd-11f0-80c3-6e593baabd40','데이터스토어 클러스터에 데이터스토어 맴버 해제','데이터스토어 클러스터에 데이터스토어 맴버 해제','/vcenter/datastore-clusters/{datastore-cluster-id}/datastore-members/{datastore-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','storage','datastorecluster','DELETE',1,'75fe8584-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2b2b61-36cd-11f0-80c3-6e593baabd40','공급자 정보 조회','공급자 정보 조회','/nsx/provider','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx','provider','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a2b41d6-8e8b-11ee-a47a-a6869ab29cd8','admin : GET/storage/info','admin : GET/storage/info','/storage/info','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storage','storage','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a2b51a8-36cd-11f0-80c3-6e593baabd40','공급자 정보 수정','공급자 정보 수정','/nsx/provider','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx','provider','PUT',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2b85dc-8e8b-11ee-a47a-a6869ab29cd8','admin : GET/storage/info/buckets/{bucketName}','admin : GET/storage/info/buckets/{bucketName}','/storage/info/buckets/{bucketName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storage','storage','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a2b8e2d-36cd-11f0-80c3-6e593baabd40','Tier-1 리스트 조회','Tier-1 리스트 조회','/nsx/tier-1s','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-1','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2bc065-36cd-11f0-80c3-6e593baabd40','Tier-1 게이트웨이 생성','Tier-1 게이트웨이 생성','/nsx/tier-1s','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-1','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2bcec4-8e8b-11ee-a47a-a6869ab29cd8','admin : GET/storage/download','admin : GET/storage/download','/storage/download','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storage','storage','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a2be7c5-36cd-11f0-80c3-6e593baabd40','Tier-1 게이트웨이 조회','Tier-1 게이트웨이 조회','/nsx/tier-1s/{tier1-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-1','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2c0c0d-36cd-11f0-80c3-6e593baabd40','Tier-1 게이트웨이 생성','Tier-1 게이트웨이 생성','/nsx/tier-1s/{tier1-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-1','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2c2e2c-36cd-11f0-80c3-6e593baabd40','Tier-1 게이트웨이 삭제','Tier-1 게이트웨이 삭제','/nsx/tier-1s/{tier1-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-1','DELETE',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2c4b69-36cd-11f0-80c3-6e593baabd40','Tier-1 게이트웨이 수정','Tier-1 게이트웨이 수정','/nsx/tier-1s/{tier1-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-1','PATCH',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2c7369-36cd-11f0-80c3-6e593baabd40','Tier-0 리스트 조회','Tier-0 리스트 조회','/nsx/tier-0s','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-0','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2c99a9-36cd-11f0-80c3-6e593baabd40','Tier-0 생성','Tier-0 생성','/nsx/tier-0s','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-0','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2cc380-36cd-11f0-80c3-6e593baabd40','Tier-0 단일 조회','Tier-0 단일 조회','/nsx/tier-0s/{tier0-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-0','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2ce8e1-36cd-11f0-80c3-6e593baabd40','Tier-0 생성','Tier-0 생성','/nsx/tier-0s/{tier0-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-0','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2d0d6a-36cd-11f0-80c3-6e593baabd40','Tier-0 삭제','Tier-0 삭제','/nsx/tier-0s/{tier0-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-0','DELETE',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2d3859-36cd-11f0-80c3-6e593baabd40','Tier-0 수정','Tier-0 수정','/nsx/tier-0s/{tier0-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-0','PATCH',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2d630f-36cd-11f0-80c3-6e593baabd40','세그먼트 리스트 조회','세그먼트 리스트 조회','/nsx/segments','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','segment','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2d7de7-8e8b-11ee-a47a-a6869ab29cd8','버킷이름 중복체크','버킷이름 중복체크','/storage/buckets/duplicate-check/{bucketName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storage','storage','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a2d8503-36cd-11f0-80c3-6e593baabd40','세그먼트 생성','세그먼트 생성','/nsx/segments','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','segment','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2da89d-36cd-11f0-80c3-6e593baabd40','세그먼트 단일 조회','세그먼트 단일 조회','/nsx/segments/{segment-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','segment','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a2dcc18-36cd-11f0-80c3-6e593baabd40','세그먼트 생성','세그먼트 생성','/nsx/segments/{segment-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','segment','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2de6c4-36cd-11f0-80c3-6e593baabd40','세그먼트 삭제','세그먼트 삭제','/nsx/segments/{segment-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','segment','DELETE',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2e0665-36cd-11f0-80c3-6e593baabd40','세그먼트 수정','세그먼트 수정','/nsx/segments/{segment-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','segment','PATCH',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2e33f8-36cd-11f0-80c3-6e593baabd40','공급자 연동 테스트','공급자 연동 테스트','/nsx/provider/connect-test','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx','provider','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2e654b-36cd-11f0-80c3-6e593baabd40','Tier-1 NAT Rule 리스트 조회','Tier-1 NAT Rule 리스트 조회','/nsx/nat/tier-1s/{tier-1-id}/rules','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nat','rules','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2e85f3-36cd-11f0-80c3-6e593baabd40','Tier-1 NAT Rule 생성','Tier-1 NAT Rule 생성','/nsx/nat/tier-1s/{tier-1-id}/rules','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nat','rules','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2e8fdb-8e8b-11ee-a47a-a6869ab29cd8','admin : GET/region',NULL,'/region','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','provider','tenant','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a2eac04-36cd-11f0-80c3-6e593baabd40','Tier-0 NAT Rule 리스트 조회','Tier-0 NAT Rule 리스트 조회','/nsx/nat/tier-0s/{tier-0-id}/rules','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nat','rules','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2ec8f7-36cd-11f0-80c3-6e593baabd40','Tier-0 NAT Rule 생성','Tier-0 NAT Rule 생성','/nsx/nat/tier-0s/{tier-0-id}/rules','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nat','rules','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2ee282-36cd-11f0-80c3-6e593baabd40','가상서버 리스트 조회','가상서버 리스트 조회','/nsx/lb-virtual-servers','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','virtualserver','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2f1534-36cd-11f0-80c3-6e593baabd40','가상서버 생성','가상서버 생성','/nsx/lb-virtual-servers','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','virtualserver','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2f3934-8e8b-11ee-a47a-a6869ab29cd8','VPC 상세보기','VPC 상세보기 조회한다.','/network/vpc/vpcs/{vpcId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a2f45dd-36cd-11f0-80c3-6e593baabd40','가상서버 단일 조회','가상서버 단일 조회','/nsx/lb-virtual-servers/{lb-virtual-server-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','virtualserver','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2f7a23-36cd-11f0-80c3-6e593baabd40','가상서버 생성','가상서버 생성','/nsx/lb-virtual-servers/{lb-virtual-server-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','virtualserver','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2fa159-36cd-11f0-80c3-6e593baabd40','가상서버 삭제','가상서버 삭제','/nsx/lb-virtual-servers/{lb-virtual-server-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','virtualserver','DELETE',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2fc314-36cd-11f0-80c3-6e593baabd40','가상서버 수정','가상서버 수정','/nsx/lb-virtual-servers/{lb-virtual-server-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','virtualserver','PATCH',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2fde84-36cd-11f0-80c3-6e593baabd40','로드 밸런서 리스트 조회','로드 밸런서 리스트 조회','/nsx/lb-services','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','loadbalancer','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a2ffefa-36cd-11f0-80c3-6e593baabd40','로드 밸런서 생성','로드 밸런서 생성','/nsx/lb-services','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','loadbalancer','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a301989-36cd-11f0-80c3-6e593baabd40','단일 서버 SSL 프로파일 조회','단일 서버 SSL 프로파일 조회','/nsx/lb-server-ssl-profiles/{lb-server-ssl-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkservice','serversslprofile','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a30244c-8e8b-11ee-a47a-a6869ab29cd8','VPC 제거','VPC 제거한다.','/network/vpc/vpcs/{vpcId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a303971-36cd-11f0-80c3-6e593baabd40','단일 서버 SSL 프로파일 생성','단일 서버 SSL 프로파일 생성','/nsx/lb-server-ssl-profiles/{lb-server-ssl-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkservice','serversslprofile','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a305b11-36cd-11f0-80c3-6e593baabd40','서버 SSL 프로파일 삭제','서버 SSL 프로파일 삭제','/nsx/lb-server-ssl-profiles/{lb-server-ssl-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkservice','serversslprofile','DELETE',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a307bd7-36cd-11f0-80c3-6e593baabd40','단일 서버 SSL 프로파일 수정','단일 서버 SSL 프로파일 수정','/nsx/lb-server-ssl-profiles/{lb-server-ssl-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkservice','serversslprofile','PATCH',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a309716-36cd-11f0-80c3-6e593baabd40','로드 밸런서 Pool 리스트 조회','로드 밸런서 Pool 리스트 조회','/nsx/lb-pools','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','lbpool','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a309951-8e8b-11ee-a47a-a6869ab29cd8','서브넷 체크','서브넷 체크한다.','/network/vpc/vpcs/{vpcId}/check/subnets/{subnetId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a30b683-36cd-11f0-80c3-6e593baabd40','로드 밸런서 Pool 생성','로드 밸런서 Pool 생성','/nsx/lb-pools','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','lbpool','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a30d253-36cd-11f0-80c3-6e593baabd40','로드 밸런서 Pool 단일 조회','로드 밸런서 Pool 단일 조회','/nsx/lb-pools/{lb-pool-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','lbpool','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a30ecaf-36cd-11f0-80c3-6e593baabd40','로드 밸런서 Pool 생성','로드 밸런서 Pool 생성','/nsx/lb-pools/{lb-pool-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','lbpool','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3109d7-36cd-11f0-80c3-6e593baabd40','로드 밸런서 Pool 삭제','로드 밸런서 Pool 삭제','/nsx/lb-pools/{lb-pool-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','lbpool','DELETE',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a311faf-8e8b-11ee-a47a-a6869ab29cd8','서브넷 상세보기','서브넷 상세보기 조회한다.','/network/subnet/subnets/{subnetId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','subnet','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a313184-36cd-11f0-80c3-6e593baabd40','로드 밸런서 Pool 수정','로드 밸런서 Pool 수정','/nsx/lb-pools/{lb-pool-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','lbpool','PATCH',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a315034-36cd-11f0-80c3-6e593baabd40','단일 Persistence Profile 조회','단일 Persistence Profile 조회','/nsx/lb-persistence-profiles/{lb-persistence-profiles}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','persistenceprofile','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a316b74-8e8b-11ee-a47a-a6869ab29cd8','admin : DELETE/network/subnet/subnets/{subnetId}',NULL,'/network/subnet/subnets/{subnetId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','subnet','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a316bbd-36cd-11f0-80c3-6e593baabd40','Persistence Profile 생성','Persistence Profile 생성','/nsx/lb-persistence-profiles/{lb-persistence-profiles}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','persistenceprofile','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a318d37-36cd-11f0-80c3-6e593baabd40','Persistence Profile 삭제','Persistence Profile 삭제','/nsx/lb-persistence-profiles/{lb-persistence-profiles}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','persistenceprofile','DELETE',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a31ac5d-36cd-11f0-80c3-6e593baabd40','Persistence Profile 수정','Persistence Profile 수정','/nsx/lb-persistence-profiles/{lb-persistence-profiles}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','persistenceprofile','PATCH',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a31b784-8e8b-11ee-a47a-a6869ab29cd8','라우팅 테이블 상세조회','라우팅 테이블 상세조회','/network/route/routes/{routeTableId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a31c70a-36cd-11f0-80c3-6e593baabd40','단일 모니터 프로파일 조회','단일 모니터 프로파일 조회','/nsx/lb-monitor-profiles/{lb-monitor-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','monitor','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a31dd2c-36cd-11f0-80c3-6e593baabd40','모니터 프로파일 생성','모니터 프로파일 생성','/nsx/lb-monitor-profiles/{lb-monitor-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','monitor','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a31f84e-36cd-11f0-80c3-6e593baabd40','모니터 프로파일 삭제','모니터 프로파일 삭제','/nsx/lb-monitor-profiles/{lb-monitor-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','monitor','DELETE',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a31f9c3-8e8b-11ee-a47a-a6869ab29cd8','admin : GET/network/ipam/ipampools','admin : GET/network/ipam/ipampools','/network/ipam/ipampools','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','ipampool','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a320eed-36cd-11f0-80c3-6e593baabd40','모니터 프로파일 수정','모니터 프로파일 수정','/nsx/lb-monitor-profiles/{lb-monitor-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','monitor','PATCH',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3228a3-36cd-11f0-80c3-6e593baabd40','단일 클라이언트 SSL 프로파일 조회','단일 클라이언트 SSL 프로파일 조회','/nsx/lb-client-ssl-profiles/{lb-client-ssl-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkservice','clientsslprofile','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a323f27-8e8b-11ee-a47a-a6869ab29cd8','NAT 게이트웨이 조회','NAT 게이트웨이 조회','/network/gateway/natgateways','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','gateway','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a323f64-36cd-11f0-80c3-6e593baabd40','클라이언트 SSL 프로파일 생성','클라이언트 SSL 프로파일 생성','/nsx/lb-client-ssl-profiles/{lb-client-ssl-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkservice','clientsslprofile','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3268ad-36cd-11f0-80c3-6e593baabd40','클라이언트 SSL 프로파일 삭제','클라이언트 SSL 프로파일 삭제','/nsx/lb-client-ssl-profiles/{lb-client-ssl-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkservice','clientsslprofile','DELETE',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a328797-8e8b-11ee-a47a-a6869ab29cd8','NAT 게이트웨이 상세조회','NAT 게이트웨이 상세조회','/network/gateway/natgateways/{natGatewayId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','gateway','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a328d86-36cd-11f0-80c3-6e593baabd40','클라이언트 SSL 프로파일 수정','클라이언트 SSL 프로파일 수정','/nsx/lb-client-ssl-profiles/{lb-client-ssl-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkservice','clientsslprofile','PATCH',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a32a8b2-36cd-11f0-80c3-6e593baabd40','단일 Lb 앱 프로파일 조회','단일 Lb 앱 프로파일 조회','/nsx/lb-app-profiles/{lb-app-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','appprofile','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a32c73e-36cd-11f0-80c3-6e593baabd40','Lb 앱 프로파일 생성','Lb 앱 프로파일 생성','/nsx/lb-app-profiles/{lb-app-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','appprofile','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a32c920-8e8b-11ee-a47a-a6869ab29cd8','인터넷 게이트웨이 조회','인터넷 게이트웨이 조회','/network/gateway/internets','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','gateway','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a32e231-36cd-11f0-80c3-6e593baabd40','Lb 앱 프로파일 삭제','Lb 앱 프로파일 삭제','/nsx/lb-app-profiles/{lb-app-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','appprofile','DELETE',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a32fb30-36cd-11f0-80c3-6e593baabd40','Lb 앱 프로파일 수정','Lb 앱 프로파일 수정','/nsx/lb-app-profiles/{lb-app-profile-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','appprofile','PATCH',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3310d8-8e8b-11ee-a47a-a6869ab29cd8','인터넷 게이트웨이 상세조회','인터넷 게이트웨이 상세조회','/network/gateway/internets/{internetGatewayId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','gateway','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a3318fe-36cd-11f0-80c3-6e593baabd40','Inventory Service 리스트 조회','Inventory Service 리스트 조회','/nsx/inventory/services','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','inventory','services','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a333b64-36cd-11f0-80c3-6e593baabd40','Service 생성','Service 생성','/nsx/inventory/services','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','inventory','services','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a335a11-36cd-11f0-80c3-6e593baabd40','게이트웨이 방화벽 정책 기준 rule 생성','게이트웨이 방화벽 정책 기준 rule 생성','/nsx/gfw/domains/{domainId}/{gfw-policy-id}/rules','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a336747-8e8b-11ee-a47a-a6869ab29cd8','사용자 상세 조회','사용자 상세 조회','/iam/users/{userName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','user','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a33799a-36cd-11f0-80c3-6e593baabd40','GFW 방화벽 쟁책 생성','GFW 방화벽 쟁책 생성','/nsx/gfw/domains/{domainId}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a339651-36cd-11f0-80c3-6e593baabd40','분산 방화벽의 정책 내부 단일 룰 조회','분산 방화벽의 정책 내부 단일 룰 조회','/nsx/dfw/{dfw-id}/rules/{dfw-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','distributedfirewall','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a33b520-36cd-11f0-80c3-6e593baabd40','분산 방화벽의 정책 내부 단일 룰 생성','분산 방화벽의 정책 내부 단일 룰 생성','/nsx/dfw/{dfw-id}/rules/{dfw-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','distributedfirewall','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a33b909-8e8b-11ee-a47a-a6869ab29cd8','사용자 삭제','사용자 삭제','/iam/users/{userName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','user','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a33de65-36cd-11f0-80c3-6e593baabd40','분산 방화벽의 정책 내부 단일 룰 삭제','분산 방화벽의 정책 내부 단일 룰 삭제','/nsx/dfw/{dfw-id}/rules/{dfw-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','distributedfirewall','DELETE',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a33fd4e-36cd-11f0-80c3-6e593baabd40','분산 방화벽의 정책 내부 단일 룰 수정','분산 방화벽의 정책 내부 단일 룰 수정','/nsx/dfw/{dfw-id}/rules/{dfw-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','distributedfirewall','PATCH',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3417f5-36cd-11f0-80c3-6e593baabd40','분산 방화벽의 정책 내부 단일 룰 생성','분산 방화벽의 정책 내부 단일 룰 생성','/nsx/dfw/{dfw-id}/rules','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','distributedfirewall','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a342932-8e8b-11ee-a47a-a6869ab29cd8','사용자 태그 목록 조회','사용자 태그 목록 조회','/iam/users/{userName}/tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','user','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a34334f-36cd-11f0-80c3-6e593baabd40','분산 방화벽 정책 조회','분산 방화벽 정책 조회','/nsx/dfw/{dfw-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','distributedfirewall','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a34510f-36cd-11f0-80c3-6e593baabd40','분산 방화벽 쟁책 등록','분산 방화벽 쟁책 등록','/nsx/dfw/{dfw-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','distributedfirewall','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a346d60-36cd-11f0-80c3-6e593baabd40','분산 방화벽 정책 삭제','분산 방화벽 정책 삭제','/nsx/dfw/{dfw-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','distributedfirewall','DELETE',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3480b0-8e8b-11ee-a47a-a6869ab29cd8','사용자 태그 삭제','사용자 태그 삭제','/iam/users/{userName}/tags','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','user','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a34867d-36cd-11f0-80c3-6e593baabd40','분산 방화벽 정책 수정','분산 방화벽 정책 수정','/nsx/dfw/{dfw-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','distributedfirewall','PATCH',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a34a4e1-36cd-11f0-80c3-6e593baabd40','분산 방화벽 리스트 조회','분산 방화벽 리스트 조회','/nsx/dfw','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','distributedfirewall','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a34c131-36cd-11f0-80c3-6e593baabd40','분산 방화벽 쟁책 등록','분산 방화벽 쟁책 등록','/nsx/dfw','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','distributedfirewall','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a34d1e2-8e8b-11ee-a47a-a6869ab29cd8','사용자 권한 목록 조회','사용자 권한 목록 조회','/iam/users/{userName}/policies','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','user','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a34dd31-36cd-11f0-80c3-6e593baabd40','공급자 연동 테스트','공급자 연동 테스트','/nsx-alb/provider/connect-test','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','provider','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a351bd9-36cd-11f0-80c3-6e593baabd40','Tier-1 NAT Rule 단일 조회','Tier-1 NAT Rule 단일 조회','/nsx/nat/tier-1s/{tier-1-id}/rules/{nat-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nat','rules','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a354902-36cd-11f0-80c3-6e593baabd40','Tier-1 NAT Rule 삭제','Tier-1 NAT Rule 삭제','/nsx/nat/tier-1s/{tier-1-id}/rules/{nat-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nat','rules','DELETE',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a355dea-8e8b-11ee-a47a-a6869ab29cd8','사용자 권한 경계 조회','사용자 권한 경계 조회','/iam/users/{userName}/permission-boundary','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','user','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a356a55-36cd-11f0-80c3-6e593baabd40','Tier-1 NAT Rule 수정','Tier-1 NAT Rule 수정','/nsx/nat/tier-1s/{tier-1-id}/rules/{nat-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nat','rules','PATCH',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a35871f-36cd-11f0-80c3-6e593baabd40','Tier-0 NAT Rule 단일 조회','Tier-0 NAT Rule 단일 조회','/nsx/nat/tier-0s/{tier-0-id}/rules/{nat-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nat','rules','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a35a1e0-36cd-11f0-80c3-6e593baabd40','Tier-0 NAT Rule 삭제','Tier-0 NAT Rule 삭제','/nsx/nat/tier-0s/{tier-0-id}/rules/{nat-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nat','rules','DELETE',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a35c383-36cd-11f0-80c3-6e593baabd40','Tier-0 NAT Rule 수정','Tier-0 NAT Rule 수정','/nsx/nat/tier-0s/{tier-0-id}/rules/{nat-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nat','rules','PATCH',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a35cdba-8e8b-11ee-a47a-a6869ab29cd8','사용자 그룹 목록 조회','사용자 그룹 목록 조회','/iam/users/{userName}/groups','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','user','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a35ded9-36cd-11f0-80c3-6e593baabd40','로드 밸런서 단일 조회','로드 밸런서 단일 조회','/nsx/lb-services/{lb-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','loadbalancer','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a35f8e3-36cd-11f0-80c3-6e593baabd40','로드 밸런서 삭제','로드 밸런서 삭제','/nsx/lb-services/{lb-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','loadbalancer','DELETE',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3611ed-36cd-11f0-80c3-6e593baabd40','로드 밸런서 수정','로드 밸런서 수정','/nsx/lb-services/{lb-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','loadbalancer','PATCH',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3694b7-8e8b-11ee-a47a-a6869ab29cd8','사용자 권한 json 조회','사용자 권한 json 조회','/iam/users/policies/json','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','user','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a36a7ec-36cd-11f0-80c3-6e593baabd40','게이트웨이 방화벽 정책 기준 rule 수정','게이트웨이 방화벽 정책 기준 rule 수정','/nsx/gfw/domains/{domainId}/{gfw-policy-id}/rules/{gfw-policy-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','PATCH',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a36cdb0-36cd-11f0-80c3-6e593baabd40','GFW 방화벽 쟁책 수정','GFW 방화벽 쟁책 수정','/nsx/gfw/domains/{domainId}/{gfw-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','PATCH',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a36f21d-36cd-11f0-80c3-6e593baabd40','단일 서버풀 조회','단일 서버풀 조회','/nsx-alb/pool/{pool-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','pool','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a370380-8e8b-11ee-a47a-a6869ab29cd8','os 에따른 버전 조회','os 종류 : linux , macos , ubuntu, window, suse, debian ','/compute/server/servers/{os}/versions','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',1)
    ,   ('4a370937-36cd-11f0-80c3-6e593baabd40','서버풀 수정','서버풀 수정','/nsx-alb/pool/{pool-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','pool','PATCH',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a37227d-36cd-11f0-80c3-6e593baabd40','Transport zone 리스트 조회','Transport zone 리스트 조회','/nsx/transport-zones','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','transportzone','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a373d95-36cd-11f0-80c3-6e593baabd40','Tier-1 게이트웨이의 edge 클러스터 조회','Tier-1 게이트웨이의 edge 클러스터 조회','/nsx/tier-1s/{tier1-id}/locale-services','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-1','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a375a13-36cd-11f0-80c3-6e593baabd40','Tier-1 게이트웨이의 edge 조회','Tier-1 게이트웨이의 edge 조회','/nsx/tier-1s/{tier1-id}/locale-services/{locale-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-1','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3779c4-36cd-11f0-80c3-6e593baabd40','Tier-0의 locale 리스트 조회','Tier-0의 locale 리스트 조회','/nsx/tier-0s/{tier0-id}/locale-services','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-0','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a379537-36cd-11f0-80c3-6e593baabd40','Tier-0의 단일 locale 조회','Tier-0의 단일 locale 조회','/nsx/tier-0s/{tier0-id}/locale-services/{locale-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','tier-0','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a37a880-8e8b-11ee-a47a-a6869ab29cd8','',NULL,'/compute/server/servers/{instanceId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',1)
    ,   ('4a37ac45-36cd-11f0-80c3-6e593baabd40','Service Profile 리스트 조회','Service Profile 리스트 조회','/nsx/service-profiles','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','inventory','serviceprofile','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a37c7a2-36cd-11f0-80c3-6e593baabd40','단일 가상서버 조회','단일 가상서버 조회','/nsx/networking/network-services/load-balancing/virtual-servers/{lb-virtual-server-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancingview','virtualserver','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a37e1f7-36cd-11f0-80c3-6e593baabd40','가상서버 리스트 조회','가상서버 리스트 조회','/nsx/networking/network-services/load-balancing/virtual-servers','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancingview','virtualserver','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a37fa7d-8e8b-11ee-a47a-a6869ab29cd8','',NULL,'/compute/server/servers/security-groups','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',1)
    ,   ('4a380169-36cd-11f0-80c3-6e593baabd40','가상서버 리스트 조회','가상서버 리스트 조회','/nsx/networking/network-services/load-balancing/virtual-servers/','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancingview','virtualserver','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a381f1b-36cd-11f0-80c3-6e593baabd40','로드 밸런서 Pool 단일 조회','로드 밸런서 Pool 단일 조회','/nsx/networking/network-services/load-balancing/server-pools/{lb-pool-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancingview','lbpool','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a383e28-36cd-11f0-80c3-6e593baabd40','로드 밸런서 Pool 리스트를 조회','로드 밸런서 Pool 리스트를 조회','/nsx/networking/network-services/load-balancing/server-pools','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancingview','lbpool','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a385dab-36cd-11f0-80c3-6e593baabd40','로드 밸런서 Pool 리스트를 조회','로드 밸런서 Pool 리스트를 조회','/nsx/networking/network-services/load-balancing/server-pools/','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancingview','lbpool','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3865c7-8e8b-11ee-a47a-a6869ab29cd8','',NULL,'/compute/server/servers/monitoring/{instanceId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',1)
    ,   ('4a388944-36cd-11f0-80c3-6e593baabd40','로드 밸런서 단일 조회','로드 밸런서 단일 조회','/nsx/networking/network-services/load-balancing/load-balancers/{lb-services-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancingview','loadbalancer','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a38ae94-36cd-11f0-80c3-6e593baabd40','로드 밸런서 리스트 조회','로드 밸런서 리스트 조회','/nsx/networking/network-services/load-balancing/load-balancers','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancingview','loadbalancer','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a38b5f9-8e8b-11ee-a47a-a6869ab29cd8','',NULL,'/compute/server/servers/logs/{instanceId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',1)
    ,   ('4a38cfc3-36cd-11f0-80c3-6e593baabd40','로드 밸런서 리스트 조회','로드 밸런서 리스트 조회','/nsx/networking/network-services/load-balancing/load-balancers/','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancingview','loadbalancer','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a38efde-36cd-11f0-80c3-6e593baabd40','Tier-1 단일 조회','Tier-1 단일 조회','/nsx/networking/connectivity/tier-1s/{tier1-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnectionview','tier-1','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a390d09-36cd-11f0-80c3-6e593baabd40','Tier-1 리스트 조회','Tier-1 리스트 조회','/nsx/networking/connectivity/tier-1s','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnectionview','tier-1','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a390d72-8e8b-11ee-a47a-a6869ab29cd8','',NULL,'/compute/server/servers/keys','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',1)
    ,   ('4a39277a-36cd-11f0-80c3-6e593baabd40','Tier-1 리스트 조회','Tier-1 리스트 조회','/nsx/networking/connectivity/tier-1s/','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnectionview','tier-1','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a39418b-36cd-11f0-80c3-6e593baabd40','Tier-0 단일 조회','Tier-0 단일 조회','/nsx/networking/connectivity/tier-0s/{tier0-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnectionview','tier-0','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3960d0-36cd-11f0-80c3-6e593baabd40','Tier-0 리스트 조회','Tier-0 리스트 조회','/nsx/networking/connectivity/tier-0s','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnectionview','tier-0','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a39724f-8e8b-11ee-a47a-a6869ab29cd8','',NULL,'/compute/server/servers/instance-types','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',1)
    ,   ('4a397cae-36cd-11f0-80c3-6e593baabd40','Tier-0 리스트 조회','Tier-0 리스트 조회','/nsx/networking/connectivity/tier-0s/','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnectionview','tier-0','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a39a331-36cd-11f0-80c3-6e593baabd40','세그먼트 단일 조회','세그먼트 단일 조회','/nsx/networking/connectivity/segments/{segment-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnectionview','segment','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a39cd13-36cd-11f0-80c3-6e593baabd40','세그먼트 리스트를 조회','세그먼트 리스트를 조회','/nsx/networking/connectivity/segments','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnectionview','segment','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a39d335-8e8b-11ee-a47a-a6869ab29cd8','인스턴스 타입 디테일 조회','인스턴스 타입 디테일 조회.','/compute/server/servers/instance-types/{instanceType}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',1)
    ,   ('4a39ed94-36cd-11f0-80c3-6e593baabd40','세그먼트 리스트를 조회','세그먼트 리스트를 조회','/nsx/networking/connectivity/segments/','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnectionview','segment','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3a10ec-36cd-11f0-80c3-6e593baabd40','SSL 프로파일 리스트 조회','SSL 프로파일 리스트 조회','/nsx/lb-ssl-profiles','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','sslprofile','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3a3735-36cd-11f0-80c3-6e593baabd40','서버 SSL 프로파일 리스트 조회','서버 SSL 프로파일 리스트 조회','/nsx/lb-server-ssl-profiles','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkservice','serversslprofile','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3a5f12-36cd-11f0-80c3-6e593baabd40','Persistence Profile 리스트 조회','Persistence Profile 리스트 조회','/nsx/lb-persistence-profiles','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','persistenceprofile','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3a688a-8e8b-11ee-a47a-a6869ab29cd8','추가된부분',NULL,'/compute/server/servers/instance-types/amis/{ami}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',1)
    ,   ('4a3a8309-36cd-11f0-80c3-6e593baabd40','로드 밸런싱 모니터링 리스트 조회','로드 밸런싱 모니터링 리스트 조회','/nsx/lb-monitor-profiles','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','monitor','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3aa77d-36cd-11f0-80c3-6e593baabd40','클라이언트 SSL 프로파일 리스트 조회','클라이언트 SSL 프로파일 리스트 조회','/nsx/lb-client-ssl-profiles','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkservice','clientsslprofile','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3acd7b-8e8b-11ee-a47a-a6869ab29cd8','quickstart  ami 리스트 조회','quick ami 리스트를 조회한다.','/compute/server/servers/amis','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',1)
    ,   ('4a3acf9d-36cd-11f0-80c3-6e593baabd40','Lb 앱 프로파일 리스트 조회','Lb 앱 프로파일 리스트 조회','/nsx/lb-app-profiles','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','appprofile','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3af920-36cd-11f0-80c3-6e593baabd40','Inventory Service 단일 조회','Inventory Service 단일 조회','/nsx/inventory/services/{service}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','inventory','services','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3b1f0f-36cd-11f0-80c3-6e593baabd40','그룹 리스트 조회','그룹 리스트 조회','/nsx/groups','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','inventory','group','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3b2cf0-8e8b-11ee-a47a-a6869ab29cd8','ami 디테일 info 조회','ami 디테일 info 조회','/compute/server/servers/amis/{ami}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',1)
    ,   ('4a3b3ea9-36cd-11f0-80c3-6e593baabd40','게이트웨이 방화벽 정책 단일 조회','게이트웨이 방화벽 정책 단일 조회','/nsx/gfw/{gfw-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3b5eda-36cd-11f0-80c3-6e593baabd40','게이트웨이 방화벽 정책 삭제','게이트웨이 방화벽 정책 삭제','/nsx/gfw/{gfw-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','DELETE',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3b829a-36cd-11f0-80c3-6e593baabd40','게이트웨이 방화벽 Summary 조회','게이트웨이 방화벽 Summary 조회','/nsx/gfw/summary','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3ba39e-36cd-11f0-80c3-6e593baabd40','모든 게이트웨이 방화벽 정책에서 rule 리스트 조회','모든 게이트웨이 방화벽 정책에서 rule 리스트 조회','/nsx/gfw/rules','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3bbe79-36cd-11f0-80c3-6e593baabd40','게이트웨이 방화벽 단일 규칙 조회','게이트웨이 방화벽 단일 규칙 조회','/nsx/gfw/domains/{domainId}/{gfw-id}/rules/{gfw-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3bd78c-8e8b-11ee-a47a-a6869ab29cd8','os 별 생성 qucickstart ami 리스트 조회','architecture = supportedArchitectures , vcpu = defaultVCpus , 메모리 = sizeInGiB , 스토리지 = instanceStorageSupported 가 켜졌을경우 instanceStorageInfo  유형도 마찬가지 , 네트워크 성능 = networkPerformance ,  프리티어 =freeTierEligible ,currentGeneration = currentGeneration ','/compute/server/servers/amis/os/{os}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',1)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a3bfd59-36cd-11f0-80c3-6e593baabd40','게이트웨이 방화벽 정책 기준 rule  삭제','게이트웨이 방화벽 정책 기준 rule  삭제','/nsx/gfw/domains/{domainId}/{gfw-id}/rules/{gfw-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','DELETE',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3c1f99-36cd-11f0-80c3-6e593baabd40','게이트웨이 방화벽 정책 기준 rule 리스트 조회','게이트웨이 방화벽 정책 기준 rule 리스트 조회','/nsx/gfw/domains/{domainId}/{gfw-id}/rules','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3c3c36-36cd-11f0-80c3-6e593baabd40','게이트웨이 방화벽 리스트 조회','게이트웨이 방화벽 리스트 조회','/nsx/gfw','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3c5b25-36cd-11f0-80c3-6e593baabd40','Enforcement 리스트 조회','Enforcement 리스트 조회','/nsx/enforcement','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','enforcement','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3c73df-8e8b-11ee-a47a-a6869ab29cd8','securityGroup 리스트 조회','securityGroup 리스트 조회 ','/compute/server/security-groups','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a3c7753-36cd-11f0-80c3-6e593baabd40','Enforcement 단일 조회','Enforcement 단일 조회','/nsx/enforcement/{enforcement-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','enforcement','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3c8f57-36cd-11f0-80c3-6e593baabd40','Edge-Cluster 리스트 조회','Edge-Cluster 리스트 조회','/nsx/enforcement/{enforcement-id}/edge-clusters','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','enforcement','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3cab4e-36cd-11f0-80c3-6e593baabd40','단일 edge-cluster 조회','단일 edge-cluster 조회','/nsx/enforcement/{enforcement-id}/edge-clusters/{cluster-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','enforcement','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3cc3d0-36cd-11f0-80c3-6e593baabd40','클러스터의 edge-node 리스트 조회','클러스터의 edge-node 리스트 조회','/nsx/enforcement/{enforcement-id}/edge-clusters/{cluster-id}/edge-nodes','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','enforcement','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3cda79-36cd-11f0-80c3-6e593baabd40','클러스터의 edge-node 단일 조회','클러스터의 edge-node 단일 조회','/nsx/enforcement/{enforcement-id}/edge-clusters/{cluster-id}/edge-nodes/{node-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networkconnection','enforcement','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3cec25-8e8b-11ee-a47a-a6869ab29cd8','admin : GET/compute/server/reservation','admin : GET/compute/server/reservation','/compute/server/reservation','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server reservation','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a3cf71d-36cd-11f0-80c3-6e593baabd40','Dashboard 리소스 조회','Dashboard 리소스 조회','/nsx/dashboard','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','dashboard','resource','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3d13df-36cd-11f0-80c3-6e593baabd40','Context Profile 리스트 조회','Context Profile 리스트 조회','/nsx/context-profiles','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','inventory','contextprofile','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3d2ebe-36cd-11f0-80c3-6e593baabd40','단일 VirtualService 조회','단일 VirtualService 조회','/nsx-alb/virtualservice/{virtualservice-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','virtualservice','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3d4b17-36cd-11f0-80c3-6e593baabd40','VirtualService summary 단일 조회','VirtualService summary 단일 조회','/nsx-alb/virtualservice/summary/{virtualservice-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','virtualservice','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3d5e08-8e8b-11ee-a47a-a6869ab29cd8','keypair 리스트 조회','keypair 리스트 조회 ','/compute/server/keypairs','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a3d664a-36cd-11f0-80c3-6e593baabd40','VirtualService summary 조회','VirtualService summary 조회','/nsx-alb/virtualservice/summary','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','virtualservice','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3d859b-36cd-11f0-80c3-6e593baabd40','VirtualService 단일 조회','VirtualService 단일 조회','/nsx-alb/virtualservice/inventory/{virtualservice-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','virtualservice','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3db660-36cd-11f0-80c3-6e593baabd40','VirtualService 인벤토리 리스트 조회','VirtualService 인벤토리 리스트 조회','/nsx-alb/virtualservice/inventory','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','virtualservice','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3ddd9e-36cd-11f0-80c3-6e593baabd40','VirtualService 리스트 조회','VirtualService 리스트 조회','/nsx-alb/virtualservice','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','virtualservice','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a3e0747-36cd-11f0-80c3-6e593baabd40','서비스 엔진 조회','서비스 엔진 조회','/nsx-alb/serviceengine','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','serviceengine','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3e21fe-8e8b-11ee-a47a-a6869ab29cd8','admin : GET/billing/month','admin : GET/billing/month','/billing/month','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','billing','billing info','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a3e3b03-36cd-11f0-80c3-6e593baabd40','단일 서비스 엔진 조회','단일 서비스 엔진 조회','/nsx-alb/serviceengine/{serviceengine-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','serviceengine','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3e60b2-36cd-11f0-80c3-6e593baabd40','인벤토리 조회','인벤토리 조회','/nsx-alb/serviceengine/inventory','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','serviceengine','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3e8eeb-36cd-11f0-80c3-6e593baabd40','단일 서비스 엔진 조회','단일 서비스 엔진 조회','/nsx-alb/serviceengine/inventory/{serviceengine-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','serviceengine','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3eb1ec-36cd-11f0-80c3-6e593baabd40','서버 풀 Summary 조회','서버 풀 Summary 조회','/nsx-alb/pool/summary/{pool-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','pool','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3ed3c4-36cd-11f0-80c3-6e593baabd40','서버 리스트 조회','서버 리스트 조회','/nsx-alb/pool/inventory/{pool-uuid}/servers','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','pool','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3ee6d4-8e8b-11ee-a47a-a6869ab29cd8','admin : GET/billing/day','admin : GET/billing/day','/billing/day','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','billing','billing info','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a3ef371-36cd-11f0-80c3-6e593baabd40','서버 풀 조회','서버 풀 조회','/nsx-alb/pool/inventory/{pool-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','pool','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3f1c70-36cd-11f0-80c3-6e593baabd40','서버풀 인벤토리 조회','서버풀 인벤토리 조회','/nsx-alb/pool/inventory','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','pool','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3f43cf-36cd-11f0-80c3-6e593baabd40','서버풀 그룹 조회','서버풀 그룹 조회','/nsx-alb/pool/group','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','pool','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3f6602-36cd-11f0-80c3-6e593baabd40','서버풀 리스트 조회','서버풀 리스트 조회','/nsx-alb/pool','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','pool','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3f7e2e-36cd-11f0-80c3-6e593baabd40','네트워크 리스트 조회','네트워크 리스트 조회','/nsx-alb/network','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','network','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3fa052-36cd-11f0-80c3-6e593baabd40','네트워크 단일 조회','네트워크 단일 조회','/nsx-alb/network/{network-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','network','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3fca5d-36cd-11f0-80c3-6e593baabd40','네트워크 서브넷 리스트 조회','네트워크 서브넷 리스트 조회','/nsx-alb/network/subnet','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','network','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3fe9ca-36cd-11f0-80c3-6e593baabd40','인벤토리 리스트 조회','인벤토리 리스트 조회','/nsx-alb/network/inventory','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','network','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a3ff9cf-8e8b-11ee-a47a-a6869ab29cd8','admin : GET/aws/api/v1/container/eks/clusters/{name}','admin : GET/aws/api/v1/container/eks/clusters/{name}','/aws/api/v1/container/eks/clusters/{name}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','container','eks','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a400a7d-36cd-11f0-80c3-6e593baabd40','인벤토리의 단일 네트워크 조회','인벤토리의 단일 네트워크 조회','/nsx-alb/network/inventory/{network-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','network','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a402a5f-36cd-11f0-80c3-6e593baabd40','클러스터의 버전 조회','클러스터의 버전 조회','/nsx-alb/cluster/version','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','cluster','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a404c4e-36cd-11f0-80c3-6e593baabd40','클라우드 리스트 조회','클라우드 리스트 조회','/nsx-alb/cloud','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','cloud','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4a408a7e-36cd-11f0-80c3-6e593baabd40','단일 클라우드 조회','단일 클라우드 조회','/nsx-alb/cloud/{cloud-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','cloud','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a40bbfe-36cd-11f0-80c3-6e593baabd40','단일 네트워크 조회','단일 네트워크 조회','/nsx-alb/cloud/{cloud-uuid}/servers/{network-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','cloud','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a40c28d-8e8b-11ee-a47a-a6869ab29cd8','admin : GET/aws/api/v1/container/eks/clusters/{name}/node-group','admin : GET/aws/api/v1/container/eks/clusters/{name}/node-group','/aws/api/v1/container/eks/clusters/{name}/node-group','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','container','eks','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a40e1ed-36cd-11f0-80c3-6e593baabd40','인벤토리 조회','인벤토리 조회','/nsx-alb/cloud/inventory','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','cloud','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a410967-36cd-11f0-80c3-6e593baabd40','단일 클라우드 조회','단일 클라우드 조회','/nsx-alb/cloud/inventory/{cloud-uuid}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','nsx-alb','cloud','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('4a41200e-8e8b-11ee-a47a-a6869ab29cd8','admin : GET/aws/api/v1/container/eks/clusters/{name}/node-groups/{nodegroupName}','admin : GET/aws/api/v1/container/eks/clusters/{name}/node-groups/{nodegroupName}','/aws/api/v1/container/eks/clusters/{name}/node-groups/{nodegroupName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','container','eks','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a41a36a-8e8b-11ee-a47a-a6869ab29cd8','admin : GET/aws/api/v1/container/eks/clusters/{name}/fargate-profiles','admin : GET/aws/api/v1/container/eks/clusters/{name}/fargate-profiles','/aws/api/v1/container/eks/clusters/{name}/fargate-profiles','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','container','eks','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a4228cd-8e8b-11ee-a47a-a6869ab29cd8','admin : GET/aws/api/v1/container/eks/clusters/{name}/fargate-profiles/{fargateProfileName}','admin : GET/aws/api/v1/container/eks/clusters/{name}/fargate-profiles/{fargateProfileName}','/aws/api/v1/container/eks/clusters/{name}/fargate-profiles/{fargateProfileName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','container','eks','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a427a51-8e8b-11ee-a47a-a6869ab29cd8','admin : DELETE/storage/objects/{bucketName}','admin : DELETE/storage/objects/{bucketName}','/storage/objects/{bucketName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storage','storage','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a42c4d4-8e8b-11ee-a47a-a6869ab29cd8','admin : DELETE/storage/buckets/{bucketName}','admin : DELETE/storage/buckets/{bucketName}','/storage/buckets/{bucketName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storage','storage','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4a4fb0a7-258f-11f0-acfd-fecd16557305','svd-서비스-템플릿 정보수정','svd-서비스-템플릿 정보수정','/service-desk-templates/info','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-desk-template','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4a515c39-258f-11f0-acfd-fecd16557305','svd-서비스-템플릿 이름 중복조회','svd-서비스-템플릿 이름 중복조회','/service-desk-templates/name-check','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-desk-template','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4a8bb420-c9aa-11ef-9c74-0a11b82fa8dd','보안 그룹 규칙 수정','보안 그룹 규칙 수정','/security-groups/rule','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','PATCH',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4b4e9487-d9f3-11ee-bd1a-bed5f84892d5','server storage 생성','server storage 생성','/compute/storages','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server storage','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4b4f7bbf-d9f3-11ee-bd1a-bed5f84892d5','admin : POST/compute/storages/detach','admin : POST/compute/storages/detach','/compute/storages/detach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server storage','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4b500c43-d9f3-11ee-bd1a-bed5f84892d5','admin : POST/compute/storages/attach','admin : POST/compute/storages/attach','/compute/storages/attach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server storage','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4b5061b8-d9f3-11ee-bd1a-bed5f84892d5','admin : GET/compute/storages/{serverStorageId}','admin : GET/compute/storages/{serverStorageId}','/compute/storages/{serverStorageId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server storage','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4b50aa8b-d9f3-11ee-bd1a-bed5f84892d5','admin : DELETE/compute/storages/{serverStorageId}','admin : DELETE/compute/storages/{serverStorageId}','/compute/storages/{serverStorageId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server storage','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('4b6b4709-4019-11ef-9f42-5e230e3817dd','프로젝트 ID로 LoadBalancer 목록 조회','프로젝트 ID로 LoadBalancer 목록 조회','/load-balancer/connected-loadbalancer/{lbProjectId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4b6b96b3-4019-11ef-9f42-5e230e3817dd','프로젝트 ID로 LoadBalancer 목록 조회','프로젝트 ID로 LoadBalancer 목록 조회','/load-balancer/connected-loadbalancer/{lbProjectId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4c1b7291-fe0c-11ee-b354-0eff8aa9f4e3','Image 메타데이터 API','Image 메타데이터 API','/compute/images/{imageId}/metadata','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','glance','image','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4c1bef6e-fe0c-11ee-b354-0eff8aa9f4e3','Image 메타데이터 API','Image 메타데이터 API','/compute/images/{imageId}/metadata','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','glance','image','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4d04f9d1-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 수정 API','볼륨 그룹 수정 API','/block-storage/volume-group/{volumeGroupId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4d054fcd-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 타입 상세 조회 API','볼륨 그룹 타입 상세 조회 API','/block-storage/volume-group-types/{volumeGroupTypeId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4d058bf2-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 타입 수정 API','볼륨 그룹 타입 수정 API','/block-storage/volume-group-types/{volumeGroupTypeId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4d05c8e4-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 타입 수정 API','볼륨 그룹 타입 수정 API','/block-storage/volume-group-type-specss/{volumeGroupTypeSpecId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4d06048a-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 스냅샷 상세 조회 API','볼륨 그룹 스냅샷 상세 조회 API','/block-storage/volume-group-snapshots/{volumeGroupSnapshotId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4d063940-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 스냅샷 수정 API','볼륨 그룹 스냅샷 수정 API','/block-storage/volume-group-snapshots/{volumeGroupSnapshotId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4d066c20-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 생성 API','볼륨 그룹 생성 API','/block-storage/volume-group','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4d06a53b-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 삭제 API','볼륨 그룹 삭제 API','/block-storage/volume-group','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4d06d2d0-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 타입 목록 조회 API','볼륨 그룹 타입 목록 조회 API','/block-storage/volume-group-types','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4d06fe88-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 타입 생성 API','볼륨 그룹 타입 생성 API','/block-storage/volume-group-types','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4d072a82-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 타입 삭제 API','볼륨 그룹 타입 삭제 API','/block-storage/volume-group-types','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4d075380-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 타입 스펙 생성 API','볼륨 그룹 타입 스펙 생성 API','/block-storage/volume-group-type-specs','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4d078279-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 타입 스펙 삭제 API','볼륨 그룹 타입 스펙 삭제 API','/block-storage/volume-group-type-specs','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4d07b72a-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 스냅샷 목록 조회 API','볼륨 그룹 스냅샷 목록 조회 API','/block-storage/volume-group-snapshots','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4d07e7c9-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 스냅샷 생성 API','볼륨 그룹 스냅샷 생성 API','/block-storage/volume-group-snapshots','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4d0817e4-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 스냅샷 삭제 API','볼륨 그룹 스냅샷 삭제 API','/block-storage/volume-group-snapshots','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4d0846b9-456e-11ef-a4c4-96fd9ef2bacb','It brings the Physical Network name that must be entered when creating a management network with VLAN.','It brings the Physical Network name that must be entered when creating a management network with VLAN.','/mole/ovs','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','vip','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4d08783f-456e-11ef-a4c4-96fd9ef2bacb','가상 자원 개요 전체 CPU, 전체 Memory, 서버 리소스','가상 자원 개요 전체 CPU, 전체 Memory, 서버 리소스','/dashboard/compute/servers/server-resource','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','dashboard','prometheus','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4d08afd0-456e-11ef-a4c4-96fd9ef2bacb','가상 자원 개요 전체 스토리지','가상 자원 개요 전체 스토리지','/dashboard/compute/servers/hypervisor-server-resource','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','dashboard','hypervisor','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4d08e6ee-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 목록 조회 API','볼륨 그룹 목록 조회 API','/block-storage/volume-groups','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4d0918d6-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 상세 조회 API','볼륨 그룹 상세 조회 API','/block-storage/volume-groups/{volumeGroupId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4d094407-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 타입 스펙 목록 조회 API','볼륨 그룹 타입 스펙 목록 조회 API','/block-storage/volume-group-types/{volumeGroupTypeId}/volume-group-type-specs','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4d096d6e-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 타입 스펙 상세 조회 API','볼륨 그룹 타입 스펙 상세 조회 API','/block-storage/volume-group-types/{volumeGroupTypeId}/volume-group-type-specs/{volumeGroupTypeSpecId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4d099c90-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 수정 API','볼륨 그룹 수정 API','/block-storage/volume-group/{volumeGroupId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','PUT',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4d09ca41-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 타입 상세 조회 API','볼륨 그룹 타입 상세 조회 API','/block-storage/volume-group-types/{volumeGroupTypeId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4d09fb0d-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 타입 수정 API','볼륨 그룹 타입 수정 API','/block-storage/volume-group-types/{volumeGroupTypeId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','PUT',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4d0a2aba-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 타입 수정 API','볼륨 그룹 타입 수정 API','/block-storage/volume-group-type-specss/{volumeGroupTypeSpecId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','PUT',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4d0a59ab-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 스냅샷 상세 조회 API','볼륨 그룹 스냅샷 상세 조회 API','/block-storage/volume-group-snapshots/{volumeGroupSnapshotId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4d0a83ea-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 스냅샷 수정 API','볼륨 그룹 스냅샷 수정 API','/block-storage/volume-group-snapshots/{volumeGroupSnapshotId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','PUT',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4d0ab4ed-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 생성 API','볼륨 그룹 생성 API','/block-storage/volume-group','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4d0ae376-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 삭제 API','볼륨 그룹 삭제 API','/block-storage/volume-group','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','DELETE',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4d0b0e97-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 타입 목록 조회 API','볼륨 그룹 타입 목록 조회 API','/block-storage/volume-group-types','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4d0b39e2-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 타입 생성 API','볼륨 그룹 타입 생성 API','/block-storage/volume-group-types','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4d0b6f34-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 타입 삭제 API','볼륨 그룹 타입 삭제 API','/block-storage/volume-group-types','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','DELETE',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4d0ba1ac-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 타입 스펙 생성 API','볼륨 그룹 타입 스펙 생성 API','/block-storage/volume-group-type-specs','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4d0bd52e-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 타입 스펙 삭제 API','볼륨 그룹 타입 스펙 삭제 API','/block-storage/volume-group-type-specs','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','DELETE',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4d0c0152-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 스냅샷 목록 조회 API','볼륨 그룹 스냅샷 목록 조회 API','/block-storage/volume-group-snapshots','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4d0c3103-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 스냅샷 생성 API','볼륨 그룹 스냅샷 생성 API','/block-storage/volume-group-snapshots','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4d0c5b80-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 스냅샷 삭제 API','볼륨 그룹 스냅샷 삭제 API','/block-storage/volume-group-snapshots','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','DELETE',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4d0c8b6d-456e-11ef-a4c4-96fd9ef2bacb','It brings the Physical Network name that must be entered when creating a management network with VLAN.','It brings the Physical Network name that must be entered when creating a management network with VLAN.','/mole/ovs','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','vip','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4d0cb4fd-456e-11ef-a4c4-96fd9ef2bacb','가상 자원 개요 전체 CPU, 전체 Memory, 서버 리소스','가상 자원 개요 전체 CPU, 전체 Memory, 서버 리소스','/dashboard/compute/servers/server-resource','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','dashboard','prometheus','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4d0ce3dd-456e-11ef-a4c4-96fd9ef2bacb','가상 자원 개요 전체 스토리지','가상 자원 개요 전체 스토리지','/dashboard/compute/servers/hypervisor-server-resource','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','dashboard','hypervisor','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4d0d0ed5-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 목록 조회 API','볼륨 그룹 목록 조회 API','/block-storage/volume-groups','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4d0d39a6-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 상세 조회 API','볼륨 그룹 상세 조회 API','/block-storage/volume-groups/{volumeGroupId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4d0d6661-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 타입 스펙 목록 조회 API','볼륨 그룹 타입 스펙 목록 조회 API','/block-storage/volume-group-types/{volumeGroupTypeId}/volume-group-type-specs','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4d0d9910-456e-11ef-a4c4-96fd9ef2bacb','볼륨 그룹 타입 스펙 상세 조회 API','볼륨 그룹 타입 스펙 상세 조회 API','/block-storage/volume-group-types/{volumeGroupTypeId}/volume-group-type-specs/{volumeGroupTypeSpecId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4dd817cd-1114-11f0-8e4c-52e9553a2057','플랫폼 과금 인스턴스 정책 조회','플랫폼 과금 인스턴스 정책 조회','/data/finops/instancePolicy','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','billing','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('4dd910dc-1114-11f0-8e4c-52e9553a2057','플랫폼 과금 기본 정책 조회','플랫폼 과금 기본 정책 조회','/data/finops/basePolicy','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','billing','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('4dd95a3c-1114-11f0-8e4c-52e9553a2057','IP Pool Physical 활성 여부 수정','IP Pool Physical 활성 여부 수정','/ip-pool-physical/{ipPoolPhysicalId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','ip pool physical','PATCH',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4def696d-716e-11ef-a7e3-025bd9f6f87b','최적화 방안 현황 조회 API','최적화 방안 현황 조회 API','/resource/provider/{providerId}/current','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','drs','resource','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4defdf70-716e-11ef-a7e3-025bd9f6f87b','최적화 방안 현황 조회 API','최적화 방안 현황 조회 API','/resource/provider/{providerId}/current','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','drs','resource','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4ecb52a4-52e4-11ef-8f18-c6494ca007d9','볼륨 그룹 타입 스펙 수정 API','볼륨 그룹 타입 스펙 수정 API','/block-storage/volume-group-types/{volumeGroupTypeId}/volume-group-type-specs/{volumeGroupTypeSpecId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4ecbb0ef-52e4-11ef-8f18-c6494ca007d9','볼륨 그룹 타입 스펙 생성 API','볼륨 그룹 타입 스펙 생성 API','/block-storage/volume-group-types/{volumeGroupTypeId}/volume-group-type-specs','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4ecbe550-52e4-11ef-8f18-c6494ca007d9','볼륨 그룹 타입 스펙 삭제 API','볼륨 그룹 타입 스펙 삭제 API','/block-storage/volume-group-types/{volumeGroupTypeId}/volume-group-type-specs','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4ecc1a81-52e4-11ef-8f18-c6494ca007d9','disk search','disk search','/mole/disk','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','host','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4ecc4ee5-52e4-11ef-8f18-c6494ca007d9','볼륨 그룹 타입 스펙 수정 API','볼륨 그룹 타입 스펙 수정 API','/block-storage/volume-group-types/{volumeGroupTypeId}/volume-group-type-specs/{volumeGroupTypeSpecId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','PUT',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4ecc84de-52e4-11ef-8f18-c6494ca007d9','볼륨 그룹 타입 스펙 생성 API','볼륨 그룹 타입 스펙 생성 API','/block-storage/volume-group-types/{volumeGroupTypeId}/volume-group-type-specs','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4eccb8cc-52e4-11ef-8f18-c6494ca007d9','볼륨 그룹 타입 스펙 삭제 API','볼륨 그룹 타입 스펙 삭제 API','/block-storage/volume-group-types/{volumeGroupTypeId}/volume-group-type-specs','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','DELETE',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('4ecce757-52e4-11ef-8f18-c6494ca007d9','disk search','disk search','/mole/disk','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','host','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4f864ad0-b83e-11ef-9c74-0a11b82fa8dd','rack id 기준 switch 목록 조회','rack id 기준 switch 목록 조회','/topology/switch/rack/{rackId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','topology','rack-topology','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4f86f196-b83e-11ef-9c74-0a11b82fa8dd','cm_provider 목록 조회','cm_provider 목록 조회','/topology/provider','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','topology','cmprovider','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4f872834-b83e-11ef-9c74-0a11b82fa8dd','host 상세 조회','host 상세 조회','/topology/host/{hostId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','topology','rack-topology','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4f875399-b83e-11ef-9c74-0a11b82fa8dd','rack id 기준 host 목록 조회','rack id 기준 host 목록 조회','/topology/host/rack/{rackId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','topology','rack-topology','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('4f8780f7-b83e-11ef-9c74-0a11b82fa8dd','rack id 기준 switch 목록 조회','rack id 기준 switch 목록 조회','/topology/switch/rack/{rackId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','topology','rack-topology','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4f87a90a-b83e-11ef-9c74-0a11b82fa8dd','cm_provider 목록 조회','cm_provider 목록 조회','/topology/provider','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','topology','cmprovider','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4f87d0a0-b83e-11ef-9c74-0a11b82fa8dd','host 상세 조회','host 상세 조회','/topology/host/{hostId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','topology','rack-topology','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('4f87f71b-b83e-11ef-9c74-0a11b82fa8dd','rack id 기준 host 목록 조회','rack id 기준 host 목록 조회','/topology/host/rack/{rackId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','topology','rack-topology','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('50b2cef6-81f1-11ee-a4fd-dadafdb14cb0','특정 계층에서 역할 가진 사용자 검색','특정 계층에서 역할 가진 사용자 검색','/user/access-control/resource/{resourceId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','access-control','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('50b515b0-81f1-11ee-a4fd-dadafdb14cb0','특정 멤버 상세 조회(계층 관계없이 가지는 역할 검색)','특정 멤버 상세 조회(계층 관계없이 가지는 역할 검색)','/user/access-control/member/{memberId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','access-control','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('50b71107-81f1-11ee-a4fd-dadafdb14cb0','특정 멤버가 특정 계층에서 가지는 역할 검색','특정 멤버가 특정 계층에서 가지는 역할 검색','/user/access-control/member/{memberId}/resource/{resourceId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','access-control','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('50b8aab0-81f1-11ee-a4fd-dadafdb14cb0','사용자 및 그룹 조회(with email)','사용자 및 그룹 조회(with email)','/user/access-control/filter','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','access-control','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('50b9fd40-81f1-11ee-a4fd-dadafdb14cb0','폴더 / 워크스페이스 이름으로 계층 검색','폴더 / 워크스페이스 이름으로 계층 검색','/folder/hier-search','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('510d9bad-06b9-11ef-8bb1-cee8dc1678f7','워크스페이스 디플로이먼트 목록 조회 API','워크스페이스 디플로이먼트 목록 조회 API','/workspaces/deployments','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','deployment','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('51182832-06b9-11ef-8bb1-cee8dc1678f7','특정 폴더(혹은 조직) / 워크스페이스에서 승인 권한 가진 사용자 검색','특정 폴더(혹은 조직) / 워크스페이스에서 승인 권한 가진 사용자 검색','/user/approver','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','management','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('51401158-fe0a-11ee-b354-0eff8aa9f4e3','일대일 문의 상태 변경','일대일 문의 상태 변경','/boards/requests/{boardId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','request board','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('5140b378-fe0a-11ee-b354-0eff8aa9f4e3','일대일 문의 수정','일대일 문의 수정','/boards/requests/{boardId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','request board','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('51412822-fe0a-11ee-b354-0eff8aa9f4e3','일대일 문의 등록','일대일 문의 등록','/boards/requests','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','request board','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('5141a2f5-fe0a-11ee-b354-0eff8aa9f4e3','일대일 문의 상태 수정','일대일 문의 상태 수정','/boards/requests/{boardId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','request board','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('5141f9f8-fe0a-11ee-b354-0eff8aa9f4e3','일대일 문의 수정','일대일 문의 수정','/boards/requests/{boardId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','request board','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('51424902-fe0a-11ee-b354-0eff8aa9f4e3','일대일 문의 등록','일대일 문의 등록','/boards/requests','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','request board','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('5142934d-fe0a-11ee-b354-0eff8aa9f4e3','워크스페이스 로드 밸런서 목록 조회 API','워크스페이스에 속한 로드 밸런서 목록 조회','/workspaces/load-balancers','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','load balancer','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('51587360-e14b-11ee-84a7-5e1f35257281','admin : GET/network/vpc/vpcs/todo',NULL,'/network/vpc/vpcs/todo','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('5158d019-e14b-11ee-84a7-5e1f35257281','admin : POST/network/vpc/vpcs/todo',NULL,'/network/vpc/vpcs/todo','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('5159016e-e14b-11ee-84a7-5e1f35257281','admin : POST/network/subnets/todo',NULL,'/network/subnets/todo','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','subnet','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('515930af-e14b-11ee-84a7-5e1f35257281','loginKey 전체 조회','loginKey 전체 조회','/compute/keys','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','login key','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('51595c82-e14b-11ee-84a7-5e1f35257281','loginKey 키페어 생성','loginKey 키페어 생성','/compute/keys','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','login key','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('515988ce-e14b-11ee-84a7-5e1f35257281','admin : GET/network/vpc/vpcs/{vpcId}/todo',NULL,'/network/vpc/vpcs/{vpcId}/todo','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('5159b6c2-e14b-11ee-84a7-5e1f35257281','admin : DELETE/network/vpc/vpcs/{vpcId}/todo',NULL,'/network/vpc/vpcs/{vpcId}/todo','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('5159e34e-e14b-11ee-84a7-5e1f35257281','admin : GET/network/subnet/subnets/{subnetId}/todo',NULL,'/network/subnet/subnets/{subnetId}/todo','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','subnet','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('515a1083-e14b-11ee-84a7-5e1f35257281','admin : GET/network/subnet/subnets/todo',NULL,'/network/subnet/subnets/todo','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','subnet','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('515a3cc8-e14b-11ee-84a7-5e1f35257281','admin : GET/network/subnet/subnets/by-vpc/{vpcId}/todo',NULL,'/network/subnet/subnets/by-vpc/{vpcId}/todo','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','subnet','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('515a69be-e14b-11ee-84a7-5e1f35257281','admin : GET/network/route/tables/todo',NULL,'/network/route/tables/todo','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('515a950e-e14b-11ee-84a7-5e1f35257281','loginKey 일부 조회','loginKey 일부 조회','/compute/keys/{loginKeyId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','login key','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('515abfa9-e14b-11ee-84a7-5e1f35257281','admin : DELETE/compute/keys/{loginKeyId}','admin : DELETE/compute/keys/{loginKeyId}','/compute/keys/{loginKeyId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','login key','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('515aed3f-e14b-11ee-84a7-5e1f35257281','admin : DELETE/network/subnets/{subnetId}/todo',NULL,'/network/subnets/{subnetId}/todo','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','subnet','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('51ff7765-6441-11ef-aa9f-f2cdef6842ce','서비스 상품 전체 조회','서비스 상품 전체 조회','/products','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-product','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('52564589-19a1-11ef-bc41-1ecbd3ef6ccd','사용자 알림 관련 정보 삭제 API','사용자 알림 관련 정보 삭제 API','/{userId}/info','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','notification','DELETE',1,'dc347010-c3f4-11ee-8281-7e177595258d',0)
    ,   ('52568cae-19a1-11ef-bc41-1ecbd3ef6ccd','admin-finops : GET/cost/total-analysis/organization/folders','admin-finops : GET/cost/total-analysis/organization/folders','/cost/total-analysis/organization/folders','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','cost','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('52571867-19a1-11ef-bc41-1ecbd3ef6ccd','클라우드 플랫폼 서비스 별 비용 분석','클라우드 플랫폼 서비스 별 비용 분석','/cost/platform/total-analysis/day/cloud-platform/service','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','cost','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('525762d9-19a1-11ef-bc41-1ecbd3ef6ccd','서비스 신청 카테고리 삭제 API','서비스 신청 카테고리 삭제 API','/service-objects/requests/type/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('5257a8ab-19a1-11ef-bc41-1ecbd3ef6ccd','가상머신 별 이상탐지 Top5 조회','가상머신 별 이상탐지 Top5 조회','/ai/anomaly-detection/servers/top5/{dayCount}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','ai','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('53a701f6-55f5-11ef-97d4-9676f6708993','클러스터 롤 바인딩 생성','클러스터 롤 바인딩 생성','/v1/k8s/clusterrolebindings','345ae518-f857-11ed-921d-aa1950d374e1','Viola','serviceaccount','clusterrolebinding','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('53ceadf1-2fad-11f0-92ed-2e5d1099d8b8','플랫폼별 공급자 리스트 조회','플랫폼별 공급자 리스트 조회','/data/finops/provider/{platformType}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','billing','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('53cee82d-ade7-11ee-94e4-eea823231fc8','커뮤니티 게시글 목록 조회','커뮤니티 게시글 목록 조회','/boards','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','board','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('53d0745f-ade7-11ee-94e4-eea823231fc8','커뮤니티 게시글 상세 조회','커뮤니티 게시글 상세 조회','/boards/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','board','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('53f72d7b-36d3-11f0-80c3-6e593baabd40','Ec2 Instance 작동중지','Ec2 Instance 작동중지','/compute/servers/hibernate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('53f7fbf6-36d3-11f0-80c3-6e593baabd40','Ec2 Instance 다중 삭제','Ec2 Instance 다중 삭제','/compute/servers','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('53f8607a-36d3-11f0-80c3-6e593baabd40','Managed Prefix List 전체 조회','Managed Prefix List 전체 조회','/network/managed-prefix','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','managed prefix','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('53f88896-36d3-11f0-80c3-6e593baabd40','admin : GET/compute/servers/temp','admin : GET/compute/servers/temp','/compute/servers/temp','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('53f8b514-36d3-11f0-80c3-6e593baabd40','버킷 암호화 설정 변경','버킷 암호화 설정 변경','/storages/buckets/{bucketName}/encryption','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53f8e35a-36d3-11f0-80c3-6e593baabd40','보안 그룹 규칙 수정','보안 그룹 규칙 수정','/security-groups/rules','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53f9124c-36d3-11f0-80c3-6e593baabd40','도메인 리스트 삭제','도메인 리스트 삭제','/route53s/domains/list','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53f93d46-36d3-11f0-80c3-6e593baabd40','도메인 서버 이름 변경','도메인 서버 이름 변경','/route53s/domains/dns-change','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53f96ee5-36d3-11f0-80c3-6e593baabd40','Dnssec 해제','Dnssec 해제','/route53s/domains/delegation-signer','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53f992e7-36d3-11f0-80c3-6e593baabd40','Dnssec 등록','Dnssec 등록','/route53s/domains/delegation-signer','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53f9b922-36d3-11f0-80c3-6e593baabd40','Route 수정','Route 수정','/network/routes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','router','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53f9daff-36d3-11f0-80c3-6e593baabd40','Route 생성','Route 생성','/network/routes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','router','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53f9fc7e-36d3-11f0-80c3-6e593baabd40','Route 삭제','Route 삭제','/network/routes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','router','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('53fa23e9-36d3-11f0-80c3-6e593baabd40','리스너 속성 조회','리스너 속성 조회','/load-balancers/listeners/attributes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancers listeners','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fa52c5-36d3-11f0-80c3-6e593baabd40','Ec2 Instance 작동중지','Ec2 Instance 작동중지','/compute/servers/hibernate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fa7ab7-36d3-11f0-80c3-6e593baabd40','오토스케일링 정책 설정 요청 제어','오토스케일링 정책 설정 요청 제어','/autoscaling/provisioning/groups/policies','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53faa4e2-36d3-11f0-80c3-6e593baabd40','도메인 등록','도메인 등록','/route53s/domains','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fac6b7-36d3-11f0-80c3-6e593baabd40','도메인 갱신','도메인 갱신','/route53s/domains/renew','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fae05e-36d3-11f0-80c3-6e593baabd40','도메인 자동 갱신 활성화','도메인 자동 갱신 활성화','/route53s/domains/renew/enable','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53faf702-36d3-11f0-80c3-6e593baabd40','도메인 자동 갱신 비활성화','도메인 자동 갱신 비활성화','/route53s/domains/renew/disable','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fb1186-36d3-11f0-80c3-6e593baabd40','도메인 리스트 등록','도메인 리스트 등록','/route53s/domains/register/list','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fb2ffb-36d3-11f0-80c3-6e593baabd40','도메인 연락처 수정','도메인 연락처 수정','/route53s/domains/contact','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fb47c1-36d3-11f0-80c3-6e593baabd40','리스너 인증서 조회','리스너 인증서 조회','/load-balancers/listeners/certificates','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancers listeners','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fbb5b2-36d3-11f0-80c3-6e593baabd40','업로드서버인증서','업로드서버인증서','/iam/users/server-certificate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','user','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fc0ce2-36d3-11f0-80c3-6e593baabd40','Ec2 Instance 다중 삭제','Ec2 Instance 다중 삭제','/compute/servers','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fc2895-36d3-11f0-80c3-6e593baabd40','퀵 스타트 AMI 저장','퀵 스타트 AMI 저장','/compute/amis/quickstart','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','ami','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fc43d0-36d3-11f0-80c3-6e593baabd40','user : POST/autoscaling/metrics/enable','user : POST/autoscaling/metrics/enable','/autoscaling/metrics/enable','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','metric','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fc5ca0-36d3-11f0-80c3-6e593baabd40','user : POST/autoscaling/metrics/disable','user : POST/autoscaling/metrics/disable','/autoscaling/metrics/disable','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','metric','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fc731d-36d3-11f0-80c3-6e593baabd40','acm 인증서 조회','acm 인증서 조회','/acm/certificates/acm-certificate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','acm','certificate','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fc8a04-36d3-11f0-80c3-6e593baabd40','acm 인증서 생성','acm 인증서 생성','/acm/certificates/acm-certificate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','acm','certificate','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fca331-36d3-11f0-80c3-6e593baabd40','user : GET/storages/objects/buckets/{bucketName}/encryption','user : GET/storages/objects/buckets/{bucketName}/encryption','/storages/objects/buckets/{bucketName}/encryption','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fcc2a3-36d3-11f0-80c3-6e593baabd40','user : GET/route53s/match-domain-vpc/{domainName}','user : GET/route53s/match-domain-vpc/{domainName}','/route53s/match-domain-vpc/{domainName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fcd827-36d3-11f0-80c3-6e593baabd40','Get HostedZone','Get HostedZone','/route53s/hosted-zone/{hostedZoneId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('53fcf7b6-36d3-11f0-80c3-6e593baabd40','이전 잠금 비활성','이전 잠금 비활성','/route53s/domains/unlock/{domainName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fd1d38-36d3-11f0-80c3-6e593baabd40','연락 가능 여부 확인 이메일 재전송','연락 가능 여부 확인 이메일 재전송','/route53s/domains/resend/{domainName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fd3a71-36d3-11f0-80c3-6e593baabd40','이전 잠금 활성','이전 잠금 활성','/route53s/domains/lock/{domainName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fd54d3-36d3-11f0-80c3-6e593baabd40','도메인 비용조회','도메인 비용조회','/route53s/domains/cost/{domainName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fd6e40-36d3-11f0-80c3-6e593baabd40','사용가능 도메인 체크','사용가능 도메인 체크','/route53s/domains/checks','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fd8a48-36d3-11f0-80c3-6e593baabd40','Managed Prefix List 전체 조회','Managed Prefix List 전체 조회','/network/managed-prefix','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','managed prefix','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fda53e-36d3-11f0-80c3-6e593baabd40','로드벨런서 신뢰 저장소 조회','로드벨런서 신뢰 저장소 조회','/load-balancers/trust-store','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancer','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fdc4c7-36d3-11f0-80c3-6e593baabd40','로드벨런서 SSL 정책 조회','로드벨런서 SSL 정책 조회','/load-balancers/ssl-policy','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancer','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fde36a-36d3-11f0-80c3-6e593baabd40','로드벨런서 정책 조회','로드벨런서 정책 조회','/load-balancers/policy','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancer','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fdfd0f-36d3-11f0-80c3-6e593baabd40','서버 인증서 조회','서버 인증서 조회','/iam/certificates/server-certificate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','certificate','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fe16ac-36d3-11f0-80c3-6e593baabd40','서버 인증서 목록 조회','서버 인증서 목록 조회','/iam/certificates/server-certificates','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','iam','certificate','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fe32de-36d3-11f0-80c3-6e593baabd40','시작 템플릿 중복 체크','시작 템플릿 중복 체크','/ec2/launchtemplates/duplication-checker','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','ec2','launchtemplate','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fe4cf6-36d3-11f0-80c3-6e593baabd40','user : GET/compute/servers/temp','user : GET/compute/servers/temp','/compute/servers/temp','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53feabb7-36d3-11f0-80c3-6e593baabd40','user : GET/autoscaling/metrics/types','user : GET/autoscaling/metrics/types','/autoscaling/metrics/types','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','metric','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53ff32fc-36d3-11f0-80c3-6e593baabd40','user : GET/autoscaling/groups/{autoScalingGroupName}/policies','user : GET/autoscaling/groups/{autoScalingGroupName}/policies','/autoscaling/groups/{autoScalingGroupName}/policies','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53ffb819-36d3-11f0-80c3-6e593baabd40','user : GET/autoscaling/groups/check/{groupName}','user : GET/autoscaling/groups/check/{groupName}','/autoscaling/groups/check/{groupName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53ffda55-36d3-11f0-80c3-6e593baabd40','acm 인증서 목록 조회','acm 인증서 목록 조회','/acm/certificates/acm-certificates','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','acm','certificate','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('53fff4bb-36d3-11f0-80c3-6e593baabd40','도메인 삭제','도메인 삭제','/route53s/domains/{domainName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','route53','route','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('54000fc0-36d3-11f0-80c3-6e593baabd40','오토스케일링 정책 삭제','오토스케일링 정책 삭제','/autoscaling/provisioning/groups/{autoScalingGroupName}/policies/{policyName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('54a3b6ef-06b9-11ef-8bb1-cee8dc1678f7','VPC cidr block 해제','VPC cidr block 해제','/network/vpcs/disassociate/cidr-block','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('54a43d32-06b9-11ef-8bb1-cee8dc1678f7','VPC cidr block 연결','VPC cidr block 연결','/network/vpcs/associate/cidr-block','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('54a4c1f6-06b9-11ef-8bb1-cee8dc1678f7','라우팅 테이블 연결 해제','라우팅 테이블 연결 해제','/network/route/disassociate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('54a53d41-06b9-11ef-8bb1-cee8dc1678f7','라우팅 테이블 연결','라우팅 테이블 연결','/network/route/associate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('54a58f66-06b9-11ef-8bb1-cee8dc1678f7','ACL 재할당','ACL 재할당','/network/acls','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','acl','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('54a5ec0e-06b9-11ef-8bb1-cee8dc1678f7','ACL 생성','ACL 생성','/network/acls','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','acl','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('54a63ac7-06b9-11ef-8bb1-cee8dc1678f7','ACL 삭제','ACL 삭제','/network/acls','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','acl','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('54a696fc-06b9-11ef-8bb1-cee8dc1678f7','VPC 목록','VPC 목록','/network/vpcs','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('54a6e58b-06b9-11ef-8bb1-cee8dc1678f7','VPC 생성','VPC 생성','/network/vpcs','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('54a7354e-06b9-11ef-8bb1-cee8dc1678f7','default VPC 생성','default VPC 생성','/network/vpcs/default','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('54a78287-06b9-11ef-8bb1-cee8dc1678f7','Subnet 목록 조회','Subnet 목록 조회','/network/subnets','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','subnet','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('54a7d077-06b9-11ef-8bb1-cee8dc1678f7','default Subnet 생성','default Subnet 생성','/network/subnets/default','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','subnet','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('54ab4675-06b9-11ef-8bb1-cee8dc1678f7','ACL Entry 생성','ACL Entry 생성','/network/acls/entrys','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','acl','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('54ab8e1a-06b9-11ef-8bb1-cee8dc1678f7','ACL Entry삭제','ACL Entry삭제','/network/acls/entrys','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','acl','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('54abe0f1-06b9-11ef-8bb1-cee8dc1678f7','VPC 상세보기','VPC 상세보기','/network/vpcs/{vpcId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('54ac2f81-06b9-11ef-8bb1-cee8dc1678f7','VPC 제거','VPC 제거','/network/vpcs/{vpcId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('54ac87e4-06b9-11ef-8bb1-cee8dc1678f7','서브넷 체크','서브넷 체크','/network/vpcs/{vpcId}/check/subnets/{subnetId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('54acd073-06b9-11ef-8bb1-cee8dc1678f7','VPC 필터 목록','VPC 목록을 필터하여 조회한다.','/network/vpcs/filter','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('54ad1418-06b9-11ef-8bb1-cee8dc1678f7','서브넷 상세보기','서브넷 상세보기','/network/subnets/{subnetId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','subnet','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('54ad5461-06b9-11ef-8bb1-cee8dc1678f7','Subnet 필터 목록','Subnet 목록을 필터하여 조회한다.','/network/subnets/filter','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','subnet','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('54ada2fc-06b9-11ef-8bb1-cee8dc1678f7','VPC와 연관된 Subnet 목록 조회','VPC와 연관된 Subnet 목록 조회','/network/subnets/by-vpc/{vpcId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','subnet','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('54ade827-06b9-11ef-8bb1-cee8dc1678f7','라우팅 테이블 필터하여 조회','라우팅 테이블 필터하여 조회','/network/route/routes/filters','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('54ae2612-06b9-11ef-8bb1-cee8dc1678f7','ACL 목록 Vpc Id 조회','ACL 목록 Vpc Id 조회','/network/acls/by-vpc/{vpcId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','acl','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('55562048-7c9f-11ef-9a6b-ba8787afde77','가상서비스별 게이트웨이 리스트 조회','가상서비스별 게이트웨이 리스트 조회','/v1/k8s/namespaces/{namespaceName}/virtualservices/{virtualServiceName}/gateways','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5556c73d-7c9f-11ef-9a6b-ba8787afde77','가상서비스별 목적지 서비스 조회','가상서비스별 목적지 서비스 조회','/v1/k8s/namespaces/{namespaceName}/virtualservices/{virtualServiceName}/destinationservices','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('555703ac-7c9f-11ef-9a6b-ba8787afde77','게이트웨이별 가상서비스 리스트 조회','게이트웨이별 가상서비스 리스트 조회','/v1/k8s/namespaces/{namespaceName}/gateways/{gatewayName}/virtualservices','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','gateway','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('55573b1a-7c9f-11ef-9a6b-ba8787afde77','트래픽 정책과 연결된 가상서비스 조회','트래픽 정책과 연결된 가상서비스 조회','/v1/k8s/namespaces/{namespaceName}/destinationrules/{destinationRuleName}/virtualservices','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','destinationrule','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('55578818-7c9f-11ef-9a6b-ba8787afde77','트래픽 정책 상세 관리 규칙 조회','트래픽 정책 상세 관리 규칙 조회','/v1/k8s/namespaces/{namespaceName}/destinationrules/{destinationRuleName}/trafficrules','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','destinationrule','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('55596f0f-7c9f-11ef-9a6b-ba8787afde77','가상서비스별 게이트웨이 리스트 조회','가상서비스별 게이트웨이 리스트 조회','/v1/k8s/namespaces/{namespaceName}/virtualservices/{virtualServiceName}/gateways','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5559a698-7c9f-11ef-9a6b-ba8787afde77','가상서비스별 목적지 서비스 조회','가상서비스별 목적지 서비스 조회','/v1/k8s/namespaces/{namespaceName}/virtualservices/{virtualServiceName}/destinationservices','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','virtualservice','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5559e1f8-7c9f-11ef-9a6b-ba8787afde77','게이트웨이별 가상서비스 리스트 조회','게이트웨이별 가상서비스 리스트 조회','/v1/k8s/namespaces/{namespaceName}/gateways/{gatewayName}/virtualservices','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','gateway','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('555a1978-7c9f-11ef-9a6b-ba8787afde77','트래픽 정책과 연결된 가상서비스 조회','트래픽 정책과 연결된 가상서비스 조회','/v1/k8s/namespaces/{namespaceName}/destinationrules/{destinationRuleName}/virtualservices','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','destinationrule','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('555a5b78-7c9f-11ef-9a6b-ba8787afde77','트래픽 정책 상세 관리 규칙 조회','트래픽 정책 상세 관리 규칙 조회','/v1/k8s/namespaces/{namespaceName}/destinationrules/{destinationRuleName}/trafficrules','345ae518-f857-11ed-921d-aa1950d374e1','Viola','servicemesh','destinationrule','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('558dd493-bb2e-11ee-afaf-76fb71c4f9db','가상머신의 스냅샷 등록','가상머신의 스냅샷 등록','/vcenter/vms/{vm-id}/snapshots','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('558e0579-bb2e-11ee-afaf-76fb71c4f9db','스냅샷 되돌리기','스냅샷 되돌리기','/vcenter/vms/{vm-id}/snapshots/{snapshot-id}/revert','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('558f84f6-bb2e-11ee-afaf-76fb71c4f9db','유저 정보 조회','등록된 유저 정보를 조회하는 API','/vcenter/userInfo','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','provider','user','GET',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('558fbf05-bb2e-11ee-afaf-76fb71c4f9db','유저 정보 등록','유저 정보를 등록하는 API','/vcenter/userInfo','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','provider','user','POST',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('559bf615-bb2e-11ee-afaf-76fb71c4f9db','스냅샷 삭제','스냅샷 삭제','/vcenter/vms/{vm-id}/snapshots/{snapshot-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','DELETE',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('559c2e7d-bb2e-11ee-afaf-76fb71c4f9db','스냅샷 수정','스냅샷 수정','/vcenter/vms/{vm-id}/snapshots/{snapshot-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','compute','virtualmachine','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('55a0b659-bb2e-11ee-afaf-76fb71c4f9db','Provider의 북마크 여부 수정','특정 Provider의 북마크 정보를 수정하는 API','/vcenter/provider/{id}/{bookMarkYN}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('55a0e48e-bb2e-11ee-afaf-76fb71c4f9db','Provider 정보 수정','특정 Provider의 정보를 수정하는 API','/vcenter/provider/{id}/selection','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','common','provider','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('55a31e68-bb2e-11ee-afaf-76fb71c4f9db','단일 클러스터 수정','단일 클러스터 수정','/vcenter/clusters/{cluster-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','management','cluster','PATCH',1,'aa4f65a1-abcf-11ee-94e4-eea823231fc8',0)
    ,   ('55dfe2c4-8f23-11ee-a47a-a6869ab29cd8','admin : GET/storage/objects/info/buckets/{bucketName}/**','admin : GET/storage/objects/info/buckets/{bucketName}/**','/storage/objects/info/buckets/{bucketName}/**','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storage','storage','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('5693e3e2-86f7-11ee-a4fd-dadafdb14cb0','워크스페이스 대시보드 내 네임스페이스 목록','워크스페이스 대시보드 내 네임스페이스 목록','/workspace-dashboard/{workspaceId}/namespaces','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','dashboard','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('56954086-86f7-11ee-a4fd-dadafdb14cb0','워크스페이스 대시보드 워크스페이스 정보','워크스페이스 대시보드 워크스페이스 정보','/workspace-dashboard/{workspaceId}/info','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','dashboard','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('569de747-86f7-11ee-a4fd-dadafdb14cb0','역할 삭제','역할 삭제','/roles/{roleId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','role','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('569f1759-86f7-11ee-a4fd-dadafdb14cb0','엔드포인트 삭제','엔드포인트 삭제','/endpoints/{endpointId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','endpoint','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('56a2e223-0d13-11ef-9fbf-8ef2ee3c3984','volume backup modify','volume backup modify','/block-storage/volumes/backups/{backupId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('56a332b8-0d13-11ef-9fbf-8ef2ee3c3984','volume backup schedule modify','volume backup schedule modify','/block-storage/volumes/backups-schedule','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('56a37371-0d13-11ef-9fbf-8ef2ee3c3984','volume backup schedule create','volume backup schedule create','/block-storage/volumes/backups-schedule','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('56a3aadf-0d13-11ef-9fbf-8ef2ee3c3984','volume backup create','volume backup create','/block-storage/volumes/backups','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('56a3e2e8-0d13-11ef-9fbf-8ef2ee3c3984','Volume Backup Delete','Volume Backup Delete','/block-storage/volumes/backups','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('56ae8c7e-fe11-11ee-b354-0eff8aa9f4e3','일대일 문의 목록 조회','일대일 문의 목록 조회','/boards/requests','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','request board','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('56aeee07-fe11-11ee-b354-0eff8aa9f4e3','일대일 문의 상세 조회','일대일 문의 상세 조회','/boards/requests/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','request board','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('56de2e7a-d709-11ef-9c74-0a11b82fa8dd','오토스케일링 정책 설정 요청 제어','오토스케일링 정책 설정 요청 제어','/autoscaling/provisioning/groups/policy','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('56df57d4-15ce-11f0-8e4c-52e9553a2057','로그인 설정 조회','로그인 설정 조회','/option/login-policy','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','option','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('56e106ac-15ce-11f0-8e4c-52e9553a2057','로그인 설정 수정','로그인 설정 수정','/option/login-policy','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','option','PATCH',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('57570bcb-1440-11f0-8e4c-52e9553a2057','svd-서비스-카탈로그 배포','svd-서비스-카탈로그 배포','/service-desk-catalogs/{serviceCatalogId}/deploy','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-desk-catalog','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('575a7a2d-1440-11f0-8e4c-52e9553a2057','사용자 기준 전체 알림 수신 이벤트 삭제 API','사용자 기준 전체 알림 수신 이벤트 삭제 API','/receive-event','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','notification','DELETE',1,'dc347010-c3f4-11ee-8281-7e177595258d',1)
    ,   ('58134233-22f2-11ef-922c-16fe18334070','admin : DELETE/network/route/routes','admin : DELETE/network/route/routes','/network/route/routes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('58138a82-22f2-11ef-922c-16fe18334070','admin : POST/network/internet-gateways/detach','admin : POST/network/internet-gateways/detach','/network/internet-gateways/detach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','gateway','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('5813c77b-22f2-11ef-922c-16fe18334070','admin : POST/network/internet-gateways/attach','admin : POST/network/internet-gateways/attach','/network/internet-gateways/attach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','gateway','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('58140014-22f2-11ef-922c-16fe18334070','Internet GW 중복 조회','Internet GW 중복 조회','/network/internet-gateways/duplicate-checker','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','gateway','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('58148148-22f2-11ef-922c-16fe18334070','quickstart  ami 리스트 조회','quickstart  ami 리스트 조회','/compute/amis/quickstart','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','ami','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('5815d50a-22f2-11ef-922c-16fe18334070','user : POST/network/route/routes','user : POST/network/route/routes','/network/route/routes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('58160cae-22f2-11ef-922c-16fe18334070','user : DELETE/network/route/routes','user : DELETE/network/route/routes','/network/route/routes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('58163ca2-22f2-11ef-922c-16fe18334070','user : POST/network/internet-gateways/detach','user : POST/network/internet-gateways/detach','/network/internet-gateways/detach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','gateway','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('58167608-22f2-11ef-922c-16fe18334070','user : POST/network/internet-gateways/attach','user : POST/network/internet-gateways/attach','/network/internet-gateways/attach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','gateway','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('5816ad52-22f2-11ef-922c-16fe18334070','Internet GW 중복 조회','Internet GW 중복 조회','/network/internet-gateways/duplicate-checker','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','gateway','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('58178687-22f2-11ef-922c-16fe18334070','quickstart  ami 리스트 조회','quickstart  ami 리스트 조회','/compute/amis/quickstart','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','ami','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('5818c4f8-cbfb-11ef-9c74-0a11b82fa8dd','보안 그룹 규칙 수정','보안 그룹 규칙 수정','/security-groups/rules','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('5868fc72-6382-11ef-9a30-f2cdef6842ce','최적화 배치 상태 조회 API','최적화 배치 상태 조회 API','/resource/status','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','drs','resource','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('58695e6f-0e8c-11ef-9fbf-8ef2ee3c3984','가상서비스 수정','가상서비스 수정','/v1/service-mesh/virtualservice/{virtualServiceName}/update','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','servicemesh','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5869a86b-0e8c-11ef-9fbf-8ef2ee3c3984','가상서비스 삭제','가상서비스 삭제','/v1/service-mesh/virtualservice/{virtualServiceName}/delete','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','servicemesh','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5869e9e6-0e8c-11ef-9fbf-8ef2ee3c3984','가상서비스 생성','가상서비스 생성','/v1/service-mesh/virtualservice/create','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','servicemesh','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('586a2c0a-0e8c-11ef-9fbf-8ef2ee3c3984','게이트웨이 수정','게이트웨이 수정','/v1/service-mesh/gateway/{gatewayName}/update','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','servicemesh','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('586a733b-0e8c-11ef-9fbf-8ef2ee3c3984','게이트웨이 삭제','게이트웨이 삭제','/v1/service-mesh/gateway/{gatewayName}/delete','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','servicemesh','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('586ab052-0e8c-11ef-9fbf-8ef2ee3c3984','게이트웨이 생성','게이트웨이 생성','/v1/service-mesh/gateway/create','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','servicemesh','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('586af8a0-6382-11ef-9a30-f2cdef6842ce','인스턴스 Max Resource 조회 API','인스턴스 Max Resource 조회 API','/compute/servers/{instanceId}/max-resources','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('586c9e0a-6382-11ef-9a30-f2cdef6842ce','최적화 배치 상태 조회 API','최적화 배치 상태 조회 API','/resource/status','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','drs','resource','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('586e5535-6382-11ef-9a30-f2cdef6842ce','인스턴스 Max Resource 조회 API','인스턴스 Max Resource 조회 API','/compute/servers/{instanceId}/max-resources','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('587e3c2f-0e8c-11ef-9fbf-8ef2ee3c3984','디플로이먼트 내 레플리카셋 변경','디플로이먼트 내 레플리카셋 변경','/v1/namespaces/{namespaceName}/deployments/{deploymentName}/replicas','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','PATCH',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('587e8c27-0e8c-11ef-9fbf-8ef2ee3c3984','가상서비스 목록 조회','가상서비스 목록 조회','/v1/service-mesh/virtualservices','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','servicemesh','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('587ee6af-0e8c-11ef-9fbf-8ef2ee3c3984','가상서비스 조회','가상서비스 조회','/v1/service-mesh/virtualservice/{virtualServiceName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','servicemesh','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('587f25ee-0e8c-11ef-9fbf-8ef2ee3c3984','가상서비스 yaml 정보 조회','가상서비스 yaml 정보 조회','/v1/service-mesh/virtualservice/{virtualServiceName}/yaml','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','servicemesh','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('587f5c49-0e8c-11ef-9fbf-8ef2ee3c3984','가상서비스 상세 기본정보 조회','가상서비스 상세 기본정보 조회','/v1/service-mesh/virtualservice/{virtualServiceName}/details','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','servicemesh','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('587f9403-0e8c-11ef-9fbf-8ef2ee3c3984','가상서비스 상세 정보(게이트웨이) 조회','가상서비스 상세 정보(게이트웨이) 조회','/v1/service-mesh/virtualservice/{virtualServiceName}/details/gateway','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','servicemesh','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('587fc9ec-0e8c-11ef-9fbf-8ef2ee3c3984','가상서비스 상세 정보(목적지 서비스) 조회','가상서비스 상세 정보(목적지 서비스) 조회','/v1/service-mesh/virtualservice/{virtualServiceName}/details/destinationService','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','servicemesh','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('58800320-0e8c-11ef-9fbf-8ef2ee3c3984','게이트웨이 목록 조회','게이트웨이 목록 조회','/v1/service-mesh/gateways','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','servicemesh','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('58803a47-0e8c-11ef-9fbf-8ef2ee3c3984','게이트웨이 상세 기본정보 조회','게이트웨이 상세 기본정보 조회','/v1/service-mesh/gateway/{gatewayName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','servicemesh','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('58806efa-0e8c-11ef-9fbf-8ef2ee3c3984','게이트웨이 yaml 정보 조회 (json)','게이트웨이 yaml 정보 조회 (json)','/v1/service-mesh/gateway/{gatewayName}/yaml','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','servicemesh','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5880ba05-0e8c-11ef-9fbf-8ef2ee3c3984','게이트웨이 상세 정보 조회 (가상서비스)','게이트웨이 상세 정보 조회 (가상서비스)','/v1/service-mesh/gateway/{gatewayName}/service','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','servicemesh','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5884939c-0e8c-11ef-9fbf-8ef2ee3c3984','멀티 클러스터 별 파드 현황 조회','멀티 클러스터 별 파드 현황 조회','/v1/k8s/multi-clusters/status-info','345ae518-f857-11ed-921d-aa1950d374e1','Viola','monitoring','multi-cluster','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5884cef9-0e8c-11ef-9fbf-8ef2ee3c3984','멀티클러스터 별 매트릭 정보 조회','멀티클러스터 별 매트릭 정보 조회','/v1/k8s/multi-clusters/metrics-info','345ae518-f857-11ed-921d-aa1950d374e1','Viola','monitoring','multi-cluster','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('58e748ab-22f6-11ef-922c-16fe18334070','예산 적용','예산 적용','/budget/apply/{budgetTarget}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','budget','POST',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('58ee5d96-2c72-11ef-9f42-5e230e3817dd','Instance 타입 변경','Instance 타입 변경','/compute/servers/instance-type','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('58eec7b4-2c72-11ef-9f42-5e230e3817dd','nic 수정','nic 수정','/compute/nics','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','network interface','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('58ef4035-2c72-11ef-9f42-5e230e3817dd','Volume Setting Meta data 조회','Volume Setting Meta data 조회','/volumes/meta','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volumes','volume','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('58ef88ec-2c72-11ef-9f42-5e230e3817dd','admin : GET/compute/nics/filters','admin : GET/compute/nics/filters','/compute/nics/filters','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','network interface','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('58efdd29-2c72-11ef-9f42-5e230e3817dd','Instance 타입 변경','Instance 타입 변경','/compute/servers/instance-type','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('58f00404-2c72-11ef-9f42-5e230e3817dd','nic 수정','nic 수정','/compute/nics','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','network interface','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('58f02d2f-2c72-11ef-9f42-5e230e3817dd','Volume Setting Meta data 조회','Volume Setting Meta data 조회','/volumes/meta','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volumes','volume','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('58f0544c-2c72-11ef-9f42-5e230e3817dd','user : GET/compute/nics/filters','user : GET/compute/nics/filters','/compute/nics/filters','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','network interface','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('592ed2c8-4272-11ef-9f42-5e230e3817dd','사용자 포탈 - 컨피그맵 리스트','사용자 포탈 - 컨피그맵 리스트','/v1/configmap','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('593049c0-4272-11ef-9f42-5e230e3817dd','사용자 포탈 - 컨피그맵 리스트','사용자 포탈 - 컨피그맵 리스트','/v1/configmap','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5a45265e-a66e-11ef-8cfe-22e1909bc60f','All Tenants','All Tenants','/v2/tenants/options','910fa43a-7797-11ee-b465-565158862942','Vista','observability','tenant','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('5a45ba2f-a66e-11ef-8cfe-22e1909bc60f','Log Table','Log Table','/v2/logs','910fa43a-7797-11ee-b465-565158862942','Vista','observability','로그','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('5a81385b-ce5d-11ef-9c74-0a11b82fa8dd','ArgoCD 잡 삭제','ArgoCD 잡 삭제','/argocd/application/{serviceName}/job','eeffe021-b1f6-11ee-b0d1-0242ac110002','Trombone','gitopsservice','argocd','DELETE',1,'973e6aaf-27c1-11ef-9f42-5e230e3817dd',0)
    ,   ('5bac0023-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 퍼시스턴트 볼륨 수정','사용자 포탈 - 퍼시스턴트 볼륨 수정','/v1/persistentvolumes/{persistentVolumeName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','volume','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bac5d32-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 퍼시스턴트 볼륨 삭제','사용자 포탈 - 퍼시스턴트 볼륨 삭제','/v1/persistentvolumes/{persistentVolumeName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','volume','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bacabe5-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 네임스페이스 수정','사용자 포탈 - 네임스페이스 수정','/v1/namespaces/{namespaceName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bacf83a-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 네임스페이스 삭제','사용자 포탈 - 네임스페이스 삭제','/v1/namespaces/{namespaceName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bad3be6-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 스테이트풀셋 수정','사용자 포탈 - 스테이트풀셋 수정','/v1/namespaces/{namespaceName}/statefulsets/{statefulsetName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bad7c5b-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 스테이트풀셋 삭제','사용자 포탈 - 스테이트풀셋 삭제','/v1/namespaces/{namespaceName}/statefulsets/{statefulsetName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5badbc15-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 서비스 수정','사용자 포탈 - 서비스 수정','/v1/namespaces/{namespaceName}/services/{serviceName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','network','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bae02d3-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 서비스 삭제','사용자 포탈 - 서비스 삭제','/v1/namespaces/{namespaceName}/services/{serviceName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','network','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bae49cd-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 시크릿 수정','사용자 포탈 - 시크릿 수정','/v1/namespaces/{namespaceName}/secrets/{secretName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bae8a2e-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 시크릿 삭제','사용자 포탈 - 시크릿 삭제','/v1/namespaces/{namespaceName}/secrets/{secretName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5baecf31-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 리소스쿼터 수정','사용자 포탈 - 리소스쿼터 수정','/v1/namespaces/{namespaceName}/resourcequotas/{resourceQuotaName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','management','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5baf0bdb-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 리소스쿼터 삭제','사용자 포탈 - 리소스쿼터 삭제','/v1/namespaces/{namespaceName}/resourcequotas/{resourceQuotaName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','management','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5baf49d5-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 레플리카셋 수정','사용자 포탈 - 레플리카셋 수정','/v1/namespaces/{namespaceName}/replicasets/{replicasetName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('5baf99f6-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 레플리카셋 삭제','사용자 포탈 - 레플리카셋 삭제','/v1/namespaces/{namespaceName}/replicasets/{replicasetName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bafda42-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 파드 수정','사용자 포탈 - 파드 수정','/v1/namespaces/{namespaceName}/pods/{podName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb01856-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 파드 삭제','사용자 포탈 - 파드 삭제','/v1/namespaces/{namespaceName}/pods/{podName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb054ea-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 퍼시스턴트 볼륨 클레임 수정','사용자 포탈 - 퍼시스턴트 볼륨 클레임 수정','/v1/namespaces/{namespaceName}/persistentvolumeclaims/{persistentvolumeclaimName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','volume','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb08e7a-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 퍼시스턴트 볼륨 클레임 삭제','사용자 포탈 - 퍼시스턴트 볼륨 클레임 삭제','/v1/namespaces/{namespaceName}/persistentvolumeclaims/{persistentvolumeclaimName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','volume','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb0c8e5-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 네트워크 폴리시 수정','사용자 포탈 - 네트워크 폴리시 수정','/v1/namespaces/{namespaceName}/networkpolicies/{networkPolicyName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','network','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb1311c-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 네트워크 폴리시 삭제','사용자 포탈 - 네트워크 폴리시 삭제','/v1/namespaces/{namespaceName}/networkpolicies/{networkPolicyName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','network','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb16f1a-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 작업 수정','사용자 포탈 - 작업 수정','/v1/namespaces/{namespaceName}/jobs/{jobName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb1a59f-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 작업 삭제','사용자 포탈 - 작업 삭제','/v1/namespaces/{namespaceName}/jobs/{jobName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb1e13b-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 인그레스 수정','사용자 포탈 - 인그레스 수정','/v1/namespaces/{namespaceName}/ingresses/{ingressName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','network','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb217b8-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 인그레스 삭제','사용자 포탈 - 인그레스 삭제','/v1/namespaces/{namespaceName}/ingresses/{ingressName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','network','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb24d06-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 오토스케일러 수정','사용자 포탈 - 오토스케일러 수정','/v1/namespaces/{namespaceName}/horizontalpodautoscalers/{horizontalPodAutoScalerName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb280a5-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 오토스케일러 삭제','사용자 포탈 - 오토스케일러 삭제','/v1/namespaces/{namespaceName}/horizontalpodautoscalers/{horizontalPodAutoScalerName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb2b6fd-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 디플로이먼트 수정','사용자 포탈 - 디플로이먼트 수정','/v1/namespaces/{namespaceName}/deployments/{deploymentName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb2ebc8-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 디플로이먼트 삭제','사용자 포탈 - 디플로이먼트 삭제','/v1/namespaces/{namespaceName}/deployments/{deploymentName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb320f8-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 데몬셋 수정','사용자 포탈 - 데몬셋 수정','/v1/namespaces/{namespaceName}/daemonsets/{daemonsetName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb36465-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 데몬셋 삭제','사용자 포탈 - 데몬셋 삭제','/v1/namespaces/{namespaceName}/daemonsets/{daemonsetName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb39e1e-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - Cron 작업 수정','사용자 포탈 - Cron 작업 수정','/v1/namespaces/{namespaceName}/cronjobs/{cronJobName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb3d71a-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - Cron 작업 삭제','사용자 포탈 - Cron 작업 삭제','/v1/namespaces/{namespaceName}/cronjobs/{cronJobName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb40469-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 컨피그맵 수정','사용자 포탈 - 컨피그맵 수정','/v1/namespaces/{namespaceName}/configmaps/{configMapName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('5bb43955-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 컨피그맵 삭제','사용자 포탈 - 컨피그맵 삭제','/v1/namespaces/{namespaceName}/configmaps/{configMapName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb46e27-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 퍼시스턴트 볼륨 생성','사용자 포탈 - 퍼시스턴트 볼륨 생성','/v1/persistentvolumes','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','volume','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb49f4c-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 네임스페이스 생성','사용자 포탈 - 네임스페이스 생성','/v1/namespaces','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb4d146-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 스테이트풀셋 생성','사용자 포탈 - 스테이트풀셋 생성','/v1/namespaces/{namespaceName}/statefulsets','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb50292-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 서비스 생성','사용자 포탈 - 서비스 생성','/v1/namespaces/{namespaceName}/services','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','network','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb53524-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 시크릿 생성','사용자 포탈 - 시크릿 생성','/v1/namespaces/{namespaceName}/secrets','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb56d5f-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 리소스쿼터 생성','사용자 포탈 - 리소스쿼터 생성','/v1/namespaces/{namespaceName}/resourcequotas','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','management','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb59f1c-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 레플리카셋 생성','사용자 포탈 - 레플리카셋 생성','/v1/namespaces/{namespaceName}/replicasets','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb5d01a-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 파드 생성','사용자 포탈 - 파드 생성','/v1/namespaces/{namespaceName}/pods','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb5fd9d-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 퍼시스턴트 볼륨 클레임 생성','사용자 포탈 - 퍼시스턴트 볼륨 클레임 생성','/v1/namespaces/{namespaceName}/persistentvolumeclaims','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','volume','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb62f14-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 네트워크 폴리시 생성','사용자 포탈 - 네트워크 폴리시 생성','/v1/namespaces/{namespaceName}/networkpolicies','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','network','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb65c9c-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 작업 생성','사용자 포탈 - 작업 생성','/v1/namespaces/{namespaceName}/jobs','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb692ae-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 인그레스 생성','사용자 포탈 - 인그레스 생성','/v1/namespaces/{namespaceName}/ingresses','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','network','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb6c5f5-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 오토스케일러 생성','사용자 포탈 - 오토스케일러 생성','/v1/namespaces/{namespaceName}/horizontalpodautoscalers','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb6f9bc-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 디플로이먼트 생성','사용자 포탈 - 디플로이먼트 생성','/v1/namespaces/{namespaceName}/deployments','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb72d8f-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 데몬셋 생성','사용자 포탈 - 데몬셋 생성','/v1/namespaces/{namespaceName}/daemonsets','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb75ee0-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - Cron 작업 생성','사용자 포탈 - Cron 작업 생성','/v1/namespaces/{namespaceName}/cronjobs','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb78e17-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 컨피그맵 생성','사용자 포탈 - 컨피그맵 생성','/v1/namespaces/{namespaceName}/configmaps','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb809ef-6065-11ef-9a30-f2cdef6842ce','관리자 포탈 - 네임스페이스 하위 자원 존재 유무','관리자 포탈 - 네임스페이스 하위 자원 존재 유무','/v1/k8s/namespaces/{namespaceName}/resources','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','namespace','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb869d1-6065-11ef-9a30-f2cdef6842ce','관리자 포탈 - 네임스페이스 하위 자원 존재 유무','관리자 포탈 - 네임스페이스 하위 자원 존재 유무','/v1/k8s/namespaces/{namespaceName}/resourcecheck','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','namespace','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('5bb95e39-6065-11ef-9a30-f2cdef6842ce','네임스페이스 대시보드 상태현황','네임스페이스 대시보드 상태현황','/v1/k8s/monitoring/namespace-dashboard/{namespaceName}/status-overview','345ae518-f857-11ed-921d-aa1950d374e1','Viola','monitoring','namespace-dashboard','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb9b493-6065-11ef-9a30-f2cdef6842ce','네임스페이스 대시보드 자원개요','네임스페이스 대시보드 자원개요','/v1/k8s/monitoring/namespace-dashboard/{namespaceName}/resource-overview','345ae518-f857-11ed-921d-aa1950d374e1','Viola','monitoring','namespace-dashboard','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bb9e55a-6065-11ef-9a30-f2cdef6842ce','네임스페이스 대시보드 파드별 현황','네임스페이스 대시보드 파드별 현황','/v1/k8s/monitoring/namespace-dashboard/{namespaceName}/pod-status-overview','345ae518-f857-11ed-921d-aa1950d374e1','Viola','monitoring','namespace-dashboard','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('5bba1d12-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 퍼시스턴트 볼륨 수정','사용자 포탈 - 퍼시스턴트 볼륨 수정','/v1/persistentvolumes/{persistentVolumeName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','volume','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bba57d0-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 퍼시스턴트 볼륨 삭제','사용자 포탈 - 퍼시스턴트 볼륨 삭제','/v1/persistentvolumes/{persistentVolumeName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','volume','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bba8bde-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 네임스페이스 수정','사용자 포탈 - 네임스페이스 수정','/v1/namespaces/{namespaceName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbabf3c-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 네임스페이스 삭제','사용자 포탈 - 네임스페이스 삭제','/v1/namespaces/{namespaceName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbaef35-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 스테이트풀셋 수정','사용자 포탈 - 스테이트풀셋 수정','/v1/namespaces/{namespaceName}/statefulsets/{statefulsetName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbb234d-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 스테이트풀셋 삭제','사용자 포탈 - 스테이트풀셋 삭제','/v1/namespaces/{namespaceName}/statefulsets/{statefulsetName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbb571b-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 서비스 수정','사용자 포탈 - 서비스 수정','/v1/namespaces/{namespaceName}/services/{serviceName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','network','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbb88a4-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 서비스 삭제','사용자 포탈 - 서비스 삭제','/v1/namespaces/{namespaceName}/services/{serviceName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','network','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbbb7b8-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 시크릿 수정','사용자 포탈 - 시크릿 수정','/v1/namespaces/{namespaceName}/secrets/{secretName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbbe9d2-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 시크릿 삭제','사용자 포탈 - 시크릿 삭제','/v1/namespaces/{namespaceName}/secrets/{secretName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbc1acf-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 리소스쿼터 수정','사용자 포탈 - 리소스쿼터 수정','/v1/namespaces/{namespaceName}/resourcequotas/{resourceQuotaName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','management','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbc4c12-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 리소스쿼터 삭제','사용자 포탈 - 리소스쿼터 삭제','/v1/namespaces/{namespaceName}/resourcequotas/{resourceQuotaName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','management','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbc7f6c-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 레플리카셋 수정','사용자 포탈 - 레플리카셋 수정','/v1/namespaces/{namespaceName}/replicasets/{replicasetName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbcb319-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 레플리카셋 삭제','사용자 포탈 - 레플리카셋 삭제','/v1/namespaces/{namespaceName}/replicasets/{replicasetName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbce6cf-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 파드 수정','사용자 포탈 - 파드 수정','/v1/namespaces/{namespaceName}/pods/{podName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbd1a9d-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 파드 삭제','사용자 포탈 - 파드 삭제','/v1/namespaces/{namespaceName}/pods/{podName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbd4a61-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 퍼시스턴트 볼륨 클레임 수정','사용자 포탈 - 퍼시스턴트 볼륨 클레임 수정','/v1/namespaces/{namespaceName}/persistentvolumeclaims/{persistentvolumeclaimName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','volume','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('5bbd7988-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 퍼시스턴트 볼륨 클레임 삭제','사용자 포탈 - 퍼시스턴트 볼륨 클레임 삭제','/v1/namespaces/{namespaceName}/persistentvolumeclaims/{persistentvolumeclaimName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','volume','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbda742-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 네트워크 폴리시 수정','사용자 포탈 - 네트워크 폴리시 수정','/v1/namespaces/{namespaceName}/networkpolicies/{networkPolicyName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','network','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbdd4d1-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 네트워크 폴리시 삭제','사용자 포탈 - 네트워크 폴리시 삭제','/v1/namespaces/{namespaceName}/networkpolicies/{networkPolicyName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','network','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbe0298-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 작업 수정','사용자 포탈 - 작업 수정','/v1/namespaces/{namespaceName}/jobs/{jobName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbe3520-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 작업 삭제','사용자 포탈 - 작업 삭제','/v1/namespaces/{namespaceName}/jobs/{jobName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbe66b7-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 인그레스 수정','사용자 포탈 - 인그레스 수정','/v1/namespaces/{namespaceName}/ingresses/{ingressName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','network','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbe96f4-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 인그레스 삭제','사용자 포탈 - 인그레스 삭제','/v1/namespaces/{namespaceName}/ingresses/{ingressName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','network','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbec607-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 오토스케일러 수정','사용자 포탈 - 오토스케일러 수정','/v1/namespaces/{namespaceName}/horizontalpodautoscalers/{horizontalPodAutoScalerName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbef6ef-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 오토스케일러 삭제','사용자 포탈 - 오토스케일러 삭제','/v1/namespaces/{namespaceName}/horizontalpodautoscalers/{horizontalPodAutoScalerName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbf2782-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 디플로이먼트 수정','사용자 포탈 - 디플로이먼트 수정','/v1/namespaces/{namespaceName}/deployments/{deploymentName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbf5943-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 디플로이먼트 삭제','사용자 포탈 - 디플로이먼트 삭제','/v1/namespaces/{namespaceName}/deployments/{deploymentName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbf87f5-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 데몬셋 수정','사용자 포탈 - 데몬셋 수정','/v1/namespaces/{namespaceName}/daemonsets/{daemonsetName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbfb877-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 데몬셋 삭제','사용자 포탈 - 데몬셋 삭제','/v1/namespaces/{namespaceName}/daemonsets/{daemonsetName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bbfe970-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - Cron 작업 수정','사용자 포탈 - Cron 작업 수정','/v1/namespaces/{namespaceName}/cronjobs/{cronJobName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bc01683-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - Cron 작업 삭제','사용자 포탈 - Cron 작업 삭제','/v1/namespaces/{namespaceName}/cronjobs/{cronJobName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bc04557-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 컨피그맵 수정','사용자 포탈 - 컨피그맵 수정','/v1/namespaces/{namespaceName}/configmaps/{configMapName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bc071dc-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 컨피그맵 삭제','사용자 포탈 - 컨피그맵 삭제','/v1/namespaces/{namespaceName}/configmaps/{configMapName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bc0a1f2-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 퍼시스턴트 볼륨 생성','사용자 포탈 - 퍼시스턴트 볼륨 생성','/v1/persistentvolumes','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','volume','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bc0d145-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 네임스페이스 생성','사용자 포탈 - 네임스페이스 생성','/v1/namespaces','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bc105a2-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 스테이트풀셋 생성','사용자 포탈 - 스테이트풀셋 생성','/v1/namespaces/{namespaceName}/statefulsets','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('5bc13ac8-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 서비스 생성','사용자 포탈 - 서비스 생성','/v1/namespaces/{namespaceName}/services','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','network','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bc16d4e-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 시크릿 생성','사용자 포탈 - 시크릿 생성','/v1/namespaces/{namespaceName}/secrets','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bc19e03-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 리소스쿼터 생성','사용자 포탈 - 리소스쿼터 생성','/v1/namespaces/{namespaceName}/resourcequotas','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','management','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bc1de9d-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 레플리카셋 생성','사용자 포탈 - 레플리카셋 생성','/v1/namespaces/{namespaceName}/replicasets','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bc216eb-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 파드 생성','사용자 포탈 - 파드 생성','/v1/namespaces/{namespaceName}/pods','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bc257fe-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 퍼시스턴트 볼륨 클레임 생성','사용자 포탈 - 퍼시스턴트 볼륨 클레임 생성','/v1/namespaces/{namespaceName}/persistentvolumeclaims','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','volume','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bc2956f-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 네트워크 폴리시 생성','사용자 포탈 - 네트워크 폴리시 생성','/v1/namespaces/{namespaceName}/networkpolicies','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','network','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bc2d2f1-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 작업 생성','사용자 포탈 - 작업 생성','/v1/namespaces/{namespaceName}/jobs','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bc31439-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 인그레스 생성','사용자 포탈 - 인그레스 생성','/v1/namespaces/{namespaceName}/ingresses','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','network','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bc354ec-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 오토스케일러 생성','사용자 포탈 - 오토스케일러 생성','/v1/namespaces/{namespaceName}/horizontalpodautoscalers','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bc38d61-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 디플로이먼트 생성','사용자 포탈 - 디플로이먼트 생성','/v1/namespaces/{namespaceName}/deployments','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bc3c4a9-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 데몬셋 생성','사용자 포탈 - 데몬셋 생성','/v1/namespaces/{namespaceName}/daemonsets','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bc3fbc9-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - Cron 작업 생성','사용자 포탈 - Cron 작업 생성','/v1/namespaces/{namespaceName}/cronjobs','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bc43828-6065-11ef-9a30-f2cdef6842ce','사용자 포탈 - 컨피그맵 생성','사용자 포탈 - 컨피그맵 생성','/v1/namespaces/{namespaceName}/configmaps','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bc4b750-6065-11ef-9a30-f2cdef6842ce','관리자 포탈 - 네임스페이스 하위 자원 존재 유무','관리자 포탈 - 네임스페이스 하위 자원 존재 유무','/v1/k8s/namespaces/{namespaceName}/resources','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','namespace','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bc4f2ad-6065-11ef-9a30-f2cdef6842ce','관리자 포탈 - 네임스페이스 하위 자원 존재 유무','관리자 포탈 - 네임스페이스 하위 자원 존재 유무','/v1/k8s/namespaces/{namespaceName}/resourcecheck','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','namespace','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bc52af2-6065-11ef-9a30-f2cdef6842ce','네임스페이스 대시보드 상태현황','네임스페이스 대시보드 상태현황','/v1/k8s/monitoring/namespace-dashboard/{namespaceName}/status-overview','345ae518-f857-11ed-921d-aa1950d374e1','Viola','monitoring','namespace-dashboard','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bc56553-6065-11ef-9a30-f2cdef6842ce','네임스페이스 대시보드 자원개요','네임스페이스 대시보드 자원개요','/v1/k8s/monitoring/namespace-dashboard/{namespaceName}/resource-overview','345ae518-f857-11ed-921d-aa1950d374e1','Viola','monitoring','namespace-dashboard','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5bc599e4-6065-11ef-9a30-f2cdef6842ce','네임스페이스 대시보드 파드별 현황','네임스페이스 대시보드 파드별 현황','/v1/k8s/monitoring/namespace-dashboard/{namespaceName}/pod-status-overview','345ae518-f857-11ed-921d-aa1950d374e1','Viola','monitoring','namespace-dashboard','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('5be5eab9-4b16-11ef-a4c4-96fd9ef2bacb','인스턴스 별 인스턴스 타입 자원 포함 목록','인스턴스 별 인스턴스 타입 자원 포함 목록','/dashboard/servers','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','dashboard','dashboard','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('5be66c0e-4b16-11ef-a4c4-96fd9ef2bacb','인스턴스 별 인스턴스 타입 자원 포함 목록','인스턴스 별 인스턴스 타입 자원 포함 목록','/dashboard/servers','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','dashboard','dashboard','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('5cb7e254-5dfb-11ef-b739-0ebddd68c8c8','기타 과금 정책 폴더별 조회','기타 과금 정책 폴더별 조회','/data/other/finops/info/folder','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','other','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('5cc3ad29-5dfb-11ef-b739-0ebddd68c8c8','Custom SSE 메시지 전송','Custom SSE 메시지 전송','/sse/send','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','notification','POST',1,'dc347010-c3f4-11ee-8281-7e177595258d',0)
    ,   ('5ccd99a7-5dfb-11ef-b739-0ebddd68c8c8','Custom Email 전송','Custom Email 전송','/message-channel/mail/send','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','notification','POST',1,'dc347010-c3f4-11ee-8281-7e177595258d',0)
    ,   ('5cfceac5-2eef-11f0-92ed-2e5d1099d8b8','저장된 리포트 이미지 조회(test)','저장된 리포트 이미지 조회(test)','/v2/reports/test/img','910fa43a-7797-11ee-b465-565158862942','Vista','observability','report','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('5d1ec2e9-3e87-11ef-9f42-5e230e3817dd','admin : GET/transit-gateway','admin : GET/transit-gateway','/transit-gateway','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','transitgateway','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('5d1f4441-3e87-11ef-9f42-5e230e3817dd','admin : GET/transit-gateway/{transitGatewayId}','admin : GET/transit-gateway/{transitGatewayId}','/transit-gateway/{transitGatewayId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','transitgateway','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('5d1f8cd7-3e87-11ef-9f42-5e230e3817dd','admin : GET/transit-gateway/filter','admin : GET/transit-gateway/filter','/transit-gateway/filter','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','transitgateway','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('5d1fcd00-3e87-11ef-9f42-5e230e3817dd','버킷 목록 조회','버킷 목록 조회','/storages/objects','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('5d200e0a-3e87-11ef-9f42-5e230e3817dd','user : GET/transit-gateway','user : GET/transit-gateway','/transit-gateway','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','transitgateway','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('5d204f07-3e87-11ef-9f42-5e230e3817dd','user : GET/transit-gateway/{transitGatewayId}','user : GET/transit-gateway/{transitGatewayId}','/transit-gateway/{transitGatewayId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','transitgateway','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('5d20874c-3e87-11ef-9f42-5e230e3817dd','user : GET/transit-gateway/filter','user : GET/transit-gateway/filter','/transit-gateway/filter','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','transitgateway','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('5d20bae2-3e87-11ef-9f42-5e230e3817dd','버킷 목록 조회','버킷 목록 조회','/storages/objects','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','storages','storages','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('5e31cb77-5494-11ef-97d4-9676f6708993','기본 배포 여부 지정','기본 배포 여부 지정','/roles/deploy/{deployId}/default-option','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','role-deploy','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('5e72f43a-7963-11ef-a354-4690f64a169c','자원 최적화 - 인스턴스 라이브 마이그레이션 API','자원 최적화 - 인스턴스 라이브 마이그레이션 API','/optimize/{consolidationNumber}/{providerId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','drs','resource','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('5e78adc7-7963-11ef-a354-4690f64a169c','최적화 배치 상태 조회 API','최적화 배치 상태 조회 API','/resource/status/{providerId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','drs','resource','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('5e79270a-7963-11ef-a354-4690f64a169c','자원 최적화 - 인스턴스 라이브 마이그레이션 API','자원 최적화 - 인스턴스 라이브 마이그레이션 API','/optimize/{consolidationNumber}/{providerId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','drs','resource','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('5e79902e-7963-11ef-a354-4690f64a169c','최적화 배치 상태 조회 API','최적화 배치 상태 조회 API','/resource/status/{providerId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','drs','resource','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('60ebe505-287a-11ef-9f42-5e230e3817dd','볼륨 수정','볼륨 수정','/volumes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volume','ebs','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('60ec7ca6-287a-11ef-9f42-5e230e3817dd','볼륨 생성','볼륨 생성','/volumes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volume','ebs','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('60eccc5c-287a-11ef-9f42-5e230e3817dd','볼륨 속성 수정','볼륨 속성 수정','/volumes/attribute','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volume','ebs','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('60ed126b-287a-11ef-9f42-5e230e3817dd','볼륨 분리','볼륨 분리','/volumes/detach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volume','ebs','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('60ed586e-287a-11ef-9f42-5e230e3817dd','볼륨 연결','볼륨 연결','/volumes/attach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volume','ebs','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('60ed9f5d-287a-11ef-9f42-5e230e3817dd','볼륨 삭제','볼륨 삭제','/volumes/{volumeId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volume','ebs','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('60eddeb8-287a-11ef-9f42-5e230e3817dd','볼륨 수정','볼륨 수정','/volumes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volume','ebs','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('60ee1d7d-287a-11ef-9f42-5e230e3817dd','볼륨 생성','볼륨 생성','/volumes','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volume','ebs','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('60ee5b56-287a-11ef-9f42-5e230e3817dd','볼륨 속성 수정','볼륨 속성 수정','/volumes/attribute','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volume','ebs','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('60ee9d84-287a-11ef-9f42-5e230e3817dd','볼륨 분리','볼륨 분리','/volumes/detach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volume','ebs','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('60eed1f7-287a-11ef-9f42-5e230e3817dd','볼륨 연결','볼륨 연결','/volumes/attach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volume','ebs','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('60ef03ff-287a-11ef-9f42-5e230e3817dd','볼륨 삭제','볼륨 삭제','/volumes/{volumeId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volume','ebs','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('61348be8-0e09-11f0-8e4c-52e9553a2057','공급자 선택 정보 저장','공급자 선택 정보 저장','/v2/provider-navigator/{providerId}/selection','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('61350f8d-0e09-11f0-8e4c-52e9553a2057','공급자 북마크 저장','공급자 북마크 저장','/v2/provider-navigator/{providerId}/bookmark','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('613537d1-0e09-11f0-8e4c-52e9553a2057','공급자 북마크 삭제','공급자 북마크 삭제','/v2/provider-navigator/{providerId}/bookmark','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('61355990-0e09-11f0-8e4c-52e9553a2057','콘트라베이스 공급자 리스트 조회','콘트라베이스 공급자 리스트 조회','/v2/providers/contrabass','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','provider','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('61357325-0e09-11f0-8e4c-52e9553a2057','공급자 리스트 조회','공급자 리스트 조회','/v2/provider-navigator','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('6135da66-0e09-11f0-8e4c-52e9553a2057','공급자 선택 정보 저장','공급자 선택 정보 저장','/v2/provider-navigator/{providerId}/selection','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('6135f519-0e09-11f0-8e4c-52e9553a2057','공급자 북마크 저장','공급자 북마크 저장','/v2/provider-navigator/{providerId}/bookmark','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('61361099-0e09-11f0-8e4c-52e9553a2057','공급자 북마크 삭제','공급자 북마크 삭제','/v2/provider-navigator/{providerId}/bookmark','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('61362a3e-0e09-11f0-8e4c-52e9553a2057','콘트라베이스 공급자 리스트 조회','콘트라베이스 공급자 리스트 조회','/v2/providers/contrabass','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','provider','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('61364e43-0e09-11f0-8e4c-52e9553a2057','공급자 리스트 조회','공급자 리스트 조회','/v2/provider-navigator','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('61af6312-9d6d-11ef-8cfe-22e1909bc60f','볼륨 IO 활성화','볼륨 IO 활성화','/volumes/enable/io/{volumeId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volume','ebs','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('61b2854d-9d6d-11ef-8cfe-22e1909bc60f','user : GET/autoscaling/groups/{groupname}','user : GET/autoscaling/groups/{groupname}','/autoscaling/groups/{groupname}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('61b2bbd5-9d6d-11ef-8cfe-22e1909bc60f','볼륨 IO 활성화','볼륨 IO 활성화','/volumes/enable/io/{volumeId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','volume','ebs','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('61b40c75-9d6d-11ef-8cfe-22e1909bc60f','admin : GET/autoscaling/groups/{groupname}','admin : GET/autoscaling/groups/{groupname}','/autoscaling/groups/{groupname}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('61e9e4c0-8370-11ee-a4fd-dadafdb14cb0','모든 조직 조회 API','모든 조직 조회 API','/org','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('61eb8dfd-8370-11ee-a4fd-dadafdb14cb0','조직 조회 API','조직 조회 API','/org/{orgId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('61ecce28-8370-11ee-a4fd-dadafdb14cb0','조직 검색 API','조직 검색 API','/org/find','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('61edcbb3-d05d-11ee-8e11-0af68e3c6ac5','워크스페이스 가상머신 일시 정지','워크스페이스의 가상머신을 일시 정지한다.','/workspaces/servers/tenants/{tenantId}/instances/{instanceId}/suspend','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('61edd297-8370-11ee-a4fd-dadafdb14cb0','카테고리 조회','카테고리 조회','/categories','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('61ee3c39-d05d-11ee-8e11-0af68e3c6ac5','워크스페이스 가상머신 정지','워크스페이스의 가상머신을 정지한다.','/workspaces/servers/tenants/{tenantId}/instances/{instanceId}/stop','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('61ee780f-8370-11ee-a4fd-dadafdb14cb0','카테고리 조회','카테고리 조회','/categories/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('61ef2fdf-d05d-11ee-8e11-0af68e3c6ac5','워크스페이스 가상머신 시작','워크스페이스의 가상머신을 시작한다.','/workspaces/servers/tenants/{tenantId}/instances/{instanceId}/start','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('61efa607-d05d-11ee-8e11-0af68e3c6ac5','워크스페이스 가상머신 소프트 리부트','워크스페이스의 가상머신을 소프트 리부트한다.','/workspaces/servers/tenants/{tenantId}/instances/{instanceId}/soft','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('61f07600-d05d-11ee-8e11-0af68e3c6ac5','워크스페이스 가상머신 재기동','워크스페이스의 가상머신을 재기동한다.','/workspaces/servers/tenants/{tenantId}/instances/{instanceId}/reset','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('61f153b8-d05d-11ee-8e11-0af68e3c6ac5','워크스페이스 가상머신 재시작','워크스페이스의 가상머신을 재시작한다.','/workspaces/servers/tenants/{tenantId}/instances/{instanceId}/reboot','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('61f1b36e-d05d-11ee-8e11-0af68e3c6ac5','워크스페이스 가상머신 기동','워크스페이스의 가상머신을 기동한다.','/workspaces/servers/tenants/{tenantId}/instances/{instanceId}/on','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('61f1f6ac-d05d-11ee-8e11-0af68e3c6ac5','워크스페이스 가상머신 종료','워크스페이스의 가상머신을 종료한다.','/workspaces/servers/tenants/{tenantId}/instances/{instanceId}/off','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('61f22cb6-d05d-11ee-8e11-0af68e3c6ac5','워크스페이스 가상머신 하드 리부트','워크스페이스의 가상머신을 하드 리부트한다.','/workspaces/servers/tenants/{tenantId}/instances/{instanceId}/hard','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('61f38c84-d05d-11ee-8e11-0af68e3c6ac5','워크스페이스 가상머신 강제 종료','워크스페이스의 가상머신을 강제 종료한다.','/workspaces/servers/tenants/{tenantId}/instances/{instanceId}/hard_stop','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('61f43737-d05d-11ee-8e11-0af68e3c6ac5','워크스페이스 가상머신 삭제','워크스페이스의 가상머신을 삭제한다.','/workspaces/servers/tenants/{tenantId}/instances/{instanceId}/delete','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','vm','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('61f5910f-d05d-11ee-8e11-0af68e3c6ac5','워크스페이스의 network 정보 조회','워크스페이스의 network 정보 조회','/workspace/{workspaceId}/dashboard/resources/network','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','workspace','dashboard','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('61f5f933-d05d-11ee-8e11-0af68e3c6ac5','폴더 리소스 조회 API','폴더 리소스 조회 API','/baton/resources/all','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','baton','resource','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('621479b3-c0c5-11ee-8281-7e177595258d','하이퍼 바이저 컴퓨트 호스트 조회 API','하이퍼 바이저 컴퓨트 호스트 조회 API','/compute/hypervisors/compute-hosts/segment','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','hypervisor','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('62200c44-5ed4-11ef-b0b3-f2cdef6842ce','기타 과금 정책 폴더별 상세조회','기타 과금 정책 폴더별 상세조회','/data/other/finops/folder/policy','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','other','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('62207a65-5ed4-11ef-b0b3-f2cdef6842ce','mfa 사용 여부 조회','mfa 사용 여부 조회','/option/mfa/enable','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','option','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('6220ca72-e14b-11ee-84a7-5e1f35257281','서비스 신청 카테고리 수정 API','서비스 신청 카테고리 수정 API','/service-objects/requests/type/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('62210541-e14b-11ee-84a7-5e1f35257281','서비스 신청 카테고리 조직 연결 API','서비스 신청 카테고리 조직 연결 API','/service-objects/requests/type/{typeId}/folder/{folderId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('622108bc-5ed4-11ef-b0b3-f2cdef6842ce','mfa 사용 여부 수정','mfa 사용 여부 수정','/option/mfa/enable','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','option','PATCH',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('6221335c-e14b-11ee-84a7-5e1f35257281','서비스-카탈로그 카테고리 복제 API','서비스 요청 타입 복제','/service-objects/requests/type/copy/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('62216e22-e14b-11ee-84a7-5e1f35257281','서비스-카탈로그 카테고리 목록 조회 API','서비스-카탈로그 카테고리 목록 조회 API','/service-objects/requests/types','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('622532fc-93f3-11ee-971f-72441c073636','Pool Modify','Pool Modify','/load-balancer/pools/{poolId}/members','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('62260ba3-93f3-11ee-971f-72441c073636','인스턴스 크기 조정 API','대상 인스턴스의 크기를 조정 한다.','/compute/servers/{serverId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('6228811d-93f3-11ee-971f-72441c073636','스택 상세 템플릿을 조회 API','스택 상세 템플릿을 조회 API','/heat/stacks/{stackName}/{stackId}/template','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','heat','stack','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('6228e343-93f3-11ee-971f-72441c073636','스택 상세 리소스 조회 API','스택 상세 리소스 조회 API','/heat/stacks/{stackName}/{stackId}/resources','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','heat','stack','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('62292881-93f3-11ee-971f-72441c073636','스택 상세 이벤트 조회 API','스택 상세 이벤트 조회 API','/heat/stacks/{stackName}/{stackId}/events','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','heat','stack','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('62a85dd4-4318-11ef-9f42-5e230e3817dd','클러스터 상세 조회','클러스터 상세 조회','/v1/k8s/management/clusters/{clusterId}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('62a8c8ce-4318-11ef-9f42-5e230e3817dd','클러스터 삭제','클러스터 삭제','/v1/k8s/management/clusters/{clusterId}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('62a91262-4318-11ef-9f42-5e230e3817dd','클러스터 노드 스케일링','클러스터 노드 스케일링','/v1/k8s/management/clusters/{clusterId}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','PATCH',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('62a94ea9-4318-11ef-9f42-5e230e3817dd','사용자 포탈 - 시크릿 리스트','사용자 포탈 - 시크릿 리스트','/v1/secrets','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('62a98839-4318-11ef-9f42-5e230e3817dd','사용자 포탈 - 파드 리스트','사용자 포탈 - 파드 리스트','/v1/pods','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('62a9c9be-4318-11ef-9f42-5e230e3817dd','사용자 포탈 - 디플로이먼트 리스트','사용자 포탈 - 디플로이먼트 리스트','/v1/deployments','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('62aa061d-4318-11ef-9f42-5e230e3817dd','클러스터 상세 조회','클러스터 상세 조회','/v1/k8s/management/clusters/{clusterId}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('62aa3ab5-4318-11ef-9f42-5e230e3817dd','클러스터 삭제','클러스터 삭제','/v1/k8s/management/clusters/{clusterId}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('62aa69ba-4318-11ef-9f42-5e230e3817dd','클러스터 노드 스케일링','클러스터 노드 스케일링','/v1/k8s/management/clusters/{clusterId}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','PATCH',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('62aa9ccb-4318-11ef-9f42-5e230e3817dd','사용자 포탈 - 시크릿 리스트','사용자 포탈 - 시크릿 리스트','/v1/secrets','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('62aad481-4318-11ef-9f42-5e230e3817dd','사용자 포탈 - 파드 리스트','사용자 포탈 - 파드 리스트','/v1/pods','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('62ab071d-4318-11ef-9f42-5e230e3817dd','사용자 포탈 - 디플로이먼트 리스트','사용자 포탈 - 디플로이먼트 리스트','/v1/deployments','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('631614ad-d53a-11ee-bd1a-bed5f84892d5','storage 전체 조회','storage 전체 조회','/compute/storages','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server storage','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('6316d64b-d53a-11ee-bd1a-bed5f84892d5','',NULL,'/compute/server/server/instance-types/test','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',1)
    ,   ('63347e76-113a-11f0-8e4c-52e9553a2057','플랫폼 과금 인스턴스 정책 상세조회','플랫폼 과금 인스턴스 정책 상세조회','/data/finops/instancePolicy/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','billing','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('63360883-113a-11f0-8e4c-52e9553a2057','플랫폼 과금 기본 정책 상세조회','플랫폼 과금 기본 정책 상세조회','/data/finops/basePolicy/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','billing','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('63a42f61-cbfe-11ef-9c74-0a11b82fa8dd','파드 리소스 상태 조회','파드 리소스 상태 조회','/v1/k8s/resource/pods','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','pod','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('63a501f0-cbfe-11ef-9c74-0a11b82fa8dd','GPU 할당 가능한 노드 리스트 조회','GPU 할당 가능한 노드 리스트 조회','/v1/k8s/gpu/nodes','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','node','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('63a8c9ad-cbfe-11ef-9c74-0a11b82fa8dd','파드 리소스 상태 조회','파드 리소스 상태 조회','/v1/k8s/resource/pods','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','pod','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('63a90b6d-cbfe-11ef-9c74-0a11b82fa8dd','GPU 할당 가능한 노드 리스트 조회','GPU 할당 가능한 노드 리스트 조회','/v1/k8s/gpu/nodes','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','node','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('64a3210b-230b-11ef-922c-16fe18334070','라우팅 테이블 수정','라우팅 테이블 수정','/network/route-tables/replace','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('64a36b60-230b-11ef-922c-16fe18334070','라우팅 테이블 연결 해제','라우팅 테이블 연결 해제','/network/route-tables/disassociate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('64a3b260-230b-11ef-922c-16fe18334070','라우팅 테이블 연결','라우팅 테이블 연결','/network/route-tables/associate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('64a3e458-230b-11ef-922c-16fe18334070','라우팅 테이블 조회','라우팅 테이블 조회','/network/route-tables','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('64a41c99-230b-11ef-922c-16fe18334070','라우팅 테이블 생성','라우팅 테이블 생성','/network/route-tables','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('64a45a29-230b-11ef-922c-16fe18334070','라우팅 테이블 라우트 추가','라우팅 테이블 라우트 추가','/network/route-tables/route','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('64a49ede-230b-11ef-922c-16fe18334070','라우팅 테이블 라우트 제거','라우팅 테이블 라우트 제거','/network/route-tables/route','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('64a4d3e8-230b-11ef-922c-16fe18334070','라우팅 테이블 상세조회','라우팅 테이블 상세조회','/network/route-tables/{routeTableId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('64a50131-230b-11ef-922c-16fe18334070','라우팅 테이블 삭제','라우팅 테이블 삭제','/network/route-tables/{routeTableId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('64a52b68-230b-11ef-922c-16fe18334070','라우팅 테이블 필터하여 조회','라우팅 테이블 필터하여 조회','/network/route-tables/filters','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('64a55fb3-230b-11ef-922c-16fe18334070','라우팅 테이블 중복 확인','라우팅 테이블 중복 확인','/network/route-tables/duplicate-checker','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('64a58bf3-230b-11ef-922c-16fe18334070','추가된부분','추가된부분','/compute/servers/instance-types/amis','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',1)
    ,   ('64a5b5eb-230b-11ef-922c-16fe18334070','라우팅 테이블 수정','라우팅 테이블 수정','/network/route-tables/replace','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('64a5e327-230b-11ef-922c-16fe18334070','라우팅 테이블 연결 해제','라우팅 테이블 연결 해제','/network/route-tables/disassociate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('64a60e9a-230b-11ef-922c-16fe18334070','라우팅 테이블 연결','라우팅 테이블 연결','/network/route-tables/associate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('64a6377a-230b-11ef-922c-16fe18334070','라우팅 테이블 조회','라우팅 테이블 조회','/network/route-tables','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('64a65fd6-230b-11ef-922c-16fe18334070','라우팅 테이블 생성','라우팅 테이블 생성','/network/route-tables','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('64a697ba-230b-11ef-922c-16fe18334070','라우팅 테이블 라우트 추가','라우팅 테이블 라우트 추가','/network/route-tables/route','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('64a6cf13-230b-11ef-922c-16fe18334070','라우팅 테이블 라우트 제거','라우팅 테이블 라우트 제거','/network/route-tables/route','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('64a6fd49-230b-11ef-922c-16fe18334070','라우팅 테이블 상세조회','라우팅 테이블 상세조회','/network/route-tables/{routeTableId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('64a72b9f-230b-11ef-922c-16fe18334070','라우팅 테이블 삭제','라우팅 테이블 삭제','/network/route-tables/{routeTableId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('64a756fe-230b-11ef-922c-16fe18334070','라우팅 테이블 필터하여 조회','라우팅 테이블 필터하여 조회','/network/route-tables/filters','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('64a78918-230b-11ef-922c-16fe18334070','라우팅 테이블 중복 확인','라우팅 테이블 중복 확인','/network/route-tables/duplicate-checker','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route table','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('64a7b88b-230b-11ef-922c-16fe18334070','추가된부분','추가된부분','/compute/servers/instance-types/amis','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',1)
    ,   ('65760618-4b16-11ef-a4c4-96fd9ef2bacb','특정 계정 감사 로그 조회(관리자용)','특정 계정 감사 로그 조회(관리자용)','/log/work/{userId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','dashboard','GET',1,'bb6fa9a6-8443-11ee-a4fd-dadafdb14cb0',1)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('65766af6-4b16-11ef-a4c4-96fd9ef2bacb','특정 계정 접속 로그 조회','특정 계정 접속 로그 조회','/log/access/{accountType}/{accountId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','dashboard','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('65abf6ad-b83c-11ef-9c74-0a11b82fa8dd','인스턴스 유형 상세에서 접근 권한을 가진 프로젝트 리스트 조회 API','인스턴스 유형 상세에서 접근 권한을 가진 프로젝트 리스트 조회 API','/compute/flavors/{flavorId}/access','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','flavor','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('65ad30ef-b83c-11ef-9c74-0a11b82fa8dd','mole-ceph-df','mole-ceph-df','/mole/ceph-df','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','vip','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('65ae0f5c-b83c-11ef-9c74-0a11b82fa8dd','인스턴스 유형 상세에서 접근 권한을 가진 프로젝트 리스트 조회 API','인스턴스 유형 상세에서 접근 권한을 가진 프로젝트 리스트 조회 API','/compute/flavors/{flavorId}/access','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','flavor','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('65ae41c8-b83c-11ef-9c74-0a11b82fa8dd','mole-ceph-df','mole-ceph-df','/mole/ceph-df','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','vip','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('66403bd8-427b-11ef-9f42-5e230e3817dd','Top5 리소스 시계열 데이터 조회','Top5 리소스 시계열 데이터 조회','/dashboard/top5/graph','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','dashboard','dashboard','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('664080dc-427b-11ef-9f42-5e230e3817dd','Top5 리소스 시계열 데이터 조회','Top5 리소스 시계열 데이터 조회','/dashboard/top5/graph','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','dashboard','dashboard','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('66d18caa-a3c8-11ee-a438-3e72d96d3fbc','공유 파일 시스템 서비스 정보 조회','공유 파일 시스템 서비스 정보 조회','/manila/shares/services','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('66d24fb1-a3c8-11ee-a438-3e72d96d3fbc','공유 파일 시스템 host 정보 조회','공유 파일 시스템 host 정보 조회','/manila/shares/distinct-hosts','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('672fd436-b5dd-11ee-afaf-76fb71c4f9db','admin : GET/price/test','admin : GET/price/test','/price/test','4ff522aa-39ab-11ee-91df-4201ac100118','NCP','billing','month','GET',1,'5620f375-8783-11ee-a4fd-dadafdb14cb0',0)
    ,   ('688beb42-27e5-11ef-9f42-5e230e3817dd','관리자가 가진 역할 목록 조회','관리자가 가진 역할 목록 조회','/admin/access-control/{adminId}/roles','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','admin','access-control','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('6af1cc3a-70e1-11ef-a7e3-025bd9f6f87b','사용자 상태변경','사용자 상태변경','/user/{userId}/status','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('6af289de-70e1-11ef-a7e3-025bd9f6f87b','반려 처리','반려 처리','/approvals/{approvalId}/reject','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('6af2e98f-70e1-11ef-a7e3-025bd9f6f87b','승인 처리','승인 처리','/approvals/{approvalId}/approve','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('6af32013-70e1-11ef-a7e3-025bd9f6f87b','서비스 신청 생성','서비스 신청 생성','/services/request','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('6af35466-70e1-11ef-a7e3-025bd9f6f87b','서비스 신청을 위해 저장한 API 조회','서비스 신청을 위해 저장한 API 조회','/service-objects/requests/{serviceRequestId}/apis','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('6af3c1c6-70e1-11ef-a7e3-025bd9f6f87b','서비스 신청을 위해 API 정보 저장','서비스 신청을 위해 API 정보 저장','/service-objects/requests/{serviceRequestId}/apis','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('6af3f2c2-70e1-11ef-a7e3-025bd9f6f87b','서비스 신청을 위해 저장한 API 실행','서비스 신청을 위해 저장한 API 실행','/service-objects/requests/{serviceRequestId}/apis/execute','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('6af42bed-70e1-11ef-a7e3-025bd9f6f87b','서비스 신청을 위해 저장한 API 실행','서비스 신청을 위해 저장한 API 실행','/service-objects/requests/apis/{apiId}/execute','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('6af4613c-70e1-11ef-a7e3-025bd9f6f87b','회원가입 초대 목록 조회','회원가입 초대 목록 조회','/invite','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('6af4b5b6-70e1-11ef-a7e3-025bd9f6f87b','회원가입 초대 생성','회원가입 초대 생성','/invite','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('6af4e69d-70e1-11ef-a7e3-025bd9f6f87b','[임시용] 초대 URL 회원가입 휴대폰 유효성 검사','[임시용] 초대 URL 회원가입 휴대폰 유효성 검사','/invite/phone/validate','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('6af51e62-70e1-11ef-a7e3-025bd9f6f87b','워크스페이스에 접근 권한 있는 모든 사용자 조회 for PPP','워크스페이스에 접근 권한 있는 모든 사용자 조회 for PPP','/user/authorized','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('6af5c3be-70e1-11ef-a7e3-025bd9f6f87b','서비스 타입 조회','서비스 타입 조회','/services/types','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('6af5f6c3-70e1-11ef-a7e3-025bd9f6f87b','나의 서비스 신청 목록','나의 서비스 신청 목록','/services/my-requests','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('6af62e40-70e1-11ef-a7e3-025bd9f6f87b','나의 서비스 신청 상세','나의 서비스 신청 상세','/services/my-requests/{serviceRequestId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('6af67016-70e1-11ef-a7e3-025bd9f6f87b','승인 처리 현황 상세','승인 처리 현황 상세','/services/my-approvals/{serviceRequestId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('6af6fcf0-70e1-11ef-a7e3-025bd9f6f87b','카테고리 별 서비스 타입 개수 조회','카테고리 별 서비스 타입 개수 조회','/services/categories/type-counts','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-product','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('6af73fd8-70e1-11ef-a7e3-025bd9f6f87b','서비스 상품 조회','서비스 상품 조회','/products/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-product','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('6af79089-70e1-11ef-a7e3-025bd9f6f87b','회원가입 초대 유효성 검사','회원가입 초대 유효성 검사','/invite/validate','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('6af7c6a2-70e1-11ef-a7e3-025bd9f6f87b','사용자 초대 시 email 유효성 검사','사용자 초대 시 email 유효성 검사','/invite/email/validate','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('6af7f91c-70e1-11ef-a7e3-025bd9f6f87b','승인 처리 대상 목록','승인 처리 대상 목록','/approvals/my-approvals','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('6af82e06-70e1-11ef-a7e3-025bd9f6f87b','사용자 삭제','사용자 삭제','/user/soft-delete/{userId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','DELETE',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('6af85f21-70e1-11ef-a7e3-025bd9f6f87b','반려 처리','반려 처리','/approvals/{approvalId}/reject','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('6af89198-70e1-11ef-a7e3-025bd9f6f87b','승인 처리','승인 처리','/approvals/{approvalId}/approve','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('6af8c32a-70e1-11ef-a7e3-025bd9f6f87b','승인 처리 현황 상세','승인 처리 현황 상세','/services/my-approvals/{serviceRequestId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('6af8f6fc-70e1-11ef-a7e3-025bd9f6f87b','승인 처리 현황','승인 처리 현황','/approvals/my-approvals','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('6afcaad9-e7ea-11ee-ac8e-c6591bb2a6db','커뮤니티 게시글 상태 수정','커뮤니티 게시글 상태 수정','/boards/status/{boardId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','board','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('6ccf78f7-44d9-11ef-a4c4-96fd9ef2bacb','로드 밸런서 생성','로드 밸런서 생성','/nsx/lb-services/{lb-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','loadbalancing','loadbalancer','POST',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
    ,   ('6ce0174e-44d9-11ef-a4c4-96fd9ef2bacb','게이트웨이 방화벽 단일 규칙 조회','게이트웨이 방화벽 단일 규칙 조회','/nsx/gfw/{gfw-id}/rules/{gfw-rule-id}','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','networksecurity','gatewayfirewall','GET',1,'76002c9b-17fa-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('6d77e97c-295b-11ef-9f42-5e230e3817dd','admin : PUT/network/internet-gateways/detach','admin : PUT/network/internet-gateways/detach','/network/internet-gateways/detach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','gateway','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('6d787107-295b-11ef-9f42-5e230e3817dd','admin : PUT/network/internet-gateways/attach','admin : PUT/network/internet-gateways/attach','/network/internet-gateways/attach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','gateway','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('6d78b4c2-295b-11ef-9f42-5e230e3817dd','보안그룹 중복 확인','보안그룹 중복 확인','/security-groups/duplicate-checker','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('6d7910b7-295b-11ef-9f42-5e230e3817dd','Internet GW 중복 조회','Internet GW 중복 조회','/network/internet-gateways/filters','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','gateway','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('6d794efd-295b-11ef-9f42-5e230e3817dd','user : PUT/network/internet-gateways/detach','user : PUT/network/internet-gateways/detach','/network/internet-gateways/detach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','gateway','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('6d7980ac-295b-11ef-9f42-5e230e3817dd','user : PUT/network/internet-gateways/attach','user : PUT/network/internet-gateways/attach','/network/internet-gateways/attach','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','gateway','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('6d7a08f1-295b-11ef-9f42-5e230e3817dd','보안그룹 중복 확인','보안그룹 중복 확인','/security-groups/duplicate-checker','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','security group','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('6d7a43cc-295b-11ef-9f42-5e230e3817dd','Internet GW 중복 조회','Internet GW 중복 조회','/network/internet-gateways/filters','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','gateway','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('6dae89d9-8ad7-11ef-a4ef-264dc84d6543','스냅샷/이미지 csv 다운로드','스냅샷/이미지 csv 다운로드','/prd/snapshotOrImage/csv','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','prd','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('6daf9955-8ad7-11ef-a4ef-264dc84d6543','스냅샷/이미지 조회','스냅샷/이미지 조회','/prd/snapshotImage','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','prd','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('6db03b55-8ad7-11ef-a4ef-264dc84d6543','서버 조회','서버 조회','/prd/server','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','prd','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('6db0a0e5-8ad7-11ef-a4ef-264dc84d6543','서버 디스크 조회','서버 디스크 조회','/prd/serverDisk','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','prd','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('6db10c38-8ad7-11ef-a4ef-264dc84d6543','서버 디스크 CSV 다운로드','서버 디스크 CSV 다운로드','/prd/serverDisk/csv','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','prd','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('6db17220-8ad7-11ef-a4ef-264dc84d6543','서버 CSV 다운로드','서버 CSV 다운로드','/prd/server/csv','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','prd','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('6db1cd79-8ad7-11ef-a4ef-264dc84d6543','라이선스(MS-SQL) 조회','라이선스(MS-SQL) 조회','/prd/licenseMsSql','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','prd','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('6db22ecc-8ad7-11ef-a4ef-264dc84d6543','라이선스(MS-SQL) csv 다운로드','라이선스(MS-SQL) csv 다운로드','/prd/licenseMsSql/csv','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','prd','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('6db2895a-8ad7-11ef-a4ef-264dc84d6543','서비스 신청 목록','서비스 신청 목록','/services/requests','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('6db2ee8e-8ad7-11ef-a4ef-264dc84d6543','서비스 신청','서비스 신청','/services/requests/{serviceRequestId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('705b5937-5878-11ef-a2be-3259e69cb451','볼륨 그룹 타입 스펙 관리 API','볼륨 그룹 타입 스펙 관리 API','/block-storage/volume-group-types/{volumeGroupTypeId}/volume-group-type-specs/manage','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('705cb257-5878-11ef-a2be-3259e69cb451','볼륨 그룹 타입 스펙 관리 API','볼륨 그룹 타입 스펙 관리 API','/block-storage/volume-group-types/{volumeGroupTypeId}/volume-group-type-specs/manage','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volumegroup','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('715badfd-1e53-11ef-922c-16fe18334070','서버 목록 조회 API','서버 목록 조회 API','/report/server/items','910fa43a-7797-11ee-b465-565158862942','Vista','observability','report','POST',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('715c195b-1e53-11ef-922c-16fe18334070','서버 현재 사용량 조회 API','서버 현재 사용량 조회 API','/report/server/status','910fa43a-7797-11ee-b465-565158862942','Vista','observability','report','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('715c5bfe-1e53-11ef-922c-16fe18334070','서버 주간 사용량 조회 API','서버 주간 사용량 조회 API','/report/server/status/week','910fa43a-7797-11ee-b465-565158862942','Vista','observability','report','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('715c9758-1e53-11ef-922c-16fe18334070','서버 월간 사용량 조회 API','서버 월간 사용량 조회 API','/report/server/status/month','910fa43a-7797-11ee-b465-565158862942','Vista','observability','report','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('715cd660-1e53-11ef-922c-16fe18334070','서버 일간 사용량 조회 API','서버 일간 사용량 조회 API','/report/server/status/day','910fa43a-7797-11ee-b465-565158862942','Vista','observability','report','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('715d1161-1e53-11ef-922c-16fe18334070','LMS Dashboard','LMS Dashboard','/point/solution/lms/table','910fa43a-7797-11ee-b465-565158862942','Vista','obsevability','pointsolution','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('71ac9ad6-1b50-11f0-b59d-5aaf6fae780b','mfa 사용 여부 조회','mfa 사용 여부 조회','/option/mfa/enable','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','option','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('71d6925d-22ff-11ef-922c-16fe18334070','추가된부분','추가된부분','/compute/servers/instance-types/amis/enables','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',1)
    ,   ('71d71102-22ff-11ef-922c-16fe18334070','추가된부분','추가된부분','/compute/servers/instance-types/amis/enables','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','server','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',1)
    ,   ('71fb0f07-b9ee-11ee-afaf-76fb71c4f9db','바톤 리소스 조회','바톤 리소스 조회','/baton/resources','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','baton','resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('71fb5e6e-b9ee-11ee-afaf-76fb71c4f9db','워크스페이스를 통한 바톤 리소스 조회','워크스페이스를 통한 바톤 리소스 조회','/baton/resources/workspace/{workspaceId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','baton','resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('71fb89b9-b9ee-11ee-afaf-76fb71c4f9db','워크스페이스 바톤 Openstack VM 리소스 조회','워크스페이스 바톤 Openstack VM 리소스 조회','/baton/resources/workspace/{workspaceId}/openstack/vm','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','baton','resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('71fbb196-b9ee-11ee-afaf-76fb71c4f9db','워크스페이스 바톤 K8s pod 리소스 조회','워크스페이스 바톤 K8s pod 리소스 조회','/baton/resources/workspace/{workspaceId}/kubernetes/pods','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','baton','resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7217b890-8f6a-11ef-a845-1a3f5588de48','조직 ID 기준 KTC Service 정보 조회','조직 ID 기준 KTC Service 정보 조회','/ktc/interface/service/{orgId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','ktc','home-api','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('7219d697-8f6a-11ef-a845-1a3f5588de48','조직 ID 기준 KTC Service 정보 조회i','조직 ID 기준 KTC Service 정보 조회i','/ktc/interface/service/{orgId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','ktc','home-api','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('7229827a-0473-11f0-a3f7-5e2a9b4227fd','자동 수집된 엔드포인트 조회','자동 수집된 엔드포인트 조회','/endpoints/auto-collected-endpoints','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','endpoint','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('72b77276-169c-11f0-8e4c-52e9553a2057','메트릭 조회 기능 단순화','메트릭 조회 기능 단순화','/v2/inquiry/','910fa43a-7797-11ee-b465-565158862942','Vista','observability','inquiry','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('730bfd8c-0388-11ef-8bb1-cee8dc1678f7','VPC cidr block 해제','VPC cidr block 해제한다.','/network/vpc/vpcs/disassociate/cidr-block','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('730c5f7f-0388-11ef-8bb1-cee8dc1678f7','VPC cidr block 연결','VPC cidr block 연결한다.','/network/vpc/vpcs/associate/cidr-block','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('730cb949-0388-11ef-8bb1-cee8dc1678f7','admin : PUT/network/gateway/private/unassign/ip','admin : PUT/network/gateway/private/unassign/ip','/network/gateway/private/unassign/ip','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','gateway','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('730d1f7e-0388-11ef-8bb1-cee8dc1678f7','admin : PUT/network/gateway/private/assign/ip','admin : PUT/network/gateway/private/assign/ip','/network/gateway/private/assign/ip','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','gateway','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('730d5571-0388-11ef-8bb1-cee8dc1678f7','admin : PUT/network/gateway/disassociate/ip','admin : PUT/network/gateway/disassociate/ip','/network/gateway/disassociate/ip','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','gateway','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('730d85d2-0388-11ef-8bb1-cee8dc1678f7','admin : PUT/network/gateway/associate/ip','admin : PUT/network/gateway/associate/ip','/network/gateway/associate/ip','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','gateway','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('730db3ff-0388-11ef-8bb1-cee8dc1678f7','ACL 목록 조회','ACL 목록을 조회한다.','/network/alcs','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','acl','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('730de846-0388-11ef-8bb1-cee8dc1678f7','ACL 재할당','ACL 을 재할당한다.','/network/alcs','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','acl','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('730e10a7-0388-11ef-8bb1-cee8dc1678f7','ACL 생성','ACL 을 생성한다.','/network/alcs','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','acl','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('730e372f-0388-11ef-8bb1-cee8dc1678f7','ACL 삭제','ACL 을 삭제한다.','/network/alcs','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','acl','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('730e5d9e-0388-11ef-8bb1-cee8dc1678f7','Elastic Ip 연결 해제','Elastic Ip 연결 해제','/compute/elastic-ips/disassociate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','elastic ip','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('730e8b02-0388-11ef-8bb1-cee8dc1678f7','Elastic Ip 연결','Elastic Ip 연결','/compute/elastic-ips/associate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','elastic ip','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('730fd115-0388-11ef-8bb1-cee8dc1678f7','default VPC 생성','default VPC 생성한다.','/network/vpc/vpcs/default','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('73108d9f-0388-11ef-8bb1-cee8dc1678f7','default Subnet 생성','default Subnet 생성한다.','/network/subnets/subnet/default','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','subnet','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7310dc01-0388-11ef-8bb1-cee8dc1678f7','라우팅 테이블 생성','라우팅 테이블 생성','/network/route','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7311049f-0388-11ef-8bb1-cee8dc1678f7','Route 생성','Route 생성','/network/router','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','router','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('73112970-0388-11ef-8bb1-cee8dc1678f7','Route 삭제','Route 삭제','/network/router','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','router','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('73114d85-0388-11ef-8bb1-cee8dc1678f7','admin : POST/network/gateway','admin : POST/network/gateway','/network/gateway','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','gateway','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7311709d-0388-11ef-8bb1-cee8dc1678f7','ACL Entry 생성','ACL Entry를 생성한다 .','/network/alcs/entrys','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','acl','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('731193d7-0388-11ef-8bb1-cee8dc1678f7','ACL Entry삭제','ACL Entry를 삭제한다.','/network/alcs/entrys','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','acl','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7311b912-0388-11ef-8bb1-cee8dc1678f7','nic 생성','nic 생성','/compute/nics','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','network interface','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7311ea2f-0388-11ef-8bb1-cee8dc1678f7','Elastic Ip 목록 조회','Elastic Ip 목록 조회','/compute/elastic-ips','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','elastic ip','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('731210e0-0388-11ef-8bb1-cee8dc1678f7','Elastic Ip 생성','Elastic Ip 생성','/compute/elastic-ips','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','elastic ip','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('73124b41-0388-11ef-8bb1-cee8dc1678f7','default Elastic Ip 생성','default Elastic Ip 생성','/compute/elastic-ips/default','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','elastic ip','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('73127da9-0388-11ef-8bb1-cee8dc1678f7','admin : GET/regions/availability-zones','admin : GET/regions/availability-zones','/regions/availability-zones','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','region','region','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7314223c-0388-11ef-8bb1-cee8dc1678f7','VPC 필터 목록','VPC 목록을 필터하여 조회한다.','/network/vpc/vpcs/filter','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','vpc','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7315492d-0388-11ef-8bb1-cee8dc1678f7','Subnet 필터 목록','Subnet 목록을 필터하여 조회한다.','/network/subnet/subnets/filter','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','subnet','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('73156f0a-0388-11ef-8bb1-cee8dc1678f7','VPC와 연관된 Subnet 목록 조회','VPC와 연관된 Subnet 목록 조회한다.','/network/subnet/subnets/by-vpc/{vpcId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','subnet','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('73158fe0-0388-11ef-8bb1-cee8dc1678f7','admin : GET/network/route/routes/by-subnet/{subnetId}',NULL,'/network/route/routes/by-subnet/{subnetId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7315b9e2-0388-11ef-8bb1-cee8dc1678f7','ACL 목록 subnet Id 조회','ACL 목록을 subnetid 로조회한다.','/network/alcs/by-subnet/{subnetId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','acl','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7315d984-0388-11ef-8bb1-cee8dc1678f7','admin : GET/compute/nics/{nicId}','admin : GET/compute/nics/{nicId}','/compute/nics/{nicId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','network interface','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7315fce3-0388-11ef-8bb1-cee8dc1678f7','nic 삭제','nic 삭제','/compute/nics/{nicId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','network interface','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('73161cda-0388-11ef-8bb1-cee8dc1678f7','Elastic Ip 상세보기','Elastic Ip 상세보기','/compute/elastic-ips/{allocationId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','elastic ip','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('73163fdc-0388-11ef-8bb1-cee8dc1678f7','Elastic Ip 삭제','Elastic Ip 삭제','/compute/elastic-ips/{allocationId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','elastic ip','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7316e930-0388-11ef-8bb1-cee8dc1678f7','라우팅 테이블 삭제','라우팅 테이블 삭제','/network/route/{routeTableId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7317105d-0388-11ef-8bb1-cee8dc1678f7','admin : DELETE/network/gateway/{natGatewayId}','admin : DELETE/network/gateway/{natGatewayId}','/network/gateway/{natGatewayId}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','gateway','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('73b769c2-874c-11ee-a4fd-dadafdb14cb0','Subnet 상세 조회 API','Subnet 상세 조회 API','/network/subnets/{subnetId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','subnet','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73b8510f-874c-11ee-a4fd-dadafdb14cb0','Subnet 수정 API','Subnet 수정 API','/network/subnets/{subnetId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','subnet','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73b8ddb8-874c-11ee-a4fd-dadafdb14cb0','SecurityGroup 상세 조회 API','SecurityGroup 상세 조회 API','/network/security-groups/{securityGroupId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','securitygroup','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73b96a58-874c-11ee-a4fd-dadafdb14cb0','보안 그룹 수정 API','보안 그룹 수정 API','/network/security-groups/{securityGroupId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','securitygroup','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73b9c69f-874c-11ee-a4fd-dadafdb14cb0','라우터 상세 조회 API','라우터 상세 조회 API','/network/routers/{routerId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','router','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73ba5c39-874c-11ee-a4fd-dadafdb14cb0','라우터 수정 API','라우터 수정 API','/network/routers/{routerId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','router','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73bb01f1-874c-11ee-a4fd-dadafdb14cb0','라우터 인터페이스 연결 해제 API','라우터 인터페이스 연결 해제 API','/network/routers/{routerId}/remove-router-interface','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','router','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('73bbd339-874c-11ee-a4fd-dadafdb14cb0','라우터 정적 경로 제거 API','라우터 정적 경로 제거 API','/network/routers/{routerId}/remove-extraroutes','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','router','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73bc3098-874c-11ee-a4fd-dadafdb14cb0','라우터 인터페이스 연결 API','라우터 인터페이스 연결 API','/network/routers/{routerId}/add-router-interface','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','router','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73bc8c5b-874c-11ee-a4fd-dadafdb14cb0','라우터 정적 경로 추가 API','라우터 정적 경로 추가 API','/network/routers/{routerId}/add-extraroutes','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','router','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73bd0be3-874c-11ee-a4fd-dadafdb14cb0','포트 상세 조회 API','포트 상세 조회 API','/network/ports/{portId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','port','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73bd63ce-874c-11ee-a4fd-dadafdb14cb0','포트 수정 API','포트 수정 API','/network/ports/{portId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','port','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73bdc453-874c-11ee-a4fd-dadafdb14cb0','포트 허용된 주소 추가 / 삭제 API','포트 허용된 주소 추가 / 삭제 API','/network/ports/{portId}/pairAddress','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','port','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73be42e1-874c-11ee-a4fd-dadafdb14cb0','네트워크 상세 조회 API','네트워크 상세 조회 API','/network/networks/{networkId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','network','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73beba01-874c-11ee-a4fd-dadafdb14cb0','네트워크 수정 API','네트워크 수정 API','/network/networks/{networkId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','network','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73bf2138-874c-11ee-a4fd-dadafdb14cb0','유동 아이피 수정 API','유동 아이피 수정 API','/network/floating-ips/{floatingIpId}/modify','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','floatingip','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73bf96d7-874c-11ee-a4fd-dadafdb14cb0','유동 아이피 연결 해제 API','유동 아이피 연결 해제 API','/network/floating-ips/{floatingIpId}/disassociate','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','floatingip','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73bfea96-874c-11ee-a4fd-dadafdb14cb0','자원(인스턴스, 포트)에 유동 아이피 할당 API','자원(인스턴스, 포트)에 유동 아이피 할당 API','/network/floating-ips/{floatingIpId}/connect','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','floatingip','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73c03d4c-874c-11ee-a4fd-dadafdb14cb0','세그먼트 조회','세그먼트 조회','/masakari/segments/{segmentUuId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','masakari','segments','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73c0a632-874c-11ee-a4fd-dadafdb14cb0','Segment Update','Segment Update','/masakari/segments/{segmentUuId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','masakari','segments','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73c12d14-874c-11ee-a4fd-dadafdb14cb0','마사카리 호스트 조회','마사카리 호스트 조회','/masakari/hosts/{hostId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','masakari','hosts','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73c1895c-874c-11ee-a4fd-dadafdb14cb0','Host Update','Host Update','/masakari/hosts/{hostId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','masakari','hosts','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73c1eeca-874c-11ee-a4fd-dadafdb14cb0','공유 파일 시스템 수정','공유 파일 시스템 수정','/manila/shares/{shareId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73c2c026-874c-11ee-a4fd-dadafdb14cb0','공유 파일 시스템 파일 메타데이터 조회','공유 파일 시스템 파일 메타데이터 조회','/manila/shares/metadata/{shareId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73c311a9-874c-11ee-a4fd-dadafdb14cb0','공유 파일 시스템 메타데이터 수정','공유 파일 시스템 메타데이터 수정','/manila/shares/metadata/{shareId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73c3615c-874c-11ee-a4fd-dadafdb14cb0','Pool 상세 조회','Pool 상세 조회','/load-balancer/pools/{poolId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73c3ac74-874c-11ee-a4fd-dadafdb14cb0','Pool Modify','Pool Modify','/load-balancer/pools/{poolId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('73c3f9f9-874c-11ee-a4fd-dadafdb14cb0','Pool Member 상세 조회','Pool Member 상세 조회','/load-balancer/pools/{poolId}/members/{memberId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73c44901-874c-11ee-a4fd-dadafdb14cb0','Pool Modify','Pool Modify','/load-balancer/pools/{poolId}/members/{memberId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73c4a274-874c-11ee-a4fd-dadafdb14cb0','LoadBalancer 상세 조회','LoadBalancer 상세 조회','/load-balancer/loadbalancers/{loadbalancerId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73c4fc21-874c-11ee-a4fd-dadafdb14cb0','Update a Listener','Update a Listener','/load-balancer/loadbalancers/{loadbalancerId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73c597df-874c-11ee-a4fd-dadafdb14cb0','loadbalancer listener 상세 조회','loadbalancer listener 상세 조회','/load-balancer/listeners/{listenerId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73c60308-874c-11ee-a4fd-dadafdb14cb0','Update a Listener','Update a Listener','/load-balancer/listeners/{listenerId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73c65966-874c-11ee-a4fd-dadafdb14cb0','loadbalancer health monitor 상세 조회','loadbalancer health monitor 상세 조회','/load-balancer/health-monitors/{healthMonitorId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73c6aacb-874c-11ee-a4fd-dadafdb14cb0','Update a Health Monitor','Update a Health Monitor','/load-balancer/health-monitors/{healthMonitorId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73c6f9fe-874c-11ee-a4fd-dadafdb14cb0','스택 상세 조회 API','스택 상세 조회 API','/heat/stacks/{stackName}/{stackId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','heat','stack','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73c76ed3-874c-11ee-a4fd-dadafdb14cb0','스택 템플릿 수정 API','스택 템플릿 수정 API','/heat/stacks/{stackName}/{stackId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','heat','stack','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73c7c136-874c-11ee-a4fd-dadafdb14cb0','스택 탬플릿 수정 프리뷰 API','스택 탬플릿 수정 프리뷰 API','/heat/stacks/{stackName}/{stackId}/preview','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','heat','stack','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73c815b1-874c-11ee-a4fd-dadafdb14cb0','인스턴스 수정 API','인스턴스 수정 API','/compute/servers/{serverId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73c86a68-874c-11ee-a4fd-dadafdb14cb0','인스턴스 스냅샷 상세 조회 API','인스턴스 스냅샷 상세 조회 API','/compute/servers/snapshots/{snapshotId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','glance','image','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73c8cdb6-874c-11ee-a4fd-dadafdb14cb0','인스턴스 스냅샷 수정 API','인스턴스 스냅샷 수정 API','/compute/servers/snapshots/{snapshotId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','glance','image','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73c92623-874c-11ee-a4fd-dadafdb14cb0','aggregate_id 가지고 호스트 상세 조회 API','aggregate_id 가지고 호스트 상세 조회 API','/compute/hosts/{aggregateId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','hostaggregate','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73c971aa-874c-11ee-a4fd-dadafdb14cb0','호스트 집합 수정 API','호스트 집합 수정 API','/compute/hosts/{aggregateId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','hostaggregate','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73ca38a5-874c-11ee-a4fd-dadafdb14cb0','인스턴스 유형 상세 조회 API','인스턴스 유형 상세 조회 API','/compute/flavors/{flavorId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','flavor','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73cab6ec-874c-11ee-a4fd-dadafdb14cb0','인스턴스 유형 수정 API','인스턴스 유형 수정 API','/compute/flavors/{flavorId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','flavor','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73cb1351-874c-11ee-a4fd-dadafdb14cb0','인스턴스 유형 메타데이터 수정 API','인스턴스 유형 메타데이터를 수정한다.','/compute/flavors/{flavorId}/metadata/{metadataKey}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','flavor','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73cb6a76-874c-11ee-a4fd-dadafdb14cb0','인스턴스 유형 메타데이터 삭제 API','인스턴스 유형 메타데이터를 삭제한다.','/compute/flavors/{flavorId}/metadata/{metadataKey}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','flavor','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('73cbbbd1-874c-11ee-a4fd-dadafdb14cb0','볼륨 상세 조회','볼륨 상세 조회','/block-storage/volumes/{volumeId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73cc31a7-874c-11ee-a4fd-dadafdb14cb0','volume modify','volume modify','/block-storage/volumes/{volumeId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73cc7b18-874c-11ee-a4fd-dadafdb14cb0','Volume Metadata - Show a volume’s metadata for a specific key','Volume Metadata - Show a volume’s metadata for a specific key','/block-storage/volumes/{volumeId}/metadata/{keyName}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73ccca4c-874c-11ee-a4fd-dadafdb14cb0','Volume Metadata - Update a volume’s metadata for a specific key','Volume Metadata - Update a volume’s metadata for a specific key','/block-storage/volumes/{volumeId}/metadata/{keyName}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73cd1338-874c-11ee-a4fd-dadafdb14cb0','volume type read','volume type read','/block-storage/volumes/volume-type','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73cd615e-874c-11ee-a4fd-dadafdb14cb0','volume type modify','볼륨타입 수정','/block-storage/volumes/volume-type','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73cda65a-874c-11ee-a4fd-dadafdb14cb0','volume type create','volume type create','/block-storage/volumes/volume-type','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73cdea16-874c-11ee-a4fd-dadafdb14cb0','Volume Type Delete','Volume Type Delete','/block-storage/volumes/volume-type','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73ce38a7-874c-11ee-a4fd-dadafdb14cb0','volume type encryption modify','volume type encryption modify','/block-storage/volumes/volume-type/{volumeTypeId}/encryption/{encryptionId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73cebe2d-874c-11ee-a4fd-dadafdb14cb0','Volume Type Encryption Delete','Volume Type Encryption Delete','/block-storage/volumes/volume-type/{volumeTypeId}/encryption/{encryptionId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73cf2503-874c-11ee-a4fd-dadafdb14cb0','volume type qos read','volume type qos read','/block-storage/volumes/volume-type-qos','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73cf749e-874c-11ee-a4fd-dadafdb14cb0','volume type qos modify','volume type qos modify','/block-storage/volumes/volume-type-qos','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73cfd2bc-874c-11ee-a4fd-dadafdb14cb0','volume type qos create','volume type qos create','/block-storage/volumes/volume-type-qos','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73d10a39-874c-11ee-a4fd-dadafdb14cb0','volume type qos delete','volume type qos delete','/block-storage/volumes/volume-type-qos','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73d1bf9a-874c-11ee-a4fd-dadafdb14cb0','volume type extra spec modify','볼륨타입 extra spec 수정','/block-storage/volumes/volume-type-extra','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73d25856-874c-11ee-a4fd-dadafdb14cb0','volume type extra specs create','볼륨 타입 extra specs 생성','/block-storage/volumes/volume-type-extra','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73d2c65c-874c-11ee-a4fd-dadafdb14cb0','Volume Type extra specs Delete','볼륨타입 extra spec 삭제','/block-storage/volumes/volume-type-extra','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73d31a2b-874c-11ee-a4fd-dadafdb14cb0','볼륨 스냅샷 상세 조회','볼륨 스냅샷 상세 조회','/block-storage/volumes/snapshots/{volumeSnapshotId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73d373db-874c-11ee-a4fd-dadafdb14cb0','볼륨 스냅샷 수정','볼륨 스냅샷 수정','/block-storage/volumes/snapshots/{volumeSnapshotId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73d403af-874c-11ee-a4fd-dadafdb14cb0','Subnet 목록 조회 API','Subnet 목록 조회 API','/network/subnets','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','subnet','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('73d4dd5c-874c-11ee-a4fd-dadafdb14cb0','Subnet 생성 API','Subnet 생성 API','/network/subnets','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','subnet','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73d53a3d-874c-11ee-a4fd-dadafdb14cb0','Subnet 삭제 API','Subnet 삭제 API','/network/subnets','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','subnet','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73d587d0-874c-11ee-a4fd-dadafdb14cb0','Security Group 목록 조회 API','Security Group 목록 조회 API','/network/security-groups','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','securitygroup','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73d6238a-874c-11ee-a4fd-dadafdb14cb0','보안 그룹 생성 API','보안 그룹 생성 API','/network/security-groups','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','securitygroup','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73d671ec-874c-11ee-a4fd-dadafdb14cb0','보안 그룹 삭제 API','보안 그룹 삭제 API','/network/security-groups','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','securitygroup','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73d6d959-874c-11ee-a4fd-dadafdb14cb0','인스턴스에 보안그룹 추가/삭제 API','인스턴스에 보안그룹 추가/삭제 API','/network/security-groups/instance-action/{instanceId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','securitygroup','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73d861c0-874c-11ee-a4fd-dadafdb14cb0','보안 그룹 규칙 목록 조회 API','보안 그룹 규칙 목록 조회 API','/network/security-group-rules','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','securitygroup','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73d9c10d-874c-11ee-a4fd-dadafdb14cb0','보안 그룹 규칙 생성 API','보안 그룹 규칙 생성 API','/network/security-group-rules','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','securitygroup','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73da465c-874c-11ee-a4fd-dadafdb14cb0','보안 그룹 규칙 다중 삭제 API','보안 그룹 규칙 다중 삭제 API','/network/security-group-rules','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','securitygroup','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73da9b91-874c-11ee-a4fd-dadafdb14cb0','라우터 목록 조회 API','라우터 목록 조회 API','/network/routers','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','router','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73daee58-874c-11ee-a4fd-dadafdb14cb0','라우터 생성 API','라우터 생성 API','/network/routers','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','router','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73db5da2-874c-11ee-a4fd-dadafdb14cb0','라우터 삭제 API','라우터 삭제 API','/network/routers','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','router','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73dc08a9-874c-11ee-a4fd-dadafdb14cb0','포트 목록 조회 API','포트 목록 조회 API','/network/ports','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','port','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73dc5f10-874c-11ee-a4fd-dadafdb14cb0','포트 생성 API','포트 생성 API','/network/ports','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','port','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73dcf21d-874c-11ee-a4fd-dadafdb14cb0','포트 삭제 API','포트 삭제 API','/network/ports','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','port','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73dd513c-874c-11ee-a4fd-dadafdb14cb0','네트워크 목록 조회 API','네트워크 목록 조회 API','/network/networks','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','network','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73ddaa7b-874c-11ee-a4fd-dadafdb14cb0','네트워크 생성 API','네트워크 생성 API','/network/networks','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','network','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73de03e9-874c-11ee-a4fd-dadafdb14cb0','네트워크 삭제 API','네트워크 삭제 API','/network/networks','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','network','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73dec7ff-874c-11ee-a4fd-dadafdb14cb0','유동 아이피 목록 조회 API','유동 아이피 목록 조회 API','/network/floating-ips','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','floatingip','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73df82d5-874c-11ee-a4fd-dadafdb14cb0','유동 아이피 생성 API','유동 아이피 생성 API','/network/floating-ips','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','floatingip','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('73dff093-874c-11ee-a4fd-dadafdb14cb0','유동 아이피 삭제 API','유동 아이피 삭제 API','/network/floating-ips','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','floatingip','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73e09e45-874c-11ee-a4fd-dadafdb14cb0','세그먼트 리스트 조회','세그먼트 리스트 조회','/masakari/segments','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','masakari','segments','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73e10194-874c-11ee-a4fd-dadafdb14cb0','Segment Create','Segment Create','/masakari/segments','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','masakari','segments','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73e1576d-874c-11ee-a4fd-dadafdb14cb0','Segment Delete','Segment Delete','/masakari/segments','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','masakari','segments','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73e21896-874c-11ee-a4fd-dadafdb14cb0','마사카리 호스트 리스트 조회','마사카리 호스트 리스트 조회','/masakari/hosts','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','masakari','hosts','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73e26d5f-874c-11ee-a4fd-dadafdb14cb0','Host Create','Host Create','/masakari/hosts','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','masakari','hosts','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73e2bb6e-874c-11ee-a4fd-dadafdb14cb0','Host Delete','Host Delete','/masakari/hosts','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','masakari','hosts','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73e3060a-874c-11ee-a4fd-dadafdb14cb0','공유 파일 시스템 목록 조회','공유 파일 시스템 목록 조회','/manila/shares','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73e3ddbd-874c-11ee-a4fd-dadafdb14cb0','공유 파일 시스템 생성','공유 파일 시스템 생성','/manila/shares','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73e522e6-874c-11ee-a4fd-dadafdb14cb0','공유 파일 시스템 삭제','공유 파일 시스템 삭제','/manila/shares','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73e5c467-874c-11ee-a4fd-dadafdb14cb0','공유 파일 시스템 타입 생성','공유 파일 시스템 타입 생성','/manila/shares/types','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73e68e9a-874c-11ee-a4fd-dadafdb14cb0','공유 파일 시스템 네트워크 전체 목록 정보 일반 조회','공유 파일 시스템 네트워크 전체 목록 정보 일반 조회','/manila/shares/networks','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73e6f782-874c-11ee-a4fd-dadafdb14cb0','공유 파일 시스템 네트워크 생성','공유 파일 시스템 네트워크 생성','/manila/shares/networks','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73e74a28-874c-11ee-a4fd-dadafdb14cb0','특정 공유 파일 시스템 규칙 전체 목록 상세 정보 조회','특정 공유 파일 시스템 규칙 전체 상세 정보가 포함된 리스트를 조회 한다.','/manila/shares/list-access/{shareId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73e8e1ee-874c-11ee-a4fd-dadafdb14cb0','공유 파일 시스템 그룹  생성','공유 파일 시스템 그룹  생성','/manila/shares/groups','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73e986f3-874c-11ee-a4fd-dadafdb14cb0','공유 파일 시스템 그룹 타입 생성','공유 파일 시스템 그룹 타입 생성','/manila/shares/group-types','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73ea125e-874c-11ee-a4fd-dadafdb14cb0','공유 파일 시스템 엑세스 규칙 생성','공유 파일 시스템 엑세스 규칙 생성','/manila/shares/grant-access/{shareId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73ea8849-874c-11ee-a4fd-dadafdb14cb0','공유 파일 시스템 사이즈 확장','공유 파일 시스템 사이즈 확장','/manila/shares/extend/{shareId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73eaf493-874c-11ee-a4fd-dadafdb14cb0','공유 파일 시스템 엑세스 규칙 삭제','공유 파일 시스템 엑세스 규칙 삭제','/manila/shares/deny-access/{shareId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73eb9c8a-874c-11ee-a4fd-dadafdb14cb0','Pool 목록 조회','Pool 목록 조회','/load-balancer/pools','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('73ec0ad5-874c-11ee-a4fd-dadafdb14cb0','Pool Create','Pool Create','/load-balancer/pools','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73ec6574-874c-11ee-a4fd-dadafdb14cb0','Pool Delete','Pool Delete','/load-balancer/pools','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73ecad4c-874c-11ee-a4fd-dadafdb14cb0','Pool Member 목록 조회','Pool Member 목록 조회','/load-balancer/pools/{poolId}/members','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73ed19b2-874c-11ee-a4fd-dadafdb14cb0','Pool Create','Pool Create','/load-balancer/pools/{poolId}/members','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73ed7886-874c-11ee-a4fd-dadafdb14cb0','LoadBalancer 목록 조회','LoadBalancer 목록 조회','/load-balancer/loadbalancers','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73edbfd0-874c-11ee-a4fd-dadafdb14cb0','로드밸런서 생성','로드밸런서 생성','/load-balancer/loadbalancers','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73ee0926-874c-11ee-a4fd-dadafdb14cb0','Update a Listener','Update a Listener','/load-balancer/loadbalancers','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73eee2b3-874c-11ee-a4fd-dadafdb14cb0','loadbalancer listener 목록 조회','loadbalancer listener 목록 조회','/load-balancer/listeners','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73f068ec-874c-11ee-a4fd-dadafdb14cb0','Create Listener','Create Listener','/load-balancer/listeners','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73f0e40a-874c-11ee-a4fd-dadafdb14cb0','Delete a Listener','Delete a Listener','/load-balancer/listeners','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73f1b303-874c-11ee-a4fd-dadafdb14cb0','loadbalancer health monitor 목록 조회','loadbalancer health monitor 목록 조회','/load-balancer/health-monitors','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73f210c4-874c-11ee-a4fd-dadafdb14cb0','Create Health Monitor','Create Health Monitor','/load-balancer/health-monitors','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73f2661f-874c-11ee-a4fd-dadafdb14cb0','Delete a Health Monitor','Delete a Health Monitor','/load-balancer/health-monitors','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73f2bc7f-874c-11ee-a4fd-dadafdb14cb0','스택 리스트 조회 API','스택 리스트 조회 API','/heat/stacks','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','heat','stack','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73f3109a-874c-11ee-a4fd-dadafdb14cb0','스택 생성 API','스택 생성 API','/heat/stacks','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','heat','stack','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73f35365-874c-11ee-a4fd-dadafdb14cb0','스택 삭제 API','스택 삭제 API','/heat/stacks','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','heat','stack','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73f39429-874c-11ee-a4fd-dadafdb14cb0','스택 Suspend/Resume/Check API','스택 Suspend/Resume/Check API','/heat/stacks/{stackName}/{stackId}/actions','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','heat','stack','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73f3e412-874c-11ee-a4fd-dadafdb14cb0','스택 탬플릿 생성 프리뷰 API','스택 탬플릿 생성 프리뷰 API','/heat/stacks/preview','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','heat','stack','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73f5149e-874c-11ee-a4fd-dadafdb14cb0','인스턴스 목록 조회 API','인스턴스 목록 조회 API','/compute/servers','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73f5aad2-874c-11ee-a4fd-dadafdb14cb0','인스턴스 생성 API','인스턴스 생성 API','/compute/servers','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('73f70c2c-874c-11ee-a4fd-dadafdb14cb0','인스턴스 삭제 API','인스턴스 삭제 API','/compute/servers','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73f77ca0-874c-11ee-a4fd-dadafdb14cb0','인스턴스 콘솔 생성 API','인스턴스 콘솔 생성 API','/compute/servers/{serverId}/remote-consoles','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73f7daf6-874c-11ee-a4fd-dadafdb14cb0','인스턴스와 인터페이스 목록 조회','인스턴스와 인터페이스 목록 조회','/compute/servers/{serverId}/os-interface','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73f82f11-874c-11ee-a4fd-dadafdb14cb0','인스턴스 인터페이스 생성 연결 API','인스턴스 인터페이스 생성 연결 API','/compute/servers/{serverId}/os-interface','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73f8862b-874c-11ee-a4fd-dadafdb14cb0','인스턴스 제어 - 중지 API','인스턴스 제어 - 중지 API','/compute/servers/{serverId}/action/stop','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73f946a3-874c-11ee-a4fd-dadafdb14cb0','인스턴스 제어 - 시작 API','인스턴스 제어 - 시작 API','/compute/servers/{serverId}/action/start','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73f9a89a-874c-11ee-a4fd-dadafdb14cb0','인스턴스 제어 - 재시작 API','인스턴스 제어 - 재시작 API','/compute/servers/{serverId}/action/reboot/{rebootType}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73fa0cf7-874c-11ee-a4fd-dadafdb14cb0','인스턴스 스냅샷 생성 API','인스턴스 스냅샷 생성 API','/compute/servers/snapshots','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','glance','image','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73fa912f-874c-11ee-a4fd-dadafdb14cb0','서버그룹 목록 조회 API','서버그룹 목록 조회 API','/compute/server-groups','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','servergroup','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73fae5b2-874c-11ee-a4fd-dadafdb14cb0','서버그룹 생성 API','서버그룹 생성 API','/compute/server-groups','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','servergroup','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73fb36e5-874c-11ee-a4fd-dadafdb14cb0','서버그룹 삭제 API','서버그룹 삭제 API','/compute/server-groups','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','servergroup','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73fb7d71-874c-11ee-a4fd-dadafdb14cb0','키페어 목록 조회 API','키페어 목록 조회 API','/compute/keypairs','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','keypair','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73fbc0d5-874c-11ee-a4fd-dadafdb14cb0','키페어 생성 및 임포트 API','키페어 생성 및 임포트 API','/compute/keypairs','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','keypair','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73fc078b-874c-11ee-a4fd-dadafdb14cb0','키페어 다중 삭제 API','키페어 다중 삭제 API','/compute/keypairs','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','keypair','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73fc4c02-874c-11ee-a4fd-dadafdb14cb0','Image 목록 조회 API','Image 목록 조회 API','/compute/images','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','glance','image','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73fc9318-874c-11ee-a4fd-dadafdb14cb0','이미지 생성 API','이미지 생성 API','/compute/images','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','image','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73fcfd8c-874c-11ee-a4fd-dadafdb14cb0','이미지 멀티 삭제 API','이미지 멀티 삭제 API','/compute/images','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','glance','image','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73fd53e1-874c-11ee-a4fd-dadafdb14cb0','호스트 리스트 조회 API','호스트 리스트 조회 API','/compute/hosts','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','hostaggregate','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73fda648-874c-11ee-a4fd-dadafdb14cb0','호스트 집합 생성 API','호스트 집합 생성 API','/compute/hosts','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','hostaggregate','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73fe0515-874c-11ee-a4fd-dadafdb14cb0','호스트 집합 삭제 API','호스트 집합 삭제 API','/compute/hosts','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','hostaggregate','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('73fe63bd-874c-11ee-a4fd-dadafdb14cb0','호스트집합 호스트 추가/삭제 API','호스트집합 호스트 추가/삭제 API','/compute/hosts/{aggregateId}/host','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','hostaggregate','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73feaf74-874c-11ee-a4fd-dadafdb14cb0','인스턴스 유형 목록 조회 API','인스턴스 유형 목록 조회 API','/compute/flavors','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','flavor','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73fef0d1-874c-11ee-a4fd-dadafdb14cb0','인스턴스 유형 생성 API','인스턴스 유형 생성 API','/compute/flavors','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','flavor','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73ff4e82-874c-11ee-a4fd-dadafdb14cb0','인스턴스 유형 멀티 삭제 API','인스턴스 유형 멀티 삭제 API','/compute/flavors','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','flavor','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73ffa212-874c-11ee-a4fd-dadafdb14cb0','인스턴스 유형 메타데이터 조회 API','인스턴스 유형 메타데이터 조회 API','/compute/flavors/{flavorId}/metadata','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','flavor','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('73ffe728-874c-11ee-a4fd-dadafdb14cb0','인스턴스 유형 메타데이터 생성/수정/삭제 API','인스턴스 유형 메타데이터 생성/수정/삭제 API','/compute/flavors/{flavorId}/metadata','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','flavor','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7400d18e-874c-11ee-a4fd-dadafdb14cb0','볼륨 목록 조회','볼륨 목록 조회','/block-storage/volumes','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('74011d71-874c-11ee-a4fd-dadafdb14cb0','volume create','volume create','/block-storage/volumes','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7401c4ff-874c-11ee-a4fd-dadafdb14cb0','Volume Delete','Volume Delete','/block-storage/volumes','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7402220c-874c-11ee-a4fd-dadafdb14cb0','Volume Action - Detach volume from server','Volume Action - Detach volume from server','/block-storage/volumes/{volumeId}/server/{serverId}/action/detach-server','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('74026cc0-874c-11ee-a4fd-dadafdb14cb0','Volume Action - Attach volume to a server','Volume Action - Attach volume to a server','/block-storage/volumes/{volumeId}/server/{serverId}/action/attach-server','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7402dece-874c-11ee-a4fd-dadafdb14cb0','Volume Metadata - Show a volume’s metadata','Volume Metadata - Show a volume’s metadata','/block-storage/volumes/{volumeId}/metadata','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7403b9a4-874c-11ee-a4fd-dadafdb14cb0','Volume Metadata - Create metadata for volume','Volume Metadata - Create metadata for volume','/block-storage/volumes/{volumeId}/metadata','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('740406a1-874c-11ee-a4fd-dadafdb14cb0','Volume Metadata - Delete a volume’s metadata','Volume Metadata - Delete a volume’s metadata','/block-storage/volumes/{volumeId}/metadata','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('74044dc5-874c-11ee-a4fd-dadafdb14cb0','Volume Action - Retype a volume type','Volume Action - Retype a volume type','/block-storage/volumes/{volumeId}/action/retype-type','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7404a7bd-874c-11ee-a4fd-dadafdb14cb0','Volume Action - Reset a volume Status','Volume Action - Reset a volume Status','/block-storage/volumes/{volumeId}/action/reset-status','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7404fa1f-874c-11ee-a4fd-dadafdb14cb0','Volume Action - Extend a volume size','Volume Action - Extend a volume size','/block-storage/volumes/{volumeId}/action/extend-size','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7405b096-874c-11ee-a4fd-dadafdb14cb0','volume type encryption read','volume type encryption read','/block-storage/volumes/volume-type/{volumeTypeId}/encryption','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7405ffc0-874c-11ee-a4fd-dadafdb14cb0','volume type encryption create','volume type encryption create','/block-storage/volumes/volume-type/{volumeTypeId}/encryption','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('740668c2-874c-11ee-a4fd-dadafdb14cb0','volume type qos modify','volume type qos modify','/block-storage/volumes/volume-type-qos-meta','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('7406b870-874c-11ee-a4fd-dadafdb14cb0','Volume Type qos meta data Delete','Volume Type qos meta data Delete','/block-storage/volumes/volume-type-qos-meta','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('740702ef-874c-11ee-a4fd-dadafdb14cb0','볼륨 스냅샷 목록 조회','볼륨 스냅샷 목록 조회','/block-storage/volumes/snapshots','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('74075550-874c-11ee-a4fd-dadafdb14cb0','볼륨 스냅샷 생성','볼륨 스냅샷 생성','/block-storage/volumes/snapshots','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7407b8e0-874c-11ee-a4fd-dadafdb14cb0','볼륨 스냅샷 삭제','볼륨 스냅샷 삭제','/block-storage/volumes/snapshots','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7407fe1c-874c-11ee-a4fd-dadafdb14cb0','Image 상세 조회 API','Image 상세 조회 API','/compute/images/{imageId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','glance','image','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('740845a7-874c-11ee-a4fd-dadafdb14cb0','이미지 수정 API','이미지 수정 API','/compute/images/{imageId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','image','PATCH',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('74088a3f-874c-11ee-a4fd-dadafdb14cb0','SecurityGroup 상세 필터링 조회 API','SecurityGroup 상세 필터링 조회 API','/network/security-groups/{securityGroupId}/instance','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','securitygroup','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7408cb17-874c-11ee-a4fd-dadafdb14cb0','Instance 생성을 위한 프로젝트별 SecurityGroup 조회','Instance 생성을 위한 프로젝트별 SecurityGroup 조회','/network/security-groups/instance','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','securitygroup','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('740910c8-874c-11ee-a4fd-dadafdb14cb0','instance에 해당하는 Security Group 목록 조회 API','instance에 해당하는 Security Group 목록 조회 API','/network/security-groups/instance/{instanceId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','securitygroup','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('740957b9-874c-11ee-a4fd-dadafdb14cb0','보안 그룹 규칙 상세 조회 API','보안 그룹 규칙 상세 조회 API','/network/security-group-rules/{securityGroupRuleId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','securitygroup','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('74099a10-874c-11ee-a4fd-dadafdb14cb0','네트워크 목록 조회 API','네트워크 목록 조회 API','/network/networks/router','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','network','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7409d9ef-874c-11ee-a4fd-dadafdb14cb0','네트워크 목록 조회 API','네트워크 목록 조회 API','/network/networks/instance','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','network','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('740a1a42-874c-11ee-a4fd-dadafdb14cb0','유동 아이피 상세 조회 API','유동 아이피 상세 조회 API','/network/floating-ips/{floatingIpId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','floatingip','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('740a9297-874c-11ee-a4fd-dadafdb14cb0','NetworkTopology 데이터 조회 API','NetworkTopology 데이터 조회 API','/network-topology','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','topology','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('740adda6-874c-11ee-a4fd-dadafdb14cb0','마사카리 알림 리스트 조회','마사카리 알림 리스트 조회','/masakari/notifications','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','masakari','notifications','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('740b2027-874c-11ee-a4fd-dadafdb14cb0','마사카리 알림 상세 조회','마사카리 알림 상세 조회','/masakari/notifications/{notificationId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','masakari','notifications','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('740b69fd-874c-11ee-a4fd-dadafdb14cb0','공유 파일 시스템 프로토콜 값 전달','공유 파일 시스템 프로토콜 값 전달','/manila/shares/share-protocol','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('740bb055-874c-11ee-a4fd-dadafdb14cb0','특정 공유 파일 시스템 네트워크  상세 정보 조회','특정 공유 파일 시스템 네트워크  상세 정보 조회','/manila/shares/networks/{shareNetworkId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('740bf168-874c-11ee-a4fd-dadafdb14cb0','공유 파일 시스템 네트워크 전체 목록 상세 정보 조회','공유 파일 시스템 네트워크 전체 목록 상세 정보 조회','/manila/shares/networks-detail','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('740c58ee-874c-11ee-a4fd-dadafdb14cb0','공유 파일 시스템 그룹 전체 목록 상세 정보 조회','공유 파일 시스템 그룹 전체 목록 상세 정보 조회','/manila/shares/groups-detail','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('740d7d6a-874c-11ee-a4fd-dadafdb14cb0','특정 공유 파일 시스템 상세 조회','특정 공유 파일 시스템 상세 조회','/manila/shares/filter-by-id','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('740dec8a-874c-11ee-a4fd-dadafdb14cb0','공유 파일 시스템 전체 목록 상세 정보 조회','공유 파일 시스템 전체 목록 상세 정보 조회','/manila/shares/detail','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('740e4dbe-874c-11ee-a4fd-dadafdb14cb0','공유 파일 시스템 가용 영역 상세 정보 조회','공유 파일 시스템 가용 영역 상세 정보 조회','/manila/shares/availability-zones','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('740eb7dc-874c-11ee-a4fd-dadafdb14cb0','공유 파일 시스템 엑세스 규칙 AccessType 값 전달','공유 파일 시스템 엑세스 규칙 AccessType 값 전달','/manila/shares/access-type','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('740f2c6f-874c-11ee-a4fd-dadafdb14cb0','공유 파일 시스템 엑세스 규칙 AccessLevel 값 전달','공유 파일 시스템 엑세스 규칙 AccessLevel 값 전달','/manila/shares/access-level','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','manila','share','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('740fb2e3-874c-11ee-a4fd-dadafdb14cb0','Pool 맴버 목록 조회','Pool 맴버 목록 조회','/load-balancer/pools/members','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('74114746-874c-11ee-a4fd-dadafdb14cb0','L7 Rule 리스트 조회','L7 Rule 리스트 조회','/load-balancer/l7/rules','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7411b4af-874c-11ee-a4fd-dadafdb14cb0','L7 Rule 조회','L7 Rule 조회','/load-balancer/l7/rules/{ruleId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('741259e7-874c-11ee-a4fd-dadafdb14cb0','L7 Policy 리스트 조회','L7 Policy 리스트 조회','/load-balancer/l7/policies','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7412ffc7-874c-11ee-a4fd-dadafdb14cb0','L7 Policy 조회','L7 Policy 조회','/load-balancer/l7/policies/{l7policyId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('74134f1c-874c-11ee-a4fd-dadafdb14cb0','스택 템플릿 버전 리스트 조회 API','스택 템플릿 버전 리스트 조회 API','/heat/stacks/template-versions','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','heat','stacktemplateversion','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('74139f5f-874c-11ee-a4fd-dadafdb14cb0','스택 템플릿 버전 조회 API','스택 템플릿 버전 조회 API','/heat/stacks/template-versions/{templateVersion}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','heat','stacktemplateversion','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('74140044-874c-11ee-a4fd-dadafdb14cb0','스택 리소스 타입 조회 API','스택 리소스 타입 조회 API','/heat/stacks/resource-types','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','heat','stackresourcetype','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('741448d2-874c-11ee-a4fd-dadafdb14cb0','스택 리소스 타입 템플릿 조회 API','스택 리소스 타입 템플릿 조회 API','/heat/stacks/resource-types/{typeName}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','heat','stackresourcetype','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('741496bb-874c-11ee-a4fd-dadafdb14cb0','인스턴스 상세 작업 이력 API','인스턴스 상세 작업 이력 API','/compute/servers/{serverId}/os-instance-actions','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('741532ee-874c-11ee-a4fd-dadafdb14cb0','인스턴스 상세 조회 API','인스턴스 상세 조회 API','/compute/servers/{instanceId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7415a342-874c-11ee-a4fd-dadafdb14cb0','인스턴스와 상세 조회 - 볼륨 API','인스턴스와 상세 조회 - 볼륨 API','/compute/servers/{instanceId}/volumes','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('74160d6a-874c-11ee-a4fd-dadafdb14cb0','인스턴스와 상세 조회 - 보안그룹 API','인스턴스와 상세 조회 - 보안그룹 API','/compute/servers/{instanceId}/security-groups','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('74165eed-874c-11ee-a4fd-dadafdb14cb0','서버그룹 상세 조회 API','서버그룹 상세 조회 API','/compute/server-groups/{serverGroupId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','servergroup','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7416b8c2-874c-11ee-a4fd-dadafdb14cb0','키페어 상세 조회 API','키페어 상세 조회 API','/compute/keypairs/{keypairName}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','keypair','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('74172d2d-874c-11ee-a4fd-dadafdb14cb0','하이퍼 바이저 조회 API','하이퍼 바이저 조회 API','/compute/hypervisors','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','hypervisor','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('741ae70a-874c-11ee-a4fd-dadafdb14cb0','하이퍼 바이저 상세 조회','하이퍼 바이저 상세 조회','/compute/hypervisors/{hypervisorId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','hypervisor','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('741bab09-874c-11ee-a4fd-dadafdb14cb0','컴퓨트 호스트 조회 API','컴퓨트 호스트 조회 API','/compute/hypervisors/compute-hosts','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','hypervisor','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('741c1e3a-874c-11ee-a4fd-dadafdb14cb0','하이퍼 바이저 컴퓨트 호스트 상세 조회','하이퍼 바이저 컴퓨트 호스트 상세 조회','/compute/hypervisors/compute-hosts/{hypervisorId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','hypervisor','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('741cdd1d-874c-11ee-a4fd-dadafdb14cb0','Availability zones 상세 리스트 조회 API','Availability zones 상세 리스트 조회 API','/compute/availability-zones','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','availabilityzone','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('741db0bc-874c-11ee-a4fd-dadafdb14cb0','Availability zones 간단 조회 API','Availability zones 간단 조회 API','/compute/availability-zones/summary','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','availabilityzone','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('741e9ceb-874c-11ee-a4fd-dadafdb14cb0','volume type detail read','volume type detail read','/block-storage/volumes/volume-type/{volumeTypeId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('741f3cbb-874c-11ee-a4fd-dadafdb14cb0','volume type metadata read','volume type metadata read','/block-storage/volumes/volume-type/{volumeTypeId}/extra-specs','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('742023d3-874c-11ee-a4fd-dadafdb14cb0','volume type qos detail read','volume type qos detail read','/block-storage/volumes/volume-type-qos/{qosId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7420b503-874c-11ee-a4fd-dadafdb14cb0','volume type qos disassociate','volume type qos disassociate','/block-storage/volumes/volume-type-qos/{qosId}/disassociate','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('74211e92-874c-11ee-a4fd-dadafdb14cb0','volume type qos associate','volume type qos associate','/block-storage/volumes/volume-type-qos/{qosId}/associate','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7421b96a-874c-11ee-a4fd-dadafdb14cb0','해당 스냅샷으로 생성한 볼륨 목록 조회','해당 스냅샷으로 생성한 볼륨 목록 조회','/block-storage/volumes/volume-snapshot/{snapshotId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('74221130-874c-11ee-a4fd-dadafdb14cb0','해당 server에 부착되어있는 볼륨 목록 조회 (인스턴스 상세)','해당 server에 부착되어있는 볼륨 목록 조회 (인스턴스 상세)','/block-storage/volumes/instance/{instanceId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('74227b08-874c-11ee-a4fd-dadafdb14cb0','볼륨 목록 조회','볼륨 목록 조회','/block-storage/volumes/filter-by-id','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7422d52d-874c-11ee-a4fd-dadafdb14cb0','인스턴스에 부착 가능한 볼륨 목록 조회','인스턴스에 부착 가능한 볼륨 목록 조회','/block-storage/volumes/attach-server','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('74232729-874c-11ee-a4fd-dadafdb14cb0','Storage Backend read','Storage Backend read','/block-storage/storage-back-end','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','storage','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('74236df3-874c-11ee-a4fd-dadafdb14cb0','인스턴스 인터페이스 연결 해제 API','인스턴스 인터페이스 연결 해제 API','/compute/servers/{serverId}/os-interface/{portId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','DELETE',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('74404c85-f645-11ee-ac8e-c6591bb2a6db','로드밸런서에 유동 아이피 할당 API','로드밸런서에 유동 아이피 할당 API','/network/{networkId}/floating-ips/connectLB','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','floatingip','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('74415b10-f645-11ee-ac8e-c6591bb2a6db','유동 아이피 풀 목록 API','유동 아이피 풀 목록 API','/network/floating-ips/pools','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','floatingip','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('748c9137-31f5-11ef-9f42-5e230e3817dd','유저 역할 타입과 조직에 배포된 역할 조회 API','유저 역할 타입과 조직에 배포된 역할 조회 API','/roles/type/user/category','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','role','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('748d0aaa-31f5-11ef-9f42-5e230e3817dd','관리자 역할 타입과 조직에 배포된 역할 조회 API','관리자 역할 타입과 조직에 배포된 역할 조회 API','/roles/type/admin/category','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','policy','role','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('74e09977-c4c0-11ee-8281-7e177595258d','워크스페이스 네트워크 목록 조회 API','워크스페이스에 속한 네트워크 목록 조회','/workspaces/networks','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','network','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('75043459-1360-11ef-b423-d64cbd53aa04','가상머신 별 이상탐지 메트릭 차트 조회','가상머신 별 이상탐지 메트릭 차트 조회','/ai/anomaly-detection/servers/chart/{vmId}/{platformType}/{metricName}/{dayCount}/{intervalType}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','ai','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7513382d-8486-11ef-9a6b-ba8787afde77','라이선스(OS) 조회','라이선스(OS) 조회','/prd/licenseOs','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','prd','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('751392ba-8486-11ef-9a6b-ba8787afde77','라이선스(OS) csv 다운로드','라이선스(OS) csv 다운로드','/prd/licenseOs/csv','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','prd','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('7513c40e-8486-11ef-9a6b-ba8787afde77','유저 도메인 용 - 그룹 상세 조회','유저 도메인 용 - 그룹 상세 조회','/user/group/{groupId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','group','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7514134f-8486-11ef-9a6b-ba8787afde77','유저 도메인 용 - 사용자 그룹 수정','유저 도메인 용 - 사용자 그룹 수정','/user/group/{groupId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','group','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('75142534-14e3-11f0-8e4c-52e9553a2057','Provider ID 기준 IP Pool 삭제','Provider ID 기준 IP Pool 삭제','/ip-pool/provider/{providerId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','ip-pool','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('751440b2-8486-11ef-9a6b-ba8787afde77','유저 도메인 용 - 사용자 그룹 삭제','유저 도메인 용 - 사용자 그룹 삭제','/user/group/{groupId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','group','DELETE',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('75146b2d-8486-11ef-9a6b-ba8787afde77','사용자 탈퇴','사용자 탈퇴','/user/cancel','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('7514bca8-8486-11ef-9a6b-ba8787afde77','유저 도메인 용 - 그룹 목록 조회','유저 도메인 용 - 그룹 목록 조회','/user/group','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','group','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7514e897-8486-11ef-9a6b-ba8787afde77','유저 도메인 용 - 사용자 그룹 생성','유저 도메인 용 - 사용자 그룹 생성','/user/group','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','group','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('75155bbe-8486-11ef-9a6b-ba8787afde77','나의 서비스 신청 취소','나의 서비스 신청 취소','/services/my-requests/{serviceRequestId}/cancel','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('7515a164-8486-11ef-9a6b-ba8787afde77','서비스 반려 처리','서비스 반려 처리','/approvals/{approvalId}/reject','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('7515e886-8486-11ef-9a6b-ba8787afde77','서비스 승인 처리','서비스 승인 처리','/approvals/{approvalId}/approve','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('7516187f-8486-11ef-9a6b-ba8787afde77','유저 도메인 용 - 사용자가 속한 그룹 목록 조회','유저 도메인 용 - 사용자가 속한 그룹 목록 조회','/user/group/{userId}/groups','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','group','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('75164941-8486-11ef-9a6b-ba8787afde77','유저 도메인 용 - 그룹 생성시 메일 중복 확인','유저 도메인 용 - 그룹 생성시 메일 중복 확인','/user/group/check-group-email','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','user','group','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('75590394-0395-11ef-8bb1-cee8dc1678f7','쿠버네티스 파드 상세 조회','쿠버네티스 파드 상세 조회','/v1/k8s/namespace/{namespaceName}/pods/{podName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','kubernetes','pod','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('75598267-0395-11ef-8bb1-cee8dc1678f7','쿠버네티스 파드 수정','쿠버네티스 파드 수정','/v1/k8s/namespace/{namespaceName}/pods/{podName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','kubernetes','pod','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('7559cb73-0395-11ef-8bb1-cee8dc1678f7','쿠버네티스 파드 삭제','쿠버네티스 파드 삭제','/v1/k8s/namespace/{namespaceName}/pods/{podName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','kubernetes','pod','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('755a14e0-0395-11ef-8bb1-cee8dc1678f7','사용자 포탈 - 파드 리스트','사용자 포탈 - 파드 리스트','/v1/pods','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('755a58b1-0395-11ef-8bb1-cee8dc1678f7','쿠버네티스 자원 번들 생성','쿠버네티스 자원 번들 생성','/v1/k8s/namespace/{namespaceName}/resources','345ae518-f857-11ed-921d-aa1950d374e1','Viola','kubernetes','namespace','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('755a9072-0395-11ef-8bb1-cee8dc1678f7','쿠버네티스 파드 리스트 조회','쿠버네티스 파드 리스트 조회','/v1/k8s/namespace/{namespaceName}/pods','345ae518-f857-11ed-921d-aa1950d374e1','Viola','kubernetes','pod','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('755ac7e6-0395-11ef-8bb1-cee8dc1678f7','쿠버네티스 파드 생성','쿠버네티스 파드 생성','/v1/k8s/namespace/{namespaceName}/pods','345ae518-f857-11ed-921d-aa1950d374e1','Viola','kubernetes','pod','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('7571c374-5b8d-11ef-b739-0ebddd68c8c8','클러스터 대시보드 상태현황','클러스터 대시보드 상태현황','/v1/k8s/monitoring/cluster-dashboard/status-overview','345ae518-f857-11ed-921d-aa1950d374e1','Viola','monitoring','cluster-dashboard','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('757292a3-5b8d-11ef-b739-0ebddd68c8c8','클러스터 대시보드 자원개요','클러스터 대시보드 자원개요','/v1/k8s/monitoring/cluster-dashboard/resource-overview','345ae518-f857-11ed-921d-aa1950d374e1','Viola','monitoring','cluster-dashboard','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('7573026d-5b8d-11ef-b739-0ebddd68c8c8','클러스터 대시보드 노드별 현황','클러스터 대시보드 노드별 현황','/v1/k8s/monitoring/cluster-dashboard/node-status-overview','345ae518-f857-11ed-921d-aa1950d374e1','Viola','monitoring','cluster-dashboard','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('75733b37-5b8d-11ef-b739-0ebddd68c8c8','클러스터 대시보드 상태현황','클러스터 대시보드 상태현황','/v1/k8s/monitoring/cluster-dashboard/status-overview','345ae518-f857-11ed-921d-aa1950d374e1','Viola','monitoring','cluster-dashboard','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('75737214-5b8d-11ef-b739-0ebddd68c8c8','클러스터 대시보드 자원개요','클러스터 대시보드 자원개요','/v1/k8s/monitoring/cluster-dashboard/resource-overview','345ae518-f857-11ed-921d-aa1950d374e1','Viola','monitoring','cluster-dashboard','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('7573a127-5b8d-11ef-b739-0ebddd68c8c8','클러스터 대시보드 노드별 현황','클러스터 대시보드 노드별 현황','/v1/k8s/monitoring/cluster-dashboard/node-status-overview','345ae518-f857-11ed-921d-aa1950d374e1','Viola','monitoring','cluster-dashboard','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('75a6c67e-1d9c-11ef-922c-16fe18334070','예산 적용 대상 조회','예산 적용 대상 조회','/budget/target/{budgetId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','budget','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('75a79be3-1d9c-11ef-922c-16fe18334070','예산 적용 대상 조회','예산 적용 대상 조회','/budget/target/save/{budgetId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','budget','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('75a80083-1d9c-11ef-922c-16fe18334070','예산 저장','예산 저장','/budget/save','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','budget','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('75a8761e-1d9c-11ef-922c-16fe18334070','예산 조회','예산 조회','/budget/list','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','budget','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('75a8fb72-1d9c-11ef-922c-16fe18334070','사용자/관리자 그룹 정보 수정 API','사용자/관리자 그룹 정보 수정 API','/group/{groupId}/user-and-admin-group','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','notification','PUT',1,'dc347010-c3f4-11ee-8281-7e177595258d',0)
    ,   ('75a95bda-1d9c-11ef-922c-16fe18334070','수신자 그룹 내 사용자/관리자 그룹 삭제 API','수신자 그룹 내 사용자/관리자 그룹 삭제 API','/group/{groupId}/user-and-admin-group','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','notification','DELETE',1,'dc347010-c3f4-11ee-8281-7e177595258d',0)
    ,   ('75a9f0bc-1d9c-11ef-922c-16fe18334070','조직 내 커뮤니티 게시글 삭제','조직 내 커뮤니티 게시글 삭제','/boards/orgs/{orgId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','board','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('75ea790f-1c1f-11f0-b59d-5aaf6fae780b','Asynq 스케줄러 상태 점검 API','Asynq 스케줄러 상태 점검 API','/v1/job-producer/scheduler/test','d4b549b8-4881-11ee-91df-4201ac100118','Doublebass','job-producer','scheduler','GET',1,'96aae0f7-15e0-11f0-8e4c-52e9553a2057',0)
    ,   ('76a344f2-2d49-11ef-9f42-5e230e3817dd','파드 상세 조회','파드 상세 조회','/v1/k8s/namespaces/{namespaceName}/pods/{podName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','pod','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('76a41589-2d49-11ef-9f42-5e230e3817dd','파드 수정','파드 수정','/v1/k8s/namespaces/{namespaceName}/pods/{podName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','pod','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('76a45b2c-2d49-11ef-9f42-5e230e3817dd','파드 삭제','파드 삭제','/v1/k8s/namespaces/{namespaceName}/pods/{podName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','pod','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('76a493a2-2d49-11ef-9f42-5e230e3817dd','Helm Release 수정','Helm Release 수정','/v1/catalog/provider/{providerId}/namespace/{namespaceId}/helms/chart/{chartName}/helmRelease/{helmReleaseName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','catalog','helm chart','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('76a4c6e8-2d49-11ef-9f42-5e230e3817dd','Helm Release 수정','Helm Release 수정','/v1/catalog/provider/{providerId}/namespace/{namespaceId}/helms/chart/{chartName}/helmRelease/{helmReleaseName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','catalog','helm chart','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('76a4fcc9-2d49-11ef-9f42-5e230e3817dd','서비스 신청을 통한 Helm Release 배포','서비스 신청을 통한 Helm Release 배포','/v1/catalog/provider/{providerId}/namespace/{namespaceId}/helms/chart/{chartName}/helmRelease/{helmReleaseName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','catalog','helm chart','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('76a533fd-2d49-11ef-9f42-5e230e3817dd','Helm Release 삭제','Helm Release 삭제','/v1/catalog/provider/{providerId}/namespace/{namespaceId}/helms/chart/{chartName}/helmRelease/{helmReleaseName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','catalog','helm chart','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('76a56346-2d49-11ef-9f42-5e230e3817dd','공급자 연결확인','공급자 연결확인','/v1/provider/connection/test','345ae518-f857-11ed-921d-aa1950d374e1','Viola','infra','provider','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('76a5929f-2d49-11ef-9f42-5e230e3817dd','네임스페이스별 파드 리스트 조회','네임스페이스별 파드 리스트 조회','/v1/k8s/namespaces/{namespaceName}/pods','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','pod','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('76a5c4e4-2d49-11ef-9f42-5e230e3817dd','파드 생성','파드 생성','/v1/k8s/namespaces/{namespaceName}/pods','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','pod','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('76a5f327-2d49-11ef-9f42-5e230e3817dd','서비스 신청을 통한 deployment 생성','서비스 신청을 통한 deployment 생성','/v1/catalog/provider/{providerId}/namespace/{namespaceId}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','catalog','deployment','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('76a624e4-2d49-11ef-9f42-5e230e3817dd','서비스 신청을 통한 Kubernetes Resources 생성','서비스 신청을 통한 Kubernetes Resources 생성','/v1/catalog/provider/{providerId}/namespace/{namespaceId}/resources','345ae518-f857-11ed-921d-aa1950d374e1','Viola','catalog','resources','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('76a6502c-2d49-11ef-9f42-5e230e3817dd','전체 파드 리스트 조회','전체 파드 리스트 조회','/v1/k8s/pods','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','pod','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('76a68156-2d49-11ef-9f42-5e230e3817dd','클러스터 삭제','클러스터 삭제','/v1/k8s/management/clusters/{clusterName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('76a6af79-2d49-11ef-9f42-5e230e3817dd','Harbor Helm Chart 조회','Harbor Helm Chart 조회','/v1/harbor/helmchart','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','helm chart','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('76a6d972-2d49-11ef-9f42-5e230e3817dd','파드 상세 조회','파드 상세 조회','/v1/k8s/namespaces/{namespaceName}/pods/{podName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','pod','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('76a721d2-2d49-11ef-9f42-5e230e3817dd','파드 수정','파드 수정','/v1/k8s/namespaces/{namespaceName}/pods/{podName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','pod','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('76a75651-2d49-11ef-9f42-5e230e3817dd','파드 삭제','파드 삭제','/v1/k8s/namespaces/{namespaceName}/pods/{podName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','pod','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('76a78d4c-2d49-11ef-9f42-5e230e3817dd','Helm Release 수정','Helm Release 수정','/v1/catalog/provider/{providerId}/namespace/{namespaceId}/helms/chart/{chartName}/helmRelease/{helmReleaseName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','catalog','helm chart','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('76a7c38d-2d49-11ef-9f42-5e230e3817dd','Helm Release 수정','Helm Release 수정','/v1/catalog/provider/{providerId}/namespace/{namespaceId}/helms/chart/{chartName}/helmRelease/{helmReleaseName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','catalog','helm chart','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('76a7fb0b-2d49-11ef-9f42-5e230e3817dd','서비스 신청을 통한 Helm Release 배포','서비스 신청을 통한 Helm Release 배포','/v1/catalog/provider/{providerId}/namespace/{namespaceId}/helms/chart/{chartName}/helmRelease/{helmReleaseName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','catalog','helm chart','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('76a82d69-2d49-11ef-9f42-5e230e3817dd','Helm Release 삭제','Helm Release 삭제','/v1/catalog/provider/{providerId}/namespace/{namespaceId}/helms/chart/{chartName}/helmRelease/{helmReleaseName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','catalog','helm chart','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('76a85ace-2d49-11ef-9f42-5e230e3817dd','공급자 연결확인','공급자 연결확인','/v1/provider/connection/test','345ae518-f857-11ed-921d-aa1950d374e1','Viola','infra','provider','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('76a887f4-2d49-11ef-9f42-5e230e3817dd','네임스페이스별 파드 리스트 조회','네임스페이스별 파드 리스트 조회','/v1/k8s/namespaces/{namespaceName}/pods','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','pod','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('76a8b586-2d49-11ef-9f42-5e230e3817dd','파드 생성','파드 생성','/v1/k8s/namespaces/{namespaceName}/pods','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','pod','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('76a8e27a-2d49-11ef-9f42-5e230e3817dd','서비스 신청을 통한 deployment 생성','서비스 신청을 통한 deployment 생성','/v1/catalog/provider/{providerId}/namespace/{namespaceId}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','catalog','deployment','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('76a90f35-2d49-11ef-9f42-5e230e3817dd','서비스 신청을 통한 Kubernetes Resources 생성','서비스 신청을 통한 Kubernetes Resources 생성','/v1/catalog/provider/{providerId}/namespace/{namespaceId}/resources','345ae518-f857-11ed-921d-aa1950d374e1','Viola','catalog','resources','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('76a93c94-2d49-11ef-9f42-5e230e3817dd','전체 파드 리스트 조회','전체 파드 리스트 조회','/v1/k8s/pods','345ae518-f857-11ed-921d-aa1950d374e1','Viola','workload','pod','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('76a97199-2d49-11ef-9f42-5e230e3817dd','클러스터 삭제','클러스터 삭제','/v1/k8s/management/clusters/{clusterName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('76a9a59a-2d49-11ef-9f42-5e230e3817dd','Harbor Helm Chart 조회','Harbor Helm Chart 조회','/v1/harbor/helmchart','345ae518-f857-11ed-921d-aa1950d374e1','Viola','resource','helm chart','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('76b7965e-f0d8-11ee-ac8e-c6591bb2a6db','SSE Health Check API','SSE Health Check API','/health-check','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','notification','GET',1,'dc347010-c3f4-11ee-8281-7e177595258d',1)
    ,   ('76e447d1-df67-11ee-84a7-5e1f35257281','대시보드 프로젝트별 쿼터 사용량','프로젝트별 자원 사용량 통계를 조회한다.','/','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','dashboard','project','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('76e4bc23-df67-11ee-84a7-5e1f35257281','네트워크 가용성 영역 조회 API','네트워크 가용성 영역 조회 API','/network/networks/availability-zones','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','network','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('77569034-4a68-11ef-a4c4-96fd9ef2bacb','워크스페이스에 속한 볼륨 목록 조회 API','워크스페이스에 속한 볼륨 목록 조회 API','/workspaces/aws/volumes','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','block storage','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7756eff4-4a68-11ef-a4c4-96fd9ef2bacb','워크스페이스에 속한 버킷 목록 조회 API','워크스페이스에 속한 버킷 목록 조회 API','/workspaces/aws/storages','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','object storage','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('77572ff7-4a68-11ef-a4c4-96fd9ef2bacb','워크스페이스에 속한 스토리지 정보 목록 조회 API','워크스페이스에 속한 스토리지 정보 목록 조회 API','/workspaces/aws/storages/info','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','object storage','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7757cd34-4a68-11ef-a4c4-96fd9ef2bacb','워크스페이스에 속한 서브넷 목록 조회 API','워크스페이스에 속한 서브넷 목록 조회 API','/workspaces/aws/network/subnets','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','network','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('77580030-4a68-11ef-a4c4-96fd9ef2bacb','워크스페이스에 속한 보안 그룹 목록 조회 API','워크스페이스에 속한 보안 그룹 목록 조회 API','/workspaces/aws/network/security-groups','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','network','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('77582f84-4a68-11ef-a4c4-96fd9ef2bacb','워크스페이스에 속한 라우팅 테이블 목록 조회 API','워크스페이스에 속한 라우팅 테이블 목록 조회 API','/workspaces/aws/network/route-tables','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','network','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('775877bd-4a68-11ef-a4c4-96fd9ef2bacb','워크스페이스에 속한 네트워크 인터페이스 목록 조회 API','워크스페이스에 속한 네트워크 인터페이스 목록 조회 API','/workspaces/aws/network/nics','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','network','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7758a719-4a68-11ef-a4c4-96fd9ef2bacb','워크스페이스에 속한 NAT 게이트웨이 목록 조회 API','워크스페이스에 속한 NAT 게이트웨이 목록 조회 API','/workspaces/aws/network/nat-gateways','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','network','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7758dd61-4a68-11ef-a4c4-96fd9ef2bacb','워크스페이스에 속한 인터넷 게이트웨이 목록 조회 API','워크스페이스에 속한 인터넷 게이트웨이 목록 조회 API','/workspaces/aws/network/internet-gateways','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','network','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('775916fb-4a68-11ef-a4c4-96fd9ef2bacb','워크스페이스에 속한 탄력적 IP 목록 조회 API','워크스페이스에 속한 탄력적 IP 목록 조회 API','/workspaces/aws/network/elastic-ips','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','network','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('77594f65-4a68-11ef-a4c4-96fd9ef2bacb','워크스페이스에 속한 네트워크 ACL 목록 조회 API','워크스페이스에 속한 네트워크 ACL 목록 조회 API','/workspaces/aws/network/acls','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','network','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('77abc400-e02a-11ee-84a7-5e1f35257281','Volume Metadata - update metadata for volume','Volume Metadata - update metadata for volume','/block-storage/volumes/{volumeId}/metadata','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','PUT',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7972b3ad-8f22-11ee-a47a-a6869ab29cd8','마이페이지 계정 정보 프로필 사진 조회','마이페이지 계정 정보 프로필 사진 조회','/user/account-image','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('79744130-8f22-11ee-a47a-a6869ab29cd8','워크스페이스 컨테이너 삭제','워크스페이스 컨테이너 삭제','/workspaces/containers/{podName}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','container','DELETE',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('79769f0d-8f22-11ee-a47a-a6869ab29cd8','마이페이지 관리자 계정 정보 수정(프로필 사진)','마이페이지 관리자 계정 정보 수정(프로필 사진)','/admin/account-info/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','admin','management','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('797751b2-8f22-11ee-a47a-a6869ab29cd8','서비스 신청 실행','서비스 신청 실행','/service-objects/requests/{id}/execute','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-catalog','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7979ef48-8f22-11ee-a47a-a6869ab29cd8','마이페이지 계정 정보 프로필 사진 조회','마이페이지 계정 정보 프로필 사진 조회','/admin/account-image','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','admin','management','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('79c09e65-c4b4-11ee-8281-7e177595258d','워크스페이스의 vm traffic 사용량(byte) 조회','워크스페이스의 vm traffic 사용량(byte) 조회','/workspace/{workspaceId}/dashboard/usage/traffic','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','workspace','dashboard','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('79df80c0-1833-11f0-9ec5-f2ebae5ce311','ArgoCD 애플리케이션 삭제','ArgoCD 애플리케이션 삭제','/argocd/application/{serviceName}','eeffe021-b1f6-11ee-b0d1-0242ac110002','Trombone','gitopsservice','argocd','DELETE',1,'973e6aaf-27c1-11ef-9f42-5e230e3817dd',0)
    ,   ('79e554a7-1833-11f0-9ec5-f2ebae5ce311','ArgoCD 애플리케이션 image sync','ArgoCD 애플리케이션 image sync','/argocd/application/{serviceName}/sync','eeffe021-b1f6-11ee-b0d1-0242ac110002','Trombone','gitopsservice','argocd','POST',1,'973e6aaf-27c1-11ef-9f42-5e230e3817dd',0)
    ,   ('79e61d5b-1833-11f0-9ec5-f2ebae5ce311','워크스페이스 내 ArgoCD 애플리케이션 리스트','워크스페이스 내 ArgoCD 애플리케이션 리스트','/argocd/applications/{projectName}','eeffe021-b1f6-11ee-b0d1-0242ac110002','Trombone','gitopsservice','argocd','GET',1,'973e6aaf-27c1-11ef-9f42-5e230e3817dd',0)
    ,   ('7a4ef345-1905-11f0-92a4-b2a8347e4220','서비스-프리셋 목록조회','서비스-프리셋 목록조회','/service-presets','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-preset','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7a974101-24b3-11f0-acfd-fecd16557305','워크스페이스별 결제 설정정보 수정','워크스페이스별 결제 설정정보 수정','/approval-line/workspace/{workspaceId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','approval-line','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7a9a83c6-24b3-11f0-acfd-fecd16557305','워크스페이스별 결제 설정정보 등록','워크스페이스별 결제 설정정보 등록','/approval-line/workspace/{workspaceId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','approval-line','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7aca0805-9fce-11ee-a438-3e72d96d3fbc','인스턴스 제어 - migrate server','인스턴스 제어 - migrate server','/compute/servers/{serverId}/action/migrate','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7aca6130-9fce-11ee-a438-3e72d96d3fbc','인스턴스 제어 - live migrate server','인스턴스 제어 - live migrate server','/compute/servers/{serverId}/action/live-migrate','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7b06de8f-3f61-11ef-9f42-5e230e3817dd','Top5 리소스 조회','Top5 리소스 조회','/dashboard/top5','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','dashboard','dashboard','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('7b0775db-3f61-11ef-9f42-5e230e3817dd','리소스 개수 조회','리소스 개수 조회','/dashboard/resource-count','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','dashboard','dashboard','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('7b07e8cc-3f61-11ef-9f42-5e230e3817dd','서비스별 비용 조회','서비스별 비용 조회','/dashboard/billing','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','dashboard','dashboard','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('7b0845ad-3f61-11ef-9f42-5e230e3817dd','Top5 리소스 조회','Top5 리소스 조회','/dashboard/top5','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','dashboard','dashboard','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7b089d81-3f61-11ef-9f42-5e230e3817dd','리소스 개수 조회','리소스 개수 조회','/dashboard/resource-count','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','dashboard','dashboard','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7b08f983-3f61-11ef-9f42-5e230e3817dd','서비스별 비용 조회','서비스별 비용 조회','/dashboard/billing','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','dashboard','dashboard','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7b1a6cf7-0eb2-11ef-9fbf-8ef2ee3c3984','특정 조직/폴더/워크스페이스 월별 비용 조회','특정 조직/폴더/워크스페이스 월별 비용 조회','/cost/total-analysis/organization/workspace','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','cost','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('7b1b12c3-0eb2-11ef-9fbf-8ef2ee3c3984','전체 조직/폴더/워크스페이스 월별 비용 조회','전체 조직/폴더/워크스페이스 월별 비용 조회','/cost/total-analysis/organization/workspace-all','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','finops','cost','GET',1,'60df3579-c3f1-11ee-8281-7e177595258d',0)
    ,   ('7b1b7711-0eb2-11ef-9fbf-8ef2ee3c3984','가상머신 별 이상탐지 메트릭 차트 조회','가상머신 별 이상탐지 메트릭 차트 조회','/ai/anomaly-detection/servers/chart/{vmId}/{platformType}/{metricName}/{dayCount}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','ai','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7b3f7945-6535-11ef-aa9f-f2cdef6842ce','Set count of cpu, size of memory of VM','Set count of cpu, size of memory of VM','/mole/vm-cpu-memory/set','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','host','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('7b40bb2f-6535-11ef-aa9f-f2cdef6842ce','Set count of cpu, size of memory of VM','Set count of cpu, size of memory of VM','/mole/vm-cpu-memory/set','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','agentmole','host','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7b4fde8b-e4df-11ee-84a7-5e1f35257281','','','/boards/like/{boardId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','board','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('7b50b632-e4df-11ee-84a7-5e1f35257281','커뮤니티 게시글 목록 조회','커뮤니티 게시글 목록 조회','/boards','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','board','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('7b513daf-e4df-11ee-84a7-5e1f35257281','커뮤니티 게시글 상세 조회','커뮤니티 게시글 상세 조회','/boards/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','board','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('7b5160d5-1132-11f0-8e4c-52e9553a2057','svd-서비스-카탈로그 상세조회','svd-서비스-카탈로그 상세조회','/service-desk-catalogs/{serviceCatalogId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-desk-catalog','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7b52bf47-e4df-11ee-84a7-5e1f35257281','커뮤니티 게시글 카테고리 목록 조회','커뮤니티 게시글 카테고리 목록 조회','/boards/categories','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','category','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('7b52d2d1-1132-11f0-8e4c-52e9553a2057','svd-서비스-카탈로그 수정','svd-서비스-카탈로그 수정','/service-desk-catalogs/{serviceCatalogId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-desk-catalog','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7b531cc8-1132-11f0-8e4c-52e9553a2057','IP Pool Physical 생성','IP Pool Physical 생성','/ip-pool-physical','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','ip pool physical','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7b53373d-e4df-11ee-84a7-5e1f35257281','커뮤니티 게시글 카테고리 상세 조회','커뮤니티 게시글 카테고리 상세 조회','/boards/categories/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','category','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('7b53d3d8-e4df-11ee-84a7-5e1f35257281','커뮤니티 게시글 카테고리명 중복 체크','커뮤니티 게시글 카테고리명 중복 체크','/boards/categories/validate','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','category','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('7b5452e1-e4df-11ee-84a7-5e1f35257281','커뮤니티 게시글 서브카테고리 목록 조회','커뮤니티 게시글 서브카테고리 목록 조회','/boards/categories/sub','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','sub category','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('7b549011-e4df-11ee-84a7-5e1f35257281','커뮤니티 게시글 서브카테고리 상세 조회','커뮤니티 게시글 서브카테고리 상세 조회','/boards/categories/sub/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','sub category','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('7b54c9f2-e4df-11ee-84a7-5e1f35257281','커뮤니티 게시글 서브카테고리명 중복체크','커뮤니티 게시글 서브카테고리명 중복체크','/boards/categories/sub/validate','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','sub category','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('7b782074-5499-11ef-97d4-9676f6708993','타겟 등록 해제','타겟 등록 해제','/target-groups/deregister-targets','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','targetgroups','targetgroups','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7b78d983-5499-11ef-97d4-9676f6708993','리스너 목록 조회','리스너 목록 조회','/load-balancers/listeners','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancers listeners','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7b792820-5499-11ef-97d4-9676f6708993','리스너 수정','리스너 수정','/load-balancers/listeners','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancers listeners','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7b796b0d-5499-11ef-97d4-9676f6708993','리스너 생성','리스너 생성','/load-balancers/listeners','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancers listeners','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7b79b252-5499-11ef-97d4-9676f6708993','모든 메트릭 조회','모든 메트릭 조회','/target-groups/monitor','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','targetgroups','monitor','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7b79e749-5499-11ef-97d4-9676f6708993','대상 그룹 중복 조회','대상 그룹 중복 조회','/target-groups/duplicate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','targetgroups','targetgroups','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7b7a2170-5499-11ef-97d4-9676f6708993','리스너 필터 목록 조회','리스너 필터 목록 조회','/load-balancers/listeners/filter','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancers listeners','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7b7a57a0-5499-11ef-97d4-9676f6708993','리스너 삭제','리스너 삭제','/load-balancers/listeners/{listenerArn}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancers listeners','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7b7a902f-5499-11ef-97d4-9676f6708993','타겟 등록 해제','타겟 등록 해제','/target-groups/deregister-targets','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','targetgroups','targetgroups','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('7b7accba-5499-11ef-97d4-9676f6708993','리스너 목록 조회','리스너 목록 조회','/load-balancers/listeners','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancers listeners','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('7b7b0981-5499-11ef-97d4-9676f6708993','리스너 수정','리스너 수정','/load-balancers/listeners','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancers listeners','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('7b7b3e4d-5499-11ef-97d4-9676f6708993','리스너 생성','리스너 생성','/load-balancers/listeners','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancers listeners','POST',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('7b7b74ac-5499-11ef-97d4-9676f6708993','모든 메트릭 조회','모든 메트릭 조회','/target-groups/monitor','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','targetgroups','monitor','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('7b7ba9b7-5499-11ef-97d4-9676f6708993','대상 그룹 중복 조회','대상 그룹 중복 조회','/target-groups/duplicate','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','targetgroups','targetgroups','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('7b7bdede-5499-11ef-97d4-9676f6708993','리스너 필터 목록 조회','리스너 필터 목록 조회','/load-balancers/listeners/filter','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancers listeners','GET',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('7b7c1ab6-5499-11ef-97d4-9676f6708993','리스너 삭제','리스너 삭제','/load-balancers/listeners/{listenerArn}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','compute','load balancers listeners','DELETE',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('7b85ab38-ea89-11ee-ac8e-c6591bb2a6db','사용자 조직 매핑 상태 조회','사용자 조직 매핑 상태 조회','/user/org-mapping-status','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('7b863b1f-ea89-11ee-ac8e-c6591bb2a6db','사용자 조직 매핑 상태 변경','사용자 조직 매핑 상태 변경','/user/org-mapping-status','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','PUT',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('7b868e77-ea89-11ee-ac8e-c6591bb2a6db','사용자 조직 매핑 상태 생성','사용자 조직 매핑 상태 생성','/user/org-mapping-status','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','POST',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('7b86d61c-ea89-11ee-ac8e-c6591bb2a6db','사용자 조직 매핑 상태 삭제','사용자 조직 매핑 상태 삭제','/user/org-mapping-status','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','DELETE',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('7b871f73-ea89-11ee-ac8e-c6591bb2a6db','워크스페이스 공유 파일 목록 조회 API','워크스페이스에 속한 공유 파일 목록 조회','/workspaces/shared-files','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','block storage','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7b875b8f-ea89-11ee-ac8e-c6591bb2a6db','사용자 조직 매핑 상태 조회','사용자 조직 매핑 상태 조회','/user/org-mapping-status/{orgId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('7b87dfc3-ea89-11ee-ac8e-c6591bb2a6db','모든 조직만 조회','모든 조직만 조회','/org/org-only','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','org-resource','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7ba9959a-d7d2-11ef-9c74-0a11b82fa8dd','오토스케일링 정책 설정 요청 제어','오토스케일링 정책 설정 요청 제어','/autoscaling/provisioning/groups/policies','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7bac48b6-d7d2-11ef-9c74-0a11b82fa8dd','admin : GET/autoscaling/groups/{autoScalingGroupName}/policies','admin : GET/autoscaling/groups/{autoScalingGroupName}/policies','/autoscaling/groups/{autoScalingGroupName}/policies','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7bacaa28-d7d2-11ef-9c74-0a11b82fa8dd','오토스케일링 정책 삭제','오토스케일링 정책 삭제','/autoscaling/provisioning/groups/{autoScalingGroupName}/policies/{policyName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','autoscaling','groups','DELETE',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('7d081b39-86b0-11ef-9a6b-ba8787afde77','대시보드용 조직 목록 조회 api','대시보드용 조직 목록 조회 api','/dashboard/org','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','dashboard','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',1)
    ,   ('7d2e130c-b04f-11ee-94e4-eea823231fc8','Volume Migration - Migrate volumes between ends which support its volumes-type','Volume Migration - Migrate volumes between ends which support its volumes-type','/block-storage/volumes/migration/{volumeId}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7d2e5bdb-b04f-11ee-94e4-eea823231fc8','볼륨 목록 host 정보 조회','볼륨 목록 host 정보 조회','/block-storage/volumes/distinct-host','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','cinder','volume','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7e23327f-82f9-11ee-a4fd-dadafdb14cb0','관리자 수정','관리자 수정','/admin/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','admin','management','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7e24e74e-82f9-11ee-a4fd-dadafdb14cb0','관리자 삭제','관리자 삭제','/admin/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','admin','management','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7e25f52f-82f9-11ee-a4fd-dadafdb14cb0','관리자 비밀번호 초기화','관리자 비밀번호 초기화','/admin/{id}/reset-password','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','admin','management','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7e26eb24-82f9-11ee-a4fd-dadafdb14cb0','그룹 상세 조회','그룹 상세 조회','/admin/group/{groupId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','admin','group','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7e27f3be-82f9-11ee-a4fd-dadafdb14cb0','사용자 그룹 수정','사용자 그룹 수정','/admin/group/{groupId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','admin','group','PUT',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7e290240-82f9-11ee-a4fd-dadafdb14cb0','사용자 그룹 삭제','사용자 그룹 삭제','/admin/group/{groupId}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','admin','group','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7e2a20b5-82f9-11ee-a4fd-dadafdb14cb0','관리자 생성','관리자 생성','/admin','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','admin','management','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7e2b0988-82f9-11ee-a4fd-dadafdb14cb0','그룹 목록 조회','그룹 목록 조회','/admin/group','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','admin','group','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7e2bdc56-82f9-11ee-a4fd-dadafdb14cb0','사용자 그룹 생성','사용자 그룹 생성','/admin/group','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','admin','group','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7e2cd30e-82f9-11ee-a4fd-dadafdb14cb0','관리자 / 관리자 그룹 접근제어 설정','관리자 / 관리자 그룹 접근제어 설정','/admin/access-control','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','admin','access-control','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7e2e1a65-82f9-11ee-a4fd-dadafdb14cb0','관리자 / 관리자 그룹 접근제어 삭제','관리자 / 관리자 그룹 접근제어 삭제','/admin/access-control','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','admin','access-control','DELETE',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('7e2f02fd-82f9-11ee-a4fd-dadafdb14cb0','그룹 생성시 메일 중복 확인','그룹 생성시 메일 중복 확인','/admin/group/check-group-email','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','admin','group','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7ee634c6-1999-11ef-bc41-1ecbd3ef6ccd','PointSolution List','PointSolution List','/point/solution/cmp/boards','910fa43a-7797-11ee-b465-565158862942','Vista','observability','pointsolution','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('7ee67eae-1999-11ef-bc41-1ecbd3ef6ccd','Batch Log','Batch Log','/point/solution/batch','910fa43a-7797-11ee-b465-565158862942','Vista','observability','pointsolution','GET',1,'6f32e0d9-e4e4-11ee-84a7-5e1f35257281',0)
    ,   ('7f4ceb89-15cc-11f0-8e4c-52e9553a2057','모니터링 Notification 전송 요청 API','모니터링 Notification 전송 요청 API','/message/monitoring/group','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','notification','POST',1,'dc347010-c3f4-11ee-8281-7e177595258d',0)
    ,   ('7f567a2b-fba7-11ee-b354-0eff8aa9f4e3','일대일 문의 목록 조회','일대일 문의 목록 조회','/boards/requests','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','request board','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7f570807-fba7-11ee-b354-0eff8aa9f4e3','일대일 문의 상세 조회','일대일 문의 상세 조회','/boards/requests/{id}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','board','request board','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7f9d8b33-d30e-11ef-9c74-0a11b82fa8dd','작업이력 detailLog 조회','작업이력 detailLog 조회','/log/action/detail/{uuid}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','x-openstack-request-id','actionlog','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7fa247e0-d30e-11ef-9c74-0a11b82fa8dd','인스턴스 마이그레이션 내역 조회 API','인스턴스 마이그레이션 내역 조회 API','/compute/servers/os-migrations','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('7fa3f183-d30e-11ef-9c74-0a11b82fa8dd','작업이력 detailLog 조회','작업이력 detailLog 조회','/log/action/detail/{uuid}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','x-openstack-request-id','actionlog','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('7fa42790-d30e-11ef-9c74-0a11b82fa8dd','인스턴스 마이그레이션 내역 조회 API','인스턴스 마이그레이션 내역 조회 API','/compute/servers/os-migrations','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('8008d1a3-593c-11ef-a2be-3259e69cb451','태그 수정','태그 수정','/tags/update','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','tags','tag','PUT',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('800a6e34-593c-11ef-a2be-3259e69cb451','태그 수정','태그 수정','/tags/update','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','tags','tag','PUT',1,'459c02c1-1678-11ef-922c-16fe18334070',0)
    ,   ('8010ad9d-44da-11ef-a4c4-96fd9ef2bacb','사용자 포탈 - 스테이트풀셋 리스트','사용자 포탈 - 스테이트풀셋 리스트','/v1/statefulsets','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('8010ff48-44da-11ef-a4c4-96fd9ef2bacb','사용자 포탈 - 레플리카셋 리스트','사용자 포탈 - 레플리카셋 리스트','/v1/replicasets','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('80113dec-44da-11ef-a4c4-96fd9ef2bacb','관리자 포탈 - 네임스페이스 하위 자원 존재 유무','관리자 포탈 - 네임스페이스 하위 자원 존재 유무','/v1/namespaces/{namespaceName}/resourcecheck','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','namespace','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('80117343-44da-11ef-a4c4-96fd9ef2bacb','클러스터 리스트 동기화','클러스터 리스트 동기화','/v1/k8s/management/clusters/sync','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('8011aadc-44da-11ef-a4c4-96fd9ef2bacb','사용자 포탈 - 작업 리스트','사용자 포탈 - 작업 리스트','/v1/jobs','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('8011dd30-44da-11ef-a4c4-96fd9ef2bacb','사용자 포탈 - HorizontalPodAutoscaler 리스트','사용자 포탈 - HorizontalPodAutoscaler 리스트','/v1/horizontalpodautoscalers','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('80120ed6-44da-11ef-a4c4-96fd9ef2bacb','사용자 포탈 - 데몬셋 리스트','사용자 포탈 - 데몬셋 리스트','/v1/daemonsets','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('80124930-44da-11ef-a4c4-96fd9ef2bacb','사용자 포탈 - Cron작업 리스트','사용자 포탈 - Cron작업 리스트','/v1/cronjobs','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('8012800a-44da-11ef-a4c4-96fd9ef2bacb','사용자 포탈 - 스테이트풀셋 리스트','사용자 포탈 - 스테이트풀셋 리스트','/v1/statefulsets','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('8012b7cd-44da-11ef-a4c4-96fd9ef2bacb','사용자 포탈 - 레플리카셋 리스트','사용자 포탈 - 레플리카셋 리스트','/v1/replicasets','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('8012ebbe-44da-11ef-a4c4-96fd9ef2bacb','관리자 포탈 - 네임스페이스 하위 자원 존재 유무','관리자 포탈 - 네임스페이스 하위 자원 존재 유무','/v1/namespaces/{namespaceName}/resourcecheck','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','namespace','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('80131c8a-44da-11ef-a4c4-96fd9ef2bacb','클러스터 리스트 동기화','클러스터 리스트 동기화','/v1/k8s/management/clusters/sync','345ae518-f857-11ed-921d-aa1950d374e1','Viola','management','cluster','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('80134fb5-44da-11ef-a4c4-96fd9ef2bacb','사용자 포탈 - 작업 리스트','사용자 포탈 - 작업 리스트','/v1/jobs','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('80137ed4-44da-11ef-a4c4-96fd9ef2bacb','사용자 포탈 - HorizontalPodAutoscaler 리스트','사용자 포탈 - HorizontalPodAutoscaler 리스트','/v1/horizontalpodautoscalers','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('8013af32-44da-11ef-a4c4-96fd9ef2bacb','사용자 포탈 - 데몬셋 리스트','사용자 포탈 - 데몬셋 리스트','/v1/daemonsets','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('8013e196-44da-11ef-a4c4-96fd9ef2bacb','사용자 포탈 - Cron작업 리스트','사용자 포탈 - Cron작업 리스트','/v1/cronjobs','345ae518-f857-11ed-921d-aa1950d374e1','Viola','user','workload','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('802aba96-231d-11ef-922c-16fe18334070','인스턴스 마이그레이션 - evacuate action server','인스턴스 마이그레이션 - evacuate action server','/compute/servers/{serverId}/action/evacuate','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','POST',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('802b0c64-231d-11ef-922c-16fe18334070','mock up data make API','mock up data make API','/monitor/{JsonfileName}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','monitor','monitor','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('802b4ed7-231d-11ef-922c-16fe18334070','인스턴스 마이그레이션 - evacuate action server','인스턴스 마이그레이션 - evacuate action server','/compute/servers/{serverId}/action/evacuate','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','nova','compute','POST',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('802b9311-231d-11ef-922c-16fe18334070','mock up data make API','mock up data make API','/monitor/{JsonfileName}','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','monitor','monitor','GET',1,'1f04a05e-1678-11ef-922c-16fe18334070',0)
    ,   ('8035b3fe-4a2b-11ef-a4c4-96fd9ef2bacb','워크스페이스에 속한 VPC 목록 조회 API','워크스페이스에 속한 VPC 목록 조회 API','/workspaces/aws/network/vpcs','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','resource','network','GET',1,'c92260ef-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('804797fb-1357-11f0-8e4c-52e9553a2057','IP Pool 생성','IP Pool 생성','/ip-pool','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','ip-pool','POST',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('8048ef40-1357-11f0-8e4c-52e9553a2057','svd-서비스-카탈로그 이름 중복조회','svd-서비스-카탈로그 이름 중복조회','/service-desk-catalogs/name/{name}','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','service-desk-catalog','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('8049fc12-1357-11f0-8e4c-52e9553a2057','IP Pool name 중복체크','IP Pool name 중복체크','/ip-pool/exists','f218ba35-f870-11ed-921d-aa1950d374e1','CMP','management','ip-pool','GET',1,'bb252b0f-82bf-11ee-a4fd-dadafdb14cb0',0)
    ,   ('80799f89-0906-11ef-aff6-82df576c693d','서브넷 중복조회','서브넷 중복조회','/network/subnets/validate/{subnetName}','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','subnet','GET',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('8105ebd7-4827-11ef-a4c4-96fd9ef2bacb','StorageClass 상세 조회','StorageClass 상세 조회','/v1/k8s/volume/storage-class/{storageClassName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','storageclass','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('810654ba-4827-11ef-a4c4-96fd9ef2bacb','StorageClass 수정','StorageClass 수정','/v1/k8s/volume/storage-class/{storageClassName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','storageclass','PUT',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('8106a53f-4827-11ef-a4c4-96fd9ef2bacb','StorageClass 삭제','StorageClass 삭제','/v1/k8s/volume/storage-class/{storageClassName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','storageclass','DELETE',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
;
INSERT INTO maestro.MSTR_ENDPOINT (id,name,description,uri,solution_id,solution,service,`type`,`method`,status,solution_server_id,white_api)  
VALUES  ('8106f3cf-4827-11ef-a4c4-96fd9ef2bacb','StorageClass 리스트 조회','StorageClass 리스트 조회','/v1/k8s/volume/storage-class','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','storageclass','GET',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('81074b81-4827-11ef-a4c4-96fd9ef2bacb','StorageClass 생성','StorageClass 생성','/v1/k8s/volume/storage-class','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','storageclass','POST',1,'cebcf6d9-b9a9-11ee-afaf-76fb71c4f9db',0)
    ,   ('8107b249-4827-11ef-a4c4-96fd9ef2bacb','StorageClass 상세 조회','StorageClass 상세 조회','/v1/k8s/volume/storage-class/{storageClassName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','storageclass','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('8107fb37-4827-11ef-a4c4-96fd9ef2bacb','StorageClass 수정','StorageClass 수정','/v1/k8s/volume/storage-class/{storageClassName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','storageclass','PUT',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('81083eb3-4827-11ef-a4c4-96fd9ef2bacb','StorageClass 삭제','StorageClass 삭제','/v1/k8s/volume/storage-class/{storageClassName}','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','storageclass','DELETE',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('8108827e-4827-11ef-a4c4-96fd9ef2bacb','StorageClass 리스트 조회','StorageClass 리스트 조회','/v1/k8s/volume/storage-class','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','storageclass','GET',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('8108cf95-4827-11ef-a4c4-96fd9ef2bacb','StorageClass 생성','StorageClass 생성','/v1/k8s/volume/storage-class','345ae518-f857-11ed-921d-aa1950d374e1','Viola','volume','storageclass','POST',1,'1f07a4ea-1678-11ef-922c-16fe18334070',0)
    ,   ('814cb179-0c10-11ef-9fbf-8ef2ee3c3984','연결된 포트 목록 조회 API','연결된 포트 목록 조회 API','/network/connected-ports','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','neutron','port','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('814d2910-0c10-11ef-9fbf-8ef2ee3c3984','LoadBalancer 목록 조회','LoadBalancer 목록 조회','/load-balancer/connected-loadbalancer','345864a3-f857-11ed-921d-aa1950d374e1','Contrabass','octavia','loadbalancer','GET',1,'0fb5e5e0-874b-11ee-a4fd-dadafdb14cb0',0)
    ,   ('81b0ead5-f0be-11ee-ac8e-c6591bb2a6db','admin : POST/network/route/tables',NULL,'/network/route/tables','3459e40c-f857-11ed-921d-aa1950d374e1','AWS','network','route','POST',1,'def60149-8e8a-11ee-a47a-a6869ab29cd8',0)
    ,   ('81b18a21-f0be-11ee-ac8e-c6591bb2a6db','snapshots 생성','snapshots 생성','/compute/snapsh