CREATE DATABASE IF NOT EXISTS `contrabass` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci */;

USE contrabass;

-- contrabass.cb_provider definition

-- contrabass.cb_provider definition

CREATE TABLE IF NOT EXISTS `cb_provider` (
  `uuid` varchar(55) NOT NULL COMMENT '공급자 uuid',
  `platform_type` varchar(20) DEFAULT 'OPENSTACK' COMMENT '플랫폼 타입',
  `provider_type` varchar(20) DEFAULT 'CONTRABASS' COMMENT '공급자 타입',
  `name` varchar(100) DEFAULT NULL COMMENT '공급자 이름',
  `server_location` varchar(100) DEFAULT NULL COMMENT '위치 정보',
  `description` varchar(100) DEFAULT NULL COMMENT '설명',
  `url` varchar(50) DEFAULT NULL COMMENT 'keystone url',
  `nova_id` varchar(32) DEFAULT NULL COMMENT 'openstack nova ID',
  `attributes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'json data' CHECK (json_valid(`attributes`)),
  `created_at` timestamp NULL DEFAULT current_timestamp() COMMENT '생성 일시',
  `created_by` varchar(100) NOT NULL COMMENT '등록자 ID',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT '수정 일시',
  `updated_by` varchar(100) DEFAULT NULL COMMENT '수정자 ID',
  `owner_id` varchar(128) DEFAULT NULL COMMENT 's3 저장소 식별정보(최초 버킷 생성 ID)',
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='공급자';

-- contrabass.cb_backup_resource_history definition

CREATE TABLE IF NOT EXISTS `cb_backup_resource_history` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '백업 이력 고유 ID',
  `job_id` bigint(20) DEFAULT NULL COMMENT '연관된 백업 작업 상태 ID',
  `resource_id` varchar(255) NOT NULL COMMENT '대상 리소스 ID (예: volume_id, instance_id)',
  `schedule_id` bigint(20) DEFAULT NULL COMMENT '연관된 백업 스케줄 ID',
  `backup_id` varchar(255) DEFAULT NULL COMMENT '백업 완료 후 생성된 식별자 (예: snapshot_id)',
  `provider_id` varchar(255) DEFAULT NULL COMMENT '서비스 공급자 ID',
  `resource_type` varchar(50) NOT NULL COMMENT '대상 리소스 유형 (예: volume, instance)',
  `backup_status` varchar(50) NOT NULL COMMENT '백업 상태 (예: SUCCESS, FAILED, IN_PROGRESS)',
  `error_message` text DEFAULT NULL COMMENT '백업 실패 시 오류 메시지',
  `scheduled_backup_time` timestamp NULL DEFAULT NULL COMMENT '예정된 백업 실행 시간',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() COMMENT '레코드 생성 일시',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() COMMENT '레코드 수정 일시',
  PRIMARY KEY (`id`),
  KEY `idx_backup_type_entity` (`resource_type`,`resource_id`),
  KEY `idx_job_id` (`job_id`),
  KEY `idx_schedule` (`schedule_id`),
  KEY `idx_provider` (`provider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='백업 실행 이력 테이블';


-- contrabass.cb_backup_resource_job_status definition

CREATE TABLE IF NOT EXISTS `cb_backup_resource_job_status` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '백업 작업 상태 ID',
  `schedule_id` bigint(20) DEFAULT NULL COMMENT '연관된 백업 스케줄 ID',
  `resource_id` varchar(255) NOT NULL COMMENT '대상 리소스 ID (예: volume_id, instance_id)',
  `resource_type` varchar(50) NOT NULL COMMENT '대상 리소스 유형 (예: volume, instance)',
  `provider_id` varchar(255) NOT NULL COMMENT '서비스 공급자 ID',
  `first_backup_time` timestamp NOT NULL COMMENT '최초 백업 수행 시각',
  `last_backup_time` timestamp NOT NULL COMMENT '마지막 백업 수행 시각',
  `backup_count` bigint(11) DEFAULT 0 COMMENT '실행된 백업 횟수',
  `backup_status` varchar(50) NOT NULL COMMENT '백업 상태 (예: SUCCESS, FAILED, IN_PROGRESS)',
  `error_message` text DEFAULT NULL COMMENT '백업 실패 시 오류 메시지',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() COMMENT '레코드 생성 일시',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() COMMENT '레코드 수정 일시',
  PRIMARY KEY (`id`),
  KEY `idx_schedule` (`schedule_id`),
  KEY `idx_backup_type_entity` (`resource_type`,`resource_id`),
  KEY `idx_provider` (`provider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='백업 작업 상태 테이블';


-- contrabass.cb_backup_resource_schedule definition

CREATE TABLE IF NOT EXISTS `cb_backup_resource_schedule` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '백업 스케줄 고유 ID',
  `name` varchar(255) DEFAULT NULL COMMENT '스케줄 이름',
  `resource_id` varchar(255) NOT NULL COMMENT '대상 리소스 ID (예: volume_id, instance_id)',
  `resource_type` varchar(50) NOT NULL COMMENT '대상 리소스 유형 (예: volume, instance)',
  `provider_id` varchar(255) NOT NULL COMMENT '서비스 공급자 ID',
  `project_id` varchar(255) NOT NULL COMMENT '프로젝트 ID',
  `schedule_cron` varchar(255) DEFAULT NULL COMMENT '백업 주기를 설정하는 크론 표현식',
  `backup_count` int(11) DEFAULT NULL COMMENT '백업 횟수',
  `enabled` tinyint(1) NOT NULL DEFAULT 1 COMMENT '스케줄 활성화 여부 (1: 활성, 0: 비활성)',
  `description` text DEFAULT NULL COMMENT '스케줄에 대한 설명',
  `additional_info` text DEFAULT NULL COMMENT '추가 리소스 정보 (볼륨 백업 시 해당 정보를 활용)',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() COMMENT '레코드 생성 일시',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() COMMENT '레코드 수정 일시',
  PRIMARY KEY (`id`),
  KEY `idx_backup_type_entity` (`resource_type`,`resource_id`),
  KEY `idx_provider` (`provider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='백업 스케줄 테이블';

CREATE TABLE IF NOT EXISTS `cb_backup_node_info`
(
    `id`          bigint(20)   NOT NULL AUTO_INCREMENT,
    `backup_type` varchar(255) NOT NULL,
    `node_ip`     varchar(255) NOT NULL,
    `deleted`     tinyint(1)            DEFAULT 0,
    `created_at`  timestamp    NOT NULL DEFAULT current_timestamp(),
    `updated_at`  timestamp    NOT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  AUTO_INCREMENT = 4
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


-- contrabass.cb_backup_schedule definition

CREATE TABLE IF NOT EXISTS `cb_backup_schedule`
(
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `description` text DEFAULT NULL,
  `schedule_cron` varchar(255) DEFAULT NULL,
  `backup_retention_days` int(11) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `provider_id` varchar(255) DEFAULT NULL,
  `backup_type` varchar(255) NOT NULL,
  `backup_mode` varchar(255) NOT NULL,
  `backup_storage_type` varchar(50) DEFAULT NULL,
  `backup_location` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- contrabass.cb_backup_job_history definition

CREATE TABLE IF NOT EXISTS `cb_backup_job_history`
(
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `job_id` bigint(20) DEFAULT NULL,
  `schedule_id` bigint(20) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `backup_type` varchar(255) DEFAULT NULL,
  `backup_status` varchar(50) NOT NULL,
  `error_message` text DEFAULT NULL,
  `node_ip` varchar(255) DEFAULT NULL,
  `backup_storage_type` varchar(50) DEFAULT NULL,
  `backup_location` varchar(255) DEFAULT NULL,
  `s3_addr` varchar(255) DEFAULT NULL,
  `scheduled_backup_time` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL,
  PRIMARY KEY (`id`),
  KEY `schedule_id` (`schedule_id`),
  CONSTRAINT `cb_backup_job_history_ibfk_1` FOREIGN KEY (`schedule_id`) REFERENCES `cb_backup_schedule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- contrabass.cb_backup_job_status definition

CREATE TABLE IF NOT EXISTS `cb_backup_job_status`
(
    `id`                 bigint(20)   NOT NULL AUTO_INCREMENT,
    `backup_schedule_id` bigint(20)            DEFAULT NULL,
    `provider_id`        varchar(255) NOT NULL,
    `backup_type`        varchar(255) NOT NULL,
    `first_backup_time`  timestamp    NOT NULL,
    `last_backup_time`   timestamp    NOT NULL,
    `backup_status`      varchar(50)  NOT NULL,
    `error_message`      text                  DEFAULT NULL,
    `created_at`         timestamp    NOT NULL DEFAULT current_timestamp(),
    `updated_at`         timestamp    NOT NULL,
    PRIMARY KEY (`id`),
    KEY `backup_schedule_id` (`backup_schedule_id`),
    CONSTRAINT `cb_backup_job_status_ibfk_1` FOREIGN KEY (`backup_schedule_id`) REFERENCES `cb_backup_schedule` (`id`) ON DELETE CASCADE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


-- contrabass.cb_backup_node_info_schedule definition

CREATE TABLE IF NOT EXISTS `cb_backup_node_info_schedule`
(
    `backup_node_info_id` bigint(20)            DEFAULT NULL,
    `backup_schedule_id`  bigint(20)            DEFAULT NULL,
    `backup_type`         varchar(255) NOT NULL,
    `created_at`          timestamp    NOT NULL DEFAULT current_timestamp(),
    KEY `backup_schedule_id` (`backup_schedule_id`),
    KEY `backup_node_info_id` (`backup_node_info_id`),
    CONSTRAINT `cb_backup_node_info_schedule_ibfk_1` FOREIGN KEY (`backup_schedule_id`) REFERENCES `cb_backup_schedule` (`id`) ON DELETE CASCADE,
    CONSTRAINT `cb_backup_node_info_schedule_ibfk_2` FOREIGN KEY (`backup_node_info_id`) REFERENCES `cb_backup_node_info` (`id`) ON DELETE CASCADE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;

-- contrabass.QRTZ_CALENDARS definition

CREATE TABLE IF NOT EXISTS `QRTZ_CALENDARS` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `CALENDAR_NAME` varchar(190) NOT NULL,
  `CALENDAR` blob NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`CALENDAR_NAME`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- contrabass.QRTZ_FIRED_TRIGGERS definition

CREATE TABLE IF NOT EXISTS `QRTZ_FIRED_TRIGGERS` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `ENTRY_ID` varchar(95) NOT NULL,
  `TRIGGER_NAME` varchar(190) NOT NULL,
  `TRIGGER_GROUP` varchar(190) NOT NULL,
  `INSTANCE_NAME` varchar(190) NOT NULL,
  `FIRED_TIME` bigint(13) NOT NULL,
  `SCHED_TIME` bigint(13) NOT NULL,
  `PRIORITY` int(11) NOT NULL,
  `STATE` varchar(16) NOT NULL,
  `JOB_NAME` varchar(190) DEFAULT NULL,
  `JOB_GROUP` varchar(190) DEFAULT NULL,
  `IS_NONCONCURRENT` varchar(1) DEFAULT NULL,
  `REQUESTS_RECOVERY` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`,`ENTRY_ID`),
  KEY `IDX_QRTZ_FT_TRIG_INST_NAME` (`SCHED_NAME`,`INSTANCE_NAME`),
  KEY `IDX_QRTZ_FT_INST_JOB_REQ_RCVRY` (`SCHED_NAME`,`INSTANCE_NAME`,`REQUESTS_RECOVERY`),
  KEY `IDX_QRTZ_FT_J_G` (`SCHED_NAME`,`JOB_NAME`,`JOB_GROUP`),
  KEY `IDX_QRTZ_FT_JG` (`SCHED_NAME`,`JOB_GROUP`),
  KEY `IDX_QRTZ_FT_T_G` (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`),
  KEY `IDX_QRTZ_FT_TG` (`SCHED_NAME`,`TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- contrabass.QRTZ_JOB_DETAILS definition

CREATE TABLE IF NOT EXISTS `QRTZ_JOB_DETAILS` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `JOB_NAME` varchar(190) NOT NULL,
  `JOB_GROUP` varchar(190) NOT NULL,
  `DESCRIPTION` varchar(250) DEFAULT NULL,
  `JOB_CLASS_NAME` varchar(250) NOT NULL,
  `IS_DURABLE` varchar(1) NOT NULL,
  `IS_NONCONCURRENT` varchar(1) NOT NULL,
  `IS_UPDATE_DATA` varchar(1) NOT NULL,
  `REQUESTS_RECOVERY` varchar(1) NOT NULL,
  `JOB_DATA` blob DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`,`JOB_NAME`,`JOB_GROUP`),
  KEY `IDX_QRTZ_J_REQ_RECOVERY` (`SCHED_NAME`,`REQUESTS_RECOVERY`),
  KEY `IDX_QRTZ_J_GRP` (`SCHED_NAME`,`JOB_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- contrabass.QRTZ_LOCKS definition

CREATE TABLE IF NOT EXISTS `QRTZ_LOCKS` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `LOCK_NAME` varchar(40) NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`LOCK_NAME`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- contrabass.QRTZ_PAUSED_TRIGGER_GRPS definition

CREATE TABLE IF NOT EXISTS `QRTZ_PAUSED_TRIGGER_GRPS` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `TRIGGER_GROUP` varchar(190) NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- contrabass.QRTZ_SCHEDULER_STATE definition

CREATE TABLE IF NOT EXISTS `QRTZ_SCHEDULER_STATE` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `INSTANCE_NAME` varchar(190) NOT NULL,
  `LAST_CHECKIN_TIME` bigint(13) NOT NULL,
  `CHECKIN_INTERVAL` bigint(13) NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`INSTANCE_NAME`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- contrabass.QRTZ_TRIGGERS definition

CREATE TABLE IF NOT EXISTS `QRTZ_TRIGGERS` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `TRIGGER_NAME` varchar(190) NOT NULL,
  `TRIGGER_GROUP` varchar(190) NOT NULL,
  `JOB_NAME` varchar(190) NOT NULL,
  `JOB_GROUP` varchar(190) NOT NULL,
  `DESCRIPTION` varchar(250) DEFAULT NULL,
  `NEXT_FIRE_TIME` bigint(13) DEFAULT NULL,
  `PREV_FIRE_TIME` bigint(13) DEFAULT NULL,
  `PRIORITY` int(11) DEFAULT NULL,
  `TRIGGER_STATE` varchar(16) NOT NULL,
  `TRIGGER_TYPE` varchar(8) NOT NULL,
  `START_TIME` bigint(13) NOT NULL,
  `END_TIME` bigint(13) DEFAULT NULL,
  `CALENDAR_NAME` varchar(190) DEFAULT NULL,
  `MISFIRE_INSTR` smallint(2) DEFAULT NULL,
  `JOB_DATA` blob DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`),
  KEY `IDX_QRTZ_T_J` (`SCHED_NAME`,`JOB_NAME`,`JOB_GROUP`),
  KEY `IDX_QRTZ_T_JG` (`SCHED_NAME`,`JOB_GROUP`),
  KEY `IDX_QRTZ_T_C` (`SCHED_NAME`,`CALENDAR_NAME`),
  KEY `IDX_QRTZ_T_G` (`SCHED_NAME`,`TRIGGER_GROUP`),
  KEY `IDX_QRTZ_T_STATE` (`SCHED_NAME`,`TRIGGER_STATE`),
  KEY `IDX_QRTZ_T_N_STATE` (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`,`TRIGGER_STATE`),
  KEY `IDX_QRTZ_T_N_G_STATE` (`SCHED_NAME`,`TRIGGER_GROUP`,`TRIGGER_STATE`),
  KEY `IDX_QRTZ_T_NEXT_FIRE_TIME` (`SCHED_NAME`,`NEXT_FIRE_TIME`),
  KEY `IDX_QRTZ_T_NFT_ST` (`SCHED_NAME`,`TRIGGER_STATE`,`NEXT_FIRE_TIME`),
  KEY `IDX_QRTZ_T_NFT_MISFIRE` (`SCHED_NAME`,`MISFIRE_INSTR`,`NEXT_FIRE_TIME`),
  KEY `IDX_QRTZ_T_NFT_ST_MISFIRE` (`SCHED_NAME`,`MISFIRE_INSTR`,`NEXT_FIRE_TIME`,`TRIGGER_STATE`),
  KEY `IDX_QRTZ_T_NFT_ST_MISFIRE_GRP` (`SCHED_NAME`,`MISFIRE_INSTR`,`NEXT_FIRE_TIME`,`TRIGGER_GROUP`,`TRIGGER_STATE`),
  CONSTRAINT `QRTZ_TRIGGERS_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `JOB_NAME`, `JOB_GROUP`) REFERENCES `QRTZ_JOB_DETAILS` (`SCHED_NAME`, `JOB_NAME`, `JOB_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- contrabass.QRTZ_BLOB_TRIGGERS definition

CREATE TABLE IF NOT EXISTS `QRTZ_BLOB_TRIGGERS` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `TRIGGER_NAME` varchar(190) NOT NULL,
  `TRIGGER_GROUP` varchar(190) NOT NULL,
  `BLOB_DATA` blob DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`),
  KEY `SCHED_NAME` (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`),
  CONSTRAINT `QRTZ_BLOB_TRIGGERS_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `QRTZ_TRIGGERS` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- contrabass.QRTZ_CRON_TRIGGERS definition

CREATE TABLE IF NOT EXISTS `QRTZ_CRON_TRIGGERS` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `TRIGGER_NAME` varchar(190) NOT NULL,
  `TRIGGER_GROUP` varchar(190) NOT NULL,
  `CRON_EXPRESSION` varchar(120) NOT NULL,
  `TIME_ZONE_ID` varchar(80) DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`),
  CONSTRAINT `QRTZ_CRON_TRIGGERS_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `QRTZ_TRIGGERS` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- contrabass.QRTZ_SIMPLE_TRIGGERS definition

CREATE TABLE IF NOT EXISTS `QRTZ_SIMPLE_TRIGGERS` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `TRIGGER_NAME` varchar(190) NOT NULL,
  `TRIGGER_GROUP` varchar(190) NOT NULL,
  `REPEAT_COUNT` bigint(7) NOT NULL,
  `REPEAT_INTERVAL` bigint(12) NOT NULL,
  `TIMES_TRIGGERED` bigint(10) NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`),
  CONSTRAINT `QRTZ_SIMPLE_TRIGGERS_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `QRTZ_TRIGGERS` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- contrabass.QRTZ_SIMPROP_TRIGGERS definition

CREATE TABLE IF NOT EXISTS `QRTZ_SIMPROP_TRIGGERS` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `TRIGGER_NAME` varchar(190) NOT NULL,
  `TRIGGER_GROUP` varchar(190) NOT NULL,
  `STR_PROP_1` varchar(512) DEFAULT NULL,
  `STR_PROP_2` varchar(512) DEFAULT NULL,
  `STR_PROP_3` varchar(512) DEFAULT NULL,
  `INT_PROP_1` int(11) DEFAULT NULL,
  `INT_PROP_2` int(11) DEFAULT NULL,
  `LONG_PROP_1` bigint(20) DEFAULT NULL,
  `LONG_PROP_2` bigint(20) DEFAULT NULL,
  `DEC_PROP_1` decimal(13,4) DEFAULT NULL,
  `DEC_PROP_2` decimal(13,4) DEFAULT NULL,
  `BOOL_PROP_1` varchar(1) DEFAULT NULL,
  `BOOL_PROP_2` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`),
  CONSTRAINT `QRTZ_SIMPROP_TRIGGERS_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `QRTZ_TRIGGERS` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- contrabass.cb_host_access_history definition

CREATE TABLE IF NOT EXISTS `cb_host_access_history` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `host_id` varchar(100) DEFAULT NULL,
  `access_type` varchar(100) DEFAULT NULL,
  `edited_at` timestamp NULL DEFAULT current_timestamp() COMMENT '생성 일시',
  `editor_id` varchar(100) DEFAULT NULL,
  `editor_name` varchar(100) DEFAULT NULL,
  `before_content` text DEFAULT NULL,
  `after_content` text DEFAULT NULL,
  `host_ip` varchar(100) DEFAULT NULL,
  `is_success` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- contrabass.cb_gpu_mig_profile definition
CREATE TABLE IF NOT EXISTS `cb_gpu_mig_profile` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '아이디',
  `name` varchar(50) DEFAULT NULL COMMENT '이름',
  `profile_id` varchar(50) DEFAULT NULL COMMENT '프로파일 아이디',
  `gpu_unit` int(11) DEFAULT NULL COMMENT '지피유 유닛',
  `gpu_memory` varchar(10) DEFAULT NULL COMMENT '지피유 메모리',
  `mdev_class` varchar(100) DEFAULT NULL COMMENT '엠데브 클래스',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


-- contrabass.cb_autoscale definition
CREATE TABLE `cb_autoscale` (
  `id` varchar(36) NOT NULL,
  `pool_id` varchar(255) DEFAULT NULL COMMENT '풀 ID (OpenStack)',
  `scaling_status` varchar(100) DEFAULT NULL COMMENT '스케일링 상태 (IN, OUT, READY)',
  `provider_id` varchar(36) DEFAULT NULL COMMENT '공급자 ID',
  `project_id` varchar(36) DEFAULT NULL COMMENT '프로젝트 ID',
  `lb_id` varchar(255) DEFAULT NULL COMMENT '로드밸런서 ID (OpenStack)',
  `listener_id` varchar(255) DEFAULT NULL COMMENT '리스너 ID (OpenStack)',
  `health_monitor_id` varchar(255) DEFAULT NULL COMMENT '헬스 모니터 ID (OpenStack)',
  `source_id` varchar(255) DEFAULT NULL COMMENT '임계치 사용시 소스 인스턴스 ID ',
  `instance_request_json` text DEFAULT NULL COMMENT '인스턴스 풀멤버 생성 요청 json',
  `volume_request_json` text DEFAULT NULL COMMENT '볼륨 생성 요청 json',
  `instance_source_json` text DEFAULT NULL COMMENT '인스턴스 소스 유형 json',
  `created_at` timestamp NULL DEFAULT NULL COMMENT '생성 시간',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT '수정 시간',
  `error_message` text DEFAULT NULL COMMENT '에러메세지',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='로드밸런서 리소스 상태 추적 테이블';


-- contrabass.cb_autoscale_detail definition
CREATE TABLE IF NOT EXISTS `cb_autoscale_detail` (
  `id` varchar(36) NOT NULL COMMENT '오토스케일 상세 UUID (PK)',
  `cb_autoscale_id` varchar(36) DEFAULT NULL COMMENT '오토스케일 정책 ID (외래키)',
  `member_order` int(11) NOT NULL DEFAULT 0 COMMENT '풀멤버 등록 순서 (우선순위)',
  `instance_id` varchar(100) DEFAULT NULL COMMENT '인스턴스 ID',
  `instance_status` varchar(20) DEFAULT NULL COMMENT '인스턴스 생성 상태',
  `created_at` timestamp NULL DEFAULT NULL COMMENT '생성 시간',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT '수정 시간',
  `fixed_ip` varchar(255) DEFAULT NULL COMMENT '인스턴스의 고정 IP 주소',
  `instance_name` varchar(255) DEFAULT NULL COMMENT '인스턴스 이름',
  `hypervisor_hostname` varchar(255) DEFAULT NULL COMMENT '인스턴스가 할당된 하이퍼바이저 호스트 이름',
  `project_id` varchar(255) DEFAULT NULL COMMENT '인스턴스가 속한 OpenStack 프로젝트 ID',
  `pool_id` varchar(36) DEFAULT NULL COMMENT '풀 멤버 등록용 설명',
  `member_id` varchar(36) DEFAULT NULL COMMENT '등록된 풀멤버 아이디',
  `volume_status` varchar(36) DEFAULT NULL COMMENT '볼륨 상태(VOLUME_CREATING_READY, VOLUME_CREATING_WORKING, VOLUME_CREATING_FINISH, VOLUME_CREATING_FAILED, VOLUME_CHECK_READY, VOLUME_CHECK_WORKING, VOLUME_CHECK_FINISH, VOLUME_CHECK_FAILED)',
  `volume_ids` text DEFAULT NULL COMMENT '볼륨 IDs(쉼표로 구분) ',
  `member_status` varchar(100) DEFAULT NULL COMMENT '풀멤버 상태',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_uca1400_ai_ci COMMENT='로드밸런서 오토스케일 대상 상세 정보 테이블';


-- contrabass.cb_autoscale_policy definition
CREATE TABLE IF NOT EXISTS `cb_autoscale_policy` (
  `id` varchar(36) NOT NULL COMMENT '정책 UUID (PK)',
  `cb_autoscale_id` varchar(36) NOT NULL COMMENT '오토스케일 대상 ID (외래키)',
  `policy_type` enum('IN','OUT','READY') DEFAULT NULL COMMENT '정책 유형: 스케일 인(IN), 스케일 아웃(OUT), 초기 준비(READY)',
  `duration_minutes` int(11) NOT NULL COMMENT '조건 유지 시간 (분)',
  `avg_cpu_usage` int(11) NOT NULL COMMENT '풀 멤버 평균 CPU 사용률 임계치 (%)',
  `instance_count` int(11) NOT NULL COMMENT '스케일 인: 최소 인스턴스 수 / 스케일 아웃: 최대 인스턴스 수',
  `created_at` timestamp NULL DEFAULT NULL COMMENT '생성 시간',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT '수정 시간',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_uca1400_ai_ci COMMENT='로드밸런서 풀 멤버 임계치 정책 상세 테이블';

-- contrabass.cb_object_file definition

CREATE TABLE IF NOT EXISTS `cb_object_file` (
  `seq` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '파일 메타데이터 고유 식별자 (자동 증가)',
  `owner_id` varchar(128) NOT NULL COMMENT '파일 소유자 ID (예: 사용자 또는 프로젝트 UUID)',
  `bucket_name` varchar(255) NOT NULL COMMENT 'S3 또는 오브젝트 스토리지 버킷 이름',
  `file_key` varchar(1024) DEFAULT NULL COMMENT '버킷 제외 이후 경로 (예: folder1/folder2)',
  `original_file_name` varchar(512) NOT NULL COMMENT '사용자가 업로드한 원본 파일 이름',
  `stored_file_name` char(36) NOT NULL COMMENT '시스템이 부여한 저장용 파일 UUID',
  `file_hash` varchar(128) DEFAULT NULL COMMENT '파일 무결성 확인용 해시값 (예: SHA-256)',
  `file_size` bigint(20) DEFAULT NULL COMMENT '파일 크기 (바이트 단위)',
  `shared_url` varchar(1024) DEFAULT NULL COMMENT '공유 URL',
  `url_expiration` varchar(1024) DEFAULT NULL COMMENT '공유 URL 만료일시',
  `uploaded_at` timestamp NULL DEFAULT current_timestamp() COMMENT '파일 업로드 일시',
  PRIMARY KEY (`seq`),
  KEY `idx_object_file_owner_id` (`owner_id`) COMMENT 'owner_id 단일 인덱스 (조회/조인용)',
  KEY `idx_object_file_bucket_name` (`bucket_name`) COMMENT 'bucket_name 단일 인덱스 (조회/조인용)',
  KEY `idx_object_file_owner_bucket` (`owner_id`,`bucket_name`) COMMENT 'owner_id + bucket_name 복합 인덱스 (집계/조회 최적화)'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='S3 오브젝트 업로드 데이터를 저장하는 테이블';


-- contrabass.cb_object_storage definition

CREATE TABLE IF NOT EXISTS `cb_object_storage` (
  `seq` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '버킷 고유 식별자 (PK, 자동 증가)',
  `owner_id` varchar(128) NOT NULL COMMENT 's3 저장소 식별정보',
  `provider_uuid` varchar(55) NOT NULL COMMENT '공급자 uuid',
  `bucket_name` varchar(255) NOT NULL COMMENT 'S3 버킷명',
  `project_id` varchar(64) NOT NULL COMMENT '오픈스택 프로젝트 ID (UUID 형식)',
  `is_shared` tinyint(1) DEFAULT 0 COMMENT '다른 프로젝트와 공유 여부 (기본값: false)',
  `s3_type` enum('aws','netapp') NOT NULL COMMENT 'S3 호환 타입 (aws 또는 netapp)',
  `created_by` varchar(64) NOT NULL COMMENT '버킷을 생성한 사용자 ID',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '마지막으로 수정한 사용자 ID',
  `created_at` datetime NOT NULL DEFAULT current_timestamp() COMMENT '버킷 등록 일시',
  `updated_at` datetime DEFAULT NULL COMMENT '수정일시',
  PRIMARY KEY (`seq`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='OpenStack 프로젝트와 연동된 S3 호환 오브젝트 스토리지 버킷 정보 테이블';

-- contrabass.cb_replication_master definition

CREATE TABLE IF NOT EXISTS `cb_replication_master` (
  `id` varchar(36) NOT NULL,
  `process_id` varchar(36) NOT NULL COMMENT '프로세스 ID (중복 불가, 고유)',
  `job_name` enum('VOLUME_GROUP_CREATION_JOB','VOLUME_ATTACHMENT_JOB','VOLUME_GROUP_SNAPSHOT_JOB','VOLUME_SNAPSHOT_JOB','VOLUME_CREATION_JOB','VOLUME_STORAGE_MIGRATION_JOB','INSTANCE_REPLICATION_JOB','RESOURCE_CLEANUP_JOB') NOT NULL COMMENT '작업명 (예: VOLUME_GROUP_CREATION_JOB, VOLUME_ATTACHMENT_JOB 등)',
  `request_data` text DEFAULT NULL COMMENT '요청 JSON 데이터',
  `source_instance_id` varchar(36) DEFAULT NULL COMMENT '원본 인스턴스 ID',
  `target_instance_id` varchar(36) DEFAULT NULL COMMENT '생성된 인스턴스 ID',
  `volume_group_type_name` varchar(36) DEFAULT NULL COMMENT '볼륨 그룹 타입 명 ',
  `volume_group_name` varchar(255) DEFAULT NULL COMMENT '볼륨 그룹 명',
  `volume_group_snapshot_name` varchar(255) DEFAULT NULL COMMENT '볼륨 그룹 스냅샷 명',
  `volume_group_type_id` varchar(36) DEFAULT NULL COMMENT '볼륨 그룹 타입 ID ',
  `volume_group_id` varchar(36) DEFAULT NULL COMMENT '볼륨 그룹 ID',
  `volume_group_snapshot_id` varchar(36) DEFAULT NULL COMMENT '볼륨 그룹 스냅샷 ID ',
  `volume_ids` text DEFAULT NULL COMMENT '볼륨 ID (콤마로 구분)',
  `replica_volume_ids` text DEFAULT NULL COMMENT '복제된 볼륨 ID 목록',
  `project_id` varchar(36) DEFAULT NULL COMMENT '프로젝트 ID',
  `provider_id` varchar(36) DEFAULT NULL COMMENT '프로바이더 ID',
  `auto_delete` tinyint(1) DEFAULT NULL COMMENT '자동 삭제 ',
  `delete_status` enum('READY','SNAPSHOT_DELETING','SNAPSHOT_DELETED','VOLUME_DETACHING','VOLUME_DETACHED','GROUP_DELETING','GROUP_DELETED','VOLUME_TYPE_DELETING','FAILED','FINISH','ERROR') DEFAULT NULL COMMENT '삭제 상태(SNAPSHOT_DELETING, VOLUME_DETACHING, GROUP_DELETING, FAILED, DELETED 등)',
  `created_by` varchar(36) DEFAULT NULL COMMENT '생성자 ID',
  `updated_by` varchar(36) DEFAULT NULL COMMENT '수정자 ID',
  `created_at` timestamp NULL DEFAULT NULL COMMENT '생성 시간',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT '수정 시간',
  PRIMARY KEY (`id`),
  KEY `idx_process_id` (`process_id`),
  KEY `idx_process_id_job_name` (`process_id`,`job_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_uca1400_ai_ci COMMENT='인스턴스 복제 마스터 테이블';

-- contrabass.cb_replication_detail definition

CREATE TABLE IF NOT EXISTS `cb_replication_detail` (
  `id` varchar(36) NOT NULL,
  `job_name` enum('VOLUME_GROUP_CREATION_JOB','VOLUME_ATTACHMENT_JOB','VOLUME_GROUP_SNAPSHOT_JOB','VOLUME_SNAPSHOT_JOB','VOLUME_CREATION_JOB','VOLUME_STORAGE_MIGRATION_JOB','INSTANCE_REPLICATION_JOB','RESOURCE_CLEANUP_JOB') NOT NULL COMMENT '작업명 (예: 상태조회, 스냅샷 생성 등)',
  `status` enum('READY','PROCESSING','RUNNING','FINISH','ERROR') NOT NULL COMMENT '상태 (READY, WORKING, FINISH, ERROR)',
  `actual_status` varchar(50) DEFAULT NULL COMMENT '실제 상태 (예: available, queue 등)',
  `error_message` text DEFAULT NULL COMMENT '에러 메세지 ',
  `process_id` varchar(36) NOT NULL COMMENT '프로세스 ID (Master와 조인용)',
  `created_at` timestamp NULL DEFAULT current_timestamp() COMMENT '생성 시간',
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT '수정 시간',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_process_id_job_name` (`process_id`,`job_name`) COMMENT 'process_id와 job_name 조합의 유일성 보장',
  KEY `idx_status` (`status`) COMMENT 'status 조회 속도 향상을 위한 인덱스',
  KEY `idx_process_id` (`process_id`) COMMENT 'process_id 조회 속도 향상을 위한 인덱스'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_uca1400_ai_ci COMMENT='Replication 작업 상세 테이블';

-- contrabass.cb_replication_history definition

CREATE TABLE IF NOT EXISTS `cb_replication_history` (
  `id` varchar(36) NOT NULL COMMENT '고유 식별자 (Primary Key)',
  `job_name` enum('VOLUME_GROUP_CREATION_JOB','VOLUME_ATTACHMENT_JOB','VOLUME_GROUP_SNAPSHOT_JOB','VOLUME_SNAPSHOT_JOB','VOLUME_CREATION_JOB','VOLUME_STORAGE_MIGRATION_JOB','INSTANCE_REPLICATION_JOB','RESOURCE_CLEANUP_JOB') DEFAULT NULL COMMENT '작업명 (예: 상태조회, 스냅샷 생성 등)',
  `status` enum('READY','PROCESSING','RUNNING','FINISH','ERROR') DEFAULT NULL COMMENT '상태 (READY, FINISH, ERROR)',
  `actual_status` varchar(50) DEFAULT NULL COMMENT '실제 상태 (예: available, queue 등)',
  `process_id` varchar(36) NOT NULL COMMENT '프로세스 ID (조인용)',
  `request_data` text DEFAULT NULL COMMENT '요청 JSON 데이터',
  `source_instance_id` varchar(36) DEFAULT NULL COMMENT '원본 인스턴스 ID',
  `target_instance_id` varchar(36) DEFAULT NULL COMMENT '생성된 인스턴스 ID',
  `volume_group_type_name` varchar(36) DEFAULT NULL COMMENT '볼륨 그룹 타입 명 ',
  `volume_group_name` varchar(255) DEFAULT NULL COMMENT '볼륨 그룹 명 ',
  `volume_group_snapshot_name` varchar(255) DEFAULT NULL COMMENT '볼륨 그룹 스냅샷 ',
  `volume_group_type_id` varchar(36) DEFAULT NULL COMMENT '볼륨 그룹 타입 ID ',
  `volume_group_id` varchar(36) DEFAULT NULL COMMENT '볼륨 그룹 ID',
  `volume_group_snapshot_id` varchar(36) DEFAULT NULL COMMENT '볼륨 그룹 스냅샷 ID ',
  `volume_ids` text DEFAULT NULL COMMENT '볼륨 ID (콤마로 구분)',
  `project_id` varchar(36) DEFAULT NULL COMMENT '프로젝트 ID',
  `provider_id` varchar(36) DEFAULT NULL COMMENT '프로바이더 ID',
  `created_by` varchar(36) DEFAULT NULL COMMENT '생성자',
  `updated_by` varchar(36) DEFAULT NULL COMMENT '수정자',
  `created_at` timestamp NULL DEFAULT current_timestamp() COMMENT '생성 시간',
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT '수정 시간',
  `finish_at` timestamp NULL DEFAULT NULL COMMENT '작업 완료 시간',
  PRIMARY KEY (`id`),
  KEY `idx_status` (`status`) COMMENT 'status 조회 속도 향상을 위한 인덱스'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_uca1400_ai_ci COMMENT='Replication 작업 이력 테이블';