# Image Tag
# Values.yaml에 직접 기입할 경우 해당 Tag 사용, 미기입 시 commonTag 사용
{{- define "image.tag" -}}
{{- $url := .Values.global.imageRegistry.url -}}
{{- $port := .Values.global.imageRegistry.pullPort -}}
{{- $registry := "maestro" -}}
{{- $imageName := .name -}}
{{- $imageTag := default .Values.global.image.commonTag .tag -}}
{{ printf "%s:%s/%s/%s:%s" $url $port $registry $imageName $imageTag -}}
{{- end -}}

# Common Label
{{- define "common.labels" -}}
maestro/app: {{ .app }}
maestro/product: {{ .product }}
maestro/tier: {{ .tier }}
maestro/type: {{ .type }}
{{- end -}}