#!/bin/bash

set -e

FILES=(
  "/etc/os-release"
  "/usr/lib/os-release"
  "/etc/lsb-release"
  "/etc/issue"
)

for file in "${FILES[@]}"; do
  if [ -f "$file" ]; then
    echo "  → Patching $file"
    sed -i 's/24.04.1/24.04.2/g' "$file"
    sed -i 's/24.04\.1/24.04.2/g' "$file"
    sed -i 's/Ubuntu 24.04.1 LTS/Ubuntu 24.04.2 LTS/g' "$file"
  else
    echo "  ⚠ File not found: $file"
  fi
done
