#!/bin/bash

LOG_DIR="/var/log/contrabass-benchmark"
mkdir -p "$LOG_DIR"

# 1. sysbench CPU 테스트
sysbench cpu --cpu-max-prime=2000000 --time=180 --threads=15 run \
  > "$LOG_DIR/sysbench-cpu-$(hostname).log" 2>&1

# 2. sysbench 메모리 테스트 (read/write 모두 수행)
for op in read write; do
  sysbench memory --memory-total-size=400G \
    --memory-block-size=4K --memory-oper=$op \
    --memory-access-mode=rnd --threads=8 --time=0 run \
    > "$LOG_DIR/sysbench-memory-${op}-$(hostname).log" 2>&1
done

# 3. fio 디스크 테스트
fio --ioengine=libaio --direct=1 --bs=4k --rw=randrw --rwmixread=70 --time_based \
  --runtime=60 --size=50G --group_reporting --name=multi-thread-high-iodepth \
  --numjobs=8 --iodepth=64 --filename=/root/contrabass-fio-test \
  --output="$LOG_DIR/fio-$(hostname).log"

# 4. iperf3 테스트
iperf3 -c 172.168.2.56 \
  > "$LOG_DIR/iperf3-$(hostname).log" 2>&1

# 5. 모든 결과를 하나의 파일로 합침
cat "$LOG_DIR"/*.log > "$LOG_DIR/benchmark-full-$(hostname).log"
