#!/bin/bash
#
# Octavia용 TLS 인증서 및 PKCS#12 생성 스크립트
# 실행 전에 VIP, 조직 정보, 파일 경로 등을 필요에 맞게 수정하세요.
#

# --- 설정값 ---
VIP="172.168.0.249"  #VIP 입력
ORG="MyOrg"
ROOT_CN="MyRootCA"
INT_CN="Octavia-Intermediate-CA"
SERVER_CN="${VIP}"
DAYS=3650
# ----------------

# 1. 루트 CA 키 및 인증서 생성
openssl genrsa -out ca.key 2048
openssl req -x509 -new -nodes -key ca.key -sha256 -days ${DAYS} \
  -subj "/C=KR/ST=Seoul/L=Seoul/O=${ORG}/OU=RootCA/CN=${ROOT_CN}" \
  -out ca.crt

# 2. 중간 CA 키 및 CSR, 인증서 생성
openssl genrsa -out ca-int.key 2048
openssl req -new -key ca-int.key \
  -subj "/C=KR/ST=Seoul/L=Seoul/O=${ORG}/OU=IntermediateCA/CN=${INT_CN}" \
  -addext "subjectAltName=IP:${VIP}" \
  -out ca-int.csr
openssl x509 -req -in ca-int.csr -CA ca.crt -CAkey ca.key -CAcreateserial \
  -out ca-int.crt -days ${DAYS} -sha256

# 3. 서버 키 및 CSR, 인증서 생성 (CN=VIP, SAN=VIP)
openssl genrsa -out server.key 2048
openssl req -new -key server.key \
  -subj "/C=KR/ST=Seoul/L=Seoul/O=${ORG}/OU=Octavia/CN=${SERVER_CN}" \
  -addext "subjectAltName=IP:${VIP}" \
  -out server.csr
openssl x509 -req -in server.csr -CA ca-int.crt -CAkey ca-int.key -CAcreateserial \
  -out server.crt -days ${DAYS} -sha256

# 4. 서버 인증서 + 중간 CA 체인 합치기
cat server.crt ca-int.crt > server_chain.pem

# 5. PKCS#12(.p12) 파일 생성 (cert+chain+key 포함)
openssl pkcs12 -export \
  -in server_chain.pem \
  -inkey server.key \
  -out octavia.p12 \
  -passin  pass: \
  -passout pass:

echo "생성 완료:"
echo "  - 루트CA:    ca.crt"
echo "  - 중간CA:    ca-int.crt"
echo "  - 서버인증서: server.crt"
echo "  - 서버체인:  server_chain.pem"
echo "  - 개인키:    server.key"
echo "  - PKCS12:    octavia.p12"
