#!/bin/bash

# 변수 정의
BASE_VM_NAME="apache2-vm"
FLAVOR="numa-flavor"
IMAGE="ubuntu-22.04.qcow2"
NETWORK="lb-mgmt-net"
LOG_FILE="vm_create_result.log"
COMPUTE_NODE="ds-com2"
VOLUME_SIZE=50  # GB
COUNT=2  # 생성할 수량

source /root/contrabass-openrc

echo "========== VM + Volume Batch Creation ==========" | tee "$LOG_FILE"

for i in $(seq 1 $COUNT); do
    VM_NAME="${BASE_VM_NAME}-${i}"
    VOLUME_NAME="${VM_NAME}-boot-volume"

    echo "" | tee -a "$LOG_FILE"
    echo "[${i}] Creating bootable volume '$VOLUME_NAME' from image '$IMAGE'..." | tee -a "$LOG_FILE"
    openstack volume create --image "$IMAGE" --size "$VOLUME_SIZE" --bootable "$VOLUME_NAME"
    if [ $? -ne 0 ]; then
        echo "[ERROR] Failed to create volume '$VOLUME_NAME'. Skipping VM creation." | tee -a "$LOG_FILE"
        continue
    fi

    # 볼륨 생성 완료까지 대기
    echo "    Waiting for volume to become available..." | tee -a "$LOG_FILE"
    for j in {1..30}; do
        VOLUME_STATUS=$(openstack volume show "$VOLUME_NAME" -f value -c status)
        echo "      -> Volume status: $VOLUME_STATUS" | tee -a "$LOG_FILE"
        if [ "$VOLUME_STATUS" == "available" ]; then
            break
        fi
        sleep 5
    done

    if [ "$VOLUME_STATUS" != "available" ]; then
        echo "[ERROR] Volume '$VOLUME_NAME' not ready. Skipping VM." | tee -a "$LOG_FILE"
        continue
    fi

    echo "[${i}] Creating VM '$VM_NAME' from volume '$VOLUME_NAME' on host '$COMPUTE_NODE'..." | tee -a "$LOG_FILE"
    openstack --os-compute-api-version 2.74 server create \
        --flavor "$FLAVOR" \
        --network "$NETWORK" \
        --volume "$VOLUME_NAME" \
        --host "$COMPUTE_NODE" \
        "$VM_NAME" --wait

    if [ $? -eq 0 ]; then
        echo "[OK] VM '$VM_NAME' created successfully." | tee -a "$LOG_FILE"
    else
        echo "[ERROR] Failed to create VM '$VM_NAME'." | tee -a "$LOG_FILE"
    fi
done
