/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtils {
    public static final String SHA1 = "SHA-1";
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private static MessageDigest getDigester(String algo) {
        try {
            return MessageDigest.getInstance(algo);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static String hash(String value, String algo) {
        MessageDigest digester = HashUtils.getDigester(algo);
        byte[] digest = digester.digest(value != null ? value.getBytes(StandardCharsets.UTF_8) : new byte[]{});
        return HashUtils.toHex(digest);
    }

    public static String hash(File file, String algo) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            String string = HashUtils.hash(is, algo);
            return string;
        }
    }

    public static String hash(InputStream is, String algo) throws IOException {
        int read;
        MessageDigest digester = HashUtils.getDigester(algo);
        byte[] buffer = new byte[32768];
        while ((read = is.read(buffer)) >= 0) {
            digester.update(buffer, 0, read);
        }
        byte[] digest = digester.digest();
        return HashUtils.toHex(digest);
    }

    public static String toHex(byte[] digest) {
        char[] chars = new char[digest.length * 2];
        for (int i = 0; i < digest.length; ++i) {
            int loNibble = digest[i] & 0xF;
            int hiNibble = (digest[i] & 0xF0) >> 4;
            chars[(i << 1) + 0] = HEX[hiNibble];
            chars[(i << 1) + 1] = HEX[loNibble];
        }
        return new String(chars);
    }
}

