/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.client.utils;

import com.sonatype.insight.client.utils.HttpClientUtils;
import com.sonatype.insight.client.utils.Result;
import com.sonatype.insight.client.utils.UrlUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientBuilder<R extends Result> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    static final boolean GZIP = Boolean.parseBoolean(System.getProperty("insight.client.accept.gzip", "true"));
    private static final String CSRF_TOKEN = "CSRF-REQUEST-TOKEN";
    static final String CLIENT_INSTANCE_ID_HEADER = "X-CLM-Client-Instance-Id";
    final HttpClientUtils.Configuration config;

    protected AbstractClientBuilder(HttpClientUtils.Configuration config) {
        this.config = config;
    }

    protected final RequestBuilder path(String ... segments) {
        return new RequestBuilder(UrlUtils.appendUrlPaths(this.config.getServerUrl(), segments));
    }

    protected final RequestBuilder adminPath(String ... segments) {
        return new RequestBuilder(UrlUtils.appendUrlPaths(this.config.getServerAdminUrl(), segments));
    }

    protected HttpRequest prepare(HttpRequest request) {
        return request;
    }

    protected abstract R result(HttpResponse var1);

    static /* synthetic */ Logger access$000(AbstractClientBuilder x0) {
        return x0.log;
    }

    public final class RequestBuilder {
        private final String uri;
        private String query = "";
        private int retries = -1;
        private int timeout = -1;

        RequestBuilder(String uri) {
            this.uri = uri;
        }

        public RequestBuilder query(String ... params) {
            this.query = UrlUtils.appendQueryParams(params);
            return this;
        }

        public RequestBuilder queryWithEmptyParams(String ... params) {
            this.query = UrlUtils.appendQueryParams(true, params);
            return this;
        }

        public RequestBuilder retries(int num) {
            this.retries = num;
            return this;
        }

        public RequestBuilder timeout(int millis) {
            this.timeout = millis;
            return this;
        }

        public R get() throws IOException {
            return this.execute((HttpUriRequest)new HttpGet(this.uri()));
        }

        public R post(HttpEntity entity) throws IOException {
            HttpPost post = new HttpPost(this.uri());
            post.setEntity(entity);
            return this.execute((HttpUriRequest)post);
        }

        public R patch(HttpEntity entity) throws IOException {
            HttpPatch patch = new HttpPatch(this.uri());
            patch.setEntity(entity);
            return this.execute((HttpUriRequest)patch);
        }

        public R put(HttpEntity entity) throws IOException {
            HttpPut put = new HttpPut(this.uri());
            put.setEntity(entity);
            return this.execute((HttpUriRequest)put);
        }

        public R delete() throws IOException {
            return this.execute((HttpUriRequest)new HttpDelete(this.uri()));
        }

        private URI uri() {
            try {
                return new URI(this.uri + this.query).parseServerAuthority();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }

        /*
         * Exception decompiling
         */
        private R execute(HttpUriRequest request) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void addCsrfTokenCookie(CookieStore cookieStore, String domain) {
            BasicClientCookie cookie = new BasicClientCookie("CLM-CSRF-TOKEN", AbstractClientBuilder.CSRF_TOKEN);
            cookie.setPath("/");
            cookie.setDomain(domain);
            cookieStore.addCookie((Cookie)cookie);
        }
    }
}

