/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.client.utils;

import java.util.UUID;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InstanceIdProvider {
    private static final Logger log = LoggerFactory.getLogger(InstanceIdProvider.class);
    static final String PREF_NODE = "/com/sonatype/integrations";
    static final String PREF_KEY = "Client-Instance-Id";

    private InstanceIdProvider() {
    }

    public static String getInstanceId() {
        String instanceId = null;
        try {
            Preferences preferences = Preferences.userRoot().node(PREF_NODE);
            instanceId = preferences.get(PREF_KEY, null);
            if (instanceId == null) {
                instanceId = UUID.randomUUID().toString().replace("-", "");
                preferences.put(PREF_KEY, instanceId);
            }
        }
        catch (Exception e) {
            log.error("Failed to load instance-id", (Throwable)e);
            instanceId = "error";
        }
        return instanceId;
    }
}

