/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileUtils;
import com.sonatype.insight.scan.file.ManifestFileReader;
import com.sonatype.insight.scan.manifest.ConanDependencyCategory;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zz.de.schlichtherle.truezip.file.TFile;

class ConanFilePyReader
implements ManifestFileReader {
    private static final String STATIC_REQUIRES_MARKER = "requires";
    private static final String STATIC_BUILD_REQUIRES_MARKER = "build_requires";
    private static final String DYNAMIC_REQUIRES_MARKER = "self.requires(";
    private static final String DYNAMIC_BUILD_REQUIRES_MARKER = "self.build_requires(";
    private static final Pattern TEXT_BETWEEN_SINGLE_OR_DOUBLE_QUOTES = Pattern.compile("(?<text>\"(?:[^\"\\\\]|\\\\.)*\"|'(?:[^'\\\\]|\\\\.)*')");

    ConanFilePyReader() {
    }

    @Override
    public List<String> readLines(TFile file) {
        ArrayList<String> requiresDependencies = new ArrayList<String>();
        ArrayList<String> buildRequiresDependencies = new ArrayList<String>();
        for (String line : FileUtils.readMultiLines(file)) {
            line = line.trim();
            this.addDependency(line, STATIC_REQUIRES_MARKER, requiresDependencies);
            this.addDependency(line, STATIC_BUILD_REQUIRES_MARKER, buildRequiresDependencies);
            this.addDependency(line, DYNAMIC_REQUIRES_MARKER, requiresDependencies);
            this.addDependency(line, DYNAMIC_BUILD_REQUIRES_MARKER, buildRequiresDependencies);
        }
        ArrayList<String> filteredLines = new ArrayList<String>();
        filteredLines.add(ConanDependencyCategory.REQUIRES.categoryMarker);
        filteredLines.addAll(requiresDependencies);
        filteredLines.add(ConanDependencyCategory.BUILD_REQUIRES.categoryMarker);
        filteredLines.addAll(buildRequiresDependencies);
        return filteredLines;
    }

    private void addDependency(String line, String marker, List<String> dependencies) {
        if (line.startsWith(marker)) {
            Matcher matcher = TEXT_BETWEEN_SINGLE_OR_DOUBLE_QUOTES.matcher(line);
            while (matcher.find()) {
                String text = matcher.group("text");
                if (!this.isValidDependency(text = this.removeQuotes(text))) continue;
                dependencies.add(text);
            }
        }
    }

    private String removeQuotes(String text) {
        return text.trim().replaceAll("\"", "").replaceAll("'", "");
    }

    private boolean isValidDependency(String text) {
        return this.isDependency(text) && this.isNotParameterized(text) && this.isExactVersion(text);
    }

    private boolean isDependency(String text) {
        return text.matches("\\S+/\\S+");
    }

    private boolean isNotParameterized(String dependency) {
        return !dependency.contains("%s");
    }

    private boolean isExactVersion(String dependency) {
        return dependency.matches("^[^<>~|]+$");
    }
}

