/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileUtils;
import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.file.SbomUtils;
import com.sonatype.insight.scan.manifest.CondaDependency;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import zz.com.github.packageurl.MalformedPackageURLException;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.org.apache.commons.lang3.tuple.Pair;
import zz.org.cyclonedx.model.Component;

public class CondaProcessor {
    private final FileVisitor fileVisitor;
    private final Logger log;
    private static final String EXPLICIT_LINE = "@EXPLICIT";
    private static final Pattern CONDA_NON_EXPLICIT_PATTERN = Pattern.compile("(?<name>.+)=(?<version>.+)=(?<build>.+)$");

    public CondaProcessor(FileVisitor fileVisitor) {
        this.fileVisitor = fileVisitor;
        this.log = fileVisitor.log;
    }

    public Pair<Boolean, String> process(TFile condaFile) {
        this.log.debug("Processing Conda file: {}", (Object)condaFile.getAbsolutePath());
        List<String> lines = FileUtils.readLines(condaFile);
        boolean isExplicitSpecFile = this.isExplicitSpecFile(lines);
        return Pair.of(isExplicitSpecFile, isExplicitSpecFile ? this.processExplicitSpecFile(lines) : this.processNonExplicitSpecFile(lines));
    }

    private String processExplicitSpecFile(List<String> lines) {
        ArrayList<Component> components = new ArrayList<Component>();
        for (String line : lines) {
            CondaDependency dependency;
            if ((line = line.trim()).isEmpty() || this.canBeSkipped(line) || (dependency = CondaDependency.fromUrl(line)) == null || this.isSensitive(dependency)) continue;
            this.addComponent(dependency, components);
        }
        try {
            return SbomUtils.createSbomXmlString(components);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String processNonExplicitSpecFile(List<String> lines) {
        ListIterator<String> iterator = lines.listIterator();
        while (iterator.hasNext()) {
            String line = iterator.next().trim();
            if (line.isEmpty() || this.isComment(line)) {
                iterator.remove();
                continue;
            }
            String dependencyLine = this.getDependencyLine(line);
            CondaDependency dependency = CondaDependency.fromString(dependencyLine);
            if (dependency == null || this.isSensitive(dependency)) {
                iterator.remove();
                continue;
            }
            iterator.set(dependencyLine);
        }
        return this.toString(lines);
    }

    private void addComponent(CondaDependency dependency, List<Component> components) {
        try {
            Component component = SbomUtils.createLibraryComponent(dependency.getName(), dependency.getVersion());
            component.setPurl(SbomUtils.createCondaPackageUrl(dependency.getChannel(), dependency.getSubdir(), dependency.getName(), dependency.getVersion(), dependency.getBuild(), dependency.getType()));
            component.setScope(Component.Scope.REQUIRED);
            components.add(component);
        }
        catch (MalformedPackageURLException e) {
            this.log.debug("Invalid coordinates found in the file conda.txt", (Throwable)e);
        }
    }

    private boolean isExplicitSpecFile(List<String> lines) {
        for (String s : lines) {
            String line = s.trim();
            Matcher matcher = CONDA_NON_EXPLICIT_PATTERN.matcher(line);
            if (EXPLICIT_LINE.equals(line)) {
                return true;
            }
            if (!matcher.matches()) continue;
            return false;
        }
        return false;
    }

    private boolean isComment(String line) {
        return line.startsWith("#");
    }

    private boolean canBeSkipped(String line) {
        return line.startsWith(EXPLICIT_LINE) || this.isComment(line);
    }

    private String getDependencyLine(String line) {
        int firstIndexOfSeparator = line.indexOf("=");
        if (firstIndexOfSeparator < 0) {
            return "";
        }
        int secondIndexOfSeparator = line.indexOf("=", firstIndexOfSeparator + 1);
        if (secondIndexOfSeparator < 0) {
            return line;
        }
        return line.substring(0, secondIndexOfSeparator);
    }

    private boolean isSensitive(CondaDependency dependency) {
        if (!this.fileVisitor.includeResourceName(dependency.getName())) {
            this.log.debug("Not including Conda dependency '{}'.", (Object)dependency);
            return true;
        }
        return false;
    }

    private String toString(List<String> lines) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String line : lines) {
            stringBuilder.append(line).append('\n');
        }
        return stringBuilder.toString();
    }
}

