/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.ScanSession;
import org.slf4j.Logger;
import zz.com.google.gson.GsonBuilder;
import zz.com.neuvector.Scanner;
import zz.com.neuvector.model.Image;
import zz.com.neuvector.model.NVScanner;
import zz.com.neuvector.model.Registry;
import zz.com.neuvector.model.ScanRepoReportData;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.org.apache.commons.lang3.StringUtils;

public class ContainerFileProcessor {
    private final ScanSession scanSession;
    private final Logger log;
    public static final String NEXUS_CONTAINER_SCANNING_SCANNER_IMAGE = "NEXUS_CONTAINER_SCANNING_SCANNER_IMAGE";
    public static final String NEXUS_CONTAINER_SCANNING_REGISTRY_URL = "NEXUS_CONTAINER_SCANNING_REGISTRY_URL";
    public static final String NEXUS_CONTAINER_SCANNING_REGISTRY_USER = "NEXUS_CONTAINER_SCANNING_REGISTRY_USER";
    public static final String NEXUS_CONTAINER_SCANNING_REGISTRY_PASSWORD = "NEXUS_CONTAINER_SCANNING_REGISTRY_PASSWORD";
    public static final String NEXUS_CONTAINER_IMAGE_REGISTRY_USER = "NEXUS_CONTAINER_IMAGE_REGISTRY_USER";
    public static final String NEXUS_CONTAINER_IMAGE_REGISTRY_PASSWORD = "NEXUS_CONTAINER_IMAGE_REGISTRY_PASSWORD";
    public static final String NEXUS_CONTAINER_SCANNING_MOUNT_PATH = "NEXUS_CONTAINER_SCANNING_MOUNT_PATH";
    public static final String DEFAULT_MOUNT_PATH = "/tmp";
    public static final String JENKINS_TMP_WORKSPACE = "WORKSPACE_TMP";
    public static final String NEUVECTOR_IMAGE = "neuvector.image";
    public static final String DEFAULT_SCANNER_IMAGE = "scanner:latest";
    public static final String DEFAULT_REGISTRY_URL = "http://registry.hub.docker.com/neuvector";
    private String nvScannerImage;
    private String nvRegistryURL;
    private String nvRegistryUser;
    private String nvRegistryPassword;
    private String nvMountPath = "/tmp";
    private String imageRegistryUserName;
    private String imageRegistryUserPassword;

    public ContainerFileProcessor(Logger log, ScanSession scanSession) {
        this.log = log;
        this.scanSession = scanSession;
    }

    public String process(TFile file) {
        String scannerImage = this.getValue(NEXUS_CONTAINER_SCANNING_SCANNER_IMAGE);
        String registryUrl = this.getValue(NEXUS_CONTAINER_SCANNING_REGISTRY_URL);
        this.nvScannerImage = scannerImage == null ? DEFAULT_SCANNER_IMAGE : scannerImage;
        this.nvRegistryURL = registryUrl == null ? DEFAULT_REGISTRY_URL : registryUrl;
        this.nvRegistryUser = this.getValue(NEXUS_CONTAINER_SCANNING_REGISTRY_USER);
        this.nvRegistryPassword = this.getValue(NEXUS_CONTAINER_SCANNING_REGISTRY_PASSWORD);
        this.imageRegistryUserName = this.getValue(NEXUS_CONTAINER_IMAGE_REGISTRY_USER);
        this.imageRegistryUserPassword = this.getValue(NEXUS_CONTAINER_IMAGE_REGISTRY_PASSWORD);
        if (this.getValue(NEXUS_CONTAINER_SCANNING_MOUNT_PATH) != null) {
            this.nvMountPath = this.getValue(NEXUS_CONTAINER_SCANNING_MOUNT_PATH);
        } else if (this.scanSession.getEnvVar(JENKINS_TMP_WORKSPACE) != null) {
            this.nvMountPath = this.scanSession.getEnvVar(JENKINS_TMP_WORKSPACE);
        }
        this.log.info("Using mount path: {}", (Object)this.nvMountPath);
        return this.getNeuVectorContainerScanReport(file);
    }

    private String getValue(String key) {
        if (this.scanSession.getEnvVar(key) != null) {
            this.log.info("{} found in provided environmental variables.", (Object)key);
            return this.scanSession.getEnvVar(key);
        }
        if (System.getenv(key) != null) {
            this.log.info("{} found in host machine environmental variables.", (Object)key);
            return System.getenv(key);
        }
        this.log.info("{} missing.", (Object)key);
        return null;
    }

    private String getNeuVectorContainerScanReport(TFile file) {
        String scanTarget = file.getPath().replace('\\', '/');
        RegistryImageTagDto registryImageTagDto = this.getRegistryImageTag(scanTarget);
        String image = registryImageTagDto.image;
        String tag = registryImageTagDto.tag;
        String remoteRegistry = registryImageTagDto.remoteRegistry;
        if (remoteRegistry != null) {
            this.log.info("Invoking remote registry scanning for: {}", (Object)file.getPath());
            return this.getNeuVectorContainerScanReportFromRegistry(image, tag, remoteRegistry);
        }
        this.log.info("Invoking local scan for: {}", (Object)file.getPath());
        return this.getNeuVectorContainerScanReportFromLocal(image, tag);
    }

    RegistryImageTagDto getRegistryImageTag(String scanTarget) {
        String imageTagAndVersion;
        this.log.info("Extracting registry, image and tag from: {}", (Object)scanTarget);
        scanTarget = scanTarget.replace("container:", "");
        scanTarget = scanTarget.startsWith("/") ? scanTarget.substring(1) : scanTarget;
        RegistryImageTagDto registryImageTagDto = new RegistryImageTagDto();
        if (scanTarget.startsWith("http")) {
            String registryImageTag = scanTarget.replace("//", "/").substring(scanTarget.indexOf("/") + 1);
            registryImageTagDto.remoteRegistry = "http" + (scanTarget.contains("https") ? "s" : "") + "://" + registryImageTag.substring(0, registryImageTag.indexOf("/"));
            imageTagAndVersion = registryImageTag.substring(registryImageTag.indexOf("/") + 1);
        } else {
            imageTagAndVersion = scanTarget;
        }
        if (imageTagAndVersion.contains(":")) {
            registryImageTagDto.image = imageTagAndVersion.substring(0, imageTagAndVersion.indexOf(":"));
            registryImageTagDto.tag = imageTagAndVersion.substring(imageTagAndVersion.indexOf(":") + 1);
        } else {
            registryImageTagDto.image = imageTagAndVersion;
            registryImageTagDto.tag = "latest";
        }
        this.log.info("Extracted registry:{}, image:{}, tag:{}", new Object[]{registryImageTagDto.remoteRegistry, registryImageTagDto.image, registryImageTagDto.tag});
        return registryImageTagDto;
    }

    private String getNeuVectorContainerScanReportFromLocal(String imageName, String imageTag) {
        Image image = new Image(imageName, imageTag);
        NVScanner scanner = new NVScanner(this.nvScannerImage, this.nvRegistryURL, this.nvRegistryUser, this.nvRegistryPassword, this.nvMountPath, this.log);
        ScanRepoReportData scanReportData = Scanner.scanLocalImage(image, scanner, "");
        this.deleteDockerImagesByLabelKey();
        if (StringUtils.isNotEmpty(scanReportData.getError_message())) {
            throw new RuntimeException(scanReportData.getError_message());
        }
        return new GsonBuilder().setPrettyPrinting().create().toJson(scanReportData);
    }

    private String getNeuVectorContainerScanReportFromRegistry(String repository, String repositoryTag, String registryURL) {
        String regUser = this.imageRegistryUserName;
        String regPassword = this.imageRegistryUserPassword;
        Registry registry = new Registry(registryURL, regUser, regPassword, repository, repositoryTag);
        NVScanner scanner = new NVScanner(this.nvScannerImage, this.nvRegistryURL, this.nvRegistryUser, this.nvRegistryPassword, this.nvMountPath, this.log);
        ScanRepoReportData scanReportData = Scanner.scanRegistry(registry, scanner, "", true);
        this.deleteDockerImagesByLabelKey();
        if (StringUtils.isNotEmpty(scanReportData.getError_message())) {
            throw new RuntimeException(scanReportData.getError_message());
        }
        return new GsonBuilder().setPrettyPrinting().create().toJson(scanReportData);
    }

    private void deleteDockerImagesByLabelKey() {
        String errorMessage = Scanner.deleteDockerImagesByLabelKey(NEUVECTOR_IMAGE);
        if (errorMessage.length() > 0) {
            this.log.warn("Failed to delete Docker Image {}", (Object)errorMessage);
        }
    }

    public static class RegistryImageTagDto {
        String remoteRegistry;
        String image;
        String tag;
    }
}

