/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.DockerManifest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import zz.com.google.gson.Gson;
import zz.com.google.gson.JsonIOException;
import zz.com.google.gson.JsonParseException;
import zz.com.google.gson.JsonSyntaxException;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.de.schlichtherle.truezip.file.TFileInputStream;
import zz.de.schlichtherle.truezip.io.Paths;
import zz.org.apache.commons.lang3.StringUtils;

public class DockerUtils {
    public static final String WHITEOUT_PREFIX = ".wh.";

    static File findFirstFileByName(File[] files, String filename) {
        for (File file : files) {
            if (!file.getName().equals(filename)) continue;
            return file;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> parseDockerManifest(File manifestFile) {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new TFileInputStream(manifestFile), StandardCharsets.UTF_8);){
            String[] layers;
            LinkedList<String> dockerImageLayers = new LinkedList<String>();
            Gson gson = new Gson();
            DockerManifest[] manifest = gson.fromJson((Reader)reader, DockerManifest[].class);
            if (manifest != null && manifest.length > 0 && (layers = manifest[0].layers) != null) {
                for (String layer : layers) {
                    dockerImageLayers.addFirst(layer);
                }
            }
            List<String> list = Collections.unmodifiableList(dockerImageLayers);
            return list;
        }
        catch (FileNotFoundException e) {
            throw new JsonIOException("Unable to read docker manifest.", e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<File> getDockerLayers(File parent, List<String> layers) {
        LinkedList<File> dockerImageLayers = new LinkedList<File>();
        for (String layer : layers) {
            String layerDir = layer;
            if (layerDir.startsWith("/")) {
                layerDir = layerDir.substring(1);
            }
            if (layerDir.contains("/")) {
                layerDir = new Paths.Splitter('/', false).split(layer).getParentPath();
            }
            if (!StringUtils.isNotBlank(layerDir)) continue;
            dockerImageLayers.addLast(new TFile(parent, layerDir));
        }
        return dockerImageLayers;
    }

    public static boolean isDockerImage(List<? extends File> children) {
        File manifestJson = DockerUtils.findFirstFileByName(children.toArray(new File[children.size()]), "manifest.json");
        if (manifestJson == null) {
            return false;
        }
        try {
            return !DockerUtils.parseDockerManifest(manifestJson).isEmpty();
        }
        catch (IllegalStateException | JsonParseException e) {
            return false;
        }
    }

    public static boolean isRemoved(String path) {
        return new File(path).getName().startsWith(WHITEOUT_PREFIX);
    }

    public static List<File> sortChildren(List<File> children) {
        File manifestJson = DockerUtils.findFirstFileByName(children.toArray(new File[children.size()]), "manifest.json");
        if (manifestJson != null && manifestJson.isFile()) {
            return DockerUtils.listChildrenInManifestOrder(children, manifestJson);
        }
        return children;
    }

    private static List<File> listChildrenInManifestOrder(List<File> children, File manifestJson) {
        try {
            List<String> layers = DockerUtils.parseDockerManifest(manifestJson);
            File dockerBasedir = manifestJson.getParentFile();
            List<File> dockerLayers = DockerUtils.getDockerLayers(dockerBasedir, layers);
            dockerLayers.add(manifestJson);
            return dockerLayers;
        }
        catch (IllegalStateException | JsonSyntaxException e) {
            return children;
        }
    }
}

