/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileUtils;
import com.sonatype.insight.scan.file.ManifestFileReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import zz.de.schlichtherle.truezip.file.TFile;

public class GoLockFileReader
implements ManifestFileReader {
    private static final String PROJECT_HEADER = "[[projects]]";
    private static final String NAME_FIELD = "name = ";
    private static final String VERSION_FIELD = "version = ";

    @Override
    public List<String> readLines(TFile file) {
        ArrayList<String> lines = new ArrayList<String>();
        ListIterator<String> iterator = FileUtils.readLines(file).listIterator();
        while (iterator.hasNext()) {
            String dependency;
            String line = (String)iterator.next();
            if (!line.startsWith(PROJECT_HEADER) || (dependency = this.processProject(iterator)) == null) continue;
            lines.add(dependency);
        }
        return lines;
    }

    private String processProject(Iterator<String> iterator) {
        boolean endOfProject = false;
        String name = null;
        String version = null;
        while (iterator.hasNext() && !endOfProject) {
            String line = iterator.next().trim();
            if (line.startsWith(NAME_FIELD)) {
                name = this.readValue(line);
                continue;
            }
            if (line.startsWith(VERSION_FIELD)) {
                version = this.readValue(line);
                continue;
            }
            if (!line.isEmpty()) continue;
            endOfProject = true;
        }
        if (name != null && version != null) {
            return name + " " + version;
        }
        return null;
    }

    private String readValue(String line) {
        String[] tokens = line.split("=");
        if (tokens.length == 2) {
            String value = tokens[1];
            return value.replaceAll("\"", "");
        }
        return null;
    }
}

