/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.file.NpmManifestFileReader;
import com.sonatype.insight.scan.manifest.NpmDependencies;
import com.sonatype.insight.scan.manifest.NpmDependency;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.ObjectMapper;
import zz.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.org.apache.commons.lang3.StringUtils;

public class PnpmLockFileReader
implements NpmManifestFileReader {
    private static final Logger log = LoggerFactory.getLogger(PnpmLockFileReader.class);

    @Override
    public NpmDependencies read(TFile file, FileVisitor fileVisitor) {
        LinkedHashSet<NpmDependency> dependencies = new LinkedHashSet<NpmDependency>();
        try {
            JsonNode jsonNode = new ObjectMapper(new YAMLFactory()).readTree(file);
            HashMap<String, NpmDependency> npmDependencyByNameVersion = new HashMap<String, NpmDependency>();
            HashMap<String, List<String>> directByNameVersion = new HashMap<String, List<String>>();
            long lockFileVersion = this.getLockFileVersion(jsonNode);
            Iterator<Map.Entry<String, JsonNode>> packageIterator = jsonNode.path("packages").fields();
            while (packageIterator.hasNext()) {
                this.processPackage(npmDependencyByNameVersion, directByNameVersion, packageIterator.next(), lockFileVersion);
            }
            for (Map.Entry entry : npmDependencyByNameVersion.entrySet()) {
                for (String childNameVersion : (List)directByNameVersion.get(entry.getKey())) {
                    NpmDependency child = (NpmDependency)npmDependencyByNameVersion.get(childNameVersion);
                    if (child == null) {
                        log.debug("no dependency details found for specifier {} in manifest {}", (Object)childNameVersion, (Object)file);
                        continue;
                    }
                    ((NpmDependency)entry.getValue()).dependencies.add(child);
                }
            }
            JsonNode dependenciesNode = jsonNode.path("dependencies");
            this.processDependency(dependenciesNode, npmDependencyByNameVersion, file, dependencies);
            boolean scanDevAndOptDeps = NpmManifestFileReader.shouldScanDevAndOptDependencies(fileVisitor);
            if (scanDevAndOptDeps) {
                JsonNode optDeps = jsonNode.path("optionalDependencies");
                this.processDependency(optDeps, npmDependencyByNameVersion, file, dependencies);
                JsonNode devDeps = jsonNode.path("devDependencies");
                this.processDependency(devDeps, npmDependencyByNameVersion, file, dependencies);
            }
            if (dependencies.isEmpty()) {
                dependencies.addAll(npmDependencyByNameVersion.values());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
        return this.createNpmDependenciesFilteredByPackageJson(file, fileVisitor, dependencies);
    }

    private Long getLockFileVersion(JsonNode lockFileRoot) {
        return lockFileRoot.path("lockfileVersion").asLong();
    }

    private void processDependency(JsonNode node, Map<String, NpmDependency> npmDependencyByNameVersion, TFile file, Set<NpmDependency> dependencies) {
        if (!node.isMissingNode()) {
            Iterator<Map.Entry<String, JsonNode>> dependencyIterator = node.fields();
            while (dependencyIterator.hasNext()) {
                String[] nameVersion = this.getNameAndVersion(dependencyIterator.next());
                if (nameVersion == null) continue;
                String key = this.getFieldName(nameVersion);
                NpmDependency npmDependency = npmDependencyByNameVersion.get(key);
                if (npmDependency == null) {
                    log.debug("no dependency details found for specifier {} in manifest {}", (Object)key, (Object)file);
                    continue;
                }
                dependencies.add(npmDependency);
            }
        }
    }

    private void processPackage(Map<String, NpmDependency> npmDependencyByNameVersion, Map<String, List<String>> directByNameVersion, Map.Entry<String, JsonNode> packageEntry, long lockFileVersion) {
        String[] nameVersion = this.getNameAndVersion(packageEntry.getKey(), lockFileVersion);
        if (nameVersion == null) {
            return;
        }
        String key = this.getFieldName(nameVersion);
        npmDependencyByNameVersion.computeIfAbsent(key, k -> new NpmDependency(nameVersion[0], nameVersion[1]));
        List directs = directByNameVersion.computeIfAbsent(key, k -> new ArrayList());
        Iterator<Map.Entry<String, JsonNode>> dependencyIterator = packageEntry.getValue().path("dependencies").fields();
        while (dependencyIterator.hasNext()) {
            Map.Entry<String, JsonNode> dependencyEntry = dependencyIterator.next();
            String[] dependencyNameVersion = this.getNameAndVersion(dependencyEntry);
            if (dependencyNameVersion == null) continue;
            directs.add(this.getFieldName(dependencyNameVersion));
        }
    }

    private String[] getNameAndVersion(Map.Entry<String, JsonNode> fieldNameAndValue) {
        String packageId = NpmManifestFileReader.removeQuotes(fieldNameAndValue.getKey()).trim();
        JsonNode value = fieldNameAndValue.getValue();
        if (!value.isTextual()) {
            if (value.has("version") && value.path("version").isTextual()) {
                String version = this.getVersion(value.path("version").asText().trim());
                return new String[]{packageId, version};
            }
            log.debug("Unable to determine version for dependency {}.", fieldNameAndValue);
            return null;
        }
        String version = this.getVersion(fieldNameAndValue.getValue().asText().trim());
        if (StringUtils.isAnyBlank(packageId, version)) {
            log.debug("Unable to determine packageId and/or version for dependency {}.", fieldNameAndValue);
            return null;
        }
        return new String[]{packageId, version};
    }

    private String[] getNameAndVersion(String fieldName, long lockFileVersion) {
        String version;
        int parenthesisIndex;
        int lastAtIndex;
        int packageIdStartIndex = fieldName.startsWith("/") ? 1 : 0;
        int packageIdEndIndex = fieldName.lastIndexOf(47);
        if ((double)lockFileVersion >= 6.0 && (lastAtIndex = fieldName.lastIndexOf(64, (parenthesisIndex = fieldName.indexOf(40)) == -1 ? fieldName.length() : parenthesisIndex)) > packageIdStartIndex && lastAtIndex < fieldName.length() - 1) {
            packageIdEndIndex = lastAtIndex;
        }
        if (packageIdEndIndex == -1 || packageIdEndIndex == fieldName.length() - 1 || packageIdStartIndex >= packageIdEndIndex) {
            log.debug("Unable to determine packageId for package {}.", (Object)fieldName);
            return null;
        }
        String packageId = fieldName.substring(packageIdStartIndex, packageIdEndIndex);
        if (StringUtils.isAnyBlank(packageId, version = this.getVersion(fieldName.substring(packageIdEndIndex + 1)))) {
            log.debug("Unable to determine packageId and/or version for package {}.", (Object)fieldName);
            return null;
        }
        return new String[]{packageId, version};
    }

    private String getVersion(String input) {
        String[] version = input.split("[_(]");
        if (version.length > 0) {
            return version[0];
        }
        return input;
    }

    private String getFieldName(String[] nameVersion) {
        return "/" + nameVersion[0] + "/" + nameVersion[1];
    }
}

