/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file.ruby;

import com.sonatype.insight.scan.file.ruby.Section;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class RubyGemsFile {
    private final List<Section> sections = new ArrayList<Section>();

    private RubyGemsFile(List<String> fileContents) {
        ListIterator<String> iterator = fileContents.listIterator();
        while (iterator.hasNext()) {
            ArrayList<String> sectionLines = new ArrayList<String>();
            String header = null;
            boolean emptyLine = false;
            while (iterator.hasNext() && !emptyLine) {
                String line = iterator.next();
                if (line.equals("PATH") || line.equals("GIT") || line.equals("GEM")) {
                    header = line;
                    continue;
                }
                if (!line.equals("")) {
                    sectionLines.add(line);
                    continue;
                }
                Section section = Section.fromFileContents(header, sectionLines);
                if (section != null) {
                    this.sections.add(section);
                }
                emptyLine = true;
            }
        }
    }

    public static RubyGemsFile fromFileContents(List<String> fileContents) {
        return new RubyGemsFile(fileContents);
    }

    public List<Section> getSections() {
        return this.sections;
    }
}

