/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file.ruby;

import com.sonatype.insight.scan.manifest.RubyGemsDependency;
import java.util.ArrayList;
import java.util.List;

public class Section {
    public static final String PATH = "PATH";
    public static final String GIT = "GIT";
    public static final String GEM = "GEM";
    private final String header;
    private final List<RubyGemsDependency> dependencies = new ArrayList<RubyGemsDependency>();

    private Section(String header, List<String> dependencies) {
        this.header = header;
        this.addDependencies(dependencies);
    }

    public static Section fromFileContents(String header, List<String> dependencies) {
        if (header != null && (header.equals(PATH) || header.equals(GIT) || header.equals(GEM))) {
            return new Section(header, dependencies);
        }
        return null;
    }

    private void addDependencies(List<String> dependencyLines) {
        for (String line : dependencyLines) {
            RubyGemsDependency dependency = RubyGemsDependency.fromString(line);
            if (dependency == null) continue;
            this.dependencies.add(dependency);
        }
    }

    public String getHeader() {
        return this.header;
    }

    public List<RubyGemsDependency> getDependencies() {
        return this.dependencies;
    }
}

