/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.hash.internal.asm;

import com.sonatype.insight.scan.hash.internal.asm.ClassFileData;
import com.sonatype.insight.scan.hash.internal.asm.ClassFileDigest;
import com.sonatype.insight.scan.hash.internal.asm.DefaultAnnotationData;
import com.sonatype.insight.scan.hash.internal.asm.FieldMethodAnnotationData;
import com.sonatype.insight.scan.hash.internal.asm.InstructionData;
import com.sonatype.insight.scan.hash.internal.asm.ListPopulator;
import com.sonatype.insight.scan.hash.internal.asm.LocalVariableAnnotationData;
import com.sonatype.insight.scan.hash.internal.asm.MethodDataComparator;
import com.sonatype.insight.scan.hash.internal.asm.MethodLocalVariableData;
import com.sonatype.insight.scan.hash.internal.asm.MethodParameterData;
import com.sonatype.insight.scan.hash.internal.asm.MethodTryCatchBlockData;
import com.sonatype.insight.scan.hash.internal.asm.ParameterAnnotationData;
import com.sonatype.insight.scan.hash.internal.asm.TypeAnnotationData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import zz.org.objectweb.asm.v71.Label;

class MethodData
implements ClassFileData {
    static final Comparator<MethodData> COMPARATOR = new MethodDataComparator();
    final int index;
    final int access;
    final String name;
    final String descriptor;
    final String signature;
    final String[] exceptions;
    private Integer maxStack;
    private Integer maxLocals;
    private DefaultAnnotationData annotationDefault;
    final List<MethodParameterData> parameters = new ArrayList<MethodParameterData>();
    final List<InstructionData> instructions = new ArrayList<InstructionData>();
    final List<MethodLocalVariableData> localVariables = new ArrayList<MethodLocalVariableData>();
    final List<MethodTryCatchBlockData> tryCatchBlocks = new ArrayList<MethodTryCatchBlockData>();
    final List<Label> asm71Labels = new ArrayList<Label>();
    final List<zz.org.objectweb.asm.Label> labels = new ArrayList<zz.org.objectweb.asm.Label>();
    final ListPopulator<FieldMethodAnnotationData> annotations = new ListPopulator<FieldMethodAnnotationData>(FieldMethodAnnotationData.COMPARATOR);
    final ListPopulator<TypeAnnotationData> typeAnnotations = new ListPopulator<TypeAnnotationData>(TypeAnnotationData.COMPARATOR);
    final ListPopulator<ParameterAnnotationData> parameterAnnotations = new ListPopulator<ParameterAnnotationData>(ParameterAnnotationData.COMPARATOR);
    final ListPopulator<TypeAnnotationData> tryCatchAnnotations = new ListPopulator<TypeAnnotationData>(TypeAnnotationData.COMPARATOR);
    final ListPopulator<LocalVariableAnnotationData> localVariableAnnotations = new ListPopulator<LocalVariableAnnotationData>(LocalVariableAnnotationData.COMPARATOR);
    final ListPopulator<TypeAnnotationData> insnAnnotations = new ListPopulator<TypeAnnotationData>(TypeAnnotationData.COMPARATOR);

    MethodData(int access, String name, String descriptor, String signature, int index, String ... exceptions) {
        this.access = access;
        this.name = name;
        this.descriptor = descriptor;
        this.signature = signature;
        this.exceptions = exceptions;
        this.index = index;
    }

    void addParameter(String name, int access) {
        this.parameters.add(new MethodParameterData(name, access));
    }

    void setMaxs(int maxStack, int maxLocals) {
        this.maxStack = maxStack;
        this.maxLocals = maxLocals;
    }

    void addInstruction(int opcode, Object ... operands) {
        this.instructions.add(new InstructionData(opcode, operands));
    }

    void addTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.tryCatchBlocks.add(new MethodTryCatchBlockData(start, end, handler, type));
    }

    void addTryCatchBlock(zz.org.objectweb.asm.Label start, zz.org.objectweb.asm.Label end, zz.org.objectweb.asm.Label handler, String type) {
        this.tryCatchBlocks.add(new MethodTryCatchBlockData(start, end, handler, type));
    }

    void addLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
        this.localVariables.add(new MethodLocalVariableData(name, descriptor, signature, start, end, index));
    }

    void addLocalVariable(String name, String descriptor, String signature, zz.org.objectweb.asm.Label start, zz.org.objectweb.asm.Label end, int index) {
        this.localVariables.add(new MethodLocalVariableData(name, descriptor, signature, start, end, index));
    }

    void addLabel(Label label) {
        this.asm71Labels.add(label);
    }

    void addLabel(zz.org.objectweb.asm.Label label) {
        this.labels.add(label);
    }

    DefaultAnnotationData setAnnotationDefault(DefaultAnnotationData annotationData) {
        this.annotationDefault = annotationData;
        return this.annotationDefault;
    }

    TypeAnnotationData addTypeAnnotation(TypeAnnotationData annotationData) {
        return this.typeAnnotations.add(annotationData);
    }

    ParameterAnnotationData addParameterAnnotation(ParameterAnnotationData annotationData) {
        return this.parameterAnnotations.add(annotationData);
    }

    TypeAnnotationData addTryCatchAnnotation(TypeAnnotationData annotationData) {
        return this.tryCatchAnnotations.add(annotationData);
    }

    LocalVariableAnnotationData addLocalVariableAnnotation(LocalVariableAnnotationData annotationData) {
        return this.localVariableAnnotations.add(annotationData);
    }

    FieldMethodAnnotationData addAnnotation(FieldMethodAnnotationData annotationData) {
        return this.annotations.add(annotationData);
    }

    TypeAnnotationData addInsnAnnotation(TypeAnnotationData annotationData) {
        return this.insnAnnotations.add(annotationData);
    }

    @Override
    public void digest(ClassFileDigest digester) {
        digester.putAccess(this.access);
        digester.putString(this.name);
        digester.putString(this.descriptor);
        digester.putString(this.signature);
        digester.putStringsSorted(this.exceptions);
        digester.putShort(this.maxStack);
        digester.putShort(this.maxLocals);
        digester.putData(this.parameters);
        digester.putData(this.instructions);
        digester.putData(this.localVariables);
        digester.putData(this.tryCatchBlocks);
        digester.putObjects(this.asm71Labels.toArray());
        digester.putObjects(this.labels.toArray());
        digester.putData(this.annotations);
        digester.putData(this.annotationDefault);
        digester.putData(this.typeAnnotations);
        digester.putData(this.parameterAnnotations);
        digester.putData(this.tryCatchAnnotations);
        digester.putData(this.localVariableAnnotations);
        digester.putData(this.insnAnnotations);
    }
}

