/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.hash.internal.asm;

import com.sonatype.insight.scan.hash.internal.asm.ClassFileData;
import com.sonatype.insight.scan.hash.internal.asm.ClassFileDigest;
import com.sonatype.insight.scan.hash.internal.asm.DataDigestUtils;
import com.sonatype.insight.scan.hash.internal.asm.ListPopulator;
import com.sonatype.insight.scan.hash.internal.asm.ModuleProvideData;
import com.sonatype.insight.scan.hash.internal.asm.ModuleValueData;

class ModuleData
implements ClassFileData {
    private final String name;
    private final int access;
    private final String version;
    private String mainClass;
    private final ListPopulator<String> packageNames = new ListPopulator<String>(DataDigestUtils.DUPLICATABLE_STRING_COMPARATOR);
    private final ListPopulator<ModuleValueData> requires = new ListPopulator<ModuleValueData>(ModuleValueData.COMPARATOR);
    private final ListPopulator<ModuleValueData> exportedPackages = new ListPopulator<ModuleValueData>(ModuleValueData.COMPARATOR);
    private final ListPopulator<ModuleValueData> openPackages = new ListPopulator<ModuleValueData>(ModuleValueData.COMPARATOR);
    private final ListPopulator<String> uses = new ListPopulator<String>(DataDigestUtils.DUPLICATABLE_STRING_COMPARATOR);
    private final ListPopulator<ModuleProvideData> provides = new ListPopulator<ModuleProvideData>(ModuleProvideData.COMPARATOR);

    ModuleData(String name, int access, String version) {
        this.name = name;
        this.access = access;
        this.version = version;
    }

    void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    void addPackageName(String packageName) {
        this.packageNames.add(packageName);
    }

    void addRequire(String module, int access, String version) {
        this.requires.add(new ModuleValueData(module, version, access));
    }

    void addExport(String packageName, int access, String ... modules) {
        this.exportedPackages.add(new ModuleValueData(packageName, access, modules));
    }

    void addOpen(String packageName, int access, String ... modules) {
        this.openPackages.add(new ModuleValueData(packageName, access, modules));
    }

    void addUse(String service) {
        this.uses.add(service);
    }

    void addProvide(String service, String ... providers) {
        this.provides.add(new ModuleProvideData(service, providers));
    }

    @Override
    public void digest(ClassFileDigest digester) {
        digester.putString(this.name);
        digester.putAccess(this.access);
        digester.putString(this.version);
        digester.putString(this.mainClass);
        digester.putStrings(this.packageNames);
        digester.putData(this.requires);
        digester.putData(this.exportedPackages);
        digester.putData(this.openPackages);
        digester.putStrings(this.uses);
        digester.putData(this.provides);
    }
}

