/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.manifest;

import com.sonatype.insight.scan.manifest.ConanDependency;
import com.sonatype.insight.scan.manifest.ConanDependencyCategory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ConanFile {
    public final List<ConanDependency> requires = new ArrayList<ConanDependency>();
    public final List<ConanDependency> buildRequires = new ArrayList<ConanDependency>();
    public final List<ConanDependency> fullRequires = new ArrayList<ConanDependency>();
    public final List<String> generators = new ArrayList<String>();
    public final List<String> options = new ArrayList<String>();
    public final List<String> imports = new ArrayList<String>();
    private static final List<ConanDependencyCategory> DEPENDENCY_CATEGORIES_TO_IGNORE = Arrays.asList(ConanDependencyCategory.FULL_OPTIONS, ConanDependencyCategory.FULL_SETTINGS, ConanDependencyCategory.SETTINGS, ConanDependencyCategory.ENV, ConanDependencyCategory.RECIPE_HASH);

    public static ConanFile fromFileContents(List<String> fileContents) {
        return new ConanFile(fileContents);
    }

    private ConanFile(List<String> contents) {
        ConanDependencyCategory currentContentCategory = null;
        for (String line : contents) {
            ConanDependencyCategory contentCategory = ConanDependencyCategory.fromString(line);
            if (contentCategory != null) {
                currentContentCategory = contentCategory;
                continue;
            }
            if (DEPENDENCY_CATEGORIES_TO_IGNORE.contains((Object)currentContentCategory)) continue;
            this.resolveDependency(currentContentCategory, line);
        }
        this.removeDuplicatedComponents(this.requires, this.fullRequires);
    }

    private void resolveDependency(ConanDependencyCategory contentCategory, String line) {
        if (contentCategory != null) {
            if (ConanDependencyCategory.REQUIRES.equals((Object)contentCategory)) {
                this.addDependencySafely(this.requires, ConanDependency.fromString(line));
            }
            if (ConanDependencyCategory.BUILD_REQUIRES.equals((Object)contentCategory)) {
                this.addDependencySafely(this.buildRequires, ConanDependency.fromString(line));
            }
            if (ConanDependencyCategory.GENERATORS.equals((Object)contentCategory)) {
                this.addElementIfNotExist(line, this.generators);
            }
            if (ConanDependencyCategory.OPTIONS.equals((Object)contentCategory)) {
                this.addElementIfNotExist(line, this.options);
            }
            if (ConanDependencyCategory.IMPORTS.equals((Object)contentCategory)) {
                this.addElementIfNotExist(line, this.imports);
            }
            if (ConanDependencyCategory.FULL_REQUIRES.equals((Object)contentCategory)) {
                this.addDependencySafely(this.fullRequires, ConanDependency.fromString(line));
            }
        }
    }

    private void addElementIfNotExist(String line, List<String> elements) {
        if (!elements.contains(line)) {
            elements.add(line);
        }
    }

    private void addDependencySafely(List<ConanDependency> dependencies, ConanDependency dependency) {
        if (dependency != null && !dependencies.contains(dependency)) {
            dependencies.add(dependency);
        }
    }

    private void removeDuplicatedComponents(List<ConanDependency> requires, List<ConanDependency> fullRequires) {
        requires.removeIf(dependency -> fullRequires.stream().anyMatch(fullDependency -> dependency.name.equals(fullDependency.name)));
    }
}

