/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.manifest;

public final class PythonRequirement {
    public String dependency;
    public String markers;
    public String options;

    public static PythonRequirement fromLine(String line) {
        PythonRequirement requirement = new PythonRequirement();
        if (line.charAt(0) == '-') {
            requirement.options = line;
        } else {
            int markersAt;
            int optionsAt = line.indexOf(" -");
            if (optionsAt > 0) {
                requirement.options = line.substring(optionsAt + 1);
                line = line.substring(0, optionsAt);
            }
            if ((markersAt = line.indexOf(59)) > 0) {
                requirement.markers = line.substring(markersAt + 1);
                requirement.dependency = line.substring(0, markersAt).trim();
            } else {
                requirement.dependency = line;
            }
        }
        return requirement;
    }

    public boolean isEmpty() {
        return this.dependency == null && this.options == null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.dependency != null) {
            result.append(this.dependency);
            if (this.markers != null) {
                result.append(';').append(this.markers);
            }
        }
        if (this.options != null) {
            if (result.length() > 0) {
                result.append(' ');
            }
            result.append(this.options);
        }
        return result.toString();
    }
}

