/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.manifest;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RubyGemsDependency {
    public static final Pattern DEPENDENCY_WITH_VERSION_PATTERN = Pattern.compile("^(.*?)(\\s\\()(=\\s)?(\\S+\\))$");
    private final String name;
    private final String version;
    private final int indentLevel;

    private RubyGemsDependency(String name, String version, int indentLevel) {
        this.name = name;
        this.version = version;
        this.indentLevel = indentLevel;
    }

    public static RubyGemsDependency fromString(String line) {
        Matcher matcher = DEPENDENCY_WITH_VERSION_PATTERN.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        int spaces = 0;
        for (char ch : line.toCharArray()) {
            if (!Character.isWhitespace(ch)) break;
            ++spaces;
        }
        String name = line.substring(0, line.indexOf("(")).trim();
        String version = line.substring(line.indexOf("(") + 1, line.indexOf(")"));
        if (version.startsWith("= ")) {
            version = version.substring(2);
        }
        return new RubyGemsDependency(name, version, spaces);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object otherObject) {
        if (otherObject == this) {
            return true;
        }
        if (!(otherObject instanceof RubyGemsDependency)) {
            return false;
        }
        RubyGemsDependency otherRubyGemsDependency = (RubyGemsDependency)otherObject;
        return Objects.equals(this.name, otherRubyGemsDependency.name) && Objects.equals(this.version, otherRubyGemsDependency.version);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.indentLevel; ++i) {
            sb.append(" ");
        }
        sb.append(this.getName()).append(" (");
        if (this.indentLevel > 4) {
            sb.append("= ");
        }
        sb.append(this.getVersion()).append(")");
        return sb.toString();
    }
}

