/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.manifest;

import java.util.Objects;

public class YumPackage {
    private final String name;
    private final String arch;
    private final String version;

    private YumPackage(String name, String arch, String version) {
        this.name = name;
        this.arch = arch;
        this.version = version;
    }

    public static YumPackage fromLine(String line) {
        if (line == null || line.isEmpty()) {
            return null;
        }
        String[] sections = line.split("\\s+");
        if (sections.length < 2) {
            return null;
        }
        String version = sections[1].trim();
        if (version.isEmpty()) {
            return null;
        }
        String nameAndArch = sections[0].trim();
        if (nameAndArch.isEmpty()) {
            return null;
        }
        int archSeparator = nameAndArch.lastIndexOf(".");
        if (archSeparator < 0) {
            return null;
        }
        String name = nameAndArch.substring(0, archSeparator);
        String arch = nameAndArch.substring(archSeparator + 1);
        return new YumPackage(name, arch, version);
    }

    public String getName() {
        return this.name;
    }

    public String getArch() {
        return this.arch;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object otherObject) {
        if (otherObject == this) {
            return true;
        }
        if (!(otherObject instanceof YumPackage)) {
            return false;
        }
        YumPackage otherYumPackage = (YumPackage)otherObject;
        return Objects.equals(this.name, otherYumPackage.name) && Objects.equals(this.arch, otherYumPackage.arch) && Objects.equals(this.version, otherYumPackage.version);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.arch, this.version);
    }

    public String toString() {
        return this.name + "." + this.arch + "\t" + this.version;
    }
}

