/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.tools.manifests.gradle.model;

import com.sonatype.insight.scan.tools.manifests.gradle.model.ExternalDependency;
import com.sonatype.insight.scan.tools.manifests.gradle.model.Property;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class BuildModel {
    private File buildFile;
    private List<ExternalDependency> dependencies = new LinkedList<ExternalDependency>();
    private List<Property> properties = new LinkedList<Property>();
    private Map<String, List<String>> configurationMap = new HashMap<String, List<String>>();
    private Set<String> compileScopeConfigurations = new HashSet<String>();

    public File getBuildFile() {
        return this.buildFile;
    }

    public void setBuildFile(File buildFile) {
        this.buildFile = buildFile;
    }

    public List<ExternalDependency> getDependencies() {
        return this.dependencies;
    }

    public void addDependency(ExternalDependency dependency) {
        this.dependencies.add(dependency);
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    public Map<String, List<String>> getConfigurationMap() {
        return this.configurationMap;
    }

    public void addConfigurationMapping(String key, String value) {
        this.configurationMap.computeIfAbsent(key, k -> new LinkedList()).add(value);
    }

    public boolean isCompileScopeConfiguration(String configuration) {
        return this.compileScopeConfigurations.contains(configuration);
    }

    public void addCompileScopeConfiguration(String compileScopeConfiguration) {
        this.compileScopeConfigurations.add(compileScopeConfiguration);
    }

    public boolean isEmpty() {
        return this.dependencies.isEmpty() && this.properties.isEmpty();
    }

    public List<ExternalDependency> getManagedDependencies() {
        if (null == this.dependencies) {
            return Collections.emptyList();
        }
        return this.dependencies.stream().filter(externalDependency -> externalDependency.getCallPath().endsWith("dependencies.constraints")).collect(Collectors.toList());
    }

    public List<ExternalDependency> getDirectDependencies() {
        if (null == this.dependencies) {
            return Collections.emptyList();
        }
        return this.dependencies.stream().filter(externalDependency -> externalDependency.getCallPath().endsWith("dependencies")).collect(Collectors.toList());
    }
}

