/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.tools.manifests.gradle.parser;

import com.sonatype.insight.scan.tools.manifests.gradle.model.BuildModel;
import com.sonatype.insight.scan.tools.manifests.gradle.model.Property;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesFileReader {
    private static final Pattern propertyDelimiter = Pattern.compile("[^\\\\][=:]");

    public BuildModel read(Path filePath) throws IOException {
        BuildModel model = new BuildModel();
        model.setBuildFile(filePath.toFile());
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath.toFile()));){
            String line;
            int lineNumber = 0;
            Property currentProperty = null;
            while ((line = reader.readLine()) != null) {
                ++lineNumber;
                int lineLength = line.length();
                if (!line.isEmpty()) {
                    line = line.replaceAll("^\\s+", "");
                }
                if (line.isEmpty() || line.startsWith("#") || line.startsWith("!")) continue;
                Matcher matcher = propertyDelimiter.matcher(line);
                if (matcher.find()) {
                    currentProperty = this.createNewProperty(line, matcher.start() + 1, model, lineNumber, lineLength, currentProperty);
                    continue;
                }
                if (currentProperty == null) continue;
                this.addToCurrentProperty(currentProperty, line, lineNumber, lineLength);
            }
            if (currentProperty != null) {
                model.addProperty(currentProperty);
            }
        }
        return model;
    }

    private void addToCurrentProperty(Property previousProperty, String line, int lineNumber, int lineLength) {
        String rightExpression = this.trimStringValue(line);
        previousProperty.setValue(previousProperty.getValue() + rightExpression);
        previousProperty.setLastLineNumber(lineNumber);
        previousProperty.setLastColumnNumber(lineLength + 1);
    }

    private Property createNewProperty(String line, int index, BuildModel model, int lineNumber, int lineLength, Property previousProperty) {
        if (previousProperty != null) {
            model.addProperty(previousProperty);
        }
        Property property = new Property(model);
        String leftExpression = line.substring(0, index).trim();
        String rightExpression = this.trimStringValue(line.substring(index + 1));
        property.setName(leftExpression);
        property.setValue(rightExpression);
        property.setCallPath("");
        property.setLineNumber(lineNumber);
        property.setColumnNumber(1);
        property.setLastLineNumber(lineNumber);
        property.setLastColumnNumber(lineLength + 1);
        if (!line.endsWith("\\")) {
            model.addProperty(property);
            return null;
        }
        return property;
    }

    private String trimStringValue(String input) {
        return input.replaceAll("^\\s+", "").replaceAll("\\\\$", "");
    }
}

