/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.git.utils.api;

import com.sonatype.nexus.git.utils.api.NativeGitCommands;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.org.apache.commons.lang3.StringUtils;
import zz.org.zeroturnaround.exec.InvalidExitValueException;
import zz.org.zeroturnaround.exec.ProcessExecutor;
import zz.org.zeroturnaround.exec.ProcessResult;

public class NativeGitUtils {
    public static final int DEFAULT_TIMEOUT_IN_SECONDS = 60;
    static final boolean IS_OS_WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private static final Logger log = LoggerFactory.getLogger(NativeGitUtils.class);
    private static final List<String> WINDOWS_SHELL = Arrays.asList("cmd.exe", "/c");
    private static final List<String> LINUX_SHELL = Arrays.asList("/bin/sh", "-c");

    private NativeGitUtils() {
    }

    public static boolean isNativeGitAvailable(String gitExecutable) {
        return NativeGitUtils.isNativeGitAvailable(60, Optional.ofNullable(gitExecutable).orElse("git"));
    }

    public static boolean isNativeGitAvailable(int timeout, String gitExecutable) {
        try {
            NativeGitUtils.exec(timeout, gitExecutable, NativeGitCommands.VERSION.getCommands());
            NativeGitUtils.determineExecPath(timeout, gitExecutable);
            return true;
        }
        catch (InvalidExitValueException e) {
            log.debug("Check for native git failed: " + e.getMessage());
            return false;
        }
        catch (Exception e) {
            log.error("Unable to determine if native git is available", (Throwable)e);
            return false;
        }
    }

    private static void determineExecPath(int timeout, String gitExecutable) {
        try {
            NativeGitUtils.exec(timeout, gitExecutable, NativeGitCommands.EXEC_PATH.getCommands());
        }
        catch (InvalidExitValueException e) {
            log.error("Unexpected exit value ascertaining git exec path", (Throwable)e);
        }
        catch (IOException | InterruptedException | TimeoutException e) {
            log.error("Unable to determine exec path of git", (Throwable)e);
        }
    }

    private static void exec(int timeout, String gitExecutable, List<String> args) throws IOException, InterruptedException, TimeoutException {
        List<String> command = NativeGitUtils.createCommandList(IS_OS_WINDOWS, gitExecutable, args);
        ProcessResult result = new ProcessExecutor().command(command).timeout(timeout, TimeUnit.SECONDS).exitValue(0).readOutput(true).execute();
        log.debug("output of '{}': {}", (Object)String.join((CharSequence)" ", command), (Object)result.outputUTF8().trim());
    }

    static List<String> createCommandList(boolean isOSWindows, String gitExecutable, List<String> args) {
        if (gitExecutable == null) {
            gitExecutable = "git";
        }
        StringJoiner joiner = new StringJoiner(" ", NativeGitUtils.wrap(isOSWindows), NativeGitUtils.wrap(isOSWindows));
        joiner.add(NativeGitUtils.wrapQuotesIfNeeded(gitExecutable));
        for (String arg : args) {
            joiner.add(NativeGitUtils.wrapQuotesIfNeeded(arg));
        }
        ArrayList<String> commandParts = new ArrayList<String>(isOSWindows ? WINDOWS_SHELL : LINUX_SHELL);
        commandParts.add(joiner.toString());
        return commandParts;
    }

    private static String wrapQuotesIfNeeded(String s) {
        if (StringUtils.isBlank(s)) {
            return s;
        }
        if (s.length() >= 2 && s.startsWith("\"") && s.endsWith("\"")) {
            return s;
        }
        if (s.contains("\"")) {
            throw new IllegalArgumentException("Command arguments cannot contain double quotes: " + s);
        }
        if (s.contains(" ")) {
            return String.valueOf('\"') + s + '\"';
        }
        return s;
    }

    private static String wrap(boolean isOsWindows) {
        return isOsWindows ? "\"" : "";
    }
}

