/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.git.utils.commit;

import com.sonatype.nexus.git.utils.Environment;
import com.sonatype.nexus.git.utils.commit.AggregateCommitHashFinder;
import com.sonatype.nexus.git.utils.commit.CommitHashFinder;
import com.sonatype.nexus.git.utils.commit.EnvironmentVariableCommitHashFinder;
import com.sonatype.nexus.git.utils.commit.JGitCommitHashFinder;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import zz.org.apache.commons.lang3.StringUtils;

public class CommitHashFinderBuilder {
    final Environment environment = new Environment();
    final List<CommitHashFinder> finders = new LinkedList<CommitHashFinder>();
    String fallback;
    Logger logger;

    public CommitHashFinderBuilder withEnvironmentVariableDefault() {
        this.finders.add(new EnvironmentVariableCommitHashFinder(this.environment));
        return this;
    }

    public CommitHashFinderBuilder withEnvironmentVariableNamed(String variableName) {
        this.finders.add(new EnvironmentVariableCommitHashFinder(this.environment, variableName));
        return this;
    }

    public CommitHashFinderBuilder withGitRepo() {
        this.finders.add(new JGitCommitHashFinder());
        return this;
    }

    public CommitHashFinderBuilder withGitRepoAtPath(String path) {
        this.finders.add(new JGitCommitHashFinder(path));
        return this;
    }

    public CommitHashFinderBuilder withFallBack(String fallbackCommitHash) {
        this.fallback = fallbackCommitHash;
        return this;
    }

    public CommitHashFinder build() {
        if (StringUtils.isBlank(this.fallback) && this.finders.size() == 1) {
            return this.finders.get(0);
        }
        return new AggregateCommitHashFinder(this.fallback, this.logger, this.finders.toArray(new CommitHashFinder[0]));
    }

    public CommitHashFinderBuilder withEnvironmentOverride(Map<String, String> environmentOverride) {
        this.environment.addEnvironmentOverrides(environmentOverride);
        return this;
    }

    public CommitHashFinderBuilder withLogger(Logger logger) {
        this.logger = logger;
        return this;
    }
}

