/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.dataformat.xml.ser;

import java.io.Serializable;
import java.util.List;
import zz.com.fasterxml.jackson.databind.AnnotationIntrospector;
import zz.com.fasterxml.jackson.databind.BeanDescription;
import zz.com.fasterxml.jackson.databind.JsonSerializer;
import zz.com.fasterxml.jackson.databind.PropertyName;
import zz.com.fasterxml.jackson.databind.SerializationConfig;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import zz.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import zz.com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import zz.com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import zz.com.fasterxml.jackson.dataformat.xml.ser.XmlBeanPropertyWriter;
import zz.com.fasterxml.jackson.dataformat.xml.ser.XmlBeanSerializer;
import zz.com.fasterxml.jackson.dataformat.xml.ser.XmlBeanSerializerBase;
import zz.com.fasterxml.jackson.dataformat.xml.util.AnnotationUtil;
import zz.com.fasterxml.jackson.dataformat.xml.util.TypeUtil;
import zz.com.fasterxml.jackson.dataformat.xml.util.XmlInfo;

public class XmlBeanSerializerModifier
extends BeanSerializerModifier
implements Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        int len = beanProperties.size();
        for (int i = 0; i < len; ++i) {
            BeanPropertyWriter bpw = beanProperties.get(i);
            AnnotatedMember member = bpw.getMember();
            String ns = AnnotationUtil.findNamespaceAnnotation(config, intr, member);
            Boolean isAttribute = AnnotationUtil.findIsAttributeAnnotation(config, intr, member);
            Boolean isText = AnnotationUtil.findIsTextAnnotation(config, intr, member);
            Boolean isCData = AnnotationUtil.findIsCDataAnnotation(config, intr, member);
            bpw.setInternalSetting(XmlBeanSerializerBase.KEY_XML_INFO, new XmlInfo(isAttribute, ns, isText, isCData));
            if (!TypeUtil.isIndexedType(bpw.getType())) continue;
            PropertyName wrappedName = PropertyName.construct(bpw.getName(), ns);
            PropertyName wrapperName = bpw.getWrapperName();
            if (wrapperName == null || wrapperName == PropertyName.NO_NAME) continue;
            String localName = wrapperName.getSimpleName();
            if (localName == null || localName.length() == 0) {
                wrapperName = wrappedName;
            }
            beanProperties.set(i, new XmlBeanPropertyWriter(bpw, wrapperName, wrappedName));
        }
        return beanProperties;
    }

    @Override
    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
        if (!(serializer instanceof BeanSerializerBase)) {
            return serializer;
        }
        return new XmlBeanSerializer((BeanSerializerBase)serializer);
    }
}

