/*
 * Decompiled with CFR 0.152.
 */
package zz.com.googlecode.javaewah32.symmetric;

import zz.com.googlecode.javaewah32.IteratingBufferedRunningLengthWord32;
import zz.com.googlecode.javaewah32.symmetric.UpdateableBitmapFunction32;

public final class EWAHPointer32
implements Comparable<EWAHPointer32> {
    private int endrun;
    private final int pos;
    private boolean isLiteral;
    private boolean value;
    private boolean dead = false;
    public final IteratingBufferedRunningLengthWord32 iterator;

    public EWAHPointer32(int previousEndRun, IteratingBufferedRunningLengthWord32 rw, int pos) {
        this.pos = pos;
        this.iterator = rw;
        if (this.iterator.getRunningLength() > 0) {
            this.endrun = previousEndRun + this.iterator.getRunningLength();
            this.isLiteral = false;
            this.value = this.iterator.getRunningBit();
        } else if (this.iterator.getNumberOfLiteralWords() > 0) {
            this.isLiteral = true;
            this.endrun = previousEndRun + this.iterator.getNumberOfLiteralWords();
        } else {
            this.endrun = previousEndRun;
            this.dead = true;
        }
    }

    public int endOfRun() {
        return this.endrun;
    }

    public int beginOfRun() {
        if (this.isLiteral) {
            return this.endrun - this.iterator.getNumberOfLiteralWords();
        }
        return this.endrun - this.iterator.getRunningLength();
    }

    public void parseNextRun() {
        if (this.isLiteral || this.iterator.getNumberOfLiteralWords() == 0) {
            this.iterator.discardFirstWords(this.iterator.size());
            if (this.iterator.getRunningLength() > 0) {
                this.endrun += this.iterator.getRunningLength();
                this.isLiteral = false;
                this.value = this.iterator.getRunningBit();
            } else if (this.iterator.getNumberOfLiteralWords() > 0) {
                this.isLiteral = true;
                this.endrun += this.iterator.getNumberOfLiteralWords();
            } else {
                this.dead = true;
            }
        } else {
            this.isLiteral = true;
            this.endrun += this.iterator.getNumberOfLiteralWords();
        }
    }

    public boolean hasNoData() {
        return this.dead;
    }

    public void callbackUpdate(UpdateableBitmapFunction32 f) {
        if (this.dead) {
            f.setZero(this.pos);
        } else if (this.isLiteral) {
            f.setLiteral(this.pos);
        } else if (this.value) {
            f.setOne(this.pos);
        } else {
            f.setZero(this.pos);
        }
    }

    @Override
    public int compareTo(EWAHPointer32 other) {
        return this.endrun - other.endrun;
    }
}

