/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema;

import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.networknt.schema.BaseJsonValidator;
import zz.com.networknt.schema.JsonSchema;
import zz.com.networknt.schema.JsonValidator;
import zz.com.networknt.schema.ValidationContext;
import zz.com.networknt.schema.ValidationMessage;
import zz.com.networknt.schema.ValidatorTypeCode;

public class ContainsValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(ContainsValidator.class);
    private final JsonSchema schema;

    public ContainsValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.CONTAINS, validationContext);
        this.schema = schemaNode.isObject() || schemaNode.isBoolean() ? new JsonSchema(validationContext, this.getValidatorType().getValue(), parentSchema.getCurrentUri(), schemaNode, parentSchema) : null;
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        if (!node.isArray()) {
            return Collections.emptySet();
        }
        if (node.size() == 0) {
            return this.buildErrorMessageSet(at);
        }
        if (node.isArray()) {
            int i = 0;
            for (JsonNode n : node) {
                if (this.schema.validate(n, rootNode, at + "[" + i + "]").isEmpty()) {
                    return Collections.emptySet();
                }
                ++i;
            }
            return this.buildErrorMessageSet(at);
        }
        return Collections.emptySet();
    }

    private Set<ValidationMessage> buildErrorMessageSet(String at) {
        return Collections.singleton(this.buildValidationMessage(at, this.schema.getSchemaNode().toString()));
    }

    @Override
    public void preloadJsonSchema() {
        if (null != this.schema) {
            this.schema.initializeValidators();
        }
    }
}

