/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.networknt.schema.BaseJsonValidator;
import zz.com.networknt.schema.CollectorContext;
import zz.com.networknt.schema.JsonSchema;
import zz.com.networknt.schema.JsonSchemaException;
import zz.com.networknt.schema.JsonValidator;
import zz.com.networknt.schema.ValidationContext;
import zz.com.networknt.schema.ValidationMessage;
import zz.com.networknt.schema.ValidatorTypeCode;

public class IfValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(IfValidator.class);
    private static final ArrayList<String> KEYWORDS = new ArrayList<String>(Arrays.asList("if", "then", "else"));
    private final JsonSchema ifSchema;
    private final JsonSchema thenSchema;
    private final JsonSchema elseSchema;

    public IfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.IF_THEN_ELSE, validationContext);
        JsonSchema foundIfSchema = null;
        JsonSchema foundThenSchema = null;
        JsonSchema foundElseSchema = null;
        for (String keyword : KEYWORDS) {
            JsonNode node = schemaNode.get(keyword);
            if (keyword.equals("if")) {
                foundIfSchema = new JsonSchema(validationContext, this.getValidatorType().getValue(), parentSchema.getCurrentUri(), node, parentSchema);
                continue;
            }
            if (keyword.equals("then") && node != null) {
                foundThenSchema = new JsonSchema(validationContext, this.getValidatorType().getValue(), parentSchema.getCurrentUri(), node, parentSchema);
                continue;
            }
            if (!keyword.equals("else") || node == null) continue;
            foundElseSchema = new JsonSchema(validationContext, this.getValidatorType().getValue(), parentSchema.getCurrentUri(), node, parentSchema);
        }
        this.ifSchema = foundIfSchema;
        this.thenSchema = foundThenSchema;
        this.elseSchema = foundElseSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        LinkedHashSet<ValidationMessage> errors;
        block16: {
            Object backupEvaluatedProperties;
            block15: {
                List backupEvaluatedPropertiesList;
                this.debug(logger, node, rootNode, at);
                backupEvaluatedProperties = CollectorContext.getInstance().get("zz.com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties");
                Object ifEvaluatedProperties = null;
                Object thenEvaluatedProperties = null;
                Object elseEvaluatedProperties = null;
                CollectorContext.getInstance().add("zz.com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", new ArrayList());
                errors = new LinkedHashSet<ValidationMessage>();
                boolean ifConditionPassed = false;
                try {
                    try {
                        ifConditionPassed = this.ifSchema.validate(node, rootNode, at).isEmpty();
                    }
                    catch (JsonSchemaException ex) {
                        ifConditionPassed = false;
                    }
                    ifEvaluatedProperties = CollectorContext.getInstance().get("zz.com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties");
                    if (ifConditionPassed && this.thenSchema != null) {
                        CollectorContext.getInstance().add("zz.com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", new ArrayList());
                        errors.addAll(this.thenSchema.validate(node, rootNode, at));
                        thenEvaluatedProperties = CollectorContext.getInstance().get("zz.com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties");
                    } else if (!ifConditionPassed && this.elseSchema != null) {
                        CollectorContext.getInstance().add("zz.com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", new ArrayList());
                        errors.addAll(this.elseSchema.validate(node, rootNode, at));
                        elseEvaluatedProperties = CollectorContext.getInstance().get("zz.com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties");
                    }
                    if (!errors.isEmpty()) break block15;
                    List list = backupEvaluatedPropertiesList = backupEvaluatedProperties == null ? new ArrayList() : (List)backupEvaluatedProperties;
                }
                catch (Throwable throwable) {
                    if (errors.isEmpty()) {
                        List backupEvaluatedPropertiesList2;
                        List list = backupEvaluatedPropertiesList2 = backupEvaluatedProperties == null ? new ArrayList() : (List)backupEvaluatedProperties;
                        if (ifEvaluatedProperties != null && ifConditionPassed) {
                            backupEvaluatedPropertiesList2.addAll((List)ifEvaluatedProperties);
                        }
                        if (thenEvaluatedProperties != null) {
                            backupEvaluatedPropertiesList2.addAll((List)thenEvaluatedProperties);
                        }
                        if (elseEvaluatedProperties != null) {
                            backupEvaluatedPropertiesList2.addAll((List)elseEvaluatedProperties);
                        }
                        CollectorContext.getInstance().add("zz.com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedPropertiesList2);
                    } else {
                        CollectorContext.getInstance().add("zz.com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedProperties);
                    }
                    throw throwable;
                }
                if (ifEvaluatedProperties != null && ifConditionPassed) {
                    backupEvaluatedPropertiesList.addAll((List)ifEvaluatedProperties);
                }
                if (thenEvaluatedProperties != null) {
                    backupEvaluatedPropertiesList.addAll((List)thenEvaluatedProperties);
                }
                if (elseEvaluatedProperties != null) {
                    backupEvaluatedPropertiesList.addAll((List)elseEvaluatedProperties);
                }
                CollectorContext.getInstance().add("zz.com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedPropertiesList);
                break block16;
            }
            CollectorContext.getInstance().add("zz.com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedProperties);
        }
        return Collections.unmodifiableSet(errors);
    }

    @Override
    public void preloadJsonSchema() {
        if (null != this.ifSchema) {
            this.ifSchema.initializeValidators();
        }
        if (null != this.thenSchema) {
            this.thenSchema.initializeValidators();
        }
        if (null != this.elseSchema) {
            this.elseSchema.initializeValidators();
        }
    }
}

