/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema;

import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.networknt.schema.BaseJsonValidator;
import zz.com.networknt.schema.JsonSchema;
import zz.com.networknt.schema.JsonValidator;
import zz.com.networknt.schema.ValidationContext;
import zz.com.networknt.schema.ValidationMessage;
import zz.com.networknt.schema.ValidatorTypeCode;

public class MaxItemsValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(MaxItemsValidator.class);
    private int max = 0;

    public MaxItemsValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.MAX_ITEMS, validationContext);
        if (schemaNode.canConvertToExactIntegral()) {
            this.max = schemaNode.intValue();
        }
        this.validationContext = validationContext;
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        if (node.isArray() ? node.size() > this.max : this.validationContext.getConfig().isTypeLoose() && 1 > this.max) {
            return Collections.singleton(this.buildValidationMessage(at, "" + this.max));
        }
        return Collections.emptySet();
    }
}

