/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema;

import java.util.Optional;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.networknt.schema.JsonMetaSchema;
import zz.com.networknt.schema.JsonSchemaException;
import zz.com.networknt.schema.JsonSchemaFactory;
import zz.com.networknt.schema.SpecVersion;

public final class SpecVersionDetector {
    private static final String SCHEMA_TAG = "$schema";

    private SpecVersionDetector() {
    }

    public static SpecVersion.VersionFlag detect(JsonNode jsonNode) {
        return SpecVersionDetector.detectOptionalVersion(jsonNode).orElseThrow(() -> new JsonSchemaException("'$schema' tag is not present"));
    }

    public static Optional<SpecVersion.VersionFlag> detectOptionalVersion(JsonNode jsonNode) {
        return Optional.ofNullable(jsonNode.get(SCHEMA_TAG)).map(schemaTag -> {
            boolean forceHttps = true;
            boolean removeEmptyFragmentSuffix = true;
            String schemaTagValue = schemaTag.asText();
            String schemaUri = JsonSchemaFactory.normalizeMetaSchemaUri(schemaTagValue, true, true);
            if (schemaUri.equals(JsonMetaSchema.getV4().getUri())) {
                return SpecVersion.VersionFlag.V4;
            }
            if (schemaUri.equals(JsonMetaSchema.getV6().getUri())) {
                return SpecVersion.VersionFlag.V6;
            }
            if (schemaUri.equals(JsonMetaSchema.getV7().getUri())) {
                return SpecVersion.VersionFlag.V7;
            }
            if (schemaUri.equals(JsonMetaSchema.getV201909().getUri())) {
                return SpecVersion.VersionFlag.V201909;
            }
            if (schemaUri.equals(JsonMetaSchema.getV202012().getUri())) {
                return SpecVersion.VersionFlag.V202012;
            }
            throw new JsonSchemaException("'" + schemaTagValue + "' is unrecognizable schema");
        });
    }
}

