/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.collections;

import java.util.Collections;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.converters.collections.MapConverter;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class SingletonMapConverter
extends MapConverter {
    private static final Class MAP = Collections.singletonMap(Boolean.TRUE, null).getClass();

    public SingletonMapConverter(Mapper mapper) {
        super(mapper);
    }

    public boolean canConvert(Class type) {
        return MAP == type;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        reader.moveDown();
        Object key = this.readCompleteItem(reader, context, null);
        Object value = this.readCompleteItem(reader, context, null);
        reader.moveUp();
        return Collections.singletonMap(key, value);
    }
}

