/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs;

import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.fs.FsArchiveEntry;
import zz.de.schlichtherle.truezip.fs.FsArchiveFileSystem;
import zz.de.schlichtherle.truezip.fs.FsBasicArchiveController;
import zz.de.schlichtherle.truezip.fs.FsLockModel;

@NotThreadSafe
abstract class FsFileSystemArchiveController<E extends FsArchiveEntry>
extends FsBasicArchiveController<E> {
    private MountState<E> mountState = new ResetFileSystem();

    FsFileSystemArchiveController(FsLockModel model) {
        super(model);
    }

    @Override
    final FsArchiveFileSystem<E> autoMount(boolean autoCreate) throws IOException {
        return this.mountState.autoMount(autoCreate);
    }

    @Nullable
    final FsArchiveFileSystem<E> getFileSystem() {
        return this.mountState.getFileSystem();
    }

    final void setFileSystem(@CheckForNull FsArchiveFileSystem<E> fileSystem) {
        this.mountState.setFileSystem(fileSystem);
    }

    abstract void mount(boolean var1) throws IOException;

    private final class MountedFileSystem
    implements MountState<E> {
        private final FsArchiveFileSystem<E> fileSystem;

        MountedFileSystem(FsArchiveFileSystem<E> fileSystem) {
            if (null == fileSystem) {
                throw new NullPointerException();
            }
            this.fileSystem = fileSystem;
        }

        @Override
        public FsArchiveFileSystem<E> autoMount(boolean autoCreate) {
            return this.fileSystem;
        }

        @Override
        public FsArchiveFileSystem<E> getFileSystem() {
            return this.fileSystem;
        }

        @Override
        public void setFileSystem(FsArchiveFileSystem<E> fileSystem) {
            if (null != fileSystem) {
                throw new IllegalArgumentException("File system already mounted!");
            }
            FsFileSystemArchiveController.this.mountState = new ResetFileSystem();
        }
    }

    private final class ResetFileSystem
    implements MountState<E> {
        private ResetFileSystem() {
        }

        @Override
        public FsArchiveFileSystem<E> autoMount(boolean autoCreate) throws IOException {
            FsFileSystemArchiveController.this.checkWriteLockedByCurrentThread();
            FsFileSystemArchiveController.this.mount(autoCreate);
            assert (this != FsFileSystemArchiveController.this.mountState);
            return FsFileSystemArchiveController.this.mountState.getFileSystem();
        }

        @Override
        public FsArchiveFileSystem<E> getFileSystem() {
            return null;
        }

        @Override
        public void setFileSystem(FsArchiveFileSystem<E> fileSystem) {
            if (fileSystem != null) {
                FsFileSystemArchiveController.this.mountState = new MountedFileSystem(fileSystem);
            }
        }
    }

    private static interface MountState<E extends FsArchiveEntry> {
        public FsArchiveFileSystem<E> autoMount(boolean var1) throws IOException;

        @Nullable
        public FsArchiveFileSystem<E> getFileSystem();

        public void setFileSystem(@CheckForNull FsArchiveFileSystem<E> var1);
    }
}

