/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.key.pbe.swing;

import java.awt.EventQueue;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.annotation.concurrent.ThreadSafe;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import zz.de.schlichtherle.truezip.awt.Windows;
import zz.de.schlichtherle.truezip.crypto.param.KeyStrength;
import zz.de.schlichtherle.truezip.key.KeyPromptingInterruptedException;
import zz.de.schlichtherle.truezip.key.PromptingKeyProvider;
import zz.de.schlichtherle.truezip.key.UnknownKeyException;
import zz.de.schlichtherle.truezip.key.pbe.SafePbeParameters;
import zz.de.schlichtherle.truezip.key.pbe.SafePbeParametersView;
import zz.de.schlichtherle.truezip.key.pbe.swing.BasicInvalidKeyFeedback;
import zz.de.schlichtherle.truezip.key.pbe.swing.BasicUnknownKeyFeedback;
import zz.de.schlichtherle.truezip.key.pbe.swing.InvalidKeyFeedback;
import zz.de.schlichtherle.truezip.key.pbe.swing.KeyStrengthPanel;
import zz.de.schlichtherle.truezip.key.pbe.swing.ReadKeyPanel;
import zz.de.schlichtherle.truezip.key.pbe.swing.UnknownKeyFeedback;
import zz.de.schlichtherle.truezip.key.pbe.swing.WriteKeyPanel;
import zz.de.schlichtherle.truezip.util.ServiceLocator;

@ThreadSafe
public abstract class SwingSafePbeParametersView<S extends KeyStrength, P extends SafePbeParameters<S, P>>
extends SafePbeParametersView<P> {
    private static final ResourceBundle resources = ResourceBundle.getBundle(SwingSafePbeParametersView.class.getName());
    static final URI INITIAL_RESOURCE = URI.create("");
    public static final int KEY_FILE_LEN = 512;
    private static final Map<URI, ReadKeyPanel> readKeyPanels = new WeakHashMap<URI, ReadKeyPanel>();
    private static final ServiceLocator serviceLocator = new ServiceLocator(SwingSafePbeParametersView.class.getClassLoader());
    static volatile URI lastResource = INITIAL_RESOURCE;
    private volatile UnknownKeyFeedback unknownKeyFeedback;
    private volatile InvalidKeyFeedback invalidKeyFeedback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] readKeyFile(File file) throws IOException {
        byte[] buf = new byte[512];
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        try {
            raf.readFully(buf);
        }
        finally {
            raf.close();
        }
        return buf;
    }

    UnknownKeyFeedback getUnknownKeyFeedback() {
        UnknownKeyFeedback uckf = this.unknownKeyFeedback;
        return null != uckf ? uckf : (this.unknownKeyFeedback = (UnknownKeyFeedback)serviceLocator.getService(UnknownKeyFeedback.class, BasicUnknownKeyFeedback.class));
    }

    void setUnkownKeyFeedback(UnknownKeyFeedback uckf) {
        this.unknownKeyFeedback = uckf;
    }

    InvalidKeyFeedback getInvalidKeyFeedback() {
        InvalidKeyFeedback ickf = this.invalidKeyFeedback;
        return null != ickf ? ickf : (this.invalidKeyFeedback = (InvalidKeyFeedback)serviceLocator.getService(InvalidKeyFeedback.class, BasicInvalidKeyFeedback.class));
    }

    void setInvalidKeyFeedback(InvalidKeyFeedback ickf) {
        this.invalidKeyFeedback = ickf;
    }

    @Override
    public void promptWriteKey(final PromptingKeyProvider.Controller<P> controller) throws UnknownKeyException {
        class PromptWriteKey
        implements Runnable {
            PromptWriteKey() {
            }

            @Override
            public void run() {
                SwingSafePbeParametersView.this.promptWriteKeyEDT(controller);
            }
        }
        SwingSafePbeParametersView.multiplexOnEDT(new PromptWriteKey());
    }

    private void promptWriteKeyEDT(PromptingKeyProvider.Controller<P> controller) {
        assert (EventQueue.isDispatchThread());
        URI resource = controller.getResource();
        assert (null != resource);
        SafePbeParameters param = (SafePbeParameters)controller.getKey();
        if (null == param) {
            param = this.newPbeParameters();
        }
        KeyStrengthPanel keyStrengthPanel = new KeyStrengthPanel(param.getKeyStrengthValues());
        keyStrengthPanel.setKeyStrength(param.getKeyStrength());
        WriteKeyPanel keyPanel = new WriteKeyPanel();
        keyPanel.setExtraDataUI((JComponent)((Object)keyStrengthPanel));
        Window parent = Windows.getParentWindow();
        while (!Thread.interrupted()) {
            keyPanel.setResource(resource);
            keyPanel.setFeedback(keyPanel.getError() != null ? this.getInvalidKeyFeedback() : this.getUnknownKeyFeedback());
            int result = JOptionPane.showConfirmDialog(parent, (Object)keyPanel, resources.getString("writeKeyDialog.title"), 2, 3);
            if (result != 0) break;
            if (keyPanel.updateParam(param)) {
                param.setKeyStrength(keyStrengthPanel.getKeyStrength());
                controller.setKey(param);
                break;
            }
            assert (keyPanel.getError() != null);
        }
    }

    @Override
    public void promptReadKey(final PromptingKeyProvider.Controller<P> controller, final boolean invalid) throws UnknownKeyException {
        class PromptReadKey
        implements Runnable {
            PromptReadKey() {
            }

            @Override
            public void run() {
                SwingSafePbeParametersView.this.promptReadKeyEDT(controller, invalid);
            }
        }
        SwingSafePbeParametersView.multiplexOnEDT(new PromptReadKey());
    }

    private void promptReadKeyEDT(PromptingKeyProvider.Controller<P> controller, boolean invalid) {
        ReadKeyPanel keyPanel;
        assert (EventQueue.isDispatchThread());
        URI resource = controller.getResource();
        assert (null != resource);
        Object param = this.newPbeParameters();
        if (invalid) {
            ReadKeyPanel panel = readKeyPanels.get(resource);
            keyPanel = panel != null ? panel : new ReadKeyPanel();
            keyPanel.setError(resources.getString("invalidKey"));
        } else {
            keyPanel = new ReadKeyPanel();
        }
        readKeyPanels.put(resource, keyPanel);
        Window parent = Windows.getParentWindow();
        while (!Thread.interrupted()) {
            keyPanel.setResource(resource);
            keyPanel.setFeedback(null != keyPanel.getError() ? this.getInvalidKeyFeedback() : this.getUnknownKeyFeedback());
            int result = JOptionPane.showConfirmDialog(parent, (Object)keyPanel, resources.getString("readKeyDialog.title"), 2, 3);
            if (result != 0) {
                controller.setKey(null);
                break;
            }
            if (keyPanel.updateParam((SafePbeParameters<?, ?>)param)) {
                controller.setKey(param);
                controller.setChangeRequested(keyPanel.isChangeKeySelected());
                break;
            }
            assert (keyPanel.getError() != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void multiplexOnEDT(Runnable task) throws UnknownKeyException {
        if (EventQueue.isDispatchThread()) {
            task.run();
            return;
        }
        Class<SwingSafePbeParametersView> clazz = SwingSafePbeParametersView.class;
        synchronized (SwingSafePbeParametersView.class) {
            try {
                EventQueue.invokeAndWait(task);
            }
            catch (InterruptedException interrupt) {
                throw new KeyPromptingInterruptedException(interrupt);
            }
            catch (InvocationTargetException failure) {
                throw new UnknownKeyException(failure);
            }
            return;
        }
    }
}

