/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.rof;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import zz.de.schlichtherle.truezip.rof.ReadOnlyFile;

@NotThreadSafe
public class IntervalReadOnlyFile
extends DecoratingReadOnlyFile {
    private final long offset;
    private final long length;
    private final boolean exclusive;
    private long fp;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public IntervalReadOnlyFile(@WillCloseWhenClosed ReadOnlyFile rof, long length) throws IOException {
        this(rof, rof.getFilePointer(), length, true);
    }

    @CreatesObligation
    public IntervalReadOnlyFile(@Nullable @WillNotClose ReadOnlyFile rof, long offset, long length) throws IOException {
        this(rof, offset, length, false);
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    private IntervalReadOnlyFile(@Nullable ReadOnlyFile rof, long offset, long length, boolean exclusive) throws IOException {
        super(rof);
        if (offset < 0L || length < 0L || rof.length() < offset + length) {
            throw new IllegalArgumentException();
        }
        this.offset = offset;
        this.length = length;
        this.exclusive = exclusive;
    }

    @Override
    public long length() throws IOException {
        long length = this.length;
        if (this.delegate.length() < this.offset + length) {
            throw new IOException("Read Only File has been changed!");
        }
        return length;
    }

    @Override
    public long getFilePointer() throws IOException {
        this.delegate.getFilePointer();
        return this.fp;
    }

    @Override
    public void seek(long fp) throws IOException {
        if (fp < 0L) {
            throw new IOException("File pointer must not be negative!");
        }
        long length = this.length;
        if (fp > length) {
            throw new IOException("File pointer (" + fp + ") is larger than file length (" + length + ")!");
        }
        this.delegate.seek(fp + this.offset);
        this.fp = fp;
    }

    @Override
    public int read() throws IOException {
        long fp = this.fp;
        if (fp >= this.length) {
            return -1;
        }
        if (!this.exclusive) {
            this.delegate.seek(fp + this.offset);
        }
        int read = this.delegate.read();
        this.fp = fp + 1L;
        return read;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (0 == len) {
            return 0;
        }
        if (0 > (off | len | buf.length - off - len)) {
            throw new IndexOutOfBoundsException();
        }
        long fp = this.fp;
        long length = this.length;
        if (fp + (long)len > length) {
            len = (int)(length - fp);
        }
        if (!this.exclusive) {
            this.delegate.seek(fp + this.offset);
        }
        int read = this.delegate.read(buf, off, len);
        if (0 == len) {
            assert (0 >= read);
            return -1;
        }
        assert (0 < read);
        this.fp = fp + (long)read;
        return read;
    }

    @Override
    public void close() throws IOException {
        if (this.exclusive) {
            this.delegate.close();
        }
    }
}

