/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.socket;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.rof.ReadOnlyFile;
import zz.de.schlichtherle.truezip.rof.ReadOnlyFileInputStream;
import zz.de.schlichtherle.truezip.socket.IOSocket;
import zz.de.schlichtherle.truezip.socket.OutputSocket;

@NotThreadSafe
public abstract class InputSocket<E extends Entry>
extends IOSocket<E, Entry> {
    @CheckForNull
    private OutputSocket<?> peer;

    @Override
    @Nullable
    public final Entry getPeerTarget() throws IOException {
        return null == this.peer ? null : (Entry)this.peer.getLocalTarget();
    }

    public final InputSocket<E> bind(InputSocket<?> to) {
        if (this == to) {
            throw new IllegalArgumentException();
        }
        this.peer = to.peer;
        return this;
    }

    final InputSocket<E> connect(@CheckForNull OutputSocket<?> newPeer) {
        OutputSocket<?> oldPeer = this.peer;
        if (oldPeer != newPeer) {
            if (null != oldPeer) {
                this.peer = null;
                oldPeer.connect(null);
            }
            if (null != newPeer) {
                this.peer = newPeer;
                newPeer.connect(this);
            }
        }
        return this;
    }

    @CreatesObligation
    public abstract ReadOnlyFile newReadOnlyFile() throws IOException;

    @CreatesObligation
    public SeekableByteChannel newSeekableByteChannel() throws IOException {
        throw new UnsupportedOperationException();
    }

    @CreatesObligation
    public InputStream newInputStream() throws IOException {
        return new ReadOnlyFileInputStream(this.newReadOnlyFile());
    }
}

