/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.util;

import java.net.URISyntaxException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.util.QuotedUriSyntaxException;

@NotThreadSafe
public final class UriDecoder {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final CharsetDecoder decoder;
    @CheckForNull
    private StringBuilder stringBuilder;

    public UriDecoder() {
        this(null);
    }

    public UriDecoder(@CheckForNull Charset charset) {
        if (null == charset) {
            charset = UTF8;
        }
        this.decoder = charset.newDecoder();
    }

    private static int dequote(CharBuffer eC) {
        if (eC.hasRemaining()) {
            char ec0 = eC.get();
            if (eC.hasRemaining()) {
                char ec1 = eC.get();
                return UriDecoder.dequote(ec0) << 4 | UriDecoder.dequote(ec1);
            }
        }
        return -1;
    }

    private static int dequote(char ec) {
        if ('0' <= ec && ec <= '9') {
            return ec - 48;
        }
        if ('A' <= (ec = (char)(ec & 0xFFFFFFDF)) && ec <= 'F') {
            return ec - 65 + 10;
        }
        return -1;
    }

    public String decode(String eS) {
        try {
            StringBuilder dS = this.decode(eS, null);
            return null != dS ? dS.toString() : eS;
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @CheckForNull
    public StringBuilder decode(String eS, @CheckForNull StringBuilder dS) throws URISyntaxException {
        CharBuffer eC = CharBuffer.wrap(eS);
        Buffer eB = null;
        CharBuffer dC = null;
        CharsetDecoder dec = null;
        while (true) {
            int ec;
            eC.mark();
            int n = ec = eC.hasRemaining() ? (int)eC.get() : -1;
            if (37 == ec) {
                int eb;
                if (null == eB) {
                    if (null == dS) {
                        dS = this.stringBuilder;
                        if (null == dS) {
                            dS = this.stringBuilder = new StringBuilder();
                        } else {
                            dS.setLength(0);
                        }
                        dS.append(eS, 0, eC.position() - 1);
                    }
                    int l = eC.remaining();
                    l = (l + 1) / 3;
                    eB = ByteBuffer.allocate(l);
                    dC = CharBuffer.allocate(l);
                    dec = this.decoder;
                }
                if ((eb = UriDecoder.dequote(eC)) < 0) {
                    throw new URISyntaxException(eS, "illegal escape sequence", eC.reset().position());
                }
                ((ByteBuffer)eB).put((byte)eb);
                continue;
            }
            if (null != eB && 0 < eB.position()) {
                ((ByteBuffer)eB).flip();
                CoderResult cr = dec.reset().decode((ByteBuffer)eB, dC, true);
                if (CoderResult.UNDERFLOW != cr || CoderResult.UNDERFLOW != (cr = dec.flush(dC))) {
                    assert (CoderResult.OVERFLOW != cr);
                    throw new QuotedUriSyntaxException((Object)eS, cr.toString());
                }
                ((ByteBuffer)eB).clear();
                dC.flip();
                dS.append(dC);
                dC.clear();
            }
            if (0 > ec) break;
            if (null == dS) continue;
            dS.append((char)ec);
        }
        return null == eB ? null : dS;
    }
}

