/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.zip;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.ZipException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.crypto.param.AesKeyStrength;
import zz.de.schlichtherle.truezip.io.DecoratingOutputStream;
import zz.de.schlichtherle.truezip.io.LEDataOutputStream;
import zz.de.schlichtherle.truezip.util.HashMaps;
import zz.de.schlichtherle.truezip.zip.CRC32Exception;
import zz.de.schlichtherle.truezip.zip.Constants;
import zz.de.schlichtherle.truezip.zip.Crc32OutputStream;
import zz.de.schlichtherle.truezip.zip.DecoratingOutputMethod;
import zz.de.schlichtherle.truezip.zip.OutputMethod;
import zz.de.schlichtherle.truezip.zip.RawZipFile;
import zz.de.schlichtherle.truezip.zip.UShort;
import zz.de.schlichtherle.truezip.zip.WinZipAesEntryExtraField;
import zz.de.schlichtherle.truezip.zip.WinZipAesEntryOutputStream;
import zz.de.schlichtherle.truezip.zip.WinZipAesEntryParameters;
import zz.de.schlichtherle.truezip.zip.WinZipAesParameters;
import zz.de.schlichtherle.truezip.zip.WinZipAesUtils;
import zz.de.schlichtherle.truezip.zip.ZipCryptoParameters;
import zz.de.schlichtherle.truezip.zip.ZipDeflaterOutputStream;
import zz.de.schlichtherle.truezip.zip.ZipEntry;
import zz.de.schlichtherle.truezip.zip.ZipOutputStreamParameters;
import zz.de.schlichtherle.truezip.zip.ZipParameters;
import zz.de.schlichtherle.truezip.zip.ZipParametersException;
import zz.de.schlichtherle.truezip.zip.ZipParametersProvider;
import zz.de.schlichtherle.truezip.zip.ZipParametersUtils;
import zz.org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

@NotThreadSafe
public abstract class RawZipOutputStream<E extends ZipEntry>
extends DecoratingOutputStream
implements Iterable<E> {
    private final LEDataOutputStream dos;
    private final Charset charset;
    private int method;
    private int level;
    @CheckForNull
    private byte[] comment;
    private final Map<String, E> entries;
    private long cdOffset;
    private boolean finished;
    @Nullable
    private ZipEntry entry;
    @Nullable
    private OutputMethod processor;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    protected RawZipOutputStream(@WillCloseWhenClosed OutputStream out, @CheckForNull @WillNotClose RawZipFile<E> appendee, ZipOutputStreamParameters param) {
        super(RawZipOutputStream.newLEDataOutputStream(out, appendee));
        this.dos = (LEDataOutputStream)this.delegate;
        if (null != appendee) {
            this.charset = appendee.getRawCharset();
            this.comment = appendee.getRawComment();
            LinkedHashMap<String, E> entries = new LinkedHashMap<String, E>(HashMaps.initialCapacity(appendee.size() + param.getOverheadSize()));
            entries.putAll(appendee.getRawEntries());
            this.entries = entries;
        } else {
            this.charset = param.getCharset();
            this.entries = new LinkedHashMap<String, E>(HashMaps.initialCapacity(param.getOverheadSize()));
        }
        this.setMethod0(param.getMethod());
        this.setLevel0(param.getLevel());
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    private static LEDataOutputStream newLEDataOutputStream(@WillCloseWhenClosed OutputStream out, @CheckForNull @WillNotClose RawZipFile<?> appendee) {
        if (null == out) {
            throw new NullPointerException();
        }
        return null != appendee ? new AppendingLEDataOutputStream(out, appendee) : (out instanceof LEDataOutputStream ? (LEDataOutputStream)out : new LEDataOutputStream(out));
    }

    private byte[] encode(String string) {
        return string.getBytes(this.charset);
    }

    private String decode(byte[] bytes) {
        return new String(bytes, this.charset);
    }

    public Charset getRawCharset() {
        return this.charset;
    }

    public String getCharset() {
        return this.charset.name();
    }

    public int size() {
        return this.entries.size();
    }

    @Deprecated
    public Enumeration<? extends ZipEntry> entries() {
        return Collections.enumeration(this.entries.values());
    }

    @Override
    public Iterator<E> iterator() {
        return Collections.unmodifiableCollection(this.entries.values()).iterator();
    }

    public E getEntry(String name) {
        return (E)((ZipEntry)this.entries.get(name));
    }

    @Nullable
    public String getComment() {
        byte[] comment = this.comment;
        return null == comment ? null : this.decode(comment);
    }

    public void setComment(@CheckForNull String comment) {
        if (null != comment && !comment.isEmpty()) {
            byte[] bytes = this.encode(comment);
            UShort.check(bytes.length);
            this.comment = bytes;
        } else {
            this.comment = null;
        }
    }

    public int getMethod() {
        return this.method;
    }

    public void setMethod(int method) {
        this.setMethod0(method);
    }

    private void setMethod0(int method) {
        ZipEntry test = new ZipEntry("");
        test.setMethod(method);
        this.method = test.getMethod();
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.setLevel0(level);
    }

    private void setLevel0(int level) {
        if ((level < 0 || 9 < level) && level != -1) {
            throw new IllegalArgumentException("Invalid compression level!");
        }
        this.level = level;
    }

    @CheckForNull
    protected abstract ZipCryptoParameters getCryptoParameters();

    public long length() {
        return this.dos.size();
    }

    public boolean isBusy() {
        return null != this.entry;
    }

    public final void putNextEntry(E entry) throws IOException {
        this.putNextEntry(entry, true);
    }

    public void putNextEntry(E entry, boolean process) throws ZipException, IOException {
        this.closeEntry();
        OutputMethod method = this.newOutputMethod((ZipEntry)entry, process);
        method.init(((ZipEntry)entry).clone());
        method.init((ZipEntry)entry);
        this.delegate = method.start();
        this.processor = method;
        this.entries.put(((ZipEntry)entry).getName(), entry);
        this.entry = entry;
    }

    private OutputMethod newOutputMethod(ZipEntry entry, boolean process) throws ZipException {
        OutputMethod processor = new RawOutputMethod(process);
        if (!process) {
            assert (-1L != entry.getCrc());
            return processor;
        }
        int method = entry.getMethod();
        if (-1 == method) {
            method = this.getMethod();
            entry.setRawMethod(method);
        }
        boolean skipCrc = false;
        if (entry.isEncrypted() || 99 == method) {
            ZipCryptoParameters param = this.getCryptoParameters();
            if (99 == method) {
                param = ZipParametersUtils.parameters(WinZipAesParameters.class, param);
                WinZipAesEntryExtraField field = (WinZipAesEntryExtraField)entry.getExtraField(39169);
                if (null != field) {
                    method = field.getMethod();
                    if (2 == field.getVendorVersion()) {
                        skipCrc = true;
                    }
                }
            }
            processor = this.newEncryptedOutputMethod((RawOutputMethod)processor, param);
        }
        switch (method) {
            case 0: {
                if (skipCrc) break;
                processor = new Crc32CheckingOutputMethod(processor);
                break;
            }
            case 8: {
                processor = new DeflaterOutputMethod(processor);
                if (skipCrc) break;
                processor = new Crc32UpdatingOutputMethod(processor);
                break;
            }
            case 12: {
                processor = new BZip2OutputMethod(processor);
                if (skipCrc) break;
                processor = new Crc32UpdatingOutputMethod(processor);
                break;
            }
            default: {
                throw new ZipException(entry.getName() + " (unsupported compression method " + method + ")");
            }
        }
        return processor;
    }

    private EncryptedOutputMethod newEncryptedOutputMethod(RawOutputMethod processor, @CheckForNull ZipParameters param) throws ZipParametersException {
        assert (null != processor);
        while (null != param) {
            if (param instanceof WinZipAesParameters) {
                return new WinZipAesOutputMethod(processor, (WinZipAesParameters)param);
            }
            if (!(param instanceof ZipParametersProvider)) break;
            param = ((ZipParametersProvider)param).get(ZipCryptoParameters.class);
        }
        throw new ZipParametersException("No suitable crypto parameters available!");
    }

    public void closeEntry() throws IOException {
        ZipEntry entry = this.entry;
        if (null == entry) {
            return;
        }
        this.processor.finish();
        this.delegate.flush();
        this.delegate = this.dos;
        this.processor = null;
        this.entry = null;
    }

    public void finish() throws IOException {
        if (this.finished) {
            return;
        }
        this.closeEntry();
        LEDataOutputStream dos = this.dos;
        this.cdOffset = dos.size();
        Iterator<E> i = this.entries.values().iterator();
        while (i.hasNext()) {
            if (this.writeCentralFileHeader((ZipEntry)i.next())) continue;
            i.remove();
        }
        this.writeEndOfCentralDirectory();
        this.finished = true;
    }

    private boolean writeCentralFileHeader(ZipEntry entry) throws IOException {
        long size;
        long csize = entry.getCompressedSize();
        if (-1L == (csize | (size = entry.getSize()))) {
            return false;
        }
        LEDataOutputStream dos = this.dos;
        dos.writeInt(33639248);
        dos.writeShort(entry.getRawPlatform() << 8 | 0x3F);
        dos.writeShort(entry.getRawVersionNeededToExtract());
        dos.writeShort(entry.getGeneralPurposeBitFlags());
        dos.writeShort(entry.getRawMethod());
        dos.writeInt((int)entry.getRawTime());
        dos.writeInt((int)entry.getRawCrc());
        dos.writeInt((int)entry.getRawCompressedSize());
        dos.writeInt((int)entry.getRawSize());
        byte[] name = this.encode(entry.getName());
        dos.writeShort(name.length);
        byte[] extra = entry.getRawExtraFields();
        dos.writeShort(extra.length);
        byte[] comment = this.getCommentEncoded(entry);
        dos.writeShort(comment.length);
        dos.writeShort(0);
        dos.writeShort(0);
        dos.writeInt((int)entry.getRawExternalAttributes());
        dos.writeInt((int)entry.getRawOffset());
        dos.write(name);
        dos.write(extra);
        dos.write(comment);
        return true;
    }

    private byte[] getCommentEncoded(ZipEntry entry) {
        return this.encode(entry.getRawComment());
    }

    private void writeEndOfCentralDirectory() throws IOException {
        boolean zip64;
        LEDataOutputStream dos = this.dos;
        long cdEntries = this.entries.size();
        long cdOffset = this.cdOffset;
        long cdSize = dos.size() - cdOffset;
        boolean cdEntriesZip64 = cdEntries > 65535L || Constants.FORCE_ZIP64_EXT;
        boolean cdSizeZip64 = cdSize > 0xFFFFFFFFL || Constants.FORCE_ZIP64_EXT;
        boolean cdOffsetZip64 = cdOffset > 0xFFFFFFFFL || Constants.FORCE_ZIP64_EXT;
        int cdEntries16 = cdEntriesZip64 ? 65535 : (int)cdEntries;
        long cdSize32 = cdSizeZip64 ? 0xFFFFFFFFL : cdSize;
        long cdOffset32 = cdOffsetZip64 ? 0xFFFFFFFFL : cdOffset;
        boolean bl = zip64 = cdEntriesZip64 || cdSizeZip64 || cdOffsetZip64;
        if (zip64) {
            long zip64eocdOffset = dos.size();
            dos.writeInt(101075792);
            dos.writeLong(44L);
            dos.writeShort(63);
            dos.writeShort(46);
            dos.writeInt(0);
            dos.writeInt(0);
            dos.writeLong(cdEntries);
            dos.writeLong(cdEntries);
            dos.writeLong(cdSize);
            dos.writeLong(cdOffset);
            dos.writeInt(117853008);
            dos.writeInt(0);
            dos.writeLong(zip64eocdOffset);
            dos.writeInt(1);
        }
        dos.writeInt(101010256);
        dos.writeShort(0);
        dos.writeShort(0);
        dos.writeShort(cdEntries16);
        dos.writeShort(cdEntries16);
        dos.writeInt((int)cdSize32);
        dos.writeInt((int)cdOffset32);
        byte[] comment = this.getRawComment();
        dos.writeShort(comment.length);
        dos.write(comment);
    }

    private byte[] getRawComment() {
        byte[] comment = this.comment;
        return null != comment ? comment : Constants.EMPTY;
    }

    @Override
    public void close() throws IOException {
        this.finish();
        this.delegate.close();
    }

    private final class Crc32UpdatingOutputMethod
    extends Crc32OutputMethod {
        Crc32UpdatingOutputMethod(OutputMethod processor) {
            super(processor);
        }

        @Override
        public void finish() throws IOException {
            ZipEntry entry = RawZipOutputStream.this.entry;
            long crc = this.out.getChecksum().getValue();
            entry.setRawCrc(crc);
            this.delegate.finish();
        }
    }

    private final class Crc32CheckingOutputMethod
    extends Crc32OutputMethod {
        Crc32CheckingOutputMethod(OutputMethod processor) {
            super(processor);
        }

        @Override
        public void finish() throws IOException {
            long actualCrc;
            this.delegate.finish();
            ZipEntry entry = RawZipOutputStream.this.entry;
            long expectedCrc = entry.getCrc();
            if (-1L != expectedCrc && expectedCrc != (actualCrc = this.out.getChecksum().getValue())) {
                throw new CRC32Exception(entry.getName(), expectedCrc, actualCrc);
            }
        }
    }

    private abstract class Crc32OutputMethod
    extends DecoratingOutputMethod {
        @Nullable
        Crc32OutputStream out;

        Crc32OutputMethod(OutputMethod processor) {
            super(processor);
        }

        @Override
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        public OutputStream start() throws IOException {
            assert (null == this.out);
            this.out = new Crc32OutputStream(this.delegate.start());
            return this.out;
        }

        @Override
        public abstract void finish() throws IOException;
    }

    private final class DeflaterOutputMethod
    extends DecoratingOutputMethod {
        @Nullable
        ZipDeflaterOutputStream out;
        @Nullable
        ZipEntry entry;

        DeflaterOutputMethod(OutputMethod processor) {
            super(processor);
        }

        @Override
        public void init(ZipEntry entry) throws ZipException {
            entry.setCompressedSize(-1L);
            this.delegate.init(entry);
            this.entry = entry;
        }

        @Override
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        public OutputStream start() throws IOException {
            assert (null == this.out);
            this.out = new ZipDeflaterOutputStream(this.delegate.start(), RawZipOutputStream.this.getLevel(), 8192);
            return this.out;
        }

        @Override
        public void finish() throws IOException {
            this.out.finish();
            Deflater deflater = this.out.getDeflater();
            ZipEntry entry = this.entry;
            entry.setRawSize(deflater.getBytesRead());
            deflater.end();
            this.delegate.finish();
        }
    }

    private final class BZip2OutputMethod
    extends DecoratingOutputMethod {
        @Nullable
        BZip2CompressorOutputStream cout;
        @Nullable
        LEDataOutputStream dout;
        @Nullable
        ZipEntry entry;

        BZip2OutputMethod(OutputMethod processor) {
            super(processor);
        }

        @Override
        public void init(ZipEntry entry) throws ZipException {
            entry.setCompressedSize(-1L);
            this.delegate.init(entry);
            this.entry = entry;
        }

        @Override
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        public OutputStream start() throws IOException {
            assert (null == this.cout);
            assert (null == this.dout);
            OutputStream out = this.delegate.start();
            long size = this.entry.getSize();
            int blockSize = -1L != size ? BZip2CompressorOutputStream.chooseBlockSize(size) : this.getBZip2BlockSize();
            this.cout = new BZip2CompressorOutputStream(out, blockSize);
            out = this.cout;
            this.dout = new LEDataOutputStream(out);
            return this.dout;
        }

        int getBZip2BlockSize() {
            int level = RawZipOutputStream.this.getLevel();
            if (1 <= level && level <= 9) {
                return level;
            }
            return 9;
        }

        @Override
        public void finish() throws IOException {
            this.dout.flush();
            this.cout.finish();
            this.entry.setRawSize(this.dout.size());
            this.delegate.finish();
        }
    }

    private final class WinZipAesOutputMethod
    extends EncryptedOutputMethod {
        final WinZipAesParameters generalParam;
        boolean suppressCrc;
        @Nullable
        WinZipAesEntryParameters entryParam;
        @Nullable
        WinZipAesEntryOutputStream out;
        @Nullable
        ZipEntry entry;

        WinZipAesOutputMethod(RawOutputMethod processor, WinZipAesParameters param) {
            super(processor);
            assert (null != param);
            this.generalParam = param;
        }

        @Override
        public void init(ZipEntry entry) throws ZipException {
            WinZipAesEntryParameters entryParam = new WinZipAesEntryParameters(this.generalParam, entry);
            AesKeyStrength keyStrength = entryParam.getKeyStrength();
            this.entryParam = entryParam;
            WinZipAesEntryExtraField field = null;
            int method = entry.getMethod();
            long csize = entry.getCompressedSize();
            if (99 == method && null != (field = (WinZipAesEntryExtraField)entry.getExtraField(39169))) {
                method = field.getMethod();
                if (-1L != csize) {
                    csize -= (long)WinZipAesUtils.overhead(field.getKeyStrength());
                }
                entry.setRawMethod(method);
            }
            if (null == field) {
                field = new WinZipAesEntryExtraField();
            }
            field.setKeyStrength(keyStrength);
            field.setMethod(method);
            long size = entry.getSize();
            if (20L <= size && 12 != method) {
                field.setVendorVersion(1);
            } else {
                field.setVendorVersion(2);
                this.suppressCrc = true;
            }
            entry.addExtraField(field);
            if (-1L != csize) {
                entry.setRawCompressedSize(csize += (long)WinZipAesUtils.overhead(keyStrength));
            }
            if (this.suppressCrc) {
                long crc = entry.getCrc();
                entry.setRawCrc(0L);
                this.delegate.init(entry);
                entry.setCrc(crc);
            } else {
                this.delegate.init(entry);
            }
            entry.setRawMethod(99);
            this.entry = entry;
        }

        @Override
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        public OutputStream start() throws IOException {
            ZipEntry entry = this.entry;
            OutputMethod delegate = this.delegate;
            WinZipAesEntryParameters entryParam = this.entryParam;
            assert (null != entryParam);
            assert (null == this.out);
            if (this.suppressCrc) {
                long crc = entry.getCrc();
                entry.setRawCrc(0L);
                this.out = new WinZipAesEntryOutputStream((LEDataOutputStream)delegate.start(), entryParam);
                entry.setCrc(crc);
            } else {
                this.out = new WinZipAesEntryOutputStream((LEDataOutputStream)delegate.start(), entryParam);
            }
            return this.out;
        }

        @Override
        public void finish() throws IOException {
            assert (null != this.out);
            this.out.finish();
            if (this.suppressCrc) {
                ZipEntry entry = this.entry;
                entry.setRawCrc(0L);
                this.delegate.finish();
                entry.setCrc(-1L);
            } else {
                this.delegate.finish();
            }
        }
    }

    private abstract class EncryptedOutputMethod
    extends DecoratingOutputMethod {
        EncryptedOutputMethod(RawOutputMethod processor) {
            super(processor);
        }
    }

    private final class RawOutputMethod
    implements OutputMethod {
        final boolean process;
        private long dataStart;
        @Nullable
        ZipEntry entry;

        RawOutputMethod(boolean process) {
            this.process = process;
        }

        @Override
        public void init(ZipEntry entry) throws ZipException {
            long size = RawZipOutputStream.this.encode(entry.getName()).length + entry.getRawExtraFields().length + RawZipOutputStream.this.encode(entry.getRawComment()).length;
            if (65535L < size) {
                throw new ZipException(entry.getName() + " (the total size " + size + " for the name, extra fields and comment exceeds the maximum size " + 65535 + ")");
            }
            if (0 == entry.getMethod() || !this.process) {
                if (-1L == entry.getCrc()) {
                    throw new ZipException(entry.getName() + " (unknown CRC-32 value)");
                }
                if (-1L == entry.getCompressedSize()) {
                    throw new ZipException(entry.getName() + " (unknown compressed size)");
                }
                if (-1L == entry.getSize()) {
                    throw new ZipException(entry.getName() + " (unknown uncompressed size)");
                }
            }
            if (-1 == entry.getPlatform()) {
                entry.setRawPlatform(0);
            }
            if (-1L == entry.getTime()) {
                entry.setTime(System.currentTimeMillis());
            }
            this.entry = entry;
        }

        @Override
        public OutputStream start() throws IOException {
            LEDataOutputStream dos = RawZipOutputStream.this.dos;
            long offset = dos.size();
            ZipEntry entry = this.entry;
            boolean encrypted = entry.isEncrypted();
            boolean dd = entry.isDataDescriptorRequired();
            boolean utf8 = Constants.UTF8.equals(RawZipOutputStream.this.charset);
            int general = (encrypted ? 1 : 0) | (dd ? 8 : 0) | (utf8 ? 2048 : 0);
            RawZipOutputStream.this.finished = false;
            dos.writeInt(67324752);
            dos.writeShort(entry.getRawVersionNeededToExtract());
            dos.writeShort(general);
            dos.writeShort(entry.getRawMethod());
            dos.writeInt((int)entry.getRawTime());
            if (dd) {
                dos.writeInt(0);
                dos.writeInt(0);
                dos.writeInt(0);
            } else {
                dos.writeInt((int)entry.getRawCrc());
                dos.writeInt((int)entry.getRawCompressedSize());
                dos.writeInt((int)entry.getRawSize());
            }
            byte[] name = RawZipOutputStream.this.encode(entry.getName());
            dos.writeShort(name.length);
            byte[] extra = entry.getRawExtraFields();
            dos.writeShort(extra.length);
            dos.write(name);
            dos.write(extra);
            entry.setGeneralPurposeBitFlags(general);
            entry.setRawOffset(offset);
            this.dataStart = dos.size();
            return dos;
        }

        @Override
        public void finish() throws IOException {
            LEDataOutputStream dos = RawZipOutputStream.this.dos;
            long csize = dos.size() - this.dataStart;
            ZipEntry entry = this.entry;
            assert (-1L != entry.getCrc());
            assert (-1L != entry.getSize());
            if (entry.getGeneralPurposeBitFlag(8)) {
                entry.setRawCompressedSize(csize);
                dos.writeInt(134695760);
                dos.writeInt((int)entry.getRawCrc());
                if (entry.isZip64ExtensionsRequired()) {
                    dos.writeLong(csize);
                    dos.writeLong(entry.getSize());
                } else {
                    dos.writeInt((int)entry.getRawCompressedSize());
                    dos.writeInt((int)entry.getRawSize());
                }
            } else if (entry.getCompressedSize() != csize) {
                throw new ZipException(entry.getName() + " (expected compressed entry size " + entry.getCompressedSize() + ", but is actually " + csize + ")");
            }
        }
    }

    private static final class AppendingLEDataOutputStream
    extends LEDataOutputStream {
        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        AppendingLEDataOutputStream(@WillCloseWhenClosed OutputStream out, @WillNotClose RawZipFile<?> appendee) {
            super(out);
            assert (null != out);
            this.written = appendee.getOffsetMapper().unmap(appendee.length());
        }
    }
}

