/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.zip;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.ThreadSafe;
import zz.de.schlichtherle.truezip.zip.Constants;
import zz.de.schlichtherle.truezip.zip.DefaultZipOutputStreamParameters;
import zz.de.schlichtherle.truezip.zip.RawZipOutputStream;
import zz.de.schlichtherle.truezip.zip.ZipCryptoParameters;
import zz.de.schlichtherle.truezip.zip.ZipEntry;
import zz.de.schlichtherle.truezip.zip.ZipFile;
import zz.de.schlichtherle.truezip.zip.ZipOutputStreamParameters;

@ThreadSafe
public class ZipOutputStream
extends RawZipOutputStream<ZipEntry> {
    public static final int OVERHEAD_SIZE = 47;
    public static final Charset DEFAULT_CHARSET = Constants.DEFAULT_CHARSET;
    private static final ZipOutputStreamParameters DEFAULT_PARAM = new DefaultZipOutputStreamParameters(DEFAULT_CHARSET);
    @CheckForNull
    private ZipCryptoParameters cryptoParameters;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public ZipOutputStream(@WillCloseWhenClosed OutputStream out) {
        super(out, null, DEFAULT_PARAM);
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public ZipOutputStream(@WillCloseWhenClosed OutputStream out, Charset charset) {
        super(out, null, new DefaultZipOutputStreamParameters(charset));
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public ZipOutputStream(@WillCloseWhenClosed OutputStream out, ZipFile appendee) {
        super(out, appendee, DEFAULT_PARAM);
        if (null == appendee) {
            throw new NullPointerException();
        }
    }

    @Override
    public synchronized int size() {
        return super.size();
    }

    @Override
    public synchronized Enumeration<? extends ZipEntry> entries() {
        class CloneEnumeration
        implements Enumeration<ZipEntry> {
            final Enumeration<? extends ZipEntry> e;

            CloneEnumeration() {
                this.e = Collections.enumeration(Collections.list(ZipOutputStream.super.entries()));
            }

            @Override
            public boolean hasMoreElements() {
                return this.e.hasMoreElements();
            }

            @Override
            public ZipEntry nextElement() {
                return this.e.nextElement().clone();
            }
        }
        return new CloneEnumeration();
    }

    @Override
    public synchronized Iterator<ZipEntry> iterator() {
        class EntryIterator
        implements Iterator<ZipEntry> {
            final Iterator<ZipEntry> i;

            EntryIterator() {
                ArrayList l = new ArrayList(ZipOutputStream.super.size());
                Iterator si = ZipOutputStream.super.iterator();
                while (si.hasNext()) {
                    l.add(si.next());
                }
                this.i = l.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public ZipEntry next() {
                return this.i.next().clone();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
        return new EntryIterator();
    }

    @Override
    public synchronized ZipEntry getEntry(String name) {
        Object entry = super.getEntry(name);
        return entry != null ? ((ZipEntry)entry).clone() : null;
    }

    @Override
    public synchronized void setComment(String comment) {
        super.setComment(comment);
    }

    @Override
    public synchronized String getComment() {
        return super.getComment();
    }

    @Override
    public synchronized int getMethod() {
        return super.getMethod();
    }

    @Override
    public synchronized void setMethod(int method) {
        super.setMethod(method);
    }

    @Override
    public synchronized int getLevel() {
        return super.getLevel();
    }

    @Override
    public synchronized void setLevel(int level) {
        super.setLevel(level);
    }

    @Override
    @Nullable
    public synchronized ZipCryptoParameters getCryptoParameters() {
        return this.cryptoParameters;
    }

    public synchronized void setCryptoParameters(@CheckForNull ZipCryptoParameters cryptoParameters) {
        this.cryptoParameters = cryptoParameters;
    }

    @Override
    public synchronized long length() {
        return super.length();
    }

    @Override
    public final synchronized boolean isBusy() {
        return super.isBusy();
    }

    @Override
    public synchronized void putNextEntry(ZipEntry entry, boolean process) throws IOException {
        super.putNextEntry(entry, process);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        super.write(b);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
    }

    @Override
    public synchronized void closeEntry() throws IOException {
        super.closeEntry();
    }

    @Override
    public synchronized void finish() throws IOException {
        super.finish();
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
    }
}

