/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import zz.org.apache.commons.io.IOUtils;
import zz.org.cyclonedx.exception.ParseException;
import zz.org.cyclonedx.parsers.JsonParser;
import zz.org.cyclonedx.parsers.Parser;
import zz.org.cyclonedx.parsers.XmlParser;

public class BomParserFactory {
    private BomParserFactory() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Parser createParser(File file) throws ParseException {
        try (InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            byte[] bytes = IOUtils.toByteArray(fis, 1);
            Parser parser = BomParserFactory.createParser(bytes);
            return parser;
        }
        catch (IOException e) {
            throw new ParseException("An error occurred creating parser from file", e);
        }
    }

    public static Parser createParser(byte[] bytes) throws ParseException {
        if (bytes.length < 1) {
            throw new ParseException("Cannot create parser from empty byte array.");
        }
        if (bytes[0] == 123) {
            return new JsonParser();
        }
        if (bytes[0] == 60) {
            return new XmlParser();
        }
        throw new ParseException("The specified BOM is not in a supported format. Supported formats are XML and JSON");
    }

    public static boolean looksLikeCycloneDX(byte[] bytes) {
        String bomString = new String(bytes, StandardCharsets.UTF_8);
        if (bomString.startsWith("<?xml") && bomString.contains("<bom") && bomString.contains("http://cyclonedx.org/schema/bom")) {
            return true;
        }
        return bomString.startsWith("{") && bomString.contains("bomFormat") && bomString.contains("CycloneDX");
    }
}

