/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.generators.json;

import java.lang.reflect.Field;
import zz.com.fasterxml.jackson.core.JsonProcessingException;
import zz.com.fasterxml.jackson.core.util.DefaultIndenter;
import zz.com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import zz.com.fasterxml.jackson.databind.ObjectMapper;
import zz.com.fasterxml.jackson.databind.module.SimpleModule;
import zz.org.cyclonedx.CycloneDxSchema;
import zz.org.cyclonedx.exception.GeneratorException;
import zz.org.cyclonedx.generators.json.BomJsonGenerator;
import zz.org.cyclonedx.model.Bom;
import zz.org.cyclonedx.model.BomReference;
import zz.org.cyclonedx.util.ComponentWrapperSerializer;
import zz.org.cyclonedx.util.DependencySerializer;
import zz.org.cyclonedx.util.LicenseChoiceSerializer;
import zz.org.cyclonedx.util.TrimStringSerializer;
import zz.org.cyclonedx.util.VersionJsonAnnotationIntrospector;
import zz.org.cyclonedx.util.mixin.MixInBomReference;

public abstract class AbstractBomJsonGenerator
extends CycloneDxSchema
implements BomJsonGenerator {
    protected final ObjectMapper mapper = new ObjectMapper();
    private final DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();

    public AbstractBomJsonGenerator() {
        this.setupObjectMapper(this.mapper);
        this.setupPrettyPrinter(this.prettyPrinter);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    private void setupPrettyPrinter(DefaultPrettyPrinter prettyPrinter) {
        prettyPrinter.indentArraysWith(DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
    }

    private void setupObjectMapper(ObjectMapper mapper) {
        mapper.setAnnotationIntrospector(new VersionJsonAnnotationIntrospector(String.valueOf(this.getSchemaVersion().getVersion())));
        SimpleModule licenseModule = new SimpleModule();
        SimpleModule depModule = new SimpleModule();
        SimpleModule componentWrapperModule = new SimpleModule();
        SimpleModule stringModule = new SimpleModule();
        stringModule.addSerializer(new TrimStringSerializer());
        mapper.registerModule(stringModule);
        licenseModule.addSerializer(new LicenseChoiceSerializer());
        mapper.registerModule(licenseModule);
        depModule.addSerializer(new DependencySerializer(false));
        mapper.registerModule(depModule);
        componentWrapperModule.addSerializer(new ComponentWrapperSerializer(mapper));
        mapper.registerModule(componentWrapperModule);
    }

    String toJson(Bom bom, boolean prettyPrint) throws GeneratorException {
        try {
            this.mapper.addMixIn(BomReference.class, MixInBomReference.class);
            if (prettyPrint) {
                return this.mapper.writer(this.prettyPrinter).writeValueAsString(bom);
            }
            return this.mapper.writeValueAsString(bom);
        }
        catch (JsonProcessingException e) {
            throw new GeneratorException(e);
        }
    }

    Bom injectBomFormatAndSpecVersion(Bom bom) throws GeneratorException {
        try {
            Field field = Bom.class.getDeclaredField("bomFormat");
            field.setAccessible(true);
            field.set(bom, "CycloneDX");
            field = Bom.class.getDeclaredField("specVersion");
            field.setAccessible(true);
            field.set(bom, this.getSchemaVersion().getVersionString());
            return bom;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new GeneratorException(e);
        }
    }
}

