/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.util;

import java.io.IOException;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import zz.com.fasterxml.jackson.core.JsonGenerator;
import zz.com.fasterxml.jackson.databind.SerializerProvider;
import zz.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import zz.com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import zz.org.cyclonedx.model.Dependency;
import zz.org.cyclonedx.model.DependencyList;

public class DependencySerializer
extends StdSerializer<DependencyList> {
    private final String REF = "ref";
    private boolean useNamespace = false;

    public DependencySerializer(boolean useNamespace) {
        super(DependencyList.class, false);
        this.useNamespace = useNamespace;
    }

    public DependencySerializer(Class<DependencyList> t) {
        super(t);
    }

    @Override
    public void serialize(DependencyList dependencies, JsonGenerator generator, SerializerProvider provider) throws IOException {
        try {
            if (generator instanceof ToXmlGenerator) {
                this.writeXMLDependenciesWithGenerator((ToXmlGenerator)generator, dependencies);
            } else {
                this.writeJSONDependenciesWithGenerator(generator, dependencies);
            }
        }
        catch (IOException | XMLStreamException ex) {
            throw new IOException(ex);
        }
    }

    private void writeJSONDependenciesWithGenerator(JsonGenerator generator, List<Dependency> dependencies) throws IOException {
        if (dependencies != null) {
            generator.writeStartArray();
            if (!dependencies.isEmpty()) {
                for (Dependency dependency : dependencies) {
                    generator.writeStartObject();
                    generator.writeStringField("ref", dependency.getRef());
                    generator.writeArrayFieldStart("dependsOn");
                    if (dependency.getDependencies() != null && !dependency.getDependencies().isEmpty()) {
                        for (Dependency subDependency : dependency.getDependencies()) {
                            generator.writeString(subDependency.getRef());
                        }
                    }
                    generator.writeEndArray();
                    generator.writeEndObject();
                }
            }
            generator.writeEndArray();
        }
    }

    private void writeXMLDependenciesWithGenerator(ToXmlGenerator toXmlGenerator, List<Dependency> dependencies) throws IOException, XMLStreamException {
        if (dependencies != null && !dependencies.isEmpty()) {
            this.processNamespace(toXmlGenerator, "dependencies");
            toXmlGenerator.writeStartArray();
            for (Dependency dependency : dependencies) {
                this.writeXMLDependency(dependency, toXmlGenerator);
            }
            toXmlGenerator.writeEndArray();
            toXmlGenerator.writeEndObject();
        }
    }

    private void writeXMLDependency(Dependency dependency, ToXmlGenerator generator) throws IOException, XMLStreamException {
        this.processNamespace(generator, "dependency");
        if (dependency.getDependencies() != null && !dependency.getDependencies().isEmpty()) {
            generator.writeStartArray();
        }
        generator.setNextIsAttribute(true);
        generator.setNextName(new QName("ref"));
        generator.writeString(dependency.getRef());
        generator.setNextIsAttribute(false);
        if (dependency.getDependencies() != null && !dependency.getDependencies().isEmpty()) {
            for (Dependency subDependency : dependency.getDependencies()) {
                this.writeXMLDependency(subDependency, generator);
            }
        }
        if (dependency.getDependencies() != null && !dependency.getDependencies().isEmpty()) {
            generator.writeEndArray();
        }
        generator.writeEndObject();
    }

    private void processNamespace(ToXmlGenerator toXmlGenerator, String dependencies) throws XMLStreamException, IOException {
        QName qName;
        if (this.useNamespace) {
            qName = new QName("http://cyclonedx.org/schema/ext/dependency-graph/1.0", dependencies, "dg");
            toXmlGenerator.getStaxWriter().setPrefix(qName.getPrefix(), qName.getNamespaceURI());
        } else {
            qName = new QName(dependencies);
        }
        toXmlGenerator.setNextName(qName);
        toXmlGenerator.writeStartObject();
        toXmlGenerator.writeFieldName(qName.getLocalPart());
    }
}

