/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.api;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import zz.org.eclipse.jgit.api.TransportCommand;
import zz.org.eclipse.jgit.api.errors.GitAPIException;
import zz.org.eclipse.jgit.api.errors.InvalidRemoteException;
import zz.org.eclipse.jgit.api.errors.JGitInternalException;
import zz.org.eclipse.jgit.api.errors.TooLargeObjectInPackException;
import zz.org.eclipse.jgit.api.errors.TooLargePackException;
import zz.org.eclipse.jgit.api.errors.TransportException;
import zz.org.eclipse.jgit.errors.NotSupportedException;
import zz.org.eclipse.jgit.internal.JGitText;
import zz.org.eclipse.jgit.lib.NullProgressMonitor;
import zz.org.eclipse.jgit.lib.ProgressMonitor;
import zz.org.eclipse.jgit.lib.Ref;
import zz.org.eclipse.jgit.lib.Repository;
import zz.org.eclipse.jgit.transport.PushResult;
import zz.org.eclipse.jgit.transport.RefLeaseSpec;
import zz.org.eclipse.jgit.transport.RefSpec;
import zz.org.eclipse.jgit.transport.RemoteConfig;
import zz.org.eclipse.jgit.transport.RemoteRefUpdate;
import zz.org.eclipse.jgit.transport.Transport;

public class PushCommand
extends TransportCommand<PushCommand, Iterable<PushResult>> {
    private String remote = "origin";
    private final List<RefSpec> refSpecs;
    private final Map<String, RefLeaseSpec> refLeaseSpecs;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private String receivePack = "git-receive-pack";
    private boolean dryRun;
    private boolean atomic;
    private boolean force;
    private boolean thin = false;
    private OutputStream out;
    private List<String> pushOptions;

    protected PushCommand(Repository repo) {
        super(repo);
        this.refSpecs = new ArrayList<RefSpec>(3);
        this.refLeaseSpecs = new HashMap<String, RefLeaseSpec>();
    }

    @Override
    public Iterable<PushResult> call() throws GitAPIException, InvalidRemoteException, TransportException {
        this.checkCallable();
        ArrayList<PushResult> pushResults = new ArrayList<PushResult>(3);
        try {
            Ref head;
            if (this.refSpecs.isEmpty()) {
                RemoteConfig config = new RemoteConfig(this.repo.getConfig(), this.getRemote());
                this.refSpecs.addAll(config.getPushRefSpecs());
            }
            if (this.refSpecs.isEmpty() && (head = this.repo.exactRef("HEAD")) != null && head.isSymbolic()) {
                this.refSpecs.add(new RefSpec(head.getLeaf().getName()));
            }
            if (this.force) {
                int i = 0;
                while (i < this.refSpecs.size()) {
                    this.refSpecs.set(i, this.refSpecs.get(i).setForceUpdate(true));
                    ++i;
                }
            }
            List<Transport> transports = Transport.openAll(this.repo, this.remote, Transport.Operation.PUSH);
            for (Transport transport : transports) {
                transport.setPushThin(this.thin);
                transport.setPushAtomic(this.atomic);
                if (this.receivePack != null) {
                    transport.setOptionReceivePack(this.receivePack);
                }
                transport.setDryRun(this.dryRun);
                transport.setPushOptions(this.pushOptions);
                this.configure(transport);
                Collection<RemoteRefUpdate> toPush = transport.findRemoteRefUpdatesFor(this.refSpecs, this.refLeaseSpecs);
                try {
                    try {
                        PushResult result = transport.push(this.monitor, toPush, this.out);
                        pushResults.add(result);
                    }
                    catch (zz.org.eclipse.jgit.errors.TooLargePackException e) {
                        throw new TooLargePackException(e.getMessage(), e);
                    }
                    catch (zz.org.eclipse.jgit.errors.TooLargeObjectInPackException e) {
                        throw new TooLargeObjectInPackException(e.getMessage(), e);
                    }
                    catch (zz.org.eclipse.jgit.errors.TransportException e) {
                        throw new TransportException(e.getMessage(), e);
                    }
                }
                finally {
                    transport.close();
                }
            }
        }
        catch (URISyntaxException e) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote), e);
        }
        catch (zz.org.eclipse.jgit.errors.TransportException e) {
            throw new TransportException(e.getMessage(), e);
        }
        catch (NotSupportedException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPushCommand, e);
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPushCommand, e);
        }
        return pushResults;
    }

    public PushCommand setRemote(String remote) {
        this.checkCallable();
        this.remote = remote;
        return this;
    }

    public String getRemote() {
        return this.remote;
    }

    public PushCommand setReceivePack(String receivePack) {
        this.checkCallable();
        this.receivePack = receivePack;
        return this;
    }

    public String getReceivePack() {
        return this.receivePack;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public PushCommand setProgressMonitor(ProgressMonitor monitor) {
        this.checkCallable();
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }

    public List<RefLeaseSpec> getRefLeaseSpecs() {
        return new ArrayList<RefLeaseSpec>(this.refLeaseSpecs.values());
    }

    public PushCommand setRefLeaseSpecs(RefLeaseSpec ... specs) {
        return this.setRefLeaseSpecs(Arrays.asList(specs));
    }

    public PushCommand setRefLeaseSpecs(List<RefLeaseSpec> specs) {
        this.checkCallable();
        this.refLeaseSpecs.clear();
        for (RefLeaseSpec spec : specs) {
            this.refLeaseSpecs.put(spec.getRef(), spec);
        }
        return this;
    }

    public List<RefSpec> getRefSpecs() {
        return this.refSpecs;
    }

    public PushCommand setRefSpecs(RefSpec ... specs) {
        this.checkCallable();
        this.refSpecs.clear();
        Collections.addAll(this.refSpecs, specs);
        return this;
    }

    public PushCommand setRefSpecs(List<RefSpec> specs) {
        this.checkCallable();
        this.refSpecs.clear();
        this.refSpecs.addAll(specs);
        return this;
    }

    public PushCommand setPushAll() {
        this.refSpecs.add(Transport.REFSPEC_PUSH_ALL);
        return this;
    }

    public PushCommand setPushTags() {
        this.refSpecs.add(Transport.REFSPEC_TAGS);
        return this;
    }

    public PushCommand add(Ref ref) {
        this.refSpecs.add(new RefSpec(ref.getLeaf().getName()));
        return this;
    }

    public PushCommand add(String nameOrSpec) {
        if (nameOrSpec.indexOf(58) >= 0) {
            this.refSpecs.add(new RefSpec(nameOrSpec));
        } else {
            Ref src;
            try {
                src = this.repo.findRef(nameOrSpec);
            }
            catch (IOException e) {
                throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPushCommand, e);
            }
            if (src != null) {
                this.add(src);
            }
        }
        return this;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public PushCommand setDryRun(boolean dryRun) {
        this.checkCallable();
        this.dryRun = dryRun;
        return this;
    }

    public boolean isThin() {
        return this.thin;
    }

    public PushCommand setThin(boolean thin) {
        this.checkCallable();
        this.thin = thin;
        return this;
    }

    public boolean isAtomic() {
        return this.atomic;
    }

    public PushCommand setAtomic(boolean atomic) {
        this.checkCallable();
        this.atomic = atomic;
        return this;
    }

    public boolean isForce() {
        return this.force;
    }

    public PushCommand setForce(boolean force) {
        this.checkCallable();
        this.force = force;
        return this;
    }

    public PushCommand setOutputStream(OutputStream out) {
        this.out = out;
        return this;
    }

    public List<String> getPushOptions() {
        return this.pushOptions;
    }

    public PushCommand setPushOptions(List<String> pushOptions) {
        this.pushOptions = pushOptions;
        return this;
    }
}

