/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import zz.org.eclipse.jgit.api.GitCommand;
import zz.org.eclipse.jgit.api.ReflogCommand;
import zz.org.eclipse.jgit.api.errors.GitAPIException;
import zz.org.eclipse.jgit.api.errors.InvalidRefNameException;
import zz.org.eclipse.jgit.api.errors.JGitInternalException;
import zz.org.eclipse.jgit.internal.JGitText;
import zz.org.eclipse.jgit.lib.ReflogEntry;
import zz.org.eclipse.jgit.lib.Repository;
import zz.org.eclipse.jgit.revwalk.RevCommit;
import zz.org.eclipse.jgit.revwalk.RevWalk;

public class StashListCommand
extends GitCommand<Collection<RevCommit>> {
    public StashListCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Collection<RevCommit> call() throws GitAPIException, InvalidRefNameException {
        this.checkCallable();
        try {
            if (this.repo.exactRef("refs/stash") == null) {
                return Collections.emptyList();
            }
        }
        catch (IOException e) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().cannotRead, "refs/stash"), e);
        }
        ReflogCommand refLog = new ReflogCommand(this.repo);
        refLog.setRef("refs/stash");
        Object stashEntries = refLog.call();
        if (stashEntries.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RevCommit> stashCommits = new ArrayList<RevCommit>(stashEntries.size());
        Throwable throwable = null;
        Object var5_7 = null;
        try (RevWalk walk = new RevWalk(this.repo);){
            Iterator iterator = stashEntries.iterator();
            while (iterator.hasNext()) {
                ReflogEntry entry = (ReflogEntry)iterator.next();
                try {
                    stashCommits.add(walk.parseCommit(entry.getNewId()));
                }
                catch (IOException e) {
                    throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotReadCommit, entry.getNewId()), e);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return stashCommits;
    }
}

