/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.internal.ketch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import zz.org.eclipse.jgit.annotations.Nullable;
import zz.org.eclipse.jgit.lib.AnyObjectId;
import zz.org.eclipse.jgit.lib.CommitBuilder;
import zz.org.eclipse.jgit.lib.ObjectId;
import zz.org.eclipse.jgit.lib.ObjectInserter;
import zz.org.eclipse.jgit.lib.PersonIdent;
import zz.org.eclipse.jgit.lib.Repository;
import zz.org.eclipse.jgit.revwalk.RevCommit;
import zz.org.eclipse.jgit.revwalk.RevObject;
import zz.org.eclipse.jgit.revwalk.RevWalk;
import zz.org.eclipse.jgit.transport.ReceiveCommand;
import zz.org.eclipse.jgit.treewalk.EmptyTreeIterator;
import zz.org.eclipse.jgit.treewalk.TreeWalk;
import zz.org.eclipse.jgit.treewalk.filter.TreeFilter;

public class StageBuilder {
    private static final int SMALL_BATCH_SIZE = 5;
    private static final int TEMP_PARENT_BATCH_SIZE = 128;
    private static final byte[] PEEL = new byte[]{32, 94};
    private final String txnStage;
    private final String txnId;

    public StageBuilder(String txnStageNamespace, ObjectId txnId) {
        this.txnStage = txnStageNamespace;
        this.txnId = txnId.name();
    }

    public List<ReceiveCommand> makeStageList(Repository git, ObjectId oldTree, ObjectId newTree) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            RevWalk rw = new RevWalk(git);
            TreeWalk tw = new TreeWalk(rw.getObjectReader());
            ObjectInserter ins = git.newObjectInserter();
            try {
                if (AnyObjectId.isEqual(oldTree, ObjectId.zeroId())) {
                    tw.addTree(new EmptyTreeIterator());
                } else {
                    tw.addTree(rw.parseTree(oldTree));
                }
                tw.addTree(rw.parseTree(newTree));
                tw.setFilter(TreeFilter.ANY_DIFF);
                tw.setRecursive(true);
                HashSet<ObjectId> newObjs = new HashSet<ObjectId>();
                while (tw.next()) {
                    if (tw.getRawMode(1) != 57344 || tw.isPathSuffix(PEEL, 2)) continue;
                    newObjs.add(tw.getObjectId(1));
                }
                List<ReceiveCommand> cmds = this.makeStageList(newObjs, git, ins);
                ins.flush();
                if (ins != null) {
                    ins.close();
                }
                if (tw != null) {
                    tw.close();
                }
                if (rw != null) {
                    rw.close();
                }
                return cmds;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (ins != null) {
                            ins.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (tw != null) {
                            tw.close();
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (rw != null) {
                        rw.close();
                    }
                    throw throwable;
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    public List<ReceiveCommand> makeStageList(Set<ObjectId> newObjs, @Nullable Repository git, @Nullable ObjectInserter inserter) throws IOException {
        if (git == null || newObjs.size() <= 5) {
            ArrayList<ReceiveCommand> cmds = new ArrayList<ReceiveCommand>(newObjs.size());
            for (ObjectId id : newObjs) {
                this.stage(cmds, id);
            }
            return cmds;
        }
        ArrayList<ReceiveCommand> cmds = new ArrayList<ReceiveCommand>();
        ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
        this.reduceObjects(cmds, commits, git, newObjs);
        if (inserter == null || commits.size() <= 1 || cmds.size() + commits.size() <= 5) {
            for (RevCommit c : commits) {
                this.stage(cmds, c.copy());
            }
            return cmds;
        }
        ObjectId tip = null;
        int end = commits.size();
        while (end > 0) {
            int start = Math.max(0, end - 128);
            List<RevCommit> batch = commits.subList(start, end);
            ArrayList<ObjectId> parents = new ArrayList<ObjectId>(1 + batch.size());
            if (tip != null) {
                parents.add(tip);
            }
            parents.addAll(batch);
            CommitBuilder b = new CommitBuilder();
            b.setTreeId(((RevCommit)batch.get(0)).getTree());
            b.setParentIds(parents);
            b.setAuthor(StageBuilder.tmpAuthor(batch));
            b.setCommitter(b.getAuthor());
            tip = inserter.insert(b);
            end = start;
        }
        this.stage(cmds, tip);
        return cmds;
    }

    private static PersonIdent tmpAuthor(List<RevCommit> commits) {
        int t = 0;
        int i = 0;
        while (i < commits.size()) {
            t = Math.max(t, commits.get(i).getCommitTime());
        }
        String name = "Ketch Stage";
        String email = "tmp@tmp";
        return new PersonIdent(name, email, (long)t * 1000L, 0);
    }

    private void reduceObjects(List<ReceiveCommand> cmds, List<RevCommit> commits, Repository git, Set<ObjectId> newObjs) throws IOException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (RevWalk rw = new RevWalk(git);){
            RevCommit c;
            rw.setRetainBody(false);
            for (ObjectId id : newObjs) {
                RevObject obj = rw.parseAny(id);
                if (obj instanceof RevCommit) {
                    rw.markStart((RevCommit)obj);
                    continue;
                }
                this.stage(cmds, id);
            }
            while ((c = rw.next()) != null) {
                commits.add(c);
                rw.markUninteresting(c);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void stage(List<ReceiveCommand> cmds, ObjectId id) {
        int estLen = this.txnStage.length() + this.txnId.length() + 5;
        StringBuilder n = new StringBuilder(estLen);
        n.append(this.txnStage).append(this.txnId).append('.');
        n.append(Integer.toHexString(cmds.size()));
        cmds.add(new ReceiveCommand(ObjectId.zeroId(), id, n.toString()));
    }
}

